"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InversifyCoreError = void 0;
const isAppErrorSymbol = Symbol.for('@inversifyjs/core/InversifyCoreError');
class InversifyCoreError extends Error {
    [isAppErrorSymbol];
    kind;
    constructor(kind, message, options) {
        super(message, options);
        this[isAppErrorSymbol] = true;
        this.kind = kind;
    }
    static is(value) {
        return (typeof value === 'object' &&
            value !== null &&
            value[isAppErrorSymbol] === true);
    }
    static isErrorOfKind(value, kind) {
        return InversifyCoreError.is(value) && value.kind === kind;
    }
}
exports.InversifyCoreError = InversifyCoreError;
//# sourceMappingURL=InversifyCoreError.js.map