"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateAndDecodeParams = validateAndDecodeParams;
var _zod = require("@kbn/zod");
var _decode_request_params = require("./decode_request_params");
var _strip_nullish_request_parameters = require("./strip_nullish_request_parameters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function validateAndDecodeParams(request, paramsSchema) {
  if (paramsSchema === undefined) {
    return undefined;
  }
  const params = (0, _strip_nullish_request_parameters.stripNullishRequestParameters)({
    params: request.params,
    body: request.body,
    query: request.query
  });
  if ((0, _zod.isZod)(paramsSchema)) {
    // Already validated by platform
    return params;
  }
  return (0, _decode_request_params.decodeRequestParams)(params, paramsSchema);
}