"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListVersionId = exports.ListVersion = exports.ListTypeEnum = exports.ListType = exports.ListSerializer = exports.ListName = exports.ListMetadata = exports.ListItemValue = exports.ListItemMetadata = exports.ListItemId = exports.ListItemDescription = exports.ListId = exports.ListDeserializer = exports.ListDescription = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Value List Attributes
 *   version: not applicable
 */

/**
 * Value list's identifier.
 */

const ListId = exports.ListId = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);

/**
  * Specifies the Elasticsearch data type of excludes the list container holds. Some common examples:

- `keyword`: Many ECS fields are Elasticsearch keywords
- `ip`: IP addresses
- `ip_range`: Range of IP addresses (supports IPv4, IPv6, and CIDR notation)

  */

const ListType = exports.ListType = _zod.z.enum(['binary', 'boolean', 'byte', 'date', 'date_nanos', 'date_range', 'double', 'double_range', 'float', 'float_range', 'geo_point', 'geo_shape', 'half_float', 'integer', 'integer_range', 'ip', 'ip_range', 'keyword', 'long', 'long_range', 'shape', 'short', 'text']);
const ListTypeEnum = exports.ListTypeEnum = ListType.enum;

/**
 * Value list's name.
 */

const ListName = exports.ListName = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);

/**
 * Describes the value list.
 */

const ListDescription = exports.ListDescription = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);

/**
 * Placeholder for metadata about the value list.
 */

const ListMetadata = exports.ListMetadata = _zod.z.object({}).catchall(_zod.z.unknown());

/**
  * Determines how uploaded list item values are parsed. By default, list items are parsed using these named regex groups:

- `(?<value>.+)` - Single value item types, such as ip, long, date, keyword, and text.
- `(?<gte>.+)-(?<lte>.+)|(?<value>.+)` - Range value item types, such as `date_range`, `ip_range`, `double_range`, `float_range`, `integer_range`, and `long_range`.

  */

const ListSerializer = exports.ListSerializer = _zod.z.string();

/**
  * Determines how retrieved list item values are presented. By default list items are presented using these Handelbar expressions:

- `{{{value}}}` - Single value item types, such as `ip`, `long`, `date`, `keyword`, and `text`.
- `{{{gte}}}-{{{lte}}}` - Range value item types, such as `ip_range`, `double_range`, `float_range`, `integer_range`, and `long_range`.
- `{{{gte}}},{{{lte}}}` - Date range values.

  */

const ListDeserializer = exports.ListDeserializer = _zod.z.string();

/**
 * The document version number.
 */

const ListVersion = exports.ListVersion = _zod.z.number().int().min(1);

/**
  * The version id, normally returned by the API when the document is retrieved. Use it ensure updates are done against the latest version.

  */

const ListVersionId = exports.ListVersionId = _zod.z.string();

/**
 * Value list item's identifier.
 */

const ListItemId = exports.ListItemId = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);

/**
 * The value used to evaluate exceptions.
 */

const ListItemValue = exports.ListItemValue = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);

/**
 * Describes the value list item.
 */

const ListItemDescription = exports.ListItemDescription = _zod.z.string().min(1).superRefine(_zodHelpers.isNonEmptyString);

/**
 * Placeholder for metadata about the value list item.
 */

const ListItemMetadata = exports.ListItemMetadata = _zod.z.object({}).catchall(_zod.z.unknown());