"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateEndpointListItemSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _default_update_comments_array = require("../../common/default_update_comments_array");
var _exception_list_item_type = require("../../common/exception_list_item_type");
var _non_empty_entries_array = require("../../common/non_empty_entries_array");
var _os_type = require("../../common/os_type");
var _description = require("../../common/description");
var _name = require("../../common/name");
var _underscore_version = require("../../common/underscore_version");
var _id = require("../../common/id");
var _meta = require("../../common/meta");
var _tags = require("../../common/tags");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateEndpointListItemSchema = exports.updateEndpointListItemSchema = t.intersection([t.exact(t.type({
  description: _description.description,
  entries: _non_empty_entries_array.nonEmptyEntriesArray,
  name: _name.name,
  type: _exception_list_item_type.exceptionListItemType
})), t.exact(t.partial({
  _version: _underscore_version._version,
  // defaults to undefined if not set during decode
  comments: _default_update_comments_array.DefaultUpdateCommentsArray,
  // defaults to empty array if not set during decode
  id: _id.id,
  // defaults to undefined if not set during decode
  item_id: t.union([t.string, t.undefined]),
  meta: _meta.meta,
  // defaults to undefined if not set during decode
  os_types: _os_type.osTypeArrayOrUndefined,
  // defaults to empty array if not set during decode
  tags: _tags.tags // defaults to empty array if not set during decode
}))]);

// This type is used after a decode since some things are defaults after a decode.