"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FindEndpointListItemsResponse = exports.FindEndpointListItemsRequestQuery = exports.FindEndpointListItemsFilter = void 0;
var _zod = require("@kbn/zod");
var _primitives = require("@kbn/openapi-common/schemas/primitives.gen");
var _endpoint_list_common = require("../model/endpoint_list_common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Find endpoint list items API endpoint
 *   version: 2023-10-31
 */

const FindEndpointListItemsFilter = exports.FindEndpointListItemsFilter = _primitives.NonEmptyString;
const FindEndpointListItemsRequestQuery = exports.FindEndpointListItemsRequestQuery = _zod.z.object({
  /** 
      * Filters the returned results according to the value of the specified field,
  using the `<field name>:<field value>` syntax.
        */
  filter: FindEndpointListItemsFilter.optional(),
  /**
   * The page number to return
   */
  page: _zod.z.coerce.number().int().min(0).optional(),
  /**
   * The number of exception list items to return per page
   */
  per_page: _zod.z.coerce.number().int().min(0).optional(),
  /**
   * Determines which field is used to sort the results
   */
  sort_field: _primitives.NonEmptyString.optional(),
  /**
   * Determines the sort order, which can be `desc` or `asc`
   */
  sort_order: _zod.z.enum(['desc', 'asc']).optional()
});
const FindEndpointListItemsResponse = exports.FindEndpointListItemsResponse = _zod.z.object({
  data: _zod.z.array(_endpoint_list_common.EndpointListItem),
  page: _zod.z.number().int().min(0),
  per_page: _zod.z.number().int().min(0),
  total: _zod.z.number().int().min(0),
  pit: _zod.z.string().optional()
});