"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySolutionServerlessPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _serverlessSecuritySettings = require("@kbn/serverless-security-settings");
var _inferenceCommon = require("@kbn/inference-common");
var _ui_settings = require("@kbn/security-solution-plugin/server/ui_settings");
var _constants = require("@kbn/security-solution-plugin/common/constants");
var _pli_features = require("../common/pli/pli_features");
var _config = require("./config");
var _usage_reporting_task = require("./task_manager/usage_reporting_task");
var _cloud_security_metering_task_config = require("./cloud_security/cloud_security_metering_task_config");
var _product_features = require("./product_features");
var _metering = require("./endpoint/constants/metering");
var _metering2 = require("./ai4soc/constants/metering");
var _services = require("./endpoint/services");
var _nlp_cleanup_task = require("./task_manager/nlp_cleanup_task/nlp_cleanup_task");
var _event_based_telemetry = require("./telemetry/event_based_telemetry");
var _usage_reporting_service = require("./common/services/usage_reporting_service");
var _services2 = require("./ai4soc/services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SecuritySolutionServerlessPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "cloudSecurityUsageReportingTask", void 0);
    (0, _defineProperty2.default)(this, "endpointUsageReportingTask", void 0);
    (0, _defineProperty2.default)(this, "ai4SocUsageReportingTask", void 0);
    (0, _defineProperty2.default)(this, "nlpCleanupTask", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "usageReportingService", void 0);
    this.initializerContext = initializerContext;
    this.kibanaVersion = initializerContext.env.packageInfo.version;
    this.config = this.initializerContext.config.get();
    this.logger = this.initializerContext.logger.get();
    this.usageReportingService = new _usage_reporting_service.UsageReportingService(this.config.usageApi, this.kibanaVersion);
    const productTypesStr = JSON.stringify(this.config.productTypes, null, 2);
    this.logger.info(`Security Solution running with product types:\n${productTypesStr}`);
  }
  setup(coreSetup, pluginsSetup) {
    this.config = (0, _config.createConfig)(this.initializerContext, pluginsSetup.securitySolution);

    // Register product features
    const enabledProductFeatures = (0, _pli_features.getEnabledProductFeatures)(this.config.productTypes);
    (0, _product_features.registerProductFeatures)(pluginsSetup, enabledProductFeatures);

    // Register telemetry events
    _event_based_telemetry.telemetryEvents.forEach(eventConfig => coreSetup.analytics.registerEventType(eventConfig));
    const projectSettings = _serverlessSecuritySettings.SECURITY_PROJECT_SETTINGS;

    // Setup project uiSettings whitelisting
    pluginsSetup.serverless.setupProjectSettings(projectSettings);

    // Serverless Advanced Settings setup
    coreSetup.getStartServices().then(async ([coreStart, depsStart]) => {
      const isNewDefaultConnectorEnabled = await coreStart.featureFlags.getBooleanValue(_constants.AI_ASSISTANT_DEFAULT_LLM_SETTING_ENABLED, false);
      try {
        const unsecuredActionsClient = depsStart.actions.getUnsecuredActionsClient();
        // using "default" space actually forces the api to use undefined space (see getAllUnsecured)
        const aiConnectors = (await unsecuredActionsClient.getAll('default')).filter(connector => (0, _inferenceCommon.isSupportedConnector)(connector));

        // hide the setting if the new default connector feature is enabled
        const defaultAIConnectorSetting = (0, _ui_settings.getDefaultAIConnectorSetting)(aiConnectors, isNewDefaultConnectorEnabled ? 'ui' : undefined);
        coreSetup.uiSettings.register({
          ...defaultAIConnectorSetting,
          ...(0, _ui_settings.getDefaultValueReportSettings)()
        });
      } catch (error) {
        this.logger.error(`Error registering default AI connector: ${error}`);
      }
    }).catch(() => {}); // it shouldn't reject, but just in case

    // Tasks
    this.cloudSecurityUsageReportingTask = new _usage_reporting_task.SecurityUsageReportingTask({
      core: coreSetup,
      logFactory: this.initializerContext.logger,
      config: this.config,
      taskManager: pluginsSetup.taskManager,
      cloudSetup: pluginsSetup.cloud,
      taskType: _cloud_security_metering_task_config.cloudSecurityMetringTaskProperties.taskType,
      taskTitle: _cloud_security_metering_task_config.cloudSecurityMetringTaskProperties.taskTitle,
      version: _cloud_security_metering_task_config.cloudSecurityMetringTaskProperties.version,
      meteringCallback: _cloud_security_metering_task_config.cloudSecurityMetringTaskProperties.meteringCallback,
      usageReportingService: this.usageReportingService
    });
    this.endpointUsageReportingTask = new _usage_reporting_task.SecurityUsageReportingTask({
      core: coreSetup,
      logFactory: this.initializerContext.logger,
      config: this.config,
      taskType: _metering.METERING_TASK.TYPE,
      taskTitle: _metering.METERING_TASK.TITLE,
      version: _metering.METERING_TASK.VERSION,
      meteringCallback: _services.endpointMeteringService.getUsageRecords,
      taskManager: pluginsSetup.taskManager,
      cloudSetup: pluginsSetup.cloud,
      usageReportingService: this.usageReportingService
    });
    this.ai4SocUsageReportingTask = new _usage_reporting_task.SecurityUsageReportingTask({
      core: coreSetup,
      logFactory: this.initializerContext.logger,
      config: this.config,
      taskType: _metering2.METERING_TASK.TYPE,
      taskTitle: _metering2.METERING_TASK.TITLE,
      version: _metering2.METERING_TASK.VERSION,
      meteringCallback: _services2.ai4SocMeteringService.getUsageRecords,
      taskManager: pluginsSetup.taskManager,
      cloudSetup: pluginsSetup.cloud,
      usageReportingService: this.usageReportingService,
      backfillConfig: {
        enabled: true,
        maxRecords: _metering2.METERING_TASK.MAX_BACKFILL_RECORDS
      }
    });
    this.nlpCleanupTask = new _nlp_cleanup_task.NLPCleanupTask({
      core: coreSetup,
      logFactory: this.initializerContext.logger,
      productTier: (0, _product_features.getSecurityAiSocProductTier)(this.config, this.logger),
      taskManager: pluginsSetup.taskManager
    });
    return {};
  }
  start(coreStart, pluginsSetup) {
    var _this$cloudSecurityUs, _this$endpointUsageRe, _this$nlpCleanupTask;
    const internalESClient = coreStart.elasticsearch.client.asInternalUser;
    const internalSOClient = coreStart.savedObjects.createInternalRepository();
    (_this$cloudSecurityUs = this.cloudSecurityUsageReportingTask) === null || _this$cloudSecurityUs === void 0 ? void 0 : _this$cloudSecurityUs.start({
      taskManager: pluginsSetup.taskManager,
      interval: this.config.cloudSecurityUsageReportingTaskInterval
    }).catch(() => {});
    (_this$endpointUsageRe = this.endpointUsageReportingTask) === null || _this$endpointUsageRe === void 0 ? void 0 : _this$endpointUsageRe.start({
      taskManager: pluginsSetup.taskManager,
      interval: this.config.usageReportingTaskInterval
    }).catch(() => {});
    if (_services2.ai4SocMeteringService.shouldMeter(this.config)) {
      var _this$ai4SocUsageRepo;
      (_this$ai4SocUsageRepo = this.ai4SocUsageReportingTask) === null || _this$ai4SocUsageRepo === void 0 ? void 0 : _this$ai4SocUsageRepo.start({
        taskManager: pluginsSetup.taskManager,
        interval: this.config.ai4SocUsageReportingTaskInterval
      }).catch(() => {});
    }
    (_this$nlpCleanupTask = this.nlpCleanupTask) === null || _this$nlpCleanupTask === void 0 ? void 0 : _this$nlpCleanupTask.start({
      taskManager: pluginsSetup.taskManager
    }).catch(() => {});
    (0, _services.setEndpointPackagePolicyServerlessBillingFlags)(internalSOClient, internalESClient, pluginsSetup.fleet.packagePolicyService).catch(() => {});
    return {};
  }
  stop() {}
}
exports.SecuritySolutionServerlessPlugin = SecuritySolutionServerlessPlugin;