"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUpsellings = void 0;
var _pli_features = require("../../common/pli/pli_features");
var _services = require("../common/services");
var _upsellings = require("./upsellings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerUpsellings = (productTypes, services) => {
  const upsellingService = registerSecuritySolutionUpsellings(productTypes, services);
  configurePluginsUpsellings(upsellingService, services);
};

/**
 * Registers the upsellings for the security solution.
 */
exports.registerUpsellings = registerUpsellings;
const registerSecuritySolutionUpsellings = (productTypes, services) => {
  const upsellingService = services.securitySolution.getUpselling();
  const enabledPLIsSet = new Set((0, _pli_features.getEnabledProductFeatures)(productTypes));
  const upsellingPagesToRegister = _upsellings.upsellingPages.reduce((pageUpsellings, {
    pageName,
    pli,
    component
  }) => {
    if (!enabledPLIsSet.has(pli)) {
      pageUpsellings[pageName] = (0, _services.withServicesProvider)(component, services);
    }
    return pageUpsellings;
  }, {});
  const upsellingSectionsToRegister = _upsellings.upsellingSections.reduce((sectionUpsellings, {
    id,
    pli,
    component
  }) => {
    if (!enabledPLIsSet.has(pli)) {
      sectionUpsellings[id] = (0, _services.withServicesProvider)(component, services);
    }
    return sectionUpsellings;
  }, {});
  const upsellingMessagesToRegister = _upsellings.upsellingMessages.reduce((messagesUpsellings, {
    id,
    pli,
    message
  }) => {
    if (!enabledPLIsSet.has(pli)) {
      messagesUpsellings[id] = message;
    }
    return messagesUpsellings;
  }, {});
  upsellingService.setPages(upsellingPagesToRegister);
  upsellingService.setSections(upsellingSectionsToRegister);
  upsellingService.setMessages(upsellingMessagesToRegister);
  return upsellingService;
};

/**
 * Configures the upsellings for other plugins.
 */
const configurePluginsUpsellings = (upsellingService, services) => {
  const {
    automaticImport
  } = services;
  upsellingService.sections$.subscribe(sections => {
    // @ts-expect-error Type 'FunctionComponent<{}>' is not assignable to type 'ReactNode'.
    automaticImport === null || automaticImport === void 0 ? void 0 : automaticImport.renderUpselling(sections.get('automatic_import'));
  });
};