"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseExperimentalConfigValue = exports.getExperimentalAllowedValues = exports.allowedExperimentalValues = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A list of allowed values that can be used in `xpack.securitySolutionServerless.enableExperimental`.
 * This object is then used to validate and parse the value entered.
 */
const allowedExperimentalValues = exports.allowedExperimentalValues = Object.freeze({
  /**
   * <Add a description of the feature here>
   *
   * [This is a fake feature key to showcase how to add a new serverless-specific experimental flag.
   * It also prevents `allowedExperimentalValues` from being empty. It should be removed once a real feature is added.]
   */
  _serverlessFeatureEnabled: false
});
const allowedKeys = Object.keys(allowedExperimentalValues);
/**
 * Parses the string value used in `xpack.securitySolutionServerless.enableExperimental` kibana configuration,
 * which should be a string of values delimited by a comma (`,`)
 * The generic experimental features are merged with the serverless values to ensure they are available
 *
 * @param configValue
 * @throws SecuritySolutionInvalidExperimentalValue
 */
const parseExperimentalConfigValue = (configValue, genericExperimentalFeatures) => {
  const enabledFeatures = {};
  const invalidKeys = [];
  const duplicatedKeys = [];
  for (const value of configValue) {
    if (genericExperimentalFeatures[value] != null) {
      duplicatedKeys.push(value);
    } else if (!allowedKeys.includes(value)) {
      invalidKeys.push(value);
    } else {
      enabledFeatures[value] = true;
    }
  }
  return {
    features: {
      ...genericExperimentalFeatures,
      ...allowedExperimentalValues,
      ...enabledFeatures
    },
    invalid: invalidKeys,
    duplicated: duplicatedKeys
  };
};
exports.parseExperimentalConfigValue = parseExperimentalConfigValue;
const getExperimentalAllowedValues = () => [...allowedKeys];
exports.getExperimentalAllowedValues = getExperimentalAllowedValues;