/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(self.securitySolution_bundle_jsonpfunction=self.securitySolution_bundle_jsonpfunction||[]).push([[4344],{61179:(e,t,i)=>{"use strict";i.d(t,{H:()=>n,k:()=>a});const n={"@timestamp":{dashed_name:"timestamp",description:"Date/time when the event originated.\nThis is the date/time extracted from the event, typically representing when the event was generated by the source.\nIf the event source has no original timestamp, this value is typically populated by the first time the event was received by the pipeline.\nRequired field for all events.",example:"2016-05-23T08:05:34.853Z",flat_name:"@timestamp",level:"core",name:"@timestamp",normalize:[],otel:[{otlp_field:"time_unix_nano",relation:"otlp",stability:"stable"},{otlp_field:"observed_time_unix_nano",relation:"otlp",stability:"stable"},{note:"On logs, events and metrics, `time_unix_nano` defines the time of the event. For logs, `observed_time_unix_nano` defines the time when the event was observed by the collection system. On spans, `start_time_unix_nano` represents the start time of the span.\n",otlp_field:"start_time_unix_nano",relation:"otlp",stability:"stable"}],required:!0,short:"Date/time when the event originated.",type:"date"},"agent.build.original":{dashed_name:"agent-build-original",description:"Extended build information for the agent.\nThis field is intended to contain any build information that a data source may provide, no specific formatting is required.",example:"metricbeat version 7.6.0 (amd64), libbeat 7.6.0 [6a23e8f8f30f5001ba344e4e54d8d9cb82cb107c built 2020-02-05 23:10:10 +0000 UTC]",flat_name:"agent.build.original",ignore_above:1024,level:"core",name:"build.original",normalize:[],short:"Extended build information for the agent.",type:"keyword"},"agent.ephemeral_id":{dashed_name:"agent-ephemeral-id",description:"Ephemeral identifier of this agent (if one exists).\nThis id normally changes across restarts, but `agent.id` does not.",example:"8a4f500f",flat_name:"agent.ephemeral_id",ignore_above:1024,level:"extended",name:"ephemeral_id",normalize:[],short:"Ephemeral identifier of this agent.",type:"keyword"},"agent.id":{dashed_name:"agent-id",description:"Unique identifier of this agent (if one exists).\nExample: For Beats this would be beat.id.",example:"8a4f500d",flat_name:"agent.id",ignore_above:1024,level:"core",name:"id",normalize:[],short:"Unique identifier of this agent.",type:"keyword"},"agent.name":{dashed_name:"agent-name",description:"Custom name of the agent.\nThis is a name that can be given to an agent. This can be helpful if for example two Filebeat instances are running on the same host but a human readable separation is needed on which Filebeat instance data is coming from.",example:"foo",flat_name:"agent.name",ignore_above:1024,level:"core",name:"name",normalize:[],short:"Custom name of the agent.",type:"keyword"},"agent.type":{dashed_name:"agent-type",description:"Type of the agent.\nThe agent type always stays the same and should be given by the agent used. In case of Filebeat the agent would always be Filebeat also if two Filebeat instances are run on the same machine.",example:"filebeat",flat_name:"agent.type",ignore_above:1024,level:"core",name:"type",normalize:[],short:"Type of the agent.",type:"keyword"},"agent.version":{dashed_name:"agent-version",description:"Version of the agent.",example:"6.0.0-rc2",flat_name:"agent.version",ignore_above:1024,level:"core",name:"version",normalize:[],short:"Version of the agent.",type:"keyword"},"client.address":{dashed_name:"client-address",description:"Some event client addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field.\nThen it should be duplicated to `.ip` or `.domain`, depending on which one it is.",flat_name:"client.address",ignore_above:1024,level:"extended",name:"address",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"Client network address.",type:"keyword"},"client.as.number":{dashed_name:"client-as-number",description:"Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.",example:15169,flat_name:"client.as.number",level:"extended",name:"number",normalize:[],original_fieldset:"as",short:"Unique number allocated to the autonomous system.",type:"long"},"client.as.organization.name":{dashed_name:"client-as-organization-name",description:"Organization name.",example:"Google LLC",flat_name:"client.as.organization.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"client.as.organization.name.text",name:"text",type:"match_only_text"}],name:"organization.name",normalize:[],original_fieldset:"as",short:"Organization name.",type:"keyword"},"client.bytes":{dashed_name:"client-bytes",description:"Bytes sent from the client to the server.",example:184,flat_name:"client.bytes",format:"bytes",level:"core",name:"bytes",normalize:[],short:"Bytes sent from the client to the server.",type:"long"},"client.domain":{dashed_name:"client-domain",description:"The domain name of the client system.\nThis value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.",example:"foo.example.com",flat_name:"client.domain",ignore_above:1024,level:"core",name:"domain",normalize:[],short:"The domain name of the client.",type:"keyword"},"client.geo.city_name":{dashed_name:"client-geo-city-name",description:"City name.",example:"Montreal",flat_name:"client.geo.city_name",ignore_above:1024,level:"core",name:"city_name",normalize:[],original_fieldset:"geo",short:"City name.",type:"keyword"},"client.geo.continent_code":{dashed_name:"client-geo-continent-code",description:"Two-letter code representing continent's name.",example:"NA",flat_name:"client.geo.continent_code",ignore_above:1024,level:"core",name:"continent_code",normalize:[],original_fieldset:"geo",short:"Continent code.",type:"keyword"},"client.geo.continent_name":{dashed_name:"client-geo-continent-name",description:"Name of the continent.",example:"North America",flat_name:"client.geo.continent_name",ignore_above:1024,level:"core",name:"continent_name",normalize:[],original_fieldset:"geo",short:"Name of the continent.",type:"keyword"},"client.geo.country_iso_code":{dashed_name:"client-geo-country-iso-code",description:"Country ISO code.",example:"CA",flat_name:"client.geo.country_iso_code",ignore_above:1024,level:"core",name:"country_iso_code",normalize:[],original_fieldset:"geo",short:"Country ISO code.",type:"keyword"},"client.geo.country_name":{dashed_name:"client-geo-country-name",description:"Country name.",example:"Canada",flat_name:"client.geo.country_name",ignore_above:1024,level:"core",name:"country_name",normalize:[],original_fieldset:"geo",short:"Country name.",type:"keyword"},"client.geo.location":{dashed_name:"client-geo-location",description:"Longitude and latitude.",example:'{ "lon": -73.614830, "lat": 45.505918 }',flat_name:"client.geo.location",level:"core",name:"location",normalize:[],original_fieldset:"geo",short:"Longitude and latitude.",type:"geo_point"},"client.geo.name":{dashed_name:"client-geo-name",description:"User-defined description of a location, at the level of granularity they care about.\nCould be the name of their data centers, the floor number, if this describes a local physical entity, city names.\nNot typically used in automated geolocation.",example:"boston-dc",flat_name:"client.geo.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"geo",short:"User-defined description of a location.",type:"keyword"},"client.geo.postal_code":{dashed_name:"client-geo-postal-code",description:"Postal code associated with the location.\nValues appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.",example:94040,flat_name:"client.geo.postal_code",ignore_above:1024,level:"core",name:"postal_code",normalize:[],original_fieldset:"geo",short:"Postal code.",type:"keyword"},"client.geo.region_iso_code":{dashed_name:"client-geo-region-iso-code",description:"Region ISO code.",example:"CA-QC",flat_name:"client.geo.region_iso_code",ignore_above:1024,level:"core",name:"region_iso_code",normalize:[],original_fieldset:"geo",short:"Region ISO code.",type:"keyword"},"client.geo.region_name":{dashed_name:"client-geo-region-name",description:"Region name.",example:"Quebec",flat_name:"client.geo.region_name",ignore_above:1024,level:"core",name:"region_name",normalize:[],original_fieldset:"geo",short:"Region name.",type:"keyword"},"client.geo.timezone":{dashed_name:"client-geo-timezone",description:"The time zone of the location, such as IANA time zone name.",example:"America/Argentina/Buenos_Aires",flat_name:"client.geo.timezone",ignore_above:1024,level:"core",name:"timezone",normalize:[],original_fieldset:"geo",short:"Time zone.",type:"keyword"},"client.ip":{dashed_name:"client-ip",description:"IP address of the client (IPv4 or IPv6).",flat_name:"client.ip",level:"core",name:"ip",normalize:[],short:"IP address of the client.",type:"ip"},"client.mac":{dashed_name:"client-mac",description:"MAC address of the client.\nThe notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.",example:"00-00-5E-00-53-23",flat_name:"client.mac",ignore_above:1024,level:"core",name:"mac",normalize:[],pattern:"^[A-F0-9]{2}(-[A-F0-9]{2}){5,}$",short:"MAC address of the client.",type:"keyword"},"client.nat.ip":{dashed_name:"client-nat-ip",description:"Translated IP of source based NAT sessions (e.g. internal client to internet).\nTypically connections traversing load balancers, firewalls, or routers.",flat_name:"client.nat.ip",level:"extended",name:"nat.ip",normalize:[],short:"Client NAT ip address",type:"ip"},"client.nat.port":{dashed_name:"client-nat-port",description:"Translated port of source based NAT sessions (e.g. internal client to internet).\nTypically connections traversing load balancers, firewalls, or routers.",flat_name:"client.nat.port",format:"string",level:"extended",name:"nat.port",normalize:[],short:"Client NAT port",type:"long"},"client.packets":{dashed_name:"client-packets",description:"Packets sent from the client to the server.",example:12,flat_name:"client.packets",level:"core",name:"packets",normalize:[],short:"Packets sent from the client to the server.",type:"long"},"client.port":{dashed_name:"client-port",description:"Port of the client.",flat_name:"client.port",format:"string",level:"core",name:"port",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"Port of the client.",type:"long"},"client.registered_domain":{dashed_name:"client-registered-domain",description:'The highest registered client domain, stripped of the subdomain.\nFor example, the registered domain for "foo.example.com" is "example.com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".',example:"example.com",flat_name:"client.registered_domain",ignore_above:1024,level:"extended",name:"registered_domain",normalize:[],short:"The highest registered client domain, stripped of the subdomain.",type:"keyword"},"client.subdomain":{dashed_name:"client-subdomain",description:'The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain.\nFor example the subdomain portion of "www.east.mydomain.co.uk" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.',example:"east",flat_name:"client.subdomain",ignore_above:1024,level:"extended",name:"subdomain",normalize:[],short:"The subdomain of the domain.",type:"keyword"},"client.top_level_domain":{dashed_name:"client-top-level-domain",description:'The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".',example:"co.uk",flat_name:"client.top_level_domain",ignore_above:1024,level:"extended",name:"top_level_domain",normalize:[],short:"The effective top level domain (com, org, net, co.uk).",type:"keyword"},"client.user.domain":{dashed_name:"client-user-domain",description:"Name of the directory the user is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"client.user.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"user",short:"Name of the directory the user is a member of.",type:"keyword"},"client.user.email":{dashed_name:"client-user-email",description:"User email address.",flat_name:"client.user.email",ignore_above:1024,level:"extended",name:"email",normalize:[],original_fieldset:"user",short:"User email address.",type:"keyword"},"client.user.full_name":{dashed_name:"client-user-full-name",description:"User's full name, if available.",example:"Albert Einstein",flat_name:"client.user.full_name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"client.user.full_name.text",name:"text",type:"match_only_text"}],name:"full_name",normalize:[],original_fieldset:"user",short:"User's full name, if available.",type:"keyword"},"client.user.group.domain":{dashed_name:"client-user-group-domain",description:"Name of the directory the group is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"client.user.group.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"group",short:"Name of the directory the group is a member of.",type:"keyword"},"client.user.group.id":{dashed_name:"client-user-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"client.user.group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"client.user.group.name":{dashed_name:"client-user-group-name",description:"Name of the group.",flat_name:"client.user.group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"client.user.hash":{dashed_name:"client-user-hash",description:"Unique user hash to correlate information for a user in anonymized form.\nUseful if `user.id` or `user.name` contain confidential information and cannot be used.",flat_name:"client.user.hash",ignore_above:1024,level:"extended",name:"hash",normalize:[],original_fieldset:"user",short:"Unique user hash to correlate information for a user in anonymized form.",type:"keyword"},"client.user.id":{dashed_name:"client-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"client.user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"client.user.name":{dashed_name:"client-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"client.user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"client.user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"client.user.roles":{dashed_name:"client-user-roles",description:"Array of user roles at the time of the event.",example:'["kibana_admin", "reporting_user"]',flat_name:"client.user.roles",ignore_above:1024,level:"extended",name:"roles",normalize:["array"],original_fieldset:"user",short:"Array of user roles at the time of the event.",synthetic_source_keep:"none",type:"keyword"},"cloud.account.id":{dashed_name:"cloud-account-id",description:"The cloud account or organization id used to identify different entities in a multi-tenant environment.\nExamples: AWS account id, Google Cloud ORG Id, or other unique identifier.",example:666777888999,flat_name:"cloud.account.id",ignore_above:1024,level:"extended",name:"account.id",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"The cloud account or organization id.",type:"keyword"},"cloud.account.name":{dashed_name:"cloud-account-name",description:"The cloud account name or alias used to identify different entities in a multi-tenant environment.\nExamples: AWS account name, Google Cloud ORG display name.",example:"elastic-dev",flat_name:"cloud.account.name",ignore_above:1024,level:"extended",name:"account.name",normalize:[],short:"The cloud account name.",type:"keyword"},"cloud.availability_zone":{dashed_name:"cloud-availability-zone",description:"Availability zone in which this host, resource, or service is located.",example:"us-east-1c",flat_name:"cloud.availability_zone",ignore_above:1024,level:"extended",name:"availability_zone",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Availability zone in which this host, resource, or service is located.",type:"keyword"},"cloud.instance.id":{dashed_name:"cloud-instance-id",description:"Instance ID of the host machine.",example:"i-1234567890abcdef0",flat_name:"cloud.instance.id",ignore_above:1024,level:"extended",name:"instance.id",normalize:[],short:"Instance ID of the host machine.",type:"keyword"},"cloud.instance.name":{dashed_name:"cloud-instance-name",description:"Instance name of the host machine.",flat_name:"cloud.instance.name",ignore_above:1024,level:"extended",name:"instance.name",normalize:[],short:"Instance name of the host machine.",type:"keyword"},"cloud.machine.type":{dashed_name:"cloud-machine-type",description:"Machine type of the host machine.",example:"t2.medium",flat_name:"cloud.machine.type",ignore_above:1024,level:"extended",name:"machine.type",normalize:[],short:"Machine type of the host machine.",type:"keyword"},"cloud.origin.account.id":{dashed_name:"cloud-origin-account-id",description:"The cloud account or organization id used to identify different entities in a multi-tenant environment.\nExamples: AWS account id, Google Cloud ORG Id, or other unique identifier.",example:666777888999,flat_name:"cloud.origin.account.id",ignore_above:1024,level:"extended",name:"account.id",normalize:[],original_fieldset:"cloud",short:"The cloud account or organization id.",type:"keyword"},"cloud.origin.account.name":{dashed_name:"cloud-origin-account-name",description:"The cloud account name or alias used to identify different entities in a multi-tenant environment.\nExamples: AWS account name, Google Cloud ORG display name.",example:"elastic-dev",flat_name:"cloud.origin.account.name",ignore_above:1024,level:"extended",name:"account.name",normalize:[],original_fieldset:"cloud",short:"The cloud account name.",type:"keyword"},"cloud.origin.availability_zone":{dashed_name:"cloud-origin-availability-zone",description:"Availability zone in which this host, resource, or service is located.",example:"us-east-1c",flat_name:"cloud.origin.availability_zone",ignore_above:1024,level:"extended",name:"availability_zone",normalize:[],original_fieldset:"cloud",short:"Availability zone in which this host, resource, or service is located.",type:"keyword"},"cloud.origin.instance.id":{dashed_name:"cloud-origin-instance-id",description:"Instance ID of the host machine.",example:"i-1234567890abcdef0",flat_name:"cloud.origin.instance.id",ignore_above:1024,level:"extended",name:"instance.id",normalize:[],original_fieldset:"cloud",short:"Instance ID of the host machine.",type:"keyword"},"cloud.origin.instance.name":{dashed_name:"cloud-origin-instance-name",description:"Instance name of the host machine.",flat_name:"cloud.origin.instance.name",ignore_above:1024,level:"extended",name:"instance.name",normalize:[],original_fieldset:"cloud",short:"Instance name of the host machine.",type:"keyword"},"cloud.origin.machine.type":{dashed_name:"cloud-origin-machine-type",description:"Machine type of the host machine.",example:"t2.medium",flat_name:"cloud.origin.machine.type",ignore_above:1024,level:"extended",name:"machine.type",normalize:[],original_fieldset:"cloud",short:"Machine type of the host machine.",type:"keyword"},"cloud.origin.project.id":{dashed_name:"cloud-origin-project-id",description:"The cloud project identifier.\nExamples: Google Cloud Project id, Azure Project id.",example:"my-project",flat_name:"cloud.origin.project.id",ignore_above:1024,level:"extended",name:"project.id",normalize:[],original_fieldset:"cloud",short:"The cloud project id.",type:"keyword"},"cloud.origin.project.name":{dashed_name:"cloud-origin-project-name",description:"The cloud project name.\nExamples: Google Cloud Project name, Azure Project name.",example:"my project",flat_name:"cloud.origin.project.name",ignore_above:1024,level:"extended",name:"project.name",normalize:[],original_fieldset:"cloud",short:"The cloud project name.",type:"keyword"},"cloud.origin.provider":{dashed_name:"cloud-origin-provider",description:"Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.",example:"aws",flat_name:"cloud.origin.provider",ignore_above:1024,level:"extended",name:"provider",normalize:[],original_fieldset:"cloud",short:"Name of the cloud provider.",type:"keyword"},"cloud.origin.region":{dashed_name:"cloud-origin-region",description:"Region in which this host, resource, or service is located.",example:"us-east-1",flat_name:"cloud.origin.region",ignore_above:1024,level:"extended",name:"region",normalize:[],original_fieldset:"cloud",short:"Region in which this host, resource, or service is located.",type:"keyword"},"cloud.origin.service.name":{dashed_name:"cloud-origin-service-name",description:"The cloud service name is intended to distinguish services running on different platforms within a provider, eg AWS EC2 vs Lambda, GCP GCE vs App Engine, Azure VM vs App Server.\nExamples: app engine, app service, cloud run, fargate, lambda.",example:"lambda",flat_name:"cloud.origin.service.name",ignore_above:1024,level:"extended",name:"service.name",normalize:[],original_fieldset:"cloud",short:"The cloud service name.",type:"keyword"},"cloud.project.id":{dashed_name:"cloud-project-id",description:"The cloud project identifier.\nExamples: Google Cloud Project id, Azure Project id.",example:"my-project",flat_name:"cloud.project.id",ignore_above:1024,level:"extended",name:"project.id",normalize:[],short:"The cloud project id.",type:"keyword"},"cloud.project.name":{dashed_name:"cloud-project-name",description:"The cloud project name.\nExamples: Google Cloud Project name, Azure Project name.",example:"my project",flat_name:"cloud.project.name",ignore_above:1024,level:"extended",name:"project.name",normalize:[],short:"The cloud project name.",type:"keyword"},"cloud.provider":{dashed_name:"cloud-provider",description:"Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.",example:"aws",flat_name:"cloud.provider",ignore_above:1024,level:"extended",name:"provider",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Name of the cloud provider.",type:"keyword"},"cloud.region":{dashed_name:"cloud-region",description:"Region in which this host, resource, or service is located.",example:"us-east-1",flat_name:"cloud.region",ignore_above:1024,level:"extended",name:"region",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Region in which this host, resource, or service is located.",type:"keyword"},"cloud.service.name":{dashed_name:"cloud-service-name",description:"The cloud service name is intended to distinguish services running on different platforms within a provider, eg AWS EC2 vs Lambda, GCP GCE vs App Engine, Azure VM vs App Server.\nExamples: app engine, app service, cloud run, fargate, lambda.",example:"lambda",flat_name:"cloud.service.name",ignore_above:1024,level:"extended",name:"service.name",normalize:[],otel:[{attribute:"cloud.platform",relation:"equivalent",stability:"experimental"}],short:"The cloud service name.",type:"keyword"},"cloud.target.account.id":{dashed_name:"cloud-target-account-id",description:"The cloud account or organization id used to identify different entities in a multi-tenant environment.\nExamples: AWS account id, Google Cloud ORG Id, or other unique identifier.",example:666777888999,flat_name:"cloud.target.account.id",ignore_above:1024,level:"extended",name:"account.id",normalize:[],original_fieldset:"cloud",short:"The cloud account or organization id.",type:"keyword"},"cloud.target.account.name":{dashed_name:"cloud-target-account-name",description:"The cloud account name or alias used to identify different entities in a multi-tenant environment.\nExamples: AWS account name, Google Cloud ORG display name.",example:"elastic-dev",flat_name:"cloud.target.account.name",ignore_above:1024,level:"extended",name:"account.name",normalize:[],original_fieldset:"cloud",short:"The cloud account name.",type:"keyword"},"cloud.target.availability_zone":{dashed_name:"cloud-target-availability-zone",description:"Availability zone in which this host, resource, or service is located.",example:"us-east-1c",flat_name:"cloud.target.availability_zone",ignore_above:1024,level:"extended",name:"availability_zone",normalize:[],original_fieldset:"cloud",short:"Availability zone in which this host, resource, or service is located.",type:"keyword"},"cloud.target.instance.id":{dashed_name:"cloud-target-instance-id",description:"Instance ID of the host machine.",example:"i-1234567890abcdef0",flat_name:"cloud.target.instance.id",ignore_above:1024,level:"extended",name:"instance.id",normalize:[],original_fieldset:"cloud",short:"Instance ID of the host machine.",type:"keyword"},"cloud.target.instance.name":{dashed_name:"cloud-target-instance-name",description:"Instance name of the host machine.",flat_name:"cloud.target.instance.name",ignore_above:1024,level:"extended",name:"instance.name",normalize:[],original_fieldset:"cloud",short:"Instance name of the host machine.",type:"keyword"},"cloud.target.machine.type":{dashed_name:"cloud-target-machine-type",description:"Machine type of the host machine.",example:"t2.medium",flat_name:"cloud.target.machine.type",ignore_above:1024,level:"extended",name:"machine.type",normalize:[],original_fieldset:"cloud",short:"Machine type of the host machine.",type:"keyword"},"cloud.target.project.id":{dashed_name:"cloud-target-project-id",description:"The cloud project identifier.\nExamples: Google Cloud Project id, Azure Project id.",example:"my-project",flat_name:"cloud.target.project.id",ignore_above:1024,level:"extended",name:"project.id",normalize:[],original_fieldset:"cloud",short:"The cloud project id.",type:"keyword"},"cloud.target.project.name":{dashed_name:"cloud-target-project-name",description:"The cloud project name.\nExamples: Google Cloud Project name, Azure Project name.",example:"my project",flat_name:"cloud.target.project.name",ignore_above:1024,level:"extended",name:"project.name",normalize:[],original_fieldset:"cloud",short:"The cloud project name.",type:"keyword"},"cloud.target.provider":{dashed_name:"cloud-target-provider",description:"Name of the cloud provider. Example values are aws, azure, gcp, or digitalocean.",example:"aws",flat_name:"cloud.target.provider",ignore_above:1024,level:"extended",name:"provider",normalize:[],original_fieldset:"cloud",short:"Name of the cloud provider.",type:"keyword"},"cloud.target.region":{dashed_name:"cloud-target-region",description:"Region in which this host, resource, or service is located.",example:"us-east-1",flat_name:"cloud.target.region",ignore_above:1024,level:"extended",name:"region",normalize:[],original_fieldset:"cloud",short:"Region in which this host, resource, or service is located.",type:"keyword"},"cloud.target.service.name":{dashed_name:"cloud-target-service-name",description:"The cloud service name is intended to distinguish services running on different platforms within a provider, eg AWS EC2 vs Lambda, GCP GCE vs App Engine, Azure VM vs App Server.\nExamples: app engine, app service, cloud run, fargate, lambda.",example:"lambda",flat_name:"cloud.target.service.name",ignore_above:1024,level:"extended",name:"service.name",normalize:[],original_fieldset:"cloud",short:"The cloud service name.",type:"keyword"},"container.cpu.usage":{dashed_name:"container-cpu-usage",description:"Percent CPU used which is normalized by the number of CPU cores and it ranges from 0 to 1. Scaling factor: 1000.",flat_name:"container.cpu.usage",level:"extended",name:"cpu.usage",normalize:[],otel:[{metric:"container.cpu.usage",relation:"metric",stability:"experimental"}],scaling_factor:1e3,short:"Percent CPU used, between 0 and 1.",type:"scaled_float"},"container.disk.read.bytes":{dashed_name:"container-disk-read-bytes",description:"The total number of bytes (gauge) read successfully (aggregated from all disks) since the last metric collection.",flat_name:"container.disk.read.bytes",level:"extended",name:"disk.read.bytes",normalize:[],short:"The number of bytes read by all disks.",type:"long"},"container.disk.write.bytes":{dashed_name:"container-disk-write-bytes",description:"The total number of bytes (gauge) written successfully (aggregated from all disks) since the last metric collection.",flat_name:"container.disk.write.bytes",level:"extended",name:"disk.write.bytes",normalize:[],short:"The number of bytes written on all disks.",type:"long"},"container.id":{dashed_name:"container-id",description:"Unique container id.",flat_name:"container.id",ignore_above:1024,level:"core",name:"id",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Unique container id.",type:"keyword"},"container.image.hash.all":{dashed_name:"container-image-hash-all",description:"An array of digests of the image the container was built on. Each digest consists of the hash algorithm and value in this format: `algorithm:value`. Algorithm names should align with the field names in the ECS hash field set.",example:"[sha256:f8fefc80e3273dc756f288a63945820d6476ad64883892c771b5e2ece6bf1b26]",flat_name:"container.image.hash.all",ignore_above:1024,level:"extended",name:"image.hash.all",normalize:["array"],otel:[{attribute:"container.image.repo_digests",relation:"equivalent",stability:"experimental"}],short:"An array of digests of the image the container was built on.",type:"keyword"},"container.image.name":{dashed_name:"container-image-name",description:"Name of the image the container was built on.",flat_name:"container.image.name",ignore_above:1024,level:"extended",name:"image.name",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Name of the image the container was built on.",type:"keyword"},"container.image.tag":{dashed_name:"container-image-tag",description:"Container image tags.",flat_name:"container.image.tag",ignore_above:1024,level:"extended",name:"image.tag",normalize:["array"],otel:[{attribute:"container.image.tags",relation:"equivalent",stability:"experimental"}],short:"Container image tags.",synthetic_source_keep:"none",type:"keyword"},"container.labels":{dashed_name:"container-labels",description:"Image labels.",flat_name:"container.labels",level:"extended",name:"labels",normalize:[],object_type:"keyword",otel:[{attribute:"container.label",relation:"related",stability:"experimental"}],short:"Image labels.",type:"object"},"container.memory.usage":{dashed_name:"container-memory-usage",description:"Memory usage percentage and it ranges from 0 to 1. Scaling factor: 1000.",flat_name:"container.memory.usage",level:"extended",name:"memory.usage",normalize:[],otel:[{metric:"container.memory.usage",relation:"metric",stability:"experimental"}],scaling_factor:1e3,short:"Percent memory used, between 0 and 1.",type:"scaled_float"},"container.name":{dashed_name:"container-name",description:"Container name.",flat_name:"container.name",ignore_above:1024,level:"extended",name:"name",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Container name.",type:"keyword"},"container.network.egress.bytes":{dashed_name:"container-network-egress-bytes",description:"The number of bytes (gauge) sent out on all network interfaces by the container since the last metric collection.",flat_name:"container.network.egress.bytes",level:"extended",name:"network.egress.bytes",normalize:[],short:"The number of bytes sent on all network interfaces.",type:"long"},"container.network.ingress.bytes":{dashed_name:"container-network-ingress-bytes",description:"The number of bytes received (gauge) on all network interfaces by the container since the last metric collection.",flat_name:"container.network.ingress.bytes",level:"extended",name:"network.ingress.bytes",normalize:[],short:"The number of bytes received on all network interfaces.",type:"long"},"container.runtime":{dashed_name:"container-runtime",description:"Runtime managing this container.",example:"docker",flat_name:"container.runtime",ignore_above:1024,level:"extended",name:"runtime",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Runtime managing this container.",type:"keyword"},"container.security_context.privileged":{dashed_name:"container-security-context-privileged",description:"Indicates whether the container is running in privileged mode.",flat_name:"container.security_context.privileged",level:"extended",name:"security_context.privileged",normalize:[],short:"Indicates whether the container is running in privileged mode.",type:"boolean"},"data_stream.dataset":{dashed_name:"data-stream-dataset",description:'The field can contain anything that makes sense to signify the source of the data.\nExamples include `nginx.access`, `prometheus`, `endpoint` etc. For data streams that otherwise fit, but that do not have dataset set we use the value "generic" for the dataset value. `event.dataset` should have the same value as `data_stream.dataset`.\nBeyond the Elasticsearch data stream naming criteria noted above, the `dataset` value has additional restrictions:\n  * Must not contain `-`\n  * No longer than 100 characters',example:"nginx.access",flat_name:"data_stream.dataset",level:"extended",name:"dataset",normalize:[],otel:[{relation:"na"}],short:"The field can contain anything that makes sense to signify the source of the data.",type:"constant_keyword"},"data_stream.namespace":{dashed_name:"data-stream-namespace",description:"A user defined namespace. Namespaces are useful to allow grouping of data.\nMany users already organize their indices this way, and the data stream naming scheme now provides this best practice as a default. Many users will populate this field with `default`. If no value is used, it falls back to `default`.\nBeyond the Elasticsearch index naming criteria noted above, `namespace` value has the additional restrictions:\n  * Must not contain `-`\n  * No longer than 100 characters",example:"production",flat_name:"data_stream.namespace",level:"extended",name:"namespace",normalize:[],otel:[{relation:"na"}],short:"A user defined namespace. Namespaces are useful to allow grouping of data.",type:"constant_keyword"},"data_stream.type":{dashed_name:"data-stream-type",description:'An overarching type for the data stream.\nCurrently allowed values are "logs" and "metrics". We expect to also add "traces" and "synthetics" in the near future.',example:"logs",flat_name:"data_stream.type",level:"extended",name:"type",normalize:[],otel:[{relation:"na"}],short:"An overarching type for the data stream.",type:"constant_keyword"},"destination.address":{dashed_name:"destination-address",description:"Some event destination addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field.\nThen it should be duplicated to `.ip` or `.domain`, depending on which one it is.",flat_name:"destination.address",ignore_above:1024,level:"extended",name:"address",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Destination network address.",type:"keyword"},"destination.as.number":{dashed_name:"destination-as-number",description:"Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.",example:15169,flat_name:"destination.as.number",level:"extended",name:"number",normalize:[],original_fieldset:"as",short:"Unique number allocated to the autonomous system.",type:"long"},"destination.as.organization.name":{dashed_name:"destination-as-organization-name",description:"Organization name.",example:"Google LLC",flat_name:"destination.as.organization.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"destination.as.organization.name.text",name:"text",type:"match_only_text"}],name:"organization.name",normalize:[],original_fieldset:"as",short:"Organization name.",type:"keyword"},"destination.bytes":{dashed_name:"destination-bytes",description:"Bytes sent from the destination to the source.",example:184,flat_name:"destination.bytes",format:"bytes",level:"core",name:"bytes",normalize:[],short:"Bytes sent from the destination to the source.",type:"long"},"destination.domain":{dashed_name:"destination-domain",description:"The domain name of the destination system.\nThis value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.",example:"foo.example.com",flat_name:"destination.domain",ignore_above:1024,level:"core",name:"domain",normalize:[],short:"The domain name of the destination.",type:"keyword"},"destination.geo.city_name":{dashed_name:"destination-geo-city-name",description:"City name.",example:"Montreal",flat_name:"destination.geo.city_name",ignore_above:1024,level:"core",name:"city_name",normalize:[],original_fieldset:"geo",short:"City name.",type:"keyword"},"destination.geo.continent_code":{dashed_name:"destination-geo-continent-code",description:"Two-letter code representing continent's name.",example:"NA",flat_name:"destination.geo.continent_code",ignore_above:1024,level:"core",name:"continent_code",normalize:[],original_fieldset:"geo",short:"Continent code.",type:"keyword"},"destination.geo.continent_name":{dashed_name:"destination-geo-continent-name",description:"Name of the continent.",example:"North America",flat_name:"destination.geo.continent_name",ignore_above:1024,level:"core",name:"continent_name",normalize:[],original_fieldset:"geo",short:"Name of the continent.",type:"keyword"},"destination.geo.country_iso_code":{dashed_name:"destination-geo-country-iso-code",description:"Country ISO code.",example:"CA",flat_name:"destination.geo.country_iso_code",ignore_above:1024,level:"core",name:"country_iso_code",normalize:[],original_fieldset:"geo",short:"Country ISO code.",type:"keyword"},"destination.geo.country_name":{dashed_name:"destination-geo-country-name",description:"Country name.",example:"Canada",flat_name:"destination.geo.country_name",ignore_above:1024,level:"core",name:"country_name",normalize:[],original_fieldset:"geo",short:"Country name.",type:"keyword"},"destination.geo.location":{dashed_name:"destination-geo-location",description:"Longitude and latitude.",example:'{ "lon": -73.614830, "lat": 45.505918 }',flat_name:"destination.geo.location",level:"core",name:"location",normalize:[],original_fieldset:"geo",short:"Longitude and latitude.",type:"geo_point"},"destination.geo.name":{dashed_name:"destination-geo-name",description:"User-defined description of a location, at the level of granularity they care about.\nCould be the name of their data centers, the floor number, if this describes a local physical entity, city names.\nNot typically used in automated geolocation.",example:"boston-dc",flat_name:"destination.geo.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"geo",short:"User-defined description of a location.",type:"keyword"},"destination.geo.postal_code":{dashed_name:"destination-geo-postal-code",description:"Postal code associated with the location.\nValues appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.",example:94040,flat_name:"destination.geo.postal_code",ignore_above:1024,level:"core",name:"postal_code",normalize:[],original_fieldset:"geo",short:"Postal code.",type:"keyword"},"destination.geo.region_iso_code":{dashed_name:"destination-geo-region-iso-code",description:"Region ISO code.",example:"CA-QC",flat_name:"destination.geo.region_iso_code",ignore_above:1024,level:"core",name:"region_iso_code",normalize:[],original_fieldset:"geo",short:"Region ISO code.",type:"keyword"},"destination.geo.region_name":{dashed_name:"destination-geo-region-name",description:"Region name.",example:"Quebec",flat_name:"destination.geo.region_name",ignore_above:1024,level:"core",name:"region_name",normalize:[],original_fieldset:"geo",short:"Region name.",type:"keyword"},"destination.geo.timezone":{dashed_name:"destination-geo-timezone",description:"The time zone of the location, such as IANA time zone name.",example:"America/Argentina/Buenos_Aires",flat_name:"destination.geo.timezone",ignore_above:1024,level:"core",name:"timezone",normalize:[],original_fieldset:"geo",short:"Time zone.",type:"keyword"},"destination.ip":{dashed_name:"destination-ip",description:"IP address of the destination (IPv4 or IPv6).",flat_name:"destination.ip",level:"core",name:"ip",normalize:[],short:"IP address of the destination.",type:"ip"},"destination.mac":{dashed_name:"destination-mac",description:"MAC address of the destination.\nThe notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.",example:"00-00-5E-00-53-23",flat_name:"destination.mac",ignore_above:1024,level:"core",name:"mac",normalize:[],pattern:"^[A-F0-9]{2}(-[A-F0-9]{2}){5,}$",short:"MAC address of the destination.",type:"keyword"},"destination.nat.ip":{dashed_name:"destination-nat-ip",description:"Translated ip of destination based NAT sessions (e.g. internet to private DMZ)\nTypically used with load balancers, firewalls, or routers.",flat_name:"destination.nat.ip",level:"extended",name:"nat.ip",normalize:[],short:"Destination NAT ip",type:"ip"},"destination.nat.port":{dashed_name:"destination-nat-port",description:"Port the source session is translated to by NAT Device.\nTypically used with load balancers, firewalls, or routers.",flat_name:"destination.nat.port",format:"string",level:"extended",name:"nat.port",normalize:[],short:"Destination NAT Port",type:"long"},"destination.packets":{dashed_name:"destination-packets",description:"Packets sent from the destination to the source.",example:12,flat_name:"destination.packets",level:"core",name:"packets",normalize:[],short:"Packets sent from the destination to the source.",type:"long"},"destination.port":{dashed_name:"destination-port",description:"Port of the destination.",flat_name:"destination.port",format:"string",level:"core",name:"port",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Port of the destination.",type:"long"},"destination.registered_domain":{dashed_name:"destination-registered-domain",description:'The highest registered destination domain, stripped of the subdomain.\nFor example, the registered domain for "foo.example.com" is "example.com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".',example:"example.com",flat_name:"destination.registered_domain",ignore_above:1024,level:"extended",name:"registered_domain",normalize:[],short:"The highest registered destination domain, stripped of the subdomain.",type:"keyword"},"destination.subdomain":{dashed_name:"destination-subdomain",description:'The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain.\nFor example the subdomain portion of "www.east.mydomain.co.uk" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.',example:"east",flat_name:"destination.subdomain",ignore_above:1024,level:"extended",name:"subdomain",normalize:[],short:"The subdomain of the domain.",type:"keyword"},"destination.top_level_domain":{dashed_name:"destination-top-level-domain",description:'The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".',example:"co.uk",flat_name:"destination.top_level_domain",ignore_above:1024,level:"extended",name:"top_level_domain",normalize:[],short:"The effective top level domain (com, org, net, co.uk).",type:"keyword"},"destination.user.domain":{dashed_name:"destination-user-domain",description:"Name of the directory the user is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"destination.user.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"user",short:"Name of the directory the user is a member of.",type:"keyword"},"destination.user.email":{dashed_name:"destination-user-email",description:"User email address.",flat_name:"destination.user.email",ignore_above:1024,level:"extended",name:"email",normalize:[],original_fieldset:"user",short:"User email address.",type:"keyword"},"destination.user.full_name":{dashed_name:"destination-user-full-name",description:"User's full name, if available.",example:"Albert Einstein",flat_name:"destination.user.full_name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"destination.user.full_name.text",name:"text",type:"match_only_text"}],name:"full_name",normalize:[],original_fieldset:"user",short:"User's full name, if available.",type:"keyword"},"destination.user.group.domain":{dashed_name:"destination-user-group-domain",description:"Name of the directory the group is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"destination.user.group.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"group",short:"Name of the directory the group is a member of.",type:"keyword"},"destination.user.group.id":{dashed_name:"destination-user-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"destination.user.group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"destination.user.group.name":{dashed_name:"destination-user-group-name",description:"Name of the group.",flat_name:"destination.user.group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"destination.user.hash":{dashed_name:"destination-user-hash",description:"Unique user hash to correlate information for a user in anonymized form.\nUseful if `user.id` or `user.name` contain confidential information and cannot be used.",flat_name:"destination.user.hash",ignore_above:1024,level:"extended",name:"hash",normalize:[],original_fieldset:"user",short:"Unique user hash to correlate information for a user in anonymized form.",type:"keyword"},"destination.user.id":{dashed_name:"destination-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"destination.user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"destination.user.name":{dashed_name:"destination-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"destination.user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"destination.user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"destination.user.roles":{dashed_name:"destination-user-roles",description:"Array of user roles at the time of the event.",example:'["kibana_admin", "reporting_user"]',flat_name:"destination.user.roles",ignore_above:1024,level:"extended",name:"roles",normalize:["array"],original_fieldset:"user",short:"Array of user roles at the time of the event.",synthetic_source_keep:"none",type:"keyword"},"device.id":{dashed_name:"device-id",description:"The unique identifier of a device. The identifier must not change across application sessions but stay fixed for an instance of a (mobile) device.\nOn iOS, this value must be equal to the vendor identifier (https://developer.apple.com/documentation/uikit/uidevice/1620059-identifierforvendor). On Android, this value must be equal to the Firebase Installation ID or a globally unique UUID which is persisted across sessions in your application.\nFor GDPR and data protection law reasons this identifier should not carry information that would allow to identify a user.",example:"00000000-54b3-e7c7-0000-000046bffd97",flat_name:"device.id",ignore_above:1024,level:"extended",name:"id",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"The unique identifier of a device.",type:"keyword"},"device.manufacturer":{dashed_name:"device-manufacturer",description:"The vendor name of the device manufacturer.",example:"Samsung",flat_name:"device.manufacturer",ignore_above:1024,level:"extended",name:"manufacturer",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"The vendor name of the device manufacturer.",type:"keyword"},"device.model.identifier":{dashed_name:"device-model-identifier",description:"The machine readable identifier of the device model.",example:"SM-G920F",flat_name:"device.model.identifier",ignore_above:1024,level:"extended",name:"model.identifier",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"The machine readable identifier of the device model.",type:"keyword"},"device.model.name":{dashed_name:"device-model-name",description:"The human readable marketing name of the device model.",example:"Samsung Galaxy S6",flat_name:"device.model.name",ignore_above:1024,level:"extended",name:"model.name",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"The human readable marketing name of the device model.",type:"keyword"},"device.serial_number":{beta:"This field is beta and subject to change.",dashed_name:"device-serial-number",description:"The unique serial number serves as a distinct identifier for each device, aiding in inventory management and device authentication.",example:"DJGAQS4CW5",flat_name:"device.serial_number",ignore_above:1024,level:"core",name:"serial_number",normalize:[],short:"Serial Number of the device",type:"keyword"},"dll.code_signature.digest_algorithm":{dashed_name:"dll-code-signature-digest-algorithm",description:"The hashing algorithm used to sign the process.\nThis value can distinguish signatures when a file is signed multiple times by the same signer but with a different digest algorithm.",example:"sha256",flat_name:"dll.code_signature.digest_algorithm",ignore_above:1024,level:"extended",name:"digest_algorithm",normalize:[],original_fieldset:"code_signature",short:"Hashing algorithm used to sign the process.",type:"keyword"},"dll.code_signature.exists":{dashed_name:"dll-code-signature-exists",description:"Boolean to capture if a signature is present.",example:"true",flat_name:"dll.code_signature.exists",level:"core",name:"exists",normalize:[],original_fieldset:"code_signature",short:"Boolean to capture if a signature is present.",type:"boolean"},"dll.code_signature.flags":{beta:"This field is beta and subject to change.",dashed_name:"dll-code-signature-flags",description:"The flags used to sign the process.",example:570522385,flat_name:"dll.code_signature.flags",ignore_above:1024,level:"extended",name:"flags",normalize:[],original_fieldset:"code_signature",short:"Code signing flags of the process",type:"keyword"},"dll.code_signature.signing_id":{dashed_name:"dll-code-signature-signing-id",description:"The identifier used to sign the process.\nThis is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only.",example:"com.apple.xpc.proxy",flat_name:"dll.code_signature.signing_id",ignore_above:1024,level:"extended",name:"signing_id",normalize:[],original_fieldset:"code_signature",short:"The identifier used to sign the process.",type:"keyword"},"dll.code_signature.status":{dashed_name:"dll-code-signature-status",description:"Additional information about the certificate status.\nThis is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.",example:"ERROR_UNTRUSTED_ROOT",flat_name:"dll.code_signature.status",ignore_above:1024,level:"extended",name:"status",normalize:[],original_fieldset:"code_signature",short:"Additional information about the certificate status.",type:"keyword"},"dll.code_signature.subject_name":{dashed_name:"dll-code-signature-subject-name",description:"Subject name of the code signer",example:"Microsoft Corporation",flat_name:"dll.code_signature.subject_name",ignore_above:1024,level:"core",name:"subject_name",normalize:[],original_fieldset:"code_signature",short:"Subject name of the code signer",type:"keyword"},"dll.code_signature.team_id":{dashed_name:"dll-code-signature-team-id",description:"The team identifier used to sign the process.\nThis is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only.",example:"EQHXZ8M8AV",flat_name:"dll.code_signature.team_id",ignore_above:1024,level:"extended",name:"team_id",normalize:[],original_fieldset:"code_signature",short:"The team identifier used to sign the process.",type:"keyword"},"dll.code_signature.timestamp":{dashed_name:"dll-code-signature-timestamp",description:"Date and time when the code signature was generated and signed.",example:"2021-01-01T12:10:30Z",flat_name:"dll.code_signature.timestamp",level:"extended",name:"timestamp",normalize:[],original_fieldset:"code_signature",short:"When the signature was generated and signed.",type:"date"},"dll.code_signature.trusted":{dashed_name:"dll-code-signature-trusted",description:"Stores the trust status of the certificate chain.\nValidating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.",example:"true",flat_name:"dll.code_signature.trusted",level:"extended",name:"trusted",normalize:[],original_fieldset:"code_signature",short:"Stores the trust status of the certificate chain.",type:"boolean"},"dll.code_signature.valid":{dashed_name:"dll-code-signature-valid",description:"Boolean to capture if the digital signature is verified against the binary content.\nLeave unpopulated if a certificate was unchecked.",example:"true",flat_name:"dll.code_signature.valid",level:"extended",name:"valid",normalize:[],original_fieldset:"code_signature",short:"Boolean to capture if the digital signature is verified against the binary content.",type:"boolean"},"dll.hash.cdhash":{beta:"This field is beta and subject to change.",dashed_name:"dll-hash-cdhash",description:"Code directory hash, utilized to uniquely identify and authenticate the integrity of the executable code.",example:"3783b4052fd474dbe30676b45c329e7a6d44acd9",flat_name:"dll.hash.cdhash",ignore_above:1024,level:"extended",name:"cdhash",normalize:[],original_fieldset:"hash",short:"The Code Directory (CD) hash of an executable.",type:"keyword"},"dll.hash.md5":{dashed_name:"dll-hash-md5",description:"MD5 hash.",flat_name:"dll.hash.md5",ignore_above:1024,level:"extended",name:"md5",normalize:[],original_fieldset:"hash",short:"MD5 hash.",type:"keyword"},"dll.hash.sha1":{dashed_name:"dll-hash-sha1",description:"SHA1 hash.",flat_name:"dll.hash.sha1",ignore_above:1024,level:"extended",name:"sha1",normalize:[],original_fieldset:"hash",short:"SHA1 hash.",type:"keyword"},"dll.hash.sha256":{dashed_name:"dll-hash-sha256",description:"SHA256 hash.",flat_name:"dll.hash.sha256",ignore_above:1024,level:"extended",name:"sha256",normalize:[],original_fieldset:"hash",short:"SHA256 hash.",type:"keyword"},"dll.hash.sha384":{dashed_name:"dll-hash-sha384",description:"SHA384 hash.",flat_name:"dll.hash.sha384",ignore_above:1024,level:"extended",name:"sha384",normalize:[],original_fieldset:"hash",short:"SHA384 hash.",type:"keyword"},"dll.hash.sha512":{dashed_name:"dll-hash-sha512",description:"SHA512 hash.",flat_name:"dll.hash.sha512",ignore_above:1024,level:"extended",name:"sha512",normalize:[],original_fieldset:"hash",short:"SHA512 hash.",type:"keyword"},"dll.hash.ssdeep":{dashed_name:"dll-hash-ssdeep",description:"SSDEEP hash.",flat_name:"dll.hash.ssdeep",ignore_above:1024,level:"extended",name:"ssdeep",normalize:[],original_fieldset:"hash",short:"SSDEEP hash.",type:"keyword"},"dll.hash.tlsh":{dashed_name:"dll-hash-tlsh",description:"TLSH hash.",flat_name:"dll.hash.tlsh",ignore_above:1024,level:"extended",name:"tlsh",normalize:[],original_fieldset:"hash",short:"TLSH hash.",type:"keyword"},"dll.name":{dashed_name:"dll-name",description:"Name of the library.\nThis generally maps to the name of the file on disk.",example:"kernel32.dll",flat_name:"dll.name",ignore_above:1024,level:"core",name:"name",normalize:[],short:"Name of the library.",type:"keyword"},"dll.origin_referrer_url":{beta:"This field is beta and subject to change.",dashed_name:"dll-origin-referrer-url",description:"The URL of the webpage that linked to the dll file.",example:"http://example.com/article1.html",flat_name:"dll.origin_referrer_url",ignore_above:8192,level:"extended",name:"origin_referrer_url",normalize:[],short:"The URL of the webpage that linked to the dll file.",type:"keyword"},"dll.origin_url":{beta:"This field is beta and subject to change.",dashed_name:"dll-origin-url",description:"The URL where the dll file is hosted.",example:"http://example.com/files/example.dll",flat_name:"dll.origin_url",ignore_above:8192,level:"extended",name:"origin_url",normalize:[],short:"The URL where the dll file is hosted.",type:"keyword"},"dll.path":{dashed_name:"dll-path",description:"Full file path of the library.",example:"C:\\Windows\\System32\\kernel32.dll",flat_name:"dll.path",ignore_above:1024,level:"extended",name:"path",normalize:[],short:"Full file path of the library.",type:"keyword"},"dll.pe.architecture":{dashed_name:"dll-pe-architecture",description:"CPU architecture target for the file.",example:"x64",flat_name:"dll.pe.architecture",ignore_above:1024,level:"extended",name:"architecture",normalize:[],original_fieldset:"pe",short:"CPU architecture target for the file.",type:"keyword"},"dll.pe.company":{dashed_name:"dll-pe-company",description:"Internal company name of the file, provided at compile-time.",example:"Microsoft Corporation",flat_name:"dll.pe.company",ignore_above:1024,level:"extended",name:"company",normalize:[],original_fieldset:"pe",short:"Internal company name of the file, provided at compile-time.",type:"keyword"},"dll.pe.description":{dashed_name:"dll-pe-description",description:"Internal description of the file, provided at compile-time.",example:"Paint",flat_name:"dll.pe.description",ignore_above:1024,level:"extended",name:"description",normalize:[],original_fieldset:"pe",short:"Internal description of the file, provided at compile-time.",type:"keyword"},"dll.pe.file_version":{dashed_name:"dll-pe-file-version",description:"Internal version of the file, provided at compile-time.",example:"6.3.9600.17415",flat_name:"dll.pe.file_version",ignore_above:1024,level:"extended",name:"file_version",normalize:[],original_fieldset:"pe",short:"Process name.",type:"keyword"},"dll.pe.go_import_hash":{dashed_name:"dll-pe-go-import-hash",description:"A hash of the Go language imports in a PE file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThe algorithm used to calculate the Go symbol hash and a reference implementation are available here: https://github.com/elastic/toutoumomoma",example:"10bddcb4cee42080f76c88d9ff964491",flat_name:"dll.pe.go_import_hash",ignore_above:1024,level:"extended",name:"go_import_hash",normalize:[],original_fieldset:"pe",short:"A hash of the Go language imports in a PE file.",type:"keyword"},"dll.pe.go_imports":{dashed_name:"dll-pe-go-imports",description:"List of imported Go language element names and types.",flat_name:"dll.pe.go_imports",level:"extended",name:"go_imports",normalize:[],original_fieldset:"pe",short:"List of imported Go language element names and types.",type:"flattened"},"dll.pe.go_imports_names_entropy":{dashed_name:"dll-pe-go-imports-names-entropy",description:"Shannon entropy calculation from the list of Go imports.",flat_name:"dll.pe.go_imports_names_entropy",format:"number",level:"extended",name:"go_imports_names_entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the list of Go imports.",type:"long"},"dll.pe.go_imports_names_var_entropy":{dashed_name:"dll-pe-go-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of Go imports.",flat_name:"dll.pe.go_imports_names_var_entropy",format:"number",level:"extended",name:"go_imports_names_var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the list of Go imports.",type:"long"},"dll.pe.go_stripped":{dashed_name:"dll-pe-go-stripped",description:"Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.",flat_name:"dll.pe.go_stripped",level:"extended",name:"go_stripped",normalize:[],original_fieldset:"pe",short:"Whether the file is a stripped or obfuscated Go executable.",type:"boolean"},"dll.pe.imphash":{dashed_name:"dll-pe-imphash",description:"A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nLearn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html.",example:"0c6803c4e922103c4dca5963aad36ddf",flat_name:"dll.pe.imphash",ignore_above:1024,level:"extended",name:"imphash",normalize:[],original_fieldset:"pe",short:"A hash of the imports in a PE file.",type:"keyword"},"dll.pe.import_hash":{dashed_name:"dll-pe-import-hash",description:"A hash of the imports in a PE file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is a synonym for imphash.",example:"d41d8cd98f00b204e9800998ecf8427e",flat_name:"dll.pe.import_hash",ignore_above:1024,level:"extended",name:"import_hash",normalize:[],original_fieldset:"pe",short:"A hash of the imports in a PE file.",type:"keyword"},"dll.pe.imports":{dashed_name:"dll-pe-imports",description:"List of imported element names and types.",flat_name:"dll.pe.imports",level:"extended",name:"imports",normalize:["array"],original_fieldset:"pe",short:"List of imported element names and types.",type:"flattened"},"dll.pe.imports_names_entropy":{dashed_name:"dll-pe-imports-names-entropy",description:"Shannon entropy calculation from the list of imported element names and types.",flat_name:"dll.pe.imports_names_entropy",format:"number",level:"extended",name:"imports_names_entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the list of imported element names and types.",type:"long"},"dll.pe.imports_names_var_entropy":{dashed_name:"dll-pe-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of imported element names and types.",flat_name:"dll.pe.imports_names_var_entropy",format:"number",level:"extended",name:"imports_names_var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the list of imported element names and types.",type:"long"},"dll.pe.original_file_name":{dashed_name:"dll-pe-original-file-name",description:"Internal name of the file, provided at compile-time.",example:"MSPAINT.EXE",flat_name:"dll.pe.original_file_name",ignore_above:1024,level:"extended",name:"original_file_name",normalize:[],original_fieldset:"pe",short:"Internal name of the file, provided at compile-time.",type:"keyword"},"dll.pe.pehash":{dashed_name:"dll-pe-pehash",description:"A hash of the PE header and data from one or more PE sections. An pehash can be used to cluster files by transforming structural information about a file into a hash value.\nLearn more at https://www.usenix.org/legacy/events/leet09/tech/full_papers/wicherski/wicherski_html/index.html.",example:"73ff189b63cd6be375a7ff25179a38d347651975",flat_name:"dll.pe.pehash",ignore_above:1024,level:"extended",name:"pehash",normalize:[],original_fieldset:"pe",short:"A hash of the PE header and data from one or more PE sections.",type:"keyword"},"dll.pe.product":{dashed_name:"dll-pe-product",description:"Internal product name of the file, provided at compile-time.",example:"Microsoft® Windows® Operating System",flat_name:"dll.pe.product",ignore_above:1024,level:"extended",name:"product",normalize:[],original_fieldset:"pe",short:"Internal product name of the file, provided at compile-time.",type:"keyword"},"dll.pe.sections":{dashed_name:"dll-pe-sections",description:"An array containing an object for each section of the PE file.\nThe keys that should be present in these objects are defined by sub-fields underneath `pe.sections.*`.",flat_name:"dll.pe.sections",level:"extended",name:"sections",normalize:["array"],original_fieldset:"pe",short:"Section information of the PE file.",type:"nested"},"dll.pe.sections.entropy":{dashed_name:"dll-pe-sections-entropy",description:"Shannon entropy calculation from the section.",flat_name:"dll.pe.sections.entropy",format:"number",level:"extended",name:"sections.entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the section.",type:"long"},"dll.pe.sections.name":{dashed_name:"dll-pe-sections-name",description:"PE Section List name.",flat_name:"dll.pe.sections.name",ignore_above:1024,level:"extended",name:"sections.name",normalize:[],original_fieldset:"pe",short:"PE Section List name.",type:"keyword"},"dll.pe.sections.physical_size":{dashed_name:"dll-pe-sections-physical-size",description:"PE Section List physical size.",flat_name:"dll.pe.sections.physical_size",format:"bytes",level:"extended",name:"sections.physical_size",normalize:[],original_fieldset:"pe",short:"PE Section List physical size.",type:"long"},"dll.pe.sections.var_entropy":{dashed_name:"dll-pe-sections-var-entropy",description:"Variance for Shannon entropy calculation from the section.",flat_name:"dll.pe.sections.var_entropy",format:"number",level:"extended",name:"sections.var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the section.",type:"long"},"dll.pe.sections.virtual_size":{dashed_name:"dll-pe-sections-virtual-size",description:"PE Section List virtual size. This is always the same as `physical_size`.",flat_name:"dll.pe.sections.virtual_size",format:"string",level:"extended",name:"sections.virtual_size",normalize:[],original_fieldset:"pe",short:"PE Section List virtual size. This is always the same as `physical_size`.",type:"long"},"dns.answers":{dashed_name:"dns-answers",description:"An array containing an object for each answer section returned by the server.\nThe main keys that should be present in these objects are defined by ECS. Records that have more information may contain more keys than what ECS defines.\nNot all DNS data sources give all details about DNS answers. At minimum, answer objects must contain the `data` key. If more information is available, map as much of it to ECS as possible, and add any additional fields to the answer objects as custom fields.",flat_name:"dns.answers",level:"extended",name:"answers",normalize:["array"],short:"Array of DNS answers.",type:"object"},"dns.answers.class":{dashed_name:"dns-answers-class",description:"The class of DNS data contained in this resource record.",example:"IN",flat_name:"dns.answers.class",ignore_above:1024,level:"extended",name:"answers.class",normalize:[],short:"The class of DNS data contained in this resource record.",type:"keyword"},"dns.answers.data":{dashed_name:"dns-answers-data",description:"The data describing the resource.\nThe meaning of this data depends on the type and class of the resource record.",example:"10.10.10.10",flat_name:"dns.answers.data",ignore_above:1024,level:"extended",name:"answers.data",normalize:[],short:"The data describing the resource.",type:"keyword"},"dns.answers.name":{dashed_name:"dns-answers-name",description:"The domain name to which this resource record pertains.\nIf a chain of CNAME is being resolved, each answer's `name` should be the one that corresponds with the answer's `data`. It should not simply be the original `question.name` repeated.",example:"www.example.com",flat_name:"dns.answers.name",ignore_above:1024,level:"extended",name:"answers.name",normalize:[],short:"The domain name to which this resource record pertains.",type:"keyword"},"dns.answers.ttl":{dashed_name:"dns-answers-ttl",description:"The time interval in seconds that this resource record may be cached before it should be discarded. Zero values mean that the data should not be cached.",example:180,flat_name:"dns.answers.ttl",level:"extended",name:"answers.ttl",normalize:[],short:"The time interval in seconds that this resource record may be cached before it should be discarded.",type:"long"},"dns.answers.type":{dashed_name:"dns-answers-type",description:"The type of data contained in this resource record.",example:"CNAME",flat_name:"dns.answers.type",ignore_above:1024,level:"extended",name:"answers.type",normalize:[],short:"The type of data contained in this resource record.",type:"keyword"},"dns.header_flags":{dashed_name:"dns-header-flags",description:"Array of 2 letter DNS header flags.",example:'["RD", "RA"]',expected_values:["AA","TC","RD","RA","AD","CD","DO"],flat_name:"dns.header_flags",ignore_above:1024,level:"extended",name:"header_flags",normalize:["array"],short:"Array of DNS header flags.",synthetic_source_keep:"none",type:"keyword"},"dns.id":{dashed_name:"dns-id",description:"The DNS packet identifier assigned by the program that generated the query. The identifier is copied to the response.",example:62111,flat_name:"dns.id",ignore_above:1024,level:"extended",name:"id",normalize:[],short:"The DNS packet identifier assigned by the program that generated the query. The identifier is copied to the response.",type:"keyword"},"dns.op_code":{dashed_name:"dns-op-code",description:"The DNS operation code that specifies the kind of query in the message. This value is set by the originator of a query and copied into the response.",example:"QUERY",flat_name:"dns.op_code",ignore_above:1024,level:"extended",name:"op_code",normalize:[],short:"The DNS operation code that specifies the kind of query in the message.",type:"keyword"},"dns.question.class":{dashed_name:"dns-question-class",description:"The class of records being queried.",example:"IN",flat_name:"dns.question.class",ignore_above:1024,level:"extended",name:"question.class",normalize:[],short:"The class of records being queried.",type:"keyword"},"dns.question.name":{dashed_name:"dns-question-name",description:"The name being queried.\nIf the name field contains non-printable characters (below 32 or above 126), those characters should be represented as escaped base 10 integers (\\DDD). Back slashes and quotes should be escaped. Tabs, carriage returns, and line feeds should be converted to \\t, \\r, and \\n respectively.",example:"www.example.com",flat_name:"dns.question.name",ignore_above:1024,level:"extended",name:"question.name",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"The name being queried.",type:"keyword"},"dns.question.registered_domain":{dashed_name:"dns-question-registered-domain",description:'The highest registered domain, stripped of the subdomain.\nFor example, the registered domain for "foo.example.com" is "example.com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".',example:"example.com",flat_name:"dns.question.registered_domain",ignore_above:1024,level:"extended",name:"question.registered_domain",normalize:[],short:"The highest registered domain, stripped of the subdomain.",type:"keyword"},"dns.question.subdomain":{dashed_name:"dns-question-subdomain",description:'The subdomain is all of the labels under the registered_domain.\nIf the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.',example:"www",flat_name:"dns.question.subdomain",ignore_above:1024,level:"extended",name:"question.subdomain",normalize:[],short:"The subdomain of the domain.",type:"keyword"},"dns.question.top_level_domain":{dashed_name:"dns-question-top-level-domain",description:'The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".',example:"co.uk",flat_name:"dns.question.top_level_domain",ignore_above:1024,level:"extended",name:"question.top_level_domain",normalize:[],short:"The effective top level domain (com, org, net, co.uk).",type:"keyword"},"dns.question.type":{dashed_name:"dns-question-type",description:"The type of record being queried.",example:"AAAA",flat_name:"dns.question.type",ignore_above:1024,level:"extended",name:"question.type",normalize:[],short:"The type of record being queried.",type:"keyword"},"dns.resolved_ip":{dashed_name:"dns-resolved-ip",description:"Array containing all IPs seen in `answers.data`.\nThe `answers` array can be difficult to use, because of the variety of data formats it can contain. Extracting all IP addresses seen in there to `dns.resolved_ip` makes it possible to index them as IP addresses, and makes them easier to visualize and query for.",example:'["10.10.10.10", "10.10.10.11"]',flat_name:"dns.resolved_ip",level:"extended",name:"resolved_ip",normalize:["array"],short:"Array containing all IPs seen in answers.data",type:"ip"},"dns.response_code":{dashed_name:"dns-response-code",description:"The DNS response code.",example:"NOERROR",flat_name:"dns.response_code",ignore_above:1024,level:"extended",name:"response_code",normalize:[],short:"The DNS response code.",type:"keyword"},"dns.type":{dashed_name:"dns-type",description:"The type of DNS event captured, query or answer.\nIf your source of DNS events only gives you DNS queries, you should only create dns events of type `dns.type:query`.\nIf your source of DNS events gives you answers as well, you should create one event per query (optionally as soon as the query is seen). And a second event containing all query details as well as an array of answers.",example:"answer",flat_name:"dns.type",ignore_above:1024,level:"extended",name:"type",normalize:[],short:"The type of DNS event captured, query or answer.",type:"keyword"},"ecs.version":{dashed_name:"ecs-version",description:"ECS version this event conforms to. `ecs.version` is a required field and must exist in all events.\nWhen querying across multiple indices -- which may conform to slightly different ECS versions -- this field lets integrations adjust to the schema version of the events.",example:"1.0.0",flat_name:"ecs.version",ignore_above:1024,level:"core",name:"version",normalize:[],otel:[{relation:"na"}],required:!0,short:"ECS version this event conforms to.",type:"keyword"},"email.attachments":{dashed_name:"email-attachments",description:"A list of objects describing the attachment files sent along with an email message.",flat_name:"email.attachments",level:"extended",name:"attachments",normalize:["array"],short:"List of objects describing the attachments.",type:"nested"},"email.attachments.file.extension":{dashed_name:"email-attachments-file-extension",description:"Attachment file extension, excluding the leading dot.",example:"txt",flat_name:"email.attachments.file.extension",ignore_above:1024,level:"extended",name:"attachments.file.extension",normalize:[],short:"Attachment file extension.",type:"keyword"},"email.attachments.file.hash.cdhash":{beta:"This field is beta and subject to change.",dashed_name:"email-attachments-file-hash-cdhash",description:"Code directory hash, utilized to uniquely identify and authenticate the integrity of the executable code.",example:"3783b4052fd474dbe30676b45c329e7a6d44acd9",flat_name:"email.attachments.file.hash.cdhash",ignore_above:1024,level:"extended",name:"cdhash",normalize:[],original_fieldset:"hash",short:"The Code Directory (CD) hash of an executable.",type:"keyword"},"email.attachments.file.hash.md5":{dashed_name:"email-attachments-file-hash-md5",description:"MD5 hash.",flat_name:"email.attachments.file.hash.md5",ignore_above:1024,level:"extended",name:"md5",normalize:[],original_fieldset:"hash",short:"MD5 hash.",type:"keyword"},"email.attachments.file.hash.sha1":{dashed_name:"email-attachments-file-hash-sha1",description:"SHA1 hash.",flat_name:"email.attachments.file.hash.sha1",ignore_above:1024,level:"extended",name:"sha1",normalize:[],original_fieldset:"hash",short:"SHA1 hash.",type:"keyword"},"email.attachments.file.hash.sha256":{dashed_name:"email-attachments-file-hash-sha256",description:"SHA256 hash.",flat_name:"email.attachments.file.hash.sha256",ignore_above:1024,level:"extended",name:"sha256",normalize:[],original_fieldset:"hash",short:"SHA256 hash.",type:"keyword"},"email.attachments.file.hash.sha384":{dashed_name:"email-attachments-file-hash-sha384",description:"SHA384 hash.",flat_name:"email.attachments.file.hash.sha384",ignore_above:1024,level:"extended",name:"sha384",normalize:[],original_fieldset:"hash",short:"SHA384 hash.",type:"keyword"},"email.attachments.file.hash.sha512":{dashed_name:"email-attachments-file-hash-sha512",description:"SHA512 hash.",flat_name:"email.attachments.file.hash.sha512",ignore_above:1024,level:"extended",name:"sha512",normalize:[],original_fieldset:"hash",short:"SHA512 hash.",type:"keyword"},"email.attachments.file.hash.ssdeep":{dashed_name:"email-attachments-file-hash-ssdeep",description:"SSDEEP hash.",flat_name:"email.attachments.file.hash.ssdeep",ignore_above:1024,level:"extended",name:"ssdeep",normalize:[],original_fieldset:"hash",short:"SSDEEP hash.",type:"keyword"},"email.attachments.file.hash.tlsh":{dashed_name:"email-attachments-file-hash-tlsh",description:"TLSH hash.",flat_name:"email.attachments.file.hash.tlsh",ignore_above:1024,level:"extended",name:"tlsh",normalize:[],original_fieldset:"hash",short:"TLSH hash.",type:"keyword"},"email.attachments.file.mime_type":{dashed_name:"email-attachments-file-mime-type",description:"The MIME media type of the attachment.\nThis value will typically be extracted from the `Content-Type` MIME header field.",example:"text/plain",flat_name:"email.attachments.file.mime_type",ignore_above:1024,level:"extended",name:"attachments.file.mime_type",normalize:[],short:"MIME type of the attachment file.",type:"keyword"},"email.attachments.file.name":{dashed_name:"email-attachments-file-name",description:"Name of the attachment file including the file extension.",example:"attachment.txt",flat_name:"email.attachments.file.name",ignore_above:1024,level:"extended",name:"attachments.file.name",normalize:[],short:"Name of the attachment file.",type:"keyword"},"email.attachments.file.size":{dashed_name:"email-attachments-file-size",description:"Attachment file size in bytes.",example:64329,flat_name:"email.attachments.file.size",level:"extended",name:"attachments.file.size",normalize:[],short:"Attachment file size.",type:"long"},"email.bcc.address":{dashed_name:"email-bcc-address",description:"The email address of BCC recipient",example:"bcc.user1@example.com",flat_name:"email.bcc.address",ignore_above:1024,level:"extended",name:"bcc.address",normalize:["array"],short:"Email address of BCC recipient",synthetic_source_keep:"none",type:"keyword"},"email.cc.address":{dashed_name:"email-cc-address",description:"The email address of CC recipient",example:"cc.user1@example.com",flat_name:"email.cc.address",ignore_above:1024,level:"extended",name:"cc.address",normalize:["array"],short:"Email address of CC recipient",synthetic_source_keep:"none",type:"keyword"},"email.content_type":{dashed_name:"email-content-type",description:"Information about how the message is to be displayed.\nTypically a MIME type.",example:"text/plain",flat_name:"email.content_type",ignore_above:1024,level:"extended",name:"content_type",normalize:[],short:"MIME type of the email message.",type:"keyword"},"email.delivery_timestamp":{dashed_name:"email-delivery-timestamp",description:"The date and time when the email message was received by the service or client.",example:"2020-11-10T22:12:34.8196921Z",flat_name:"email.delivery_timestamp",level:"extended",name:"delivery_timestamp",normalize:[],short:"Date and time when message was delivered.",type:"date"},"email.direction":{dashed_name:"email-direction",description:"The direction of the message based on the sending and receiving domains.",example:"inbound",flat_name:"email.direction",ignore_above:1024,level:"extended",name:"direction",normalize:[],short:"Direction of the message.",type:"keyword"},"email.from.address":{dashed_name:"email-from-address",description:"The email address of the sender, typically from the RFC 5322 `From:` header field.",example:"sender@example.com",flat_name:"email.from.address",ignore_above:1024,level:"extended",name:"from.address",normalize:["array"],short:"The sender's email address.",synthetic_source_keep:"none",type:"keyword"},"email.local_id":{dashed_name:"email-local-id",description:"Unique identifier given to the email by the source that created the event.\nIdentifier is not persistent across hops.",example:"c26dbea0-80d5-463b-b93c-4e8b708219ce",flat_name:"email.local_id",ignore_above:1024,level:"extended",name:"local_id",normalize:[],short:"Unique identifier given by the source.",type:"keyword"},"email.message_id":{dashed_name:"email-message-id",description:"Identifier from the RFC 5322 `Message-ID:` email header that refers to a particular email message.",example:"81ce15$8r2j59@mail01.example.com",flat_name:"email.message_id",level:"extended",name:"message_id",normalize:[],short:"Value from the Message-ID header.",type:"wildcard"},"email.origination_timestamp":{dashed_name:"email-origination-timestamp",description:"The date and time the email message was composed. Many email clients will fill in this value automatically when the message is sent by a user.",example:"2020-11-10T22:12:34.8196921Z",flat_name:"email.origination_timestamp",level:"extended",name:"origination_timestamp",normalize:[],short:"Date and time the email was composed.",type:"date"},"email.reply_to.address":{dashed_name:"email-reply-to-address",description:"The address that replies should be delivered to based on the value in the RFC 5322 `Reply-To:` header.",example:"reply.here@example.com",flat_name:"email.reply_to.address",ignore_above:1024,level:"extended",name:"reply_to.address",normalize:["array"],short:"Address replies should be delivered to.",synthetic_source_keep:"none",type:"keyword"},"email.sender.address":{dashed_name:"email-sender-address",description:"Per RFC 5322, specifies the address responsible for the actual transmission of the message.",flat_name:"email.sender.address",ignore_above:1024,level:"extended",name:"sender.address",normalize:[],short:"Address of the message sender.",synthetic_source_keep:"none",type:"keyword"},"email.subject":{dashed_name:"email-subject",description:"A brief summary of the topic of the message.",example:"Please see this important message.",flat_name:"email.subject",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"email.subject.text",name:"text",type:"match_only_text"}],name:"subject",normalize:[],short:"The subject of the email message.",type:"keyword"},"email.to.address":{dashed_name:"email-to-address",description:"The email address of recipient",example:"user1@example.com",flat_name:"email.to.address",ignore_above:1024,level:"extended",name:"to.address",normalize:["array"],short:"Email address of recipient",synthetic_source_keep:"none",type:"keyword"},"email.x_mailer":{dashed_name:"email-x-mailer",description:"The name of the application that was used to draft and send the original email message.",example:"Spambot v2.5",flat_name:"email.x_mailer",ignore_above:1024,level:"extended",name:"x_mailer",normalize:[],short:"Application that drafted email.",type:"keyword"},"error.code":{dashed_name:"error-code",description:"Error code describing the error.",flat_name:"error.code",ignore_above:1024,level:"core",name:"code",normalize:[],short:"Error code describing the error.",type:"keyword"},"error.id":{dashed_name:"error-id",description:"Unique identifier for the error.",flat_name:"error.id",ignore_above:1024,level:"core",name:"id",normalize:[],short:"Unique identifier for the error.",type:"keyword"},"error.message":{dashed_name:"error-message",description:"Error message.",flat_name:"error.message",level:"core",name:"message",normalize:[],otel:[{attribute:"exception.message",relation:"equivalent",stability:"stable"}],short:"Error message.",type:"match_only_text"},"error.stack_trace":{dashed_name:"error-stack-trace",description:"The stack trace of this error in plain text.",flat_name:"error.stack_trace",level:"extended",multi_fields:[{flat_name:"error.stack_trace.text",name:"text",type:"match_only_text"}],name:"stack_trace",normalize:[],otel:[{attribute:"exception.stacktrace",relation:"equivalent",stability:"stable"}],short:"The stack trace of this error in plain text.",type:"wildcard"},"error.type":{dashed_name:"error-type",description:"The type of the error, for example the class name of the exception.",example:"java.lang.NullPointerException",flat_name:"error.type",ignore_above:1024,level:"extended",name:"type",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"The type of the error, for example the class name of the exception.",type:"keyword"},"event.action":{dashed_name:"event-action",description:"The action captured by the event.\nThis describes the information in the event. It is more specific than `event.category`. Examples are `group-add`, `process-started`, `file-created`. The value is normally defined by the implementer.",example:"user-password-change",flat_name:"event.action",ignore_above:1024,level:"core",name:"action",normalize:[],short:"The action captured by the event.",type:"keyword"},"event.agent_id_status":{dashed_name:"event-agent-id-status",description:"Agents are normally responsible for populating the `agent.id` field value. If the system receiving events is capable of validating the value based on authentication information for the client then this field can be used to reflect the outcome of that validation.\nFor example if the agent's connection is authenticated with mTLS and the client cert contains the ID of the agent to which the cert was issued then the `agent.id` value in events can be checked against the certificate. If the values match then `event.agent_id_status: verified` is added to the event, otherwise one of the other allowed values should be used.\nIf no validation is performed then the field should be omitted.\nThe allowed values are:\n`verified` - The `agent.id` field value matches expected value obtained from auth metadata.\n`mismatch` - The `agent.id` field value does not match the expected value obtained from auth metadata.\n`missing` - There was no `agent.id` field in the event to validate.\n`auth_metadata_missing` - There was no auth metadata or it was missing information about the agent ID.",example:"verified",flat_name:"event.agent_id_status",ignore_above:1024,level:"extended",name:"agent_id_status",normalize:[],short:"Validation status of the event's agent.id field.",type:"keyword"},"event.category":{allowed_values:[{description:"Events in this category annotate API calls that occured on a system. Typical sources for those events could be from the Operating System level through the native libraries (for example Windows Win32, Linux libc, etc.), or managed sources of events (such as ETW, syslog), but can also include network protocols (such as SOAP, RPC, Websocket, REST, etc.)",expected_event_types:["access","admin","allowed","change","creation","deletion","denied","end","info","start","user"],name:"api"},{description:"Events in this category are related to the challenge and response process in which credentials are supplied and verified to allow the creation of a session. Common sources for these logs are Windows event logs and ssh logs. Visualize and analyze events in this category to look for failed logins, and other authentication-related activity.",expected_event_types:["start","end","info"],name:"authentication"},{description:"Events in the configuration category have to deal with creating, modifying, or deleting the settings or parameters of an application, process, or system.\nExample sources include security policy change logs, configuration auditing logging, and system integrity monitoring.",expected_event_types:["access","change","creation","deletion","info"],name:"configuration"},{description:"The database category denotes events and metrics relating to a data storage and retrieval system. Note that use of this category is not limited to relational database systems. Examples include event logs from MS SQL, MySQL, Elasticsearch, MongoDB, etc. Use this category to visualize and analyze database activity such as accesses and changes.",expected_event_types:["access","change","info","error"],name:"database"},{description:"Events in the driver category have to do with operating system device drivers and similar software entities such as Windows drivers, kernel extensions, kernel modules, etc.\nUse events and metrics in this category to visualize and analyze driver-related activity and status on hosts.",expected_event_types:["change","end","info","start"],name:"driver"},{description:"This category is used for events relating to email messages, email attachments, and email network or protocol activity.\nEmails events can be produced by email security gateways, mail transfer agents, email cloud service providers, or mail server monitoring applications.",expected_event_types:["info"],name:"email"},{description:"Relating to a set of information that has been created on, or has existed on a filesystem. Use this category of events to visualize and analyze the creation, access, and deletions of files. Events in this category can come from both host-based and network-based sources. An example source of a network-based detection of a file transfer would be the Zeek file.log.",expected_event_types:["access","change","creation","deletion","info"],name:"file"},{description:'Use this category to visualize and analyze information such as host inventory or host lifecycle events.\nMost of the events in this category can usually be observed from the outside, such as from a hypervisor or a control plane\'s point of view. Some can also be seen from within, such as "start" or "end".\nNote that this category is for information about hosts themselves; it is not meant to capture activity "happening on a host".',expected_event_types:["access","change","end","info","start"],name:"host"},{description:"Identity and access management (IAM) events relating to users, groups, and administration. Use this category to visualize and analyze IAM-related logs and data from active directory, LDAP, Okta, Duo, and other IAM systems.",expected_event_types:["admin","change","creation","deletion","group","info","user"],name:"iam"},{description:"Relating to intrusion detections from IDS/IPS systems and functions, both network and host-based. Use this category to visualize and analyze intrusion detection alerts from systems such as Snort, Suricata, and Palo Alto threat detections.",expected_event_types:["allowed","denied","info"],name:"intrusion_detection"},{description:'Events in this category refer to the loading of a library, such as (dll / so / dynlib), into a process. Use this category to visualize and analyze library loading related activity on hosts.  Keep in mind that driver related activity will be captured under the "driver" category above.',expected_event_types:["start"],name:"library"},{description:"Malware detection events and alerts. Use this category to visualize and analyze malware detections from EDR/EPP systems such as Elastic Endpoint Security, Symantec Endpoint Protection, Crowdstrike, and network IDS/IPS systems such as Suricata, or other sources of malware-related events such as Palo Alto Networks threat logs and Wildfire logs.",expected_event_types:["info"],name:"malware"},{description:"Relating to all network activity, including network connection lifecycle, network traffic, and essentially any event that includes an IP address. Many events containing decoded network protocol transactions fit into this category. Use events in this category to visualize or analyze counts of network ports, protocols, addresses, geolocation information, etc.",expected_event_types:["access","allowed","connection","denied","end","info","protocol","start"],name:"network"},{description:"Relating to software packages installed on hosts. Use this category to visualize and analyze inventory of software installed on various hosts, or to determine host vulnerability in the absence of vulnerability scan data.",expected_event_types:["access","change","deletion","info","installation","start"],name:"package"},{description:"Use this category of events to visualize and analyze process-specific information such as lifecycle events or process ancestry.",expected_event_types:["access","change","end","info","start"],name:"process"},{description:"Having to do with settings and assets stored in the Windows registry. Use this category to visualize and analyze activity such as registry access and modifications.",expected_event_types:["access","change","creation","deletion"],name:"registry"},{description:"The session category is applied to events and metrics regarding logical persistent connections to hosts and services. Use this category to visualize and analyze interactive or automated persistent connections between assets. Data for this category may come from Windows Event logs, SSH logs, or stateless sessions such as HTTP cookie-based sessions, etc.",expected_event_types:["start","end","info"],name:"session"},{description:"Use this category to visualize and analyze events describing threat actors' targets, motives, or behaviors.",expected_event_types:["indicator"],name:"threat"},{description:"Relating to vulnerability scan results. Use this category to analyze vulnerabilities detected by Tenable, Qualys, internal scanners, and other vulnerability management sources.",expected_event_types:["info"],name:"vulnerability"},{description:"Relating to web server access. Use this category to create a dashboard of web server/proxy activity from apache, IIS, nginx web servers, etc. Note: events from network observers such as Zeek http log may also be included in this category.",expected_event_types:["access","error","info"],name:"web"}],dashed_name:"event-category",description:'This is one of four ECS Categorization Fields, and indicates the second level in the ECS category hierarchy.\n`event.category` represents the "big buckets" of ECS categories. For example, filtering on `event.category:process` yields all events relating to process activity. This field is closely related to `event.type`, which is used as a subcategory.\nThis field is an array. This will allow proper categorization of some events that fall in multiple categories.',example:"authentication",flat_name:"event.category",ignore_above:1024,level:"core",name:"category",normalize:["array"],short:"Event category. The second categorization field in the hierarchy.",synthetic_source_keep:"none",type:"keyword"},"event.code":{dashed_name:"event-code",description:"Identification code for this event, if one exists.\nSome event sources use event codes to identify messages unambiguously, regardless of message language or wording adjustments over time. An example of this is the Windows Event ID.",example:4648,flat_name:"event.code",ignore_above:1024,level:"extended",name:"code",normalize:[],short:"Identification code for this event.",type:"keyword"},"event.created":{dashed_name:"event-created",description:"`event.created` contains the date/time when the event was first read by an agent, or by your pipeline.\nThis field is distinct from `@timestamp` in that `@timestamp` typically contain the time extracted from the original event.\nIn most situations, these two timestamps will be slightly different. The difference can be used to calculate the delay between your source generating an event, and the time when your agent first processed it. This can be used to monitor your agent's or pipeline's ability to keep up with your event source.\nIn case the two timestamps are identical, `@timestamp` should be used.",example:"2016-05-23T08:05:34.857Z",flat_name:"event.created",level:"core",name:"created",normalize:[],short:"Time when the event was first read by an agent or by your pipeline.",type:"date"},"event.dataset":{dashed_name:"event-dataset",description:"Name of the dataset.\nIf an event source publishes more than one type of log or events (e.g. access log, error log), the dataset is used to specify which one the event comes from.\nIt's recommended but not required to start the dataset name with the module name, followed by a dot, then the dataset name.",example:"apache.access",flat_name:"event.dataset",ignore_above:1024,level:"core",name:"dataset",normalize:[],short:"Name of the dataset.",type:"keyword"},"event.duration":{dashed_name:"event-duration",description:"Duration of the event in nanoseconds.\nIf `event.start` and `event.end` are known this value should be the difference between the end and start time.",flat_name:"event.duration",format:"duration",input_format:"nanoseconds",level:"core",name:"duration",normalize:[],output_format:"asMilliseconds",output_precision:1,short:"Duration of the event in nanoseconds.",type:"long"},"event.end":{dashed_name:"event-end",description:"`event.end` contains the date when the event ended or when the activity was last observed.",flat_name:"event.end",level:"extended",name:"end",normalize:[],short:"`event.end` contains the date when the event ended or when the activity was last observed.",type:"date"},"event.hash":{dashed_name:"event-hash",description:"Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity.",example:"123456789012345678901234567890ABCD",flat_name:"event.hash",ignore_above:1024,level:"extended",name:"hash",normalize:[],short:"Hash (perhaps logstash fingerprint) of raw field to be able to demonstrate log integrity.",type:"keyword"},"event.id":{dashed_name:"event-id",description:"Unique ID to describe the event.",example:"8a4f500d",flat_name:"event.id",ignore_above:1024,level:"core",name:"id",normalize:[],short:"Unique ID to describe the event.",type:"keyword"},"event.ingested":{dashed_name:"event-ingested",description:"Timestamp when an event arrived in the central data store.\nThis is different from `@timestamp`, which is when the event originally occurred.  It's also different from `event.created`, which is meant to capture the first time an agent saw the event.\nIn normal conditions, assuming no tampering, the timestamps should chronologically look like this: `@timestamp` < `event.created` < `event.ingested`.",example:"2016-05-23T08:05:35.101Z",flat_name:"event.ingested",level:"core",name:"ingested",normalize:[],short:"Timestamp when an event arrived in the central data store.",type:"date"},"event.kind":{allowed_values:[{description:"This value indicates an event such as an alert or notable event, triggered by a detection rule executing externally to the Elastic Stack.\n`event.kind:alert` is often populated for events coming from firewalls, intrusion detection systems, endpoint detection and response systems, and so on.\nThis value is not used by Elastic solutions for alert documents that are created by rules executing within the Kibana alerting framework.",name:"alert"},{description:"This value indicates events whose primary purpose is to store an inventory of assets/entities and their attributes. Assets/entities are objects (such as users and hosts) that are expected to be subjects of detailed analysis within the system.\nExamples include lists of user identities or accounts ingested from directory services such as Active Directory (AD), inventory of hosts pulled from configuration management databases (CMDB), and lists of cloud storage buckets pulled from cloud provider APIs.\nThis value is used by Elastic Security for asset management solutions. `event.kind: asset` is not used for normal system events or logs that are coming from an asset/entity, nor is it used for system events or logs coming from a directory or CMDB system.",name:"asset"},{description:"The `enrichment` value indicates an event collected to provide additional context, often to other events.\nAn example is collecting indicators of compromise (IOCs) from a threat intelligence provider with the intent to use those values to enrich other events. The IOC events from the intelligence provider should be categorized as `event.kind:enrichment`.",name:"enrichment"},{description:"This value is the most general and most common value for this field. It is used to represent events that indicate that something happened.",name:"event"},{description:"This value is used to indicate that this event describes a numeric measurement taken at given point in time.\nExamples include CPU utilization, memory usage, or device temperature.\nMetric events are often collected on a predictable frequency, such as once every few seconds, or once a minute, but can also be used to describe ad-hoc numeric metric queries.",name:"metric"},{description:"The state value is similar to metric, indicating that this event describes a measurement taken at given point in time, except that the measurement does not result in a numeric value, but rather one of a fixed set of categorical values that represent conditions or states.\nExamples include periodic events reporting Elasticsearch cluster state (green/yellow/red), the state of a TCP connection (open, closed, fin_wait, etc.), the state of a host with respect to a software vulnerability (vulnerable, not vulnerable), and the state of a system regarding compliance with a regulatory standard (compliant, not compliant).\nNote that an event that describes a change of state would not use `event.kind:state`, but instead would use 'event.kind:event' since a state change fits the more general event definition of something that happened.\nState events are often collected on a predictable frequency, such as once every few seconds, once a minute, once an hour, or once a day, but can also be used to describe ad-hoc state queries.",name:"state"},{description:"This value indicates that an error occurred during the ingestion of this event, and that event data may be missing, inconsistent, or incorrect. `event.kind:pipeline_error` is often associated with parsing errors.",name:"pipeline_error"},{description:'This value is used by Elastic solutions (e.g., Security, Observability) for alert documents that are created by rules executing within the Kibana alerting framework.\nUsage of this value is reserved, and data ingestion pipelines must not populate `event.kind` with the value "signal".',name:"signal"}],dashed_name:"event-kind",description:"This is one of four ECS Categorization Fields, and indicates the highest level in the ECS category hierarchy.\n`event.kind` gives high-level information about what type of information the event contains, without being specific to the contents of the event. For example, values of this field distinguish alert events from metric events.\nThe value of this field can be used to inform how these kinds of events should be handled. They may warrant different retention, different access control, it may also help understand whether the data is coming in at a regular interval or not.",example:"alert",flat_name:"event.kind",ignore_above:1024,level:"core",name:"kind",normalize:[],short:"The kind of the event. The highest categorization field in the hierarchy.",type:"keyword"},"event.module":{dashed_name:"event-module",description:"Name of the module this data is coming from.\nIf your monitoring agent supports the concept of modules or plugins to process events of a given source (e.g. Apache logs), `event.module` should contain the name of this module.",example:"apache",flat_name:"event.module",ignore_above:1024,level:"core",name:"module",normalize:[],short:"Name of the module this data is coming from.",type:"keyword"},"event.original":{dashed_name:"event-original",description:"Raw text message of entire event. Used to demonstrate log integrity or where the full log message (before splitting it up in multiple parts) may be required, e.g. for reindex.\nThis field is not indexed and doc_values are disabled. It cannot be searched, but it can be retrieved from `_source`. If users wish to override this and index this field, please see `Field data types` in the `Elasticsearch Reference`.",doc_values:!1,example:"Sep 19 08:26:10 host CEF:0&#124;Security&#124; threatmanager&#124;1.0&#124;100&#124; worm successfully stopped&#124;10&#124;src=10.0.0.1 dst=2.1.2.2spt=1232",flat_name:"event.original",index:!1,level:"core",name:"original",normalize:[],short:"Raw text message of entire event.",type:"keyword"},"event.outcome":{allowed_values:[{description:"Indicates that this event describes a failed result. A common example is `event.category:file AND event.type:access AND event.outcome:failure` to indicate that a file access was attempted, but was not successful.",name:"failure"},{description:"Indicates that this event describes a successful result. A common example is `event.category:file AND event.type:create AND event.outcome:success` to indicate that a file was successfully created.",name:"success"},{description:"Indicates that this event describes only an attempt for which the result is unknown from the perspective of the event producer. For example, if the event contains information only about the request side of a transaction that results in a response, populating `event.outcome:unknown` in the request event is appropriate. The unknown value should not be used when an outcome doesn't make logical sense for the event. In such cases `event.outcome` should not be populated.",name:"unknown"}],dashed_name:"event-outcome",description:"This is one of four ECS Categorization Fields, and indicates the lowest level in the ECS category hierarchy.\n`event.outcome` simply denotes whether the event represents a success or a failure from the perspective of the entity that produced the event.\nNote that when a single transaction is described in multiple events, each event may populate different values of `event.outcome`, according to their perspective.\nAlso note that in the case of a compound event (a single event that contains multiple logical events), this field should be populated with the value that best captures the overall success or failure from the perspective of the event producer.\nFurther note that not all events will have an associated outcome. For example, this field is generally not populated for metric events, events with `event.type:info`, or any events for which an outcome does not make logical sense.",example:"success",flat_name:"event.outcome",ignore_above:1024,level:"core",name:"outcome",normalize:[],short:"The outcome of the event. The lowest level categorization field in the hierarchy.",type:"keyword"},"event.provider":{dashed_name:"event-provider",description:"Source of the event.\nEvent transports such as Syslog or the Windows Event Log typically mention the source of an event. It can be the name of the software that generated the event (e.g. Sysmon, httpd), or of a subsystem of the operating system (kernel, Microsoft-Windows-Security-Auditing).",example:"kernel",flat_name:"event.provider",ignore_above:1024,level:"extended",name:"provider",normalize:[],short:"Source of the event.",type:"keyword"},"event.reason":{dashed_name:"event-reason",description:"Reason why this event happened, according to the source.\nThis describes the why of a particular action or outcome captured in the event. Where `event.action` captures the action from the event, `event.reason` describes why that action was taken. For example, a web proxy with an `event.action` which denied the request may also populate `event.reason` with the reason why (e.g. `blocked site`).",example:"Terminated an unexpected process",flat_name:"event.reason",ignore_above:1024,level:"extended",name:"reason",normalize:[],short:"Reason why this event happened, according to the source",type:"keyword"},"event.reference":{dashed_name:"event-reference",description:"Reference URL linking to additional information about this event.\nThis URL links to a static definition of this event. Alert events, indicated by `event.kind:alert`, are a common use case for this field.",example:"https://system.example.com/event/#0001234",flat_name:"event.reference",ignore_above:1024,level:"extended",name:"reference",normalize:[],short:"Event reference URL",type:"keyword"},"event.risk_score":{dashed_name:"event-risk-score",description:"Risk score or priority of the event (e.g. security solutions). Use your system's original value here.",flat_name:"event.risk_score",level:"core",name:"risk_score",normalize:[],short:"Risk score or priority of the event (e.g. security solutions). Use your system's original value here.",type:"float"},"event.risk_score_norm":{dashed_name:"event-risk-score-norm",description:"Normalized risk score or priority of the event, on a scale of 0 to 100.\nThis is mainly useful if you use more than one system that assigns risk scores, and you want to see a normalized value across all systems.",flat_name:"event.risk_score_norm",level:"extended",name:"risk_score_norm",normalize:[],short:"Normalized risk score or priority of the event (0-100).",type:"float"},"event.sequence":{dashed_name:"event-sequence",description:"Sequence number of the event.\nThe sequence number is a value published by some event sources, to make the exact ordering of events unambiguous, regardless of the timestamp precision.",flat_name:"event.sequence",format:"string",level:"extended",name:"sequence",normalize:[],short:"Sequence number of the event.",type:"long"},"event.severity":{dashed_name:"event-severity",description:"The numeric severity of the event according to your event source.\nWhat the different severity values mean can be different between sources and use cases. It's up to the implementer to make sure severities are consistent across events from the same source.\nThe Syslog severity belongs in `log.syslog.severity.code`. `event.severity` is meant to represent the severity according to the event source (e.g. firewall, IDS). If the event source does not publish its own severity, you may optionally copy the `log.syslog.severity.code` to `event.severity`.",example:7,flat_name:"event.severity",format:"string",level:"core",name:"severity",normalize:[],short:"Numeric severity of the event.",type:"long"},"event.start":{dashed_name:"event-start",description:"`event.start` contains the date when the event started or when the activity was first observed.",flat_name:"event.start",level:"extended",name:"start",normalize:[],short:"`event.start` contains the date when the event started or when the activity was first observed.",type:"date"},"event.timezone":{dashed_name:"event-timezone",description:'This field should be populated when the event\'s timestamp does not include timezone information already (e.g. default Syslog timestamps). It\'s optional otherwise.\nAcceptable timezone formats are: a canonical ID (e.g. "Europe/Amsterdam"), abbreviated (e.g. "EST") or an HH:mm differential (e.g. "-05:00").',flat_name:"event.timezone",ignore_above:1024,level:"extended",name:"timezone",normalize:[],short:"Event time zone.",type:"keyword"},"event.type":{allowed_values:[{description:"The access event type is used for the subset of events within a category that indicate that something was accessed. Common examples include `event.category:database AND event.type:access`, or `event.category:file AND event.type:access`. Note for file access, both directory listings and file opens should be included in this subcategory. You can further distinguish access operations using the ECS `event.action` field.",name:"access"},{description:"The admin event type is used for the subset of events within a category that are related to admin objects. For example, administrative changes within an IAM framework that do not specifically affect a user or group (e.g., adding new applications to a federation solution or connecting discrete forests in Active Directory) would fall into this subcategory. Common example: `event.category:iam AND event.type:change AND event.type:admin`. You can further distinguish admin operations using the ECS `event.action` field.",name:"admin"},{description:'The allowed event type is used for the subset of events within a category that indicate that something was allowed. Common examples include `event.category:network AND event.type:connection AND event.type:allowed` (to indicate a network firewall event for which the firewall disposition was to allow the connection to complete) and `event.category:intrusion_detection AND event.type:allowed` (to indicate a network intrusion prevention system event for which the IPS disposition was to allow the connection to complete). You can further distinguish allowed operations using the ECS `event.action` field, populating with values of your choosing, such as "allow", "detect", or "pass".',name:"allowed"},{description:"The change event type is used for the subset of events within a category that indicate that something has changed. If semantics best describe an event as modified, then include them in this subcategory. Common examples include `event.category:process AND event.type:change`, and `event.category:file AND event.type:change`. You can further distinguish change operations using the ECS `event.action` field.",name:"change"},{description:'Used primarily with `event.category:network` this value is used for the subset of network traffic that includes sufficient information for the event to be included in flow or connection analysis. Events in this subcategory will contain at least source and destination IP addresses, source and destination TCP/UDP ports, and will usually contain counts of bytes and/or packets transferred. Events in this subcategory may contain unidirectional or bidirectional information, including summary information. Use this subcategory to visualize and analyze network connections. Flow analysis, including Netflow, IPFIX, and other flow-related events fit in this subcategory. Note that firewall events from many Next-Generation Firewall (NGFW) devices will also fit into this subcategory.  A common filter for flow/connection information would be `event.category:network AND event.type:connection AND event.type:end` (to view or analyze all completed network connections, ignoring mid-flow reports). You can further distinguish connection events using the ECS `event.action` field, populating with values of your choosing, such as "timeout", or "reset".',name:"connection"},{description:'The "creation" event type is used for the subset of events within a category that indicate that something was created. A common example is `event.category:file AND event.type:creation`.',name:"creation"},{description:"The deletion event type is used for the subset of events within a category that indicate that something was deleted. A common example is `event.category:file AND event.type:deletion` to indicate that a file has been deleted.",name:"deletion"},{description:'The denied event type is used for the subset of events within a category that indicate that something was denied. Common examples include `event.category:network AND event.type:denied` (to indicate a network firewall event for which the firewall disposition was to deny the connection) and `event.category:intrusion_detection AND event.type:denied` (to indicate a network intrusion prevention system event for which the IPS disposition was to deny the connection to complete). You can further distinguish denied operations using the ECS `event.action` field, populating with values of your choosing, such as "blocked", "dropped", or "quarantined".',name:"denied"},{description:"The end event type is used for the subset of events within a category that indicate something has ended. A common example is `event.category:process AND event.type:end`.",name:"end"},{description:"The error event type is used for the subset of events within a category that indicate or describe an error. A common example is `event.category:database AND event.type:error`. Note that pipeline errors that occur during the event ingestion process should not use this `event.type` value. Instead, they should use `event.kind:pipeline_error`.",name:"error"},{description:"The group event type is used for the subset of events within a category that are related to group objects. Common example: `event.category:iam AND event.type:creation AND event.type:group`. You can further distinguish group operations using the ECS `event.action` field.",name:"group"},{description:"The indicator event type is used for the subset of events within a category that contain details about indicators of compromise (IOCs).\nA common example is `event.category:threat AND event.type:indicator`.",name:"indicator"},{description:'The info event type is used for the subset of events within a category that indicate that they are purely informational, and don\'t report a state change, or any type of action. For example, an initial run of a file integrity monitoring system (FIM), where an agent reports all files under management, would fall into the "info" subcategory. Similarly, an event containing a dump of all currently running processes (as opposed to reporting that a process started/ended) would fall into the "info" subcategory. An additional common examples is `event.category:intrusion_detection AND event.type:info`.',name:"info"},{description:"The installation event type is used for the subset of events within a category that indicate that something was installed. A common example is `event.category:package` AND `event.type:installation`.",name:"installation"},{description:"The protocol event type is used for the subset of events within a category that indicate that they contain protocol details or analysis, beyond simply identifying the protocol. Generally, network events that contain specific protocol details will fall into this subcategory. A common example is `event.category:network AND event.type:protocol AND event.type:connection AND event.type:end` (to indicate that the event is a network connection event sent at the end of a connection that also includes a protocol detail breakdown). Note that events that only indicate the name or id of the protocol should not use the protocol value. Further note that when the protocol subcategory is used, the identified protocol is populated in the ECS `network.protocol` field.",name:"protocol"},{description:"The start event type is used for the subset of events within a category that indicate something has started. A common example is `event.category:process AND event.type:start`.",name:"start"},{description:"The user event type is used for the subset of events within a category that are related to user objects. Common example: `event.category:iam AND event.type:deletion AND event.type:user`. You can further distinguish user operations using the ECS `event.action` field.",name:"user"}],dashed_name:"event-type",description:'This is one of four ECS Categorization Fields, and indicates the third level in the ECS category hierarchy.\n`event.type` represents a categorization "sub-bucket" that, when used along with the `event.category` field values, enables filtering events down to a level appropriate for single visualization.\nThis field is an array. This will allow proper categorization of some events that fall in multiple event types.',flat_name:"event.type",ignore_above:1024,level:"core",name:"type",normalize:["array"],short:"Event type. The third categorization field in the hierarchy.",synthetic_source_keep:"none",type:"keyword"},"event.url":{dashed_name:"event-url",description:"URL linking to an external system to continue investigation of this event.\nThis URL links to another system where in-depth investigation of the specific occurrence of this event can take place. Alert events, indicated by `event.kind:alert`, are a common use case for this field.",example:"https://mysystem.example.com/alert/5271dedb-f5b0-4218-87f0-4ac4870a38fe",flat_name:"event.url",ignore_above:2083,level:"extended",name:"url",normalize:[],short:"Event investigation URL",type:"keyword"},"faas.coldstart":{dashed_name:"faas-coldstart",description:"Boolean value indicating a cold start of a function.",flat_name:"faas.coldstart",level:"extended",name:"coldstart",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Boolean value indicating a cold start of a function.",type:"boolean"},"faas.execution":{dashed_name:"faas-execution",description:"The execution ID of the current function execution.",example:"af9d5aa4-a685-4c5f-a22b-444f80b3cc28",flat_name:"faas.execution",ignore_above:1024,level:"extended",name:"execution",normalize:[],otel:[{attribute:"faas.invocation_id",relation:"equivalent",stability:"experimental"}],short:"The execution ID of the current function execution.",type:"keyword"},"faas.id":{dashed_name:"faas-id",description:"The unique identifier of a serverless function.\nFor AWS Lambda it's the function ARN (Amazon Resource Name) without a version or alias suffix.",example:"arn:aws:lambda:us-west-2:123456789012:function:my-function",flat_name:"faas.id",ignore_above:1024,level:"extended",name:"id",normalize:[],short:"The unique identifier of a serverless function.",type:"keyword"},"faas.name":{dashed_name:"faas-name",description:"The name of a serverless function.",example:"my-function",flat_name:"faas.name",ignore_above:1024,level:"extended",name:"name",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"The name of a serverless function.",type:"keyword"},"faas.trigger.request_id":{dashed_name:"faas-trigger-request-id",description:"The ID of the trigger request , message, event, etc.",example:123456789,flat_name:"faas.trigger.request_id",ignore_above:1024,level:"extended",name:"trigger.request_id",normalize:[],short:"The ID of the trigger request , message, event, etc.",type:"keyword"},"faas.trigger.type":{dashed_name:"faas-trigger-type",description:"The trigger for the function execution.",example:"http",expected_values:["http","pubsub","datasource","timer","other"],flat_name:"faas.trigger.type",ignore_above:1024,level:"extended",name:"trigger.type",normalize:[],otel:[{attribute:"faas.trigger",relation:"equivalent",stability:"experimental"}],short:"The trigger for the function execution.",type:"keyword"},"faas.version":{dashed_name:"faas-version",description:"The version of a serverless function.",example:"123",flat_name:"faas.version",ignore_above:1024,level:"extended",name:"version",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"The version of a serverless function.",type:"keyword"},"file.accessed":{dashed_name:"file-accessed",description:"Last time the file was accessed.\nNote that not all filesystems keep track of access time.",flat_name:"file.accessed",level:"extended",name:"accessed",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Last time the file was accessed.",type:"date"},"file.attributes":{dashed_name:"file-attributes",description:"Array of file attributes.\nAttributes names will vary by platform. Here's a non-exhaustive list of values that are expected in this field: archive, compressed, directory, encrypted, execute, hidden, read, readonly, system, write.",example:'["readonly", "system"]',flat_name:"file.attributes",ignore_above:1024,level:"extended",name:"attributes",normalize:["array"],otel:[{relation:"match",stability:"experimental"}],short:"Array of file attributes.",synthetic_source_keep:"none",type:"keyword"},"file.code_signature.digest_algorithm":{dashed_name:"file-code-signature-digest-algorithm",description:"The hashing algorithm used to sign the process.\nThis value can distinguish signatures when a file is signed multiple times by the same signer but with a different digest algorithm.",example:"sha256",flat_name:"file.code_signature.digest_algorithm",ignore_above:1024,level:"extended",name:"digest_algorithm",normalize:[],original_fieldset:"code_signature",short:"Hashing algorithm used to sign the process.",type:"keyword"},"file.code_signature.exists":{dashed_name:"file-code-signature-exists",description:"Boolean to capture if a signature is present.",example:"true",flat_name:"file.code_signature.exists",level:"core",name:"exists",normalize:[],original_fieldset:"code_signature",short:"Boolean to capture if a signature is present.",type:"boolean"},"file.code_signature.flags":{beta:"This field is beta and subject to change.",dashed_name:"file-code-signature-flags",description:"The flags used to sign the process.",example:570522385,flat_name:"file.code_signature.flags",ignore_above:1024,level:"extended",name:"flags",normalize:[],original_fieldset:"code_signature",short:"Code signing flags of the process",type:"keyword"},"file.code_signature.signing_id":{dashed_name:"file-code-signature-signing-id",description:"The identifier used to sign the process.\nThis is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only.",example:"com.apple.xpc.proxy",flat_name:"file.code_signature.signing_id",ignore_above:1024,level:"extended",name:"signing_id",normalize:[],original_fieldset:"code_signature",short:"The identifier used to sign the process.",type:"keyword"},"file.code_signature.status":{dashed_name:"file-code-signature-status",description:"Additional information about the certificate status.\nThis is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.",example:"ERROR_UNTRUSTED_ROOT",flat_name:"file.code_signature.status",ignore_above:1024,level:"extended",name:"status",normalize:[],original_fieldset:"code_signature",short:"Additional information about the certificate status.",type:"keyword"},"file.code_signature.subject_name":{dashed_name:"file-code-signature-subject-name",description:"Subject name of the code signer",example:"Microsoft Corporation",flat_name:"file.code_signature.subject_name",ignore_above:1024,level:"core",name:"subject_name",normalize:[],original_fieldset:"code_signature",short:"Subject name of the code signer",type:"keyword"},"file.code_signature.team_id":{dashed_name:"file-code-signature-team-id",description:"The team identifier used to sign the process.\nThis is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only.",example:"EQHXZ8M8AV",flat_name:"file.code_signature.team_id",ignore_above:1024,level:"extended",name:"team_id",normalize:[],original_fieldset:"code_signature",short:"The team identifier used to sign the process.",type:"keyword"},"file.code_signature.timestamp":{dashed_name:"file-code-signature-timestamp",description:"Date and time when the code signature was generated and signed.",example:"2021-01-01T12:10:30Z",flat_name:"file.code_signature.timestamp",level:"extended",name:"timestamp",normalize:[],original_fieldset:"code_signature",short:"When the signature was generated and signed.",type:"date"},"file.code_signature.trusted":{dashed_name:"file-code-signature-trusted",description:"Stores the trust status of the certificate chain.\nValidating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.",example:"true",flat_name:"file.code_signature.trusted",level:"extended",name:"trusted",normalize:[],original_fieldset:"code_signature",short:"Stores the trust status of the certificate chain.",type:"boolean"},"file.code_signature.valid":{dashed_name:"file-code-signature-valid",description:"Boolean to capture if the digital signature is verified against the binary content.\nLeave unpopulated if a certificate was unchecked.",example:"true",flat_name:"file.code_signature.valid",level:"extended",name:"valid",normalize:[],original_fieldset:"code_signature",short:"Boolean to capture if the digital signature is verified against the binary content.",type:"boolean"},"file.created":{dashed_name:"file-created",description:"File creation time.\nNote that not all filesystems store the creation time.",flat_name:"file.created",level:"extended",name:"created",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"File creation time.",type:"date"},"file.ctime":{dashed_name:"file-ctime",description:"Last time the file attributes or metadata changed.\nNote that changes to the file content will update `mtime`. This implies `ctime` will be adjusted at the same time, since `mtime` is an attribute of the file.",flat_name:"file.ctime",level:"extended",name:"ctime",normalize:[],otel:[{attribute:"file.changed",relation:"equivalent",stability:"experimental"}],short:"Last time the file attributes or metadata changed.",type:"date"},"file.device":{dashed_name:"file-device",description:"Device that is the source of the file.",example:"sda",flat_name:"file.device",ignore_above:1024,level:"extended",name:"device",normalize:[],short:"Device that is the source of the file.",type:"keyword"},"file.directory":{dashed_name:"file-directory",description:"Directory where the file is located. It should include the drive letter, when appropriate.",example:"/home/alice",flat_name:"file.directory",ignore_above:1024,level:"extended",name:"directory",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Directory where the file is located.",type:"keyword"},"file.drive_letter":{dashed_name:"file-drive-letter",description:"Drive letter where the file is located. This field is only relevant on Windows.\nThe value should be uppercase, and not include the colon.",example:"C",flat_name:"file.drive_letter",ignore_above:1,level:"extended",name:"drive_letter",normalize:[],short:"Drive letter where the file is located.",type:"keyword"},"file.elf.architecture":{dashed_name:"file-elf-architecture",description:"Machine architecture of the ELF file.",example:"x86-64",flat_name:"file.elf.architecture",ignore_above:1024,level:"extended",name:"architecture",normalize:[],original_fieldset:"elf",short:"Machine architecture of the ELF file.",type:"keyword"},"file.elf.byte_order":{dashed_name:"file-elf-byte-order",description:"Byte sequence of ELF file.",example:"Little Endian",flat_name:"file.elf.byte_order",ignore_above:1024,level:"extended",name:"byte_order",normalize:[],original_fieldset:"elf",short:"Byte sequence of ELF file.",type:"keyword"},"file.elf.cpu_type":{dashed_name:"file-elf-cpu-type",description:"CPU type of the ELF file.",example:"Intel",flat_name:"file.elf.cpu_type",ignore_above:1024,level:"extended",name:"cpu_type",normalize:[],original_fieldset:"elf",short:"CPU type of the ELF file.",type:"keyword"},"file.elf.creation_date":{dashed_name:"file-elf-creation-date",description:"Extracted when possible from the file's metadata. Indicates when it was built or compiled. It can also be faked by malware creators.",flat_name:"file.elf.creation_date",level:"extended",name:"creation_date",normalize:[],original_fieldset:"elf",short:"Build or compile date.",type:"date"},"file.elf.exports":{dashed_name:"file-elf-exports",description:"List of exported element names and types.",flat_name:"file.elf.exports",level:"extended",name:"exports",normalize:["array"],original_fieldset:"elf",short:"List of exported element names and types.",type:"flattened"},"file.elf.go_import_hash":{dashed_name:"file-elf-go-import-hash",description:"A hash of the Go language imports in an ELF file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThe algorithm used to calculate the Go symbol hash and a reference implementation are available here: https://github.com/elastic/toutoumomoma",example:"10bddcb4cee42080f76c88d9ff964491",flat_name:"file.elf.go_import_hash",ignore_above:1024,level:"extended",name:"go_import_hash",normalize:[],original_fieldset:"elf",short:"A hash of the Go language imports in an ELF file.",type:"keyword"},"file.elf.go_imports":{dashed_name:"file-elf-go-imports",description:"List of imported Go language element names and types.",flat_name:"file.elf.go_imports",level:"extended",name:"go_imports",normalize:[],original_fieldset:"elf",short:"List of imported Go language element names and types.",type:"flattened"},"file.elf.go_imports_names_entropy":{dashed_name:"file-elf-go-imports-names-entropy",description:"Shannon entropy calculation from the list of Go imports.",flat_name:"file.elf.go_imports_names_entropy",format:"number",level:"extended",name:"go_imports_names_entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the list of Go imports.",type:"long"},"file.elf.go_imports_names_var_entropy":{dashed_name:"file-elf-go-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of Go imports.",flat_name:"file.elf.go_imports_names_var_entropy",format:"number",level:"extended",name:"go_imports_names_var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the list of Go imports.",type:"long"},"file.elf.go_stripped":{dashed_name:"file-elf-go-stripped",description:"Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.",flat_name:"file.elf.go_stripped",level:"extended",name:"go_stripped",normalize:[],original_fieldset:"elf",short:"Whether the file is a stripped or obfuscated Go executable.",type:"boolean"},"file.elf.header.abi_version":{dashed_name:"file-elf-header-abi-version",description:"Version of the ELF Application Binary Interface (ABI).",flat_name:"file.elf.header.abi_version",ignore_above:1024,level:"extended",name:"header.abi_version",normalize:[],original_fieldset:"elf",short:"Version of the ELF Application Binary Interface (ABI).",type:"keyword"},"file.elf.header.class":{dashed_name:"file-elf-header-class",description:"Header class of the ELF file.",flat_name:"file.elf.header.class",ignore_above:1024,level:"extended",name:"header.class",normalize:[],original_fieldset:"elf",short:"Header class of the ELF file.",type:"keyword"},"file.elf.header.data":{dashed_name:"file-elf-header-data",description:"Data table of the ELF header.",flat_name:"file.elf.header.data",ignore_above:1024,level:"extended",name:"header.data",normalize:[],original_fieldset:"elf",short:"Data table of the ELF header.",type:"keyword"},"file.elf.header.entrypoint":{dashed_name:"file-elf-header-entrypoint",description:"Header entrypoint of the ELF file.",flat_name:"file.elf.header.entrypoint",format:"string",level:"extended",name:"header.entrypoint",normalize:[],original_fieldset:"elf",short:"Header entrypoint of the ELF file.",type:"long"},"file.elf.header.object_version":{dashed_name:"file-elf-header-object-version",description:'"0x1" for original ELF files.',flat_name:"file.elf.header.object_version",ignore_above:1024,level:"extended",name:"header.object_version",normalize:[],original_fieldset:"elf",short:'"0x1" for original ELF files.',type:"keyword"},"file.elf.header.os_abi":{dashed_name:"file-elf-header-os-abi",description:"Application Binary Interface (ABI) of the Linux OS.",flat_name:"file.elf.header.os_abi",ignore_above:1024,level:"extended",name:"header.os_abi",normalize:[],original_fieldset:"elf",short:"Application Binary Interface (ABI) of the Linux OS.",type:"keyword"},"file.elf.header.type":{dashed_name:"file-elf-header-type",description:"Header type of the ELF file.",flat_name:"file.elf.header.type",ignore_above:1024,level:"extended",name:"header.type",normalize:[],original_fieldset:"elf",short:"Header type of the ELF file.",type:"keyword"},"file.elf.header.version":{dashed_name:"file-elf-header-version",description:"Version of the ELF header.",flat_name:"file.elf.header.version",ignore_above:1024,level:"extended",name:"header.version",normalize:[],original_fieldset:"elf",short:"Version of the ELF header.",type:"keyword"},"file.elf.import_hash":{dashed_name:"file-elf-import-hash",description:"A hash of the imports in an ELF file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is an ELF implementation of the Windows PE imphash.",example:"d41d8cd98f00b204e9800998ecf8427e",flat_name:"file.elf.import_hash",ignore_above:1024,level:"extended",name:"import_hash",normalize:[],original_fieldset:"elf",short:"A hash of the imports in an ELF file.",type:"keyword"},"file.elf.imports":{dashed_name:"file-elf-imports",description:"List of imported element names and types.",flat_name:"file.elf.imports",level:"extended",name:"imports",normalize:["array"],original_fieldset:"elf",short:"List of imported element names and types.",type:"flattened"},"file.elf.imports_names_entropy":{dashed_name:"file-elf-imports-names-entropy",description:"Shannon entropy calculation from the list of imported element names and types.",flat_name:"file.elf.imports_names_entropy",format:"number",level:"extended",name:"imports_names_entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the list of imported element names and types.",type:"long"},"file.elf.imports_names_var_entropy":{dashed_name:"file-elf-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of imported element names and types.",flat_name:"file.elf.imports_names_var_entropy",format:"number",level:"extended",name:"imports_names_var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the list of imported element names and types.",type:"long"},"file.elf.sections":{dashed_name:"file-elf-sections",description:"An array containing an object for each section of the ELF file.\nThe keys that should be present in these objects are defined by sub-fields underneath `elf.sections.*`.",flat_name:"file.elf.sections",level:"extended",name:"sections",normalize:["array"],original_fieldset:"elf",short:"Section information of the ELF file.",type:"nested"},"file.elf.sections.chi2":{dashed_name:"file-elf-sections-chi2",description:"Chi-square probability distribution of the section.",flat_name:"file.elf.sections.chi2",format:"number",level:"extended",name:"sections.chi2",normalize:[],original_fieldset:"elf",short:"Chi-square probability distribution of the section.",type:"long"},"file.elf.sections.entropy":{dashed_name:"file-elf-sections-entropy",description:"Shannon entropy calculation from the section.",flat_name:"file.elf.sections.entropy",format:"number",level:"extended",name:"sections.entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the section.",type:"long"},"file.elf.sections.flags":{dashed_name:"file-elf-sections-flags",description:"ELF Section List flags.",flat_name:"file.elf.sections.flags",ignore_above:1024,level:"extended",name:"sections.flags",normalize:[],original_fieldset:"elf",short:"ELF Section List flags.",type:"keyword"},"file.elf.sections.name":{dashed_name:"file-elf-sections-name",description:"ELF Section List name.",flat_name:"file.elf.sections.name",ignore_above:1024,level:"extended",name:"sections.name",normalize:[],original_fieldset:"elf",short:"ELF Section List name.",type:"keyword"},"file.elf.sections.physical_offset":{dashed_name:"file-elf-sections-physical-offset",description:"ELF Section List offset.",flat_name:"file.elf.sections.physical_offset",ignore_above:1024,level:"extended",name:"sections.physical_offset",normalize:[],original_fieldset:"elf",short:"ELF Section List offset.",type:"keyword"},"file.elf.sections.physical_size":{dashed_name:"file-elf-sections-physical-size",description:"ELF Section List physical size.",flat_name:"file.elf.sections.physical_size",format:"bytes",level:"extended",name:"sections.physical_size",normalize:[],original_fieldset:"elf",short:"ELF Section List physical size.",type:"long"},"file.elf.sections.type":{dashed_name:"file-elf-sections-type",description:"ELF Section List type.",flat_name:"file.elf.sections.type",ignore_above:1024,level:"extended",name:"sections.type",normalize:[],original_fieldset:"elf",short:"ELF Section List type.",type:"keyword"},"file.elf.sections.var_entropy":{dashed_name:"file-elf-sections-var-entropy",description:"Variance for Shannon entropy calculation from the section.",flat_name:"file.elf.sections.var_entropy",format:"number",level:"extended",name:"sections.var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the section.",type:"long"},"file.elf.sections.virtual_address":{dashed_name:"file-elf-sections-virtual-address",description:"ELF Section List virtual address.",flat_name:"file.elf.sections.virtual_address",format:"string",level:"extended",name:"sections.virtual_address",normalize:[],original_fieldset:"elf",short:"ELF Section List virtual address.",type:"long"},"file.elf.sections.virtual_size":{dashed_name:"file-elf-sections-virtual-size",description:"ELF Section List virtual size.",flat_name:"file.elf.sections.virtual_size",format:"string",level:"extended",name:"sections.virtual_size",normalize:[],original_fieldset:"elf",short:"ELF Section List virtual size.",type:"long"},"file.elf.segments":{dashed_name:"file-elf-segments",description:"An array containing an object for each segment of the ELF file.\nThe keys that should be present in these objects are defined by sub-fields underneath `elf.segments.*`.",flat_name:"file.elf.segments",level:"extended",name:"segments",normalize:["array"],original_fieldset:"elf",short:"ELF object segment list.",type:"nested"},"file.elf.segments.sections":{dashed_name:"file-elf-segments-sections",description:"ELF object segment sections.",flat_name:"file.elf.segments.sections",ignore_above:1024,level:"extended",name:"segments.sections",normalize:[],original_fieldset:"elf",short:"ELF object segment sections.",type:"keyword"},"file.elf.segments.type":{dashed_name:"file-elf-segments-type",description:"ELF object segment type.",flat_name:"file.elf.segments.type",ignore_above:1024,level:"extended",name:"segments.type",normalize:[],original_fieldset:"elf",short:"ELF object segment type.",type:"keyword"},"file.elf.shared_libraries":{dashed_name:"file-elf-shared-libraries",description:"List of shared libraries used by this ELF object.",flat_name:"file.elf.shared_libraries",ignore_above:1024,level:"extended",name:"shared_libraries",normalize:["array"],original_fieldset:"elf",short:"List of shared libraries used by this ELF object.",type:"keyword"},"file.elf.telfhash":{dashed_name:"file-elf-telfhash",description:"telfhash symbol hash for ELF file.",flat_name:"file.elf.telfhash",ignore_above:1024,level:"extended",name:"telfhash",normalize:[],original_fieldset:"elf",short:"telfhash hash for ELF file.",type:"keyword"},"file.extension":{dashed_name:"file-extension",description:'File extension, excluding the leading dot.\nNote that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").',example:"png",flat_name:"file.extension",ignore_above:1024,level:"extended",name:"extension",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"File extension, excluding the leading dot.",type:"keyword"},"file.fork_name":{dashed_name:"file-fork-name",description:"A fork is additional data associated with a filesystem object.\nOn Linux, a resource fork is used to store additional data with a filesystem object. A file always has at least one fork for the data portion, and additional forks may exist.\nOn NTFS, this is analogous to an Alternate Data Stream (ADS), and the default data stream for a file is just called $DATA. Zone.Identifier is commonly used by Windows to track contents downloaded from the Internet. An ADS is typically of the form: `C:\\path\\to\\filename.extension:some_fork_name`, and `some_fork_name` is the value that should populate `fork_name`. `filename.extension` should populate `file.name`, and `extension` should populate `file.extension`. The full path, `file.path`, will include the fork name.",example:"Zone.Identifer",flat_name:"file.fork_name",ignore_above:1024,level:"extended",name:"fork_name",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"A fork is additional data associated with a filesystem object.",type:"keyword"},"file.gid":{dashed_name:"file-gid",description:"Primary group ID (GID) of the file.",example:"1001",flat_name:"file.gid",ignore_above:1024,level:"extended",name:"gid",normalize:[],otel:[{attribute:"file.group.id",relation:"equivalent",stability:"experimental"}],short:"Primary group ID (GID) of the file.",type:"keyword"},"file.group":{dashed_name:"file-group",description:"Primary group name of the file.",example:"alice",flat_name:"file.group",ignore_above:1024,level:"extended",name:"group",normalize:[],otel:[{attribute:"file.group.name",relation:"equivalent",stability:"experimental"}],short:"Primary group name of the file.",type:"keyword"},"file.hash.cdhash":{beta:"This field is beta and subject to change.",dashed_name:"file-hash-cdhash",description:"Code directory hash, utilized to uniquely identify and authenticate the integrity of the executable code.",example:"3783b4052fd474dbe30676b45c329e7a6d44acd9",flat_name:"file.hash.cdhash",ignore_above:1024,level:"extended",name:"cdhash",normalize:[],original_fieldset:"hash",short:"The Code Directory (CD) hash of an executable.",type:"keyword"},"file.hash.md5":{dashed_name:"file-hash-md5",description:"MD5 hash.",flat_name:"file.hash.md5",ignore_above:1024,level:"extended",name:"md5",normalize:[],original_fieldset:"hash",short:"MD5 hash.",type:"keyword"},"file.hash.sha1":{dashed_name:"file-hash-sha1",description:"SHA1 hash.",flat_name:"file.hash.sha1",ignore_above:1024,level:"extended",name:"sha1",normalize:[],original_fieldset:"hash",short:"SHA1 hash.",type:"keyword"},"file.hash.sha256":{dashed_name:"file-hash-sha256",description:"SHA256 hash.",flat_name:"file.hash.sha256",ignore_above:1024,level:"extended",name:"sha256",normalize:[],original_fieldset:"hash",short:"SHA256 hash.",type:"keyword"},"file.hash.sha384":{dashed_name:"file-hash-sha384",description:"SHA384 hash.",flat_name:"file.hash.sha384",ignore_above:1024,level:"extended",name:"sha384",normalize:[],original_fieldset:"hash",short:"SHA384 hash.",type:"keyword"},"file.hash.sha512":{dashed_name:"file-hash-sha512",description:"SHA512 hash.",flat_name:"file.hash.sha512",ignore_above:1024,level:"extended",name:"sha512",normalize:[],original_fieldset:"hash",short:"SHA512 hash.",type:"keyword"},"file.hash.ssdeep":{dashed_name:"file-hash-ssdeep",description:"SSDEEP hash.",flat_name:"file.hash.ssdeep",ignore_above:1024,level:"extended",name:"ssdeep",normalize:[],original_fieldset:"hash",short:"SSDEEP hash.",type:"keyword"},"file.hash.tlsh":{dashed_name:"file-hash-tlsh",description:"TLSH hash.",flat_name:"file.hash.tlsh",ignore_above:1024,level:"extended",name:"tlsh",normalize:[],original_fieldset:"hash",short:"TLSH hash.",type:"keyword"},"file.inode":{dashed_name:"file-inode",description:"Inode representing the file in the filesystem.",example:"256383",flat_name:"file.inode",ignore_above:1024,level:"extended",name:"inode",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Inode representing the file in the filesystem.",type:"keyword"},"file.macho.go_import_hash":{dashed_name:"file-macho-go-import-hash",description:"A hash of the Go language imports in a Mach-O file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThe algorithm used to calculate the Go symbol hash and a reference implementation are available here: https://github.com/elastic/toutoumomoma",example:"10bddcb4cee42080f76c88d9ff964491",flat_name:"file.macho.go_import_hash",ignore_above:1024,level:"extended",name:"go_import_hash",normalize:[],original_fieldset:"macho",short:"A hash of the Go language imports in a Mach-O file.",type:"keyword"},"file.macho.go_imports":{dashed_name:"file-macho-go-imports",description:"List of imported Go language element names and types.",flat_name:"file.macho.go_imports",level:"extended",name:"go_imports",normalize:[],original_fieldset:"macho",short:"List of imported Go language element names and types.",type:"flattened"},"file.macho.go_imports_names_entropy":{dashed_name:"file-macho-go-imports-names-entropy",description:"Shannon entropy calculation from the list of Go imports.",flat_name:"file.macho.go_imports_names_entropy",format:"number",level:"extended",name:"go_imports_names_entropy",normalize:[],original_fieldset:"macho",short:"Shannon entropy calculation from the list of Go imports.",type:"long"},"file.macho.go_imports_names_var_entropy":{dashed_name:"file-macho-go-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of Go imports.",flat_name:"file.macho.go_imports_names_var_entropy",format:"number",level:"extended",name:"go_imports_names_var_entropy",normalize:[],original_fieldset:"macho",short:"Variance for Shannon entropy calculation from the list of Go imports.",type:"long"},"file.macho.go_stripped":{dashed_name:"file-macho-go-stripped",description:"Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.",flat_name:"file.macho.go_stripped",level:"extended",name:"go_stripped",normalize:[],original_fieldset:"macho",short:"Whether the file is a stripped or obfuscated Go executable.",type:"boolean"},"file.macho.import_hash":{dashed_name:"file-macho-import-hash",description:"A hash of the imports in a Mach-O file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is a synonym for symhash.",example:"d41d8cd98f00b204e9800998ecf8427e",flat_name:"file.macho.import_hash",ignore_above:1024,level:"extended",name:"import_hash",normalize:[],original_fieldset:"macho",short:"A hash of the imports in a Mach-O file.",type:"keyword"},"file.macho.imports":{dashed_name:"file-macho-imports",description:"List of imported element names and types.",flat_name:"file.macho.imports",level:"extended",name:"imports",normalize:["array"],original_fieldset:"macho",short:"List of imported element names and types.",type:"flattened"},"file.macho.imports_names_entropy":{dashed_name:"file-macho-imports-names-entropy",description:"Shannon entropy calculation from the list of imported element names and types.",flat_name:"file.macho.imports_names_entropy",format:"number",level:"extended",name:"imports_names_entropy",normalize:[],original_fieldset:"macho",short:"Shannon entropy calculation from the list of imported element names and types.",type:"long"},"file.macho.imports_names_var_entropy":{dashed_name:"file-macho-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of imported element names and types.",flat_name:"file.macho.imports_names_var_entropy",format:"number",level:"extended",name:"imports_names_var_entropy",normalize:[],original_fieldset:"macho",short:"Variance for Shannon entropy calculation from the list of imported element names and types.",type:"long"},"file.macho.sections":{dashed_name:"file-macho-sections",description:"An array containing an object for each section of the Mach-O file.\nThe keys that should be present in these objects are defined by sub-fields underneath `macho.sections.*`.",flat_name:"file.macho.sections",level:"extended",name:"sections",normalize:["array"],original_fieldset:"macho",short:"Section information of the Mach-O file.",type:"nested"},"file.macho.sections.entropy":{dashed_name:"file-macho-sections-entropy",description:"Shannon entropy calculation from the section.",flat_name:"file.macho.sections.entropy",format:"number",level:"extended",name:"sections.entropy",normalize:[],original_fieldset:"macho",short:"Shannon entropy calculation from the section.",type:"long"},"file.macho.sections.name":{dashed_name:"file-macho-sections-name",description:"Mach-O Section List name.",flat_name:"file.macho.sections.name",ignore_above:1024,level:"extended",name:"sections.name",normalize:[],original_fieldset:"macho",short:"Mach-O Section List name.",type:"keyword"},"file.macho.sections.physical_size":{dashed_name:"file-macho-sections-physical-size",description:"Mach-O Section List physical size.",flat_name:"file.macho.sections.physical_size",format:"bytes",level:"extended",name:"sections.physical_size",normalize:[],original_fieldset:"macho",short:"Mach-O Section List physical size.",type:"long"},"file.macho.sections.var_entropy":{dashed_name:"file-macho-sections-var-entropy",description:"Variance for Shannon entropy calculation from the section.",flat_name:"file.macho.sections.var_entropy",format:"number",level:"extended",name:"sections.var_entropy",normalize:[],original_fieldset:"macho",short:"Variance for Shannon entropy calculation from the section.",type:"long"},"file.macho.sections.virtual_size":{dashed_name:"file-macho-sections-virtual-size",description:"Mach-O Section List virtual size. This is always the same as `physical_size`.",flat_name:"file.macho.sections.virtual_size",format:"string",level:"extended",name:"sections.virtual_size",normalize:[],original_fieldset:"macho",short:"Mach-O Section List virtual size. This is always the same as `physical_size`.",type:"long"},"file.macho.symhash":{dashed_name:"file-macho-symhash",description:"A hash of the imports in a Mach-O file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is a Mach-O implementation of the Windows PE imphash",example:"d3ccf195b62a9279c3c19af1080497ec",flat_name:"file.macho.symhash",ignore_above:1024,level:"extended",name:"symhash",normalize:[],original_fieldset:"macho",short:"A hash of the imports in a Mach-O file.",type:"keyword"},"file.mime_type":{dashed_name:"file-mime-type",description:"MIME type should identify the format of the file or stream of bytes using IANA official types: https://www.iana.org/assignments/media-types/media-types.xhtml, where possible. When more than one type is applicable, the most specific type should be used.",flat_name:"file.mime_type",ignore_above:1024,level:"extended",name:"mime_type",normalize:[],short:"Media type of file, document, or arrangement of bytes.",type:"keyword"},"file.mode":{dashed_name:"file-mode",description:"Mode of the file in octal representation.",example:"0640",flat_name:"file.mode",ignore_above:1024,level:"extended",name:"mode",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Mode of the file in octal representation.",type:"keyword"},"file.mtime":{dashed_name:"file-mtime",description:"Last time the file content was modified.",flat_name:"file.mtime",level:"extended",name:"mtime",normalize:[],otel:[{attribute:"file.modified",relation:"equivalent",stability:"experimental"}],short:"Last time the file content was modified.",type:"date"},"file.name":{dashed_name:"file-name",description:"Name of the file including the extension, without the directory.",example:"example.png",flat_name:"file.name",ignore_above:1024,level:"extended",name:"name",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Name of the file including the extension, without the directory.",type:"keyword"},"file.origin_referrer_url":{beta:"This field is beta and subject to change.",dashed_name:"file-origin-referrer-url",description:"The URL of the webpage that linked to the file.",example:"http://example.com/article1.html",flat_name:"file.origin_referrer_url",ignore_above:8192,level:"extended",name:"origin_referrer_url",normalize:[],short:"The URL of the webpage that linked to the file.",type:"keyword"},"file.origin_url":{beta:"This field is beta and subject to change.",dashed_name:"file-origin-url",description:"The URL where the file is hosted.",example:"http://example.com/imgs/article1_img1.jpg",flat_name:"file.origin_url",ignore_above:8192,level:"extended",name:"origin_url",normalize:[],short:"The URL where the file is hosted.",type:"keyword"},"file.owner":{dashed_name:"file-owner",description:"File owner's username.",example:"alice",flat_name:"file.owner",ignore_above:1024,level:"extended",name:"owner",normalize:[],otel:[{attribute:"file.owner.name",relation:"equivalent",stability:"experimental"}],short:"File owner's username.",type:"keyword"},"file.path":{dashed_name:"file-path",description:"Full path to the file, including the file name. It should include the drive letter, when appropriate.",example:"/home/alice/example.png",flat_name:"file.path",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"file.path.text",name:"text",type:"match_only_text"}],name:"path",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Full path to the file, including the file name.",type:"keyword"},"file.pe.architecture":{dashed_name:"file-pe-architecture",description:"CPU architecture target for the file.",example:"x64",flat_name:"file.pe.architecture",ignore_above:1024,level:"extended",name:"architecture",normalize:[],original_fieldset:"pe",short:"CPU architecture target for the file.",type:"keyword"},"file.pe.company":{dashed_name:"file-pe-company",description:"Internal company name of the file, provided at compile-time.",example:"Microsoft Corporation",flat_name:"file.pe.company",ignore_above:1024,level:"extended",name:"company",normalize:[],original_fieldset:"pe",short:"Internal company name of the file, provided at compile-time.",type:"keyword"},"file.pe.description":{dashed_name:"file-pe-description",description:"Internal description of the file, provided at compile-time.",example:"Paint",flat_name:"file.pe.description",ignore_above:1024,level:"extended",name:"description",normalize:[],original_fieldset:"pe",short:"Internal description of the file, provided at compile-time.",type:"keyword"},"file.pe.file_version":{dashed_name:"file-pe-file-version",description:"Internal version of the file, provided at compile-time.",example:"6.3.9600.17415",flat_name:"file.pe.file_version",ignore_above:1024,level:"extended",name:"file_version",normalize:[],original_fieldset:"pe",short:"Process name.",type:"keyword"},"file.pe.go_import_hash":{dashed_name:"file-pe-go-import-hash",description:"A hash of the Go language imports in a PE file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThe algorithm used to calculate the Go symbol hash and a reference implementation are available here: https://github.com/elastic/toutoumomoma",example:"10bddcb4cee42080f76c88d9ff964491",flat_name:"file.pe.go_import_hash",ignore_above:1024,level:"extended",name:"go_import_hash",normalize:[],original_fieldset:"pe",short:"A hash of the Go language imports in a PE file.",type:"keyword"},"file.pe.go_imports":{dashed_name:"file-pe-go-imports",description:"List of imported Go language element names and types.",flat_name:"file.pe.go_imports",level:"extended",name:"go_imports",normalize:[],original_fieldset:"pe",short:"List of imported Go language element names and types.",type:"flattened"},"file.pe.go_imports_names_entropy":{dashed_name:"file-pe-go-imports-names-entropy",description:"Shannon entropy calculation from the list of Go imports.",flat_name:"file.pe.go_imports_names_entropy",format:"number",level:"extended",name:"go_imports_names_entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the list of Go imports.",type:"long"},"file.pe.go_imports_names_var_entropy":{dashed_name:"file-pe-go-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of Go imports.",flat_name:"file.pe.go_imports_names_var_entropy",format:"number",level:"extended",name:"go_imports_names_var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the list of Go imports.",type:"long"},"file.pe.go_stripped":{dashed_name:"file-pe-go-stripped",description:"Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.",flat_name:"file.pe.go_stripped",level:"extended",name:"go_stripped",normalize:[],original_fieldset:"pe",short:"Whether the file is a stripped or obfuscated Go executable.",type:"boolean"},"file.pe.imphash":{dashed_name:"file-pe-imphash",description:"A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nLearn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html.",example:"0c6803c4e922103c4dca5963aad36ddf",flat_name:"file.pe.imphash",ignore_above:1024,level:"extended",name:"imphash",normalize:[],original_fieldset:"pe",short:"A hash of the imports in a PE file.",type:"keyword"},"file.pe.import_hash":{dashed_name:"file-pe-import-hash",description:"A hash of the imports in a PE file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is a synonym for imphash.",example:"d41d8cd98f00b204e9800998ecf8427e",flat_name:"file.pe.import_hash",ignore_above:1024,level:"extended",name:"import_hash",normalize:[],original_fieldset:"pe",short:"A hash of the imports in a PE file.",type:"keyword"},"file.pe.imports":{dashed_name:"file-pe-imports",description:"List of imported element names and types.",flat_name:"file.pe.imports",level:"extended",name:"imports",normalize:["array"],original_fieldset:"pe",short:"List of imported element names and types.",type:"flattened"},"file.pe.imports_names_entropy":{dashed_name:"file-pe-imports-names-entropy",description:"Shannon entropy calculation from the list of imported element names and types.",flat_name:"file.pe.imports_names_entropy",format:"number",level:"extended",name:"imports_names_entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the list of imported element names and types.",type:"long"},"file.pe.imports_names_var_entropy":{dashed_name:"file-pe-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of imported element names and types.",flat_name:"file.pe.imports_names_var_entropy",format:"number",level:"extended",name:"imports_names_var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the list of imported element names and types.",type:"long"},"file.pe.original_file_name":{dashed_name:"file-pe-original-file-name",description:"Internal name of the file, provided at compile-time.",example:"MSPAINT.EXE",flat_name:"file.pe.original_file_name",ignore_above:1024,level:"extended",name:"original_file_name",normalize:[],original_fieldset:"pe",short:"Internal name of the file, provided at compile-time.",type:"keyword"},"file.pe.pehash":{dashed_name:"file-pe-pehash",description:"A hash of the PE header and data from one or more PE sections. An pehash can be used to cluster files by transforming structural information about a file into a hash value.\nLearn more at https://www.usenix.org/legacy/events/leet09/tech/full_papers/wicherski/wicherski_html/index.html.",example:"73ff189b63cd6be375a7ff25179a38d347651975",flat_name:"file.pe.pehash",ignore_above:1024,level:"extended",name:"pehash",normalize:[],original_fieldset:"pe",short:"A hash of the PE header and data from one or more PE sections.",type:"keyword"},"file.pe.product":{dashed_name:"file-pe-product",description:"Internal product name of the file, provided at compile-time.",example:"Microsoft® Windows® Operating System",flat_name:"file.pe.product",ignore_above:1024,level:"extended",name:"product",normalize:[],original_fieldset:"pe",short:"Internal product name of the file, provided at compile-time.",type:"keyword"},"file.pe.sections":{dashed_name:"file-pe-sections",description:"An array containing an object for each section of the PE file.\nThe keys that should be present in these objects are defined by sub-fields underneath `pe.sections.*`.",flat_name:"file.pe.sections",level:"extended",name:"sections",normalize:["array"],original_fieldset:"pe",short:"Section information of the PE file.",type:"nested"},"file.pe.sections.entropy":{dashed_name:"file-pe-sections-entropy",description:"Shannon entropy calculation from the section.",flat_name:"file.pe.sections.entropy",format:"number",level:"extended",name:"sections.entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the section.",type:"long"},"file.pe.sections.name":{dashed_name:"file-pe-sections-name",description:"PE Section List name.",flat_name:"file.pe.sections.name",ignore_above:1024,level:"extended",name:"sections.name",normalize:[],original_fieldset:"pe",short:"PE Section List name.",type:"keyword"},"file.pe.sections.physical_size":{dashed_name:"file-pe-sections-physical-size",description:"PE Section List physical size.",flat_name:"file.pe.sections.physical_size",format:"bytes",level:"extended",name:"sections.physical_size",normalize:[],original_fieldset:"pe",short:"PE Section List physical size.",type:"long"},"file.pe.sections.var_entropy":{dashed_name:"file-pe-sections-var-entropy",description:"Variance for Shannon entropy calculation from the section.",flat_name:"file.pe.sections.var_entropy",format:"number",level:"extended",name:"sections.var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the section.",type:"long"},"file.pe.sections.virtual_size":{dashed_name:"file-pe-sections-virtual-size",description:"PE Section List virtual size. This is always the same as `physical_size`.",flat_name:"file.pe.sections.virtual_size",format:"string",level:"extended",name:"sections.virtual_size",normalize:[],original_fieldset:"pe",short:"PE Section List virtual size. This is always the same as `physical_size`.",type:"long"},"file.size":{dashed_name:"file-size",description:'File size in bytes.\nOnly relevant when `file.type` is "file".',example:16384,flat_name:"file.size",level:"extended",name:"size",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"File size in bytes.",type:"long"},"file.target_path":{dashed_name:"file-target-path",description:"Target path for symlinks.",flat_name:"file.target_path",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"file.target_path.text",name:"text",type:"match_only_text"}],name:"target_path",normalize:[],otel:[{attribute:"file.symbolic_link.target_path",relation:"equivalent",stability:"experimental"}],short:"Target path for symlinks.",type:"keyword"},"file.type":{dashed_name:"file-type",description:"File type (file, dir, or symlink).",example:"file",flat_name:"file.type",ignore_above:1024,level:"extended",name:"type",normalize:[],short:"File type (file, dir, or symlink).",type:"keyword"},"file.uid":{dashed_name:"file-uid",description:"The user ID (UID) or security identifier (SID) of the file owner.",example:"1001",flat_name:"file.uid",ignore_above:1024,level:"extended",name:"uid",normalize:[],otel:[{attribute:"file.owner.id",relation:"equivalent",stability:"experimental"}],short:"The user ID (UID) or security identifier (SID) of the file owner.",type:"keyword"},"file.x509.alternative_names":{dashed_name:"file-x509-alternative-names",description:"List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.",example:"*.elastic.co",flat_name:"file.x509.alternative_names",ignore_above:1024,level:"extended",name:"alternative_names",normalize:["array"],original_fieldset:"x509",short:"List of subject alternative names (SAN).",type:"keyword"},"file.x509.issuer.common_name":{dashed_name:"file-x509-issuer-common-name",description:"List of common name (CN) of issuing certificate authority.",example:"Example SHA2 High Assurance Server CA",flat_name:"file.x509.issuer.common_name",ignore_above:1024,level:"extended",name:"issuer.common_name",normalize:["array"],original_fieldset:"x509",short:"List of common name (CN) of issuing certificate authority.",type:"keyword"},"file.x509.issuer.country":{dashed_name:"file-x509-issuer-country",description:"List of country \\(C) codes",example:"US",flat_name:"file.x509.issuer.country",ignore_above:1024,level:"extended",name:"issuer.country",normalize:["array"],original_fieldset:"x509",short:"List of country \\(C) codes",type:"keyword"},"file.x509.issuer.distinguished_name":{dashed_name:"file-x509-issuer-distinguished-name",description:"Distinguished name (DN) of issuing certificate authority.",example:"C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA",flat_name:"file.x509.issuer.distinguished_name",ignore_above:1024,level:"extended",name:"issuer.distinguished_name",normalize:[],original_fieldset:"x509",short:"Distinguished name (DN) of issuing certificate authority.",type:"keyword"},"file.x509.issuer.locality":{dashed_name:"file-x509-issuer-locality",description:"List of locality names (L)",example:"Mountain View",flat_name:"file.x509.issuer.locality",ignore_above:1024,level:"extended",name:"issuer.locality",normalize:["array"],original_fieldset:"x509",short:"List of locality names (L)",type:"keyword"},"file.x509.issuer.organization":{dashed_name:"file-x509-issuer-organization",description:"List of organizations (O) of issuing certificate authority.",example:"Example Inc",flat_name:"file.x509.issuer.organization",ignore_above:1024,level:"extended",name:"issuer.organization",normalize:["array"],original_fieldset:"x509",short:"List of organizations (O) of issuing certificate authority.",type:"keyword"},"file.x509.issuer.organizational_unit":{dashed_name:"file-x509-issuer-organizational-unit",description:"List of organizational units (OU) of issuing certificate authority.",example:"www.example.com",flat_name:"file.x509.issuer.organizational_unit",ignore_above:1024,level:"extended",name:"issuer.organizational_unit",normalize:["array"],original_fieldset:"x509",short:"List of organizational units (OU) of issuing certificate authority.",type:"keyword"},"file.x509.issuer.state_or_province":{dashed_name:"file-x509-issuer-state-or-province",description:"List of state or province names (ST, S, or P)",example:"California",flat_name:"file.x509.issuer.state_or_province",ignore_above:1024,level:"extended",name:"issuer.state_or_province",normalize:["array"],original_fieldset:"x509",short:"List of state or province names (ST, S, or P)",type:"keyword"},"file.x509.not_after":{dashed_name:"file-x509-not-after",description:"Time at which the certificate is no longer considered valid.",example:"2020-07-16T03:15:39Z",flat_name:"file.x509.not_after",level:"extended",name:"not_after",normalize:[],original_fieldset:"x509",short:"Time at which the certificate is no longer considered valid.",type:"date"},"file.x509.not_before":{dashed_name:"file-x509-not-before",description:"Time at which the certificate is first considered valid.",example:"2019-08-16T01:40:25Z",flat_name:"file.x509.not_before",level:"extended",name:"not_before",normalize:[],original_fieldset:"x509",short:"Time at which the certificate is first considered valid.",type:"date"},"file.x509.public_key_algorithm":{dashed_name:"file-x509-public-key-algorithm",description:"Algorithm used to generate the public key.",example:"RSA",flat_name:"file.x509.public_key_algorithm",ignore_above:1024,level:"extended",name:"public_key_algorithm",normalize:[],original_fieldset:"x509",short:"Algorithm used to generate the public key.",type:"keyword"},"file.x509.public_key_curve":{dashed_name:"file-x509-public-key-curve",description:"The curve used by the elliptic curve public key algorithm. This is algorithm specific.",example:"nistp521",flat_name:"file.x509.public_key_curve",ignore_above:1024,level:"extended",name:"public_key_curve",normalize:[],original_fieldset:"x509",short:"The curve used by the elliptic curve public key algorithm. This is algorithm specific.",type:"keyword"},"file.x509.public_key_exponent":{dashed_name:"file-x509-public-key-exponent",description:"Exponent used to derive the public key. This is algorithm specific.",doc_values:!1,example:65537,flat_name:"file.x509.public_key_exponent",index:!1,level:"extended",name:"public_key_exponent",normalize:[],original_fieldset:"x509",short:"Exponent used to derive the public key. This is algorithm specific.",type:"long"},"file.x509.public_key_size":{dashed_name:"file-x509-public-key-size",description:"The size of the public key space in bits.",example:2048,flat_name:"file.x509.public_key_size",level:"extended",name:"public_key_size",normalize:[],original_fieldset:"x509",short:"The size of the public key space in bits.",type:"long"},"file.x509.serial_number":{dashed_name:"file-x509-serial-number",description:"Unique serial number issued by the certificate authority. For consistency, this must be encoded in base 16 and formatted without colons and uppercase characters.",example:"55FBB9C7DEBF09809D12CCAA",flat_name:"file.x509.serial_number",ignore_above:1024,level:"extended",name:"serial_number",normalize:[],original_fieldset:"x509",short:"Unique serial number issued by the certificate authority.",type:"keyword"},"file.x509.signature_algorithm":{dashed_name:"file-x509-signature-algorithm",description:"Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353.",example:"SHA256-RSA",flat_name:"file.x509.signature_algorithm",ignore_above:1024,level:"extended",name:"signature_algorithm",normalize:[],original_fieldset:"x509",short:"Identifier for certificate signature algorithm.",type:"keyword"},"file.x509.subject.common_name":{dashed_name:"file-x509-subject-common-name",description:"List of common names (CN) of subject.",example:"shared.global.example.net",flat_name:"file.x509.subject.common_name",ignore_above:1024,level:"extended",name:"subject.common_name",normalize:["array"],original_fieldset:"x509",short:"List of common names (CN) of subject.",type:"keyword"},"file.x509.subject.country":{dashed_name:"file-x509-subject-country",description:"List of country \\(C) code",example:"US",flat_name:"file.x509.subject.country",ignore_above:1024,level:"extended",name:"subject.country",normalize:["array"],original_fieldset:"x509",short:"List of country \\(C) code",type:"keyword"},"file.x509.subject.distinguished_name":{dashed_name:"file-x509-subject-distinguished-name",description:"Distinguished name (DN) of the certificate subject entity.",example:"C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net",flat_name:"file.x509.subject.distinguished_name",ignore_above:1024,level:"extended",name:"subject.distinguished_name",normalize:[],original_fieldset:"x509",short:"Distinguished name (DN) of the certificate subject entity.",type:"keyword"},"file.x509.subject.locality":{dashed_name:"file-x509-subject-locality",description:"List of locality names (L)",example:"San Francisco",flat_name:"file.x509.subject.locality",ignore_above:1024,level:"extended",name:"subject.locality",normalize:["array"],original_fieldset:"x509",short:"List of locality names (L)",type:"keyword"},"file.x509.subject.organization":{dashed_name:"file-x509-subject-organization",description:"List of organizations (O) of subject.",example:"Example, Inc.",flat_name:"file.x509.subject.organization",ignore_above:1024,level:"extended",name:"subject.organization",normalize:["array"],original_fieldset:"x509",short:"List of organizations (O) of subject.",type:"keyword"},"file.x509.subject.organizational_unit":{dashed_name:"file-x509-subject-organizational-unit",description:"List of organizational units (OU) of subject.",flat_name:"file.x509.subject.organizational_unit",ignore_above:1024,level:"extended",name:"subject.organizational_unit",normalize:["array"],original_fieldset:"x509",short:"List of organizational units (OU) of subject.",type:"keyword"},"file.x509.subject.state_or_province":{dashed_name:"file-x509-subject-state-or-province",description:"List of state or province names (ST, S, or P)",example:"California",flat_name:"file.x509.subject.state_or_province",ignore_above:1024,level:"extended",name:"subject.state_or_province",normalize:["array"],original_fieldset:"x509",short:"List of state or province names (ST, S, or P)",type:"keyword"},"file.x509.version_number":{dashed_name:"file-x509-version-number",description:"Version of x509 format.",example:3,flat_name:"file.x509.version_number",ignore_above:1024,level:"extended",name:"version_number",normalize:[],original_fieldset:"x509",short:"Version of x509 format.",type:"keyword"},"group.domain":{dashed_name:"group-domain",description:"Name of the directory the group is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"group.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],short:"Name of the directory the group is a member of.",type:"keyword"},"group.id":{dashed_name:"group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],short:"Unique identifier for the group on the system/platform.",type:"keyword"},"group.name":{dashed_name:"group-name",description:"Name of the group.",flat_name:"group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],short:"Name of the group.",type:"keyword"},"host.architecture":{dashed_name:"host-architecture",description:"Operating system architecture.",example:"x86_64",flat_name:"host.architecture",ignore_above:1024,level:"core",name:"architecture",normalize:[],otel:[{attribute:"host.arch",relation:"equivalent",stability:"experimental"}],short:"Operating system architecture.",type:"keyword"},"host.boot.id":{dashed_name:"host-boot-id",description:"Linux boot uuid taken from /proc/sys/kernel/random/boot_id. Note the boot_id value from /proc may or may not be the same in containers as on the host. Some container runtimes will bind mount a new boot_id value onto the proc file in each container.",example:"88a1f0ed-5ae5-41ee-af6b-41921c311872",flat_name:"host.boot.id",ignore_above:1024,level:"extended",name:"boot.id",normalize:[],short:"Linux boot uuid taken from /proc/sys/kernel/random/boot_id",type:"keyword"},"host.cpu.usage":{dashed_name:"host-cpu-usage",description:"Percent CPU used which is normalized by the number of CPU cores and it ranges from 0 to 1.\nScaling factor: 1000.\nFor example: For a two core host, this value should be the average of the two cores, between 0 and 1.",flat_name:"host.cpu.usage",level:"extended",name:"cpu.usage",normalize:[],otel:[{metric:"system.cpu.utilization",relation:"metric",stability:"experimental"}],scaling_factor:1e3,short:"Percent CPU used, between 0 and 1.",type:"scaled_float"},"host.disk.read.bytes":{dashed_name:"host-disk-read-bytes",description:"The total number of bytes (gauge) read successfully (aggregated from all disks) since the last metric collection.",flat_name:"host.disk.read.bytes",level:"extended",name:"disk.read.bytes",normalize:[],otel:[{metric:"system.disk.io",relation:"metric",stability:"experimental"}],short:"The number of bytes read by all disks.",type:"long"},"host.disk.write.bytes":{dashed_name:"host-disk-write-bytes",description:"The total number of bytes (gauge) written successfully (aggregated from all disks) since the last metric collection.",flat_name:"host.disk.write.bytes",level:"extended",name:"disk.write.bytes",normalize:[],otel:[{metric:"system.disk.io",relation:"metric",stability:"experimental"}],short:"The number of bytes written on all disks.",type:"long"},"host.domain":{dashed_name:"host-domain",description:"Name of the domain of which the host is a member.\nFor example, on Windows this could be the host's Active Directory domain or NetBIOS domain name. For Linux this could be the domain of the host's LDAP provider.",example:"CONTOSO",flat_name:"host.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],short:"Name of the directory the group is a member of.",type:"keyword"},"host.geo.city_name":{dashed_name:"host-geo-city-name",description:"City name.",example:"Montreal",flat_name:"host.geo.city_name",ignore_above:1024,level:"core",name:"city_name",normalize:[],original_fieldset:"geo",short:"City name.",type:"keyword"},"host.geo.continent_code":{dashed_name:"host-geo-continent-code",description:"Two-letter code representing continent's name.",example:"NA",flat_name:"host.geo.continent_code",ignore_above:1024,level:"core",name:"continent_code",normalize:[],original_fieldset:"geo",short:"Continent code.",type:"keyword"},"host.geo.continent_name":{dashed_name:"host-geo-continent-name",description:"Name of the continent.",example:"North America",flat_name:"host.geo.continent_name",ignore_above:1024,level:"core",name:"continent_name",normalize:[],original_fieldset:"geo",short:"Name of the continent.",type:"keyword"},"host.geo.country_iso_code":{dashed_name:"host-geo-country-iso-code",description:"Country ISO code.",example:"CA",flat_name:"host.geo.country_iso_code",ignore_above:1024,level:"core",name:"country_iso_code",normalize:[],original_fieldset:"geo",short:"Country ISO code.",type:"keyword"},"host.geo.country_name":{dashed_name:"host-geo-country-name",description:"Country name.",example:"Canada",flat_name:"host.geo.country_name",ignore_above:1024,level:"core",name:"country_name",normalize:[],original_fieldset:"geo",short:"Country name.",type:"keyword"},"host.geo.location":{dashed_name:"host-geo-location",description:"Longitude and latitude.",example:'{ "lon": -73.614830, "lat": 45.505918 }',flat_name:"host.geo.location",level:"core",name:"location",normalize:[],original_fieldset:"geo",short:"Longitude and latitude.",type:"geo_point"},"host.geo.name":{dashed_name:"host-geo-name",description:"User-defined description of a location, at the level of granularity they care about.\nCould be the name of their data centers, the floor number, if this describes a local physical entity, city names.\nNot typically used in automated geolocation.",example:"boston-dc",flat_name:"host.geo.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"geo",short:"User-defined description of a location.",type:"keyword"},"host.geo.postal_code":{dashed_name:"host-geo-postal-code",description:"Postal code associated with the location.\nValues appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.",example:94040,flat_name:"host.geo.postal_code",ignore_above:1024,level:"core",name:"postal_code",normalize:[],original_fieldset:"geo",short:"Postal code.",type:"keyword"},"host.geo.region_iso_code":{dashed_name:"host-geo-region-iso-code",description:"Region ISO code.",example:"CA-QC",flat_name:"host.geo.region_iso_code",ignore_above:1024,level:"core",name:"region_iso_code",normalize:[],original_fieldset:"geo",short:"Region ISO code.",type:"keyword"},"host.geo.region_name":{dashed_name:"host-geo-region-name",description:"Region name.",example:"Quebec",flat_name:"host.geo.region_name",ignore_above:1024,level:"core",name:"region_name",normalize:[],original_fieldset:"geo",short:"Region name.",type:"keyword"},"host.geo.timezone":{dashed_name:"host-geo-timezone",description:"The time zone of the location, such as IANA time zone name.",example:"America/Argentina/Buenos_Aires",flat_name:"host.geo.timezone",ignore_above:1024,level:"core",name:"timezone",normalize:[],original_fieldset:"geo",short:"Time zone.",type:"keyword"},"host.hostname":{dashed_name:"host-hostname",description:"Hostname of the host.\nIt normally contains what the `hostname` command returns on the host machine.",flat_name:"host.hostname",ignore_above:1024,level:"core",name:"hostname",normalize:[],short:"Hostname of the host.",type:"keyword"},"host.id":{dashed_name:"host-id",description:"Unique host id.\nAs hostname is not always unique, use values that are meaningful in your environment.\nExample: The current usage of `beat.name`.",flat_name:"host.id",ignore_above:1024,level:"core",name:"id",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Unique host id.",type:"keyword"},"host.ip":{dashed_name:"host-ip",description:"Host ip addresses.",flat_name:"host.ip",level:"core",name:"ip",normalize:["array"],otel:[{relation:"match",stability:"experimental"}],short:"Host ip addresses.",synthetic_source_keep:"none",type:"ip"},"host.mac":{dashed_name:"host-mac",description:"Host MAC addresses.\nThe notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.",example:'["00-00-5E-00-53-23", "00-00-5E-00-53-24"]',flat_name:"host.mac",ignore_above:1024,level:"core",name:"mac",normalize:["array"],otel:[{relation:"match",stability:"experimental"}],pattern:"^[A-F0-9]{2}(-[A-F0-9]{2}){5,}$",short:"Host MAC addresses.",synthetic_source_keep:"none",type:"keyword"},"host.name":{dashed_name:"host-name",description:"Name of the host.\nIt can contain what hostname returns on Unix systems, the fully qualified domain name (FQDN), or a name specified by the user. The recommended value is the lowercase FQDN of the host.",flat_name:"host.name",ignore_above:1024,level:"core",name:"name",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Name of the host.",type:"keyword"},"host.network.egress.bytes":{dashed_name:"host-network-egress-bytes",description:"The number of bytes (gauge) sent out on all network interfaces by the host since the last metric collection.",flat_name:"host.network.egress.bytes",level:"extended",name:"network.egress.bytes",normalize:[],otel:[{metric:"system.network.io",relation:"metric",stability:"experimental"}],short:"The number of bytes sent on all network interfaces.",type:"long"},"host.network.egress.packets":{dashed_name:"host-network-egress-packets",description:"The number of packets (gauge) sent out on all network interfaces by the host since the last metric collection.",flat_name:"host.network.egress.packets",level:"extended",name:"network.egress.packets",normalize:[],otel:[{metric:"system.network.packets",relation:"metric",stability:"experimental"}],short:"The number of packets sent on all network interfaces.",type:"long"},"host.network.ingress.bytes":{dashed_name:"host-network-ingress-bytes",description:"The number of bytes received (gauge) on all network interfaces by the host since the last metric collection.",flat_name:"host.network.ingress.bytes",level:"extended",name:"network.ingress.bytes",normalize:[],otel:[{metric:"system.network.io",relation:"metric",stability:"experimental"}],short:"The number of bytes received on all network interfaces.",type:"long"},"host.network.ingress.packets":{dashed_name:"host-network-ingress-packets",description:"The number of packets (gauge) received on all network interfaces by the host since the last metric collection.",flat_name:"host.network.ingress.packets",level:"extended",name:"network.ingress.packets",normalize:[],otel:[{metric:"system.network.packets",relation:"metric",stability:"experimental"}],short:"The number of packets received on all network interfaces.",type:"long"},"host.os.family":{dashed_name:"host-os-family",description:"OS family (such as redhat, debian, freebsd, windows).",example:"debian",flat_name:"host.os.family",ignore_above:1024,level:"extended",name:"family",normalize:[],original_fieldset:"os",short:"OS family (such as redhat, debian, freebsd, windows).",type:"keyword"},"host.os.full":{dashed_name:"host-os-full",description:"Operating system name, including the version or code name.",example:"Mac OS Mojave",flat_name:"host.os.full",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"host.os.full.text",name:"text",type:"match_only_text"}],name:"full",normalize:[],original_fieldset:"os",short:"Operating system name, including the version or code name.",type:"keyword"},"host.os.kernel":{dashed_name:"host-os-kernel",description:"Operating system kernel version as a raw string.",example:"4.4.0-112-generic",flat_name:"host.os.kernel",ignore_above:1024,level:"extended",name:"kernel",normalize:[],original_fieldset:"os",short:"Operating system kernel version as a raw string.",type:"keyword"},"host.os.name":{dashed_name:"host-os-name",description:"Operating system name, without the version.",example:"Mac OS X",flat_name:"host.os.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"host.os.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"os",short:"Operating system name, without the version.",type:"keyword"},"host.os.platform":{dashed_name:"host-os-platform",description:"Operating system platform (such centos, ubuntu, windows).",example:"darwin",flat_name:"host.os.platform",ignore_above:1024,level:"extended",name:"platform",normalize:[],original_fieldset:"os",short:"Operating system platform (such centos, ubuntu, windows).",type:"keyword"},"host.os.type":{dashed_name:"host-os-type",description:"Use the `os.type` field to categorize the operating system into one of the broad commercial families.\nIf the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition.",example:"macos",expected_values:["linux","macos","unix","windows","ios","android"],flat_name:"host.os.type",ignore_above:1024,level:"extended",name:"type",normalize:[],original_fieldset:"os",short:"Which commercial OS family (one of: linux, macos, unix, windows, ios or android).",type:"keyword"},"host.os.version":{dashed_name:"host-os-version",description:"Operating system version as a raw string.",example:"10.14.1",flat_name:"host.os.version",ignore_above:1024,level:"extended",name:"version",normalize:[],original_fieldset:"os",short:"Operating system version as a raw string.",type:"keyword"},"host.pid_ns_ino":{dashed_name:"host-pid-ns-ino",description:"This is the inode number of the namespace in the namespace file system (nsfs). Unsigned int inum in include/linux/ns_common.h.",example:256383,flat_name:"host.pid_ns_ino",ignore_above:1024,level:"extended",name:"pid_ns_ino",normalize:[],short:"Pid namespace inode",type:"keyword"},"host.risk.calculated_level":{dashed_name:"host-risk-calculated-level",description:"A risk classification level calculated by an internal system as part of entity analytics and entity risk scoring.",example:"High",flat_name:"host.risk.calculated_level",ignore_above:1024,level:"extended",name:"calculated_level",normalize:[],original_fieldset:"risk",short:"A risk classification level calculated by an internal system as part of entity analytics and entity risk scoring.",type:"keyword"},"host.risk.calculated_score":{dashed_name:"host-risk-calculated-score",description:"A risk classification score calculated by an internal system as part of entity analytics and entity risk scoring.",example:880.73,flat_name:"host.risk.calculated_score",level:"extended",name:"calculated_score",normalize:[],original_fieldset:"risk",short:"A risk classification score calculated by an internal system as part of entity analytics and entity risk scoring.",type:"float"},"host.risk.calculated_score_norm":{dashed_name:"host-risk-calculated-score-norm",description:"A risk classification score calculated by an internal system as part of entity analytics and entity risk scoring, and normalized to a range of 0 to 100.",example:88.73,flat_name:"host.risk.calculated_score_norm",level:"extended",name:"calculated_score_norm",normalize:[],original_fieldset:"risk",short:"A normalized risk score calculated by an internal system.",type:"float"},"host.risk.static_level":{dashed_name:"host-risk-static-level",description:"A risk classification level obtained from outside the system, such as from some external Threat Intelligence Platform.",example:"High",flat_name:"host.risk.static_level",ignore_above:1024,level:"extended",name:"static_level",normalize:[],original_fieldset:"risk",short:"A risk classification level obtained from outside the system, such as from some external Threat Intelligence Platform.",type:"keyword"},"host.risk.static_score":{dashed_name:"host-risk-static-score",description:"A risk classification score obtained from outside the system, such as from some external Threat Intelligence Platform.",example:830,flat_name:"host.risk.static_score",level:"extended",name:"static_score",normalize:[],original_fieldset:"risk",short:"A risk classification score obtained from outside the system, such as from some external Threat Intelligence Platform.",type:"float"},"host.risk.static_score_norm":{dashed_name:"host-risk-static-score-norm",description:"A risk classification score obtained from outside the system, such as from some external Threat Intelligence Platform, and normalized to a range of 0 to 100.",example:83,flat_name:"host.risk.static_score_norm",level:"extended",name:"static_score_norm",normalize:[],original_fieldset:"risk",short:"A normalized risk score calculated by an external system.",type:"float"},"host.type":{dashed_name:"host-type",description:"Type of host.\nFor Cloud providers this can be the machine type like `t2.medium`. If vm, this could be the container, for example, or other information meaningful in your environment.",flat_name:"host.type",ignore_above:1024,level:"core",name:"type",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Type of host.",type:"keyword"},"host.uptime":{dashed_name:"host-uptime",description:"Seconds the host has been up.",example:1325,flat_name:"host.uptime",level:"extended",name:"uptime",normalize:[],otel:[{metric:"system.uptime",relation:"metric",stability:"experimental"}],short:"Seconds the host has been up.",type:"long"},"http.request.body.bytes":{dashed_name:"http-request-body-bytes",description:"Size in bytes of the request body.",example:887,flat_name:"http.request.body.bytes",format:"bytes",level:"extended",name:"request.body.bytes",normalize:[],otel:[{attribute:"http.request.body.size",relation:"equivalent",stability:"experimental"}],short:"Size in bytes of the request body.",type:"long"},"http.request.body.content":{dashed_name:"http-request-body-content",description:"The full HTTP request body.",example:"Hello world",flat_name:"http.request.body.content",level:"extended",multi_fields:[{flat_name:"http.request.body.content.text",name:"text",type:"match_only_text"}],name:"request.body.content",normalize:[],short:"The full HTTP request body.",type:"wildcard"},"http.request.bytes":{dashed_name:"http-request-bytes",description:"Total size in bytes of the request (body and headers).",example:1437,flat_name:"http.request.bytes",format:"bytes",level:"extended",name:"request.bytes",normalize:[],otel:[{attribute:"http.request.size",relation:"equivalent",stability:"experimental"}],short:"Total size in bytes of the request (body and headers).",type:"long"},"http.request.id":{dashed_name:"http-request-id",description:"A unique identifier for each HTTP request to correlate logs between clients and servers in transactions.\nThe id may be contained in a non-standard HTTP header, such as `X-Request-ID` or `X-Correlation-ID`.",example:"123e4567-e89b-12d3-a456-426614174000",flat_name:"http.request.id",ignore_above:1024,level:"extended",name:"request.id",normalize:[],short:"HTTP request ID.",type:"keyword"},"http.request.method":{dashed_name:"http-request-method",description:"HTTP request method.\nThe value should retain its casing from the original event. For example, `GET`, `get`, and `GeT` are all considered valid values for this field.",example:"POST",flat_name:"http.request.method",ignore_above:1024,level:"extended",name:"request.method",normalize:[],otel:[{attribute:"http.request.method_original",relation:"equivalent",stability:"stable"},{attribute:"http.request.method",note:"`http.request.method` in SemConv is the known, normalized, upper case value of the request method, other than the ECS' `http.request.method` that retains casing from the original event.\n",relation:"conflict",stability:"stable"}],short:"HTTP request method.",type:"keyword"},"http.request.mime_type":{dashed_name:"http-request-mime-type",description:"Mime type of the body of the request.\nThis value must only be populated based on the content of the request body, not on the `Content-Type` header. Comparing the mime type of a request with the request's Content-Type header can be helpful in detecting threats or misconfigured clients.",example:"image/gif",flat_name:"http.request.mime_type",ignore_above:1024,level:"extended",name:"request.mime_type",normalize:[],short:"Mime type of the body of the request.",type:"keyword"},"http.request.referrer":{dashed_name:"http-request-referrer",description:"Referrer for this HTTP request.",example:"https://blog.example.com/",flat_name:"http.request.referrer",ignore_above:1024,level:"extended",name:"request.referrer",normalize:[],short:"Referrer for this HTTP request.",type:"keyword"},"http.response.body.bytes":{dashed_name:"http-response-body-bytes",description:"Size in bytes of the response body.",example:887,flat_name:"http.response.body.bytes",format:"bytes",level:"extended",name:"response.body.bytes",normalize:[],otel:[{attribute:"http.response.body.size",relation:"equivalent",stability:"experimental"}],short:"Size in bytes of the response body.",type:"long"},"http.response.body.content":{dashed_name:"http-response-body-content",description:"The full HTTP response body.",example:"Hello world",flat_name:"http.response.body.content",level:"extended",multi_fields:[{flat_name:"http.response.body.content.text",name:"text",type:"match_only_text"}],name:"response.body.content",normalize:[],short:"The full HTTP response body.",type:"wildcard"},"http.response.bytes":{dashed_name:"http-response-bytes",description:"Total size in bytes of the response (body and headers).",example:1437,flat_name:"http.response.bytes",format:"bytes",level:"extended",name:"response.bytes",normalize:[],otel:[{attribute:"http.response.size",relation:"equivalent",stability:"experimental"}],short:"Total size in bytes of the response (body and headers).",type:"long"},"http.response.mime_type":{dashed_name:"http-response-mime-type",description:"Mime type of the body of the response.\nThis value must only be populated based on the content of the response body, not on the `Content-Type` header. Comparing the mime type of a response with the response's Content-Type header can be helpful in detecting misconfigured servers.",example:"image/gif",flat_name:"http.response.mime_type",ignore_above:1024,level:"extended",name:"response.mime_type",normalize:[],short:"Mime type of the body of the response.",type:"keyword"},"http.response.status_code":{dashed_name:"http-response-status-code",description:"HTTP response status code.",example:404,flat_name:"http.response.status_code",format:"string",level:"extended",name:"response.status_code",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"HTTP response status code.",type:"long"},"http.version":{dashed_name:"http-version",description:"HTTP version.",example:1.1,flat_name:"http.version",ignore_above:1024,level:"extended",name:"version",normalize:[],otel:[{attribute:"network.protocol.name",relation:"related",stability:"stable"},{attribute:"network.protocol.version",note:"In OTel SemConv, `network.protocol.version` specifies the HTTP version if the value of `network.protocol.name` is `http`.\n",relation:"related",stability:"stable"}],short:"HTTP version.",type:"keyword"},labels:{dashed_name:"labels",description:"Custom key/value pairs.\nCan be used to add meta information to events. Should not contain nested objects. All values are stored as keyword.\nExample: `docker` and `k8s` labels.",example:'{"application": "foo-bar", "env": "production"}',flat_name:"labels",level:"core",name:"labels",normalize:[],object_type:"keyword",otel:[{attribute:"k8s.pod.label",relation:"related",stability:"experimental"},{attribute:"container.label",relation:"related",stability:"experimental"}],short:"Custom key/value pairs.",type:"object"},"log.file.path":{dashed_name:"log-file-path",description:"Full path to the log file this event came from, including the file name. It should include the drive letter, when appropriate.\nIf the event wasn't read from a log file, do not populate this field.",example:"/var/log/fun-times.log",flat_name:"log.file.path",ignore_above:1024,level:"extended",name:"file.path",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Full path to the log file this event came from.",type:"keyword"},"log.level":{dashed_name:"log-level",description:"Original log level of the log event.\nIf the source of the event provides a log level or textual severity, this is the one that goes in `log.level`. If your source doesn't specify one, you may put your event transport's severity here (e.g. Syslog severity).\nSome examples are `warn`, `err`, `i`, `informational`.",example:"error",flat_name:"log.level",ignore_above:1024,level:"core",name:"level",normalize:[],otel:[{otlp_field:"severity_text",relation:"otlp",stability:"stable"}],short:"Log level of the log event.",type:"keyword"},"log.logger":{dashed_name:"log-logger",description:"The name of the logger inside an application. This is usually the name of the class which initialized the logger, or can be a custom name.",example:"org.elasticsearch.bootstrap.Bootstrap",flat_name:"log.logger",ignore_above:1024,level:"core",name:"logger",normalize:[],short:"Name of the logger.",type:"keyword"},"log.origin.file.line":{dashed_name:"log-origin-file-line",description:"The line number of the file containing the source code which originated the log event.",example:42,flat_name:"log.origin.file.line",level:"extended",name:"origin.file.line",normalize:[],short:"The line number of the file which originated the log event.",type:"long"},"log.origin.file.name":{dashed_name:"log-origin-file-name",description:"The name of the file containing the source code which originated the log event.\nNote that this field is not meant to capture the log file. The correct field to capture the log file is `log.file.path`.",example:"Bootstrap.java",flat_name:"log.origin.file.name",ignore_above:1024,level:"extended",name:"origin.file.name",normalize:[],short:"The code file which originated the log event.",type:"keyword"},"log.origin.function":{dashed_name:"log-origin-function",description:"The name of the function or method which originated the log event.",example:"init",flat_name:"log.origin.function",ignore_above:1024,level:"extended",name:"origin.function",normalize:[],short:"The function which originated the log event.",type:"keyword"},"log.syslog":{dashed_name:"log-syslog",description:"The Syslog metadata of the event, if the event was transmitted via Syslog. Please see RFCs 5424 or 3164.",flat_name:"log.syslog",level:"extended",name:"syslog",normalize:[],short:"Syslog metadata",type:"object"},"log.syslog.appname":{dashed_name:"log-syslog-appname",description:"The device or application that originated the Syslog message, if available.",example:"sshd",flat_name:"log.syslog.appname",ignore_above:1024,level:"extended",name:"syslog.appname",normalize:[],short:"The device or application that originated the Syslog message.",type:"keyword"},"log.syslog.facility.code":{dashed_name:"log-syslog-facility-code",description:"The Syslog numeric facility of the log event, if available.\nAccording to RFCs 5424 and 3164, this value should be an integer between 0 and 23.",example:23,flat_name:"log.syslog.facility.code",format:"string",level:"extended",name:"syslog.facility.code",normalize:[],short:"Syslog numeric facility of the event.",type:"long"},"log.syslog.facility.name":{dashed_name:"log-syslog-facility-name",description:"The Syslog text-based facility of the log event, if available.",example:"local7",flat_name:"log.syslog.facility.name",ignore_above:1024,level:"extended",name:"syslog.facility.name",normalize:[],short:"Syslog text-based facility of the event.",type:"keyword"},"log.syslog.hostname":{dashed_name:"log-syslog-hostname",description:"The hostname, FQDN, or IP of the machine that originally sent the Syslog message. This is sourced from the hostname field of the syslog header. Depending on the environment, this value may be different from the host that handled the event, especially if the host handling the events is acting as a collector.",example:"example-host",flat_name:"log.syslog.hostname",ignore_above:1024,level:"extended",name:"syslog.hostname",normalize:[],short:"The host that originated the Syslog message.",type:"keyword"},"log.syslog.msgid":{dashed_name:"log-syslog-msgid",description:"An identifier for the type of Syslog message, if available. Only applicable for RFC 5424 messages.",example:"ID47",flat_name:"log.syslog.msgid",ignore_above:1024,level:"extended",name:"syslog.msgid",normalize:[],short:"An identifier for the type of Syslog message.",type:"keyword"},"log.syslog.priority":{dashed_name:"log-syslog-priority",description:"Syslog numeric priority of the event, if available.\nAccording to RFCs 5424 and 3164, the priority is 8 * facility + severity. This number is therefore expected to contain a value between 0 and 191.",example:135,flat_name:"log.syslog.priority",format:"string",level:"extended",name:"syslog.priority",normalize:[],short:"Syslog priority of the event.",type:"long"},"log.syslog.procid":{dashed_name:"log-syslog-procid",description:"The process name or ID that originated the Syslog message, if available.",example:12345,flat_name:"log.syslog.procid",ignore_above:1024,level:"extended",name:"syslog.procid",normalize:[],short:"The process name or ID that originated the Syslog message.",type:"keyword"},"log.syslog.severity.code":{dashed_name:"log-syslog-severity-code",description:"The Syslog numeric severity of the log event, if available.\nIf the event source publishing via Syslog provides a different numeric severity value (e.g. firewall, IDS), your source's numeric severity should go to `event.severity`. If the event source does not specify a distinct severity, you can optionally copy the Syslog severity to `event.severity`.",example:3,flat_name:"log.syslog.severity.code",level:"extended",name:"syslog.severity.code",normalize:[],short:"Syslog numeric severity of the event.",type:"long"},"log.syslog.severity.name":{dashed_name:"log-syslog-severity-name",description:"The Syslog numeric severity of the log event, if available.\nIf the event source publishing via Syslog provides a different severity value (e.g. firewall, IDS), your source's text severity should go to `log.level`. If the event source does not specify a distinct severity, you can optionally copy the Syslog severity to `log.level`.",example:"Error",flat_name:"log.syslog.severity.name",ignore_above:1024,level:"extended",name:"syslog.severity.name",normalize:[],short:"Syslog text-based severity of the event.",type:"keyword"},"log.syslog.structured_data":{dashed_name:"log-syslog-structured-data",description:"Structured data expressed in RFC 5424 messages, if available. These are key-value pairs formed from the structured data portion of the syslog message, as defined in RFC 5424 Section 6.3.",flat_name:"log.syslog.structured_data",level:"extended",name:"syslog.structured_data",normalize:[],short:"Structured data expressed in RFC 5424 messages.",type:"flattened"},"log.syslog.version":{dashed_name:"log-syslog-version",description:"The version of the Syslog protocol specification. Only applicable for RFC 5424 messages.",example:1,flat_name:"log.syslog.version",ignore_above:1024,level:"extended",name:"syslog.version",normalize:[],short:"Syslog protocol version.",type:"keyword"},message:{dashed_name:"message",description:"For log events the message field contains the log message, optimized for viewing in a log viewer.\nFor structured logs without an original message field, other fields can be concatenated to form a human-readable summary of the event.\nIf multiple messages exist, they can be combined into one message.",example:"Hello World",flat_name:"message",level:"core",name:"message",normalize:[],otel:[{note:"The `body` in OTLP is of type `Any` and can be either an unstructured log message or a structured event.",otlp_field:"body",relation:"otlp",stability:"stable"}],short:"Log message optimized for viewing in a log viewer.",type:"match_only_text"},"network.application":{dashed_name:"network-application",description:"When a specific application or service is identified from network connection details (source/dest IPs, ports, certificates, or wire format), this field captures the application's or service's name.\nFor example, the original event identifies the network connection being from a specific web service in a `https` network connection, like `facebook` or `twitter`.\nThe field value must be normalized to lowercase for querying.",example:"aim",flat_name:"network.application",ignore_above:1024,level:"extended",name:"application",normalize:[],short:"Application level protocol name.",type:"keyword"},"network.bytes":{dashed_name:"network-bytes",description:"Total bytes transferred in both directions.\nIf `source.bytes` and `destination.bytes` are known, `network.bytes` is their sum.",example:368,flat_name:"network.bytes",format:"bytes",level:"core",name:"bytes",normalize:[],short:"Total bytes transferred in both directions.",type:"long"},"network.community_id":{dashed_name:"network-community-id",description:"A hash of source and destination IPs and ports, as well as the protocol used in a communication. This is a tool-agnostic standard to identify flows.\nLearn more at https://github.com/corelight/community-id-spec.",example:"1:hO+sN4H+MG5MY/8hIrXPqc4ZQz0=",flat_name:"network.community_id",ignore_above:1024,level:"extended",name:"community_id",normalize:[],short:"A hash of source and destination IPs and ports.",type:"keyword"},"network.direction":{dashed_name:"network-direction",description:'Direction of the network traffic.\nWhen mapping events from a host-based monitoring context, populate this field from the host\'s point of view, using the values "ingress" or "egress".\nWhen mapping events from a network or perimeter-based monitoring context, populate this field from the point of view of the network perimeter, using the values "inbound", "outbound", "internal" or "external".\nNote that "internal" is not crossing perimeter boundaries, and is meant to describe communication between two hosts within the perimeter. Note also that "external" is meant to describe traffic between two hosts that are external to the perimeter. This could for example be useful for ISPs or VPN service providers.',example:"inbound",expected_values:["ingress","egress","inbound","outbound","internal","external","unknown"],flat_name:"network.direction",ignore_above:1024,level:"core",name:"direction",normalize:[],short:"Direction of the network traffic.",type:"keyword"},"network.forwarded_ip":{dashed_name:"network-forwarded-ip",description:"Host IP address when the source IP address is the proxy.",example:"192.1.1.2",flat_name:"network.forwarded_ip",level:"core",name:"forwarded_ip",normalize:[],short:"Host IP address when the source IP address is the proxy.",type:"ip"},"network.iana_number":{dashed_name:"network-iana-number",description:"IANA Protocol Number (https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml). Standardized list of protocols. This aligns well with NetFlow and sFlow related logs which use the IANA Protocol Number.",example:6,flat_name:"network.iana_number",ignore_above:1024,level:"extended",name:"iana_number",normalize:[],short:"IANA Protocol Number.",type:"keyword"},"network.inner":{dashed_name:"network-inner",description:"Network.inner fields are added in addition to network.vlan fields to describe the innermost VLAN when q-in-q VLAN tagging is present. Allowed fields include vlan.id and vlan.name. Inner vlan fields are typically used when sending traffic with multiple 802.1q encapsulations to a network sensor (e.g. Zeek, Wireshark.)",flat_name:"network.inner",level:"extended",name:"inner",normalize:[],short:"Inner VLAN tag information",type:"object"},"network.inner.vlan.id":{dashed_name:"network-inner-vlan-id",description:"VLAN ID as reported by the observer.",example:10,flat_name:"network.inner.vlan.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"vlan",short:"VLAN ID as reported by the observer.",type:"keyword"},"network.inner.vlan.name":{dashed_name:"network-inner-vlan-name",description:"Optional VLAN name as reported by the observer.",example:"outside",flat_name:"network.inner.vlan.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"vlan",short:"Optional VLAN name as reported by the observer.",type:"keyword"},"network.name":{dashed_name:"network-name",description:"Name given by operators to sections of their network.",example:"Guest Wifi",flat_name:"network.name",ignore_above:1024,level:"extended",name:"name",normalize:[],short:"Name given by operators to sections of their network.",type:"keyword"},"network.packets":{dashed_name:"network-packets",description:"Total packets transferred in both directions.\nIf `source.packets` and `destination.packets` are known, `network.packets` is their sum.",example:24,flat_name:"network.packets",level:"core",name:"packets",normalize:[],short:"Total packets transferred in both directions.",type:"long"},"network.protocol":{dashed_name:"network-protocol",description:"In the OSI Model this would be the Application Layer protocol. For example, `http`, `dns`, or `ssh`.\nThe field value must be normalized to lowercase for querying.",example:"http",flat_name:"network.protocol",ignore_above:1024,level:"core",name:"protocol",normalize:[],otel:[{attribute:"network.protocol.name",relation:"equivalent",stability:"stable"}],short:"Application protocol name.",type:"keyword"},"network.transport":{dashed_name:"network-transport",description:"Same as network.iana_number, but instead using the Keyword name of the transport layer (udp, tcp, ipv6-icmp, etc.)\nThe field value must be normalized to lowercase for querying.",example:"tcp",flat_name:"network.transport",ignore_above:1024,level:"core",name:"transport",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"Protocol Name corresponding to the field `iana_number`.",type:"keyword"},"network.type":{dashed_name:"network-type",description:"In the OSI Model this would be the Network Layer. ipv4, ipv6, ipsec, pim, etc\nThe field value must be normalized to lowercase for querying.",example:"ipv4",flat_name:"network.type",ignore_above:1024,level:"core",name:"type",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"In the OSI Model this would be the Network Layer. ipv4, ipv6, ipsec, pim, etc",type:"keyword"},"network.vlan.id":{dashed_name:"network-vlan-id",description:"VLAN ID as reported by the observer.",example:10,flat_name:"network.vlan.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"vlan",short:"VLAN ID as reported by the observer.",type:"keyword"},"network.vlan.name":{dashed_name:"network-vlan-name",description:"Optional VLAN name as reported by the observer.",example:"outside",flat_name:"network.vlan.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"vlan",short:"Optional VLAN name as reported by the observer.",type:"keyword"},"observer.egress":{dashed_name:"observer-egress",description:"Observer.egress holds information like interface number and name, vlan, and zone information to classify egress traffic.  Single armed monitoring such as a network sensor on a span port should only use observer.ingress to categorize traffic.",flat_name:"observer.egress",level:"extended",name:"egress",normalize:[],short:"Object field for egress information",type:"object"},"observer.egress.interface.alias":{dashed_name:"observer-egress-interface-alias",description:"Interface alias as reported by the system, typically used in firewall implementations for e.g. inside, outside, or dmz logical interface naming.",example:"outside",flat_name:"observer.egress.interface.alias",ignore_above:1024,level:"extended",name:"alias",normalize:[],original_fieldset:"interface",short:"Interface alias",type:"keyword"},"observer.egress.interface.id":{dashed_name:"observer-egress-interface-id",description:"Interface ID as reported by an observer (typically SNMP interface ID).",example:10,flat_name:"observer.egress.interface.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"interface",short:"Interface ID",type:"keyword"},"observer.egress.interface.name":{dashed_name:"observer-egress-interface-name",description:"Interface name as reported by the system.",example:"eth0",flat_name:"observer.egress.interface.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"interface",short:"Interface name",type:"keyword"},"observer.egress.vlan.id":{dashed_name:"observer-egress-vlan-id",description:"VLAN ID as reported by the observer.",example:10,flat_name:"observer.egress.vlan.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"vlan",short:"VLAN ID as reported by the observer.",type:"keyword"},"observer.egress.vlan.name":{dashed_name:"observer-egress-vlan-name",description:"Optional VLAN name as reported by the observer.",example:"outside",flat_name:"observer.egress.vlan.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"vlan",short:"Optional VLAN name as reported by the observer.",type:"keyword"},"observer.egress.zone":{dashed_name:"observer-egress-zone",description:"Network zone of outbound traffic as reported by the observer to categorize the destination area of egress traffic, e.g. Internal, External, DMZ, HR, Legal, etc.",example:"Public_Internet",flat_name:"observer.egress.zone",ignore_above:1024,level:"extended",name:"egress.zone",normalize:[],short:"Observer Egress zone",type:"keyword"},"observer.geo.city_name":{dashed_name:"observer-geo-city-name",description:"City name.",example:"Montreal",flat_name:"observer.geo.city_name",ignore_above:1024,level:"core",name:"city_name",normalize:[],original_fieldset:"geo",short:"City name.",type:"keyword"},"observer.geo.continent_code":{dashed_name:"observer-geo-continent-code",description:"Two-letter code representing continent's name.",example:"NA",flat_name:"observer.geo.continent_code",ignore_above:1024,level:"core",name:"continent_code",normalize:[],original_fieldset:"geo",short:"Continent code.",type:"keyword"},"observer.geo.continent_name":{dashed_name:"observer-geo-continent-name",description:"Name of the continent.",example:"North America",flat_name:"observer.geo.continent_name",ignore_above:1024,level:"core",name:"continent_name",normalize:[],original_fieldset:"geo",short:"Name of the continent.",type:"keyword"},"observer.geo.country_iso_code":{dashed_name:"observer-geo-country-iso-code",description:"Country ISO code.",example:"CA",flat_name:"observer.geo.country_iso_code",ignore_above:1024,level:"core",name:"country_iso_code",normalize:[],original_fieldset:"geo",short:"Country ISO code.",type:"keyword"},"observer.geo.country_name":{dashed_name:"observer-geo-country-name",description:"Country name.",example:"Canada",flat_name:"observer.geo.country_name",ignore_above:1024,level:"core",name:"country_name",normalize:[],original_fieldset:"geo",short:"Country name.",type:"keyword"},"observer.geo.location":{dashed_name:"observer-geo-location",description:"Longitude and latitude.",example:'{ "lon": -73.614830, "lat": 45.505918 }',flat_name:"observer.geo.location",level:"core",name:"location",normalize:[],original_fieldset:"geo",short:"Longitude and latitude.",type:"geo_point"},"observer.geo.name":{dashed_name:"observer-geo-name",description:"User-defined description of a location, at the level of granularity they care about.\nCould be the name of their data centers, the floor number, if this describes a local physical entity, city names.\nNot typically used in automated geolocation.",example:"boston-dc",flat_name:"observer.geo.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"geo",short:"User-defined description of a location.",type:"keyword"},"observer.geo.postal_code":{dashed_name:"observer-geo-postal-code",description:"Postal code associated with the location.\nValues appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.",example:94040,flat_name:"observer.geo.postal_code",ignore_above:1024,level:"core",name:"postal_code",normalize:[],original_fieldset:"geo",short:"Postal code.",type:"keyword"},"observer.geo.region_iso_code":{dashed_name:"observer-geo-region-iso-code",description:"Region ISO code.",example:"CA-QC",flat_name:"observer.geo.region_iso_code",ignore_above:1024,level:"core",name:"region_iso_code",normalize:[],original_fieldset:"geo",short:"Region ISO code.",type:"keyword"},"observer.geo.region_name":{dashed_name:"observer-geo-region-name",description:"Region name.",example:"Quebec",flat_name:"observer.geo.region_name",ignore_above:1024,level:"core",name:"region_name",normalize:[],original_fieldset:"geo",short:"Region name.",type:"keyword"},"observer.geo.timezone":{dashed_name:"observer-geo-timezone",description:"The time zone of the location, such as IANA time zone name.",example:"America/Argentina/Buenos_Aires",flat_name:"observer.geo.timezone",ignore_above:1024,level:"core",name:"timezone",normalize:[],original_fieldset:"geo",short:"Time zone.",type:"keyword"},"observer.hostname":{dashed_name:"observer-hostname",description:"Hostname of the observer.",flat_name:"observer.hostname",ignore_above:1024,level:"core",name:"hostname",normalize:[],short:"Hostname of the observer.",type:"keyword"},"observer.ingress":{dashed_name:"observer-ingress",description:"Observer.ingress holds information like interface number and name, vlan, and zone information to classify ingress traffic.  Single armed monitoring such as a network sensor on a span port should only use observer.ingress to categorize traffic.",flat_name:"observer.ingress",level:"extended",name:"ingress",normalize:[],short:"Object field for ingress information",type:"object"},"observer.ingress.interface.alias":{dashed_name:"observer-ingress-interface-alias",description:"Interface alias as reported by the system, typically used in firewall implementations for e.g. inside, outside, or dmz logical interface naming.",example:"outside",flat_name:"observer.ingress.interface.alias",ignore_above:1024,level:"extended",name:"alias",normalize:[],original_fieldset:"interface",short:"Interface alias",type:"keyword"},"observer.ingress.interface.id":{dashed_name:"observer-ingress-interface-id",description:"Interface ID as reported by an observer (typically SNMP interface ID).",example:10,flat_name:"observer.ingress.interface.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"interface",short:"Interface ID",type:"keyword"},"observer.ingress.interface.name":{dashed_name:"observer-ingress-interface-name",description:"Interface name as reported by the system.",example:"eth0",flat_name:"observer.ingress.interface.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"interface",short:"Interface name",type:"keyword"},"observer.ingress.vlan.id":{dashed_name:"observer-ingress-vlan-id",description:"VLAN ID as reported by the observer.",example:10,flat_name:"observer.ingress.vlan.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"vlan",short:"VLAN ID as reported by the observer.",type:"keyword"},"observer.ingress.vlan.name":{dashed_name:"observer-ingress-vlan-name",description:"Optional VLAN name as reported by the observer.",example:"outside",flat_name:"observer.ingress.vlan.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"vlan",short:"Optional VLAN name as reported by the observer.",type:"keyword"},"observer.ingress.zone":{dashed_name:"observer-ingress-zone",description:"Network zone of incoming traffic as reported by the observer to categorize the source area of ingress traffic. e.g. internal, External, DMZ, HR, Legal, etc.",example:"DMZ",flat_name:"observer.ingress.zone",ignore_above:1024,level:"extended",name:"ingress.zone",normalize:[],short:"Observer ingress zone",type:"keyword"},"observer.ip":{dashed_name:"observer-ip",description:"IP addresses of the observer.",flat_name:"observer.ip",level:"core",name:"ip",normalize:["array"],short:"IP addresses of the observer.",synthetic_source_keep:"none",type:"ip"},"observer.mac":{dashed_name:"observer-mac",description:"MAC addresses of the observer.\nThe notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.",example:'["00-00-5E-00-53-23", "00-00-5E-00-53-24"]',flat_name:"observer.mac",ignore_above:1024,level:"core",name:"mac",normalize:["array"],pattern:"^[A-F0-9]{2}(-[A-F0-9]{2}){5,}$",short:"MAC addresses of the observer.",synthetic_source_keep:"none",type:"keyword"},"observer.name":{dashed_name:"observer-name",description:"Custom name of the observer.\nThis is a name that can be given to an observer. This can be helpful for example if multiple firewalls of the same model are used in an organization.\nIf no custom name is needed, the field can be left empty.",example:"1_proxySG",flat_name:"observer.name",ignore_above:1024,level:"extended",name:"name",normalize:[],short:"Custom name of the observer.",type:"keyword"},"observer.os.family":{dashed_name:"observer-os-family",description:"OS family (such as redhat, debian, freebsd, windows).",example:"debian",flat_name:"observer.os.family",ignore_above:1024,level:"extended",name:"family",normalize:[],original_fieldset:"os",short:"OS family (such as redhat, debian, freebsd, windows).",type:"keyword"},"observer.os.full":{dashed_name:"observer-os-full",description:"Operating system name, including the version or code name.",example:"Mac OS Mojave",flat_name:"observer.os.full",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"observer.os.full.text",name:"text",type:"match_only_text"}],name:"full",normalize:[],original_fieldset:"os",short:"Operating system name, including the version or code name.",type:"keyword"},"observer.os.kernel":{dashed_name:"observer-os-kernel",description:"Operating system kernel version as a raw string.",example:"4.4.0-112-generic",flat_name:"observer.os.kernel",ignore_above:1024,level:"extended",name:"kernel",normalize:[],original_fieldset:"os",short:"Operating system kernel version as a raw string.",type:"keyword"},"observer.os.name":{dashed_name:"observer-os-name",description:"Operating system name, without the version.",example:"Mac OS X",flat_name:"observer.os.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"observer.os.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"os",short:"Operating system name, without the version.",type:"keyword"},"observer.os.platform":{dashed_name:"observer-os-platform",description:"Operating system platform (such centos, ubuntu, windows).",example:"darwin",flat_name:"observer.os.platform",ignore_above:1024,level:"extended",name:"platform",normalize:[],original_fieldset:"os",short:"Operating system platform (such centos, ubuntu, windows).",type:"keyword"},"observer.os.type":{dashed_name:"observer-os-type",description:"Use the `os.type` field to categorize the operating system into one of the broad commercial families.\nIf the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition.",example:"macos",expected_values:["linux","macos","unix","windows","ios","android"],flat_name:"observer.os.type",ignore_above:1024,level:"extended",name:"type",normalize:[],original_fieldset:"os",short:"Which commercial OS family (one of: linux, macos, unix, windows, ios or android).",type:"keyword"},"observer.os.version":{dashed_name:"observer-os-version",description:"Operating system version as a raw string.",example:"10.14.1",flat_name:"observer.os.version",ignore_above:1024,level:"extended",name:"version",normalize:[],original_fieldset:"os",short:"Operating system version as a raw string.",type:"keyword"},"observer.product":{dashed_name:"observer-product",description:"The product name of the observer.",example:"s200",flat_name:"observer.product",ignore_above:1024,level:"extended",name:"product",normalize:[],short:"The product name of the observer.",type:"keyword"},"observer.serial_number":{dashed_name:"observer-serial-number",description:"Observer serial number.",flat_name:"observer.serial_number",ignore_above:1024,level:"extended",name:"serial_number",normalize:[],short:"Observer serial number.",type:"keyword"},"observer.type":{dashed_name:"observer-type",description:"The type of the observer the data is coming from.\nThere is no predefined list of observer types. Some examples are `forwarder`, `firewall`, `ids`, `ips`, `proxy`, `poller`, `sensor`, `APM server`.",example:"firewall",flat_name:"observer.type",ignore_above:1024,level:"core",name:"type",normalize:[],short:"The type of the observer the data is coming from.",type:"keyword"},"observer.vendor":{dashed_name:"observer-vendor",description:"Vendor name of the observer.",example:"Symantec",flat_name:"observer.vendor",ignore_above:1024,level:"core",name:"vendor",normalize:[],short:"Vendor name of the observer.",type:"keyword"},"observer.version":{dashed_name:"observer-version",description:"Observer version.",flat_name:"observer.version",ignore_above:1024,level:"core",name:"version",normalize:[],short:"Observer version.",type:"keyword"},"orchestrator.api_version":{dashed_name:"orchestrator-api-version",description:"API version being used to carry out the action",example:"v1beta1",flat_name:"orchestrator.api_version",ignore_above:1024,level:"extended",name:"api_version",normalize:[],short:"API version being used to carry out the action",type:"keyword"},"orchestrator.cluster.id":{dashed_name:"orchestrator-cluster-id",description:"Unique ID of the cluster.",flat_name:"orchestrator.cluster.id",ignore_above:1024,level:"extended",name:"cluster.id",normalize:[],short:"Unique ID of the cluster.",type:"keyword"},"orchestrator.cluster.name":{dashed_name:"orchestrator-cluster-name",description:"Name of the cluster.",flat_name:"orchestrator.cluster.name",ignore_above:1024,level:"extended",name:"cluster.name",normalize:[],short:"Name of the cluster.",type:"keyword"},"orchestrator.cluster.url":{dashed_name:"orchestrator-cluster-url",description:"URL of the API used to manage the cluster.",flat_name:"orchestrator.cluster.url",ignore_above:1024,level:"extended",name:"cluster.url",normalize:[],short:"URL of the API used to manage the cluster.",type:"keyword"},"orchestrator.cluster.version":{dashed_name:"orchestrator-cluster-version",description:"The version of the cluster.",flat_name:"orchestrator.cluster.version",ignore_above:1024,level:"extended",name:"cluster.version",normalize:[],short:"The version of the cluster.",type:"keyword"},"orchestrator.namespace":{dashed_name:"orchestrator-namespace",description:"Namespace in which the action is taking place.",example:"kube-system",flat_name:"orchestrator.namespace",ignore_above:1024,level:"extended",name:"namespace",normalize:[],short:"Namespace in which the action is taking place.",type:"keyword"},"orchestrator.organization":{dashed_name:"orchestrator-organization",description:"Organization affected by the event (for multi-tenant orchestrator setups).",example:"elastic",flat_name:"orchestrator.organization",ignore_above:1024,level:"extended",name:"organization",normalize:[],short:"Organization affected by the event (for multi-tenant orchestrator setups).",type:"keyword"},"orchestrator.resource.annotation":{dashed_name:"orchestrator-resource-annotation",description:"The list of annotations added to the resource.",example:"['key1:value1', 'key2:value2', 'key3:value3']",flat_name:"orchestrator.resource.annotation",ignore_above:1024,level:"extended",name:"resource.annotation",normalize:["array"],short:"The list of annotations added to the resource.",synthetic_source_keep:"none",type:"keyword"},"orchestrator.resource.id":{dashed_name:"orchestrator-resource-id",description:"Unique ID of the resource being acted upon.",flat_name:"orchestrator.resource.id",ignore_above:1024,level:"extended",name:"resource.id",normalize:[],short:"Unique ID of the resource being acted upon.",type:"keyword"},"orchestrator.resource.ip":{dashed_name:"orchestrator-resource-ip",description:"IP address assigned to the resource associated with the event being observed. In the case of a Kubernetes Pod, this array would contain only one element: the IP of the Pod (as opposed to the Node on which the Pod is running).",flat_name:"orchestrator.resource.ip",level:"extended",name:"resource.ip",normalize:["array"],short:"IP address assigned to the resource associated with the event being observed.",synthetic_source_keep:"none",type:"ip"},"orchestrator.resource.label":{dashed_name:"orchestrator-resource-label",description:"The list of labels added to the resource.",example:"['key1:value1', 'key2:value2', 'key3:value3']",flat_name:"orchestrator.resource.label",ignore_above:1024,level:"extended",name:"resource.label",normalize:["array"],short:"The list of labels added to the resource.",synthetic_source_keep:"none",type:"keyword"},"orchestrator.resource.name":{dashed_name:"orchestrator-resource-name",description:"Name of the resource being acted upon.",example:"test-pod-cdcws",flat_name:"orchestrator.resource.name",ignore_above:1024,level:"extended",name:"resource.name",normalize:[],short:"Name of the resource being acted upon.",type:"keyword"},"orchestrator.resource.parent.type":{dashed_name:"orchestrator-resource-parent-type",description:"Type or kind of the parent resource associated with the event being observed. In Kubernetes, this will be the name of a built-in workload resource (e.g., Deployment, StatefulSet, DaemonSet).",example:"DaemonSet",flat_name:"orchestrator.resource.parent.type",ignore_above:1024,level:"extended",name:"resource.parent.type",normalize:[],short:"Type or kind of the parent resource associated with the event being observed.",type:"keyword"},"orchestrator.resource.type":{dashed_name:"orchestrator-resource-type",description:"Type of resource being acted upon.",example:"service",flat_name:"orchestrator.resource.type",ignore_above:1024,level:"extended",name:"resource.type",normalize:[],short:"Type of resource being acted upon.",type:"keyword"},"orchestrator.type":{dashed_name:"orchestrator-type",description:"Orchestrator cluster type (e.g. kubernetes, nomad or cloudfoundry).",example:"kubernetes",flat_name:"orchestrator.type",ignore_above:1024,level:"extended",name:"type",normalize:[],short:"Orchestrator cluster type (e.g. kubernetes, nomad or cloudfoundry).",type:"keyword"},"organization.id":{dashed_name:"organization-id",description:"Unique identifier for the organization.",flat_name:"organization.id",ignore_above:1024,level:"extended",name:"id",normalize:[],short:"Unique identifier for the organization.",type:"keyword"},"organization.name":{dashed_name:"organization-name",description:"Organization name.",flat_name:"organization.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"organization.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],short:"Organization name.",type:"keyword"},"package.architecture":{dashed_name:"package-architecture",description:"Package architecture.",example:"x86_64",flat_name:"package.architecture",ignore_above:1024,level:"extended",name:"architecture",normalize:[],short:"Package architecture.",type:"keyword"},"package.build_version":{dashed_name:"package-build-version",description:"Additional information about the build version of the installed package.\nFor example use the commit SHA of a non-released package.",example:"36f4f7e89dd61b0988b12ee000b98966867710cd",flat_name:"package.build_version",ignore_above:1024,level:"extended",name:"build_version",normalize:[],short:"Build version information",type:"keyword"},"package.checksum":{dashed_name:"package-checksum",description:"Checksum of the installed package for verification.",example:"68b329da9893e34099c7d8ad5cb9c940",flat_name:"package.checksum",ignore_above:1024,level:"extended",name:"checksum",normalize:[],short:"Checksum of the installed package for verification.",type:"keyword"},"package.description":{dashed_name:"package-description",description:"Description of the package.",example:"Open source programming language to build simple/reliable/efficient software.",flat_name:"package.description",ignore_above:1024,level:"extended",name:"description",normalize:[],short:"Description of the package.",type:"keyword"},"package.install_scope":{dashed_name:"package-install-scope",description:"Indicating how the package was installed, e.g. user-local, global.",example:"global",flat_name:"package.install_scope",ignore_above:1024,level:"extended",name:"install_scope",normalize:[],short:"Indicating how the package was installed, e.g. user-local, global.",type:"keyword"},"package.installed":{dashed_name:"package-installed",description:"Time when package was installed.",flat_name:"package.installed",level:"extended",name:"installed",normalize:[],short:"Time when package was installed.",type:"date"},"package.license":{dashed_name:"package-license",description:"License under which the package was released.\nUse a short name, e.g. the license identifier from SPDX License List where possible (https://spdx.org/licenses/).",example:"Apache License 2.0",flat_name:"package.license",ignore_above:1024,level:"extended",name:"license",normalize:[],short:"Package license",type:"keyword"},"package.name":{dashed_name:"package-name",description:"Package name",example:"go",flat_name:"package.name",ignore_above:1024,level:"extended",name:"name",normalize:[],short:"Package name",type:"keyword"},"package.path":{dashed_name:"package-path",description:"Path where the package is installed.",example:"/usr/local/Cellar/go/1.12.9/",flat_name:"package.path",ignore_above:1024,level:"extended",name:"path",normalize:[],short:"Path where the package is installed.",type:"keyword"},"package.reference":{dashed_name:"package-reference",description:"Home page or reference URL of the software in this package, if available.",example:"https://golang.org",flat_name:"package.reference",ignore_above:1024,level:"extended",name:"reference",normalize:[],short:"Package home page or reference URL",type:"keyword"},"package.size":{dashed_name:"package-size",description:"Package size in bytes.",example:62231,flat_name:"package.size",format:"string",level:"extended",name:"size",normalize:[],short:"Package size in bytes.",type:"long"},"package.type":{dashed_name:"package-type",description:"Type of package.\nThis should contain the package file type, rather than the package manager name. Examples: rpm, dpkg, brew, npm, gem, nupkg, jar.",example:"rpm",flat_name:"package.type",ignore_above:1024,level:"extended",name:"type",normalize:[],short:"Package type",type:"keyword"},"package.version":{dashed_name:"package-version",description:"Package version",example:"1.12.9",flat_name:"package.version",ignore_above:1024,level:"extended",name:"version",normalize:[],short:"Package version",type:"keyword"},"process.args":{dashed_name:"process-args",description:"Array of process arguments, starting with the absolute path to the executable.\nMay be filtered to protect sensitive information.",example:'["/usr/bin/ssh", "-l", "user", "10.0.0.16"]',flat_name:"process.args",ignore_above:1024,level:"extended",name:"args",normalize:["array"],otel:[{attribute:"process.command_args",relation:"equivalent",stability:"experimental"}],short:"Array of process arguments.",type:"keyword"},"process.args_count":{dashed_name:"process-args-count",description:"Length of the process.args array.\nThis field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity.",example:4,flat_name:"process.args_count",level:"extended",name:"args_count",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Length of the process.args array.",type:"long"},"process.code_signature.digest_algorithm":{dashed_name:"process-code-signature-digest-algorithm",description:"The hashing algorithm used to sign the process.\nThis value can distinguish signatures when a file is signed multiple times by the same signer but with a different digest algorithm.",example:"sha256",flat_name:"process.code_signature.digest_algorithm",ignore_above:1024,level:"extended",name:"digest_algorithm",normalize:[],original_fieldset:"code_signature",short:"Hashing algorithm used to sign the process.",type:"keyword"},"process.code_signature.exists":{dashed_name:"process-code-signature-exists",description:"Boolean to capture if a signature is present.",example:"true",flat_name:"process.code_signature.exists",level:"core",name:"exists",normalize:[],original_fieldset:"code_signature",short:"Boolean to capture if a signature is present.",type:"boolean"},"process.code_signature.flags":{beta:"This field is beta and subject to change.",dashed_name:"process-code-signature-flags",description:"The flags used to sign the process.",example:570522385,flat_name:"process.code_signature.flags",ignore_above:1024,level:"extended",name:"flags",normalize:[],original_fieldset:"code_signature",short:"Code signing flags of the process",type:"keyword"},"process.code_signature.signing_id":{dashed_name:"process-code-signature-signing-id",description:"The identifier used to sign the process.\nThis is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only.",example:"com.apple.xpc.proxy",flat_name:"process.code_signature.signing_id",ignore_above:1024,level:"extended",name:"signing_id",normalize:[],original_fieldset:"code_signature",short:"The identifier used to sign the process.",type:"keyword"},"process.code_signature.status":{dashed_name:"process-code-signature-status",description:"Additional information about the certificate status.\nThis is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.",example:"ERROR_UNTRUSTED_ROOT",flat_name:"process.code_signature.status",ignore_above:1024,level:"extended",name:"status",normalize:[],original_fieldset:"code_signature",short:"Additional information about the certificate status.",type:"keyword"},"process.code_signature.subject_name":{dashed_name:"process-code-signature-subject-name",description:"Subject name of the code signer",example:"Microsoft Corporation",flat_name:"process.code_signature.subject_name",ignore_above:1024,level:"core",name:"subject_name",normalize:[],original_fieldset:"code_signature",short:"Subject name of the code signer",type:"keyword"},"process.code_signature.team_id":{dashed_name:"process-code-signature-team-id",description:"The team identifier used to sign the process.\nThis is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only.",example:"EQHXZ8M8AV",flat_name:"process.code_signature.team_id",ignore_above:1024,level:"extended",name:"team_id",normalize:[],original_fieldset:"code_signature",short:"The team identifier used to sign the process.",type:"keyword"},"process.code_signature.timestamp":{dashed_name:"process-code-signature-timestamp",description:"Date and time when the code signature was generated and signed.",example:"2021-01-01T12:10:30Z",flat_name:"process.code_signature.timestamp",level:"extended",name:"timestamp",normalize:[],original_fieldset:"code_signature",short:"When the signature was generated and signed.",type:"date"},"process.code_signature.trusted":{dashed_name:"process-code-signature-trusted",description:"Stores the trust status of the certificate chain.\nValidating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.",example:"true",flat_name:"process.code_signature.trusted",level:"extended",name:"trusted",normalize:[],original_fieldset:"code_signature",short:"Stores the trust status of the certificate chain.",type:"boolean"},"process.code_signature.valid":{dashed_name:"process-code-signature-valid",description:"Boolean to capture if the digital signature is verified against the binary content.\nLeave unpopulated if a certificate was unchecked.",example:"true",flat_name:"process.code_signature.valid",level:"extended",name:"valid",normalize:[],original_fieldset:"code_signature",short:"Boolean to capture if the digital signature is verified against the binary content.",type:"boolean"},"process.command_line":{dashed_name:"process-command-line",description:"Full command line that started the process, including the absolute path to the executable, and all arguments.\nSome arguments may be filtered to protect sensitive information.",example:"/usr/bin/ssh -l user 10.0.0.16",flat_name:"process.command_line",level:"extended",multi_fields:[{flat_name:"process.command_line.text",name:"text",type:"match_only_text"}],name:"command_line",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Full command line that started the process.",type:"wildcard"},"process.elf.architecture":{dashed_name:"process-elf-architecture",description:"Machine architecture of the ELF file.",example:"x86-64",flat_name:"process.elf.architecture",ignore_above:1024,level:"extended",name:"architecture",normalize:[],original_fieldset:"elf",short:"Machine architecture of the ELF file.",type:"keyword"},"process.elf.byte_order":{dashed_name:"process-elf-byte-order",description:"Byte sequence of ELF file.",example:"Little Endian",flat_name:"process.elf.byte_order",ignore_above:1024,level:"extended",name:"byte_order",normalize:[],original_fieldset:"elf",short:"Byte sequence of ELF file.",type:"keyword"},"process.elf.cpu_type":{dashed_name:"process-elf-cpu-type",description:"CPU type of the ELF file.",example:"Intel",flat_name:"process.elf.cpu_type",ignore_above:1024,level:"extended",name:"cpu_type",normalize:[],original_fieldset:"elf",short:"CPU type of the ELF file.",type:"keyword"},"process.elf.creation_date":{dashed_name:"process-elf-creation-date",description:"Extracted when possible from the file's metadata. Indicates when it was built or compiled. It can also be faked by malware creators.",flat_name:"process.elf.creation_date",level:"extended",name:"creation_date",normalize:[],original_fieldset:"elf",short:"Build or compile date.",type:"date"},"process.elf.exports":{dashed_name:"process-elf-exports",description:"List of exported element names and types.",flat_name:"process.elf.exports",level:"extended",name:"exports",normalize:["array"],original_fieldset:"elf",short:"List of exported element names and types.",type:"flattened"},"process.elf.go_import_hash":{dashed_name:"process-elf-go-import-hash",description:"A hash of the Go language imports in an ELF file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThe algorithm used to calculate the Go symbol hash and a reference implementation are available here: https://github.com/elastic/toutoumomoma",example:"10bddcb4cee42080f76c88d9ff964491",flat_name:"process.elf.go_import_hash",ignore_above:1024,level:"extended",name:"go_import_hash",normalize:[],original_fieldset:"elf",short:"A hash of the Go language imports in an ELF file.",type:"keyword"},"process.elf.go_imports":{dashed_name:"process-elf-go-imports",description:"List of imported Go language element names and types.",flat_name:"process.elf.go_imports",level:"extended",name:"go_imports",normalize:[],original_fieldset:"elf",short:"List of imported Go language element names and types.",type:"flattened"},"process.elf.go_imports_names_entropy":{dashed_name:"process-elf-go-imports-names-entropy",description:"Shannon entropy calculation from the list of Go imports.",flat_name:"process.elf.go_imports_names_entropy",format:"number",level:"extended",name:"go_imports_names_entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the list of Go imports.",type:"long"},"process.elf.go_imports_names_var_entropy":{dashed_name:"process-elf-go-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of Go imports.",flat_name:"process.elf.go_imports_names_var_entropy",format:"number",level:"extended",name:"go_imports_names_var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the list of Go imports.",type:"long"},"process.elf.go_stripped":{dashed_name:"process-elf-go-stripped",description:"Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.",flat_name:"process.elf.go_stripped",level:"extended",name:"go_stripped",normalize:[],original_fieldset:"elf",short:"Whether the file is a stripped or obfuscated Go executable.",type:"boolean"},"process.elf.header.abi_version":{dashed_name:"process-elf-header-abi-version",description:"Version of the ELF Application Binary Interface (ABI).",flat_name:"process.elf.header.abi_version",ignore_above:1024,level:"extended",name:"header.abi_version",normalize:[],original_fieldset:"elf",short:"Version of the ELF Application Binary Interface (ABI).",type:"keyword"},"process.elf.header.class":{dashed_name:"process-elf-header-class",description:"Header class of the ELF file.",flat_name:"process.elf.header.class",ignore_above:1024,level:"extended",name:"header.class",normalize:[],original_fieldset:"elf",short:"Header class of the ELF file.",type:"keyword"},"process.elf.header.data":{dashed_name:"process-elf-header-data",description:"Data table of the ELF header.",flat_name:"process.elf.header.data",ignore_above:1024,level:"extended",name:"header.data",normalize:[],original_fieldset:"elf",short:"Data table of the ELF header.",type:"keyword"},"process.elf.header.entrypoint":{dashed_name:"process-elf-header-entrypoint",description:"Header entrypoint of the ELF file.",flat_name:"process.elf.header.entrypoint",format:"string",level:"extended",name:"header.entrypoint",normalize:[],original_fieldset:"elf",short:"Header entrypoint of the ELF file.",type:"long"},"process.elf.header.object_version":{dashed_name:"process-elf-header-object-version",description:'"0x1" for original ELF files.',flat_name:"process.elf.header.object_version",ignore_above:1024,level:"extended",name:"header.object_version",normalize:[],original_fieldset:"elf",short:'"0x1" for original ELF files.',type:"keyword"},"process.elf.header.os_abi":{dashed_name:"process-elf-header-os-abi",description:"Application Binary Interface (ABI) of the Linux OS.",flat_name:"process.elf.header.os_abi",ignore_above:1024,level:"extended",name:"header.os_abi",normalize:[],original_fieldset:"elf",short:"Application Binary Interface (ABI) of the Linux OS.",type:"keyword"},"process.elf.header.type":{dashed_name:"process-elf-header-type",description:"Header type of the ELF file.",flat_name:"process.elf.header.type",ignore_above:1024,level:"extended",name:"header.type",normalize:[],original_fieldset:"elf",short:"Header type of the ELF file.",type:"keyword"},"process.elf.header.version":{dashed_name:"process-elf-header-version",description:"Version of the ELF header.",flat_name:"process.elf.header.version",ignore_above:1024,level:"extended",name:"header.version",normalize:[],original_fieldset:"elf",short:"Version of the ELF header.",type:"keyword"},"process.elf.import_hash":{dashed_name:"process-elf-import-hash",description:"A hash of the imports in an ELF file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is an ELF implementation of the Windows PE imphash.",example:"d41d8cd98f00b204e9800998ecf8427e",flat_name:"process.elf.import_hash",ignore_above:1024,level:"extended",name:"import_hash",normalize:[],original_fieldset:"elf",short:"A hash of the imports in an ELF file.",type:"keyword"},"process.elf.imports":{dashed_name:"process-elf-imports",description:"List of imported element names and types.",flat_name:"process.elf.imports",level:"extended",name:"imports",normalize:["array"],original_fieldset:"elf",short:"List of imported element names and types.",type:"flattened"},"process.elf.imports_names_entropy":{dashed_name:"process-elf-imports-names-entropy",description:"Shannon entropy calculation from the list of imported element names and types.",flat_name:"process.elf.imports_names_entropy",format:"number",level:"extended",name:"imports_names_entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the list of imported element names and types.",type:"long"},"process.elf.imports_names_var_entropy":{dashed_name:"process-elf-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of imported element names and types.",flat_name:"process.elf.imports_names_var_entropy",format:"number",level:"extended",name:"imports_names_var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the list of imported element names and types.",type:"long"},"process.elf.sections":{dashed_name:"process-elf-sections",description:"An array containing an object for each section of the ELF file.\nThe keys that should be present in these objects are defined by sub-fields underneath `elf.sections.*`.",flat_name:"process.elf.sections",level:"extended",name:"sections",normalize:["array"],original_fieldset:"elf",short:"Section information of the ELF file.",type:"nested"},"process.elf.sections.chi2":{dashed_name:"process-elf-sections-chi2",description:"Chi-square probability distribution of the section.",flat_name:"process.elf.sections.chi2",format:"number",level:"extended",name:"sections.chi2",normalize:[],original_fieldset:"elf",short:"Chi-square probability distribution of the section.",type:"long"},"process.elf.sections.entropy":{dashed_name:"process-elf-sections-entropy",description:"Shannon entropy calculation from the section.",flat_name:"process.elf.sections.entropy",format:"number",level:"extended",name:"sections.entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the section.",type:"long"},"process.elf.sections.flags":{dashed_name:"process-elf-sections-flags",description:"ELF Section List flags.",flat_name:"process.elf.sections.flags",ignore_above:1024,level:"extended",name:"sections.flags",normalize:[],original_fieldset:"elf",short:"ELF Section List flags.",type:"keyword"},"process.elf.sections.name":{dashed_name:"process-elf-sections-name",description:"ELF Section List name.",flat_name:"process.elf.sections.name",ignore_above:1024,level:"extended",name:"sections.name",normalize:[],original_fieldset:"elf",short:"ELF Section List name.",type:"keyword"},"process.elf.sections.physical_offset":{dashed_name:"process-elf-sections-physical-offset",description:"ELF Section List offset.",flat_name:"process.elf.sections.physical_offset",ignore_above:1024,level:"extended",name:"sections.physical_offset",normalize:[],original_fieldset:"elf",short:"ELF Section List offset.",type:"keyword"},"process.elf.sections.physical_size":{dashed_name:"process-elf-sections-physical-size",description:"ELF Section List physical size.",flat_name:"process.elf.sections.physical_size",format:"bytes",level:"extended",name:"sections.physical_size",normalize:[],original_fieldset:"elf",short:"ELF Section List physical size.",type:"long"},"process.elf.sections.type":{dashed_name:"process-elf-sections-type",description:"ELF Section List type.",flat_name:"process.elf.sections.type",ignore_above:1024,level:"extended",name:"sections.type",normalize:[],original_fieldset:"elf",short:"ELF Section List type.",type:"keyword"},"process.elf.sections.var_entropy":{dashed_name:"process-elf-sections-var-entropy",description:"Variance for Shannon entropy calculation from the section.",flat_name:"process.elf.sections.var_entropy",format:"number",level:"extended",name:"sections.var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the section.",type:"long"},"process.elf.sections.virtual_address":{dashed_name:"process-elf-sections-virtual-address",description:"ELF Section List virtual address.",flat_name:"process.elf.sections.virtual_address",format:"string",level:"extended",name:"sections.virtual_address",normalize:[],original_fieldset:"elf",short:"ELF Section List virtual address.",type:"long"},"process.elf.sections.virtual_size":{dashed_name:"process-elf-sections-virtual-size",description:"ELF Section List virtual size.",flat_name:"process.elf.sections.virtual_size",format:"string",level:"extended",name:"sections.virtual_size",normalize:[],original_fieldset:"elf",short:"ELF Section List virtual size.",type:"long"},"process.elf.segments":{dashed_name:"process-elf-segments",description:"An array containing an object for each segment of the ELF file.\nThe keys that should be present in these objects are defined by sub-fields underneath `elf.segments.*`.",flat_name:"process.elf.segments",level:"extended",name:"segments",normalize:["array"],original_fieldset:"elf",short:"ELF object segment list.",type:"nested"},"process.elf.segments.sections":{dashed_name:"process-elf-segments-sections",description:"ELF object segment sections.",flat_name:"process.elf.segments.sections",ignore_above:1024,level:"extended",name:"segments.sections",normalize:[],original_fieldset:"elf",short:"ELF object segment sections.",type:"keyword"},"process.elf.segments.type":{dashed_name:"process-elf-segments-type",description:"ELF object segment type.",flat_name:"process.elf.segments.type",ignore_above:1024,level:"extended",name:"segments.type",normalize:[],original_fieldset:"elf",short:"ELF object segment type.",type:"keyword"},"process.elf.shared_libraries":{dashed_name:"process-elf-shared-libraries",description:"List of shared libraries used by this ELF object.",flat_name:"process.elf.shared_libraries",ignore_above:1024,level:"extended",name:"shared_libraries",normalize:["array"],original_fieldset:"elf",short:"List of shared libraries used by this ELF object.",type:"keyword"},"process.elf.telfhash":{dashed_name:"process-elf-telfhash",description:"telfhash symbol hash for ELF file.",flat_name:"process.elf.telfhash",ignore_above:1024,level:"extended",name:"telfhash",normalize:[],original_fieldset:"elf",short:"telfhash hash for ELF file.",type:"keyword"},"process.end":{dashed_name:"process-end",description:"The time the process ended.",example:"2016-05-23T08:05:34.853Z",flat_name:"process.end",level:"extended",name:"end",normalize:[],short:"The time the process ended.",type:"date"},"process.entity_id":{dashed_name:"process-entity-id",description:"Unique identifier for the process.\nThe implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process.\nConstructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.",example:"c2c455d9f99375d",flat_name:"process.entity_id",ignore_above:1024,level:"extended",name:"entity_id",normalize:[],short:"Unique identifier for the process.",type:"keyword"},"process.entry_leader.args":{dashed_name:"process-entry-leader-args",description:"Array of process arguments, starting with the absolute path to the executable.\nMay be filtered to protect sensitive information.",example:'["/usr/bin/ssh", "-l", "user", "10.0.0.16"]',flat_name:"process.entry_leader.args",ignore_above:1024,level:"extended",name:"args",normalize:["array"],original_fieldset:"process",short:"Array of process arguments.",type:"keyword"},"process.entry_leader.args_count":{dashed_name:"process-entry-leader-args-count",description:"Length of the process.args array.\nThis field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity.",example:4,flat_name:"process.entry_leader.args_count",level:"extended",name:"args_count",normalize:[],original_fieldset:"process",short:"Length of the process.args array.",type:"long"},"process.entry_leader.attested_groups.name":{dashed_name:"process-entry-leader-attested-groups-name",description:"Name of the group.",flat_name:"process.entry_leader.attested_groups.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.entry_leader.attested_user.id":{dashed_name:"process-entry-leader-attested-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.entry_leader.attested_user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"process.entry_leader.attested_user.name":{dashed_name:"process-entry-leader-attested-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.entry_leader.attested_user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.entry_leader.attested_user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"process.entry_leader.command_line":{dashed_name:"process-entry-leader-command-line",description:"Full command line that started the process, including the absolute path to the executable, and all arguments.\nSome arguments may be filtered to protect sensitive information.",example:"/usr/bin/ssh -l user 10.0.0.16",flat_name:"process.entry_leader.command_line",level:"extended",multi_fields:[{flat_name:"process.entry_leader.command_line.text",name:"text",type:"match_only_text"}],name:"command_line",normalize:[],original_fieldset:"process",short:"Full command line that started the process.",type:"wildcard"},"process.entry_leader.entity_id":{dashed_name:"process-entry-leader-entity-id",description:"Unique identifier for the process.\nThe implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process.\nConstructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.",example:"c2c455d9f99375d",flat_name:"process.entry_leader.entity_id",ignore_above:1024,level:"extended",name:"entity_id",normalize:[],original_fieldset:"process",short:"Unique identifier for the process.",type:"keyword"},"process.entry_leader.entry_meta.source.ip":{dashed_name:"process-entry-leader-entry-meta-source-ip",description:"IP address of the source (IPv4 or IPv6).",flat_name:"process.entry_leader.entry_meta.source.ip",level:"core",name:"ip",normalize:[],original_fieldset:"source",short:"IP address of the source.",type:"ip"},"process.entry_leader.entry_meta.type":{dashed_name:"process-entry-leader-entry-meta-type",description:"The entry type for the entry session leader. Values include: init(e.g systemd), sshd, ssm, kubelet, teleport, terminal, console\nNote: This field is only set on process.session_leader.",flat_name:"process.entry_leader.entry_meta.type",ignore_above:1024,level:"extended",name:"entry_meta.type",normalize:[],original_fieldset:"process",short:"The entry type for the entry session leader.",type:"keyword"},"process.entry_leader.executable":{dashed_name:"process-entry-leader-executable",description:"Absolute path to the process executable.",example:"/usr/bin/ssh",flat_name:"process.entry_leader.executable",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.entry_leader.executable.text",name:"text",type:"match_only_text"}],name:"executable",normalize:[],original_fieldset:"process",short:"Absolute path to the process executable.",type:"keyword"},"process.entry_leader.group.id":{dashed_name:"process-entry-leader-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.entry_leader.group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.entry_leader.group.name":{dashed_name:"process-entry-leader-group-name",description:"Name of the group.",flat_name:"process.entry_leader.group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.entry_leader.interactive":{dashed_name:"process-entry-leader-interactive",description:"Whether the process is connected to an interactive shell.\nProcess interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive.\nNote: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY.",example:!0,flat_name:"process.entry_leader.interactive",level:"extended",name:"interactive",normalize:[],original_fieldset:"process",short:"Whether the process is connected to an interactive shell.",type:"boolean"},"process.entry_leader.name":{dashed_name:"process-entry-leader-name",description:"Process name.\nSometimes called program name or similar.",example:"ssh",flat_name:"process.entry_leader.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.entry_leader.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"process",short:"Process name.",type:"keyword"},"process.entry_leader.parent.entity_id":{dashed_name:"process-entry-leader-parent-entity-id",description:"Unique identifier for the process.\nThe implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process.\nConstructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.",example:"c2c455d9f99375d",flat_name:"process.entry_leader.parent.entity_id",ignore_above:1024,level:"extended",name:"entity_id",normalize:[],original_fieldset:"process",short:"Unique identifier for the process.",type:"keyword"},"process.entry_leader.parent.pid":{dashed_name:"process-entry-leader-parent-pid",description:"Process id.",example:4242,flat_name:"process.entry_leader.parent.pid",format:"string",level:"core",name:"pid",normalize:[],original_fieldset:"process",short:"Process id.",type:"long"},"process.entry_leader.parent.session_leader.entity_id":{dashed_name:"process-entry-leader-parent-session-leader-entity-id",description:"Unique identifier for the process.\nThe implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process.\nConstructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.",example:"c2c455d9f99375d",flat_name:"process.entry_leader.parent.session_leader.entity_id",ignore_above:1024,level:"extended",name:"entity_id",normalize:[],original_fieldset:"process",short:"Unique identifier for the process.",type:"keyword"},"process.entry_leader.parent.session_leader.pid":{dashed_name:"process-entry-leader-parent-session-leader-pid",description:"Process id.",example:4242,flat_name:"process.entry_leader.parent.session_leader.pid",format:"string",level:"core",name:"pid",normalize:[],original_fieldset:"process",short:"Process id.",type:"long"},"process.entry_leader.parent.session_leader.start":{dashed_name:"process-entry-leader-parent-session-leader-start",description:"The time the process started.",example:"2016-05-23T08:05:34.853Z",flat_name:"process.entry_leader.parent.session_leader.start",level:"extended",name:"start",normalize:[],original_fieldset:"process",short:"The time the process started.",type:"date"},"process.entry_leader.parent.session_leader.vpid":{dashed_name:"process-entry-leader-parent-session-leader-vpid",description:"Virtual process id.\nThe process id within a pid namespace. This is not necessarily unique across all processes on the host but it is unique within the process namespace that the process exists within.",example:4242,flat_name:"process.entry_leader.parent.session_leader.vpid",format:"string",level:"core",name:"vpid",normalize:[],original_fieldset:"process",short:"Virtual process id.",type:"long"},"process.entry_leader.parent.start":{dashed_name:"process-entry-leader-parent-start",description:"The time the process started.",example:"2016-05-23T08:05:34.853Z",flat_name:"process.entry_leader.parent.start",level:"extended",name:"start",normalize:[],original_fieldset:"process",short:"The time the process started.",type:"date"},"process.entry_leader.parent.vpid":{dashed_name:"process-entry-leader-parent-vpid",description:"Virtual process id.\nThe process id within a pid namespace. This is not necessarily unique across all processes on the host but it is unique within the process namespace that the process exists within.",example:4242,flat_name:"process.entry_leader.parent.vpid",format:"string",level:"core",name:"vpid",normalize:[],original_fieldset:"process",short:"Virtual process id.",type:"long"},"process.entry_leader.pid":{dashed_name:"process-entry-leader-pid",description:"Process id.",example:4242,flat_name:"process.entry_leader.pid",format:"string",level:"core",name:"pid",normalize:[],original_fieldset:"process",short:"Process id.",type:"long"},"process.entry_leader.real_group.id":{dashed_name:"process-entry-leader-real-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.entry_leader.real_group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.entry_leader.real_group.name":{dashed_name:"process-entry-leader-real-group-name",description:"Name of the group.",flat_name:"process.entry_leader.real_group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.entry_leader.real_user.id":{dashed_name:"process-entry-leader-real-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.entry_leader.real_user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"process.entry_leader.real_user.name":{dashed_name:"process-entry-leader-real-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.entry_leader.real_user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.entry_leader.real_user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"process.entry_leader.same_as_process":{dashed_name:"process-entry-leader-same-as-process",description:"This boolean is used to identify if a leader process is the same as the top level process.\nFor example, if `process.group_leader.same_as_process = true`, it means the process event in question is the leader of its process group. Details under `process.*` like `pid` would be the same under `process.group_leader.*` The same applies for both `process.session_leader` and `process.entry_leader`.\nThis field exists to the benefit of EQL and other rule engines since it's not possible to compare equality between two fields in a single document. e.g `process.entity_id` = `process.group_leader.entity_id` (top level process is the process group leader) OR `process.entity_id` = `process.entry_leader.entity_id` (top level process is the entry session leader)\nInstead these rules could be written like: `process.group_leader.same_as_process: true` OR `process.entry_leader.same_as_process: true`\nNote: This field is only set on `process.entry_leader`, `process.session_leader` and `process.group_leader`.",example:!0,flat_name:"process.entry_leader.same_as_process",level:"extended",name:"same_as_process",normalize:[],original_fieldset:"process",short:"This boolean is used to identify if a leader process is the same as the top level process.",type:"boolean"},"process.entry_leader.saved_group.id":{dashed_name:"process-entry-leader-saved-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.entry_leader.saved_group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.entry_leader.saved_group.name":{dashed_name:"process-entry-leader-saved-group-name",description:"Name of the group.",flat_name:"process.entry_leader.saved_group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.entry_leader.saved_user.id":{dashed_name:"process-entry-leader-saved-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.entry_leader.saved_user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"process.entry_leader.saved_user.name":{dashed_name:"process-entry-leader-saved-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.entry_leader.saved_user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.entry_leader.saved_user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"process.entry_leader.start":{dashed_name:"process-entry-leader-start",description:"The time the process started.",example:"2016-05-23T08:05:34.853Z",flat_name:"process.entry_leader.start",level:"extended",name:"start",normalize:[],original_fieldset:"process",short:"The time the process started.",type:"date"},"process.entry_leader.supplemental_groups.id":{dashed_name:"process-entry-leader-supplemental-groups-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.entry_leader.supplemental_groups.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.entry_leader.supplemental_groups.name":{dashed_name:"process-entry-leader-supplemental-groups-name",description:"Name of the group.",flat_name:"process.entry_leader.supplemental_groups.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.entry_leader.tty":{dashed_name:"process-entry-leader-tty",description:"Information about the controlling TTY device. If set, the process belongs to an interactive session.",flat_name:"process.entry_leader.tty",level:"extended",name:"tty",normalize:[],original_fieldset:"process",short:"Information about the controlling TTY device.",type:"object"},"process.entry_leader.tty.char_device.major":{dashed_name:"process-entry-leader-tty-char-device-major",description:'The major number identifies the driver associated with the device. The character device\'s major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation.',example:4,flat_name:"process.entry_leader.tty.char_device.major",level:"extended",name:"tty.char_device.major",normalize:[],original_fieldset:"process",short:"The TTY character device's major number.",type:"long"},"process.entry_leader.tty.char_device.minor":{dashed_name:"process-entry-leader-tty-char-device-minor",description:"The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them.",example:1,flat_name:"process.entry_leader.tty.char_device.minor",level:"extended",name:"tty.char_device.minor",normalize:[],original_fieldset:"process",short:"The TTY character device's minor number.",type:"long"},"process.entry_leader.user.id":{dashed_name:"process-entry-leader-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.entry_leader.user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"process.entry_leader.user.name":{dashed_name:"process-entry-leader-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.entry_leader.user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.entry_leader.user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"process.entry_leader.vpid":{dashed_name:"process-entry-leader-vpid",description:"Virtual process id.\nThe process id within a pid namespace. This is not necessarily unique across all processes on the host but it is unique within the process namespace that the process exists within.",example:4242,flat_name:"process.entry_leader.vpid",format:"string",level:"core",name:"vpid",normalize:[],original_fieldset:"process",short:"Virtual process id.",type:"long"},"process.entry_leader.working_directory":{dashed_name:"process-entry-leader-working-directory",description:"The working directory of the process.",example:"/home/alice",flat_name:"process.entry_leader.working_directory",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.entry_leader.working_directory.text",name:"text",type:"match_only_text"}],name:"working_directory",normalize:[],original_fieldset:"process",short:"The working directory of the process.",type:"keyword"},"process.env_vars":{dashed_name:"process-env-vars",description:"Array of environment variable bindings. Captured from a snapshot of the environment at the time of execution.\nMay be filtered to protect sensitive information.",example:'["PATH=/usr/local/bin:/usr/bin", "USER=ubuntu"]',flat_name:"process.env_vars",ignore_above:1024,level:"extended",name:"env_vars",normalize:["array"],short:"Array of environment variable bindings.",synthetic_source_keep:"none",type:"keyword"},"process.executable":{dashed_name:"process-executable",description:"Absolute path to the process executable.",example:"/usr/bin/ssh",flat_name:"process.executable",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.executable.text",name:"text",type:"match_only_text"}],name:"executable",normalize:[],otel:[{attribute:"process.executable.path",relation:"equivalent",stability:"experimental"}],short:"Absolute path to the process executable.",type:"keyword"},"process.exit_code":{dashed_name:"process-exit-code",description:"The exit code of the process, if this is a termination event.\nThe field should be absent if there is no exit code for the event (e.g. process start).",example:137,flat_name:"process.exit_code",level:"extended",name:"exit_code",normalize:[],short:"The exit code of the process.",type:"long"},"process.group.id":{dashed_name:"process-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.group.name":{dashed_name:"process-group-name",description:"Name of the group.",flat_name:"process.group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.group_leader.args":{dashed_name:"process-group-leader-args",description:"Array of process arguments, starting with the absolute path to the executable.\nMay be filtered to protect sensitive information.",example:'["/usr/bin/ssh", "-l", "user", "10.0.0.16"]',flat_name:"process.group_leader.args",ignore_above:1024,level:"extended",name:"args",normalize:["array"],original_fieldset:"process",short:"Array of process arguments.",type:"keyword"},"process.group_leader.args_count":{dashed_name:"process-group-leader-args-count",description:"Length of the process.args array.\nThis field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity.",example:4,flat_name:"process.group_leader.args_count",level:"extended",name:"args_count",normalize:[],original_fieldset:"process",short:"Length of the process.args array.",type:"long"},"process.group_leader.command_line":{dashed_name:"process-group-leader-command-line",description:"Full command line that started the process, including the absolute path to the executable, and all arguments.\nSome arguments may be filtered to protect sensitive information.",example:"/usr/bin/ssh -l user 10.0.0.16",flat_name:"process.group_leader.command_line",level:"extended",multi_fields:[{flat_name:"process.group_leader.command_line.text",name:"text",type:"match_only_text"}],name:"command_line",normalize:[],original_fieldset:"process",short:"Full command line that started the process.",type:"wildcard"},"process.group_leader.entity_id":{dashed_name:"process-group-leader-entity-id",description:"Unique identifier for the process.\nThe implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process.\nConstructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.",example:"c2c455d9f99375d",flat_name:"process.group_leader.entity_id",ignore_above:1024,level:"extended",name:"entity_id",normalize:[],original_fieldset:"process",short:"Unique identifier for the process.",type:"keyword"},"process.group_leader.executable":{dashed_name:"process-group-leader-executable",description:"Absolute path to the process executable.",example:"/usr/bin/ssh",flat_name:"process.group_leader.executable",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.group_leader.executable.text",name:"text",type:"match_only_text"}],name:"executable",normalize:[],original_fieldset:"process",short:"Absolute path to the process executable.",type:"keyword"},"process.group_leader.group.id":{dashed_name:"process-group-leader-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.group_leader.group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.group_leader.group.name":{dashed_name:"process-group-leader-group-name",description:"Name of the group.",flat_name:"process.group_leader.group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.group_leader.interactive":{dashed_name:"process-group-leader-interactive",description:"Whether the process is connected to an interactive shell.\nProcess interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive.\nNote: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY.",example:!0,flat_name:"process.group_leader.interactive",level:"extended",name:"interactive",normalize:[],original_fieldset:"process",short:"Whether the process is connected to an interactive shell.",type:"boolean"},"process.group_leader.name":{dashed_name:"process-group-leader-name",description:"Process name.\nSometimes called program name or similar.",example:"ssh",flat_name:"process.group_leader.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.group_leader.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"process",short:"Process name.",type:"keyword"},"process.group_leader.pid":{dashed_name:"process-group-leader-pid",description:"Process id.",example:4242,flat_name:"process.group_leader.pid",format:"string",level:"core",name:"pid",normalize:[],original_fieldset:"process",otel:[{relation:"match",stability:"experimental"}],short:"Process id.",type:"long"},"process.group_leader.real_group.id":{dashed_name:"process-group-leader-real-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.group_leader.real_group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.group_leader.real_group.name":{dashed_name:"process-group-leader-real-group-name",description:"Name of the group.",flat_name:"process.group_leader.real_group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.group_leader.real_user.id":{dashed_name:"process-group-leader-real-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.group_leader.real_user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"process.group_leader.real_user.name":{dashed_name:"process-group-leader-real-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.group_leader.real_user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.group_leader.real_user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"process.group_leader.same_as_process":{dashed_name:"process-group-leader-same-as-process",description:"This boolean is used to identify if a leader process is the same as the top level process.\nFor example, if `process.group_leader.same_as_process = true`, it means the process event in question is the leader of its process group. Details under `process.*` like `pid` would be the same under `process.group_leader.*` The same applies for both `process.session_leader` and `process.entry_leader`.\nThis field exists to the benefit of EQL and other rule engines since it's not possible to compare equality between two fields in a single document. e.g `process.entity_id` = `process.group_leader.entity_id` (top level process is the process group leader) OR `process.entity_id` = `process.entry_leader.entity_id` (top level process is the entry session leader)\nInstead these rules could be written like: `process.group_leader.same_as_process: true` OR `process.entry_leader.same_as_process: true`\nNote: This field is only set on `process.entry_leader`, `process.session_leader` and `process.group_leader`.",example:!0,flat_name:"process.group_leader.same_as_process",level:"extended",name:"same_as_process",normalize:[],original_fieldset:"process",short:"This boolean is used to identify if a leader process is the same as the top level process.",type:"boolean"},"process.group_leader.saved_group.id":{dashed_name:"process-group-leader-saved-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.group_leader.saved_group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.group_leader.saved_group.name":{dashed_name:"process-group-leader-saved-group-name",description:"Name of the group.",flat_name:"process.group_leader.saved_group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.group_leader.saved_user.id":{dashed_name:"process-group-leader-saved-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.group_leader.saved_user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"process.group_leader.saved_user.name":{dashed_name:"process-group-leader-saved-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.group_leader.saved_user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.group_leader.saved_user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"process.group_leader.start":{dashed_name:"process-group-leader-start",description:"The time the process started.",example:"2016-05-23T08:05:34.853Z",flat_name:"process.group_leader.start",level:"extended",name:"start",normalize:[],original_fieldset:"process",short:"The time the process started.",type:"date"},"process.group_leader.supplemental_groups.id":{dashed_name:"process-group-leader-supplemental-groups-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.group_leader.supplemental_groups.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.group_leader.supplemental_groups.name":{dashed_name:"process-group-leader-supplemental-groups-name",description:"Name of the group.",flat_name:"process.group_leader.supplemental_groups.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.group_leader.tty":{dashed_name:"process-group-leader-tty",description:"Information about the controlling TTY device. If set, the process belongs to an interactive session.",flat_name:"process.group_leader.tty",level:"extended",name:"tty",normalize:[],original_fieldset:"process",short:"Information about the controlling TTY device.",type:"object"},"process.group_leader.tty.char_device.major":{dashed_name:"process-group-leader-tty-char-device-major",description:'The major number identifies the driver associated with the device. The character device\'s major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation.',example:4,flat_name:"process.group_leader.tty.char_device.major",level:"extended",name:"tty.char_device.major",normalize:[],original_fieldset:"process",short:"The TTY character device's major number.",type:"long"},"process.group_leader.tty.char_device.minor":{dashed_name:"process-group-leader-tty-char-device-minor",description:"The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them.",example:1,flat_name:"process.group_leader.tty.char_device.minor",level:"extended",name:"tty.char_device.minor",normalize:[],original_fieldset:"process",short:"The TTY character device's minor number.",type:"long"},"process.group_leader.user.id":{dashed_name:"process-group-leader-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.group_leader.user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"process.group_leader.user.name":{dashed_name:"process-group-leader-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.group_leader.user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.group_leader.user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"process.group_leader.vpid":{dashed_name:"process-group-leader-vpid",description:"Virtual process id.\nThe process id within a pid namespace. This is not necessarily unique across all processes on the host but it is unique within the process namespace that the process exists within.",example:4242,flat_name:"process.group_leader.vpid",format:"string",level:"core",name:"vpid",normalize:[],original_fieldset:"process",short:"Virtual process id.",type:"long"},"process.group_leader.working_directory":{dashed_name:"process-group-leader-working-directory",description:"The working directory of the process.",example:"/home/alice",flat_name:"process.group_leader.working_directory",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.group_leader.working_directory.text",name:"text",type:"match_only_text"}],name:"working_directory",normalize:[],original_fieldset:"process",short:"The working directory of the process.",type:"keyword"},"process.hash.cdhash":{beta:"This field is beta and subject to change.",dashed_name:"process-hash-cdhash",description:"Code directory hash, utilized to uniquely identify and authenticate the integrity of the executable code.",example:"3783b4052fd474dbe30676b45c329e7a6d44acd9",flat_name:"process.hash.cdhash",ignore_above:1024,level:"extended",name:"cdhash",normalize:[],original_fieldset:"hash",short:"The Code Directory (CD) hash of an executable.",type:"keyword"},"process.hash.md5":{dashed_name:"process-hash-md5",description:"MD5 hash.",flat_name:"process.hash.md5",ignore_above:1024,level:"extended",name:"md5",normalize:[],original_fieldset:"hash",short:"MD5 hash.",type:"keyword"},"process.hash.sha1":{dashed_name:"process-hash-sha1",description:"SHA1 hash.",flat_name:"process.hash.sha1",ignore_above:1024,level:"extended",name:"sha1",normalize:[],original_fieldset:"hash",short:"SHA1 hash.",type:"keyword"},"process.hash.sha256":{dashed_name:"process-hash-sha256",description:"SHA256 hash.",flat_name:"process.hash.sha256",ignore_above:1024,level:"extended",name:"sha256",normalize:[],original_fieldset:"hash",short:"SHA256 hash.",type:"keyword"},"process.hash.sha384":{dashed_name:"process-hash-sha384",description:"SHA384 hash.",flat_name:"process.hash.sha384",ignore_above:1024,level:"extended",name:"sha384",normalize:[],original_fieldset:"hash",short:"SHA384 hash.",type:"keyword"},"process.hash.sha512":{dashed_name:"process-hash-sha512",description:"SHA512 hash.",flat_name:"process.hash.sha512",ignore_above:1024,level:"extended",name:"sha512",normalize:[],original_fieldset:"hash",short:"SHA512 hash.",type:"keyword"},"process.hash.ssdeep":{dashed_name:"process-hash-ssdeep",description:"SSDEEP hash.",flat_name:"process.hash.ssdeep",ignore_above:1024,level:"extended",name:"ssdeep",normalize:[],original_fieldset:"hash",short:"SSDEEP hash.",type:"keyword"},"process.hash.tlsh":{dashed_name:"process-hash-tlsh",description:"TLSH hash.",flat_name:"process.hash.tlsh",ignore_above:1024,level:"extended",name:"tlsh",normalize:[],original_fieldset:"hash",short:"TLSH hash.",type:"keyword"},"process.interactive":{dashed_name:"process-interactive",description:"Whether the process is connected to an interactive shell.\nProcess interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive.\nNote: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY.",example:!0,flat_name:"process.interactive",level:"extended",name:"interactive",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Whether the process is connected to an interactive shell.",type:"boolean"},"process.io":{dashed_name:"process-io",description:"A chunk of input or output (IO) from a single process.\nThis field only appears on the top level process object, which is the process that wrote the output or read the input.",flat_name:"process.io",level:"extended",name:"io",normalize:[],short:"A chunk of input or output (IO) from a single process.",type:"object"},"process.io.bytes_skipped":{dashed_name:"process-io-bytes-skipped",description:"An array of byte offsets and lengths denoting where IO data has been skipped.",flat_name:"process.io.bytes_skipped",level:"extended",name:"io.bytes_skipped",normalize:["array"],short:"An array of byte offsets and lengths denoting where IO data has been skipped.",type:"object"},"process.io.bytes_skipped.length":{dashed_name:"process-io-bytes-skipped-length",description:"The length of bytes skipped.",flat_name:"process.io.bytes_skipped.length",level:"extended",name:"io.bytes_skipped.length",normalize:[],short:"The length of bytes skipped.",type:"long"},"process.io.bytes_skipped.offset":{dashed_name:"process-io-bytes-skipped-offset",description:"The byte offset into this event's io.text (or io.bytes in the future) where length bytes were skipped.",flat_name:"process.io.bytes_skipped.offset",level:"extended",name:"io.bytes_skipped.offset",normalize:[],short:"The byte offset into this event's io.text (or io.bytes in the future) where length bytes were skipped.",type:"long"},"process.io.max_bytes_per_process_exceeded":{dashed_name:"process-io-max-bytes-per-process-exceeded",description:"If true, the process producing the output has exceeded the max_kilobytes_per_process configuration setting.",flat_name:"process.io.max_bytes_per_process_exceeded",level:"extended",name:"io.max_bytes_per_process_exceeded",normalize:[],short:"If true, the process producing the output has exceeded the max_kilobytes_per_process configuration setting.",type:"boolean"},"process.io.text":{dashed_name:"process-io-text",description:"A chunk of output or input sanitized to UTF-8.\nBest efforts are made to ensure complete lines are captured in these events. Assumptions should NOT be made that multiple lines will appear in the same event. TTY output may contain terminal control codes such as for cursor movement, so some string queries may not match due to terminal codes inserted between characters of a word.",flat_name:"process.io.text",level:"extended",name:"io.text",normalize:[],short:"A chunk of output or input sanitized to UTF-8.",type:"wildcard"},"process.io.total_bytes_captured":{dashed_name:"process-io-total-bytes-captured",description:"The total number of bytes captured in this event.",flat_name:"process.io.total_bytes_captured",level:"extended",name:"io.total_bytes_captured",normalize:[],short:"The total number of bytes captured in this event.",type:"long"},"process.io.total_bytes_skipped":{dashed_name:"process-io-total-bytes-skipped",description:"The total number of bytes that were not captured due to implementation restrictions such as buffer size limits. Implementors should strive to ensure this value is always zero",flat_name:"process.io.total_bytes_skipped",level:"extended",name:"io.total_bytes_skipped",normalize:[],short:"The total number of bytes that were not captured due to implementation restrictions such as buffer size limits.",type:"long"},"process.io.type":{dashed_name:"process-io-type",description:"The type of object on which the IO action (read or write) was taken.\nCurrently only 'tty' is supported. Other types may be added in the future for 'file' and 'socket' support.",flat_name:"process.io.type",ignore_above:1024,level:"extended",name:"io.type",normalize:[],short:"The type of object on which the IO action (read or write) was taken.",type:"keyword"},"process.macho.go_import_hash":{dashed_name:"process-macho-go-import-hash",description:"A hash of the Go language imports in a Mach-O file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThe algorithm used to calculate the Go symbol hash and a reference implementation are available here: https://github.com/elastic/toutoumomoma",example:"10bddcb4cee42080f76c88d9ff964491",flat_name:"process.macho.go_import_hash",ignore_above:1024,level:"extended",name:"go_import_hash",normalize:[],original_fieldset:"macho",short:"A hash of the Go language imports in a Mach-O file.",type:"keyword"},"process.macho.go_imports":{dashed_name:"process-macho-go-imports",description:"List of imported Go language element names and types.",flat_name:"process.macho.go_imports",level:"extended",name:"go_imports",normalize:[],original_fieldset:"macho",short:"List of imported Go language element names and types.",type:"flattened"},"process.macho.go_imports_names_entropy":{dashed_name:"process-macho-go-imports-names-entropy",description:"Shannon entropy calculation from the list of Go imports.",flat_name:"process.macho.go_imports_names_entropy",format:"number",level:"extended",name:"go_imports_names_entropy",normalize:[],original_fieldset:"macho",short:"Shannon entropy calculation from the list of Go imports.",type:"long"},"process.macho.go_imports_names_var_entropy":{dashed_name:"process-macho-go-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of Go imports.",flat_name:"process.macho.go_imports_names_var_entropy",format:"number",level:"extended",name:"go_imports_names_var_entropy",normalize:[],original_fieldset:"macho",short:"Variance for Shannon entropy calculation from the list of Go imports.",type:"long"},"process.macho.go_stripped":{dashed_name:"process-macho-go-stripped",description:"Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.",flat_name:"process.macho.go_stripped",level:"extended",name:"go_stripped",normalize:[],original_fieldset:"macho",short:"Whether the file is a stripped or obfuscated Go executable.",type:"boolean"},"process.macho.import_hash":{dashed_name:"process-macho-import-hash",description:"A hash of the imports in a Mach-O file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is a synonym for symhash.",example:"d41d8cd98f00b204e9800998ecf8427e",flat_name:"process.macho.import_hash",ignore_above:1024,level:"extended",name:"import_hash",normalize:[],original_fieldset:"macho",short:"A hash of the imports in a Mach-O file.",type:"keyword"},"process.macho.imports":{dashed_name:"process-macho-imports",description:"List of imported element names and types.",flat_name:"process.macho.imports",level:"extended",name:"imports",normalize:["array"],original_fieldset:"macho",short:"List of imported element names and types.",type:"flattened"},"process.macho.imports_names_entropy":{dashed_name:"process-macho-imports-names-entropy",description:"Shannon entropy calculation from the list of imported element names and types.",flat_name:"process.macho.imports_names_entropy",format:"number",level:"extended",name:"imports_names_entropy",normalize:[],original_fieldset:"macho",short:"Shannon entropy calculation from the list of imported element names and types.",type:"long"},"process.macho.imports_names_var_entropy":{dashed_name:"process-macho-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of imported element names and types.",flat_name:"process.macho.imports_names_var_entropy",format:"number",level:"extended",name:"imports_names_var_entropy",normalize:[],original_fieldset:"macho",short:"Variance for Shannon entropy calculation from the list of imported element names and types.",type:"long"},"process.macho.sections":{dashed_name:"process-macho-sections",description:"An array containing an object for each section of the Mach-O file.\nThe keys that should be present in these objects are defined by sub-fields underneath `macho.sections.*`.",flat_name:"process.macho.sections",level:"extended",name:"sections",normalize:["array"],original_fieldset:"macho",short:"Section information of the Mach-O file.",type:"nested"},"process.macho.sections.entropy":{dashed_name:"process-macho-sections-entropy",description:"Shannon entropy calculation from the section.",flat_name:"process.macho.sections.entropy",format:"number",level:"extended",name:"sections.entropy",normalize:[],original_fieldset:"macho",short:"Shannon entropy calculation from the section.",type:"long"},"process.macho.sections.name":{dashed_name:"process-macho-sections-name",description:"Mach-O Section List name.",flat_name:"process.macho.sections.name",ignore_above:1024,level:"extended",name:"sections.name",normalize:[],original_fieldset:"macho",short:"Mach-O Section List name.",type:"keyword"},"process.macho.sections.physical_size":{dashed_name:"process-macho-sections-physical-size",description:"Mach-O Section List physical size.",flat_name:"process.macho.sections.physical_size",format:"bytes",level:"extended",name:"sections.physical_size",normalize:[],original_fieldset:"macho",short:"Mach-O Section List physical size.",type:"long"},"process.macho.sections.var_entropy":{dashed_name:"process-macho-sections-var-entropy",description:"Variance for Shannon entropy calculation from the section.",flat_name:"process.macho.sections.var_entropy",format:"number",level:"extended",name:"sections.var_entropy",normalize:[],original_fieldset:"macho",short:"Variance for Shannon entropy calculation from the section.",type:"long"},"process.macho.sections.virtual_size":{dashed_name:"process-macho-sections-virtual-size",description:"Mach-O Section List virtual size. This is always the same as `physical_size`.",flat_name:"process.macho.sections.virtual_size",format:"string",level:"extended",name:"sections.virtual_size",normalize:[],original_fieldset:"macho",short:"Mach-O Section List virtual size. This is always the same as `physical_size`.",type:"long"},"process.macho.symhash":{dashed_name:"process-macho-symhash",description:"A hash of the imports in a Mach-O file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is a Mach-O implementation of the Windows PE imphash",example:"d3ccf195b62a9279c3c19af1080497ec",flat_name:"process.macho.symhash",ignore_above:1024,level:"extended",name:"symhash",normalize:[],original_fieldset:"macho",short:"A hash of the imports in a Mach-O file.",type:"keyword"},"process.name":{dashed_name:"process-name",description:"Process name.\nSometimes called program name or similar.",example:"ssh",flat_name:"process.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],short:"Process name.",type:"keyword"},"process.parent.args":{dashed_name:"process-parent-args",description:"Array of process arguments, starting with the absolute path to the executable.\nMay be filtered to protect sensitive information.",example:'["/usr/bin/ssh", "-l", "user", "10.0.0.16"]',flat_name:"process.parent.args",ignore_above:1024,level:"extended",name:"args",normalize:["array"],original_fieldset:"process",short:"Array of process arguments.",type:"keyword"},"process.parent.args_count":{dashed_name:"process-parent-args-count",description:"Length of the process.args array.\nThis field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity.",example:4,flat_name:"process.parent.args_count",level:"extended",name:"args_count",normalize:[],original_fieldset:"process",short:"Length of the process.args array.",type:"long"},"process.parent.code_signature.digest_algorithm":{dashed_name:"process-parent-code-signature-digest-algorithm",description:"The hashing algorithm used to sign the process.\nThis value can distinguish signatures when a file is signed multiple times by the same signer but with a different digest algorithm.",example:"sha256",flat_name:"process.parent.code_signature.digest_algorithm",ignore_above:1024,level:"extended",name:"digest_algorithm",normalize:[],original_fieldset:"code_signature",short:"Hashing algorithm used to sign the process.",type:"keyword"},"process.parent.code_signature.exists":{dashed_name:"process-parent-code-signature-exists",description:"Boolean to capture if a signature is present.",example:"true",flat_name:"process.parent.code_signature.exists",level:"core",name:"exists",normalize:[],original_fieldset:"code_signature",short:"Boolean to capture if a signature is present.",type:"boolean"},"process.parent.code_signature.flags":{beta:"This field is beta and subject to change.",dashed_name:"process-parent-code-signature-flags",description:"The flags used to sign the process.",example:570522385,flat_name:"process.parent.code_signature.flags",ignore_above:1024,level:"extended",name:"flags",normalize:[],original_fieldset:"code_signature",short:"Code signing flags of the process",type:"keyword"},"process.parent.code_signature.signing_id":{dashed_name:"process-parent-code-signature-signing-id",description:"The identifier used to sign the process.\nThis is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only.",example:"com.apple.xpc.proxy",flat_name:"process.parent.code_signature.signing_id",ignore_above:1024,level:"extended",name:"signing_id",normalize:[],original_fieldset:"code_signature",short:"The identifier used to sign the process.",type:"keyword"},"process.parent.code_signature.status":{dashed_name:"process-parent-code-signature-status",description:"Additional information about the certificate status.\nThis is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.",example:"ERROR_UNTRUSTED_ROOT",flat_name:"process.parent.code_signature.status",ignore_above:1024,level:"extended",name:"status",normalize:[],original_fieldset:"code_signature",short:"Additional information about the certificate status.",type:"keyword"},"process.parent.code_signature.subject_name":{dashed_name:"process-parent-code-signature-subject-name",description:"Subject name of the code signer",example:"Microsoft Corporation",flat_name:"process.parent.code_signature.subject_name",ignore_above:1024,level:"core",name:"subject_name",normalize:[],original_fieldset:"code_signature",short:"Subject name of the code signer",type:"keyword"},"process.parent.code_signature.team_id":{dashed_name:"process-parent-code-signature-team-id",description:"The team identifier used to sign the process.\nThis is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only.",example:"EQHXZ8M8AV",flat_name:"process.parent.code_signature.team_id",ignore_above:1024,level:"extended",name:"team_id",normalize:[],original_fieldset:"code_signature",short:"The team identifier used to sign the process.",type:"keyword"},"process.parent.code_signature.timestamp":{dashed_name:"process-parent-code-signature-timestamp",description:"Date and time when the code signature was generated and signed.",example:"2021-01-01T12:10:30Z",flat_name:"process.parent.code_signature.timestamp",level:"extended",name:"timestamp",normalize:[],original_fieldset:"code_signature",short:"When the signature was generated and signed.",type:"date"},"process.parent.code_signature.trusted":{dashed_name:"process-parent-code-signature-trusted",description:"Stores the trust status of the certificate chain.\nValidating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.",example:"true",flat_name:"process.parent.code_signature.trusted",level:"extended",name:"trusted",normalize:[],original_fieldset:"code_signature",short:"Stores the trust status of the certificate chain.",type:"boolean"},"process.parent.code_signature.valid":{dashed_name:"process-parent-code-signature-valid",description:"Boolean to capture if the digital signature is verified against the binary content.\nLeave unpopulated if a certificate was unchecked.",example:"true",flat_name:"process.parent.code_signature.valid",level:"extended",name:"valid",normalize:[],original_fieldset:"code_signature",short:"Boolean to capture if the digital signature is verified against the binary content.",type:"boolean"},"process.parent.command_line":{dashed_name:"process-parent-command-line",description:"Full command line that started the process, including the absolute path to the executable, and all arguments.\nSome arguments may be filtered to protect sensitive information.",example:"/usr/bin/ssh -l user 10.0.0.16",flat_name:"process.parent.command_line",level:"extended",multi_fields:[{flat_name:"process.parent.command_line.text",name:"text",type:"match_only_text"}],name:"command_line",normalize:[],original_fieldset:"process",short:"Full command line that started the process.",type:"wildcard"},"process.parent.elf.architecture":{dashed_name:"process-parent-elf-architecture",description:"Machine architecture of the ELF file.",example:"x86-64",flat_name:"process.parent.elf.architecture",ignore_above:1024,level:"extended",name:"architecture",normalize:[],original_fieldset:"elf",short:"Machine architecture of the ELF file.",type:"keyword"},"process.parent.elf.byte_order":{dashed_name:"process-parent-elf-byte-order",description:"Byte sequence of ELF file.",example:"Little Endian",flat_name:"process.parent.elf.byte_order",ignore_above:1024,level:"extended",name:"byte_order",normalize:[],original_fieldset:"elf",short:"Byte sequence of ELF file.",type:"keyword"},"process.parent.elf.cpu_type":{dashed_name:"process-parent-elf-cpu-type",description:"CPU type of the ELF file.",example:"Intel",flat_name:"process.parent.elf.cpu_type",ignore_above:1024,level:"extended",name:"cpu_type",normalize:[],original_fieldset:"elf",short:"CPU type of the ELF file.",type:"keyword"},"process.parent.elf.creation_date":{dashed_name:"process-parent-elf-creation-date",description:"Extracted when possible from the file's metadata. Indicates when it was built or compiled. It can also be faked by malware creators.",flat_name:"process.parent.elf.creation_date",level:"extended",name:"creation_date",normalize:[],original_fieldset:"elf",short:"Build or compile date.",type:"date"},"process.parent.elf.exports":{dashed_name:"process-parent-elf-exports",description:"List of exported element names and types.",flat_name:"process.parent.elf.exports",level:"extended",name:"exports",normalize:["array"],original_fieldset:"elf",short:"List of exported element names and types.",type:"flattened"},"process.parent.elf.go_import_hash":{dashed_name:"process-parent-elf-go-import-hash",description:"A hash of the Go language imports in an ELF file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThe algorithm used to calculate the Go symbol hash and a reference implementation are available here: https://github.com/elastic/toutoumomoma",example:"10bddcb4cee42080f76c88d9ff964491",flat_name:"process.parent.elf.go_import_hash",ignore_above:1024,level:"extended",name:"go_import_hash",normalize:[],original_fieldset:"elf",short:"A hash of the Go language imports in an ELF file.",type:"keyword"},"process.parent.elf.go_imports":{dashed_name:"process-parent-elf-go-imports",description:"List of imported Go language element names and types.",flat_name:"process.parent.elf.go_imports",level:"extended",name:"go_imports",normalize:[],original_fieldset:"elf",short:"List of imported Go language element names and types.",type:"flattened"},"process.parent.elf.go_imports_names_entropy":{dashed_name:"process-parent-elf-go-imports-names-entropy",description:"Shannon entropy calculation from the list of Go imports.",flat_name:"process.parent.elf.go_imports_names_entropy",format:"number",level:"extended",name:"go_imports_names_entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the list of Go imports.",type:"long"},"process.parent.elf.go_imports_names_var_entropy":{dashed_name:"process-parent-elf-go-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of Go imports.",flat_name:"process.parent.elf.go_imports_names_var_entropy",format:"number",level:"extended",name:"go_imports_names_var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the list of Go imports.",type:"long"},"process.parent.elf.go_stripped":{dashed_name:"process-parent-elf-go-stripped",description:"Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.",flat_name:"process.parent.elf.go_stripped",level:"extended",name:"go_stripped",normalize:[],original_fieldset:"elf",short:"Whether the file is a stripped or obfuscated Go executable.",type:"boolean"},"process.parent.elf.header.abi_version":{dashed_name:"process-parent-elf-header-abi-version",description:"Version of the ELF Application Binary Interface (ABI).",flat_name:"process.parent.elf.header.abi_version",ignore_above:1024,level:"extended",name:"header.abi_version",normalize:[],original_fieldset:"elf",short:"Version of the ELF Application Binary Interface (ABI).",type:"keyword"},"process.parent.elf.header.class":{dashed_name:"process-parent-elf-header-class",description:"Header class of the ELF file.",flat_name:"process.parent.elf.header.class",ignore_above:1024,level:"extended",name:"header.class",normalize:[],original_fieldset:"elf",short:"Header class of the ELF file.",type:"keyword"},"process.parent.elf.header.data":{dashed_name:"process-parent-elf-header-data",description:"Data table of the ELF header.",flat_name:"process.parent.elf.header.data",ignore_above:1024,level:"extended",name:"header.data",normalize:[],original_fieldset:"elf",short:"Data table of the ELF header.",type:"keyword"},"process.parent.elf.header.entrypoint":{dashed_name:"process-parent-elf-header-entrypoint",description:"Header entrypoint of the ELF file.",flat_name:"process.parent.elf.header.entrypoint",format:"string",level:"extended",name:"header.entrypoint",normalize:[],original_fieldset:"elf",short:"Header entrypoint of the ELF file.",type:"long"},"process.parent.elf.header.object_version":{dashed_name:"process-parent-elf-header-object-version",description:'"0x1" for original ELF files.',flat_name:"process.parent.elf.header.object_version",ignore_above:1024,level:"extended",name:"header.object_version",normalize:[],original_fieldset:"elf",short:'"0x1" for original ELF files.',type:"keyword"},"process.parent.elf.header.os_abi":{dashed_name:"process-parent-elf-header-os-abi",description:"Application Binary Interface (ABI) of the Linux OS.",flat_name:"process.parent.elf.header.os_abi",ignore_above:1024,level:"extended",name:"header.os_abi",normalize:[],original_fieldset:"elf",short:"Application Binary Interface (ABI) of the Linux OS.",type:"keyword"},"process.parent.elf.header.type":{dashed_name:"process-parent-elf-header-type",description:"Header type of the ELF file.",flat_name:"process.parent.elf.header.type",ignore_above:1024,level:"extended",name:"header.type",normalize:[],original_fieldset:"elf",short:"Header type of the ELF file.",type:"keyword"},"process.parent.elf.header.version":{dashed_name:"process-parent-elf-header-version",description:"Version of the ELF header.",flat_name:"process.parent.elf.header.version",ignore_above:1024,level:"extended",name:"header.version",normalize:[],original_fieldset:"elf",short:"Version of the ELF header.",type:"keyword"},"process.parent.elf.import_hash":{dashed_name:"process-parent-elf-import-hash",description:"A hash of the imports in an ELF file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is an ELF implementation of the Windows PE imphash.",example:"d41d8cd98f00b204e9800998ecf8427e",flat_name:"process.parent.elf.import_hash",ignore_above:1024,level:"extended",name:"import_hash",normalize:[],original_fieldset:"elf",short:"A hash of the imports in an ELF file.",type:"keyword"},"process.parent.elf.imports":{dashed_name:"process-parent-elf-imports",description:"List of imported element names and types.",flat_name:"process.parent.elf.imports",level:"extended",name:"imports",normalize:["array"],original_fieldset:"elf",short:"List of imported element names and types.",type:"flattened"},"process.parent.elf.imports_names_entropy":{dashed_name:"process-parent-elf-imports-names-entropy",description:"Shannon entropy calculation from the list of imported element names and types.",flat_name:"process.parent.elf.imports_names_entropy",format:"number",level:"extended",name:"imports_names_entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the list of imported element names and types.",type:"long"},"process.parent.elf.imports_names_var_entropy":{dashed_name:"process-parent-elf-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of imported element names and types.",flat_name:"process.parent.elf.imports_names_var_entropy",format:"number",level:"extended",name:"imports_names_var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the list of imported element names and types.",type:"long"},"process.parent.elf.sections":{dashed_name:"process-parent-elf-sections",description:"An array containing an object for each section of the ELF file.\nThe keys that should be present in these objects are defined by sub-fields underneath `elf.sections.*`.",flat_name:"process.parent.elf.sections",level:"extended",name:"sections",normalize:["array"],original_fieldset:"elf",short:"Section information of the ELF file.",type:"nested"},"process.parent.elf.sections.chi2":{dashed_name:"process-parent-elf-sections-chi2",description:"Chi-square probability distribution of the section.",flat_name:"process.parent.elf.sections.chi2",format:"number",level:"extended",name:"sections.chi2",normalize:[],original_fieldset:"elf",short:"Chi-square probability distribution of the section.",type:"long"},"process.parent.elf.sections.entropy":{dashed_name:"process-parent-elf-sections-entropy",description:"Shannon entropy calculation from the section.",flat_name:"process.parent.elf.sections.entropy",format:"number",level:"extended",name:"sections.entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the section.",type:"long"},"process.parent.elf.sections.flags":{dashed_name:"process-parent-elf-sections-flags",description:"ELF Section List flags.",flat_name:"process.parent.elf.sections.flags",ignore_above:1024,level:"extended",name:"sections.flags",normalize:[],original_fieldset:"elf",short:"ELF Section List flags.",type:"keyword"},"process.parent.elf.sections.name":{dashed_name:"process-parent-elf-sections-name",description:"ELF Section List name.",flat_name:"process.parent.elf.sections.name",ignore_above:1024,level:"extended",name:"sections.name",normalize:[],original_fieldset:"elf",short:"ELF Section List name.",type:"keyword"},"process.parent.elf.sections.physical_offset":{dashed_name:"process-parent-elf-sections-physical-offset",description:"ELF Section List offset.",flat_name:"process.parent.elf.sections.physical_offset",ignore_above:1024,level:"extended",name:"sections.physical_offset",normalize:[],original_fieldset:"elf",short:"ELF Section List offset.",type:"keyword"},"process.parent.elf.sections.physical_size":{dashed_name:"process-parent-elf-sections-physical-size",description:"ELF Section List physical size.",flat_name:"process.parent.elf.sections.physical_size",format:"bytes",level:"extended",name:"sections.physical_size",normalize:[],original_fieldset:"elf",short:"ELF Section List physical size.",type:"long"},"process.parent.elf.sections.type":{dashed_name:"process-parent-elf-sections-type",description:"ELF Section List type.",flat_name:"process.parent.elf.sections.type",ignore_above:1024,level:"extended",name:"sections.type",normalize:[],original_fieldset:"elf",short:"ELF Section List type.",type:"keyword"},"process.parent.elf.sections.var_entropy":{dashed_name:"process-parent-elf-sections-var-entropy",description:"Variance for Shannon entropy calculation from the section.",flat_name:"process.parent.elf.sections.var_entropy",format:"number",level:"extended",name:"sections.var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the section.",type:"long"},"process.parent.elf.sections.virtual_address":{dashed_name:"process-parent-elf-sections-virtual-address",description:"ELF Section List virtual address.",flat_name:"process.parent.elf.sections.virtual_address",format:"string",level:"extended",name:"sections.virtual_address",normalize:[],original_fieldset:"elf",short:"ELF Section List virtual address.",type:"long"},"process.parent.elf.sections.virtual_size":{dashed_name:"process-parent-elf-sections-virtual-size",description:"ELF Section List virtual size.",flat_name:"process.parent.elf.sections.virtual_size",format:"string",level:"extended",name:"sections.virtual_size",normalize:[],original_fieldset:"elf",short:"ELF Section List virtual size.",type:"long"},"process.parent.elf.segments":{dashed_name:"process-parent-elf-segments",description:"An array containing an object for each segment of the ELF file.\nThe keys that should be present in these objects are defined by sub-fields underneath `elf.segments.*`.",flat_name:"process.parent.elf.segments",level:"extended",name:"segments",normalize:["array"],original_fieldset:"elf",short:"ELF object segment list.",type:"nested"},"process.parent.elf.segments.sections":{dashed_name:"process-parent-elf-segments-sections",description:"ELF object segment sections.",flat_name:"process.parent.elf.segments.sections",ignore_above:1024,level:"extended",name:"segments.sections",normalize:[],original_fieldset:"elf",short:"ELF object segment sections.",type:"keyword"},"process.parent.elf.segments.type":{dashed_name:"process-parent-elf-segments-type",description:"ELF object segment type.",flat_name:"process.parent.elf.segments.type",ignore_above:1024,level:"extended",name:"segments.type",normalize:[],original_fieldset:"elf",short:"ELF object segment type.",type:"keyword"},"process.parent.elf.shared_libraries":{dashed_name:"process-parent-elf-shared-libraries",description:"List of shared libraries used by this ELF object.",flat_name:"process.parent.elf.shared_libraries",ignore_above:1024,level:"extended",name:"shared_libraries",normalize:["array"],original_fieldset:"elf",short:"List of shared libraries used by this ELF object.",type:"keyword"},"process.parent.elf.telfhash":{dashed_name:"process-parent-elf-telfhash",description:"telfhash symbol hash for ELF file.",flat_name:"process.parent.elf.telfhash",ignore_above:1024,level:"extended",name:"telfhash",normalize:[],original_fieldset:"elf",short:"telfhash hash for ELF file.",type:"keyword"},"process.parent.end":{dashed_name:"process-parent-end",description:"The time the process ended.",example:"2016-05-23T08:05:34.853Z",flat_name:"process.parent.end",level:"extended",name:"end",normalize:[],original_fieldset:"process",short:"The time the process ended.",type:"date"},"process.parent.entity_id":{dashed_name:"process-parent-entity-id",description:"Unique identifier for the process.\nThe implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process.\nConstructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.",example:"c2c455d9f99375d",flat_name:"process.parent.entity_id",ignore_above:1024,level:"extended",name:"entity_id",normalize:[],original_fieldset:"process",short:"Unique identifier for the process.",type:"keyword"},"process.parent.executable":{dashed_name:"process-parent-executable",description:"Absolute path to the process executable.",example:"/usr/bin/ssh",flat_name:"process.parent.executable",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.parent.executable.text",name:"text",type:"match_only_text"}],name:"executable",normalize:[],original_fieldset:"process",short:"Absolute path to the process executable.",type:"keyword"},"process.parent.exit_code":{dashed_name:"process-parent-exit-code",description:"The exit code of the process, if this is a termination event.\nThe field should be absent if there is no exit code for the event (e.g. process start).",example:137,flat_name:"process.parent.exit_code",level:"extended",name:"exit_code",normalize:[],original_fieldset:"process",short:"The exit code of the process.",type:"long"},"process.parent.group.id":{dashed_name:"process-parent-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.parent.group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.parent.group.name":{dashed_name:"process-parent-group-name",description:"Name of the group.",flat_name:"process.parent.group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.parent.group_leader.entity_id":{dashed_name:"process-parent-group-leader-entity-id",description:"Unique identifier for the process.\nThe implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process.\nConstructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.",example:"c2c455d9f99375d",flat_name:"process.parent.group_leader.entity_id",ignore_above:1024,level:"extended",name:"entity_id",normalize:[],original_fieldset:"process",short:"Unique identifier for the process.",type:"keyword"},"process.parent.group_leader.pid":{dashed_name:"process-parent-group-leader-pid",description:"Process id.",example:4242,flat_name:"process.parent.group_leader.pid",format:"string",level:"core",name:"pid",normalize:[],original_fieldset:"process",short:"Process id.",type:"long"},"process.parent.group_leader.start":{dashed_name:"process-parent-group-leader-start",description:"The time the process started.",example:"2016-05-23T08:05:34.853Z",flat_name:"process.parent.group_leader.start",level:"extended",name:"start",normalize:[],original_fieldset:"process",short:"The time the process started.",type:"date"},"process.parent.group_leader.vpid":{dashed_name:"process-parent-group-leader-vpid",description:"Virtual process id.\nThe process id within a pid namespace. This is not necessarily unique across all processes on the host but it is unique within the process namespace that the process exists within.",example:4242,flat_name:"process.parent.group_leader.vpid",format:"string",level:"core",name:"vpid",normalize:[],original_fieldset:"process",short:"Virtual process id.",type:"long"},"process.parent.hash.cdhash":{beta:"This field is beta and subject to change.",dashed_name:"process-parent-hash-cdhash",description:"Code directory hash, utilized to uniquely identify and authenticate the integrity of the executable code.",example:"3783b4052fd474dbe30676b45c329e7a6d44acd9",flat_name:"process.parent.hash.cdhash",ignore_above:1024,level:"extended",name:"cdhash",normalize:[],original_fieldset:"hash",short:"The Code Directory (CD) hash of an executable.",type:"keyword"},"process.parent.hash.md5":{dashed_name:"process-parent-hash-md5",description:"MD5 hash.",flat_name:"process.parent.hash.md5",ignore_above:1024,level:"extended",name:"md5",normalize:[],original_fieldset:"hash",short:"MD5 hash.",type:"keyword"},"process.parent.hash.sha1":{dashed_name:"process-parent-hash-sha1",description:"SHA1 hash.",flat_name:"process.parent.hash.sha1",ignore_above:1024,level:"extended",name:"sha1",normalize:[],original_fieldset:"hash",short:"SHA1 hash.",type:"keyword"},"process.parent.hash.sha256":{dashed_name:"process-parent-hash-sha256",description:"SHA256 hash.",flat_name:"process.parent.hash.sha256",ignore_above:1024,level:"extended",name:"sha256",normalize:[],original_fieldset:"hash",short:"SHA256 hash.",type:"keyword"},"process.parent.hash.sha384":{dashed_name:"process-parent-hash-sha384",description:"SHA384 hash.",flat_name:"process.parent.hash.sha384",ignore_above:1024,level:"extended",name:"sha384",normalize:[],original_fieldset:"hash",short:"SHA384 hash.",type:"keyword"},"process.parent.hash.sha512":{dashed_name:"process-parent-hash-sha512",description:"SHA512 hash.",flat_name:"process.parent.hash.sha512",ignore_above:1024,level:"extended",name:"sha512",normalize:[],original_fieldset:"hash",short:"SHA512 hash.",type:"keyword"},"process.parent.hash.ssdeep":{dashed_name:"process-parent-hash-ssdeep",description:"SSDEEP hash.",flat_name:"process.parent.hash.ssdeep",ignore_above:1024,level:"extended",name:"ssdeep",normalize:[],original_fieldset:"hash",short:"SSDEEP hash.",type:"keyword"},"process.parent.hash.tlsh":{dashed_name:"process-parent-hash-tlsh",description:"TLSH hash.",flat_name:"process.parent.hash.tlsh",ignore_above:1024,level:"extended",name:"tlsh",normalize:[],original_fieldset:"hash",short:"TLSH hash.",type:"keyword"},"process.parent.interactive":{dashed_name:"process-parent-interactive",description:"Whether the process is connected to an interactive shell.\nProcess interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive.\nNote: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY.",example:!0,flat_name:"process.parent.interactive",level:"extended",name:"interactive",normalize:[],original_fieldset:"process",short:"Whether the process is connected to an interactive shell.",type:"boolean"},"process.parent.macho.go_import_hash":{dashed_name:"process-parent-macho-go-import-hash",description:"A hash of the Go language imports in a Mach-O file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThe algorithm used to calculate the Go symbol hash and a reference implementation are available here: https://github.com/elastic/toutoumomoma",example:"10bddcb4cee42080f76c88d9ff964491",flat_name:"process.parent.macho.go_import_hash",ignore_above:1024,level:"extended",name:"go_import_hash",normalize:[],original_fieldset:"macho",short:"A hash of the Go language imports in a Mach-O file.",type:"keyword"},"process.parent.macho.go_imports":{dashed_name:"process-parent-macho-go-imports",description:"List of imported Go language element names and types.",flat_name:"process.parent.macho.go_imports",level:"extended",name:"go_imports",normalize:[],original_fieldset:"macho",short:"List of imported Go language element names and types.",type:"flattened"},"process.parent.macho.go_imports_names_entropy":{dashed_name:"process-parent-macho-go-imports-names-entropy",description:"Shannon entropy calculation from the list of Go imports.",flat_name:"process.parent.macho.go_imports_names_entropy",format:"number",level:"extended",name:"go_imports_names_entropy",normalize:[],original_fieldset:"macho",short:"Shannon entropy calculation from the list of Go imports.",type:"long"},"process.parent.macho.go_imports_names_var_entropy":{dashed_name:"process-parent-macho-go-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of Go imports.",flat_name:"process.parent.macho.go_imports_names_var_entropy",format:"number",level:"extended",name:"go_imports_names_var_entropy",normalize:[],original_fieldset:"macho",short:"Variance for Shannon entropy calculation from the list of Go imports.",type:"long"},"process.parent.macho.go_stripped":{dashed_name:"process-parent-macho-go-stripped",description:"Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.",flat_name:"process.parent.macho.go_stripped",level:"extended",name:"go_stripped",normalize:[],original_fieldset:"macho",short:"Whether the file is a stripped or obfuscated Go executable.",type:"boolean"},"process.parent.macho.import_hash":{dashed_name:"process-parent-macho-import-hash",description:"A hash of the imports in a Mach-O file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is a synonym for symhash.",example:"d41d8cd98f00b204e9800998ecf8427e",flat_name:"process.parent.macho.import_hash",ignore_above:1024,level:"extended",name:"import_hash",normalize:[],original_fieldset:"macho",short:"A hash of the imports in a Mach-O file.",type:"keyword"},"process.parent.macho.imports":{dashed_name:"process-parent-macho-imports",description:"List of imported element names and types.",flat_name:"process.parent.macho.imports",level:"extended",name:"imports",normalize:["array"],original_fieldset:"macho",short:"List of imported element names and types.",type:"flattened"},"process.parent.macho.imports_names_entropy":{dashed_name:"process-parent-macho-imports-names-entropy",description:"Shannon entropy calculation from the list of imported element names and types.",flat_name:"process.parent.macho.imports_names_entropy",format:"number",level:"extended",name:"imports_names_entropy",normalize:[],original_fieldset:"macho",short:"Shannon entropy calculation from the list of imported element names and types.",type:"long"},"process.parent.macho.imports_names_var_entropy":{dashed_name:"process-parent-macho-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of imported element names and types.",flat_name:"process.parent.macho.imports_names_var_entropy",format:"number",level:"extended",name:"imports_names_var_entropy",normalize:[],original_fieldset:"macho",short:"Variance for Shannon entropy calculation from the list of imported element names and types.",type:"long"},"process.parent.macho.sections":{dashed_name:"process-parent-macho-sections",description:"An array containing an object for each section of the Mach-O file.\nThe keys that should be present in these objects are defined by sub-fields underneath `macho.sections.*`.",flat_name:"process.parent.macho.sections",level:"extended",name:"sections",normalize:["array"],original_fieldset:"macho",short:"Section information of the Mach-O file.",type:"nested"},"process.parent.macho.sections.entropy":{dashed_name:"process-parent-macho-sections-entropy",description:"Shannon entropy calculation from the section.",flat_name:"process.parent.macho.sections.entropy",format:"number",level:"extended",name:"sections.entropy",normalize:[],original_fieldset:"macho",short:"Shannon entropy calculation from the section.",type:"long"},"process.parent.macho.sections.name":{dashed_name:"process-parent-macho-sections-name",description:"Mach-O Section List name.",flat_name:"process.parent.macho.sections.name",ignore_above:1024,level:"extended",name:"sections.name",normalize:[],original_fieldset:"macho",short:"Mach-O Section List name.",type:"keyword"},"process.parent.macho.sections.physical_size":{dashed_name:"process-parent-macho-sections-physical-size",description:"Mach-O Section List physical size.",flat_name:"process.parent.macho.sections.physical_size",format:"bytes",level:"extended",name:"sections.physical_size",normalize:[],original_fieldset:"macho",short:"Mach-O Section List physical size.",type:"long"},"process.parent.macho.sections.var_entropy":{dashed_name:"process-parent-macho-sections-var-entropy",description:"Variance for Shannon entropy calculation from the section.",flat_name:"process.parent.macho.sections.var_entropy",format:"number",level:"extended",name:"sections.var_entropy",normalize:[],original_fieldset:"macho",short:"Variance for Shannon entropy calculation from the section.",type:"long"},"process.parent.macho.sections.virtual_size":{dashed_name:"process-parent-macho-sections-virtual-size",description:"Mach-O Section List virtual size. This is always the same as `physical_size`.",flat_name:"process.parent.macho.sections.virtual_size",format:"string",level:"extended",name:"sections.virtual_size",normalize:[],original_fieldset:"macho",short:"Mach-O Section List virtual size. This is always the same as `physical_size`.",type:"long"},"process.parent.macho.symhash":{dashed_name:"process-parent-macho-symhash",description:"A hash of the imports in a Mach-O file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is a Mach-O implementation of the Windows PE imphash",example:"d3ccf195b62a9279c3c19af1080497ec",flat_name:"process.parent.macho.symhash",ignore_above:1024,level:"extended",name:"symhash",normalize:[],original_fieldset:"macho",short:"A hash of the imports in a Mach-O file.",type:"keyword"},"process.parent.name":{dashed_name:"process-parent-name",description:"Process name.\nSometimes called program name or similar.",example:"ssh",flat_name:"process.parent.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.parent.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"process",short:"Process name.",type:"keyword"},"process.parent.pe.architecture":{dashed_name:"process-parent-pe-architecture",description:"CPU architecture target for the file.",example:"x64",flat_name:"process.parent.pe.architecture",ignore_above:1024,level:"extended",name:"architecture",normalize:[],original_fieldset:"pe",short:"CPU architecture target for the file.",type:"keyword"},"process.parent.pe.company":{dashed_name:"process-parent-pe-company",description:"Internal company name of the file, provided at compile-time.",example:"Microsoft Corporation",flat_name:"process.parent.pe.company",ignore_above:1024,level:"extended",name:"company",normalize:[],original_fieldset:"pe",short:"Internal company name of the file, provided at compile-time.",type:"keyword"},"process.parent.pe.description":{dashed_name:"process-parent-pe-description",description:"Internal description of the file, provided at compile-time.",example:"Paint",flat_name:"process.parent.pe.description",ignore_above:1024,level:"extended",name:"description",normalize:[],original_fieldset:"pe",short:"Internal description of the file, provided at compile-time.",type:"keyword"},"process.parent.pe.file_version":{dashed_name:"process-parent-pe-file-version",description:"Internal version of the file, provided at compile-time.",example:"6.3.9600.17415",flat_name:"process.parent.pe.file_version",ignore_above:1024,level:"extended",name:"file_version",normalize:[],original_fieldset:"pe",short:"Process name.",type:"keyword"},"process.parent.pe.go_import_hash":{dashed_name:"process-parent-pe-go-import-hash",description:"A hash of the Go language imports in a PE file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThe algorithm used to calculate the Go symbol hash and a reference implementation are available here: https://github.com/elastic/toutoumomoma",example:"10bddcb4cee42080f76c88d9ff964491",flat_name:"process.parent.pe.go_import_hash",ignore_above:1024,level:"extended",name:"go_import_hash",normalize:[],original_fieldset:"pe",short:"A hash of the Go language imports in a PE file.",type:"keyword"},"process.parent.pe.go_imports":{dashed_name:"process-parent-pe-go-imports",description:"List of imported Go language element names and types.",flat_name:"process.parent.pe.go_imports",level:"extended",name:"go_imports",normalize:[],original_fieldset:"pe",short:"List of imported Go language element names and types.",type:"flattened"},"process.parent.pe.go_imports_names_entropy":{dashed_name:"process-parent-pe-go-imports-names-entropy",description:"Shannon entropy calculation from the list of Go imports.",flat_name:"process.parent.pe.go_imports_names_entropy",format:"number",level:"extended",name:"go_imports_names_entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the list of Go imports.",type:"long"},"process.parent.pe.go_imports_names_var_entropy":{dashed_name:"process-parent-pe-go-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of Go imports.",flat_name:"process.parent.pe.go_imports_names_var_entropy",format:"number",level:"extended",name:"go_imports_names_var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the list of Go imports.",type:"long"},"process.parent.pe.go_stripped":{dashed_name:"process-parent-pe-go-stripped",description:"Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.",flat_name:"process.parent.pe.go_stripped",level:"extended",name:"go_stripped",normalize:[],original_fieldset:"pe",short:"Whether the file is a stripped or obfuscated Go executable.",type:"boolean"},"process.parent.pe.imphash":{dashed_name:"process-parent-pe-imphash",description:"A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nLearn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html.",example:"0c6803c4e922103c4dca5963aad36ddf",flat_name:"process.parent.pe.imphash",ignore_above:1024,level:"extended",name:"imphash",normalize:[],original_fieldset:"pe",short:"A hash of the imports in a PE file.",type:"keyword"},"process.parent.pe.import_hash":{dashed_name:"process-parent-pe-import-hash",description:"A hash of the imports in a PE file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is a synonym for imphash.",example:"d41d8cd98f00b204e9800998ecf8427e",flat_name:"process.parent.pe.import_hash",ignore_above:1024,level:"extended",name:"import_hash",normalize:[],original_fieldset:"pe",short:"A hash of the imports in a PE file.",type:"keyword"},"process.parent.pe.imports":{dashed_name:"process-parent-pe-imports",description:"List of imported element names and types.",flat_name:"process.parent.pe.imports",level:"extended",name:"imports",normalize:["array"],original_fieldset:"pe",short:"List of imported element names and types.",type:"flattened"},"process.parent.pe.imports_names_entropy":{dashed_name:"process-parent-pe-imports-names-entropy",description:"Shannon entropy calculation from the list of imported element names and types.",flat_name:"process.parent.pe.imports_names_entropy",format:"number",level:"extended",name:"imports_names_entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the list of imported element names and types.",type:"long"},"process.parent.pe.imports_names_var_entropy":{dashed_name:"process-parent-pe-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of imported element names and types.",flat_name:"process.parent.pe.imports_names_var_entropy",format:"number",level:"extended",name:"imports_names_var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the list of imported element names and types.",type:"long"},"process.parent.pe.original_file_name":{dashed_name:"process-parent-pe-original-file-name",description:"Internal name of the file, provided at compile-time.",example:"MSPAINT.EXE",flat_name:"process.parent.pe.original_file_name",ignore_above:1024,level:"extended",name:"original_file_name",normalize:[],original_fieldset:"pe",short:"Internal name of the file, provided at compile-time.",type:"keyword"},"process.parent.pe.pehash":{dashed_name:"process-parent-pe-pehash",description:"A hash of the PE header and data from one or more PE sections. An pehash can be used to cluster files by transforming structural information about a file into a hash value.\nLearn more at https://www.usenix.org/legacy/events/leet09/tech/full_papers/wicherski/wicherski_html/index.html.",example:"73ff189b63cd6be375a7ff25179a38d347651975",flat_name:"process.parent.pe.pehash",ignore_above:1024,level:"extended",name:"pehash",normalize:[],original_fieldset:"pe",short:"A hash of the PE header and data from one or more PE sections.",type:"keyword"},"process.parent.pe.product":{dashed_name:"process-parent-pe-product",description:"Internal product name of the file, provided at compile-time.",example:"Microsoft® Windows® Operating System",flat_name:"process.parent.pe.product",ignore_above:1024,level:"extended",name:"product",normalize:[],original_fieldset:"pe",short:"Internal product name of the file, provided at compile-time.",type:"keyword"},"process.parent.pe.sections":{dashed_name:"process-parent-pe-sections",description:"An array containing an object for each section of the PE file.\nThe keys that should be present in these objects are defined by sub-fields underneath `pe.sections.*`.",flat_name:"process.parent.pe.sections",level:"extended",name:"sections",normalize:["array"],original_fieldset:"pe",short:"Section information of the PE file.",type:"nested"},"process.parent.pe.sections.entropy":{dashed_name:"process-parent-pe-sections-entropy",description:"Shannon entropy calculation from the section.",flat_name:"process.parent.pe.sections.entropy",format:"number",level:"extended",name:"sections.entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the section.",type:"long"},"process.parent.pe.sections.name":{dashed_name:"process-parent-pe-sections-name",description:"PE Section List name.",flat_name:"process.parent.pe.sections.name",ignore_above:1024,level:"extended",name:"sections.name",normalize:[],original_fieldset:"pe",short:"PE Section List name.",type:"keyword"},"process.parent.pe.sections.physical_size":{dashed_name:"process-parent-pe-sections-physical-size",description:"PE Section List physical size.",flat_name:"process.parent.pe.sections.physical_size",format:"bytes",level:"extended",name:"sections.physical_size",normalize:[],original_fieldset:"pe",short:"PE Section List physical size.",type:"long"},"process.parent.pe.sections.var_entropy":{dashed_name:"process-parent-pe-sections-var-entropy",description:"Variance for Shannon entropy calculation from the section.",flat_name:"process.parent.pe.sections.var_entropy",format:"number",level:"extended",name:"sections.var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the section.",type:"long"},"process.parent.pe.sections.virtual_size":{dashed_name:"process-parent-pe-sections-virtual-size",description:"PE Section List virtual size. This is always the same as `physical_size`.",flat_name:"process.parent.pe.sections.virtual_size",format:"string",level:"extended",name:"sections.virtual_size",normalize:[],original_fieldset:"pe",short:"PE Section List virtual size. This is always the same as `physical_size`.",type:"long"},"process.parent.pid":{dashed_name:"process-parent-pid",description:"Process id.",example:4242,flat_name:"process.parent.pid",format:"string",level:"core",name:"pid",normalize:[],original_fieldset:"process",short:"Process id.",type:"long"},"process.parent.real_group.id":{dashed_name:"process-parent-real-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.parent.real_group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.parent.real_group.name":{dashed_name:"process-parent-real-group-name",description:"Name of the group.",flat_name:"process.parent.real_group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.parent.real_user.id":{dashed_name:"process-parent-real-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.parent.real_user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"process.parent.real_user.name":{dashed_name:"process-parent-real-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.parent.real_user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.parent.real_user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"process.parent.saved_group.id":{dashed_name:"process-parent-saved-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.parent.saved_group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.parent.saved_group.name":{dashed_name:"process-parent-saved-group-name",description:"Name of the group.",flat_name:"process.parent.saved_group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.parent.saved_user.id":{dashed_name:"process-parent-saved-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.parent.saved_user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"process.parent.saved_user.name":{dashed_name:"process-parent-saved-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.parent.saved_user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.parent.saved_user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"process.parent.start":{dashed_name:"process-parent-start",description:"The time the process started.",example:"2016-05-23T08:05:34.853Z",flat_name:"process.parent.start",level:"extended",name:"start",normalize:[],original_fieldset:"process",short:"The time the process started.",type:"date"},"process.parent.supplemental_groups.id":{dashed_name:"process-parent-supplemental-groups-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.parent.supplemental_groups.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.parent.supplemental_groups.name":{dashed_name:"process-parent-supplemental-groups-name",description:"Name of the group.",flat_name:"process.parent.supplemental_groups.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.parent.thread.capabilities.effective":{dashed_name:"process-parent-thread-capabilities-effective",description:"This is the set of capabilities used by the kernel to perform permission checks for the thread.",example:'["CAP_BPF", "CAP_SYS_ADMIN"]',flat_name:"process.parent.thread.capabilities.effective",ignore_above:1024,level:"extended",name:"thread.capabilities.effective",normalize:["array"],original_fieldset:"process",pattern:"^(CAP_[A-Z_]+|\\d+)$",short:"Array of capabilities used for permission checks.",synthetic_source_keep:"none",type:"keyword"},"process.parent.thread.capabilities.permitted":{dashed_name:"process-parent-thread-capabilities-permitted",description:"This is a limiting superset for the effective capabilities that the thread may assume.",example:'["CAP_BPF", "CAP_SYS_ADMIN"]',flat_name:"process.parent.thread.capabilities.permitted",ignore_above:1024,level:"extended",name:"thread.capabilities.permitted",normalize:["array"],original_fieldset:"process",pattern:"^(CAP_[A-Z_]+|\\d+)$",short:"Array of capabilities a thread could assume.",synthetic_source_keep:"none",type:"keyword"},"process.parent.thread.id":{dashed_name:"process-parent-thread-id",description:"Thread ID.",example:4242,flat_name:"process.parent.thread.id",format:"string",level:"extended",name:"thread.id",normalize:[],original_fieldset:"process",short:"Thread ID.",type:"long"},"process.parent.thread.name":{dashed_name:"process-parent-thread-name",description:"Thread name.",example:"thread-0",flat_name:"process.parent.thread.name",ignore_above:1024,level:"extended",name:"thread.name",normalize:[],original_fieldset:"process",short:"Thread name.",type:"keyword"},"process.parent.title":{dashed_name:"process-parent-title",description:"Process title.\nThe proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened.",flat_name:"process.parent.title",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.parent.title.text",name:"text",type:"match_only_text"}],name:"title",normalize:[],original_fieldset:"process",short:"Process title.",type:"keyword"},"process.parent.tty":{dashed_name:"process-parent-tty",description:"Information about the controlling TTY device. If set, the process belongs to an interactive session.",flat_name:"process.parent.tty",level:"extended",name:"tty",normalize:[],original_fieldset:"process",short:"Information about the controlling TTY device.",type:"object"},"process.parent.tty.char_device.major":{dashed_name:"process-parent-tty-char-device-major",description:'The major number identifies the driver associated with the device. The character device\'s major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation.',example:4,flat_name:"process.parent.tty.char_device.major",level:"extended",name:"tty.char_device.major",normalize:[],original_fieldset:"process",short:"The TTY character device's major number.",type:"long"},"process.parent.tty.char_device.minor":{dashed_name:"process-parent-tty-char-device-minor",description:"The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them.",example:1,flat_name:"process.parent.tty.char_device.minor",level:"extended",name:"tty.char_device.minor",normalize:[],original_fieldset:"process",short:"The TTY character device's minor number.",type:"long"},"process.parent.uptime":{dashed_name:"process-parent-uptime",description:"Seconds the process has been up.",example:1325,flat_name:"process.parent.uptime",level:"extended",name:"uptime",normalize:[],original_fieldset:"process",short:"Seconds the process has been up.",type:"long"},"process.parent.user.id":{dashed_name:"process-parent-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.parent.user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"process.parent.user.name":{dashed_name:"process-parent-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.parent.user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.parent.user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"process.parent.vpid":{dashed_name:"process-parent-vpid",description:"Virtual process id.\nThe process id within a pid namespace. This is not necessarily unique across all processes on the host but it is unique within the process namespace that the process exists within.",example:4242,flat_name:"process.parent.vpid",format:"string",level:"core",name:"vpid",normalize:[],original_fieldset:"process",short:"Virtual process id.",type:"long"},"process.parent.working_directory":{dashed_name:"process-parent-working-directory",description:"The working directory of the process.",example:"/home/alice",flat_name:"process.parent.working_directory",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.parent.working_directory.text",name:"text",type:"match_only_text"}],name:"working_directory",normalize:[],original_fieldset:"process",short:"The working directory of the process.",type:"keyword"},"process.pe.architecture":{dashed_name:"process-pe-architecture",description:"CPU architecture target for the file.",example:"x64",flat_name:"process.pe.architecture",ignore_above:1024,level:"extended",name:"architecture",normalize:[],original_fieldset:"pe",short:"CPU architecture target for the file.",type:"keyword"},"process.pe.company":{dashed_name:"process-pe-company",description:"Internal company name of the file, provided at compile-time.",example:"Microsoft Corporation",flat_name:"process.pe.company",ignore_above:1024,level:"extended",name:"company",normalize:[],original_fieldset:"pe",short:"Internal company name of the file, provided at compile-time.",type:"keyword"},"process.pe.description":{dashed_name:"process-pe-description",description:"Internal description of the file, provided at compile-time.",example:"Paint",flat_name:"process.pe.description",ignore_above:1024,level:"extended",name:"description",normalize:[],original_fieldset:"pe",short:"Internal description of the file, provided at compile-time.",type:"keyword"},"process.pe.file_version":{dashed_name:"process-pe-file-version",description:"Internal version of the file, provided at compile-time.",example:"6.3.9600.17415",flat_name:"process.pe.file_version",ignore_above:1024,level:"extended",name:"file_version",normalize:[],original_fieldset:"pe",short:"Process name.",type:"keyword"},"process.pe.go_import_hash":{dashed_name:"process-pe-go-import-hash",description:"A hash of the Go language imports in a PE file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThe algorithm used to calculate the Go symbol hash and a reference implementation are available here: https://github.com/elastic/toutoumomoma",example:"10bddcb4cee42080f76c88d9ff964491",flat_name:"process.pe.go_import_hash",ignore_above:1024,level:"extended",name:"go_import_hash",normalize:[],original_fieldset:"pe",short:"A hash of the Go language imports in a PE file.",type:"keyword"},"process.pe.go_imports":{dashed_name:"process-pe-go-imports",description:"List of imported Go language element names and types.",flat_name:"process.pe.go_imports",level:"extended",name:"go_imports",normalize:[],original_fieldset:"pe",short:"List of imported Go language element names and types.",type:"flattened"},"process.pe.go_imports_names_entropy":{dashed_name:"process-pe-go-imports-names-entropy",description:"Shannon entropy calculation from the list of Go imports.",flat_name:"process.pe.go_imports_names_entropy",format:"number",level:"extended",name:"go_imports_names_entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the list of Go imports.",type:"long"},"process.pe.go_imports_names_var_entropy":{dashed_name:"process-pe-go-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of Go imports.",flat_name:"process.pe.go_imports_names_var_entropy",format:"number",level:"extended",name:"go_imports_names_var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the list of Go imports.",type:"long"},"process.pe.go_stripped":{dashed_name:"process-pe-go-stripped",description:"Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.",flat_name:"process.pe.go_stripped",level:"extended",name:"go_stripped",normalize:[],original_fieldset:"pe",short:"Whether the file is a stripped or obfuscated Go executable.",type:"boolean"},"process.pe.imphash":{dashed_name:"process-pe-imphash",description:"A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nLearn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html.",example:"0c6803c4e922103c4dca5963aad36ddf",flat_name:"process.pe.imphash",ignore_above:1024,level:"extended",name:"imphash",normalize:[],original_fieldset:"pe",short:"A hash of the imports in a PE file.",type:"keyword"},"process.pe.import_hash":{dashed_name:"process-pe-import-hash",description:"A hash of the imports in a PE file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is a synonym for imphash.",example:"d41d8cd98f00b204e9800998ecf8427e",flat_name:"process.pe.import_hash",ignore_above:1024,level:"extended",name:"import_hash",normalize:[],original_fieldset:"pe",short:"A hash of the imports in a PE file.",type:"keyword"},"process.pe.imports":{dashed_name:"process-pe-imports",description:"List of imported element names and types.",flat_name:"process.pe.imports",level:"extended",name:"imports",normalize:["array"],original_fieldset:"pe",short:"List of imported element names and types.",type:"flattened"},"process.pe.imports_names_entropy":{dashed_name:"process-pe-imports-names-entropy",description:"Shannon entropy calculation from the list of imported element names and types.",flat_name:"process.pe.imports_names_entropy",format:"number",level:"extended",name:"imports_names_entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the list of imported element names and types.",type:"long"},"process.pe.imports_names_var_entropy":{dashed_name:"process-pe-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of imported element names and types.",flat_name:"process.pe.imports_names_var_entropy",format:"number",level:"extended",name:"imports_names_var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the list of imported element names and types.",type:"long"},"process.pe.original_file_name":{dashed_name:"process-pe-original-file-name",description:"Internal name of the file, provided at compile-time.",example:"MSPAINT.EXE",flat_name:"process.pe.original_file_name",ignore_above:1024,level:"extended",name:"original_file_name",normalize:[],original_fieldset:"pe",short:"Internal name of the file, provided at compile-time.",type:"keyword"},"process.pe.pehash":{dashed_name:"process-pe-pehash",description:"A hash of the PE header and data from one or more PE sections. An pehash can be used to cluster files by transforming structural information about a file into a hash value.\nLearn more at https://www.usenix.org/legacy/events/leet09/tech/full_papers/wicherski/wicherski_html/index.html.",example:"73ff189b63cd6be375a7ff25179a38d347651975",flat_name:"process.pe.pehash",ignore_above:1024,level:"extended",name:"pehash",normalize:[],original_fieldset:"pe",short:"A hash of the PE header and data from one or more PE sections.",type:"keyword"},"process.pe.product":{dashed_name:"process-pe-product",description:"Internal product name of the file, provided at compile-time.",example:"Microsoft® Windows® Operating System",flat_name:"process.pe.product",ignore_above:1024,level:"extended",name:"product",normalize:[],original_fieldset:"pe",short:"Internal product name of the file, provided at compile-time.",type:"keyword"},"process.pe.sections":{dashed_name:"process-pe-sections",description:"An array containing an object for each section of the PE file.\nThe keys that should be present in these objects are defined by sub-fields underneath `pe.sections.*`.",flat_name:"process.pe.sections",level:"extended",name:"sections",normalize:["array"],original_fieldset:"pe",short:"Section information of the PE file.",type:"nested"},"process.pe.sections.entropy":{dashed_name:"process-pe-sections-entropy",description:"Shannon entropy calculation from the section.",flat_name:"process.pe.sections.entropy",format:"number",level:"extended",name:"sections.entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the section.",type:"long"},"process.pe.sections.name":{dashed_name:"process-pe-sections-name",description:"PE Section List name.",flat_name:"process.pe.sections.name",ignore_above:1024,level:"extended",name:"sections.name",normalize:[],original_fieldset:"pe",short:"PE Section List name.",type:"keyword"},"process.pe.sections.physical_size":{dashed_name:"process-pe-sections-physical-size",description:"PE Section List physical size.",flat_name:"process.pe.sections.physical_size",format:"bytes",level:"extended",name:"sections.physical_size",normalize:[],original_fieldset:"pe",short:"PE Section List physical size.",type:"long"},"process.pe.sections.var_entropy":{dashed_name:"process-pe-sections-var-entropy",description:"Variance for Shannon entropy calculation from the section.",flat_name:"process.pe.sections.var_entropy",format:"number",level:"extended",name:"sections.var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the section.",type:"long"},"process.pe.sections.virtual_size":{dashed_name:"process-pe-sections-virtual-size",description:"PE Section List virtual size. This is always the same as `physical_size`.",flat_name:"process.pe.sections.virtual_size",format:"string",level:"extended",name:"sections.virtual_size",normalize:[],original_fieldset:"pe",short:"PE Section List virtual size. This is always the same as `physical_size`.",type:"long"},"process.pid":{dashed_name:"process-pid",description:"Process id.",example:4242,flat_name:"process.pid",format:"string",level:"core",name:"pid",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Process id.",type:"long"},"process.previous.args":{dashed_name:"process-previous-args",description:"Array of process arguments, starting with the absolute path to the executable.\nMay be filtered to protect sensitive information.",example:'["/usr/bin/ssh", "-l", "user", "10.0.0.16"]',flat_name:"process.previous.args",ignore_above:1024,level:"extended",name:"args",normalize:["array"],original_fieldset:"process",short:"Array of process arguments.",type:"keyword"},"process.previous.args_count":{dashed_name:"process-previous-args-count",description:"Length of the process.args array.\nThis field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity.",example:4,flat_name:"process.previous.args_count",level:"extended",name:"args_count",normalize:[],original_fieldset:"process",short:"Length of the process.args array.",type:"long"},"process.previous.executable":{dashed_name:"process-previous-executable",description:"Absolute path to the process executable.",example:"/usr/bin/ssh",flat_name:"process.previous.executable",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.previous.executable.text",name:"text",type:"match_only_text"}],name:"executable",normalize:[],original_fieldset:"process",short:"Absolute path to the process executable.",type:"keyword"},"process.real_group.id":{dashed_name:"process-real-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.real_group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.real_group.name":{dashed_name:"process-real-group-name",description:"Name of the group.",flat_name:"process.real_group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.real_user.id":{dashed_name:"process-real-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.real_user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",otel:[{relation:"match",stability:"experimental"}],short:"Unique identifier of the user.",type:"keyword"},"process.real_user.name":{dashed_name:"process-real-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.real_user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.real_user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",otel:[{relation:"match",stability:"experimental"}],short:"Short name or login of the user.",type:"keyword"},"process.saved_group.id":{dashed_name:"process-saved-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.saved_group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.saved_group.name":{dashed_name:"process-saved-group-name",description:"Name of the group.",flat_name:"process.saved_group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.saved_user.id":{dashed_name:"process-saved-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.saved_user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",otel:[{relation:"match",stability:"experimental"}],short:"Unique identifier of the user.",type:"keyword"},"process.saved_user.name":{dashed_name:"process-saved-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.saved_user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.saved_user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",otel:[{relation:"match",stability:"experimental"}],short:"Short name or login of the user.",type:"keyword"},"process.session_leader.args":{dashed_name:"process-session-leader-args",description:"Array of process arguments, starting with the absolute path to the executable.\nMay be filtered to protect sensitive information.",example:'["/usr/bin/ssh", "-l", "user", "10.0.0.16"]',flat_name:"process.session_leader.args",ignore_above:1024,level:"extended",name:"args",normalize:["array"],original_fieldset:"process",short:"Array of process arguments.",type:"keyword"},"process.session_leader.args_count":{dashed_name:"process-session-leader-args-count",description:"Length of the process.args array.\nThis field can be useful for querying or performing bucket analysis on how many arguments were provided to start a process. More arguments may be an indication of suspicious activity.",example:4,flat_name:"process.session_leader.args_count",level:"extended",name:"args_count",normalize:[],original_fieldset:"process",short:"Length of the process.args array.",type:"long"},"process.session_leader.command_line":{dashed_name:"process-session-leader-command-line",description:"Full command line that started the process, including the absolute path to the executable, and all arguments.\nSome arguments may be filtered to protect sensitive information.",example:"/usr/bin/ssh -l user 10.0.0.16",flat_name:"process.session_leader.command_line",level:"extended",multi_fields:[{flat_name:"process.session_leader.command_line.text",name:"text",type:"match_only_text"}],name:"command_line",normalize:[],original_fieldset:"process",short:"Full command line that started the process.",type:"wildcard"},"process.session_leader.entity_id":{dashed_name:"process-session-leader-entity-id",description:"Unique identifier for the process.\nThe implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process.\nConstructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.",example:"c2c455d9f99375d",flat_name:"process.session_leader.entity_id",ignore_above:1024,level:"extended",name:"entity_id",normalize:[],original_fieldset:"process",short:"Unique identifier for the process.",type:"keyword"},"process.session_leader.executable":{dashed_name:"process-session-leader-executable",description:"Absolute path to the process executable.",example:"/usr/bin/ssh",flat_name:"process.session_leader.executable",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.session_leader.executable.text",name:"text",type:"match_only_text"}],name:"executable",normalize:[],original_fieldset:"process",short:"Absolute path to the process executable.",type:"keyword"},"process.session_leader.group.id":{dashed_name:"process-session-leader-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.session_leader.group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.session_leader.group.name":{dashed_name:"process-session-leader-group-name",description:"Name of the group.",flat_name:"process.session_leader.group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.session_leader.interactive":{dashed_name:"process-session-leader-interactive",description:"Whether the process is connected to an interactive shell.\nProcess interactivity is inferred from the processes file descriptors. If the character device for the controlling tty is the same as stdin and stderr for the process, the process is considered interactive.\nNote: A non-interactive process can belong to an interactive session and is simply one that does not have open file descriptors reading the controlling TTY on FD 0 (stdin) or writing to the controlling TTY on FD 2 (stderr). A backgrounded process is still considered interactive if stdin and stderr are connected to the controlling TTY.",example:!0,flat_name:"process.session_leader.interactive",level:"extended",name:"interactive",normalize:[],original_fieldset:"process",short:"Whether the process is connected to an interactive shell.",type:"boolean"},"process.session_leader.name":{dashed_name:"process-session-leader-name",description:"Process name.\nSometimes called program name or similar.",example:"ssh",flat_name:"process.session_leader.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.session_leader.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"process",short:"Process name.",type:"keyword"},"process.session_leader.parent.entity_id":{dashed_name:"process-session-leader-parent-entity-id",description:"Unique identifier for the process.\nThe implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process.\nConstructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.",example:"c2c455d9f99375d",flat_name:"process.session_leader.parent.entity_id",ignore_above:1024,level:"extended",name:"entity_id",normalize:[],original_fieldset:"process",short:"Unique identifier for the process.",type:"keyword"},"process.session_leader.parent.pid":{dashed_name:"process-session-leader-parent-pid",description:"Process id.",example:4242,flat_name:"process.session_leader.parent.pid",format:"string",level:"core",name:"pid",normalize:[],original_fieldset:"process",short:"Process id.",type:"long"},"process.session_leader.parent.session_leader.entity_id":{dashed_name:"process-session-leader-parent-session-leader-entity-id",description:"Unique identifier for the process.\nThe implementation of this is specified by the data source, but some examples of what could be used here are a process-generated UUID, Sysmon Process GUIDs, or a hash of some uniquely identifying components of a process.\nConstructing a globally unique identifier is a common practice to mitigate PID reuse as well as to identify a specific process over time, across multiple monitored hosts.",example:"c2c455d9f99375d",flat_name:"process.session_leader.parent.session_leader.entity_id",ignore_above:1024,level:"extended",name:"entity_id",normalize:[],original_fieldset:"process",short:"Unique identifier for the process.",type:"keyword"},"process.session_leader.parent.session_leader.pid":{dashed_name:"process-session-leader-parent-session-leader-pid",description:"Process id.",example:4242,flat_name:"process.session_leader.parent.session_leader.pid",format:"string",level:"core",name:"pid",normalize:[],original_fieldset:"process",short:"Process id.",type:"long"},"process.session_leader.parent.session_leader.start":{dashed_name:"process-session-leader-parent-session-leader-start",description:"The time the process started.",example:"2016-05-23T08:05:34.853Z",flat_name:"process.session_leader.parent.session_leader.start",level:"extended",name:"start",normalize:[],original_fieldset:"process",short:"The time the process started.",type:"date"},"process.session_leader.parent.session_leader.vpid":{dashed_name:"process-session-leader-parent-session-leader-vpid",description:"Virtual process id.\nThe process id within a pid namespace. This is not necessarily unique across all processes on the host but it is unique within the process namespace that the process exists within.",example:4242,flat_name:"process.session_leader.parent.session_leader.vpid",format:"string",level:"core",name:"vpid",normalize:[],original_fieldset:"process",short:"Virtual process id.",type:"long"},"process.session_leader.parent.start":{dashed_name:"process-session-leader-parent-start",description:"The time the process started.",example:"2016-05-23T08:05:34.853Z",flat_name:"process.session_leader.parent.start",level:"extended",name:"start",normalize:[],original_fieldset:"process",short:"The time the process started.",type:"date"},"process.session_leader.parent.vpid":{dashed_name:"process-session-leader-parent-vpid",description:"Virtual process id.\nThe process id within a pid namespace. This is not necessarily unique across all processes on the host but it is unique within the process namespace that the process exists within.",example:4242,flat_name:"process.session_leader.parent.vpid",format:"string",level:"core",name:"vpid",normalize:[],original_fieldset:"process",short:"Virtual process id.",type:"long"},"process.session_leader.pid":{dashed_name:"process-session-leader-pid",description:"Process id.",example:4242,flat_name:"process.session_leader.pid",format:"string",level:"core",name:"pid",normalize:[],original_fieldset:"process",otel:[{relation:"match",stability:"experimental"}],short:"Process id.",type:"long"},"process.session_leader.real_group.id":{dashed_name:"process-session-leader-real-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.session_leader.real_group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.session_leader.real_group.name":{dashed_name:"process-session-leader-real-group-name",description:"Name of the group.",flat_name:"process.session_leader.real_group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.session_leader.real_user.id":{dashed_name:"process-session-leader-real-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.session_leader.real_user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"process.session_leader.real_user.name":{dashed_name:"process-session-leader-real-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.session_leader.real_user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.session_leader.real_user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"process.session_leader.same_as_process":{dashed_name:"process-session-leader-same-as-process",description:"This boolean is used to identify if a leader process is the same as the top level process.\nFor example, if `process.group_leader.same_as_process = true`, it means the process event in question is the leader of its process group. Details under `process.*` like `pid` would be the same under `process.group_leader.*` The same applies for both `process.session_leader` and `process.entry_leader`.\nThis field exists to the benefit of EQL and other rule engines since it's not possible to compare equality between two fields in a single document. e.g `process.entity_id` = `process.group_leader.entity_id` (top level process is the process group leader) OR `process.entity_id` = `process.entry_leader.entity_id` (top level process is the entry session leader)\nInstead these rules could be written like: `process.group_leader.same_as_process: true` OR `process.entry_leader.same_as_process: true`\nNote: This field is only set on `process.entry_leader`, `process.session_leader` and `process.group_leader`.",example:!0,flat_name:"process.session_leader.same_as_process",level:"extended",name:"same_as_process",normalize:[],original_fieldset:"process",short:"This boolean is used to identify if a leader process is the same as the top level process.",type:"boolean"},"process.session_leader.saved_group.id":{dashed_name:"process-session-leader-saved-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.session_leader.saved_group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.session_leader.saved_group.name":{dashed_name:"process-session-leader-saved-group-name",description:"Name of the group.",flat_name:"process.session_leader.saved_group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.session_leader.saved_user.id":{dashed_name:"process-session-leader-saved-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.session_leader.saved_user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"process.session_leader.saved_user.name":{dashed_name:"process-session-leader-saved-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.session_leader.saved_user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.session_leader.saved_user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"process.session_leader.start":{dashed_name:"process-session-leader-start",description:"The time the process started.",example:"2016-05-23T08:05:34.853Z",flat_name:"process.session_leader.start",level:"extended",name:"start",normalize:[],original_fieldset:"process",short:"The time the process started.",type:"date"},"process.session_leader.supplemental_groups.id":{dashed_name:"process-session-leader-supplemental-groups-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.session_leader.supplemental_groups.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.session_leader.supplemental_groups.name":{dashed_name:"process-session-leader-supplemental-groups-name",description:"Name of the group.",flat_name:"process.session_leader.supplemental_groups.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.session_leader.tty":{dashed_name:"process-session-leader-tty",description:"Information about the controlling TTY device. If set, the process belongs to an interactive session.",flat_name:"process.session_leader.tty",level:"extended",name:"tty",normalize:[],original_fieldset:"process",short:"Information about the controlling TTY device.",type:"object"},"process.session_leader.tty.char_device.major":{dashed_name:"process-session-leader-tty-char-device-major",description:'The major number identifies the driver associated with the device. The character device\'s major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation.',example:4,flat_name:"process.session_leader.tty.char_device.major",level:"extended",name:"tty.char_device.major",normalize:[],original_fieldset:"process",short:"The TTY character device's major number.",type:"long"},"process.session_leader.tty.char_device.minor":{dashed_name:"process-session-leader-tty-char-device-minor",description:"The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them.",example:1,flat_name:"process.session_leader.tty.char_device.minor",level:"extended",name:"tty.char_device.minor",normalize:[],original_fieldset:"process",short:"The TTY character device's minor number.",type:"long"},"process.session_leader.user.id":{dashed_name:"process-session-leader-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.session_leader.user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"process.session_leader.user.name":{dashed_name:"process-session-leader-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.session_leader.user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.session_leader.user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"process.session_leader.vpid":{dashed_name:"process-session-leader-vpid",description:"Virtual process id.\nThe process id within a pid namespace. This is not necessarily unique across all processes on the host but it is unique within the process namespace that the process exists within.",example:4242,flat_name:"process.session_leader.vpid",format:"string",level:"core",name:"vpid",normalize:[],original_fieldset:"process",short:"Virtual process id.",type:"long"},"process.session_leader.working_directory":{dashed_name:"process-session-leader-working-directory",description:"The working directory of the process.",example:"/home/alice",flat_name:"process.session_leader.working_directory",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.session_leader.working_directory.text",name:"text",type:"match_only_text"}],name:"working_directory",normalize:[],original_fieldset:"process",short:"The working directory of the process.",type:"keyword"},"process.start":{dashed_name:"process-start",description:"The time the process started.",example:"2016-05-23T08:05:34.853Z",flat_name:"process.start",level:"extended",name:"start",normalize:[],short:"The time the process started.",type:"date"},"process.supplemental_groups.id":{dashed_name:"process-supplemental-groups-id",description:"Unique identifier for the group on the system/platform.",flat_name:"process.supplemental_groups.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"process.supplemental_groups.name":{dashed_name:"process-supplemental-groups-name",description:"Name of the group.",flat_name:"process.supplemental_groups.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"process.thread.capabilities.effective":{dashed_name:"process-thread-capabilities-effective",description:"This is the set of capabilities used by the kernel to perform permission checks for the thread.",example:'["CAP_BPF", "CAP_SYS_ADMIN"]',flat_name:"process.thread.capabilities.effective",ignore_above:1024,level:"extended",name:"thread.capabilities.effective",normalize:["array"],pattern:"^(CAP_[A-Z_]+|\\d+)$",short:"Array of capabilities used for permission checks.",synthetic_source_keep:"none",type:"keyword"},"process.thread.capabilities.permitted":{dashed_name:"process-thread-capabilities-permitted",description:"This is a limiting superset for the effective capabilities that the thread may assume.",example:'["CAP_BPF", "CAP_SYS_ADMIN"]',flat_name:"process.thread.capabilities.permitted",ignore_above:1024,level:"extended",name:"thread.capabilities.permitted",normalize:["array"],pattern:"^(CAP_[A-Z_]+|\\d+)$",short:"Array of capabilities a thread could assume.",synthetic_source_keep:"none",type:"keyword"},"process.thread.id":{dashed_name:"process-thread-id",description:"Thread ID.",example:4242,flat_name:"process.thread.id",format:"string",level:"extended",name:"thread.id",normalize:[],short:"Thread ID.",type:"long"},"process.thread.name":{dashed_name:"process-thread-name",description:"Thread name.",example:"thread-0",flat_name:"process.thread.name",ignore_above:1024,level:"extended",name:"thread.name",normalize:[],short:"Thread name.",type:"keyword"},"process.title":{dashed_name:"process-title",description:"Process title.\nThe proctitle, some times the same as process name. Can also be different: for example a browser setting its title to the web page currently opened.",flat_name:"process.title",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.title.text",name:"text",type:"match_only_text"}],name:"title",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Process title.",type:"keyword"},"process.tty":{dashed_name:"process-tty",description:"Information about the controlling TTY device. If set, the process belongs to an interactive session.",flat_name:"process.tty",level:"extended",name:"tty",normalize:[],short:"Information about the controlling TTY device.",type:"object"},"process.tty.char_device.major":{dashed_name:"process-tty-char-device-major",description:'The major number identifies the driver associated with the device. The character device\'s major and minor numbers can be algorithmically combined to produce the more familiar terminal identifiers such as "ttyS0" and "pts/0". For more details, please refer to the Linux kernel documentation.',example:4,flat_name:"process.tty.char_device.major",level:"extended",name:"tty.char_device.major",normalize:[],short:"The TTY character device's major number.",type:"long"},"process.tty.char_device.minor":{dashed_name:"process-tty-char-device-minor",description:"The minor number is used only by the driver specified by the major number; other parts of the kernel don’t use it, and merely pass it along to the driver. It is common for a driver to control several devices; the minor number provides a way for the driver to differentiate among them.",example:1,flat_name:"process.tty.char_device.minor",level:"extended",name:"tty.char_device.minor",normalize:[],short:"The TTY character device's minor number.",type:"long"},"process.tty.columns":{dashed_name:"process-tty-columns",description:"The number of character columns per line. e.g terminal width\nTerminal sizes can change, so this value reflects the maximum value for a given IO event. i.e. where event.action = 'text_output'",example:80,flat_name:"process.tty.columns",level:"extended",name:"tty.columns",normalize:[],short:"The number of character columns per line. e.g terminal width",type:"long"},"process.tty.rows":{dashed_name:"process-tty-rows",description:"The number of character rows in the terminal. e.g terminal height\nTerminal sizes can change, so this value reflects the maximum value for a given IO event. i.e. where event.action = 'text_output'",example:24,flat_name:"process.tty.rows",level:"extended",name:"tty.rows",normalize:[],short:"The number of character rows in the terminal. e.g terminal height",type:"long"},"process.uptime":{dashed_name:"process-uptime",description:"Seconds the process has been up.",example:1325,flat_name:"process.uptime",level:"extended",name:"uptime",normalize:[],otel:[{metric:"process.uptime",relation:"metric",stability:"experimental"}],short:"Seconds the process has been up.",type:"long"},"process.user.id":{dashed_name:"process-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"process.user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",otel:[{relation:"match",stability:"experimental"}],short:"Unique identifier of the user.",type:"keyword"},"process.user.name":{dashed_name:"process-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"process.user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"process.user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",otel:[{relation:"match",stability:"experimental"}],short:"Short name or login of the user.",type:"keyword"},"process.vpid":{dashed_name:"process-vpid",description:"Virtual process id.\nThe process id within a pid namespace. This is not necessarily unique across all processes on the host but it is unique within the process namespace that the process exists within.",example:4242,flat_name:"process.vpid",format:"string",level:"core",name:"vpid",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Virtual process id.",type:"long"},"process.working_directory":{dashed_name:"process-working-directory",description:"The working directory of the process.",example:"/home/alice",flat_name:"process.working_directory",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"process.working_directory.text",name:"text",type:"match_only_text"}],name:"working_directory",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"The working directory of the process.",type:"keyword"},"registry.data.bytes":{dashed_name:"registry-data-bytes",description:"Original bytes written with base64 encoding.\nFor Windows registry operations, such as SetValueEx and RegQueryValueEx, this corresponds to the data pointed by `lp_data`. This is optional but provides better recoverability and should be populated for REG_BINARY encoded values.",example:"ZQBuAC0AVQBTAAAAZQBuAAAAAAA=",flat_name:"registry.data.bytes",ignore_above:1024,level:"extended",name:"data.bytes",normalize:[],short:"Original bytes written with base64 encoding.",type:"keyword"},"registry.data.strings":{dashed_name:"registry-data-strings",description:'Content when writing string types.\nPopulated as an array when writing string data to the registry. For single string registry types (REG_SZ, REG_EXPAND_SZ), this should be an array with one string. For sequences of string with REG_MULTI_SZ, this array will be variable length. For numeric data, such as REG_DWORD and REG_QWORD, this should be populated with the decimal representation (e.g `"1"`).',example:'["C:\\rta\\red_ttp\\bin\\myapp.exe"]',flat_name:"registry.data.strings",level:"core",name:"data.strings",normalize:["array"],short:"List of strings representing what was written to the registry.",type:"wildcard"},"registry.data.type":{dashed_name:"registry-data-type",description:"Standard registry type for encoding contents",example:"REG_SZ",flat_name:"registry.data.type",ignore_above:1024,level:"core",name:"data.type",normalize:[],short:"Standard registry type for encoding contents",type:"keyword"},"registry.hive":{dashed_name:"registry-hive",description:"Abbreviated name for the hive.",example:"HKLM",flat_name:"registry.hive",ignore_above:1024,level:"core",name:"hive",normalize:[],short:"Abbreviated name for the hive.",type:"keyword"},"registry.key":{dashed_name:"registry-key",description:"Hive-relative path of keys.",example:"SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Image File Execution Options\\winword.exe",flat_name:"registry.key",ignore_above:1024,level:"core",name:"key",normalize:[],short:"Hive-relative path of keys.",type:"keyword"},"registry.path":{dashed_name:"registry-path",description:"Full path, including hive, key and value",example:"HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Image File Execution Options\\winword.exe\\Debugger",flat_name:"registry.path",ignore_above:1024,level:"core",name:"path",normalize:[],short:"Full path, including hive, key and value",type:"keyword"},"registry.value":{dashed_name:"registry-value",description:"Name of the value written.",example:"Debugger",flat_name:"registry.value",ignore_above:1024,level:"core",name:"value",normalize:[],short:"Name of the value written.",type:"keyword"},"related.hash":{dashed_name:"related-hash",description:"All the hashes seen on your event. Populating this field, then using it to search for hashes can help in situations where you're unsure what the hash algorithm is (and therefore which key name to search).",flat_name:"related.hash",ignore_above:1024,level:"extended",name:"hash",normalize:["array"],otel:[{relation:"na"}],short:"All the hashes seen on your event.",synthetic_source_keep:"none",type:"keyword"},"related.hosts":{dashed_name:"related-hosts",description:"All hostnames or other host identifiers seen on your event. Example identifiers include FQDNs, domain names, workstation names, or aliases.",flat_name:"related.hosts",ignore_above:1024,level:"extended",name:"hosts",normalize:["array"],otel:[{relation:"na"}],short:"All the host identifiers seen on your event.",synthetic_source_keep:"none",type:"keyword"},"related.ip":{dashed_name:"related-ip",description:"All of the IPs seen on your event.",flat_name:"related.ip",level:"extended",name:"ip",normalize:["array"],otel:[{relation:"na"}],short:"All of the IPs seen on your event.",synthetic_source_keep:"none",type:"ip"},"related.user":{dashed_name:"related-user",description:"All the user names or other user identifiers seen on the event.",flat_name:"related.user",ignore_above:1024,level:"extended",name:"user",normalize:["array"],otel:[{relation:"na"}],short:"All the user names or other user identifiers seen on the event.",synthetic_source_keep:"none",type:"keyword"},"rule.author":{dashed_name:"rule-author",description:"Name, organization, or pseudonym of the author or authors who created the rule used to generate this event.",example:'["Star-Lord"]',flat_name:"rule.author",ignore_above:1024,level:"extended",name:"author",normalize:["array"],short:"Rule author",synthetic_source_keep:"none",type:"keyword"},"rule.category":{dashed_name:"rule-category",description:"A categorization value keyword used by the entity using the rule for detection of this event.",example:"Attempted Information Leak",flat_name:"rule.category",ignore_above:1024,level:"extended",name:"category",normalize:[],short:"Rule category",type:"keyword"},"rule.description":{dashed_name:"rule-description",description:"The description of the rule generating the event.",example:"Block requests to public DNS over HTTPS / TLS protocols",flat_name:"rule.description",ignore_above:1024,level:"extended",name:"description",normalize:[],short:"Rule description",type:"keyword"},"rule.id":{dashed_name:"rule-id",description:"A rule ID that is unique within the scope of an agent, observer, or other entity using the rule for detection of this event.",example:101,flat_name:"rule.id",ignore_above:1024,level:"extended",name:"id",normalize:[],short:"Rule ID",type:"keyword"},"rule.license":{dashed_name:"rule-license",description:"Name of the license under which the rule used to generate this event is made available.",example:"Apache 2.0",flat_name:"rule.license",ignore_above:1024,level:"extended",name:"license",normalize:[],short:"Rule license",type:"keyword"},"rule.name":{dashed_name:"rule-name",description:"The name of the rule or signature generating the event.",example:"BLOCK_DNS_over_TLS",flat_name:"rule.name",ignore_above:1024,level:"extended",name:"name",normalize:[],short:"Rule name",type:"keyword"},"rule.reference":{dashed_name:"rule-reference",description:"Reference URL to additional information about the rule used to generate this event.\nThe URL can point to the vendor's documentation about the rule. If that's not available, it can also be a link to a more general page describing this type of alert.",example:"https://en.wikipedia.org/wiki/DNS_over_TLS",flat_name:"rule.reference",ignore_above:1024,level:"extended",name:"reference",normalize:[],short:"Rule reference URL",type:"keyword"},"rule.ruleset":{dashed_name:"rule-ruleset",description:"Name of the ruleset, policy, group, or parent category in which the rule used to generate this event is a member.",example:"Standard_Protocol_Filters",flat_name:"rule.ruleset",ignore_above:1024,level:"extended",name:"ruleset",normalize:[],short:"Rule ruleset",type:"keyword"},"rule.uuid":{dashed_name:"rule-uuid",description:"A rule ID that is unique within the scope of a set or group of agents, observers, or other entities using the rule for detection of this event.",example:1100110011,flat_name:"rule.uuid",ignore_above:1024,level:"extended",name:"uuid",normalize:[],short:"Rule UUID",type:"keyword"},"rule.version":{dashed_name:"rule-version",description:"The version / revision of the rule being used for analysis.",example:1.1,flat_name:"rule.version",ignore_above:1024,level:"extended",name:"version",normalize:[],short:"Rule version",type:"keyword"},"server.address":{dashed_name:"server-address",description:"Some event server addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field.\nThen it should be duplicated to `.ip` or `.domain`, depending on which one it is.",flat_name:"server.address",ignore_above:1024,level:"extended",name:"address",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"Server network address.",type:"keyword"},"server.as.number":{dashed_name:"server-as-number",description:"Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.",example:15169,flat_name:"server.as.number",level:"extended",name:"number",normalize:[],original_fieldset:"as",short:"Unique number allocated to the autonomous system.",type:"long"},"server.as.organization.name":{dashed_name:"server-as-organization-name",description:"Organization name.",example:"Google LLC",flat_name:"server.as.organization.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"server.as.organization.name.text",name:"text",type:"match_only_text"}],name:"organization.name",normalize:[],original_fieldset:"as",short:"Organization name.",type:"keyword"},"server.bytes":{dashed_name:"server-bytes",description:"Bytes sent from the server to the client.",example:184,flat_name:"server.bytes",format:"bytes",level:"core",name:"bytes",normalize:[],short:"Bytes sent from the server to the client.",type:"long"},"server.domain":{dashed_name:"server-domain",description:"The domain name of the server system.\nThis value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.",example:"foo.example.com",flat_name:"server.domain",ignore_above:1024,level:"core",name:"domain",normalize:[],short:"The domain name of the server.",type:"keyword"},"server.geo.city_name":{dashed_name:"server-geo-city-name",description:"City name.",example:"Montreal",flat_name:"server.geo.city_name",ignore_above:1024,level:"core",name:"city_name",normalize:[],original_fieldset:"geo",short:"City name.",type:"keyword"},"server.geo.continent_code":{dashed_name:"server-geo-continent-code",description:"Two-letter code representing continent's name.",example:"NA",flat_name:"server.geo.continent_code",ignore_above:1024,level:"core",name:"continent_code",normalize:[],original_fieldset:"geo",short:"Continent code.",type:"keyword"},"server.geo.continent_name":{dashed_name:"server-geo-continent-name",description:"Name of the continent.",example:"North America",flat_name:"server.geo.continent_name",ignore_above:1024,level:"core",name:"continent_name",normalize:[],original_fieldset:"geo",short:"Name of the continent.",type:"keyword"},"server.geo.country_iso_code":{dashed_name:"server-geo-country-iso-code",description:"Country ISO code.",example:"CA",flat_name:"server.geo.country_iso_code",ignore_above:1024,level:"core",name:"country_iso_code",normalize:[],original_fieldset:"geo",short:"Country ISO code.",type:"keyword"},"server.geo.country_name":{dashed_name:"server-geo-country-name",description:"Country name.",example:"Canada",flat_name:"server.geo.country_name",ignore_above:1024,level:"core",name:"country_name",normalize:[],original_fieldset:"geo",short:"Country name.",type:"keyword"},"server.geo.location":{dashed_name:"server-geo-location",description:"Longitude and latitude.",example:'{ "lon": -73.614830, "lat": 45.505918 }',flat_name:"server.geo.location",level:"core",name:"location",normalize:[],original_fieldset:"geo",short:"Longitude and latitude.",type:"geo_point"},"server.geo.name":{dashed_name:"server-geo-name",description:"User-defined description of a location, at the level of granularity they care about.\nCould be the name of their data centers, the floor number, if this describes a local physical entity, city names.\nNot typically used in automated geolocation.",example:"boston-dc",flat_name:"server.geo.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"geo",short:"User-defined description of a location.",type:"keyword"},"server.geo.postal_code":{dashed_name:"server-geo-postal-code",description:"Postal code associated with the location.\nValues appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.",example:94040,flat_name:"server.geo.postal_code",ignore_above:1024,level:"core",name:"postal_code",normalize:[],original_fieldset:"geo",short:"Postal code.",type:"keyword"},"server.geo.region_iso_code":{dashed_name:"server-geo-region-iso-code",description:"Region ISO code.",example:"CA-QC",flat_name:"server.geo.region_iso_code",ignore_above:1024,level:"core",name:"region_iso_code",normalize:[],original_fieldset:"geo",short:"Region ISO code.",type:"keyword"},"server.geo.region_name":{dashed_name:"server-geo-region-name",description:"Region name.",example:"Quebec",flat_name:"server.geo.region_name",ignore_above:1024,level:"core",name:"region_name",normalize:[],original_fieldset:"geo",short:"Region name.",type:"keyword"},"server.geo.timezone":{dashed_name:"server-geo-timezone",description:"The time zone of the location, such as IANA time zone name.",example:"America/Argentina/Buenos_Aires",flat_name:"server.geo.timezone",ignore_above:1024,level:"core",name:"timezone",normalize:[],original_fieldset:"geo",short:"Time zone.",type:"keyword"},"server.ip":{dashed_name:"server-ip",description:"IP address of the server (IPv4 or IPv6).",flat_name:"server.ip",level:"core",name:"ip",normalize:[],short:"IP address of the server.",type:"ip"},"server.mac":{dashed_name:"server-mac",description:"MAC address of the server.\nThe notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.",example:"00-00-5E-00-53-23",flat_name:"server.mac",ignore_above:1024,level:"core",name:"mac",normalize:[],pattern:"^[A-F0-9]{2}(-[A-F0-9]{2}){5,}$",short:"MAC address of the server.",type:"keyword"},"server.nat.ip":{dashed_name:"server-nat-ip",description:"Translated ip of destination based NAT sessions (e.g. internet to private DMZ)\nTypically used with load balancers, firewalls, or routers.",flat_name:"server.nat.ip",level:"extended",name:"nat.ip",normalize:[],short:"Server NAT ip",type:"ip"},"server.nat.port":{dashed_name:"server-nat-port",description:"Translated port of destination based NAT sessions (e.g. internet to private DMZ)\nTypically used with load balancers, firewalls, or routers.",flat_name:"server.nat.port",format:"string",level:"extended",name:"nat.port",normalize:[],short:"Server NAT port",type:"long"},"server.packets":{dashed_name:"server-packets",description:"Packets sent from the server to the client.",example:12,flat_name:"server.packets",level:"core",name:"packets",normalize:[],short:"Packets sent from the server to the client.",type:"long"},"server.port":{dashed_name:"server-port",description:"Port of the server.",flat_name:"server.port",format:"string",level:"core",name:"port",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"Port of the server.",type:"long"},"server.registered_domain":{dashed_name:"server-registered-domain",description:'The highest registered server domain, stripped of the subdomain.\nFor example, the registered domain for "foo.example.com" is "example.com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".',example:"example.com",flat_name:"server.registered_domain",ignore_above:1024,level:"extended",name:"registered_domain",normalize:[],short:"The highest registered server domain, stripped of the subdomain.",type:"keyword"},"server.subdomain":{dashed_name:"server-subdomain",description:'The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain.\nFor example the subdomain portion of "www.east.mydomain.co.uk" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.',example:"east",flat_name:"server.subdomain",ignore_above:1024,level:"extended",name:"subdomain",normalize:[],short:"The subdomain of the domain.",type:"keyword"},"server.top_level_domain":{dashed_name:"server-top-level-domain",description:'The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".',example:"co.uk",flat_name:"server.top_level_domain",ignore_above:1024,level:"extended",name:"top_level_domain",normalize:[],short:"The effective top level domain (com, org, net, co.uk).",type:"keyword"},"server.user.domain":{dashed_name:"server-user-domain",description:"Name of the directory the user is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"server.user.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"user",short:"Name of the directory the user is a member of.",type:"keyword"},"server.user.email":{dashed_name:"server-user-email",description:"User email address.",flat_name:"server.user.email",ignore_above:1024,level:"extended",name:"email",normalize:[],original_fieldset:"user",short:"User email address.",type:"keyword"},"server.user.full_name":{dashed_name:"server-user-full-name",description:"User's full name, if available.",example:"Albert Einstein",flat_name:"server.user.full_name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"server.user.full_name.text",name:"text",type:"match_only_text"}],name:"full_name",normalize:[],original_fieldset:"user",short:"User's full name, if available.",type:"keyword"},"server.user.group.domain":{dashed_name:"server-user-group-domain",description:"Name of the directory the group is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"server.user.group.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"group",short:"Name of the directory the group is a member of.",type:"keyword"},"server.user.group.id":{dashed_name:"server-user-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"server.user.group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"server.user.group.name":{dashed_name:"server-user-group-name",description:"Name of the group.",flat_name:"server.user.group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"server.user.hash":{dashed_name:"server-user-hash",description:"Unique user hash to correlate information for a user in anonymized form.\nUseful if `user.id` or `user.name` contain confidential information and cannot be used.",flat_name:"server.user.hash",ignore_above:1024,level:"extended",name:"hash",normalize:[],original_fieldset:"user",short:"Unique user hash to correlate information for a user in anonymized form.",type:"keyword"},"server.user.id":{dashed_name:"server-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"server.user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"server.user.name":{dashed_name:"server-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"server.user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"server.user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"server.user.roles":{dashed_name:"server-user-roles",description:"Array of user roles at the time of the event.",example:'["kibana_admin", "reporting_user"]',flat_name:"server.user.roles",ignore_above:1024,level:"extended",name:"roles",normalize:["array"],original_fieldset:"user",short:"Array of user roles at the time of the event.",synthetic_source_keep:"none",type:"keyword"},"service.address":{dashed_name:"service-address",description:"Address where data about this service was collected from.\nThis should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).",example:"172.26.0.2:5432",flat_name:"service.address",ignore_above:1024,level:"extended",name:"address",normalize:[],short:"Address of this service.",type:"keyword"},"service.environment":{beta:"This field is beta and subject to change.",dashed_name:"service-environment",description:"Identifies the environment where the service is running.\nIf the same service runs in different environments (production, staging, QA, development, etc.), the environment can identify other instances of the same service. Can also group services and applications from the same environment.",example:"production",flat_name:"service.environment",ignore_above:1024,level:"extended",name:"environment",normalize:[],otel:[{attribute:"deployment.environment.name",relation:"equivalent",stability:"experimental"}],short:"Environment of the service.",type:"keyword"},"service.ephemeral_id":{dashed_name:"service-ephemeral-id",description:"Ephemeral identifier of this service (if one exists).\nThis id normally changes across restarts, but `service.id` does not.",example:"8a4f500f",flat_name:"service.ephemeral_id",ignore_above:1024,level:"extended",name:"ephemeral_id",normalize:[],short:"Ephemeral identifier of this service.",type:"keyword"},"service.id":{dashed_name:"service-id",description:"Unique identifier of the running service. If the service is comprised of many nodes, the `service.id` should be the same for all nodes.\nThis id should uniquely identify the service. This makes it possible to correlate logs and metrics for one specific service, no matter which particular node emitted the event.\nNote that if you need to see the events from one specific host of the service, you should filter on that `host.name` or `host.id` instead.",example:"d37e5ebfe0ae6c4972dbe9f0174a1637bb8247f6",flat_name:"service.id",ignore_above:1024,level:"core",name:"id",normalize:[],short:"Unique identifier of the running service.",type:"keyword"},"service.name":{dashed_name:"service-name",description:"Name of the service data is collected from.\nThe name of the service is normally user given. This allows for distributed services that run on multiple hosts to correlate the related instances based on the name.\nIn the case of Elasticsearch the `service.name` could contain the cluster name. For Beats the `service.name` is by default a copy of the `service.type` field if no name is specified.",example:"elasticsearch-metrics",flat_name:"service.name",ignore_above:1024,level:"core",name:"name",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"Name of the service.",type:"keyword"},"service.node.name":{dashed_name:"service-node-name",description:"Name of a service node.\nThis allows for two nodes of the same service running on the same host to be differentiated. Therefore, `service.node.name` should typically be unique across nodes of a given service.\nIn the case of Elasticsearch, the `service.node.name` could contain the unique node name within the Elasticsearch cluster. In cases where the service doesn't have the concept of a node name, the host name or container name can be used to distinguish running instances that make up this service. If those do not provide uniqueness (e.g. multiple instances of the service running on the same host) - the node name can be manually set.",example:"instance-0000000016",flat_name:"service.node.name",ignore_above:1024,level:"extended",name:"node.name",normalize:[],otel:[{attribute:"service.instance.id",relation:"equivalent",stability:"experimental"}],short:"Name of the service node.",type:"keyword"},"service.node.role":{dashed_name:"service-node-role",description:"Deprecated for removal in next major version release. This field will be superseded by `node.roles`.\nRole of a service node.\nThis allows for distinction between different running roles of the same service.\nIn the case of Kibana, the `service.node.role` could be `ui` or `background_tasks`.\nIn the case of Elasticsearch, the `service.node.role` could be `master` or `data`.\nOther services could use this to distinguish between a `web` and `worker` role running as part of the service.",example:"background_tasks",flat_name:"service.node.role",ignore_above:1024,level:"extended",name:"node.role",normalize:[],short:"Deprecated role (singular) of the service node.",type:"keyword"},"service.node.roles":{dashed_name:"service-node-roles",description:"Roles of a service node.\nThis allows for distinction between different running roles of the same service.\nIn the case of Kibana, the `service.node.role` could be `ui` or `background_tasks` or both.\nIn the case of Elasticsearch, the `service.node.role` could be `master` or `data` or both.\nOther services could use this to distinguish between a `web` and `worker` role running as part of the service.",example:'["ui", "background_tasks"]',flat_name:"service.node.roles",ignore_above:1024,level:"extended",name:"node.roles",normalize:["array"],short:"Roles of the service node.",synthetic_source_keep:"none",type:"keyword"},"service.origin.address":{dashed_name:"service-origin-address",description:"Address where data about this service was collected from.\nThis should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).",example:"172.26.0.2:5432",flat_name:"service.origin.address",ignore_above:1024,level:"extended",name:"address",normalize:[],original_fieldset:"service",short:"Address of this service.",type:"keyword"},"service.origin.environment":{beta:"This field is beta and subject to change.",dashed_name:"service-origin-environment",description:"Identifies the environment where the service is running.\nIf the same service runs in different environments (production, staging, QA, development, etc.), the environment can identify other instances of the same service. Can also group services and applications from the same environment.",example:"production",flat_name:"service.origin.environment",ignore_above:1024,level:"extended",name:"environment",normalize:[],original_fieldset:"service",short:"Environment of the service.",type:"keyword"},"service.origin.ephemeral_id":{dashed_name:"service-origin-ephemeral-id",description:"Ephemeral identifier of this service (if one exists).\nThis id normally changes across restarts, but `service.id` does not.",example:"8a4f500f",flat_name:"service.origin.ephemeral_id",ignore_above:1024,level:"extended",name:"ephemeral_id",normalize:[],original_fieldset:"service",short:"Ephemeral identifier of this service.",type:"keyword"},"service.origin.id":{dashed_name:"service-origin-id",description:"Unique identifier of the running service. If the service is comprised of many nodes, the `service.id` should be the same for all nodes.\nThis id should uniquely identify the service. This makes it possible to correlate logs and metrics for one specific service, no matter which particular node emitted the event.\nNote that if you need to see the events from one specific host of the service, you should filter on that `host.name` or `host.id` instead.",example:"d37e5ebfe0ae6c4972dbe9f0174a1637bb8247f6",flat_name:"service.origin.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"service",short:"Unique identifier of the running service.",type:"keyword"},"service.origin.name":{dashed_name:"service-origin-name",description:"Name of the service data is collected from.\nThe name of the service is normally user given. This allows for distributed services that run on multiple hosts to correlate the related instances based on the name.\nIn the case of Elasticsearch the `service.name` could contain the cluster name. For Beats the `service.name` is by default a copy of the `service.type` field if no name is specified.",example:"elasticsearch-metrics",flat_name:"service.origin.name",ignore_above:1024,level:"core",name:"name",normalize:[],original_fieldset:"service",short:"Name of the service.",type:"keyword"},"service.origin.node.name":{dashed_name:"service-origin-node-name",description:"Name of a service node.\nThis allows for two nodes of the same service running on the same host to be differentiated. Therefore, `service.node.name` should typically be unique across nodes of a given service.\nIn the case of Elasticsearch, the `service.node.name` could contain the unique node name within the Elasticsearch cluster. In cases where the service doesn't have the concept of a node name, the host name or container name can be used to distinguish running instances that make up this service. If those do not provide uniqueness (e.g. multiple instances of the service running on the same host) - the node name can be manually set.",example:"instance-0000000016",flat_name:"service.origin.node.name",ignore_above:1024,level:"extended",name:"node.name",normalize:[],original_fieldset:"service",short:"Name of the service node.",type:"keyword"},"service.origin.node.role":{dashed_name:"service-origin-node-role",description:"Deprecated for removal in next major version release. This field will be superseded by `node.roles`.\nRole of a service node.\nThis allows for distinction between different running roles of the same service.\nIn the case of Kibana, the `service.node.role` could be `ui` or `background_tasks`.\nIn the case of Elasticsearch, the `service.node.role` could be `master` or `data`.\nOther services could use this to distinguish between a `web` and `worker` role running as part of the service.",example:"background_tasks",flat_name:"service.origin.node.role",ignore_above:1024,level:"extended",name:"node.role",normalize:[],original_fieldset:"service",short:"Deprecated role (singular) of the service node.",type:"keyword"},"service.origin.node.roles":{dashed_name:"service-origin-node-roles",description:"Roles of a service node.\nThis allows for distinction between different running roles of the same service.\nIn the case of Kibana, the `service.node.role` could be `ui` or `background_tasks` or both.\nIn the case of Elasticsearch, the `service.node.role` could be `master` or `data` or both.\nOther services could use this to distinguish between a `web` and `worker` role running as part of the service.",example:'["ui", "background_tasks"]',flat_name:"service.origin.node.roles",ignore_above:1024,level:"extended",name:"node.roles",normalize:["array"],original_fieldset:"service",short:"Roles of the service node.",synthetic_source_keep:"none",type:"keyword"},"service.origin.state":{dashed_name:"service-origin-state",description:"Current state of the service.",flat_name:"service.origin.state",ignore_above:1024,level:"core",name:"state",normalize:[],original_fieldset:"service",short:"Current state of the service.",type:"keyword"},"service.origin.type":{dashed_name:"service-origin-type",description:"The type of the service data is collected from.\nThe type can be used to group and correlate logs and metrics from one service type.\nExample: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.",example:"elasticsearch",flat_name:"service.origin.type",ignore_above:1024,level:"core",name:"type",normalize:[],original_fieldset:"service",short:"The type of the service.",type:"keyword"},"service.origin.version":{dashed_name:"service-origin-version",description:"Version of the service the data was collected from.\nThis allows to look at a data set only for a specific version of a service.",example:"3.2.4",flat_name:"service.origin.version",ignore_above:1024,level:"core",name:"version",normalize:[],original_fieldset:"service",short:"Version of the service.",type:"keyword"},"service.state":{dashed_name:"service-state",description:"Current state of the service.",flat_name:"service.state",ignore_above:1024,level:"core",name:"state",normalize:[],short:"Current state of the service.",type:"keyword"},"service.target.address":{dashed_name:"service-target-address",description:"Address where data about this service was collected from.\nThis should be a URI, network address (ipv4:port or [ipv6]:port) or a resource path (sockets).",example:"172.26.0.2:5432",flat_name:"service.target.address",ignore_above:1024,level:"extended",name:"address",normalize:[],original_fieldset:"service",short:"Address of this service.",type:"keyword"},"service.target.environment":{beta:"This field is beta and subject to change.",dashed_name:"service-target-environment",description:"Identifies the environment where the service is running.\nIf the same service runs in different environments (production, staging, QA, development, etc.), the environment can identify other instances of the same service. Can also group services and applications from the same environment.",example:"production",flat_name:"service.target.environment",ignore_above:1024,level:"extended",name:"environment",normalize:[],original_fieldset:"service",short:"Environment of the service.",type:"keyword"},"service.target.ephemeral_id":{dashed_name:"service-target-ephemeral-id",description:"Ephemeral identifier of this service (if one exists).\nThis id normally changes across restarts, but `service.id` does not.",example:"8a4f500f",flat_name:"service.target.ephemeral_id",ignore_above:1024,level:"extended",name:"ephemeral_id",normalize:[],original_fieldset:"service",short:"Ephemeral identifier of this service.",type:"keyword"},"service.target.id":{dashed_name:"service-target-id",description:"Unique identifier of the running service. If the service is comprised of many nodes, the `service.id` should be the same for all nodes.\nThis id should uniquely identify the service. This makes it possible to correlate logs and metrics for one specific service, no matter which particular node emitted the event.\nNote that if you need to see the events from one specific host of the service, you should filter on that `host.name` or `host.id` instead.",example:"d37e5ebfe0ae6c4972dbe9f0174a1637bb8247f6",flat_name:"service.target.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"service",short:"Unique identifier of the running service.",type:"keyword"},"service.target.name":{dashed_name:"service-target-name",description:"Name of the service data is collected from.\nThe name of the service is normally user given. This allows for distributed services that run on multiple hosts to correlate the related instances based on the name.\nIn the case of Elasticsearch the `service.name` could contain the cluster name. For Beats the `service.name` is by default a copy of the `service.type` field if no name is specified.",example:"elasticsearch-metrics",flat_name:"service.target.name",ignore_above:1024,level:"core",name:"name",normalize:[],original_fieldset:"service",short:"Name of the service.",type:"keyword"},"service.target.node.name":{dashed_name:"service-target-node-name",description:"Name of a service node.\nThis allows for two nodes of the same service running on the same host to be differentiated. Therefore, `service.node.name` should typically be unique across nodes of a given service.\nIn the case of Elasticsearch, the `service.node.name` could contain the unique node name within the Elasticsearch cluster. In cases where the service doesn't have the concept of a node name, the host name or container name can be used to distinguish running instances that make up this service. If those do not provide uniqueness (e.g. multiple instances of the service running on the same host) - the node name can be manually set.",example:"instance-0000000016",flat_name:"service.target.node.name",ignore_above:1024,level:"extended",name:"node.name",normalize:[],original_fieldset:"service",short:"Name of the service node.",type:"keyword"},"service.target.node.role":{dashed_name:"service-target-node-role",description:"Deprecated for removal in next major version release. This field will be superseded by `node.roles`.\nRole of a service node.\nThis allows for distinction between different running roles of the same service.\nIn the case of Kibana, the `service.node.role` could be `ui` or `background_tasks`.\nIn the case of Elasticsearch, the `service.node.role` could be `master` or `data`.\nOther services could use this to distinguish between a `web` and `worker` role running as part of the service.",example:"background_tasks",flat_name:"service.target.node.role",ignore_above:1024,level:"extended",name:"node.role",normalize:[],original_fieldset:"service",short:"Deprecated role (singular) of the service node.",type:"keyword"},"service.target.node.roles":{dashed_name:"service-target-node-roles",description:"Roles of a service node.\nThis allows for distinction between different running roles of the same service.\nIn the case of Kibana, the `service.node.role` could be `ui` or `background_tasks` or both.\nIn the case of Elasticsearch, the `service.node.role` could be `master` or `data` or both.\nOther services could use this to distinguish between a `web` and `worker` role running as part of the service.",example:'["ui", "background_tasks"]',flat_name:"service.target.node.roles",ignore_above:1024,level:"extended",name:"node.roles",normalize:["array"],original_fieldset:"service",short:"Roles of the service node.",synthetic_source_keep:"none",type:"keyword"},"service.target.state":{dashed_name:"service-target-state",description:"Current state of the service.",flat_name:"service.target.state",ignore_above:1024,level:"core",name:"state",normalize:[],original_fieldset:"service",short:"Current state of the service.",type:"keyword"},"service.target.type":{dashed_name:"service-target-type",description:"The type of the service data is collected from.\nThe type can be used to group and correlate logs and metrics from one service type.\nExample: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.",example:"elasticsearch",flat_name:"service.target.type",ignore_above:1024,level:"core",name:"type",normalize:[],original_fieldset:"service",short:"The type of the service.",type:"keyword"},"service.target.version":{dashed_name:"service-target-version",description:"Version of the service the data was collected from.\nThis allows to look at a data set only for a specific version of a service.",example:"3.2.4",flat_name:"service.target.version",ignore_above:1024,level:"core",name:"version",normalize:[],original_fieldset:"service",short:"Version of the service.",type:"keyword"},"service.type":{dashed_name:"service-type",description:"The type of the service data is collected from.\nThe type can be used to group and correlate logs and metrics from one service type.\nExample: If logs or metrics are collected from Elasticsearch, `service.type` would be `elasticsearch`.",example:"elasticsearch",flat_name:"service.type",ignore_above:1024,level:"core",name:"type",normalize:[],short:"The type of the service.",type:"keyword"},"service.version":{dashed_name:"service-version",description:"Version of the service the data was collected from.\nThis allows to look at a data set only for a specific version of a service.",example:"3.2.4",flat_name:"service.version",ignore_above:1024,level:"core",name:"version",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"Version of the service.",type:"keyword"},"source.address":{dashed_name:"source-address",description:"Some event source addresses are defined ambiguously. The event will sometimes list an IP, a domain or a unix socket.  You should always store the raw address in the `.address` field.\nThen it should be duplicated to `.ip` or `.domain`, depending on which one it is.",flat_name:"source.address",ignore_above:1024,level:"extended",name:"address",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Source network address.",type:"keyword"},"source.as.number":{dashed_name:"source-as-number",description:"Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.",example:15169,flat_name:"source.as.number",level:"extended",name:"number",normalize:[],original_fieldset:"as",short:"Unique number allocated to the autonomous system.",type:"long"},"source.as.organization.name":{dashed_name:"source-as-organization-name",description:"Organization name.",example:"Google LLC",flat_name:"source.as.organization.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"source.as.organization.name.text",name:"text",type:"match_only_text"}],name:"organization.name",normalize:[],original_fieldset:"as",short:"Organization name.",type:"keyword"},"source.bytes":{dashed_name:"source-bytes",description:"Bytes sent from the source to the destination.",example:184,flat_name:"source.bytes",format:"bytes",level:"core",name:"bytes",normalize:[],short:"Bytes sent from the source to the destination.",type:"long"},"source.domain":{dashed_name:"source-domain",description:"The domain name of the source system.\nThis value may be a host name, a fully qualified domain name, or another host naming format. The value may derive from the original event or be added from enrichment.",example:"foo.example.com",flat_name:"source.domain",ignore_above:1024,level:"core",name:"domain",normalize:[],short:"The domain name of the source.",type:"keyword"},"source.geo.city_name":{dashed_name:"source-geo-city-name",description:"City name.",example:"Montreal",flat_name:"source.geo.city_name",ignore_above:1024,level:"core",name:"city_name",normalize:[],original_fieldset:"geo",short:"City name.",type:"keyword"},"source.geo.continent_code":{dashed_name:"source-geo-continent-code",description:"Two-letter code representing continent's name.",example:"NA",flat_name:"source.geo.continent_code",ignore_above:1024,level:"core",name:"continent_code",normalize:[],original_fieldset:"geo",short:"Continent code.",type:"keyword"},"source.geo.continent_name":{dashed_name:"source-geo-continent-name",description:"Name of the continent.",example:"North America",flat_name:"source.geo.continent_name",ignore_above:1024,level:"core",name:"continent_name",normalize:[],original_fieldset:"geo",short:"Name of the continent.",type:"keyword"},"source.geo.country_iso_code":{dashed_name:"source-geo-country-iso-code",description:"Country ISO code.",example:"CA",flat_name:"source.geo.country_iso_code",ignore_above:1024,level:"core",name:"country_iso_code",normalize:[],original_fieldset:"geo",short:"Country ISO code.",type:"keyword"},"source.geo.country_name":{dashed_name:"source-geo-country-name",description:"Country name.",example:"Canada",flat_name:"source.geo.country_name",ignore_above:1024,level:"core",name:"country_name",normalize:[],original_fieldset:"geo",short:"Country name.",type:"keyword"},"source.geo.location":{dashed_name:"source-geo-location",description:"Longitude and latitude.",example:'{ "lon": -73.614830, "lat": 45.505918 }',flat_name:"source.geo.location",level:"core",name:"location",normalize:[],original_fieldset:"geo",short:"Longitude and latitude.",type:"geo_point"},"source.geo.name":{dashed_name:"source-geo-name",description:"User-defined description of a location, at the level of granularity they care about.\nCould be the name of their data centers, the floor number, if this describes a local physical entity, city names.\nNot typically used in automated geolocation.",example:"boston-dc",flat_name:"source.geo.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"geo",short:"User-defined description of a location.",type:"keyword"},"source.geo.postal_code":{dashed_name:"source-geo-postal-code",description:"Postal code associated with the location.\nValues appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.",example:94040,flat_name:"source.geo.postal_code",ignore_above:1024,level:"core",name:"postal_code",normalize:[],original_fieldset:"geo",short:"Postal code.",type:"keyword"},"source.geo.region_iso_code":{dashed_name:"source-geo-region-iso-code",description:"Region ISO code.",example:"CA-QC",flat_name:"source.geo.region_iso_code",ignore_above:1024,level:"core",name:"region_iso_code",normalize:[],original_fieldset:"geo",short:"Region ISO code.",type:"keyword"},"source.geo.region_name":{dashed_name:"source-geo-region-name",description:"Region name.",example:"Quebec",flat_name:"source.geo.region_name",ignore_above:1024,level:"core",name:"region_name",normalize:[],original_fieldset:"geo",short:"Region name.",type:"keyword"},"source.geo.timezone":{dashed_name:"source-geo-timezone",description:"The time zone of the location, such as IANA time zone name.",example:"America/Argentina/Buenos_Aires",flat_name:"source.geo.timezone",ignore_above:1024,level:"core",name:"timezone",normalize:[],original_fieldset:"geo",short:"Time zone.",type:"keyword"},"source.ip":{dashed_name:"source-ip",description:"IP address of the source (IPv4 or IPv6).",flat_name:"source.ip",level:"core",name:"ip",normalize:[],short:"IP address of the source.",type:"ip"},"source.mac":{dashed_name:"source-mac",description:"MAC address of the source.\nThe notation format from RFC 7042 is suggested: Each octet (that is, 8-bit byte) is represented by two [uppercase] hexadecimal digits giving the value of the octet as an unsigned integer. Successive octets are separated by a hyphen.",example:"00-00-5E-00-53-23",flat_name:"source.mac",ignore_above:1024,level:"core",name:"mac",normalize:[],pattern:"^[A-F0-9]{2}(-[A-F0-9]{2}){5,}$",short:"MAC address of the source.",type:"keyword"},"source.nat.ip":{dashed_name:"source-nat-ip",description:"Translated ip of source based NAT sessions (e.g. internal client to internet)\nTypically connections traversing load balancers, firewalls, or routers.",flat_name:"source.nat.ip",level:"extended",name:"nat.ip",normalize:[],short:"Source NAT ip",type:"ip"},"source.nat.port":{dashed_name:"source-nat-port",description:"Translated port of source based NAT sessions. (e.g. internal client to internet)\nTypically used with load balancers, firewalls, or routers.",flat_name:"source.nat.port",format:"string",level:"extended",name:"nat.port",normalize:[],short:"Source NAT port",type:"long"},"source.packets":{dashed_name:"source-packets",description:"Packets sent from the source to the destination.",example:12,flat_name:"source.packets",level:"core",name:"packets",normalize:[],short:"Packets sent from the source to the destination.",type:"long"},"source.port":{dashed_name:"source-port",description:"Port of the source.",flat_name:"source.port",format:"string",level:"core",name:"port",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Port of the source.",type:"long"},"source.registered_domain":{dashed_name:"source-registered-domain",description:'The highest registered source domain, stripped of the subdomain.\nFor example, the registered domain for "foo.example.com" is "example.com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".',example:"example.com",flat_name:"source.registered_domain",ignore_above:1024,level:"extended",name:"registered_domain",normalize:[],short:"The highest registered source domain, stripped of the subdomain.",type:"keyword"},"source.subdomain":{dashed_name:"source-subdomain",description:'The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain.\nFor example the subdomain portion of "www.east.mydomain.co.uk" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.',example:"east",flat_name:"source.subdomain",ignore_above:1024,level:"extended",name:"subdomain",normalize:[],short:"The subdomain of the domain.",type:"keyword"},"source.top_level_domain":{dashed_name:"source-top-level-domain",description:'The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".',example:"co.uk",flat_name:"source.top_level_domain",ignore_above:1024,level:"extended",name:"top_level_domain",normalize:[],short:"The effective top level domain (com, org, net, co.uk).",type:"keyword"},"source.user.domain":{dashed_name:"source-user-domain",description:"Name of the directory the user is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"source.user.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"user",short:"Name of the directory the user is a member of.",type:"keyword"},"source.user.email":{dashed_name:"source-user-email",description:"User email address.",flat_name:"source.user.email",ignore_above:1024,level:"extended",name:"email",normalize:[],original_fieldset:"user",short:"User email address.",type:"keyword"},"source.user.full_name":{dashed_name:"source-user-full-name",description:"User's full name, if available.",example:"Albert Einstein",flat_name:"source.user.full_name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"source.user.full_name.text",name:"text",type:"match_only_text"}],name:"full_name",normalize:[],original_fieldset:"user",short:"User's full name, if available.",type:"keyword"},"source.user.group.domain":{dashed_name:"source-user-group-domain",description:"Name of the directory the group is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"source.user.group.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"group",short:"Name of the directory the group is a member of.",type:"keyword"},"source.user.group.id":{dashed_name:"source-user-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"source.user.group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"source.user.group.name":{dashed_name:"source-user-group-name",description:"Name of the group.",flat_name:"source.user.group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"source.user.hash":{dashed_name:"source-user-hash",description:"Unique user hash to correlate information for a user in anonymized form.\nUseful if `user.id` or `user.name` contain confidential information and cannot be used.",flat_name:"source.user.hash",ignore_above:1024,level:"extended",name:"hash",normalize:[],original_fieldset:"user",short:"Unique user hash to correlate information for a user in anonymized form.",type:"keyword"},"source.user.id":{dashed_name:"source-user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"source.user.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"source.user.name":{dashed_name:"source-user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"source.user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"source.user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"source.user.roles":{dashed_name:"source-user-roles",description:"Array of user roles at the time of the event.",example:'["kibana_admin", "reporting_user"]',flat_name:"source.user.roles",ignore_above:1024,level:"extended",name:"roles",normalize:["array"],original_fieldset:"user",short:"Array of user roles at the time of the event.",synthetic_source_keep:"none",type:"keyword"},"span.id":{dashed_name:"span-id",description:"Unique identifier of the span within the scope of its trace.\nA span represents an operation within a transaction, such as a request to another service, or a database query.",example:"3ff9a8981b7ccd5a",flat_name:"span.id",ignore_above:1024,level:"extended",name:"span.id",normalize:[],otel:[{otlp_field:"span_id",relation:"otlp",stability:"stable"}],short:"Unique identifier of the span within the scope of its trace.",type:"keyword"},tags:{dashed_name:"tags",description:"List of keywords used to tag each event.",example:'["production", "env2"]',flat_name:"tags",ignore_above:1024,level:"core",name:"tags",normalize:["array"],short:"List of keywords used to tag each event.",synthetic_source_keep:"none",type:"keyword"},"threat.enrichments":{dashed_name:"threat-enrichments",description:"A list of associated indicators objects enriching the event, and the context of that association/enrichment.",flat_name:"threat.enrichments",level:"extended",name:"enrichments",normalize:["array"],short:"List of objects containing indicators enriching the event.",synthetic_source_keep:"none",type:"nested"},"threat.enrichments.indicator":{dashed_name:"threat-enrichments-indicator",description:"Object containing associated indicators enriching the event.",flat_name:"threat.enrichments.indicator",level:"extended",name:"enrichments.indicator",normalize:[],short:"Object containing indicators enriching the event.",type:"object"},"threat.enrichments.indicator.as.number":{dashed_name:"threat-enrichments-indicator-as-number",description:"Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.",example:15169,flat_name:"threat.enrichments.indicator.as.number",level:"extended",name:"number",normalize:[],original_fieldset:"as",short:"Unique number allocated to the autonomous system.",type:"long"},"threat.enrichments.indicator.as.organization.name":{dashed_name:"threat-enrichments-indicator-as-organization-name",description:"Organization name.",example:"Google LLC",flat_name:"threat.enrichments.indicator.as.organization.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"threat.enrichments.indicator.as.organization.name.text",name:"text",type:"match_only_text"}],name:"organization.name",normalize:[],original_fieldset:"as",short:"Organization name.",type:"keyword"},"threat.enrichments.indicator.confidence":{dashed_name:"threat-enrichments-indicator-confidence",description:"Identifies the vendor-neutral confidence rating using the None/Low/Medium/High scale defined in Appendix A of the STIX 2.1 framework. Vendor-specific confidence scales may be added as custom fields.",example:"Medium",expected_values:["Not Specified","None","Low","Medium","High"],flat_name:"threat.enrichments.indicator.confidence",ignore_above:1024,level:"extended",name:"enrichments.indicator.confidence",normalize:[],short:"Indicator confidence rating",type:"keyword"},"threat.enrichments.indicator.description":{dashed_name:"threat-enrichments-indicator-description",description:"Describes the type of action conducted by the threat.",example:"IP x.x.x.x was observed delivering the Angler EK.",flat_name:"threat.enrichments.indicator.description",ignore_above:1024,level:"extended",name:"enrichments.indicator.description",normalize:[],short:"Indicator description",type:"keyword"},"threat.enrichments.indicator.email.address":{dashed_name:"threat-enrichments-indicator-email-address",description:"Identifies a threat indicator as an email address (irrespective of direction).",example:"phish@example.com",flat_name:"threat.enrichments.indicator.email.address",ignore_above:1024,level:"extended",name:"enrichments.indicator.email.address",normalize:[],short:"Indicator email address",type:"keyword"},"threat.enrichments.indicator.file.accessed":{dashed_name:"threat-enrichments-indicator-file-accessed",description:"Last time the file was accessed.\nNote that not all filesystems keep track of access time.",flat_name:"threat.enrichments.indicator.file.accessed",level:"extended",name:"accessed",normalize:[],original_fieldset:"file",short:"Last time the file was accessed.",type:"date"},"threat.enrichments.indicator.file.attributes":{dashed_name:"threat-enrichments-indicator-file-attributes",description:"Array of file attributes.\nAttributes names will vary by platform. Here's a non-exhaustive list of values that are expected in this field: archive, compressed, directory, encrypted, execute, hidden, read, readonly, system, write.",example:'["readonly", "system"]',flat_name:"threat.enrichments.indicator.file.attributes",ignore_above:1024,level:"extended",name:"attributes",normalize:["array"],original_fieldset:"file",short:"Array of file attributes.",synthetic_source_keep:"none",type:"keyword"},"threat.enrichments.indicator.file.code_signature.digest_algorithm":{dashed_name:"threat-enrichments-indicator-file-code-signature-digest-algorithm",description:"The hashing algorithm used to sign the process.\nThis value can distinguish signatures when a file is signed multiple times by the same signer but with a different digest algorithm.",example:"sha256",flat_name:"threat.enrichments.indicator.file.code_signature.digest_algorithm",ignore_above:1024,level:"extended",name:"digest_algorithm",normalize:[],original_fieldset:"code_signature",short:"Hashing algorithm used to sign the process.",type:"keyword"},"threat.enrichments.indicator.file.code_signature.exists":{dashed_name:"threat-enrichments-indicator-file-code-signature-exists",description:"Boolean to capture if a signature is present.",example:"true",flat_name:"threat.enrichments.indicator.file.code_signature.exists",level:"core",name:"exists",normalize:[],original_fieldset:"code_signature",short:"Boolean to capture if a signature is present.",type:"boolean"},"threat.enrichments.indicator.file.code_signature.flags":{beta:"This field is beta and subject to change.",dashed_name:"threat-enrichments-indicator-file-code-signature-flags",description:"The flags used to sign the process.",example:570522385,flat_name:"threat.enrichments.indicator.file.code_signature.flags",ignore_above:1024,level:"extended",name:"flags",normalize:[],original_fieldset:"code_signature",short:"Code signing flags of the process",type:"keyword"},"threat.enrichments.indicator.file.code_signature.signing_id":{dashed_name:"threat-enrichments-indicator-file-code-signature-signing-id",description:"The identifier used to sign the process.\nThis is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only.",example:"com.apple.xpc.proxy",flat_name:"threat.enrichments.indicator.file.code_signature.signing_id",ignore_above:1024,level:"extended",name:"signing_id",normalize:[],original_fieldset:"code_signature",short:"The identifier used to sign the process.",type:"keyword"},"threat.enrichments.indicator.file.code_signature.status":{dashed_name:"threat-enrichments-indicator-file-code-signature-status",description:"Additional information about the certificate status.\nThis is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.",example:"ERROR_UNTRUSTED_ROOT",flat_name:"threat.enrichments.indicator.file.code_signature.status",ignore_above:1024,level:"extended",name:"status",normalize:[],original_fieldset:"code_signature",short:"Additional information about the certificate status.",type:"keyword"},"threat.enrichments.indicator.file.code_signature.subject_name":{dashed_name:"threat-enrichments-indicator-file-code-signature-subject-name",description:"Subject name of the code signer",example:"Microsoft Corporation",flat_name:"threat.enrichments.indicator.file.code_signature.subject_name",ignore_above:1024,level:"core",name:"subject_name",normalize:[],original_fieldset:"code_signature",short:"Subject name of the code signer",type:"keyword"},"threat.enrichments.indicator.file.code_signature.team_id":{dashed_name:"threat-enrichments-indicator-file-code-signature-team-id",description:"The team identifier used to sign the process.\nThis is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only.",example:"EQHXZ8M8AV",flat_name:"threat.enrichments.indicator.file.code_signature.team_id",ignore_above:1024,level:"extended",name:"team_id",normalize:[],original_fieldset:"code_signature",short:"The team identifier used to sign the process.",type:"keyword"},"threat.enrichments.indicator.file.code_signature.timestamp":{dashed_name:"threat-enrichments-indicator-file-code-signature-timestamp",description:"Date and time when the code signature was generated and signed.",example:"2021-01-01T12:10:30Z",flat_name:"threat.enrichments.indicator.file.code_signature.timestamp",level:"extended",name:"timestamp",normalize:[],original_fieldset:"code_signature",short:"When the signature was generated and signed.",type:"date"},"threat.enrichments.indicator.file.code_signature.trusted":{dashed_name:"threat-enrichments-indicator-file-code-signature-trusted",description:"Stores the trust status of the certificate chain.\nValidating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.",example:"true",flat_name:"threat.enrichments.indicator.file.code_signature.trusted",level:"extended",name:"trusted",normalize:[],original_fieldset:"code_signature",short:"Stores the trust status of the certificate chain.",type:"boolean"},"threat.enrichments.indicator.file.code_signature.valid":{dashed_name:"threat-enrichments-indicator-file-code-signature-valid",description:"Boolean to capture if the digital signature is verified against the binary content.\nLeave unpopulated if a certificate was unchecked.",example:"true",flat_name:"threat.enrichments.indicator.file.code_signature.valid",level:"extended",name:"valid",normalize:[],original_fieldset:"code_signature",short:"Boolean to capture if the digital signature is verified against the binary content.",type:"boolean"},"threat.enrichments.indicator.file.created":{dashed_name:"threat-enrichments-indicator-file-created",description:"File creation time.\nNote that not all filesystems store the creation time.",flat_name:"threat.enrichments.indicator.file.created",level:"extended",name:"created",normalize:[],original_fieldset:"file",short:"File creation time.",type:"date"},"threat.enrichments.indicator.file.ctime":{dashed_name:"threat-enrichments-indicator-file-ctime",description:"Last time the file attributes or metadata changed.\nNote that changes to the file content will update `mtime`. This implies `ctime` will be adjusted at the same time, since `mtime` is an attribute of the file.",flat_name:"threat.enrichments.indicator.file.ctime",level:"extended",name:"ctime",normalize:[],original_fieldset:"file",short:"Last time the file attributes or metadata changed.",type:"date"},"threat.enrichments.indicator.file.device":{dashed_name:"threat-enrichments-indicator-file-device",description:"Device that is the source of the file.",example:"sda",flat_name:"threat.enrichments.indicator.file.device",ignore_above:1024,level:"extended",name:"device",normalize:[],original_fieldset:"file",short:"Device that is the source of the file.",type:"keyword"},"threat.enrichments.indicator.file.directory":{dashed_name:"threat-enrichments-indicator-file-directory",description:"Directory where the file is located. It should include the drive letter, when appropriate.",example:"/home/alice",flat_name:"threat.enrichments.indicator.file.directory",ignore_above:1024,level:"extended",name:"directory",normalize:[],original_fieldset:"file",short:"Directory where the file is located.",type:"keyword"},"threat.enrichments.indicator.file.drive_letter":{dashed_name:"threat-enrichments-indicator-file-drive-letter",description:"Drive letter where the file is located. This field is only relevant on Windows.\nThe value should be uppercase, and not include the colon.",example:"C",flat_name:"threat.enrichments.indicator.file.drive_letter",ignore_above:1,level:"extended",name:"drive_letter",normalize:[],original_fieldset:"file",short:"Drive letter where the file is located.",type:"keyword"},"threat.enrichments.indicator.file.elf.architecture":{dashed_name:"threat-enrichments-indicator-file-elf-architecture",description:"Machine architecture of the ELF file.",example:"x86-64",flat_name:"threat.enrichments.indicator.file.elf.architecture",ignore_above:1024,level:"extended",name:"architecture",normalize:[],original_fieldset:"elf",short:"Machine architecture of the ELF file.",type:"keyword"},"threat.enrichments.indicator.file.elf.byte_order":{dashed_name:"threat-enrichments-indicator-file-elf-byte-order",description:"Byte sequence of ELF file.",example:"Little Endian",flat_name:"threat.enrichments.indicator.file.elf.byte_order",ignore_above:1024,level:"extended",name:"byte_order",normalize:[],original_fieldset:"elf",short:"Byte sequence of ELF file.",type:"keyword"},"threat.enrichments.indicator.file.elf.cpu_type":{dashed_name:"threat-enrichments-indicator-file-elf-cpu-type",description:"CPU type of the ELF file.",example:"Intel",flat_name:"threat.enrichments.indicator.file.elf.cpu_type",ignore_above:1024,level:"extended",name:"cpu_type",normalize:[],original_fieldset:"elf",short:"CPU type of the ELF file.",type:"keyword"},"threat.enrichments.indicator.file.elf.creation_date":{dashed_name:"threat-enrichments-indicator-file-elf-creation-date",description:"Extracted when possible from the file's metadata. Indicates when it was built or compiled. It can also be faked by malware creators.",flat_name:"threat.enrichments.indicator.file.elf.creation_date",level:"extended",name:"creation_date",normalize:[],original_fieldset:"elf",short:"Build or compile date.",type:"date"},"threat.enrichments.indicator.file.elf.exports":{dashed_name:"threat-enrichments-indicator-file-elf-exports",description:"List of exported element names and types.",flat_name:"threat.enrichments.indicator.file.elf.exports",level:"extended",name:"exports",normalize:["array"],original_fieldset:"elf",short:"List of exported element names and types.",type:"flattened"},"threat.enrichments.indicator.file.elf.go_import_hash":{dashed_name:"threat-enrichments-indicator-file-elf-go-import-hash",description:"A hash of the Go language imports in an ELF file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThe algorithm used to calculate the Go symbol hash and a reference implementation are available here: https://github.com/elastic/toutoumomoma",example:"10bddcb4cee42080f76c88d9ff964491",flat_name:"threat.enrichments.indicator.file.elf.go_import_hash",ignore_above:1024,level:"extended",name:"go_import_hash",normalize:[],original_fieldset:"elf",short:"A hash of the Go language imports in an ELF file.",type:"keyword"},"threat.enrichments.indicator.file.elf.go_imports":{dashed_name:"threat-enrichments-indicator-file-elf-go-imports",description:"List of imported Go language element names and types.",flat_name:"threat.enrichments.indicator.file.elf.go_imports",level:"extended",name:"go_imports",normalize:[],original_fieldset:"elf",short:"List of imported Go language element names and types.",type:"flattened"},"threat.enrichments.indicator.file.elf.go_imports_names_entropy":{dashed_name:"threat-enrichments-indicator-file-elf-go-imports-names-entropy",description:"Shannon entropy calculation from the list of Go imports.",flat_name:"threat.enrichments.indicator.file.elf.go_imports_names_entropy",format:"number",level:"extended",name:"go_imports_names_entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the list of Go imports.",type:"long"},"threat.enrichments.indicator.file.elf.go_imports_names_var_entropy":{dashed_name:"threat-enrichments-indicator-file-elf-go-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of Go imports.",flat_name:"threat.enrichments.indicator.file.elf.go_imports_names_var_entropy",format:"number",level:"extended",name:"go_imports_names_var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the list of Go imports.",type:"long"},"threat.enrichments.indicator.file.elf.go_stripped":{dashed_name:"threat-enrichments-indicator-file-elf-go-stripped",description:"Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.",flat_name:"threat.enrichments.indicator.file.elf.go_stripped",level:"extended",name:"go_stripped",normalize:[],original_fieldset:"elf",short:"Whether the file is a stripped or obfuscated Go executable.",type:"boolean"},"threat.enrichments.indicator.file.elf.header.abi_version":{dashed_name:"threat-enrichments-indicator-file-elf-header-abi-version",description:"Version of the ELF Application Binary Interface (ABI).",flat_name:"threat.enrichments.indicator.file.elf.header.abi_version",ignore_above:1024,level:"extended",name:"header.abi_version",normalize:[],original_fieldset:"elf",short:"Version of the ELF Application Binary Interface (ABI).",type:"keyword"},"threat.enrichments.indicator.file.elf.header.class":{dashed_name:"threat-enrichments-indicator-file-elf-header-class",description:"Header class of the ELF file.",flat_name:"threat.enrichments.indicator.file.elf.header.class",ignore_above:1024,level:"extended",name:"header.class",normalize:[],original_fieldset:"elf",short:"Header class of the ELF file.",type:"keyword"},"threat.enrichments.indicator.file.elf.header.data":{dashed_name:"threat-enrichments-indicator-file-elf-header-data",description:"Data table of the ELF header.",flat_name:"threat.enrichments.indicator.file.elf.header.data",ignore_above:1024,level:"extended",name:"header.data",normalize:[],original_fieldset:"elf",short:"Data table of the ELF header.",type:"keyword"},"threat.enrichments.indicator.file.elf.header.entrypoint":{dashed_name:"threat-enrichments-indicator-file-elf-header-entrypoint",description:"Header entrypoint of the ELF file.",flat_name:"threat.enrichments.indicator.file.elf.header.entrypoint",format:"string",level:"extended",name:"header.entrypoint",normalize:[],original_fieldset:"elf",short:"Header entrypoint of the ELF file.",type:"long"},"threat.enrichments.indicator.file.elf.header.object_version":{dashed_name:"threat-enrichments-indicator-file-elf-header-object-version",description:'"0x1" for original ELF files.',flat_name:"threat.enrichments.indicator.file.elf.header.object_version",ignore_above:1024,level:"extended",name:"header.object_version",normalize:[],original_fieldset:"elf",short:'"0x1" for original ELF files.',type:"keyword"},"threat.enrichments.indicator.file.elf.header.os_abi":{dashed_name:"threat-enrichments-indicator-file-elf-header-os-abi",description:"Application Binary Interface (ABI) of the Linux OS.",flat_name:"threat.enrichments.indicator.file.elf.header.os_abi",ignore_above:1024,level:"extended",name:"header.os_abi",normalize:[],original_fieldset:"elf",short:"Application Binary Interface (ABI) of the Linux OS.",type:"keyword"},"threat.enrichments.indicator.file.elf.header.type":{dashed_name:"threat-enrichments-indicator-file-elf-header-type",description:"Header type of the ELF file.",flat_name:"threat.enrichments.indicator.file.elf.header.type",ignore_above:1024,level:"extended",name:"header.type",normalize:[],original_fieldset:"elf",short:"Header type of the ELF file.",type:"keyword"},"threat.enrichments.indicator.file.elf.header.version":{dashed_name:"threat-enrichments-indicator-file-elf-header-version",description:"Version of the ELF header.",flat_name:"threat.enrichments.indicator.file.elf.header.version",ignore_above:1024,level:"extended",name:"header.version",normalize:[],original_fieldset:"elf",short:"Version of the ELF header.",type:"keyword"},"threat.enrichments.indicator.file.elf.import_hash":{dashed_name:"threat-enrichments-indicator-file-elf-import-hash",description:"A hash of the imports in an ELF file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is an ELF implementation of the Windows PE imphash.",example:"d41d8cd98f00b204e9800998ecf8427e",flat_name:"threat.enrichments.indicator.file.elf.import_hash",ignore_above:1024,level:"extended",name:"import_hash",normalize:[],original_fieldset:"elf",short:"A hash of the imports in an ELF file.",type:"keyword"},"threat.enrichments.indicator.file.elf.imports":{dashed_name:"threat-enrichments-indicator-file-elf-imports",description:"List of imported element names and types.",flat_name:"threat.enrichments.indicator.file.elf.imports",level:"extended",name:"imports",normalize:["array"],original_fieldset:"elf",short:"List of imported element names and types.",type:"flattened"},"threat.enrichments.indicator.file.elf.imports_names_entropy":{dashed_name:"threat-enrichments-indicator-file-elf-imports-names-entropy",description:"Shannon entropy calculation from the list of imported element names and types.",flat_name:"threat.enrichments.indicator.file.elf.imports_names_entropy",format:"number",level:"extended",name:"imports_names_entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the list of imported element names and types.",type:"long"},"threat.enrichments.indicator.file.elf.imports_names_var_entropy":{dashed_name:"threat-enrichments-indicator-file-elf-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of imported element names and types.",flat_name:"threat.enrichments.indicator.file.elf.imports_names_var_entropy",format:"number",level:"extended",name:"imports_names_var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the list of imported element names and types.",type:"long"},"threat.enrichments.indicator.file.elf.sections":{dashed_name:"threat-enrichments-indicator-file-elf-sections",description:"An array containing an object for each section of the ELF file.\nThe keys that should be present in these objects are defined by sub-fields underneath `elf.sections.*`.",flat_name:"threat.enrichments.indicator.file.elf.sections",level:"extended",name:"sections",normalize:["array"],original_fieldset:"elf",short:"Section information of the ELF file.",type:"nested"},"threat.enrichments.indicator.file.elf.sections.chi2":{dashed_name:"threat-enrichments-indicator-file-elf-sections-chi2",description:"Chi-square probability distribution of the section.",flat_name:"threat.enrichments.indicator.file.elf.sections.chi2",format:"number",level:"extended",name:"sections.chi2",normalize:[],original_fieldset:"elf",short:"Chi-square probability distribution of the section.",type:"long"},"threat.enrichments.indicator.file.elf.sections.entropy":{dashed_name:"threat-enrichments-indicator-file-elf-sections-entropy",description:"Shannon entropy calculation from the section.",flat_name:"threat.enrichments.indicator.file.elf.sections.entropy",format:"number",level:"extended",name:"sections.entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the section.",type:"long"},"threat.enrichments.indicator.file.elf.sections.flags":{dashed_name:"threat-enrichments-indicator-file-elf-sections-flags",description:"ELF Section List flags.",flat_name:"threat.enrichments.indicator.file.elf.sections.flags",ignore_above:1024,level:"extended",name:"sections.flags",normalize:[],original_fieldset:"elf",short:"ELF Section List flags.",type:"keyword"},"threat.enrichments.indicator.file.elf.sections.name":{dashed_name:"threat-enrichments-indicator-file-elf-sections-name",description:"ELF Section List name.",flat_name:"threat.enrichments.indicator.file.elf.sections.name",ignore_above:1024,level:"extended",name:"sections.name",normalize:[],original_fieldset:"elf",short:"ELF Section List name.",type:"keyword"},"threat.enrichments.indicator.file.elf.sections.physical_offset":{dashed_name:"threat-enrichments-indicator-file-elf-sections-physical-offset",description:"ELF Section List offset.",flat_name:"threat.enrichments.indicator.file.elf.sections.physical_offset",ignore_above:1024,level:"extended",name:"sections.physical_offset",normalize:[],original_fieldset:"elf",short:"ELF Section List offset.",type:"keyword"},"threat.enrichments.indicator.file.elf.sections.physical_size":{dashed_name:"threat-enrichments-indicator-file-elf-sections-physical-size",description:"ELF Section List physical size.",flat_name:"threat.enrichments.indicator.file.elf.sections.physical_size",format:"bytes",level:"extended",name:"sections.physical_size",normalize:[],original_fieldset:"elf",short:"ELF Section List physical size.",type:"long"},"threat.enrichments.indicator.file.elf.sections.type":{dashed_name:"threat-enrichments-indicator-file-elf-sections-type",description:"ELF Section List type.",flat_name:"threat.enrichments.indicator.file.elf.sections.type",ignore_above:1024,level:"extended",name:"sections.type",normalize:[],original_fieldset:"elf",short:"ELF Section List type.",type:"keyword"},"threat.enrichments.indicator.file.elf.sections.var_entropy":{dashed_name:"threat-enrichments-indicator-file-elf-sections-var-entropy",description:"Variance for Shannon entropy calculation from the section.",flat_name:"threat.enrichments.indicator.file.elf.sections.var_entropy",format:"number",level:"extended",name:"sections.var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the section.",type:"long"},"threat.enrichments.indicator.file.elf.sections.virtual_address":{dashed_name:"threat-enrichments-indicator-file-elf-sections-virtual-address",description:"ELF Section List virtual address.",flat_name:"threat.enrichments.indicator.file.elf.sections.virtual_address",format:"string",level:"extended",name:"sections.virtual_address",normalize:[],original_fieldset:"elf",short:"ELF Section List virtual address.",type:"long"},"threat.enrichments.indicator.file.elf.sections.virtual_size":{dashed_name:"threat-enrichments-indicator-file-elf-sections-virtual-size",description:"ELF Section List virtual size.",flat_name:"threat.enrichments.indicator.file.elf.sections.virtual_size",format:"string",level:"extended",name:"sections.virtual_size",normalize:[],original_fieldset:"elf",short:"ELF Section List virtual size.",type:"long"},"threat.enrichments.indicator.file.elf.segments":{dashed_name:"threat-enrichments-indicator-file-elf-segments",description:"An array containing an object for each segment of the ELF file.\nThe keys that should be present in these objects are defined by sub-fields underneath `elf.segments.*`.",flat_name:"threat.enrichments.indicator.file.elf.segments",level:"extended",name:"segments",normalize:["array"],original_fieldset:"elf",short:"ELF object segment list.",type:"nested"},"threat.enrichments.indicator.file.elf.segments.sections":{dashed_name:"threat-enrichments-indicator-file-elf-segments-sections",description:"ELF object segment sections.",flat_name:"threat.enrichments.indicator.file.elf.segments.sections",ignore_above:1024,level:"extended",name:"segments.sections",normalize:[],original_fieldset:"elf",short:"ELF object segment sections.",type:"keyword"},"threat.enrichments.indicator.file.elf.segments.type":{dashed_name:"threat-enrichments-indicator-file-elf-segments-type",description:"ELF object segment type.",flat_name:"threat.enrichments.indicator.file.elf.segments.type",ignore_above:1024,level:"extended",name:"segments.type",normalize:[],original_fieldset:"elf",short:"ELF object segment type.",type:"keyword"},"threat.enrichments.indicator.file.elf.shared_libraries":{dashed_name:"threat-enrichments-indicator-file-elf-shared-libraries",description:"List of shared libraries used by this ELF object.",flat_name:"threat.enrichments.indicator.file.elf.shared_libraries",ignore_above:1024,level:"extended",name:"shared_libraries",normalize:["array"],original_fieldset:"elf",short:"List of shared libraries used by this ELF object.",type:"keyword"},"threat.enrichments.indicator.file.elf.telfhash":{dashed_name:"threat-enrichments-indicator-file-elf-telfhash",description:"telfhash symbol hash for ELF file.",flat_name:"threat.enrichments.indicator.file.elf.telfhash",ignore_above:1024,level:"extended",name:"telfhash",normalize:[],original_fieldset:"elf",short:"telfhash hash for ELF file.",type:"keyword"},"threat.enrichments.indicator.file.extension":{dashed_name:"threat-enrichments-indicator-file-extension",description:'File extension, excluding the leading dot.\nNote that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").',example:"png",flat_name:"threat.enrichments.indicator.file.extension",ignore_above:1024,level:"extended",name:"extension",normalize:[],original_fieldset:"file",short:"File extension, excluding the leading dot.",type:"keyword"},"threat.enrichments.indicator.file.fork_name":{dashed_name:"threat-enrichments-indicator-file-fork-name",description:"A fork is additional data associated with a filesystem object.\nOn Linux, a resource fork is used to store additional data with a filesystem object. A file always has at least one fork for the data portion, and additional forks may exist.\nOn NTFS, this is analogous to an Alternate Data Stream (ADS), and the default data stream for a file is just called $DATA. Zone.Identifier is commonly used by Windows to track contents downloaded from the Internet. An ADS is typically of the form: `C:\\path\\to\\filename.extension:some_fork_name`, and `some_fork_name` is the value that should populate `fork_name`. `filename.extension` should populate `file.name`, and `extension` should populate `file.extension`. The full path, `file.path`, will include the fork name.",example:"Zone.Identifer",flat_name:"threat.enrichments.indicator.file.fork_name",ignore_above:1024,level:"extended",name:"fork_name",normalize:[],original_fieldset:"file",short:"A fork is additional data associated with a filesystem object.",type:"keyword"},"threat.enrichments.indicator.file.gid":{dashed_name:"threat-enrichments-indicator-file-gid",description:"Primary group ID (GID) of the file.",example:"1001",flat_name:"threat.enrichments.indicator.file.gid",ignore_above:1024,level:"extended",name:"gid",normalize:[],original_fieldset:"file",short:"Primary group ID (GID) of the file.",type:"keyword"},"threat.enrichments.indicator.file.group":{dashed_name:"threat-enrichments-indicator-file-group",description:"Primary group name of the file.",example:"alice",flat_name:"threat.enrichments.indicator.file.group",ignore_above:1024,level:"extended",name:"group",normalize:[],original_fieldset:"file",short:"Primary group name of the file.",type:"keyword"},"threat.enrichments.indicator.file.hash.cdhash":{beta:"This field is beta and subject to change.",dashed_name:"threat-enrichments-indicator-file-hash-cdhash",description:"Code directory hash, utilized to uniquely identify and authenticate the integrity of the executable code.",example:"3783b4052fd474dbe30676b45c329e7a6d44acd9",flat_name:"threat.enrichments.indicator.file.hash.cdhash",ignore_above:1024,level:"extended",name:"cdhash",normalize:[],original_fieldset:"hash",short:"The Code Directory (CD) hash of an executable.",type:"keyword"},"threat.enrichments.indicator.file.hash.md5":{dashed_name:"threat-enrichments-indicator-file-hash-md5",description:"MD5 hash.",flat_name:"threat.enrichments.indicator.file.hash.md5",ignore_above:1024,level:"extended",name:"md5",normalize:[],original_fieldset:"hash",short:"MD5 hash.",type:"keyword"},"threat.enrichments.indicator.file.hash.sha1":{dashed_name:"threat-enrichments-indicator-file-hash-sha1",description:"SHA1 hash.",flat_name:"threat.enrichments.indicator.file.hash.sha1",ignore_above:1024,level:"extended",name:"sha1",normalize:[],original_fieldset:"hash",short:"SHA1 hash.",type:"keyword"},"threat.enrichments.indicator.file.hash.sha256":{dashed_name:"threat-enrichments-indicator-file-hash-sha256",description:"SHA256 hash.",flat_name:"threat.enrichments.indicator.file.hash.sha256",ignore_above:1024,level:"extended",name:"sha256",normalize:[],original_fieldset:"hash",short:"SHA256 hash.",type:"keyword"},"threat.enrichments.indicator.file.hash.sha384":{dashed_name:"threat-enrichments-indicator-file-hash-sha384",description:"SHA384 hash.",flat_name:"threat.enrichments.indicator.file.hash.sha384",ignore_above:1024,level:"extended",name:"sha384",normalize:[],original_fieldset:"hash",short:"SHA384 hash.",type:"keyword"},"threat.enrichments.indicator.file.hash.sha512":{dashed_name:"threat-enrichments-indicator-file-hash-sha512",description:"SHA512 hash.",flat_name:"threat.enrichments.indicator.file.hash.sha512",ignore_above:1024,level:"extended",name:"sha512",normalize:[],original_fieldset:"hash",short:"SHA512 hash.",type:"keyword"},"threat.enrichments.indicator.file.hash.ssdeep":{dashed_name:"threat-enrichments-indicator-file-hash-ssdeep",description:"SSDEEP hash.",flat_name:"threat.enrichments.indicator.file.hash.ssdeep",ignore_above:1024,level:"extended",name:"ssdeep",normalize:[],original_fieldset:"hash",short:"SSDEEP hash.",type:"keyword"},"threat.enrichments.indicator.file.hash.tlsh":{dashed_name:"threat-enrichments-indicator-file-hash-tlsh",description:"TLSH hash.",flat_name:"threat.enrichments.indicator.file.hash.tlsh",ignore_above:1024,level:"extended",name:"tlsh",normalize:[],original_fieldset:"hash",short:"TLSH hash.",type:"keyword"},"threat.enrichments.indicator.file.inode":{dashed_name:"threat-enrichments-indicator-file-inode",description:"Inode representing the file in the filesystem.",example:"256383",flat_name:"threat.enrichments.indicator.file.inode",ignore_above:1024,level:"extended",name:"inode",normalize:[],original_fieldset:"file",short:"Inode representing the file in the filesystem.",type:"keyword"},"threat.enrichments.indicator.file.mime_type":{dashed_name:"threat-enrichments-indicator-file-mime-type",description:"MIME type should identify the format of the file or stream of bytes using IANA official types: https://www.iana.org/assignments/media-types/media-types.xhtml, where possible. When more than one type is applicable, the most specific type should be used.",flat_name:"threat.enrichments.indicator.file.mime_type",ignore_above:1024,level:"extended",name:"mime_type",normalize:[],original_fieldset:"file",short:"Media type of file, document, or arrangement of bytes.",type:"keyword"},"threat.enrichments.indicator.file.mode":{dashed_name:"threat-enrichments-indicator-file-mode",description:"Mode of the file in octal representation.",example:"0640",flat_name:"threat.enrichments.indicator.file.mode",ignore_above:1024,level:"extended",name:"mode",normalize:[],original_fieldset:"file",short:"Mode of the file in octal representation.",type:"keyword"},"threat.enrichments.indicator.file.mtime":{dashed_name:"threat-enrichments-indicator-file-mtime",description:"Last time the file content was modified.",flat_name:"threat.enrichments.indicator.file.mtime",level:"extended",name:"mtime",normalize:[],original_fieldset:"file",short:"Last time the file content was modified.",type:"date"},"threat.enrichments.indicator.file.name":{dashed_name:"threat-enrichments-indicator-file-name",description:"Name of the file including the extension, without the directory.",example:"example.png",flat_name:"threat.enrichments.indicator.file.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"file",short:"Name of the file including the extension, without the directory.",type:"keyword"},"threat.enrichments.indicator.file.origin_referrer_url":{beta:"This field is beta and subject to change.",dashed_name:"threat-enrichments-indicator-file-origin-referrer-url",description:"The URL of the webpage that linked to the file.",example:"http://example.com/article1.html",flat_name:"threat.enrichments.indicator.file.origin_referrer_url",ignore_above:8192,level:"extended",name:"origin_referrer_url",normalize:[],original_fieldset:"file",short:"The URL of the webpage that linked to the file.",type:"keyword"},"threat.enrichments.indicator.file.origin_url":{beta:"This field is beta and subject to change.",dashed_name:"threat-enrichments-indicator-file-origin-url",description:"The URL where the file is hosted.",example:"http://example.com/imgs/article1_img1.jpg",flat_name:"threat.enrichments.indicator.file.origin_url",ignore_above:8192,level:"extended",name:"origin_url",normalize:[],original_fieldset:"file",short:"The URL where the file is hosted.",type:"keyword"},"threat.enrichments.indicator.file.owner":{dashed_name:"threat-enrichments-indicator-file-owner",description:"File owner's username.",example:"alice",flat_name:"threat.enrichments.indicator.file.owner",ignore_above:1024,level:"extended",name:"owner",normalize:[],original_fieldset:"file",short:"File owner's username.",type:"keyword"},"threat.enrichments.indicator.file.path":{dashed_name:"threat-enrichments-indicator-file-path",description:"Full path to the file, including the file name. It should include the drive letter, when appropriate.",example:"/home/alice/example.png",flat_name:"threat.enrichments.indicator.file.path",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"threat.enrichments.indicator.file.path.text",name:"text",type:"match_only_text"}],name:"path",normalize:[],original_fieldset:"file",short:"Full path to the file, including the file name.",type:"keyword"},"threat.enrichments.indicator.file.pe.architecture":{dashed_name:"threat-enrichments-indicator-file-pe-architecture",description:"CPU architecture target for the file.",example:"x64",flat_name:"threat.enrichments.indicator.file.pe.architecture",ignore_above:1024,level:"extended",name:"architecture",normalize:[],original_fieldset:"pe",short:"CPU architecture target for the file.",type:"keyword"},"threat.enrichments.indicator.file.pe.company":{dashed_name:"threat-enrichments-indicator-file-pe-company",description:"Internal company name of the file, provided at compile-time.",example:"Microsoft Corporation",flat_name:"threat.enrichments.indicator.file.pe.company",ignore_above:1024,level:"extended",name:"company",normalize:[],original_fieldset:"pe",short:"Internal company name of the file, provided at compile-time.",type:"keyword"},"threat.enrichments.indicator.file.pe.description":{dashed_name:"threat-enrichments-indicator-file-pe-description",description:"Internal description of the file, provided at compile-time.",example:"Paint",flat_name:"threat.enrichments.indicator.file.pe.description",ignore_above:1024,level:"extended",name:"description",normalize:[],original_fieldset:"pe",short:"Internal description of the file, provided at compile-time.",type:"keyword"},"threat.enrichments.indicator.file.pe.file_version":{dashed_name:"threat-enrichments-indicator-file-pe-file-version",description:"Internal version of the file, provided at compile-time.",example:"6.3.9600.17415",flat_name:"threat.enrichments.indicator.file.pe.file_version",ignore_above:1024,level:"extended",name:"file_version",normalize:[],original_fieldset:"pe",short:"Process name.",type:"keyword"},"threat.enrichments.indicator.file.pe.go_import_hash":{dashed_name:"threat-enrichments-indicator-file-pe-go-import-hash",description:"A hash of the Go language imports in a PE file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThe algorithm used to calculate the Go symbol hash and a reference implementation are available here: https://github.com/elastic/toutoumomoma",example:"10bddcb4cee42080f76c88d9ff964491",flat_name:"threat.enrichments.indicator.file.pe.go_import_hash",ignore_above:1024,level:"extended",name:"go_import_hash",normalize:[],original_fieldset:"pe",short:"A hash of the Go language imports in a PE file.",type:"keyword"},"threat.enrichments.indicator.file.pe.go_imports":{dashed_name:"threat-enrichments-indicator-file-pe-go-imports",description:"List of imported Go language element names and types.",flat_name:"threat.enrichments.indicator.file.pe.go_imports",level:"extended",name:"go_imports",normalize:[],original_fieldset:"pe",short:"List of imported Go language element names and types.",type:"flattened"},"threat.enrichments.indicator.file.pe.go_imports_names_entropy":{dashed_name:"threat-enrichments-indicator-file-pe-go-imports-names-entropy",description:"Shannon entropy calculation from the list of Go imports.",flat_name:"threat.enrichments.indicator.file.pe.go_imports_names_entropy",format:"number",level:"extended",name:"go_imports_names_entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the list of Go imports.",type:"long"},"threat.enrichments.indicator.file.pe.go_imports_names_var_entropy":{dashed_name:"threat-enrichments-indicator-file-pe-go-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of Go imports.",flat_name:"threat.enrichments.indicator.file.pe.go_imports_names_var_entropy",format:"number",level:"extended",name:"go_imports_names_var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the list of Go imports.",type:"long"},"threat.enrichments.indicator.file.pe.go_stripped":{dashed_name:"threat-enrichments-indicator-file-pe-go-stripped",description:"Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.",flat_name:"threat.enrichments.indicator.file.pe.go_stripped",level:"extended",name:"go_stripped",normalize:[],original_fieldset:"pe",short:"Whether the file is a stripped or obfuscated Go executable.",type:"boolean"},"threat.enrichments.indicator.file.pe.imphash":{dashed_name:"threat-enrichments-indicator-file-pe-imphash",description:"A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nLearn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html.",example:"0c6803c4e922103c4dca5963aad36ddf",flat_name:"threat.enrichments.indicator.file.pe.imphash",ignore_above:1024,level:"extended",name:"imphash",normalize:[],original_fieldset:"pe",short:"A hash of the imports in a PE file.",type:"keyword"},"threat.enrichments.indicator.file.pe.import_hash":{dashed_name:"threat-enrichments-indicator-file-pe-import-hash",description:"A hash of the imports in a PE file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is a synonym for imphash.",example:"d41d8cd98f00b204e9800998ecf8427e",flat_name:"threat.enrichments.indicator.file.pe.import_hash",ignore_above:1024,level:"extended",name:"import_hash",normalize:[],original_fieldset:"pe",short:"A hash of the imports in a PE file.",type:"keyword"},"threat.enrichments.indicator.file.pe.imports":{dashed_name:"threat-enrichments-indicator-file-pe-imports",description:"List of imported element names and types.",flat_name:"threat.enrichments.indicator.file.pe.imports",level:"extended",name:"imports",normalize:["array"],original_fieldset:"pe",short:"List of imported element names and types.",type:"flattened"},"threat.enrichments.indicator.file.pe.imports_names_entropy":{dashed_name:"threat-enrichments-indicator-file-pe-imports-names-entropy",description:"Shannon entropy calculation from the list of imported element names and types.",flat_name:"threat.enrichments.indicator.file.pe.imports_names_entropy",format:"number",level:"extended",name:"imports_names_entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the list of imported element names and types.",type:"long"},"threat.enrichments.indicator.file.pe.imports_names_var_entropy":{dashed_name:"threat-enrichments-indicator-file-pe-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of imported element names and types.",flat_name:"threat.enrichments.indicator.file.pe.imports_names_var_entropy",format:"number",level:"extended",name:"imports_names_var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the list of imported element names and types.",type:"long"},"threat.enrichments.indicator.file.pe.original_file_name":{dashed_name:"threat-enrichments-indicator-file-pe-original-file-name",description:"Internal name of the file, provided at compile-time.",example:"MSPAINT.EXE",flat_name:"threat.enrichments.indicator.file.pe.original_file_name",ignore_above:1024,level:"extended",name:"original_file_name",normalize:[],original_fieldset:"pe",short:"Internal name of the file, provided at compile-time.",type:"keyword"},"threat.enrichments.indicator.file.pe.pehash":{dashed_name:"threat-enrichments-indicator-file-pe-pehash",description:"A hash of the PE header and data from one or more PE sections. An pehash can be used to cluster files by transforming structural information about a file into a hash value.\nLearn more at https://www.usenix.org/legacy/events/leet09/tech/full_papers/wicherski/wicherski_html/index.html.",example:"73ff189b63cd6be375a7ff25179a38d347651975",flat_name:"threat.enrichments.indicator.file.pe.pehash",ignore_above:1024,level:"extended",name:"pehash",normalize:[],original_fieldset:"pe",short:"A hash of the PE header and data from one or more PE sections.",type:"keyword"},"threat.enrichments.indicator.file.pe.product":{dashed_name:"threat-enrichments-indicator-file-pe-product",description:"Internal product name of the file, provided at compile-time.",example:"Microsoft® Windows® Operating System",flat_name:"threat.enrichments.indicator.file.pe.product",ignore_above:1024,level:"extended",name:"product",normalize:[],original_fieldset:"pe",short:"Internal product name of the file, provided at compile-time.",type:"keyword"},"threat.enrichments.indicator.file.pe.sections":{dashed_name:"threat-enrichments-indicator-file-pe-sections",description:"An array containing an object for each section of the PE file.\nThe keys that should be present in these objects are defined by sub-fields underneath `pe.sections.*`.",flat_name:"threat.enrichments.indicator.file.pe.sections",level:"extended",name:"sections",normalize:["array"],original_fieldset:"pe",short:"Section information of the PE file.",type:"nested"},"threat.enrichments.indicator.file.pe.sections.entropy":{dashed_name:"threat-enrichments-indicator-file-pe-sections-entropy",description:"Shannon entropy calculation from the section.",flat_name:"threat.enrichments.indicator.file.pe.sections.entropy",format:"number",level:"extended",name:"sections.entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the section.",type:"long"},"threat.enrichments.indicator.file.pe.sections.name":{dashed_name:"threat-enrichments-indicator-file-pe-sections-name",description:"PE Section List name.",flat_name:"threat.enrichments.indicator.file.pe.sections.name",ignore_above:1024,level:"extended",name:"sections.name",normalize:[],original_fieldset:"pe",short:"PE Section List name.",type:"keyword"},"threat.enrichments.indicator.file.pe.sections.physical_size":{dashed_name:"threat-enrichments-indicator-file-pe-sections-physical-size",description:"PE Section List physical size.",flat_name:"threat.enrichments.indicator.file.pe.sections.physical_size",format:"bytes",level:"extended",name:"sections.physical_size",normalize:[],original_fieldset:"pe",short:"PE Section List physical size.",type:"long"},"threat.enrichments.indicator.file.pe.sections.var_entropy":{dashed_name:"threat-enrichments-indicator-file-pe-sections-var-entropy",description:"Variance for Shannon entropy calculation from the section.",flat_name:"threat.enrichments.indicator.file.pe.sections.var_entropy",format:"number",level:"extended",name:"sections.var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the section.",type:"long"},"threat.enrichments.indicator.file.pe.sections.virtual_size":{dashed_name:"threat-enrichments-indicator-file-pe-sections-virtual-size",description:"PE Section List virtual size. This is always the same as `physical_size`.",flat_name:"threat.enrichments.indicator.file.pe.sections.virtual_size",format:"string",level:"extended",name:"sections.virtual_size",normalize:[],original_fieldset:"pe",short:"PE Section List virtual size. This is always the same as `physical_size`.",type:"long"},"threat.enrichments.indicator.file.size":{dashed_name:"threat-enrichments-indicator-file-size",description:'File size in bytes.\nOnly relevant when `file.type` is "file".',example:16384,flat_name:"threat.enrichments.indicator.file.size",level:"extended",name:"size",normalize:[],original_fieldset:"file",short:"File size in bytes.",type:"long"},"threat.enrichments.indicator.file.target_path":{dashed_name:"threat-enrichments-indicator-file-target-path",description:"Target path for symlinks.",flat_name:"threat.enrichments.indicator.file.target_path",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"threat.enrichments.indicator.file.target_path.text",name:"text",type:"match_only_text"}],name:"target_path",normalize:[],original_fieldset:"file",short:"Target path for symlinks.",type:"keyword"},"threat.enrichments.indicator.file.type":{dashed_name:"threat-enrichments-indicator-file-type",description:"File type (file, dir, or symlink).",example:"file",flat_name:"threat.enrichments.indicator.file.type",ignore_above:1024,level:"extended",name:"type",normalize:[],original_fieldset:"file",short:"File type (file, dir, or symlink).",type:"keyword"},"threat.enrichments.indicator.file.uid":{dashed_name:"threat-enrichments-indicator-file-uid",description:"The user ID (UID) or security identifier (SID) of the file owner.",example:"1001",flat_name:"threat.enrichments.indicator.file.uid",ignore_above:1024,level:"extended",name:"uid",normalize:[],original_fieldset:"file",short:"The user ID (UID) or security identifier (SID) of the file owner.",type:"keyword"},"threat.enrichments.indicator.file.x509.alternative_names":{dashed_name:"threat-enrichments-indicator-file-x509-alternative-names",description:"List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.",example:"*.elastic.co",flat_name:"threat.enrichments.indicator.file.x509.alternative_names",ignore_above:1024,level:"extended",name:"alternative_names",normalize:["array"],original_fieldset:"x509",short:"List of subject alternative names (SAN).",type:"keyword"},"threat.enrichments.indicator.file.x509.issuer.common_name":{dashed_name:"threat-enrichments-indicator-file-x509-issuer-common-name",description:"List of common name (CN) of issuing certificate authority.",example:"Example SHA2 High Assurance Server CA",flat_name:"threat.enrichments.indicator.file.x509.issuer.common_name",ignore_above:1024,level:"extended",name:"issuer.common_name",normalize:["array"],original_fieldset:"x509",short:"List of common name (CN) of issuing certificate authority.",type:"keyword"},"threat.enrichments.indicator.file.x509.issuer.country":{dashed_name:"threat-enrichments-indicator-file-x509-issuer-country",description:"List of country \\(C) codes",example:"US",flat_name:"threat.enrichments.indicator.file.x509.issuer.country",ignore_above:1024,level:"extended",name:"issuer.country",normalize:["array"],original_fieldset:"x509",short:"List of country \\(C) codes",type:"keyword"},"threat.enrichments.indicator.file.x509.issuer.distinguished_name":{dashed_name:"threat-enrichments-indicator-file-x509-issuer-distinguished-name",description:"Distinguished name (DN) of issuing certificate authority.",example:"C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA",flat_name:"threat.enrichments.indicator.file.x509.issuer.distinguished_name",ignore_above:1024,level:"extended",name:"issuer.distinguished_name",normalize:[],original_fieldset:"x509",short:"Distinguished name (DN) of issuing certificate authority.",type:"keyword"},"threat.enrichments.indicator.file.x509.issuer.locality":{dashed_name:"threat-enrichments-indicator-file-x509-issuer-locality",description:"List of locality names (L)",example:"Mountain View",flat_name:"threat.enrichments.indicator.file.x509.issuer.locality",ignore_above:1024,level:"extended",name:"issuer.locality",normalize:["array"],original_fieldset:"x509",short:"List of locality names (L)",type:"keyword"},"threat.enrichments.indicator.file.x509.issuer.organization":{dashed_name:"threat-enrichments-indicator-file-x509-issuer-organization",description:"List of organizations (O) of issuing certificate authority.",example:"Example Inc",flat_name:"threat.enrichments.indicator.file.x509.issuer.organization",ignore_above:1024,level:"extended",name:"issuer.organization",normalize:["array"],original_fieldset:"x509",short:"List of organizations (O) of issuing certificate authority.",type:"keyword"},"threat.enrichments.indicator.file.x509.issuer.organizational_unit":{dashed_name:"threat-enrichments-indicator-file-x509-issuer-organizational-unit",description:"List of organizational units (OU) of issuing certificate authority.",example:"www.example.com",flat_name:"threat.enrichments.indicator.file.x509.issuer.organizational_unit",ignore_above:1024,level:"extended",name:"issuer.organizational_unit",normalize:["array"],original_fieldset:"x509",short:"List of organizational units (OU) of issuing certificate authority.",type:"keyword"},"threat.enrichments.indicator.file.x509.issuer.state_or_province":{dashed_name:"threat-enrichments-indicator-file-x509-issuer-state-or-province",description:"List of state or province names (ST, S, or P)",example:"California",flat_name:"threat.enrichments.indicator.file.x509.issuer.state_or_province",ignore_above:1024,level:"extended",name:"issuer.state_or_province",normalize:["array"],original_fieldset:"x509",short:"List of state or province names (ST, S, or P)",type:"keyword"},"threat.enrichments.indicator.file.x509.not_after":{dashed_name:"threat-enrichments-indicator-file-x509-not-after",description:"Time at which the certificate is no longer considered valid.",example:"2020-07-16T03:15:39Z",flat_name:"threat.enrichments.indicator.file.x509.not_after",level:"extended",name:"not_after",normalize:[],original_fieldset:"x509",short:"Time at which the certificate is no longer considered valid.",type:"date"},"threat.enrichments.indicator.file.x509.not_before":{dashed_name:"threat-enrichments-indicator-file-x509-not-before",description:"Time at which the certificate is first considered valid.",example:"2019-08-16T01:40:25Z",flat_name:"threat.enrichments.indicator.file.x509.not_before",level:"extended",name:"not_before",normalize:[],original_fieldset:"x509",short:"Time at which the certificate is first considered valid.",type:"date"},"threat.enrichments.indicator.file.x509.public_key_algorithm":{dashed_name:"threat-enrichments-indicator-file-x509-public-key-algorithm",description:"Algorithm used to generate the public key.",example:"RSA",flat_name:"threat.enrichments.indicator.file.x509.public_key_algorithm",ignore_above:1024,level:"extended",name:"public_key_algorithm",normalize:[],original_fieldset:"x509",short:"Algorithm used to generate the public key.",type:"keyword"},"threat.enrichments.indicator.file.x509.public_key_curve":{dashed_name:"threat-enrichments-indicator-file-x509-public-key-curve",description:"The curve used by the elliptic curve public key algorithm. This is algorithm specific.",example:"nistp521",flat_name:"threat.enrichments.indicator.file.x509.public_key_curve",ignore_above:1024,level:"extended",name:"public_key_curve",normalize:[],original_fieldset:"x509",short:"The curve used by the elliptic curve public key algorithm. This is algorithm specific.",type:"keyword"},"threat.enrichments.indicator.file.x509.public_key_exponent":{dashed_name:"threat-enrichments-indicator-file-x509-public-key-exponent",description:"Exponent used to derive the public key. This is algorithm specific.",doc_values:!1,example:65537,flat_name:"threat.enrichments.indicator.file.x509.public_key_exponent",index:!1,level:"extended",name:"public_key_exponent",normalize:[],original_fieldset:"x509",short:"Exponent used to derive the public key. This is algorithm specific.",type:"long"},"threat.enrichments.indicator.file.x509.public_key_size":{dashed_name:"threat-enrichments-indicator-file-x509-public-key-size",description:"The size of the public key space in bits.",example:2048,flat_name:"threat.enrichments.indicator.file.x509.public_key_size",level:"extended",name:"public_key_size",normalize:[],original_fieldset:"x509",short:"The size of the public key space in bits.",type:"long"},"threat.enrichments.indicator.file.x509.serial_number":{dashed_name:"threat-enrichments-indicator-file-x509-serial-number",description:"Unique serial number issued by the certificate authority. For consistency, this must be encoded in base 16 and formatted without colons and uppercase characters.",example:"55FBB9C7DEBF09809D12CCAA",flat_name:"threat.enrichments.indicator.file.x509.serial_number",ignore_above:1024,level:"extended",name:"serial_number",normalize:[],original_fieldset:"x509",short:"Unique serial number issued by the certificate authority.",type:"keyword"},"threat.enrichments.indicator.file.x509.signature_algorithm":{dashed_name:"threat-enrichments-indicator-file-x509-signature-algorithm",description:"Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353.",example:"SHA256-RSA",flat_name:"threat.enrichments.indicator.file.x509.signature_algorithm",ignore_above:1024,level:"extended",name:"signature_algorithm",normalize:[],original_fieldset:"x509",short:"Identifier for certificate signature algorithm.",type:"keyword"},"threat.enrichments.indicator.file.x509.subject.common_name":{dashed_name:"threat-enrichments-indicator-file-x509-subject-common-name",description:"List of common names (CN) of subject.",example:"shared.global.example.net",flat_name:"threat.enrichments.indicator.file.x509.subject.common_name",ignore_above:1024,level:"extended",name:"subject.common_name",normalize:["array"],original_fieldset:"x509",short:"List of common names (CN) of subject.",type:"keyword"},"threat.enrichments.indicator.file.x509.subject.country":{dashed_name:"threat-enrichments-indicator-file-x509-subject-country",description:"List of country \\(C) code",example:"US",flat_name:"threat.enrichments.indicator.file.x509.subject.country",ignore_above:1024,level:"extended",name:"subject.country",normalize:["array"],original_fieldset:"x509",short:"List of country \\(C) code",type:"keyword"},"threat.enrichments.indicator.file.x509.subject.distinguished_name":{dashed_name:"threat-enrichments-indicator-file-x509-subject-distinguished-name",description:"Distinguished name (DN) of the certificate subject entity.",example:"C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net",flat_name:"threat.enrichments.indicator.file.x509.subject.distinguished_name",ignore_above:1024,level:"extended",name:"subject.distinguished_name",normalize:[],original_fieldset:"x509",short:"Distinguished name (DN) of the certificate subject entity.",type:"keyword"},"threat.enrichments.indicator.file.x509.subject.locality":{dashed_name:"threat-enrichments-indicator-file-x509-subject-locality",description:"List of locality names (L)",example:"San Francisco",flat_name:"threat.enrichments.indicator.file.x509.subject.locality",ignore_above:1024,level:"extended",name:"subject.locality",normalize:["array"],original_fieldset:"x509",short:"List of locality names (L)",type:"keyword"},"threat.enrichments.indicator.file.x509.subject.organization":{dashed_name:"threat-enrichments-indicator-file-x509-subject-organization",description:"List of organizations (O) of subject.",example:"Example, Inc.",flat_name:"threat.enrichments.indicator.file.x509.subject.organization",ignore_above:1024,level:"extended",name:"subject.organization",normalize:["array"],original_fieldset:"x509",short:"List of organizations (O) of subject.",type:"keyword"},"threat.enrichments.indicator.file.x509.subject.organizational_unit":{dashed_name:"threat-enrichments-indicator-file-x509-subject-organizational-unit",description:"List of organizational units (OU) of subject.",flat_name:"threat.enrichments.indicator.file.x509.subject.organizational_unit",ignore_above:1024,level:"extended",name:"subject.organizational_unit",normalize:["array"],original_fieldset:"x509",short:"List of organizational units (OU) of subject.",type:"keyword"},"threat.enrichments.indicator.file.x509.subject.state_or_province":{dashed_name:"threat-enrichments-indicator-file-x509-subject-state-or-province",description:"List of state or province names (ST, S, or P)",example:"California",flat_name:"threat.enrichments.indicator.file.x509.subject.state_or_province",ignore_above:1024,level:"extended",name:"subject.state_or_province",normalize:["array"],original_fieldset:"x509",short:"List of state or province names (ST, S, or P)",type:"keyword"},"threat.enrichments.indicator.file.x509.version_number":{dashed_name:"threat-enrichments-indicator-file-x509-version-number",description:"Version of x509 format.",example:3,flat_name:"threat.enrichments.indicator.file.x509.version_number",ignore_above:1024,level:"extended",name:"version_number",normalize:[],original_fieldset:"x509",short:"Version of x509 format.",type:"keyword"},"threat.enrichments.indicator.first_seen":{dashed_name:"threat-enrichments-indicator-first-seen",description:"The date and time when intelligence source first reported sighting this indicator.",example:"2020-11-05T17:25:47.000Z",flat_name:"threat.enrichments.indicator.first_seen",level:"extended",name:"enrichments.indicator.first_seen",normalize:[],short:"Date/time indicator was first reported.",type:"date"},"threat.enrichments.indicator.geo.city_name":{dashed_name:"threat-enrichments-indicator-geo-city-name",description:"City name.",example:"Montreal",flat_name:"threat.enrichments.indicator.geo.city_name",ignore_above:1024,level:"core",name:"city_name",normalize:[],original_fieldset:"geo",short:"City name.",type:"keyword"},"threat.enrichments.indicator.geo.continent_code":{dashed_name:"threat-enrichments-indicator-geo-continent-code",description:"Two-letter code representing continent's name.",example:"NA",flat_name:"threat.enrichments.indicator.geo.continent_code",ignore_above:1024,level:"core",name:"continent_code",normalize:[],original_fieldset:"geo",short:"Continent code.",type:"keyword"},"threat.enrichments.indicator.geo.continent_name":{dashed_name:"threat-enrichments-indicator-geo-continent-name",description:"Name of the continent.",example:"North America",flat_name:"threat.enrichments.indicator.geo.continent_name",ignore_above:1024,level:"core",name:"continent_name",normalize:[],original_fieldset:"geo",short:"Name of the continent.",type:"keyword"},"threat.enrichments.indicator.geo.country_iso_code":{dashed_name:"threat-enrichments-indicator-geo-country-iso-code",description:"Country ISO code.",example:"CA",flat_name:"threat.enrichments.indicator.geo.country_iso_code",ignore_above:1024,level:"core",name:"country_iso_code",normalize:[],original_fieldset:"geo",short:"Country ISO code.",type:"keyword"},"threat.enrichments.indicator.geo.country_name":{dashed_name:"threat-enrichments-indicator-geo-country-name",description:"Country name.",example:"Canada",flat_name:"threat.enrichments.indicator.geo.country_name",ignore_above:1024,level:"core",name:"country_name",normalize:[],original_fieldset:"geo",short:"Country name.",type:"keyword"},"threat.enrichments.indicator.geo.location":{dashed_name:"threat-enrichments-indicator-geo-location",description:"Longitude and latitude.",example:'{ "lon": -73.614830, "lat": 45.505918 }',flat_name:"threat.enrichments.indicator.geo.location",level:"core",name:"location",normalize:[],original_fieldset:"geo",short:"Longitude and latitude.",type:"geo_point"},"threat.enrichments.indicator.geo.name":{dashed_name:"threat-enrichments-indicator-geo-name",description:"User-defined description of a location, at the level of granularity they care about.\nCould be the name of their data centers, the floor number, if this describes a local physical entity, city names.\nNot typically used in automated geolocation.",example:"boston-dc",flat_name:"threat.enrichments.indicator.geo.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"geo",short:"User-defined description of a location.",type:"keyword"},"threat.enrichments.indicator.geo.postal_code":{dashed_name:"threat-enrichments-indicator-geo-postal-code",description:"Postal code associated with the location.\nValues appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.",example:94040,flat_name:"threat.enrichments.indicator.geo.postal_code",ignore_above:1024,level:"core",name:"postal_code",normalize:[],original_fieldset:"geo",short:"Postal code.",type:"keyword"},"threat.enrichments.indicator.geo.region_iso_code":{dashed_name:"threat-enrichments-indicator-geo-region-iso-code",description:"Region ISO code.",example:"CA-QC",flat_name:"threat.enrichments.indicator.geo.region_iso_code",ignore_above:1024,level:"core",name:"region_iso_code",normalize:[],original_fieldset:"geo",short:"Region ISO code.",type:"keyword"},"threat.enrichments.indicator.geo.region_name":{dashed_name:"threat-enrichments-indicator-geo-region-name",description:"Region name.",example:"Quebec",flat_name:"threat.enrichments.indicator.geo.region_name",ignore_above:1024,level:"core",name:"region_name",normalize:[],original_fieldset:"geo",short:"Region name.",type:"keyword"},"threat.enrichments.indicator.geo.timezone":{dashed_name:"threat-enrichments-indicator-geo-timezone",description:"The time zone of the location, such as IANA time zone name.",example:"America/Argentina/Buenos_Aires",flat_name:"threat.enrichments.indicator.geo.timezone",ignore_above:1024,level:"core",name:"timezone",normalize:[],original_fieldset:"geo",short:"Time zone.",type:"keyword"},"threat.enrichments.indicator.ip":{dashed_name:"threat-enrichments-indicator-ip",description:"Identifies a threat indicator as an IP address (irrespective of direction).",example:"1.2.3.4",flat_name:"threat.enrichments.indicator.ip",level:"extended",name:"enrichments.indicator.ip",normalize:[],short:"Indicator IP address",type:"ip"},"threat.enrichments.indicator.last_seen":{dashed_name:"threat-enrichments-indicator-last-seen",description:"The date and time when intelligence source last reported sighting this indicator.",example:"2020-11-05T17:25:47.000Z",flat_name:"threat.enrichments.indicator.last_seen",level:"extended",name:"enrichments.indicator.last_seen",normalize:[],short:"Date/time indicator was last reported.",type:"date"},"threat.enrichments.indicator.marking.tlp":{dashed_name:"threat-enrichments-indicator-marking-tlp",description:"Traffic Light Protocol sharing markings.",example:"CLEAR",expected_values:["WHITE","CLEAR","GREEN","AMBER","AMBER+STRICT","RED"],flat_name:"threat.enrichments.indicator.marking.tlp",ignore_above:1024,level:"extended",name:"enrichments.indicator.marking.tlp",normalize:[],short:"Indicator TLP marking",type:"keyword"},"threat.enrichments.indicator.marking.tlp_version":{dashed_name:"threat-enrichments-indicator-marking-tlp-version",description:"Traffic Light Protocol version.",example:2,flat_name:"threat.enrichments.indicator.marking.tlp_version",ignore_above:1024,level:"extended",name:"enrichments.indicator.marking.tlp_version",normalize:[],short:"Indicator TLP version",type:"keyword"},"threat.enrichments.indicator.modified_at":{dashed_name:"threat-enrichments-indicator-modified-at",description:"The date and time when intelligence source last modified information for this indicator.",example:"2020-11-05T17:25:47.000Z",flat_name:"threat.enrichments.indicator.modified_at",level:"extended",name:"enrichments.indicator.modified_at",normalize:[],short:"Date/time indicator was last updated.",type:"date"},"threat.enrichments.indicator.name":{dashed_name:"threat-enrichments-indicator-name",description:"The display name indicator in an UI friendly format\nURL, IP address, email address, registry key, port number, hash value, or other relevant name can serve as the display name.",example:"5.2.75.227",flat_name:"threat.enrichments.indicator.name",ignore_above:1024,level:"extended",name:"enrichments.indicator.name",normalize:[],short:"Indicator display name",type:"keyword"},"threat.enrichments.indicator.port":{dashed_name:"threat-enrichments-indicator-port",description:"Identifies a threat indicator as a port number (irrespective of direction).",example:443,flat_name:"threat.enrichments.indicator.port",level:"extended",name:"enrichments.indicator.port",normalize:[],short:"Indicator port",type:"long"},"threat.enrichments.indicator.provider":{dashed_name:"threat-enrichments-indicator-provider",description:"The name of the indicator's provider.",example:"lrz_urlhaus",flat_name:"threat.enrichments.indicator.provider",ignore_above:1024,level:"extended",name:"enrichments.indicator.provider",normalize:[],short:"Indicator provider",type:"keyword"},"threat.enrichments.indicator.reference":{dashed_name:"threat-enrichments-indicator-reference",description:"Reference URL linking to additional information about this indicator.",example:"https://system.example.com/indicator/0001234",flat_name:"threat.enrichments.indicator.reference",ignore_above:1024,level:"extended",name:"enrichments.indicator.reference",normalize:[],short:"Indicator reference URL",type:"keyword"},"threat.enrichments.indicator.registry.data.bytes":{dashed_name:"threat-enrichments-indicator-registry-data-bytes",description:"Original bytes written with base64 encoding.\nFor Windows registry operations, such as SetValueEx and RegQueryValueEx, this corresponds to the data pointed by `lp_data`. This is optional but provides better recoverability and should be populated for REG_BINARY encoded values.",example:"ZQBuAC0AVQBTAAAAZQBuAAAAAAA=",flat_name:"threat.enrichments.indicator.registry.data.bytes",ignore_above:1024,level:"extended",name:"data.bytes",normalize:[],original_fieldset:"registry",short:"Original bytes written with base64 encoding.",type:"keyword"},"threat.enrichments.indicator.registry.data.strings":{dashed_name:"threat-enrichments-indicator-registry-data-strings",description:'Content when writing string types.\nPopulated as an array when writing string data to the registry. For single string registry types (REG_SZ, REG_EXPAND_SZ), this should be an array with one string. For sequences of string with REG_MULTI_SZ, this array will be variable length. For numeric data, such as REG_DWORD and REG_QWORD, this should be populated with the decimal representation (e.g `"1"`).',example:'["C:\\rta\\red_ttp\\bin\\myapp.exe"]',flat_name:"threat.enrichments.indicator.registry.data.strings",level:"core",name:"data.strings",normalize:["array"],original_fieldset:"registry",short:"List of strings representing what was written to the registry.",type:"wildcard"},"threat.enrichments.indicator.registry.data.type":{dashed_name:"threat-enrichments-indicator-registry-data-type",description:"Standard registry type for encoding contents",example:"REG_SZ",flat_name:"threat.enrichments.indicator.registry.data.type",ignore_above:1024,level:"core",name:"data.type",normalize:[],original_fieldset:"registry",short:"Standard registry type for encoding contents",type:"keyword"},"threat.enrichments.indicator.registry.hive":{dashed_name:"threat-enrichments-indicator-registry-hive",description:"Abbreviated name for the hive.",example:"HKLM",flat_name:"threat.enrichments.indicator.registry.hive",ignore_above:1024,level:"core",name:"hive",normalize:[],original_fieldset:"registry",short:"Abbreviated name for the hive.",type:"keyword"},"threat.enrichments.indicator.registry.key":{dashed_name:"threat-enrichments-indicator-registry-key",description:"Hive-relative path of keys.",example:"SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Image File Execution Options\\winword.exe",flat_name:"threat.enrichments.indicator.registry.key",ignore_above:1024,level:"core",name:"key",normalize:[],original_fieldset:"registry",short:"Hive-relative path of keys.",type:"keyword"},"threat.enrichments.indicator.registry.path":{dashed_name:"threat-enrichments-indicator-registry-path",description:"Full path, including hive, key and value",example:"HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Image File Execution Options\\winword.exe\\Debugger",flat_name:"threat.enrichments.indicator.registry.path",ignore_above:1024,level:"core",name:"path",normalize:[],original_fieldset:"registry",short:"Full path, including hive, key and value",type:"keyword"},"threat.enrichments.indicator.registry.value":{dashed_name:"threat-enrichments-indicator-registry-value",description:"Name of the value written.",example:"Debugger",flat_name:"threat.enrichments.indicator.registry.value",ignore_above:1024,level:"core",name:"value",normalize:[],original_fieldset:"registry",short:"Name of the value written.",type:"keyword"},"threat.enrichments.indicator.scanner_stats":{dashed_name:"threat-enrichments-indicator-scanner-stats",description:"Count of AV/EDR vendors that successfully detected malicious file or URL.",example:4,flat_name:"threat.enrichments.indicator.scanner_stats",level:"extended",name:"enrichments.indicator.scanner_stats",normalize:[],short:"Scanner statistics",type:"long"},"threat.enrichments.indicator.sightings":{dashed_name:"threat-enrichments-indicator-sightings",description:"Number of times this indicator was observed conducting threat activity.",example:20,flat_name:"threat.enrichments.indicator.sightings",level:"extended",name:"enrichments.indicator.sightings",normalize:[],short:"Number of times indicator observed",type:"long"},"threat.enrichments.indicator.type":{dashed_name:"threat-enrichments-indicator-type",description:"Type of indicator as represented by Cyber Observable in STIX 2.0.",example:"ipv4-addr",expected_values:["autonomous-system","artifact","directory","domain-name","email-addr","file","ipv4-addr","ipv6-addr","mac-addr","mutex","port","process","software","url","user-account","windows-registry-key","x509-certificate"],flat_name:"threat.enrichments.indicator.type",ignore_above:1024,level:"extended",name:"enrichments.indicator.type",normalize:[],short:"Type of indicator",type:"keyword"},"threat.enrichments.indicator.url.domain":{dashed_name:"threat-enrichments-indicator-url-domain",description:'Domain of the url, such as "www.elastic.co".\nIn some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field.\nIf the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field.',example:"www.elastic.co",flat_name:"threat.enrichments.indicator.url.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"url",short:"Domain of the url.",type:"keyword"},"threat.enrichments.indicator.url.extension":{dashed_name:"threat-enrichments-indicator-url-extension",description:'The field contains the file extension from the original request url, excluding the leading dot.\nThe file extension is only set if it exists, as not every url has a file extension.\nThe leading period must not be included. For example, the value must be "png", not ".png".\nNote that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").',example:"png",flat_name:"threat.enrichments.indicator.url.extension",ignore_above:1024,level:"extended",name:"extension",normalize:[],original_fieldset:"url",short:"File extension from the request url, excluding the leading dot.",type:"keyword"},"threat.enrichments.indicator.url.fragment":{dashed_name:"threat-enrichments-indicator-url-fragment",description:'Portion of the url after the `#`, such as "top".\nThe `#` is not part of the fragment.',flat_name:"threat.enrichments.indicator.url.fragment",ignore_above:1024,level:"extended",name:"fragment",normalize:[],original_fieldset:"url",short:"Portion of the url after the `#`.",type:"keyword"},"threat.enrichments.indicator.url.full":{dashed_name:"threat-enrichments-indicator-url-full",description:"If full URLs are important to your use case, they should be stored in `url.full`, whether this field is reconstructed or present in the event source.",example:"https://www.elastic.co:443/search?q=elasticsearch#top",flat_name:"threat.enrichments.indicator.url.full",level:"extended",multi_fields:[{flat_name:"threat.enrichments.indicator.url.full.text",name:"text",type:"match_only_text"}],name:"full",normalize:[],original_fieldset:"url",short:"Full unparsed URL.",type:"wildcard"},"threat.enrichments.indicator.url.original":{dashed_name:"threat-enrichments-indicator-url-original",description:"Unmodified original url as seen in the event source.\nNote that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path.\nThis field is meant to represent the URL as it was observed, complete or not.",example:"https://www.elastic.co:443/search?q=elasticsearch#top or /search?q=elasticsearch",flat_name:"threat.enrichments.indicator.url.original",level:"extended",multi_fields:[{flat_name:"threat.enrichments.indicator.url.original.text",name:"text",type:"match_only_text"}],name:"original",normalize:[],original_fieldset:"url",short:"Unmodified original url as seen in the event source.",type:"wildcard"},"threat.enrichments.indicator.url.password":{dashed_name:"threat-enrichments-indicator-url-password",description:"Password of the request.",flat_name:"threat.enrichments.indicator.url.password",ignore_above:1024,level:"extended",name:"password",normalize:[],original_fieldset:"url",short:"Password of the request.",type:"keyword"},"threat.enrichments.indicator.url.path":{dashed_name:"threat-enrichments-indicator-url-path",description:'Path of the request, such as "/search".',flat_name:"threat.enrichments.indicator.url.path",level:"extended",name:"path",normalize:[],original_fieldset:"url",short:'Path of the request, such as "/search".',type:"wildcard"},"threat.enrichments.indicator.url.port":{dashed_name:"threat-enrichments-indicator-url-port",description:"Port of the request, such as 443.",example:443,flat_name:"threat.enrichments.indicator.url.port",format:"string",level:"extended",name:"port",normalize:[],original_fieldset:"url",short:"Port of the request, such as 443.",type:"long"},"threat.enrichments.indicator.url.query":{dashed_name:"threat-enrichments-indicator-url-query",description:'The query field describes the query string of the request, such as "q=elasticsearch".\nThe `?` is excluded from the query string. If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases.',flat_name:"threat.enrichments.indicator.url.query",ignore_above:2083,level:"extended",name:"query",normalize:[],original_fieldset:"url",short:"Query string of the request.",type:"keyword"},"threat.enrichments.indicator.url.registered_domain":{dashed_name:"threat-enrichments-indicator-url-registered-domain",description:'The highest registered url domain, stripped of the subdomain.\nFor example, the registered domain for "foo.example.com" is "example.com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".',example:"example.com",flat_name:"threat.enrichments.indicator.url.registered_domain",ignore_above:1024,level:"extended",name:"registered_domain",normalize:[],original_fieldset:"url",short:"The highest registered url domain, stripped of the subdomain.",type:"keyword"},"threat.enrichments.indicator.url.scheme":{dashed_name:"threat-enrichments-indicator-url-scheme",description:'Scheme of the request, such as "https".\nNote: The `:` is not part of the scheme.',example:"https",flat_name:"threat.enrichments.indicator.url.scheme",ignore_above:1024,level:"extended",name:"scheme",normalize:[],original_fieldset:"url",short:"Scheme of the url.",type:"keyword"},"threat.enrichments.indicator.url.subdomain":{dashed_name:"threat-enrichments-indicator-url-subdomain",description:'The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain.\nFor example the subdomain portion of "www.east.mydomain.co.uk" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.',example:"east",flat_name:"threat.enrichments.indicator.url.subdomain",ignore_above:1024,level:"extended",name:"subdomain",normalize:[],original_fieldset:"url",short:"The subdomain of the domain.",type:"keyword"},"threat.enrichments.indicator.url.top_level_domain":{dashed_name:"threat-enrichments-indicator-url-top-level-domain",description:'The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".',example:"co.uk",flat_name:"threat.enrichments.indicator.url.top_level_domain",ignore_above:1024,level:"extended",name:"top_level_domain",normalize:[],original_fieldset:"url",short:"The effective top level domain (com, org, net, co.uk).",type:"keyword"},"threat.enrichments.indicator.url.username":{dashed_name:"threat-enrichments-indicator-url-username",description:"Username of the request.",flat_name:"threat.enrichments.indicator.url.username",ignore_above:1024,level:"extended",name:"username",normalize:[],original_fieldset:"url",short:"Username of the request.",type:"keyword"},"threat.enrichments.indicator.x509.alternative_names":{dashed_name:"threat-enrichments-indicator-x509-alternative-names",description:"List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.",example:"*.elastic.co",flat_name:"threat.enrichments.indicator.x509.alternative_names",ignore_above:1024,level:"extended",name:"alternative_names",normalize:["array"],original_fieldset:"x509",short:"List of subject alternative names (SAN).",type:"keyword"},"threat.enrichments.indicator.x509.issuer.common_name":{dashed_name:"threat-enrichments-indicator-x509-issuer-common-name",description:"List of common name (CN) of issuing certificate authority.",example:"Example SHA2 High Assurance Server CA",flat_name:"threat.enrichments.indicator.x509.issuer.common_name",ignore_above:1024,level:"extended",name:"issuer.common_name",normalize:["array"],original_fieldset:"x509",short:"List of common name (CN) of issuing certificate authority.",type:"keyword"},"threat.enrichments.indicator.x509.issuer.country":{dashed_name:"threat-enrichments-indicator-x509-issuer-country",description:"List of country \\(C) codes",example:"US",flat_name:"threat.enrichments.indicator.x509.issuer.country",ignore_above:1024,level:"extended",name:"issuer.country",normalize:["array"],original_fieldset:"x509",short:"List of country \\(C) codes",type:"keyword"},"threat.enrichments.indicator.x509.issuer.distinguished_name":{dashed_name:"threat-enrichments-indicator-x509-issuer-distinguished-name",description:"Distinguished name (DN) of issuing certificate authority.",example:"C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA",flat_name:"threat.enrichments.indicator.x509.issuer.distinguished_name",ignore_above:1024,level:"extended",name:"issuer.distinguished_name",normalize:[],original_fieldset:"x509",short:"Distinguished name (DN) of issuing certificate authority.",type:"keyword"},"threat.enrichments.indicator.x509.issuer.locality":{dashed_name:"threat-enrichments-indicator-x509-issuer-locality",description:"List of locality names (L)",example:"Mountain View",flat_name:"threat.enrichments.indicator.x509.issuer.locality",ignore_above:1024,level:"extended",name:"issuer.locality",normalize:["array"],original_fieldset:"x509",short:"List of locality names (L)",type:"keyword"},"threat.enrichments.indicator.x509.issuer.organization":{dashed_name:"threat-enrichments-indicator-x509-issuer-organization",description:"List of organizations (O) of issuing certificate authority.",example:"Example Inc",flat_name:"threat.enrichments.indicator.x509.issuer.organization",ignore_above:1024,level:"extended",name:"issuer.organization",normalize:["array"],original_fieldset:"x509",short:"List of organizations (O) of issuing certificate authority.",type:"keyword"},"threat.enrichments.indicator.x509.issuer.organizational_unit":{dashed_name:"threat-enrichments-indicator-x509-issuer-organizational-unit",description:"List of organizational units (OU) of issuing certificate authority.",example:"www.example.com",flat_name:"threat.enrichments.indicator.x509.issuer.organizational_unit",ignore_above:1024,level:"extended",name:"issuer.organizational_unit",normalize:["array"],original_fieldset:"x509",short:"List of organizational units (OU) of issuing certificate authority.",type:"keyword"},"threat.enrichments.indicator.x509.issuer.state_or_province":{dashed_name:"threat-enrichments-indicator-x509-issuer-state-or-province",description:"List of state or province names (ST, S, or P)",example:"California",flat_name:"threat.enrichments.indicator.x509.issuer.state_or_province",ignore_above:1024,level:"extended",name:"issuer.state_or_province",normalize:["array"],original_fieldset:"x509",short:"List of state or province names (ST, S, or P)",type:"keyword"},"threat.enrichments.indicator.x509.not_after":{dashed_name:"threat-enrichments-indicator-x509-not-after",description:"Time at which the certificate is no longer considered valid.",example:"2020-07-16T03:15:39Z",flat_name:"threat.enrichments.indicator.x509.not_after",level:"extended",name:"not_after",normalize:[],original_fieldset:"x509",short:"Time at which the certificate is no longer considered valid.",type:"date"},"threat.enrichments.indicator.x509.not_before":{dashed_name:"threat-enrichments-indicator-x509-not-before",description:"Time at which the certificate is first considered valid.",example:"2019-08-16T01:40:25Z",flat_name:"threat.enrichments.indicator.x509.not_before",level:"extended",name:"not_before",normalize:[],original_fieldset:"x509",short:"Time at which the certificate is first considered valid.",type:"date"},"threat.enrichments.indicator.x509.public_key_algorithm":{dashed_name:"threat-enrichments-indicator-x509-public-key-algorithm",description:"Algorithm used to generate the public key.",example:"RSA",flat_name:"threat.enrichments.indicator.x509.public_key_algorithm",ignore_above:1024,level:"extended",name:"public_key_algorithm",normalize:[],original_fieldset:"x509",short:"Algorithm used to generate the public key.",type:"keyword"},"threat.enrichments.indicator.x509.public_key_curve":{dashed_name:"threat-enrichments-indicator-x509-public-key-curve",description:"The curve used by the elliptic curve public key algorithm. This is algorithm specific.",example:"nistp521",flat_name:"threat.enrichments.indicator.x509.public_key_curve",ignore_above:1024,level:"extended",name:"public_key_curve",normalize:[],original_fieldset:"x509",short:"The curve used by the elliptic curve public key algorithm. This is algorithm specific.",type:"keyword"},"threat.enrichments.indicator.x509.public_key_exponent":{dashed_name:"threat-enrichments-indicator-x509-public-key-exponent",description:"Exponent used to derive the public key. This is algorithm specific.",doc_values:!1,example:65537,flat_name:"threat.enrichments.indicator.x509.public_key_exponent",index:!1,level:"extended",name:"public_key_exponent",normalize:[],original_fieldset:"x509",short:"Exponent used to derive the public key. This is algorithm specific.",type:"long"},"threat.enrichments.indicator.x509.public_key_size":{dashed_name:"threat-enrichments-indicator-x509-public-key-size",description:"The size of the public key space in bits.",example:2048,flat_name:"threat.enrichments.indicator.x509.public_key_size",level:"extended",name:"public_key_size",normalize:[],original_fieldset:"x509",short:"The size of the public key space in bits.",type:"long"},"threat.enrichments.indicator.x509.serial_number":{dashed_name:"threat-enrichments-indicator-x509-serial-number",description:"Unique serial number issued by the certificate authority. For consistency, this must be encoded in base 16 and formatted without colons and uppercase characters.",example:"55FBB9C7DEBF09809D12CCAA",flat_name:"threat.enrichments.indicator.x509.serial_number",ignore_above:1024,level:"extended",name:"serial_number",normalize:[],original_fieldset:"x509",short:"Unique serial number issued by the certificate authority.",type:"keyword"},"threat.enrichments.indicator.x509.signature_algorithm":{dashed_name:"threat-enrichments-indicator-x509-signature-algorithm",description:"Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353.",example:"SHA256-RSA",flat_name:"threat.enrichments.indicator.x509.signature_algorithm",ignore_above:1024,level:"extended",name:"signature_algorithm",normalize:[],original_fieldset:"x509",short:"Identifier for certificate signature algorithm.",type:"keyword"},"threat.enrichments.indicator.x509.subject.common_name":{dashed_name:"threat-enrichments-indicator-x509-subject-common-name",description:"List of common names (CN) of subject.",example:"shared.global.example.net",flat_name:"threat.enrichments.indicator.x509.subject.common_name",ignore_above:1024,level:"extended",name:"subject.common_name",normalize:["array"],original_fieldset:"x509",short:"List of common names (CN) of subject.",type:"keyword"},"threat.enrichments.indicator.x509.subject.country":{dashed_name:"threat-enrichments-indicator-x509-subject-country",description:"List of country \\(C) code",example:"US",flat_name:"threat.enrichments.indicator.x509.subject.country",ignore_above:1024,level:"extended",name:"subject.country",normalize:["array"],original_fieldset:"x509",short:"List of country \\(C) code",type:"keyword"},"threat.enrichments.indicator.x509.subject.distinguished_name":{dashed_name:"threat-enrichments-indicator-x509-subject-distinguished-name",description:"Distinguished name (DN) of the certificate subject entity.",example:"C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net",flat_name:"threat.enrichments.indicator.x509.subject.distinguished_name",ignore_above:1024,level:"extended",name:"subject.distinguished_name",normalize:[],original_fieldset:"x509",short:"Distinguished name (DN) of the certificate subject entity.",type:"keyword"},"threat.enrichments.indicator.x509.subject.locality":{dashed_name:"threat-enrichments-indicator-x509-subject-locality",description:"List of locality names (L)",example:"San Francisco",flat_name:"threat.enrichments.indicator.x509.subject.locality",ignore_above:1024,level:"extended",name:"subject.locality",normalize:["array"],original_fieldset:"x509",short:"List of locality names (L)",type:"keyword"},"threat.enrichments.indicator.x509.subject.organization":{dashed_name:"threat-enrichments-indicator-x509-subject-organization",description:"List of organizations (O) of subject.",example:"Example, Inc.",flat_name:"threat.enrichments.indicator.x509.subject.organization",ignore_above:1024,level:"extended",name:"subject.organization",normalize:["array"],original_fieldset:"x509",short:"List of organizations (O) of subject.",type:"keyword"},"threat.enrichments.indicator.x509.subject.organizational_unit":{dashed_name:"threat-enrichments-indicator-x509-subject-organizational-unit",description:"List of organizational units (OU) of subject.",flat_name:"threat.enrichments.indicator.x509.subject.organizational_unit",ignore_above:1024,level:"extended",name:"subject.organizational_unit",normalize:["array"],original_fieldset:"x509",short:"List of organizational units (OU) of subject.",type:"keyword"},"threat.enrichments.indicator.x509.subject.state_or_province":{dashed_name:"threat-enrichments-indicator-x509-subject-state-or-province",description:"List of state or province names (ST, S, or P)",example:"California",flat_name:"threat.enrichments.indicator.x509.subject.state_or_province",ignore_above:1024,level:"extended",name:"subject.state_or_province",normalize:["array"],original_fieldset:"x509",short:"List of state or province names (ST, S, or P)",type:"keyword"},"threat.enrichments.indicator.x509.version_number":{dashed_name:"threat-enrichments-indicator-x509-version-number",description:"Version of x509 format.",example:3,flat_name:"threat.enrichments.indicator.x509.version_number",ignore_above:1024,level:"extended",name:"version_number",normalize:[],original_fieldset:"x509",short:"Version of x509 format.",type:"keyword"},"threat.enrichments.matched.atomic":{dashed_name:"threat-enrichments-matched-atomic",description:"Identifies the atomic indicator value that matched a local environment endpoint or network event.",example:"bad-domain.com",flat_name:"threat.enrichments.matched.atomic",ignore_above:1024,level:"extended",name:"enrichments.matched.atomic",normalize:[],short:"Matched indicator value",type:"keyword"},"threat.enrichments.matched.field":{dashed_name:"threat-enrichments-matched-field",description:"Identifies the field of the atomic indicator that matched a local environment endpoint or network event.",example:"file.hash.sha256",flat_name:"threat.enrichments.matched.field",ignore_above:1024,level:"extended",name:"enrichments.matched.field",normalize:[],short:"Matched indicator field",type:"keyword"},"threat.enrichments.matched.id":{dashed_name:"threat-enrichments-matched-id",description:"Identifies the _id of the indicator document enriching the event.",example:"ff93aee5-86a1-4a61-b0e6-0cdc313d01b5",flat_name:"threat.enrichments.matched.id",ignore_above:1024,level:"extended",name:"enrichments.matched.id",normalize:[],short:"Matched indicator identifier",type:"keyword"},"threat.enrichments.matched.index":{dashed_name:"threat-enrichments-matched-index",description:"Identifies the _index of the indicator document enriching the event.",example:"filebeat-8.0.0-2021.05.23-000011",flat_name:"threat.enrichments.matched.index",ignore_above:1024,level:"extended",name:"enrichments.matched.index",normalize:[],short:"Matched indicator index",type:"keyword"},"threat.enrichments.matched.occurred":{dashed_name:"threat-enrichments-matched-occurred",description:"Indicates when the indicator match was generated",example:"2021-10-05T17:00:58.326Z",flat_name:"threat.enrichments.matched.occurred",level:"extended",name:"enrichments.matched.occurred",normalize:[],short:"Date of match",type:"date"},"threat.enrichments.matched.type":{dashed_name:"threat-enrichments-matched-type",description:"Identifies the type of match that caused the event to be enriched with the given indicator",example:"indicator_match_rule",flat_name:"threat.enrichments.matched.type",ignore_above:1024,level:"extended",name:"enrichments.matched.type",normalize:[],short:"Type of indicator match",type:"keyword"},"threat.feed.dashboard_id":{dashed_name:"threat-feed-dashboard-id",description:"The saved object ID of the dashboard belonging to the threat feed for displaying dashboard links to threat feeds in Kibana.",example:"5ba16340-72e6-11eb-a3e3-b3cc7c78a70f",flat_name:"threat.feed.dashboard_id",ignore_above:1024,level:"extended",name:"feed.dashboard_id",normalize:[],short:"Feed dashboard ID.",type:"keyword"},"threat.feed.description":{dashed_name:"threat-feed-description",description:"Description of the threat feed in a UI friendly format.",example:"Threat feed from the AlienVault Open Threat eXchange network.",flat_name:"threat.feed.description",ignore_above:1024,level:"extended",name:"feed.description",normalize:[],short:"Description of the threat feed.",type:"keyword"},"threat.feed.name":{dashed_name:"threat-feed-name",description:"The name of the threat feed in UI friendly format.",example:"AlienVault OTX",flat_name:"threat.feed.name",ignore_above:1024,level:"extended",name:"feed.name",normalize:[],short:"Name of the threat feed.",type:"keyword"},"threat.feed.reference":{dashed_name:"threat-feed-reference",description:"Reference information for the threat feed in a UI friendly format.",example:"https://otx.alienvault.com",flat_name:"threat.feed.reference",ignore_above:1024,level:"extended",name:"feed.reference",normalize:[],short:"Reference for the threat feed.",type:"keyword"},"threat.framework":{dashed_name:"threat-framework",description:"Name of the threat framework used to further categorize and classify the tactic and technique of the reported threat. Framework classification can be provided by detecting systems, evaluated at ingest time, or retrospectively tagged to events.",example:"MITRE ATT&CK",flat_name:"threat.framework",ignore_above:1024,level:"extended",name:"framework",normalize:[],short:"Threat classification framework.",type:"keyword"},"threat.group.alias":{dashed_name:"threat-group-alias",description:"The alias(es) of the group for a set of related intrusion activity that are tracked by a common name in the security community.\nWhile not required, you can use a MITRE ATT&CK® group alias(es).",example:'[ "Magecart Group 6" ]',flat_name:"threat.group.alias",ignore_above:1024,level:"extended",name:"group.alias",normalize:["array"],short:"Alias of the group.",synthetic_source_keep:"none",type:"keyword"},"threat.group.id":{dashed_name:"threat-group-id",description:"The id of the group for a set of related intrusion activity that are tracked by a common name in the security community.\nWhile not required, you can use a MITRE ATT&CK® group id.",example:"G0037",flat_name:"threat.group.id",ignore_above:1024,level:"extended",name:"group.id",normalize:[],short:"ID of the group.",type:"keyword"},"threat.group.name":{dashed_name:"threat-group-name",description:"The name of the group for a set of related intrusion activity that are tracked by a common name in the security community.\nWhile not required, you can use a MITRE ATT&CK® group name.",example:"FIN6",flat_name:"threat.group.name",ignore_above:1024,level:"extended",name:"group.name",normalize:[],short:"Name of the group.",type:"keyword"},"threat.group.reference":{dashed_name:"threat-group-reference",description:"The reference URL of the group for a set of related intrusion activity that are tracked by a common name in the security community.\nWhile not required, you can use a MITRE ATT&CK® group reference URL.",example:"https://attack.mitre.org/groups/G0037/",flat_name:"threat.group.reference",ignore_above:1024,level:"extended",name:"group.reference",normalize:[],short:"Reference URL of the group.",type:"keyword"},"threat.indicator.as.number":{dashed_name:"threat-indicator-as-number",description:"Unique number allocated to the autonomous system. The autonomous system number (ASN) uniquely identifies each network on the Internet.",example:15169,flat_name:"threat.indicator.as.number",level:"extended",name:"number",normalize:[],original_fieldset:"as",short:"Unique number allocated to the autonomous system.",type:"long"},"threat.indicator.as.organization.name":{dashed_name:"threat-indicator-as-organization-name",description:"Organization name.",example:"Google LLC",flat_name:"threat.indicator.as.organization.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"threat.indicator.as.organization.name.text",name:"text",type:"match_only_text"}],name:"organization.name",normalize:[],original_fieldset:"as",short:"Organization name.",type:"keyword"},"threat.indicator.confidence":{dashed_name:"threat-indicator-confidence",description:"Identifies the vendor-neutral confidence rating using the None/Low/Medium/High scale defined in Appendix A of the STIX 2.1 framework. Vendor-specific confidence scales may be added as custom fields.",example:"Medium",expected_values:["Not Specified","None","Low","Medium","High"],flat_name:"threat.indicator.confidence",ignore_above:1024,level:"extended",name:"indicator.confidence",normalize:[],short:"Indicator confidence rating",type:"keyword"},"threat.indicator.description":{dashed_name:"threat-indicator-description",description:"Describes the type of action conducted by the threat.",example:"IP x.x.x.x was observed delivering the Angler EK.",flat_name:"threat.indicator.description",ignore_above:1024,level:"extended",name:"indicator.description",normalize:[],short:"Indicator description",type:"keyword"},"threat.indicator.email.address":{dashed_name:"threat-indicator-email-address",description:"Identifies a threat indicator as an email address (irrespective of direction).",example:"phish@example.com",flat_name:"threat.indicator.email.address",ignore_above:1024,level:"extended",name:"indicator.email.address",normalize:[],short:"Indicator email address",type:"keyword"},"threat.indicator.file.accessed":{dashed_name:"threat-indicator-file-accessed",description:"Last time the file was accessed.\nNote that not all filesystems keep track of access time.",flat_name:"threat.indicator.file.accessed",level:"extended",name:"accessed",normalize:[],original_fieldset:"file",short:"Last time the file was accessed.",type:"date"},"threat.indicator.file.attributes":{dashed_name:"threat-indicator-file-attributes",description:"Array of file attributes.\nAttributes names will vary by platform. Here's a non-exhaustive list of values that are expected in this field: archive, compressed, directory, encrypted, execute, hidden, read, readonly, system, write.",example:'["readonly", "system"]',flat_name:"threat.indicator.file.attributes",ignore_above:1024,level:"extended",name:"attributes",normalize:["array"],original_fieldset:"file",short:"Array of file attributes.",synthetic_source_keep:"none",type:"keyword"},"threat.indicator.file.code_signature.digest_algorithm":{dashed_name:"threat-indicator-file-code-signature-digest-algorithm",description:"The hashing algorithm used to sign the process.\nThis value can distinguish signatures when a file is signed multiple times by the same signer but with a different digest algorithm.",example:"sha256",flat_name:"threat.indicator.file.code_signature.digest_algorithm",ignore_above:1024,level:"extended",name:"digest_algorithm",normalize:[],original_fieldset:"code_signature",short:"Hashing algorithm used to sign the process.",type:"keyword"},"threat.indicator.file.code_signature.exists":{dashed_name:"threat-indicator-file-code-signature-exists",description:"Boolean to capture if a signature is present.",example:"true",flat_name:"threat.indicator.file.code_signature.exists",level:"core",name:"exists",normalize:[],original_fieldset:"code_signature",short:"Boolean to capture if a signature is present.",type:"boolean"},"threat.indicator.file.code_signature.flags":{beta:"This field is beta and subject to change.",dashed_name:"threat-indicator-file-code-signature-flags",description:"The flags used to sign the process.",example:570522385,flat_name:"threat.indicator.file.code_signature.flags",ignore_above:1024,level:"extended",name:"flags",normalize:[],original_fieldset:"code_signature",short:"Code signing flags of the process",type:"keyword"},"threat.indicator.file.code_signature.signing_id":{dashed_name:"threat-indicator-file-code-signature-signing-id",description:"The identifier used to sign the process.\nThis is used to identify the application manufactured by a software vendor. The field is relevant to Apple *OS only.",example:"com.apple.xpc.proxy",flat_name:"threat.indicator.file.code_signature.signing_id",ignore_above:1024,level:"extended",name:"signing_id",normalize:[],original_fieldset:"code_signature",short:"The identifier used to sign the process.",type:"keyword"},"threat.indicator.file.code_signature.status":{dashed_name:"threat-indicator-file-code-signature-status",description:"Additional information about the certificate status.\nThis is useful for logging cryptographic errors with the certificate validity or trust status. Leave unpopulated if the validity or trust of the certificate was unchecked.",example:"ERROR_UNTRUSTED_ROOT",flat_name:"threat.indicator.file.code_signature.status",ignore_above:1024,level:"extended",name:"status",normalize:[],original_fieldset:"code_signature",short:"Additional information about the certificate status.",type:"keyword"},"threat.indicator.file.code_signature.subject_name":{dashed_name:"threat-indicator-file-code-signature-subject-name",description:"Subject name of the code signer",example:"Microsoft Corporation",flat_name:"threat.indicator.file.code_signature.subject_name",ignore_above:1024,level:"core",name:"subject_name",normalize:[],original_fieldset:"code_signature",short:"Subject name of the code signer",type:"keyword"},"threat.indicator.file.code_signature.team_id":{dashed_name:"threat-indicator-file-code-signature-team-id",description:"The team identifier used to sign the process.\nThis is used to identify the team or vendor of a software product. The field is relevant to Apple *OS only.",example:"EQHXZ8M8AV",flat_name:"threat.indicator.file.code_signature.team_id",ignore_above:1024,level:"extended",name:"team_id",normalize:[],original_fieldset:"code_signature",short:"The team identifier used to sign the process.",type:"keyword"},"threat.indicator.file.code_signature.timestamp":{dashed_name:"threat-indicator-file-code-signature-timestamp",description:"Date and time when the code signature was generated and signed.",example:"2021-01-01T12:10:30Z",flat_name:"threat.indicator.file.code_signature.timestamp",level:"extended",name:"timestamp",normalize:[],original_fieldset:"code_signature",short:"When the signature was generated and signed.",type:"date"},"threat.indicator.file.code_signature.trusted":{dashed_name:"threat-indicator-file-code-signature-trusted",description:"Stores the trust status of the certificate chain.\nValidating the trust of the certificate chain may be complicated, and this field should only be populated by tools that actively check the status.",example:"true",flat_name:"threat.indicator.file.code_signature.trusted",level:"extended",name:"trusted",normalize:[],original_fieldset:"code_signature",short:"Stores the trust status of the certificate chain.",type:"boolean"},"threat.indicator.file.code_signature.valid":{dashed_name:"threat-indicator-file-code-signature-valid",description:"Boolean to capture if the digital signature is verified against the binary content.\nLeave unpopulated if a certificate was unchecked.",example:"true",flat_name:"threat.indicator.file.code_signature.valid",level:"extended",name:"valid",normalize:[],original_fieldset:"code_signature",short:"Boolean to capture if the digital signature is verified against the binary content.",type:"boolean"},"threat.indicator.file.created":{dashed_name:"threat-indicator-file-created",description:"File creation time.\nNote that not all filesystems store the creation time.",flat_name:"threat.indicator.file.created",level:"extended",name:"created",normalize:[],original_fieldset:"file",short:"File creation time.",type:"date"},"threat.indicator.file.ctime":{dashed_name:"threat-indicator-file-ctime",description:"Last time the file attributes or metadata changed.\nNote that changes to the file content will update `mtime`. This implies `ctime` will be adjusted at the same time, since `mtime` is an attribute of the file.",flat_name:"threat.indicator.file.ctime",level:"extended",name:"ctime",normalize:[],original_fieldset:"file",short:"Last time the file attributes or metadata changed.",type:"date"},"threat.indicator.file.device":{dashed_name:"threat-indicator-file-device",description:"Device that is the source of the file.",example:"sda",flat_name:"threat.indicator.file.device",ignore_above:1024,level:"extended",name:"device",normalize:[],original_fieldset:"file",short:"Device that is the source of the file.",type:"keyword"},"threat.indicator.file.directory":{dashed_name:"threat-indicator-file-directory",description:"Directory where the file is located. It should include the drive letter, when appropriate.",example:"/home/alice",flat_name:"threat.indicator.file.directory",ignore_above:1024,level:"extended",name:"directory",normalize:[],original_fieldset:"file",short:"Directory where the file is located.",type:"keyword"},"threat.indicator.file.drive_letter":{dashed_name:"threat-indicator-file-drive-letter",description:"Drive letter where the file is located. This field is only relevant on Windows.\nThe value should be uppercase, and not include the colon.",example:"C",flat_name:"threat.indicator.file.drive_letter",ignore_above:1,level:"extended",name:"drive_letter",normalize:[],original_fieldset:"file",short:"Drive letter where the file is located.",type:"keyword"},"threat.indicator.file.elf.architecture":{dashed_name:"threat-indicator-file-elf-architecture",description:"Machine architecture of the ELF file.",example:"x86-64",flat_name:"threat.indicator.file.elf.architecture",ignore_above:1024,level:"extended",name:"architecture",normalize:[],original_fieldset:"elf",short:"Machine architecture of the ELF file.",type:"keyword"},"threat.indicator.file.elf.byte_order":{dashed_name:"threat-indicator-file-elf-byte-order",description:"Byte sequence of ELF file.",example:"Little Endian",flat_name:"threat.indicator.file.elf.byte_order",ignore_above:1024,level:"extended",name:"byte_order",normalize:[],original_fieldset:"elf",short:"Byte sequence of ELF file.",type:"keyword"},"threat.indicator.file.elf.cpu_type":{dashed_name:"threat-indicator-file-elf-cpu-type",description:"CPU type of the ELF file.",example:"Intel",flat_name:"threat.indicator.file.elf.cpu_type",ignore_above:1024,level:"extended",name:"cpu_type",normalize:[],original_fieldset:"elf",short:"CPU type of the ELF file.",type:"keyword"},"threat.indicator.file.elf.creation_date":{dashed_name:"threat-indicator-file-elf-creation-date",description:"Extracted when possible from the file's metadata. Indicates when it was built or compiled. It can also be faked by malware creators.",flat_name:"threat.indicator.file.elf.creation_date",level:"extended",name:"creation_date",normalize:[],original_fieldset:"elf",short:"Build or compile date.",type:"date"},"threat.indicator.file.elf.exports":{dashed_name:"threat-indicator-file-elf-exports",description:"List of exported element names and types.",flat_name:"threat.indicator.file.elf.exports",level:"extended",name:"exports",normalize:["array"],original_fieldset:"elf",short:"List of exported element names and types.",type:"flattened"},"threat.indicator.file.elf.go_import_hash":{dashed_name:"threat-indicator-file-elf-go-import-hash",description:"A hash of the Go language imports in an ELF file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThe algorithm used to calculate the Go symbol hash and a reference implementation are available here: https://github.com/elastic/toutoumomoma",example:"10bddcb4cee42080f76c88d9ff964491",flat_name:"threat.indicator.file.elf.go_import_hash",ignore_above:1024,level:"extended",name:"go_import_hash",normalize:[],original_fieldset:"elf",short:"A hash of the Go language imports in an ELF file.",type:"keyword"},"threat.indicator.file.elf.go_imports":{dashed_name:"threat-indicator-file-elf-go-imports",description:"List of imported Go language element names and types.",flat_name:"threat.indicator.file.elf.go_imports",level:"extended",name:"go_imports",normalize:[],original_fieldset:"elf",short:"List of imported Go language element names and types.",type:"flattened"},"threat.indicator.file.elf.go_imports_names_entropy":{dashed_name:"threat-indicator-file-elf-go-imports-names-entropy",description:"Shannon entropy calculation from the list of Go imports.",flat_name:"threat.indicator.file.elf.go_imports_names_entropy",format:"number",level:"extended",name:"go_imports_names_entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the list of Go imports.",type:"long"},"threat.indicator.file.elf.go_imports_names_var_entropy":{dashed_name:"threat-indicator-file-elf-go-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of Go imports.",flat_name:"threat.indicator.file.elf.go_imports_names_var_entropy",format:"number",level:"extended",name:"go_imports_names_var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the list of Go imports.",type:"long"},"threat.indicator.file.elf.go_stripped":{dashed_name:"threat-indicator-file-elf-go-stripped",description:"Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.",flat_name:"threat.indicator.file.elf.go_stripped",level:"extended",name:"go_stripped",normalize:[],original_fieldset:"elf",short:"Whether the file is a stripped or obfuscated Go executable.",type:"boolean"},"threat.indicator.file.elf.header.abi_version":{dashed_name:"threat-indicator-file-elf-header-abi-version",description:"Version of the ELF Application Binary Interface (ABI).",flat_name:"threat.indicator.file.elf.header.abi_version",ignore_above:1024,level:"extended",name:"header.abi_version",normalize:[],original_fieldset:"elf",short:"Version of the ELF Application Binary Interface (ABI).",type:"keyword"},"threat.indicator.file.elf.header.class":{dashed_name:"threat-indicator-file-elf-header-class",description:"Header class of the ELF file.",flat_name:"threat.indicator.file.elf.header.class",ignore_above:1024,level:"extended",name:"header.class",normalize:[],original_fieldset:"elf",short:"Header class of the ELF file.",type:"keyword"},"threat.indicator.file.elf.header.data":{dashed_name:"threat-indicator-file-elf-header-data",description:"Data table of the ELF header.",flat_name:"threat.indicator.file.elf.header.data",ignore_above:1024,level:"extended",name:"header.data",normalize:[],original_fieldset:"elf",short:"Data table of the ELF header.",type:"keyword"},"threat.indicator.file.elf.header.entrypoint":{dashed_name:"threat-indicator-file-elf-header-entrypoint",description:"Header entrypoint of the ELF file.",flat_name:"threat.indicator.file.elf.header.entrypoint",format:"string",level:"extended",name:"header.entrypoint",normalize:[],original_fieldset:"elf",short:"Header entrypoint of the ELF file.",type:"long"},"threat.indicator.file.elf.header.object_version":{dashed_name:"threat-indicator-file-elf-header-object-version",description:'"0x1" for original ELF files.',flat_name:"threat.indicator.file.elf.header.object_version",ignore_above:1024,level:"extended",name:"header.object_version",normalize:[],original_fieldset:"elf",short:'"0x1" for original ELF files.',type:"keyword"},"threat.indicator.file.elf.header.os_abi":{dashed_name:"threat-indicator-file-elf-header-os-abi",description:"Application Binary Interface (ABI) of the Linux OS.",flat_name:"threat.indicator.file.elf.header.os_abi",ignore_above:1024,level:"extended",name:"header.os_abi",normalize:[],original_fieldset:"elf",short:"Application Binary Interface (ABI) of the Linux OS.",type:"keyword"},"threat.indicator.file.elf.header.type":{dashed_name:"threat-indicator-file-elf-header-type",description:"Header type of the ELF file.",flat_name:"threat.indicator.file.elf.header.type",ignore_above:1024,level:"extended",name:"header.type",normalize:[],original_fieldset:"elf",short:"Header type of the ELF file.",type:"keyword"},"threat.indicator.file.elf.header.version":{dashed_name:"threat-indicator-file-elf-header-version",description:"Version of the ELF header.",flat_name:"threat.indicator.file.elf.header.version",ignore_above:1024,level:"extended",name:"header.version",normalize:[],original_fieldset:"elf",short:"Version of the ELF header.",type:"keyword"},"threat.indicator.file.elf.import_hash":{dashed_name:"threat-indicator-file-elf-import-hash",description:"A hash of the imports in an ELF file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is an ELF implementation of the Windows PE imphash.",example:"d41d8cd98f00b204e9800998ecf8427e",flat_name:"threat.indicator.file.elf.import_hash",ignore_above:1024,level:"extended",name:"import_hash",normalize:[],original_fieldset:"elf",short:"A hash of the imports in an ELF file.",type:"keyword"},"threat.indicator.file.elf.imports":{dashed_name:"threat-indicator-file-elf-imports",description:"List of imported element names and types.",flat_name:"threat.indicator.file.elf.imports",level:"extended",name:"imports",normalize:["array"],original_fieldset:"elf",short:"List of imported element names and types.",type:"flattened"},"threat.indicator.file.elf.imports_names_entropy":{dashed_name:"threat-indicator-file-elf-imports-names-entropy",description:"Shannon entropy calculation from the list of imported element names and types.",flat_name:"threat.indicator.file.elf.imports_names_entropy",format:"number",level:"extended",name:"imports_names_entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the list of imported element names and types.",type:"long"},"threat.indicator.file.elf.imports_names_var_entropy":{dashed_name:"threat-indicator-file-elf-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of imported element names and types.",flat_name:"threat.indicator.file.elf.imports_names_var_entropy",format:"number",level:"extended",name:"imports_names_var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the list of imported element names and types.",type:"long"},"threat.indicator.file.elf.sections":{dashed_name:"threat-indicator-file-elf-sections",description:"An array containing an object for each section of the ELF file.\nThe keys that should be present in these objects are defined by sub-fields underneath `elf.sections.*`.",flat_name:"threat.indicator.file.elf.sections",level:"extended",name:"sections",normalize:["array"],original_fieldset:"elf",short:"Section information of the ELF file.",type:"nested"},"threat.indicator.file.elf.sections.chi2":{dashed_name:"threat-indicator-file-elf-sections-chi2",description:"Chi-square probability distribution of the section.",flat_name:"threat.indicator.file.elf.sections.chi2",format:"number",level:"extended",name:"sections.chi2",normalize:[],original_fieldset:"elf",short:"Chi-square probability distribution of the section.",type:"long"},"threat.indicator.file.elf.sections.entropy":{dashed_name:"threat-indicator-file-elf-sections-entropy",description:"Shannon entropy calculation from the section.",flat_name:"threat.indicator.file.elf.sections.entropy",format:"number",level:"extended",name:"sections.entropy",normalize:[],original_fieldset:"elf",short:"Shannon entropy calculation from the section.",type:"long"},"threat.indicator.file.elf.sections.flags":{dashed_name:"threat-indicator-file-elf-sections-flags",description:"ELF Section List flags.",flat_name:"threat.indicator.file.elf.sections.flags",ignore_above:1024,level:"extended",name:"sections.flags",normalize:[],original_fieldset:"elf",short:"ELF Section List flags.",type:"keyword"},"threat.indicator.file.elf.sections.name":{dashed_name:"threat-indicator-file-elf-sections-name",description:"ELF Section List name.",flat_name:"threat.indicator.file.elf.sections.name",ignore_above:1024,level:"extended",name:"sections.name",normalize:[],original_fieldset:"elf",short:"ELF Section List name.",type:"keyword"},"threat.indicator.file.elf.sections.physical_offset":{dashed_name:"threat-indicator-file-elf-sections-physical-offset",description:"ELF Section List offset.",flat_name:"threat.indicator.file.elf.sections.physical_offset",ignore_above:1024,level:"extended",name:"sections.physical_offset",normalize:[],original_fieldset:"elf",short:"ELF Section List offset.",type:"keyword"},"threat.indicator.file.elf.sections.physical_size":{dashed_name:"threat-indicator-file-elf-sections-physical-size",description:"ELF Section List physical size.",flat_name:"threat.indicator.file.elf.sections.physical_size",format:"bytes",level:"extended",name:"sections.physical_size",normalize:[],original_fieldset:"elf",short:"ELF Section List physical size.",type:"long"},"threat.indicator.file.elf.sections.type":{dashed_name:"threat-indicator-file-elf-sections-type",description:"ELF Section List type.",flat_name:"threat.indicator.file.elf.sections.type",ignore_above:1024,level:"extended",name:"sections.type",normalize:[],original_fieldset:"elf",short:"ELF Section List type.",type:"keyword"},"threat.indicator.file.elf.sections.var_entropy":{dashed_name:"threat-indicator-file-elf-sections-var-entropy",description:"Variance for Shannon entropy calculation from the section.",flat_name:"threat.indicator.file.elf.sections.var_entropy",format:"number",level:"extended",name:"sections.var_entropy",normalize:[],original_fieldset:"elf",short:"Variance for Shannon entropy calculation from the section.",type:"long"},"threat.indicator.file.elf.sections.virtual_address":{dashed_name:"threat-indicator-file-elf-sections-virtual-address",description:"ELF Section List virtual address.",flat_name:"threat.indicator.file.elf.sections.virtual_address",format:"string",level:"extended",name:"sections.virtual_address",normalize:[],original_fieldset:"elf",short:"ELF Section List virtual address.",type:"long"},"threat.indicator.file.elf.sections.virtual_size":{dashed_name:"threat-indicator-file-elf-sections-virtual-size",description:"ELF Section List virtual size.",flat_name:"threat.indicator.file.elf.sections.virtual_size",format:"string",level:"extended",name:"sections.virtual_size",normalize:[],original_fieldset:"elf",short:"ELF Section List virtual size.",type:"long"},"threat.indicator.file.elf.segments":{dashed_name:"threat-indicator-file-elf-segments",description:"An array containing an object for each segment of the ELF file.\nThe keys that should be present in these objects are defined by sub-fields underneath `elf.segments.*`.",flat_name:"threat.indicator.file.elf.segments",level:"extended",name:"segments",normalize:["array"],original_fieldset:"elf",short:"ELF object segment list.",type:"nested"},"threat.indicator.file.elf.segments.sections":{dashed_name:"threat-indicator-file-elf-segments-sections",description:"ELF object segment sections.",flat_name:"threat.indicator.file.elf.segments.sections",ignore_above:1024,level:"extended",name:"segments.sections",normalize:[],original_fieldset:"elf",short:"ELF object segment sections.",type:"keyword"},"threat.indicator.file.elf.segments.type":{dashed_name:"threat-indicator-file-elf-segments-type",description:"ELF object segment type.",flat_name:"threat.indicator.file.elf.segments.type",ignore_above:1024,level:"extended",name:"segments.type",normalize:[],original_fieldset:"elf",short:"ELF object segment type.",type:"keyword"},"threat.indicator.file.elf.shared_libraries":{dashed_name:"threat-indicator-file-elf-shared-libraries",description:"List of shared libraries used by this ELF object.",flat_name:"threat.indicator.file.elf.shared_libraries",ignore_above:1024,level:"extended",name:"shared_libraries",normalize:["array"],original_fieldset:"elf",short:"List of shared libraries used by this ELF object.",type:"keyword"},"threat.indicator.file.elf.telfhash":{dashed_name:"threat-indicator-file-elf-telfhash",description:"telfhash symbol hash for ELF file.",flat_name:"threat.indicator.file.elf.telfhash",ignore_above:1024,level:"extended",name:"telfhash",normalize:[],original_fieldset:"elf",short:"telfhash hash for ELF file.",type:"keyword"},"threat.indicator.file.extension":{dashed_name:"threat-indicator-file-extension",description:'File extension, excluding the leading dot.\nNote that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").',example:"png",flat_name:"threat.indicator.file.extension",ignore_above:1024,level:"extended",name:"extension",normalize:[],original_fieldset:"file",short:"File extension, excluding the leading dot.",type:"keyword"},"threat.indicator.file.fork_name":{dashed_name:"threat-indicator-file-fork-name",description:"A fork is additional data associated with a filesystem object.\nOn Linux, a resource fork is used to store additional data with a filesystem object. A file always has at least one fork for the data portion, and additional forks may exist.\nOn NTFS, this is analogous to an Alternate Data Stream (ADS), and the default data stream for a file is just called $DATA. Zone.Identifier is commonly used by Windows to track contents downloaded from the Internet. An ADS is typically of the form: `C:\\path\\to\\filename.extension:some_fork_name`, and `some_fork_name` is the value that should populate `fork_name`. `filename.extension` should populate `file.name`, and `extension` should populate `file.extension`. The full path, `file.path`, will include the fork name.",example:"Zone.Identifer",flat_name:"threat.indicator.file.fork_name",ignore_above:1024,level:"extended",name:"fork_name",normalize:[],original_fieldset:"file",short:"A fork is additional data associated with a filesystem object.",type:"keyword"},"threat.indicator.file.gid":{dashed_name:"threat-indicator-file-gid",description:"Primary group ID (GID) of the file.",example:"1001",flat_name:"threat.indicator.file.gid",ignore_above:1024,level:"extended",name:"gid",normalize:[],original_fieldset:"file",short:"Primary group ID (GID) of the file.",type:"keyword"},"threat.indicator.file.group":{dashed_name:"threat-indicator-file-group",description:"Primary group name of the file.",example:"alice",flat_name:"threat.indicator.file.group",ignore_above:1024,level:"extended",name:"group",normalize:[],original_fieldset:"file",short:"Primary group name of the file.",type:"keyword"},"threat.indicator.file.hash.cdhash":{beta:"This field is beta and subject to change.",dashed_name:"threat-indicator-file-hash-cdhash",description:"Code directory hash, utilized to uniquely identify and authenticate the integrity of the executable code.",example:"3783b4052fd474dbe30676b45c329e7a6d44acd9",flat_name:"threat.indicator.file.hash.cdhash",ignore_above:1024,level:"extended",name:"cdhash",normalize:[],original_fieldset:"hash",short:"The Code Directory (CD) hash of an executable.",type:"keyword"},"threat.indicator.file.hash.md5":{dashed_name:"threat-indicator-file-hash-md5",description:"MD5 hash.",flat_name:"threat.indicator.file.hash.md5",ignore_above:1024,level:"extended",name:"md5",normalize:[],original_fieldset:"hash",short:"MD5 hash.",type:"keyword"},"threat.indicator.file.hash.sha1":{dashed_name:"threat-indicator-file-hash-sha1",description:"SHA1 hash.",flat_name:"threat.indicator.file.hash.sha1",ignore_above:1024,level:"extended",name:"sha1",normalize:[],original_fieldset:"hash",short:"SHA1 hash.",type:"keyword"},"threat.indicator.file.hash.sha256":{dashed_name:"threat-indicator-file-hash-sha256",description:"SHA256 hash.",flat_name:"threat.indicator.file.hash.sha256",ignore_above:1024,level:"extended",name:"sha256",normalize:[],original_fieldset:"hash",short:"SHA256 hash.",type:"keyword"},"threat.indicator.file.hash.sha384":{dashed_name:"threat-indicator-file-hash-sha384",description:"SHA384 hash.",flat_name:"threat.indicator.file.hash.sha384",ignore_above:1024,level:"extended",name:"sha384",normalize:[],original_fieldset:"hash",short:"SHA384 hash.",type:"keyword"},"threat.indicator.file.hash.sha512":{dashed_name:"threat-indicator-file-hash-sha512",description:"SHA512 hash.",flat_name:"threat.indicator.file.hash.sha512",ignore_above:1024,level:"extended",name:"sha512",normalize:[],original_fieldset:"hash",short:"SHA512 hash.",type:"keyword"},"threat.indicator.file.hash.ssdeep":{dashed_name:"threat-indicator-file-hash-ssdeep",description:"SSDEEP hash.",flat_name:"threat.indicator.file.hash.ssdeep",ignore_above:1024,level:"extended",name:"ssdeep",normalize:[],original_fieldset:"hash",short:"SSDEEP hash.",type:"keyword"},"threat.indicator.file.hash.tlsh":{dashed_name:"threat-indicator-file-hash-tlsh",description:"TLSH hash.",flat_name:"threat.indicator.file.hash.tlsh",ignore_above:1024,level:"extended",name:"tlsh",normalize:[],original_fieldset:"hash",short:"TLSH hash.",type:"keyword"},"threat.indicator.file.inode":{dashed_name:"threat-indicator-file-inode",description:"Inode representing the file in the filesystem.",example:"256383",flat_name:"threat.indicator.file.inode",ignore_above:1024,level:"extended",name:"inode",normalize:[],original_fieldset:"file",short:"Inode representing the file in the filesystem.",type:"keyword"},"threat.indicator.file.mime_type":{dashed_name:"threat-indicator-file-mime-type",description:"MIME type should identify the format of the file or stream of bytes using IANA official types: https://www.iana.org/assignments/media-types/media-types.xhtml, where possible. When more than one type is applicable, the most specific type should be used.",flat_name:"threat.indicator.file.mime_type",ignore_above:1024,level:"extended",name:"mime_type",normalize:[],original_fieldset:"file",short:"Media type of file, document, or arrangement of bytes.",type:"keyword"},"threat.indicator.file.mode":{dashed_name:"threat-indicator-file-mode",description:"Mode of the file in octal representation.",example:"0640",flat_name:"threat.indicator.file.mode",ignore_above:1024,level:"extended",name:"mode",normalize:[],original_fieldset:"file",short:"Mode of the file in octal representation.",type:"keyword"},"threat.indicator.file.mtime":{dashed_name:"threat-indicator-file-mtime",description:"Last time the file content was modified.",flat_name:"threat.indicator.file.mtime",level:"extended",name:"mtime",normalize:[],original_fieldset:"file",short:"Last time the file content was modified.",type:"date"},"threat.indicator.file.name":{dashed_name:"threat-indicator-file-name",description:"Name of the file including the extension, without the directory.",example:"example.png",flat_name:"threat.indicator.file.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"file",short:"Name of the file including the extension, without the directory.",type:"keyword"},"threat.indicator.file.origin_referrer_url":{beta:"This field is beta and subject to change.",dashed_name:"threat-indicator-file-origin-referrer-url",description:"The URL of the webpage that linked to the file.",example:"http://example.com/article1.html",flat_name:"threat.indicator.file.origin_referrer_url",ignore_above:8192,level:"extended",name:"origin_referrer_url",normalize:[],original_fieldset:"file",short:"The URL of the webpage that linked to the file.",type:"keyword"},"threat.indicator.file.origin_url":{beta:"This field is beta and subject to change.",dashed_name:"threat-indicator-file-origin-url",description:"The URL where the file is hosted.",example:"http://example.com/imgs/article1_img1.jpg",flat_name:"threat.indicator.file.origin_url",ignore_above:8192,level:"extended",name:"origin_url",normalize:[],original_fieldset:"file",short:"The URL where the file is hosted.",type:"keyword"},"threat.indicator.file.owner":{dashed_name:"threat-indicator-file-owner",description:"File owner's username.",example:"alice",flat_name:"threat.indicator.file.owner",ignore_above:1024,level:"extended",name:"owner",normalize:[],original_fieldset:"file",short:"File owner's username.",type:"keyword"},"threat.indicator.file.path":{dashed_name:"threat-indicator-file-path",description:"Full path to the file, including the file name. It should include the drive letter, when appropriate.",example:"/home/alice/example.png",flat_name:"threat.indicator.file.path",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"threat.indicator.file.path.text",name:"text",type:"match_only_text"}],name:"path",normalize:[],original_fieldset:"file",short:"Full path to the file, including the file name.",type:"keyword"},"threat.indicator.file.pe.architecture":{dashed_name:"threat-indicator-file-pe-architecture",description:"CPU architecture target for the file.",example:"x64",flat_name:"threat.indicator.file.pe.architecture",ignore_above:1024,level:"extended",name:"architecture",normalize:[],original_fieldset:"pe",short:"CPU architecture target for the file.",type:"keyword"},"threat.indicator.file.pe.company":{dashed_name:"threat-indicator-file-pe-company",description:"Internal company name of the file, provided at compile-time.",example:"Microsoft Corporation",flat_name:"threat.indicator.file.pe.company",ignore_above:1024,level:"extended",name:"company",normalize:[],original_fieldset:"pe",short:"Internal company name of the file, provided at compile-time.",type:"keyword"},"threat.indicator.file.pe.description":{dashed_name:"threat-indicator-file-pe-description",description:"Internal description of the file, provided at compile-time.",example:"Paint",flat_name:"threat.indicator.file.pe.description",ignore_above:1024,level:"extended",name:"description",normalize:[],original_fieldset:"pe",short:"Internal description of the file, provided at compile-time.",type:"keyword"},"threat.indicator.file.pe.file_version":{dashed_name:"threat-indicator-file-pe-file-version",description:"Internal version of the file, provided at compile-time.",example:"6.3.9600.17415",flat_name:"threat.indicator.file.pe.file_version",ignore_above:1024,level:"extended",name:"file_version",normalize:[],original_fieldset:"pe",short:"Process name.",type:"keyword"},"threat.indicator.file.pe.go_import_hash":{dashed_name:"threat-indicator-file-pe-go-import-hash",description:"A hash of the Go language imports in a PE file excluding standard library imports. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThe algorithm used to calculate the Go symbol hash and a reference implementation are available here: https://github.com/elastic/toutoumomoma",example:"10bddcb4cee42080f76c88d9ff964491",flat_name:"threat.indicator.file.pe.go_import_hash",ignore_above:1024,level:"extended",name:"go_import_hash",normalize:[],original_fieldset:"pe",short:"A hash of the Go language imports in a PE file.",type:"keyword"},"threat.indicator.file.pe.go_imports":{dashed_name:"threat-indicator-file-pe-go-imports",description:"List of imported Go language element names and types.",flat_name:"threat.indicator.file.pe.go_imports",level:"extended",name:"go_imports",normalize:[],original_fieldset:"pe",short:"List of imported Go language element names and types.",type:"flattened"},"threat.indicator.file.pe.go_imports_names_entropy":{dashed_name:"threat-indicator-file-pe-go-imports-names-entropy",description:"Shannon entropy calculation from the list of Go imports.",flat_name:"threat.indicator.file.pe.go_imports_names_entropy",format:"number",level:"extended",name:"go_imports_names_entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the list of Go imports.",type:"long"},"threat.indicator.file.pe.go_imports_names_var_entropy":{dashed_name:"threat-indicator-file-pe-go-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of Go imports.",flat_name:"threat.indicator.file.pe.go_imports_names_var_entropy",format:"number",level:"extended",name:"go_imports_names_var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the list of Go imports.",type:"long"},"threat.indicator.file.pe.go_stripped":{dashed_name:"threat-indicator-file-pe-go-stripped",description:"Set to true if the file is a Go executable that has had its symbols stripped or obfuscated and false if an unobfuscated Go executable.",flat_name:"threat.indicator.file.pe.go_stripped",level:"extended",name:"go_stripped",normalize:[],original_fieldset:"pe",short:"Whether the file is a stripped or obfuscated Go executable.",type:"boolean"},"threat.indicator.file.pe.imphash":{dashed_name:"threat-indicator-file-pe-imphash",description:"A hash of the imports in a PE file. An imphash -- or import hash -- can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nLearn more at https://www.fireeye.com/blog/threat-research/2014/01/tracking-malware-import-hashing.html.",example:"0c6803c4e922103c4dca5963aad36ddf",flat_name:"threat.indicator.file.pe.imphash",ignore_above:1024,level:"extended",name:"imphash",normalize:[],original_fieldset:"pe",short:"A hash of the imports in a PE file.",type:"keyword"},"threat.indicator.file.pe.import_hash":{dashed_name:"threat-indicator-file-pe-import-hash",description:"A hash of the imports in a PE file. An import hash can be used to fingerprint binaries even after recompilation or other code-level transformations have occurred, which would change more traditional hash values.\nThis is a synonym for imphash.",example:"d41d8cd98f00b204e9800998ecf8427e",flat_name:"threat.indicator.file.pe.import_hash",ignore_above:1024,level:"extended",name:"import_hash",normalize:[],original_fieldset:"pe",short:"A hash of the imports in a PE file.",type:"keyword"},"threat.indicator.file.pe.imports":{dashed_name:"threat-indicator-file-pe-imports",description:"List of imported element names and types.",flat_name:"threat.indicator.file.pe.imports",level:"extended",name:"imports",normalize:["array"],original_fieldset:"pe",short:"List of imported element names and types.",type:"flattened"},"threat.indicator.file.pe.imports_names_entropy":{dashed_name:"threat-indicator-file-pe-imports-names-entropy",description:"Shannon entropy calculation from the list of imported element names and types.",flat_name:"threat.indicator.file.pe.imports_names_entropy",format:"number",level:"extended",name:"imports_names_entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the list of imported element names and types.",type:"long"},"threat.indicator.file.pe.imports_names_var_entropy":{dashed_name:"threat-indicator-file-pe-imports-names-var-entropy",description:"Variance for Shannon entropy calculation from the list of imported element names and types.",flat_name:"threat.indicator.file.pe.imports_names_var_entropy",format:"number",level:"extended",name:"imports_names_var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the list of imported element names and types.",type:"long"},"threat.indicator.file.pe.original_file_name":{dashed_name:"threat-indicator-file-pe-original-file-name",description:"Internal name of the file, provided at compile-time.",example:"MSPAINT.EXE",flat_name:"threat.indicator.file.pe.original_file_name",ignore_above:1024,level:"extended",name:"original_file_name",normalize:[],original_fieldset:"pe",short:"Internal name of the file, provided at compile-time.",type:"keyword"},"threat.indicator.file.pe.pehash":{dashed_name:"threat-indicator-file-pe-pehash",description:"A hash of the PE header and data from one or more PE sections. An pehash can be used to cluster files by transforming structural information about a file into a hash value.\nLearn more at https://www.usenix.org/legacy/events/leet09/tech/full_papers/wicherski/wicherski_html/index.html.",example:"73ff189b63cd6be375a7ff25179a38d347651975",flat_name:"threat.indicator.file.pe.pehash",ignore_above:1024,level:"extended",name:"pehash",normalize:[],original_fieldset:"pe",short:"A hash of the PE header and data from one or more PE sections.",type:"keyword"},"threat.indicator.file.pe.product":{dashed_name:"threat-indicator-file-pe-product",description:"Internal product name of the file, provided at compile-time.",example:"Microsoft® Windows® Operating System",flat_name:"threat.indicator.file.pe.product",ignore_above:1024,level:"extended",name:"product",normalize:[],original_fieldset:"pe",short:"Internal product name of the file, provided at compile-time.",type:"keyword"},"threat.indicator.file.pe.sections":{dashed_name:"threat-indicator-file-pe-sections",description:"An array containing an object for each section of the PE file.\nThe keys that should be present in these objects are defined by sub-fields underneath `pe.sections.*`.",flat_name:"threat.indicator.file.pe.sections",level:"extended",name:"sections",normalize:["array"],original_fieldset:"pe",short:"Section information of the PE file.",type:"nested"},"threat.indicator.file.pe.sections.entropy":{dashed_name:"threat-indicator-file-pe-sections-entropy",description:"Shannon entropy calculation from the section.",flat_name:"threat.indicator.file.pe.sections.entropy",format:"number",level:"extended",name:"sections.entropy",normalize:[],original_fieldset:"pe",short:"Shannon entropy calculation from the section.",type:"long"},"threat.indicator.file.pe.sections.name":{dashed_name:"threat-indicator-file-pe-sections-name",description:"PE Section List name.",flat_name:"threat.indicator.file.pe.sections.name",ignore_above:1024,level:"extended",name:"sections.name",normalize:[],original_fieldset:"pe",short:"PE Section List name.",type:"keyword"},"threat.indicator.file.pe.sections.physical_size":{dashed_name:"threat-indicator-file-pe-sections-physical-size",description:"PE Section List physical size.",flat_name:"threat.indicator.file.pe.sections.physical_size",format:"bytes",level:"extended",name:"sections.physical_size",normalize:[],original_fieldset:"pe",short:"PE Section List physical size.",type:"long"},"threat.indicator.file.pe.sections.var_entropy":{dashed_name:"threat-indicator-file-pe-sections-var-entropy",description:"Variance for Shannon entropy calculation from the section.",flat_name:"threat.indicator.file.pe.sections.var_entropy",format:"number",level:"extended",name:"sections.var_entropy",normalize:[],original_fieldset:"pe",short:"Variance for Shannon entropy calculation from the section.",type:"long"},"threat.indicator.file.pe.sections.virtual_size":{dashed_name:"threat-indicator-file-pe-sections-virtual-size",description:"PE Section List virtual size. This is always the same as `physical_size`.",flat_name:"threat.indicator.file.pe.sections.virtual_size",format:"string",level:"extended",name:"sections.virtual_size",normalize:[],original_fieldset:"pe",short:"PE Section List virtual size. This is always the same as `physical_size`.",type:"long"},"threat.indicator.file.size":{dashed_name:"threat-indicator-file-size",description:'File size in bytes.\nOnly relevant when `file.type` is "file".',example:16384,flat_name:"threat.indicator.file.size",level:"extended",name:"size",normalize:[],original_fieldset:"file",short:"File size in bytes.",type:"long"},"threat.indicator.file.target_path":{dashed_name:"threat-indicator-file-target-path",description:"Target path for symlinks.",flat_name:"threat.indicator.file.target_path",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"threat.indicator.file.target_path.text",name:"text",type:"match_only_text"}],name:"target_path",normalize:[],original_fieldset:"file",short:"Target path for symlinks.",type:"keyword"},"threat.indicator.file.type":{dashed_name:"threat-indicator-file-type",description:"File type (file, dir, or symlink).",example:"file",flat_name:"threat.indicator.file.type",ignore_above:1024,level:"extended",name:"type",normalize:[],original_fieldset:"file",short:"File type (file, dir, or symlink).",type:"keyword"},"threat.indicator.file.uid":{dashed_name:"threat-indicator-file-uid",description:"The user ID (UID) or security identifier (SID) of the file owner.",example:"1001",flat_name:"threat.indicator.file.uid",ignore_above:1024,level:"extended",name:"uid",normalize:[],original_fieldset:"file",short:"The user ID (UID) or security identifier (SID) of the file owner.",type:"keyword"},"threat.indicator.file.x509.alternative_names":{dashed_name:"threat-indicator-file-x509-alternative-names",description:"List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.",example:"*.elastic.co",flat_name:"threat.indicator.file.x509.alternative_names",ignore_above:1024,level:"extended",name:"alternative_names",normalize:["array"],original_fieldset:"x509",short:"List of subject alternative names (SAN).",type:"keyword"},"threat.indicator.file.x509.issuer.common_name":{dashed_name:"threat-indicator-file-x509-issuer-common-name",description:"List of common name (CN) of issuing certificate authority.",example:"Example SHA2 High Assurance Server CA",flat_name:"threat.indicator.file.x509.issuer.common_name",ignore_above:1024,level:"extended",name:"issuer.common_name",normalize:["array"],original_fieldset:"x509",short:"List of common name (CN) of issuing certificate authority.",type:"keyword"},"threat.indicator.file.x509.issuer.country":{dashed_name:"threat-indicator-file-x509-issuer-country",description:"List of country \\(C) codes",example:"US",flat_name:"threat.indicator.file.x509.issuer.country",ignore_above:1024,level:"extended",name:"issuer.country",normalize:["array"],original_fieldset:"x509",short:"List of country \\(C) codes",type:"keyword"},"threat.indicator.file.x509.issuer.distinguished_name":{dashed_name:"threat-indicator-file-x509-issuer-distinguished-name",description:"Distinguished name (DN) of issuing certificate authority.",example:"C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA",flat_name:"threat.indicator.file.x509.issuer.distinguished_name",ignore_above:1024,level:"extended",name:"issuer.distinguished_name",normalize:[],original_fieldset:"x509",short:"Distinguished name (DN) of issuing certificate authority.",type:"keyword"},"threat.indicator.file.x509.issuer.locality":{dashed_name:"threat-indicator-file-x509-issuer-locality",description:"List of locality names (L)",example:"Mountain View",flat_name:"threat.indicator.file.x509.issuer.locality",ignore_above:1024,level:"extended",name:"issuer.locality",normalize:["array"],original_fieldset:"x509",short:"List of locality names (L)",type:"keyword"},"threat.indicator.file.x509.issuer.organization":{dashed_name:"threat-indicator-file-x509-issuer-organization",description:"List of organizations (O) of issuing certificate authority.",example:"Example Inc",flat_name:"threat.indicator.file.x509.issuer.organization",ignore_above:1024,level:"extended",name:"issuer.organization",normalize:["array"],original_fieldset:"x509",short:"List of organizations (O) of issuing certificate authority.",type:"keyword"},"threat.indicator.file.x509.issuer.organizational_unit":{dashed_name:"threat-indicator-file-x509-issuer-organizational-unit",description:"List of organizational units (OU) of issuing certificate authority.",example:"www.example.com",flat_name:"threat.indicator.file.x509.issuer.organizational_unit",ignore_above:1024,level:"extended",name:"issuer.organizational_unit",normalize:["array"],original_fieldset:"x509",short:"List of organizational units (OU) of issuing certificate authority.",type:"keyword"},"threat.indicator.file.x509.issuer.state_or_province":{dashed_name:"threat-indicator-file-x509-issuer-state-or-province",description:"List of state or province names (ST, S, or P)",example:"California",flat_name:"threat.indicator.file.x509.issuer.state_or_province",ignore_above:1024,level:"extended",name:"issuer.state_or_province",normalize:["array"],original_fieldset:"x509",short:"List of state or province names (ST, S, or P)",type:"keyword"},"threat.indicator.file.x509.not_after":{dashed_name:"threat-indicator-file-x509-not-after",description:"Time at which the certificate is no longer considered valid.",example:"2020-07-16T03:15:39Z",flat_name:"threat.indicator.file.x509.not_after",level:"extended",name:"not_after",normalize:[],original_fieldset:"x509",short:"Time at which the certificate is no longer considered valid.",type:"date"},"threat.indicator.file.x509.not_before":{dashed_name:"threat-indicator-file-x509-not-before",description:"Time at which the certificate is first considered valid.",example:"2019-08-16T01:40:25Z",flat_name:"threat.indicator.file.x509.not_before",level:"extended",name:"not_before",normalize:[],original_fieldset:"x509",short:"Time at which the certificate is first considered valid.",type:"date"},"threat.indicator.file.x509.public_key_algorithm":{dashed_name:"threat-indicator-file-x509-public-key-algorithm",description:"Algorithm used to generate the public key.",example:"RSA",flat_name:"threat.indicator.file.x509.public_key_algorithm",ignore_above:1024,level:"extended",name:"public_key_algorithm",normalize:[],original_fieldset:"x509",short:"Algorithm used to generate the public key.",type:"keyword"},"threat.indicator.file.x509.public_key_curve":{dashed_name:"threat-indicator-file-x509-public-key-curve",description:"The curve used by the elliptic curve public key algorithm. This is algorithm specific.",example:"nistp521",flat_name:"threat.indicator.file.x509.public_key_curve",ignore_above:1024,level:"extended",name:"public_key_curve",normalize:[],original_fieldset:"x509",short:"The curve used by the elliptic curve public key algorithm. This is algorithm specific.",type:"keyword"},"threat.indicator.file.x509.public_key_exponent":{dashed_name:"threat-indicator-file-x509-public-key-exponent",description:"Exponent used to derive the public key. This is algorithm specific.",doc_values:!1,example:65537,flat_name:"threat.indicator.file.x509.public_key_exponent",index:!1,level:"extended",name:"public_key_exponent",normalize:[],original_fieldset:"x509",short:"Exponent used to derive the public key. This is algorithm specific.",type:"long"},"threat.indicator.file.x509.public_key_size":{dashed_name:"threat-indicator-file-x509-public-key-size",description:"The size of the public key space in bits.",example:2048,flat_name:"threat.indicator.file.x509.public_key_size",level:"extended",name:"public_key_size",normalize:[],original_fieldset:"x509",short:"The size of the public key space in bits.",type:"long"},"threat.indicator.file.x509.serial_number":{dashed_name:"threat-indicator-file-x509-serial-number",description:"Unique serial number issued by the certificate authority. For consistency, this must be encoded in base 16 and formatted without colons and uppercase characters.",example:"55FBB9C7DEBF09809D12CCAA",flat_name:"threat.indicator.file.x509.serial_number",ignore_above:1024,level:"extended",name:"serial_number",normalize:[],original_fieldset:"x509",short:"Unique serial number issued by the certificate authority.",type:"keyword"},"threat.indicator.file.x509.signature_algorithm":{dashed_name:"threat-indicator-file-x509-signature-algorithm",description:"Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353.",example:"SHA256-RSA",flat_name:"threat.indicator.file.x509.signature_algorithm",ignore_above:1024,level:"extended",name:"signature_algorithm",normalize:[],original_fieldset:"x509",short:"Identifier for certificate signature algorithm.",type:"keyword"},"threat.indicator.file.x509.subject.common_name":{dashed_name:"threat-indicator-file-x509-subject-common-name",description:"List of common names (CN) of subject.",example:"shared.global.example.net",flat_name:"threat.indicator.file.x509.subject.common_name",ignore_above:1024,level:"extended",name:"subject.common_name",normalize:["array"],original_fieldset:"x509",short:"List of common names (CN) of subject.",type:"keyword"},"threat.indicator.file.x509.subject.country":{dashed_name:"threat-indicator-file-x509-subject-country",description:"List of country \\(C) code",example:"US",flat_name:"threat.indicator.file.x509.subject.country",ignore_above:1024,level:"extended",name:"subject.country",normalize:["array"],original_fieldset:"x509",short:"List of country \\(C) code",type:"keyword"},"threat.indicator.file.x509.subject.distinguished_name":{dashed_name:"threat-indicator-file-x509-subject-distinguished-name",description:"Distinguished name (DN) of the certificate subject entity.",example:"C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net",flat_name:"threat.indicator.file.x509.subject.distinguished_name",ignore_above:1024,level:"extended",name:"subject.distinguished_name",normalize:[],original_fieldset:"x509",short:"Distinguished name (DN) of the certificate subject entity.",type:"keyword"},"threat.indicator.file.x509.subject.locality":{dashed_name:"threat-indicator-file-x509-subject-locality",description:"List of locality names (L)",example:"San Francisco",flat_name:"threat.indicator.file.x509.subject.locality",ignore_above:1024,level:"extended",name:"subject.locality",normalize:["array"],original_fieldset:"x509",short:"List of locality names (L)",type:"keyword"},"threat.indicator.file.x509.subject.organization":{dashed_name:"threat-indicator-file-x509-subject-organization",description:"List of organizations (O) of subject.",example:"Example, Inc.",flat_name:"threat.indicator.file.x509.subject.organization",ignore_above:1024,level:"extended",name:"subject.organization",normalize:["array"],original_fieldset:"x509",short:"List of organizations (O) of subject.",type:"keyword"},"threat.indicator.file.x509.subject.organizational_unit":{dashed_name:"threat-indicator-file-x509-subject-organizational-unit",description:"List of organizational units (OU) of subject.",flat_name:"threat.indicator.file.x509.subject.organizational_unit",ignore_above:1024,level:"extended",name:"subject.organizational_unit",normalize:["array"],original_fieldset:"x509",short:"List of organizational units (OU) of subject.",type:"keyword"},"threat.indicator.file.x509.subject.state_or_province":{dashed_name:"threat-indicator-file-x509-subject-state-or-province",description:"List of state or province names (ST, S, or P)",example:"California",flat_name:"threat.indicator.file.x509.subject.state_or_province",ignore_above:1024,level:"extended",name:"subject.state_or_province",normalize:["array"],original_fieldset:"x509",short:"List of state or province names (ST, S, or P)",type:"keyword"},"threat.indicator.file.x509.version_number":{dashed_name:"threat-indicator-file-x509-version-number",description:"Version of x509 format.",example:3,flat_name:"threat.indicator.file.x509.version_number",ignore_above:1024,level:"extended",name:"version_number",normalize:[],original_fieldset:"x509",short:"Version of x509 format.",type:"keyword"},"threat.indicator.first_seen":{dashed_name:"threat-indicator-first-seen",description:"The date and time when intelligence source first reported sighting this indicator.",example:"2020-11-05T17:25:47.000Z",flat_name:"threat.indicator.first_seen",level:"extended",name:"indicator.first_seen",normalize:[],short:"Date/time indicator was first reported.",type:"date"},"threat.indicator.geo.city_name":{dashed_name:"threat-indicator-geo-city-name",description:"City name.",example:"Montreal",flat_name:"threat.indicator.geo.city_name",ignore_above:1024,level:"core",name:"city_name",normalize:[],original_fieldset:"geo",short:"City name.",type:"keyword"},"threat.indicator.geo.continent_code":{dashed_name:"threat-indicator-geo-continent-code",description:"Two-letter code representing continent's name.",example:"NA",flat_name:"threat.indicator.geo.continent_code",ignore_above:1024,level:"core",name:"continent_code",normalize:[],original_fieldset:"geo",short:"Continent code.",type:"keyword"},"threat.indicator.geo.continent_name":{dashed_name:"threat-indicator-geo-continent-name",description:"Name of the continent.",example:"North America",flat_name:"threat.indicator.geo.continent_name",ignore_above:1024,level:"core",name:"continent_name",normalize:[],original_fieldset:"geo",short:"Name of the continent.",type:"keyword"},"threat.indicator.geo.country_iso_code":{dashed_name:"threat-indicator-geo-country-iso-code",description:"Country ISO code.",example:"CA",flat_name:"threat.indicator.geo.country_iso_code",ignore_above:1024,level:"core",name:"country_iso_code",normalize:[],original_fieldset:"geo",short:"Country ISO code.",type:"keyword"},"threat.indicator.geo.country_name":{dashed_name:"threat-indicator-geo-country-name",description:"Country name.",example:"Canada",flat_name:"threat.indicator.geo.country_name",ignore_above:1024,level:"core",name:"country_name",normalize:[],original_fieldset:"geo",short:"Country name.",type:"keyword"},"threat.indicator.geo.location":{dashed_name:"threat-indicator-geo-location",description:"Longitude and latitude.",example:'{ "lon": -73.614830, "lat": 45.505918 }',flat_name:"threat.indicator.geo.location",level:"core",name:"location",normalize:[],original_fieldset:"geo",short:"Longitude and latitude.",type:"geo_point"},"threat.indicator.geo.name":{dashed_name:"threat-indicator-geo-name",description:"User-defined description of a location, at the level of granularity they care about.\nCould be the name of their data centers, the floor number, if this describes a local physical entity, city names.\nNot typically used in automated geolocation.",example:"boston-dc",flat_name:"threat.indicator.geo.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"geo",short:"User-defined description of a location.",type:"keyword"},"threat.indicator.geo.postal_code":{dashed_name:"threat-indicator-geo-postal-code",description:"Postal code associated with the location.\nValues appropriate for this field may also be known as a postcode or ZIP code and will vary widely from country to country.",example:94040,flat_name:"threat.indicator.geo.postal_code",ignore_above:1024,level:"core",name:"postal_code",normalize:[],original_fieldset:"geo",short:"Postal code.",type:"keyword"},"threat.indicator.geo.region_iso_code":{dashed_name:"threat-indicator-geo-region-iso-code",description:"Region ISO code.",example:"CA-QC",flat_name:"threat.indicator.geo.region_iso_code",ignore_above:1024,level:"core",name:"region_iso_code",normalize:[],original_fieldset:"geo",short:"Region ISO code.",type:"keyword"},"threat.indicator.geo.region_name":{dashed_name:"threat-indicator-geo-region-name",description:"Region name.",example:"Quebec",flat_name:"threat.indicator.geo.region_name",ignore_above:1024,level:"core",name:"region_name",normalize:[],original_fieldset:"geo",short:"Region name.",type:"keyword"},"threat.indicator.geo.timezone":{dashed_name:"threat-indicator-geo-timezone",description:"The time zone of the location, such as IANA time zone name.",example:"America/Argentina/Buenos_Aires",flat_name:"threat.indicator.geo.timezone",ignore_above:1024,level:"core",name:"timezone",normalize:[],original_fieldset:"geo",short:"Time zone.",type:"keyword"},"threat.indicator.id":{dashed_name:"threat-indicator-id",description:"The ID of the indicator used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®. This field can have multiple values to allow for the identification of the same indicator across systems that use different ID formats.\nWhile not required, a common approach is to use a STIX 2.x indicator ID.",example:"[indicator--d7008e06-ab86-415a-9803-3c81ce2d3c37]",flat_name:"threat.indicator.id",ignore_above:1024,level:"extended",name:"indicator.id",normalize:["array"],short:"ID of the indicator",synthetic_source_keep:"none",type:"keyword"},"threat.indicator.ip":{dashed_name:"threat-indicator-ip",description:"Identifies a threat indicator as an IP address (irrespective of direction).",example:"1.2.3.4",flat_name:"threat.indicator.ip",level:"extended",name:"indicator.ip",normalize:[],short:"Indicator IP address",type:"ip"},"threat.indicator.last_seen":{dashed_name:"threat-indicator-last-seen",description:"The date and time when intelligence source last reported sighting this indicator.",example:"2020-11-05T17:25:47.000Z",flat_name:"threat.indicator.last_seen",level:"extended",name:"indicator.last_seen",normalize:[],short:"Date/time indicator was last reported.",type:"date"},"threat.indicator.marking.tlp":{dashed_name:"threat-indicator-marking-tlp",description:"Traffic Light Protocol sharing markings.",example:"CLEAR",expected_values:["WHITE","CLEAR","GREEN","AMBER","AMBER+STRICT","RED"],flat_name:"threat.indicator.marking.tlp",ignore_above:1024,level:"extended",name:"indicator.marking.tlp",normalize:[],short:"Indicator TLP marking",type:"keyword"},"threat.indicator.marking.tlp_version":{dashed_name:"threat-indicator-marking-tlp-version",description:"Traffic Light Protocol version.",example:2,flat_name:"threat.indicator.marking.tlp_version",ignore_above:1024,level:"extended",name:"indicator.marking.tlp_version",normalize:[],short:"Indicator TLP version",type:"keyword"},"threat.indicator.modified_at":{dashed_name:"threat-indicator-modified-at",description:"The date and time when intelligence source last modified information for this indicator.",example:"2020-11-05T17:25:47.000Z",flat_name:"threat.indicator.modified_at",level:"extended",name:"indicator.modified_at",normalize:[],short:"Date/time indicator was last updated.",type:"date"},"threat.indicator.name":{dashed_name:"threat-indicator-name",description:"The display name indicator in an UI friendly format\nURL, IP address, email address, registry key, port number, hash value, or other relevant name can serve as the display name.",example:"5.2.75.227",flat_name:"threat.indicator.name",ignore_above:1024,level:"extended",name:"indicator.name",normalize:[],short:"Indicator display name",type:"keyword"},"threat.indicator.port":{dashed_name:"threat-indicator-port",description:"Identifies a threat indicator as a port number (irrespective of direction).",example:443,flat_name:"threat.indicator.port",level:"extended",name:"indicator.port",normalize:[],short:"Indicator port",type:"long"},"threat.indicator.provider":{dashed_name:"threat-indicator-provider",description:"The name of the indicator's provider.",example:"lrz_urlhaus",flat_name:"threat.indicator.provider",ignore_above:1024,level:"extended",name:"indicator.provider",normalize:[],short:"Indicator provider",type:"keyword"},"threat.indicator.reference":{dashed_name:"threat-indicator-reference",description:"Reference URL linking to additional information about this indicator.",example:"https://system.example.com/indicator/0001234",flat_name:"threat.indicator.reference",ignore_above:1024,level:"extended",name:"indicator.reference",normalize:[],short:"Indicator reference URL",type:"keyword"},"threat.indicator.registry.data.bytes":{dashed_name:"threat-indicator-registry-data-bytes",description:"Original bytes written with base64 encoding.\nFor Windows registry operations, such as SetValueEx and RegQueryValueEx, this corresponds to the data pointed by `lp_data`. This is optional but provides better recoverability and should be populated for REG_BINARY encoded values.",example:"ZQBuAC0AVQBTAAAAZQBuAAAAAAA=",flat_name:"threat.indicator.registry.data.bytes",ignore_above:1024,level:"extended",name:"data.bytes",normalize:[],original_fieldset:"registry",short:"Original bytes written with base64 encoding.",type:"keyword"},"threat.indicator.registry.data.strings":{dashed_name:"threat-indicator-registry-data-strings",description:'Content when writing string types.\nPopulated as an array when writing string data to the registry. For single string registry types (REG_SZ, REG_EXPAND_SZ), this should be an array with one string. For sequences of string with REG_MULTI_SZ, this array will be variable length. For numeric data, such as REG_DWORD and REG_QWORD, this should be populated with the decimal representation (e.g `"1"`).',example:'["C:\\rta\\red_ttp\\bin\\myapp.exe"]',flat_name:"threat.indicator.registry.data.strings",level:"core",name:"data.strings",normalize:["array"],original_fieldset:"registry",short:"List of strings representing what was written to the registry.",type:"wildcard"},"threat.indicator.registry.data.type":{dashed_name:"threat-indicator-registry-data-type",description:"Standard registry type for encoding contents",example:"REG_SZ",flat_name:"threat.indicator.registry.data.type",ignore_above:1024,level:"core",name:"data.type",normalize:[],original_fieldset:"registry",short:"Standard registry type for encoding contents",type:"keyword"},"threat.indicator.registry.hive":{dashed_name:"threat-indicator-registry-hive",description:"Abbreviated name for the hive.",example:"HKLM",flat_name:"threat.indicator.registry.hive",ignore_above:1024,level:"core",name:"hive",normalize:[],original_fieldset:"registry",short:"Abbreviated name for the hive.",type:"keyword"},"threat.indicator.registry.key":{dashed_name:"threat-indicator-registry-key",description:"Hive-relative path of keys.",example:"SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Image File Execution Options\\winword.exe",flat_name:"threat.indicator.registry.key",ignore_above:1024,level:"core",name:"key",normalize:[],original_fieldset:"registry",short:"Hive-relative path of keys.",type:"keyword"},"threat.indicator.registry.path":{dashed_name:"threat-indicator-registry-path",description:"Full path, including hive, key and value",example:"HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion\\Image File Execution Options\\winword.exe\\Debugger",flat_name:"threat.indicator.registry.path",ignore_above:1024,level:"core",name:"path",normalize:[],original_fieldset:"registry",short:"Full path, including hive, key and value",type:"keyword"},"threat.indicator.registry.value":{dashed_name:"threat-indicator-registry-value",description:"Name of the value written.",example:"Debugger",flat_name:"threat.indicator.registry.value",ignore_above:1024,level:"core",name:"value",normalize:[],original_fieldset:"registry",short:"Name of the value written.",type:"keyword"},"threat.indicator.scanner_stats":{dashed_name:"threat-indicator-scanner-stats",description:"Count of AV/EDR vendors that successfully detected malicious file or URL.",example:4,flat_name:"threat.indicator.scanner_stats",level:"extended",name:"indicator.scanner_stats",normalize:[],short:"Scanner statistics",type:"long"},"threat.indicator.sightings":{dashed_name:"threat-indicator-sightings",description:"Number of times this indicator was observed conducting threat activity.",example:20,flat_name:"threat.indicator.sightings",level:"extended",name:"indicator.sightings",normalize:[],short:"Number of times indicator observed",type:"long"},"threat.indicator.type":{dashed_name:"threat-indicator-type",description:"Type of indicator as represented by Cyber Observable in STIX 2.0.",example:"ipv4-addr",expected_values:["autonomous-system","artifact","directory","domain-name","email-addr","file","ipv4-addr","ipv6-addr","mac-addr","mutex","port","process","software","url","user-account","windows-registry-key","x509-certificate"],flat_name:"threat.indicator.type",ignore_above:1024,level:"extended",name:"indicator.type",normalize:[],short:"Type of indicator",type:"keyword"},"threat.indicator.url.domain":{dashed_name:"threat-indicator-url-domain",description:'Domain of the url, such as "www.elastic.co".\nIn some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field.\nIf the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field.',example:"www.elastic.co",flat_name:"threat.indicator.url.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"url",short:"Domain of the url.",type:"keyword"},"threat.indicator.url.extension":{dashed_name:"threat-indicator-url-extension",description:'The field contains the file extension from the original request url, excluding the leading dot.\nThe file extension is only set if it exists, as not every url has a file extension.\nThe leading period must not be included. For example, the value must be "png", not ".png".\nNote that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").',example:"png",flat_name:"threat.indicator.url.extension",ignore_above:1024,level:"extended",name:"extension",normalize:[],original_fieldset:"url",short:"File extension from the request url, excluding the leading dot.",type:"keyword"},"threat.indicator.url.fragment":{dashed_name:"threat-indicator-url-fragment",description:'Portion of the url after the `#`, such as "top".\nThe `#` is not part of the fragment.',flat_name:"threat.indicator.url.fragment",ignore_above:1024,level:"extended",name:"fragment",normalize:[],original_fieldset:"url",short:"Portion of the url after the `#`.",type:"keyword"},"threat.indicator.url.full":{dashed_name:"threat-indicator-url-full",description:"If full URLs are important to your use case, they should be stored in `url.full`, whether this field is reconstructed or present in the event source.",example:"https://www.elastic.co:443/search?q=elasticsearch#top",flat_name:"threat.indicator.url.full",level:"extended",multi_fields:[{flat_name:"threat.indicator.url.full.text",name:"text",type:"match_only_text"}],name:"full",normalize:[],original_fieldset:"url",short:"Full unparsed URL.",type:"wildcard"},"threat.indicator.url.original":{dashed_name:"threat-indicator-url-original",description:"Unmodified original url as seen in the event source.\nNote that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path.\nThis field is meant to represent the URL as it was observed, complete or not.",example:"https://www.elastic.co:443/search?q=elasticsearch#top or /search?q=elasticsearch",flat_name:"threat.indicator.url.original",level:"extended",multi_fields:[{flat_name:"threat.indicator.url.original.text",name:"text",type:"match_only_text"}],name:"original",normalize:[],original_fieldset:"url",short:"Unmodified original url as seen in the event source.",type:"wildcard"},"threat.indicator.url.password":{dashed_name:"threat-indicator-url-password",description:"Password of the request.",flat_name:"threat.indicator.url.password",ignore_above:1024,level:"extended",name:"password",normalize:[],original_fieldset:"url",short:"Password of the request.",type:"keyword"},"threat.indicator.url.path":{dashed_name:"threat-indicator-url-path",description:'Path of the request, such as "/search".',flat_name:"threat.indicator.url.path",level:"extended",name:"path",normalize:[],original_fieldset:"url",short:'Path of the request, such as "/search".',type:"wildcard"},"threat.indicator.url.port":{dashed_name:"threat-indicator-url-port",description:"Port of the request, such as 443.",example:443,flat_name:"threat.indicator.url.port",format:"string",level:"extended",name:"port",normalize:[],original_fieldset:"url",short:"Port of the request, such as 443.",type:"long"},"threat.indicator.url.query":{dashed_name:"threat-indicator-url-query",description:'The query field describes the query string of the request, such as "q=elasticsearch".\nThe `?` is excluded from the query string. If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases.',flat_name:"threat.indicator.url.query",ignore_above:2083,level:"extended",name:"query",normalize:[],original_fieldset:"url",short:"Query string of the request.",type:"keyword"},"threat.indicator.url.registered_domain":{dashed_name:"threat-indicator-url-registered-domain",description:'The highest registered url domain, stripped of the subdomain.\nFor example, the registered domain for "foo.example.com" is "example.com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".',example:"example.com",flat_name:"threat.indicator.url.registered_domain",ignore_above:1024,level:"extended",name:"registered_domain",normalize:[],original_fieldset:"url",short:"The highest registered url domain, stripped of the subdomain.",type:"keyword"},"threat.indicator.url.scheme":{dashed_name:"threat-indicator-url-scheme",description:'Scheme of the request, such as "https".\nNote: The `:` is not part of the scheme.',example:"https",flat_name:"threat.indicator.url.scheme",ignore_above:1024,level:"extended",name:"scheme",normalize:[],original_fieldset:"url",short:"Scheme of the url.",type:"keyword"},"threat.indicator.url.subdomain":{dashed_name:"threat-indicator-url-subdomain",description:'The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain.\nFor example the subdomain portion of "www.east.mydomain.co.uk" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.',example:"east",flat_name:"threat.indicator.url.subdomain",ignore_above:1024,level:"extended",name:"subdomain",normalize:[],original_fieldset:"url",short:"The subdomain of the domain.",type:"keyword"},"threat.indicator.url.top_level_domain":{dashed_name:"threat-indicator-url-top-level-domain",description:'The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".',example:"co.uk",flat_name:"threat.indicator.url.top_level_domain",ignore_above:1024,level:"extended",name:"top_level_domain",normalize:[],original_fieldset:"url",short:"The effective top level domain (com, org, net, co.uk).",type:"keyword"},"threat.indicator.url.username":{dashed_name:"threat-indicator-url-username",description:"Username of the request.",flat_name:"threat.indicator.url.username",ignore_above:1024,level:"extended",name:"username",normalize:[],original_fieldset:"url",short:"Username of the request.",type:"keyword"},"threat.indicator.x509.alternative_names":{dashed_name:"threat-indicator-x509-alternative-names",description:"List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.",example:"*.elastic.co",flat_name:"threat.indicator.x509.alternative_names",ignore_above:1024,level:"extended",name:"alternative_names",normalize:["array"],original_fieldset:"x509",short:"List of subject alternative names (SAN).",type:"keyword"},"threat.indicator.x509.issuer.common_name":{dashed_name:"threat-indicator-x509-issuer-common-name",description:"List of common name (CN) of issuing certificate authority.",example:"Example SHA2 High Assurance Server CA",flat_name:"threat.indicator.x509.issuer.common_name",ignore_above:1024,level:"extended",name:"issuer.common_name",normalize:["array"],original_fieldset:"x509",short:"List of common name (CN) of issuing certificate authority.",type:"keyword"},"threat.indicator.x509.issuer.country":{dashed_name:"threat-indicator-x509-issuer-country",description:"List of country \\(C) codes",example:"US",flat_name:"threat.indicator.x509.issuer.country",ignore_above:1024,level:"extended",name:"issuer.country",normalize:["array"],original_fieldset:"x509",short:"List of country \\(C) codes",type:"keyword"},"threat.indicator.x509.issuer.distinguished_name":{dashed_name:"threat-indicator-x509-issuer-distinguished-name",description:"Distinguished name (DN) of issuing certificate authority.",example:"C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA",flat_name:"threat.indicator.x509.issuer.distinguished_name",ignore_above:1024,level:"extended",name:"issuer.distinguished_name",normalize:[],original_fieldset:"x509",short:"Distinguished name (DN) of issuing certificate authority.",type:"keyword"},"threat.indicator.x509.issuer.locality":{dashed_name:"threat-indicator-x509-issuer-locality",description:"List of locality names (L)",example:"Mountain View",flat_name:"threat.indicator.x509.issuer.locality",ignore_above:1024,level:"extended",name:"issuer.locality",normalize:["array"],original_fieldset:"x509",short:"List of locality names (L)",type:"keyword"},"threat.indicator.x509.issuer.organization":{dashed_name:"threat-indicator-x509-issuer-organization",description:"List of organizations (O) of issuing certificate authority.",example:"Example Inc",flat_name:"threat.indicator.x509.issuer.organization",ignore_above:1024,level:"extended",name:"issuer.organization",normalize:["array"],original_fieldset:"x509",short:"List of organizations (O) of issuing certificate authority.",type:"keyword"},"threat.indicator.x509.issuer.organizational_unit":{dashed_name:"threat-indicator-x509-issuer-organizational-unit",description:"List of organizational units (OU) of issuing certificate authority.",example:"www.example.com",flat_name:"threat.indicator.x509.issuer.organizational_unit",ignore_above:1024,level:"extended",name:"issuer.organizational_unit",normalize:["array"],original_fieldset:"x509",short:"List of organizational units (OU) of issuing certificate authority.",type:"keyword"},"threat.indicator.x509.issuer.state_or_province":{dashed_name:"threat-indicator-x509-issuer-state-or-province",description:"List of state or province names (ST, S, or P)",example:"California",flat_name:"threat.indicator.x509.issuer.state_or_province",ignore_above:1024,level:"extended",name:"issuer.state_or_province",normalize:["array"],original_fieldset:"x509",short:"List of state or province names (ST, S, or P)",type:"keyword"},"threat.indicator.x509.not_after":{dashed_name:"threat-indicator-x509-not-after",description:"Time at which the certificate is no longer considered valid.",example:"2020-07-16T03:15:39Z",flat_name:"threat.indicator.x509.not_after",level:"extended",name:"not_after",normalize:[],original_fieldset:"x509",short:"Time at which the certificate is no longer considered valid.",type:"date"},"threat.indicator.x509.not_before":{dashed_name:"threat-indicator-x509-not-before",description:"Time at which the certificate is first considered valid.",example:"2019-08-16T01:40:25Z",flat_name:"threat.indicator.x509.not_before",level:"extended",name:"not_before",normalize:[],original_fieldset:"x509",short:"Time at which the certificate is first considered valid.",type:"date"},"threat.indicator.x509.public_key_algorithm":{dashed_name:"threat-indicator-x509-public-key-algorithm",description:"Algorithm used to generate the public key.",example:"RSA",flat_name:"threat.indicator.x509.public_key_algorithm",ignore_above:1024,level:"extended",name:"public_key_algorithm",normalize:[],original_fieldset:"x509",short:"Algorithm used to generate the public key.",type:"keyword"},"threat.indicator.x509.public_key_curve":{dashed_name:"threat-indicator-x509-public-key-curve",description:"The curve used by the elliptic curve public key algorithm. This is algorithm specific.",example:"nistp521",flat_name:"threat.indicator.x509.public_key_curve",ignore_above:1024,level:"extended",name:"public_key_curve",normalize:[],original_fieldset:"x509",short:"The curve used by the elliptic curve public key algorithm. This is algorithm specific.",type:"keyword"},"threat.indicator.x509.public_key_exponent":{dashed_name:"threat-indicator-x509-public-key-exponent",description:"Exponent used to derive the public key. This is algorithm specific.",doc_values:!1,example:65537,flat_name:"threat.indicator.x509.public_key_exponent",index:!1,level:"extended",name:"public_key_exponent",normalize:[],original_fieldset:"x509",short:"Exponent used to derive the public key. This is algorithm specific.",type:"long"},"threat.indicator.x509.public_key_size":{dashed_name:"threat-indicator-x509-public-key-size",description:"The size of the public key space in bits.",example:2048,flat_name:"threat.indicator.x509.public_key_size",level:"extended",name:"public_key_size",normalize:[],original_fieldset:"x509",short:"The size of the public key space in bits.",type:"long"},"threat.indicator.x509.serial_number":{dashed_name:"threat-indicator-x509-serial-number",description:"Unique serial number issued by the certificate authority. For consistency, this must be encoded in base 16 and formatted without colons and uppercase characters.",example:"55FBB9C7DEBF09809D12CCAA",flat_name:"threat.indicator.x509.serial_number",ignore_above:1024,level:"extended",name:"serial_number",normalize:[],original_fieldset:"x509",short:"Unique serial number issued by the certificate authority.",type:"keyword"},"threat.indicator.x509.signature_algorithm":{dashed_name:"threat-indicator-x509-signature-algorithm",description:"Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353.",example:"SHA256-RSA",flat_name:"threat.indicator.x509.signature_algorithm",ignore_above:1024,level:"extended",name:"signature_algorithm",normalize:[],original_fieldset:"x509",short:"Identifier for certificate signature algorithm.",type:"keyword"},"threat.indicator.x509.subject.common_name":{dashed_name:"threat-indicator-x509-subject-common-name",description:"List of common names (CN) of subject.",example:"shared.global.example.net",flat_name:"threat.indicator.x509.subject.common_name",ignore_above:1024,level:"extended",name:"subject.common_name",normalize:["array"],original_fieldset:"x509",short:"List of common names (CN) of subject.",type:"keyword"},"threat.indicator.x509.subject.country":{dashed_name:"threat-indicator-x509-subject-country",description:"List of country \\(C) code",example:"US",flat_name:"threat.indicator.x509.subject.country",ignore_above:1024,level:"extended",name:"subject.country",normalize:["array"],original_fieldset:"x509",short:"List of country \\(C) code",type:"keyword"},"threat.indicator.x509.subject.distinguished_name":{dashed_name:"threat-indicator-x509-subject-distinguished-name",description:"Distinguished name (DN) of the certificate subject entity.",example:"C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net",flat_name:"threat.indicator.x509.subject.distinguished_name",ignore_above:1024,level:"extended",name:"subject.distinguished_name",normalize:[],original_fieldset:"x509",short:"Distinguished name (DN) of the certificate subject entity.",type:"keyword"},"threat.indicator.x509.subject.locality":{dashed_name:"threat-indicator-x509-subject-locality",description:"List of locality names (L)",example:"San Francisco",flat_name:"threat.indicator.x509.subject.locality",ignore_above:1024,level:"extended",name:"subject.locality",normalize:["array"],original_fieldset:"x509",short:"List of locality names (L)",type:"keyword"},"threat.indicator.x509.subject.organization":{dashed_name:"threat-indicator-x509-subject-organization",description:"List of organizations (O) of subject.",example:"Example, Inc.",flat_name:"threat.indicator.x509.subject.organization",ignore_above:1024,level:"extended",name:"subject.organization",normalize:["array"],original_fieldset:"x509",short:"List of organizations (O) of subject.",type:"keyword"},"threat.indicator.x509.subject.organizational_unit":{dashed_name:"threat-indicator-x509-subject-organizational-unit",description:"List of organizational units (OU) of subject.",flat_name:"threat.indicator.x509.subject.organizational_unit",ignore_above:1024,level:"extended",name:"subject.organizational_unit",normalize:["array"],original_fieldset:"x509",short:"List of organizational units (OU) of subject.",type:"keyword"},"threat.indicator.x509.subject.state_or_province":{dashed_name:"threat-indicator-x509-subject-state-or-province",description:"List of state or province names (ST, S, or P)",example:"California",flat_name:"threat.indicator.x509.subject.state_or_province",ignore_above:1024,level:"extended",name:"subject.state_or_province",normalize:["array"],original_fieldset:"x509",short:"List of state or province names (ST, S, or P)",type:"keyword"},"threat.indicator.x509.version_number":{dashed_name:"threat-indicator-x509-version-number",description:"Version of x509 format.",example:3,flat_name:"threat.indicator.x509.version_number",ignore_above:1024,level:"extended",name:"version_number",normalize:[],original_fieldset:"x509",short:"Version of x509 format.",type:"keyword"},"threat.software.alias":{dashed_name:"threat-software-alias",description:"The alias(es) of the software for a set of related intrusion activity that are tracked by a common name in the security community.\nWhile not required, you can use a MITRE ATT&CK® associated software description.",example:'[ "X-Agent" ]',flat_name:"threat.software.alias",ignore_above:1024,level:"extended",name:"software.alias",normalize:["array"],short:"Alias of the software",synthetic_source_keep:"none",type:"keyword"},"threat.software.id":{dashed_name:"threat-software-id",description:"The id of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®.\nWhile not required, you can use a MITRE ATT&CK® software id.",example:"S0552",flat_name:"threat.software.id",ignore_above:1024,level:"extended",name:"software.id",normalize:[],short:"ID of the software",type:"keyword"},"threat.software.name":{dashed_name:"threat-software-name",description:"The name of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®.\nWhile not required, you can use a MITRE ATT&CK® software name.",example:"AdFind",flat_name:"threat.software.name",ignore_above:1024,level:"extended",name:"software.name",normalize:[],short:"Name of the software.",type:"keyword"},"threat.software.platforms":{dashed_name:"threat-software-platforms",description:"The platforms of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®.\nWhile not required, you can use MITRE ATT&CK® software platform values.",example:'[ "Windows" ]',expected_values:["AWS","Azure","Azure AD","GCP","Linux","macOS","Network","Office 365","SaaS","Windows"],flat_name:"threat.software.platforms",ignore_above:1024,level:"extended",name:"software.platforms",normalize:["array"],short:"Platforms of the software.",synthetic_source_keep:"none",type:"keyword"},"threat.software.reference":{dashed_name:"threat-software-reference",description:"The reference URL of the software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®.\nWhile not required, you can use a MITRE ATT&CK® software reference URL.",example:"https://attack.mitre.org/software/S0552/",flat_name:"threat.software.reference",ignore_above:1024,level:"extended",name:"software.reference",normalize:[],short:"Software reference URL.",type:"keyword"},"threat.software.type":{dashed_name:"threat-software-type",description:"The type of software used by this threat to conduct behavior commonly modeled using MITRE ATT&CK®.\nWhile not required, you can use a MITRE ATT&CK® software type.",example:"Tool",expected_values:["Malware","Tool"],flat_name:"threat.software.type",ignore_above:1024,level:"extended",name:"software.type",normalize:[],short:"Software type.",type:"keyword"},"threat.tactic.id":{dashed_name:"threat-tactic-id",description:"The id of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex. https://attack.mitre.org/tactics/TA0002/ )",example:"TA0002",flat_name:"threat.tactic.id",ignore_above:1024,level:"extended",name:"tactic.id",normalize:["array"],short:"Threat tactic id.",type:"keyword"},"threat.tactic.name":{dashed_name:"threat-tactic-name",description:"Name of the type of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex. https://attack.mitre.org/tactics/TA0002/)",example:"Execution",flat_name:"threat.tactic.name",ignore_above:1024,level:"extended",name:"tactic.name",normalize:["array"],short:"Threat tactic.",type:"keyword"},"threat.tactic.reference":{dashed_name:"threat-tactic-reference",description:"The reference url of tactic used by this threat. You can use a MITRE ATT&CK® tactic, for example. (ex. https://attack.mitre.org/tactics/TA0002/ )",example:"https://attack.mitre.org/tactics/TA0002/",flat_name:"threat.tactic.reference",ignore_above:1024,level:"extended",name:"tactic.reference",normalize:["array"],short:"Threat tactic URL reference.",type:"keyword"},"threat.technique.id":{dashed_name:"threat-technique-id",description:"The id of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. https://attack.mitre.org/techniques/T1059/)",example:"T1059",flat_name:"threat.technique.id",ignore_above:1024,level:"extended",name:"technique.id",normalize:["array"],short:"Threat technique id.",type:"keyword"},"threat.technique.name":{dashed_name:"threat-technique-name",description:"The name of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. https://attack.mitre.org/techniques/T1059/)",example:"Command and Scripting Interpreter",flat_name:"threat.technique.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"threat.technique.name.text",name:"text",type:"match_only_text"}],name:"technique.name",normalize:["array"],short:"Threat technique name.",type:"keyword"},"threat.technique.reference":{dashed_name:"threat-technique-reference",description:"The reference url of technique used by this threat. You can use a MITRE ATT&CK® technique, for example. (ex. https://attack.mitre.org/techniques/T1059/)",example:"https://attack.mitre.org/techniques/T1059/",flat_name:"threat.technique.reference",ignore_above:1024,level:"extended",name:"technique.reference",normalize:["array"],short:"Threat technique URL reference.",type:"keyword"},"threat.technique.subtechnique.id":{dashed_name:"threat-technique-subtechnique-id",description:"The full id of subtechnique used by this threat. You can use a MITRE ATT&CK® subtechnique, for example. (ex. https://attack.mitre.org/techniques/T1059/001/)",example:"T1059.001",flat_name:"threat.technique.subtechnique.id",ignore_above:1024,level:"extended",name:"technique.subtechnique.id",normalize:["array"],short:"Threat subtechnique id.",type:"keyword"},"threat.technique.subtechnique.name":{dashed_name:"threat-technique-subtechnique-name",description:"The name of subtechnique used by this threat. You can use a MITRE ATT&CK® subtechnique, for example. (ex. https://attack.mitre.org/techniques/T1059/001/)",example:"PowerShell",flat_name:"threat.technique.subtechnique.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"threat.technique.subtechnique.name.text",name:"text",type:"match_only_text"}],name:"technique.subtechnique.name",normalize:["array"],short:"Threat subtechnique name.",type:"keyword"},"threat.technique.subtechnique.reference":{dashed_name:"threat-technique-subtechnique-reference",description:"The reference url of subtechnique used by this threat. You can use a MITRE ATT&CK® subtechnique, for example. (ex. https://attack.mitre.org/techniques/T1059/001/)",example:"https://attack.mitre.org/techniques/T1059/001/",flat_name:"threat.technique.subtechnique.reference",ignore_above:1024,level:"extended",name:"technique.subtechnique.reference",normalize:["array"],short:"Threat subtechnique URL reference.",type:"keyword"},"tls.cipher":{dashed_name:"tls-cipher",description:"String indicating the cipher used during the current connection.",example:"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256",flat_name:"tls.cipher",ignore_above:1024,level:"extended",name:"cipher",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"String indicating the cipher used during the current connection.",type:"keyword"},"tls.client.certificate":{dashed_name:"tls-client-certificate",description:"PEM-encoded stand-alone certificate offered by the client. This is usually mutually-exclusive of `client.certificate_chain` since this value also exists in that list.",example:"MII...",flat_name:"tls.client.certificate",ignore_above:1024,level:"extended",name:"client.certificate",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"PEM-encoded stand-alone certificate offered by the client.",type:"keyword"},"tls.client.certificate_chain":{dashed_name:"tls-client-certificate-chain",description:"Array of PEM-encoded certificates that make up the certificate chain offered by the client. This is usually mutually-exclusive of `client.certificate` since that value should be the first certificate in the chain.",example:'["MII...", "MII..."]',flat_name:"tls.client.certificate_chain",ignore_above:1024,level:"extended",name:"client.certificate_chain",normalize:["array"],otel:[{relation:"match",stability:"experimental"}],short:"Array of PEM-encoded certificates that make up the certificate chain offered by the client.",type:"keyword"},"tls.client.hash.md5":{dashed_name:"tls-client-hash-md5",description:"Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.",example:"0F76C7F2C55BFD7D8E8B8F4BFBF0C9EC",flat_name:"tls.client.hash.md5",ignore_above:1024,level:"extended",name:"client.hash.md5",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the client.",type:"keyword"},"tls.client.hash.sha1":{dashed_name:"tls-client-hash-sha1",description:"Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.",example:"9E393D93138888D288266C2D915214D1D1CCEB2A",flat_name:"tls.client.hash.sha1",ignore_above:1024,level:"extended",name:"client.hash.sha1",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the client.",type:"keyword"},"tls.client.hash.sha256":{dashed_name:"tls-client-hash-sha256",description:"Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the client. For consistency with other hash values, this value should be formatted as an uppercase hash.",example:"0687F666A054EF17A08E2F2162EAB4CBC0D265E1D7875BE74BF3C712CA92DAF0",flat_name:"tls.client.hash.sha256",ignore_above:1024,level:"extended",name:"client.hash.sha256",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the client.",type:"keyword"},"tls.client.issuer":{dashed_name:"tls-client-issuer",description:"Distinguished name of subject of the issuer of the x.509 certificate presented by the client.",example:"CN=Example Root CA, OU=Infrastructure Team, DC=example, DC=com",flat_name:"tls.client.issuer",ignore_above:1024,level:"extended",name:"client.issuer",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Distinguished name of subject of the issuer of the x.509 certificate presented by the client.",type:"keyword"},"tls.client.ja3":{dashed_name:"tls-client-ja3",description:"A hash that identifies clients based on how they perform an SSL/TLS handshake.",example:"d4e5b18d6b55c71272893221c96ba240",flat_name:"tls.client.ja3",ignore_above:1024,level:"extended",name:"client.ja3",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"A hash that identifies clients based on how they perform an SSL/TLS handshake.",type:"keyword"},"tls.client.not_after":{dashed_name:"tls-client-not-after",description:"Date/Time indicating when client certificate is no longer considered valid.",example:"2021-01-01T00:00:00.000Z",flat_name:"tls.client.not_after",level:"extended",name:"client.not_after",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Date/Time indicating when client certificate is no longer considered valid.",type:"date"},"tls.client.not_before":{dashed_name:"tls-client-not-before",description:"Date/Time indicating when client certificate is first considered valid.",example:"1970-01-01T00:00:00.000Z",flat_name:"tls.client.not_before",level:"extended",name:"client.not_before",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Date/Time indicating when client certificate is first considered valid.",type:"date"},"tls.client.server_name":{dashed_name:"tls-client-server-name",description:"Also called an SNI, this tells the server which hostname to which the client is attempting to connect to. When this value is available, it should get copied to `destination.domain`.",example:"www.elastic.co",flat_name:"tls.client.server_name",ignore_above:1024,level:"extended",name:"client.server_name",normalize:[],short:"Hostname the client is trying to connect to. Also called the SNI.",type:"keyword"},"tls.client.subject":{dashed_name:"tls-client-subject",description:"Distinguished name of subject of the x.509 certificate presented by the client.",example:"CN=myclient, OU=Documentation Team, DC=example, DC=com",flat_name:"tls.client.subject",ignore_above:1024,level:"extended",name:"client.subject",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Distinguished name of subject of the x.509 certificate presented by the client.",type:"keyword"},"tls.client.supported_ciphers":{dashed_name:"tls-client-supported-ciphers",description:"Array of ciphers offered by the client during the client hello.",example:'["TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "..."]',flat_name:"tls.client.supported_ciphers",ignore_above:1024,level:"extended",name:"client.supported_ciphers",normalize:["array"],otel:[{relation:"match",stability:"experimental"}],short:"Array of ciphers offered by the client during the client hello.",type:"keyword"},"tls.client.x509.alternative_names":{dashed_name:"tls-client-x509-alternative-names",description:"List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.",example:"*.elastic.co",flat_name:"tls.client.x509.alternative_names",ignore_above:1024,level:"extended",name:"alternative_names",normalize:["array"],original_fieldset:"x509",short:"List of subject alternative names (SAN).",type:"keyword"},"tls.client.x509.issuer.common_name":{dashed_name:"tls-client-x509-issuer-common-name",description:"List of common name (CN) of issuing certificate authority.",example:"Example SHA2 High Assurance Server CA",flat_name:"tls.client.x509.issuer.common_name",ignore_above:1024,level:"extended",name:"issuer.common_name",normalize:["array"],original_fieldset:"x509",short:"List of common name (CN) of issuing certificate authority.",type:"keyword"},"tls.client.x509.issuer.country":{dashed_name:"tls-client-x509-issuer-country",description:"List of country \\(C) codes",example:"US",flat_name:"tls.client.x509.issuer.country",ignore_above:1024,level:"extended",name:"issuer.country",normalize:["array"],original_fieldset:"x509",short:"List of country \\(C) codes",type:"keyword"},"tls.client.x509.issuer.distinguished_name":{dashed_name:"tls-client-x509-issuer-distinguished-name",description:"Distinguished name (DN) of issuing certificate authority.",example:"C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA",flat_name:"tls.client.x509.issuer.distinguished_name",ignore_above:1024,level:"extended",name:"issuer.distinguished_name",normalize:[],original_fieldset:"x509",short:"Distinguished name (DN) of issuing certificate authority.",type:"keyword"},"tls.client.x509.issuer.locality":{dashed_name:"tls-client-x509-issuer-locality",description:"List of locality names (L)",example:"Mountain View",flat_name:"tls.client.x509.issuer.locality",ignore_above:1024,level:"extended",name:"issuer.locality",normalize:["array"],original_fieldset:"x509",short:"List of locality names (L)",type:"keyword"},"tls.client.x509.issuer.organization":{dashed_name:"tls-client-x509-issuer-organization",description:"List of organizations (O) of issuing certificate authority.",example:"Example Inc",flat_name:"tls.client.x509.issuer.organization",ignore_above:1024,level:"extended",name:"issuer.organization",normalize:["array"],original_fieldset:"x509",short:"List of organizations (O) of issuing certificate authority.",type:"keyword"},"tls.client.x509.issuer.organizational_unit":{dashed_name:"tls-client-x509-issuer-organizational-unit",description:"List of organizational units (OU) of issuing certificate authority.",example:"www.example.com",flat_name:"tls.client.x509.issuer.organizational_unit",ignore_above:1024,level:"extended",name:"issuer.organizational_unit",normalize:["array"],original_fieldset:"x509",short:"List of organizational units (OU) of issuing certificate authority.",type:"keyword"},"tls.client.x509.issuer.state_or_province":{dashed_name:"tls-client-x509-issuer-state-or-province",description:"List of state or province names (ST, S, or P)",example:"California",flat_name:"tls.client.x509.issuer.state_or_province",ignore_above:1024,level:"extended",name:"issuer.state_or_province",normalize:["array"],original_fieldset:"x509",short:"List of state or province names (ST, S, or P)",type:"keyword"},"tls.client.x509.not_after":{dashed_name:"tls-client-x509-not-after",description:"Time at which the certificate is no longer considered valid.",example:"2020-07-16T03:15:39Z",flat_name:"tls.client.x509.not_after",level:"extended",name:"not_after",normalize:[],original_fieldset:"x509",short:"Time at which the certificate is no longer considered valid.",type:"date"},"tls.client.x509.not_before":{dashed_name:"tls-client-x509-not-before",description:"Time at which the certificate is first considered valid.",example:"2019-08-16T01:40:25Z",flat_name:"tls.client.x509.not_before",level:"extended",name:"not_before",normalize:[],original_fieldset:"x509",short:"Time at which the certificate is first considered valid.",type:"date"},"tls.client.x509.public_key_algorithm":{dashed_name:"tls-client-x509-public-key-algorithm",description:"Algorithm used to generate the public key.",example:"RSA",flat_name:"tls.client.x509.public_key_algorithm",ignore_above:1024,level:"extended",name:"public_key_algorithm",normalize:[],original_fieldset:"x509",short:"Algorithm used to generate the public key.",type:"keyword"},"tls.client.x509.public_key_curve":{dashed_name:"tls-client-x509-public-key-curve",description:"The curve used by the elliptic curve public key algorithm. This is algorithm specific.",example:"nistp521",flat_name:"tls.client.x509.public_key_curve",ignore_above:1024,level:"extended",name:"public_key_curve",normalize:[],original_fieldset:"x509",short:"The curve used by the elliptic curve public key algorithm. This is algorithm specific.",type:"keyword"},"tls.client.x509.public_key_exponent":{dashed_name:"tls-client-x509-public-key-exponent",description:"Exponent used to derive the public key. This is algorithm specific.",doc_values:!1,example:65537,flat_name:"tls.client.x509.public_key_exponent",index:!1,level:"extended",name:"public_key_exponent",normalize:[],original_fieldset:"x509",short:"Exponent used to derive the public key. This is algorithm specific.",type:"long"},"tls.client.x509.public_key_size":{dashed_name:"tls-client-x509-public-key-size",description:"The size of the public key space in bits.",example:2048,flat_name:"tls.client.x509.public_key_size",level:"extended",name:"public_key_size",normalize:[],original_fieldset:"x509",short:"The size of the public key space in bits.",type:"long"},"tls.client.x509.serial_number":{dashed_name:"tls-client-x509-serial-number",description:"Unique serial number issued by the certificate authority. For consistency, this must be encoded in base 16 and formatted without colons and uppercase characters.",example:"55FBB9C7DEBF09809D12CCAA",flat_name:"tls.client.x509.serial_number",ignore_above:1024,level:"extended",name:"serial_number",normalize:[],original_fieldset:"x509",short:"Unique serial number issued by the certificate authority.",type:"keyword"},"tls.client.x509.signature_algorithm":{dashed_name:"tls-client-x509-signature-algorithm",description:"Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353.",example:"SHA256-RSA",flat_name:"tls.client.x509.signature_algorithm",ignore_above:1024,level:"extended",name:"signature_algorithm",normalize:[],original_fieldset:"x509",short:"Identifier for certificate signature algorithm.",type:"keyword"},"tls.client.x509.subject.common_name":{dashed_name:"tls-client-x509-subject-common-name",description:"List of common names (CN) of subject.",example:"shared.global.example.net",flat_name:"tls.client.x509.subject.common_name",ignore_above:1024,level:"extended",name:"subject.common_name",normalize:["array"],original_fieldset:"x509",short:"List of common names (CN) of subject.",type:"keyword"},"tls.client.x509.subject.country":{dashed_name:"tls-client-x509-subject-country",description:"List of country \\(C) code",example:"US",flat_name:"tls.client.x509.subject.country",ignore_above:1024,level:"extended",name:"subject.country",normalize:["array"],original_fieldset:"x509",short:"List of country \\(C) code",type:"keyword"},"tls.client.x509.subject.distinguished_name":{dashed_name:"tls-client-x509-subject-distinguished-name",description:"Distinguished name (DN) of the certificate subject entity.",example:"C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net",flat_name:"tls.client.x509.subject.distinguished_name",ignore_above:1024,level:"extended",name:"subject.distinguished_name",normalize:[],original_fieldset:"x509",short:"Distinguished name (DN) of the certificate subject entity.",type:"keyword"},"tls.client.x509.subject.locality":{dashed_name:"tls-client-x509-subject-locality",description:"List of locality names (L)",example:"San Francisco",flat_name:"tls.client.x509.subject.locality",ignore_above:1024,level:"extended",name:"subject.locality",normalize:["array"],original_fieldset:"x509",short:"List of locality names (L)",type:"keyword"},"tls.client.x509.subject.organization":{dashed_name:"tls-client-x509-subject-organization",description:"List of organizations (O) of subject.",example:"Example, Inc.",flat_name:"tls.client.x509.subject.organization",ignore_above:1024,level:"extended",name:"subject.organization",normalize:["array"],original_fieldset:"x509",short:"List of organizations (O) of subject.",type:"keyword"},"tls.client.x509.subject.organizational_unit":{dashed_name:"tls-client-x509-subject-organizational-unit",description:"List of organizational units (OU) of subject.",flat_name:"tls.client.x509.subject.organizational_unit",ignore_above:1024,level:"extended",name:"subject.organizational_unit",normalize:["array"],original_fieldset:"x509",short:"List of organizational units (OU) of subject.",type:"keyword"},"tls.client.x509.subject.state_or_province":{dashed_name:"tls-client-x509-subject-state-or-province",description:"List of state or province names (ST, S, or P)",example:"California",flat_name:"tls.client.x509.subject.state_or_province",ignore_above:1024,level:"extended",name:"subject.state_or_province",normalize:["array"],original_fieldset:"x509",short:"List of state or province names (ST, S, or P)",type:"keyword"},"tls.client.x509.version_number":{dashed_name:"tls-client-x509-version-number",description:"Version of x509 format.",example:3,flat_name:"tls.client.x509.version_number",ignore_above:1024,level:"extended",name:"version_number",normalize:[],original_fieldset:"x509",short:"Version of x509 format.",type:"keyword"},"tls.curve":{dashed_name:"tls-curve",description:"String indicating the curve used for the given cipher, when applicable.",example:"secp256r1",flat_name:"tls.curve",ignore_above:1024,level:"extended",name:"curve",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"String indicating the curve used for the given cipher, when applicable.",type:"keyword"},"tls.established":{dashed_name:"tls-established",description:"Boolean flag indicating if the TLS negotiation was successful and transitioned to an encrypted tunnel.",flat_name:"tls.established",level:"extended",name:"established",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Boolean flag indicating if the TLS negotiation was successful and transitioned to an encrypted tunnel.",type:"boolean"},"tls.next_protocol":{dashed_name:"tls-next-protocol",description:"String indicating the protocol being tunneled. Per the values in the IANA registry (https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids), this string should be lower case.",example:"http/1.1",flat_name:"tls.next_protocol",ignore_above:1024,level:"extended",name:"next_protocol",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"String indicating the protocol being tunneled.",type:"keyword"},"tls.resumed":{dashed_name:"tls-resumed",description:"Boolean flag indicating if this TLS connection was resumed from an existing TLS negotiation.",flat_name:"tls.resumed",level:"extended",name:"resumed",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Boolean flag indicating if this TLS connection was resumed from an existing TLS negotiation.",type:"boolean"},"tls.server.certificate":{dashed_name:"tls-server-certificate",description:"PEM-encoded stand-alone certificate offered by the server. This is usually mutually-exclusive of `server.certificate_chain` since this value also exists in that list.",example:"MII...",flat_name:"tls.server.certificate",ignore_above:1024,level:"extended",name:"server.certificate",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"PEM-encoded stand-alone certificate offered by the server.",type:"keyword"},"tls.server.certificate_chain":{dashed_name:"tls-server-certificate-chain",description:"Array of PEM-encoded certificates that make up the certificate chain offered by the server. This is usually mutually-exclusive of `server.certificate` since that value should be the first certificate in the chain.",example:'["MII...", "MII..."]',flat_name:"tls.server.certificate_chain",ignore_above:1024,level:"extended",name:"server.certificate_chain",normalize:["array"],otel:[{relation:"match",stability:"experimental"}],short:"Array of PEM-encoded certificates that make up the certificate chain offered by the server.",type:"keyword"},"tls.server.hash.md5":{dashed_name:"tls-server-hash-md5",description:"Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.",example:"0F76C7F2C55BFD7D8E8B8F4BFBF0C9EC",flat_name:"tls.server.hash.md5",ignore_above:1024,level:"extended",name:"server.hash.md5",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Certificate fingerprint using the MD5 digest of DER-encoded version of certificate offered by the server.",type:"keyword"},"tls.server.hash.sha1":{dashed_name:"tls-server-hash-sha1",description:"Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.",example:"9E393D93138888D288266C2D915214D1D1CCEB2A",flat_name:"tls.server.hash.sha1",ignore_above:1024,level:"extended",name:"server.hash.sha1",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Certificate fingerprint using the SHA1 digest of DER-encoded version of certificate offered by the server.",type:"keyword"},"tls.server.hash.sha256":{dashed_name:"tls-server-hash-sha256",description:"Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the server. For consistency with other hash values, this value should be formatted as an uppercase hash.",example:"0687F666A054EF17A08E2F2162EAB4CBC0D265E1D7875BE74BF3C712CA92DAF0",flat_name:"tls.server.hash.sha256",ignore_above:1024,level:"extended",name:"server.hash.sha256",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Certificate fingerprint using the SHA256 digest of DER-encoded version of certificate offered by the server.",type:"keyword"},"tls.server.issuer":{dashed_name:"tls-server-issuer",description:"Subject of the issuer of the x.509 certificate presented by the server.",example:"CN=Example Root CA, OU=Infrastructure Team, DC=example, DC=com",flat_name:"tls.server.issuer",ignore_above:1024,level:"extended",name:"server.issuer",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Subject of the issuer of the x.509 certificate presented by the server.",type:"keyword"},"tls.server.ja3s":{dashed_name:"tls-server-ja3s",description:"A hash that identifies servers based on how they perform an SSL/TLS handshake.",example:"394441ab65754e2207b1e1b457b3641d",flat_name:"tls.server.ja3s",ignore_above:1024,level:"extended",name:"server.ja3s",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"A hash that identifies servers based on how they perform an SSL/TLS handshake.",type:"keyword"},"tls.server.not_after":{dashed_name:"tls-server-not-after",description:"Timestamp indicating when server certificate is no longer considered valid.",example:"2021-01-01T00:00:00.000Z",flat_name:"tls.server.not_after",level:"extended",name:"server.not_after",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Timestamp indicating when server certificate is no longer considered valid.",type:"date"},"tls.server.not_before":{dashed_name:"tls-server-not-before",description:"Timestamp indicating when server certificate is first considered valid.",example:"1970-01-01T00:00:00.000Z",flat_name:"tls.server.not_before",level:"extended",name:"server.not_before",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Timestamp indicating when server certificate is first considered valid.",type:"date"},"tls.server.subject":{dashed_name:"tls-server-subject",description:"Subject of the x.509 certificate presented by the server.",example:"CN=www.example.com, OU=Infrastructure Team, DC=example, DC=com",flat_name:"tls.server.subject",ignore_above:1024,level:"extended",name:"server.subject",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Subject of the x.509 certificate presented by the server.",type:"keyword"},"tls.server.x509.alternative_names":{dashed_name:"tls-server-x509-alternative-names",description:"List of subject alternative names (SAN). Name types vary by certificate authority and certificate type but commonly contain IP addresses, DNS names (and wildcards), and email addresses.",example:"*.elastic.co",flat_name:"tls.server.x509.alternative_names",ignore_above:1024,level:"extended",name:"alternative_names",normalize:["array"],original_fieldset:"x509",short:"List of subject alternative names (SAN).",type:"keyword"},"tls.server.x509.issuer.common_name":{dashed_name:"tls-server-x509-issuer-common-name",description:"List of common name (CN) of issuing certificate authority.",example:"Example SHA2 High Assurance Server CA",flat_name:"tls.server.x509.issuer.common_name",ignore_above:1024,level:"extended",name:"issuer.common_name",normalize:["array"],original_fieldset:"x509",short:"List of common name (CN) of issuing certificate authority.",type:"keyword"},"tls.server.x509.issuer.country":{dashed_name:"tls-server-x509-issuer-country",description:"List of country \\(C) codes",example:"US",flat_name:"tls.server.x509.issuer.country",ignore_above:1024,level:"extended",name:"issuer.country",normalize:["array"],original_fieldset:"x509",short:"List of country \\(C) codes",type:"keyword"},"tls.server.x509.issuer.distinguished_name":{dashed_name:"tls-server-x509-issuer-distinguished-name",description:"Distinguished name (DN) of issuing certificate authority.",example:"C=US, O=Example Inc, OU=www.example.com, CN=Example SHA2 High Assurance Server CA",flat_name:"tls.server.x509.issuer.distinguished_name",ignore_above:1024,level:"extended",name:"issuer.distinguished_name",normalize:[],original_fieldset:"x509",short:"Distinguished name (DN) of issuing certificate authority.",type:"keyword"},"tls.server.x509.issuer.locality":{dashed_name:"tls-server-x509-issuer-locality",description:"List of locality names (L)",example:"Mountain View",flat_name:"tls.server.x509.issuer.locality",ignore_above:1024,level:"extended",name:"issuer.locality",normalize:["array"],original_fieldset:"x509",short:"List of locality names (L)",type:"keyword"},"tls.server.x509.issuer.organization":{dashed_name:"tls-server-x509-issuer-organization",description:"List of organizations (O) of issuing certificate authority.",example:"Example Inc",flat_name:"tls.server.x509.issuer.organization",ignore_above:1024,level:"extended",name:"issuer.organization",normalize:["array"],original_fieldset:"x509",short:"List of organizations (O) of issuing certificate authority.",type:"keyword"},"tls.server.x509.issuer.organizational_unit":{dashed_name:"tls-server-x509-issuer-organizational-unit",description:"List of organizational units (OU) of issuing certificate authority.",example:"www.example.com",flat_name:"tls.server.x509.issuer.organizational_unit",ignore_above:1024,level:"extended",name:"issuer.organizational_unit",normalize:["array"],original_fieldset:"x509",short:"List of organizational units (OU) of issuing certificate authority.",type:"keyword"},"tls.server.x509.issuer.state_or_province":{dashed_name:"tls-server-x509-issuer-state-or-province",description:"List of state or province names (ST, S, or P)",example:"California",flat_name:"tls.server.x509.issuer.state_or_province",ignore_above:1024,level:"extended",name:"issuer.state_or_province",normalize:["array"],original_fieldset:"x509",short:"List of state or province names (ST, S, or P)",type:"keyword"},"tls.server.x509.not_after":{dashed_name:"tls-server-x509-not-after",description:"Time at which the certificate is no longer considered valid.",example:"2020-07-16T03:15:39Z",flat_name:"tls.server.x509.not_after",level:"extended",name:"not_after",normalize:[],original_fieldset:"x509",short:"Time at which the certificate is no longer considered valid.",type:"date"},"tls.server.x509.not_before":{dashed_name:"tls-server-x509-not-before",description:"Time at which the certificate is first considered valid.",example:"2019-08-16T01:40:25Z",flat_name:"tls.server.x509.not_before",level:"extended",name:"not_before",normalize:[],original_fieldset:"x509",short:"Time at which the certificate is first considered valid.",type:"date"},"tls.server.x509.public_key_algorithm":{dashed_name:"tls-server-x509-public-key-algorithm",description:"Algorithm used to generate the public key.",example:"RSA",flat_name:"tls.server.x509.public_key_algorithm",ignore_above:1024,level:"extended",name:"public_key_algorithm",normalize:[],original_fieldset:"x509",short:"Algorithm used to generate the public key.",type:"keyword"},"tls.server.x509.public_key_curve":{dashed_name:"tls-server-x509-public-key-curve",description:"The curve used by the elliptic curve public key algorithm. This is algorithm specific.",example:"nistp521",flat_name:"tls.server.x509.public_key_curve",ignore_above:1024,level:"extended",name:"public_key_curve",normalize:[],original_fieldset:"x509",short:"The curve used by the elliptic curve public key algorithm. This is algorithm specific.",type:"keyword"},"tls.server.x509.public_key_exponent":{dashed_name:"tls-server-x509-public-key-exponent",description:"Exponent used to derive the public key. This is algorithm specific.",doc_values:!1,example:65537,flat_name:"tls.server.x509.public_key_exponent",index:!1,level:"extended",name:"public_key_exponent",normalize:[],original_fieldset:"x509",short:"Exponent used to derive the public key. This is algorithm specific.",type:"long"},"tls.server.x509.public_key_size":{dashed_name:"tls-server-x509-public-key-size",description:"The size of the public key space in bits.",example:2048,flat_name:"tls.server.x509.public_key_size",level:"extended",name:"public_key_size",normalize:[],original_fieldset:"x509",short:"The size of the public key space in bits.",type:"long"},"tls.server.x509.serial_number":{dashed_name:"tls-server-x509-serial-number",description:"Unique serial number issued by the certificate authority. For consistency, this must be encoded in base 16 and formatted without colons and uppercase characters.",example:"55FBB9C7DEBF09809D12CCAA",flat_name:"tls.server.x509.serial_number",ignore_above:1024,level:"extended",name:"serial_number",normalize:[],original_fieldset:"x509",short:"Unique serial number issued by the certificate authority.",type:"keyword"},"tls.server.x509.signature_algorithm":{dashed_name:"tls-server-x509-signature-algorithm",description:"Identifier for certificate signature algorithm. We recommend using names found in Go Lang Crypto library. See https://github.com/golang/go/blob/go1.14/src/crypto/x509/x509.go#L337-L353.",example:"SHA256-RSA",flat_name:"tls.server.x509.signature_algorithm",ignore_above:1024,level:"extended",name:"signature_algorithm",normalize:[],original_fieldset:"x509",short:"Identifier for certificate signature algorithm.",type:"keyword"},"tls.server.x509.subject.common_name":{dashed_name:"tls-server-x509-subject-common-name",description:"List of common names (CN) of subject.",example:"shared.global.example.net",flat_name:"tls.server.x509.subject.common_name",ignore_above:1024,level:"extended",name:"subject.common_name",normalize:["array"],original_fieldset:"x509",short:"List of common names (CN) of subject.",type:"keyword"},"tls.server.x509.subject.country":{dashed_name:"tls-server-x509-subject-country",description:"List of country \\(C) code",example:"US",flat_name:"tls.server.x509.subject.country",ignore_above:1024,level:"extended",name:"subject.country",normalize:["array"],original_fieldset:"x509",short:"List of country \\(C) code",type:"keyword"},"tls.server.x509.subject.distinguished_name":{dashed_name:"tls-server-x509-subject-distinguished-name",description:"Distinguished name (DN) of the certificate subject entity.",example:"C=US, ST=California, L=San Francisco, O=Example, Inc., CN=shared.global.example.net",flat_name:"tls.server.x509.subject.distinguished_name",ignore_above:1024,level:"extended",name:"subject.distinguished_name",normalize:[],original_fieldset:"x509",short:"Distinguished name (DN) of the certificate subject entity.",type:"keyword"},"tls.server.x509.subject.locality":{dashed_name:"tls-server-x509-subject-locality",description:"List of locality names (L)",example:"San Francisco",flat_name:"tls.server.x509.subject.locality",ignore_above:1024,level:"extended",name:"subject.locality",normalize:["array"],original_fieldset:"x509",short:"List of locality names (L)",type:"keyword"},"tls.server.x509.subject.organization":{dashed_name:"tls-server-x509-subject-organization",description:"List of organizations (O) of subject.",example:"Example, Inc.",flat_name:"tls.server.x509.subject.organization",ignore_above:1024,level:"extended",name:"subject.organization",normalize:["array"],original_fieldset:"x509",short:"List of organizations (O) of subject.",type:"keyword"},"tls.server.x509.subject.organizational_unit":{dashed_name:"tls-server-x509-subject-organizational-unit",description:"List of organizational units (OU) of subject.",flat_name:"tls.server.x509.subject.organizational_unit",ignore_above:1024,level:"extended",name:"subject.organizational_unit",normalize:["array"],original_fieldset:"x509",short:"List of organizational units (OU) of subject.",type:"keyword"},"tls.server.x509.subject.state_or_province":{dashed_name:"tls-server-x509-subject-state-or-province",description:"List of state or province names (ST, S, or P)",example:"California",flat_name:"tls.server.x509.subject.state_or_province",ignore_above:1024,level:"extended",name:"subject.state_or_province",normalize:["array"],original_fieldset:"x509",short:"List of state or province names (ST, S, or P)",type:"keyword"},"tls.server.x509.version_number":{dashed_name:"tls-server-x509-version-number",description:"Version of x509 format.",example:3,flat_name:"tls.server.x509.version_number",ignore_above:1024,level:"extended",name:"version_number",normalize:[],original_fieldset:"x509",short:"Version of x509 format.",type:"keyword"},"tls.version":{dashed_name:"tls-version",description:"Numeric part of the version parsed from the original string.",example:"1.2",flat_name:"tls.version",ignore_above:1024,level:"extended",name:"version",normalize:[],short:"Numeric part of the version parsed from the original string.",type:"keyword"},"tls.version_protocol":{dashed_name:"tls-version-protocol",description:"Normalized lowercase protocol name parsed from original string.",example:"tls",flat_name:"tls.version_protocol",ignore_above:1024,level:"extended",name:"version_protocol",normalize:[],short:"Normalized lowercase protocol name parsed from original string.",type:"keyword"},"trace.id":{dashed_name:"trace-id",description:"Unique identifier of the trace.\nA trace groups multiple events like transactions that belong together. For example, a user request handled by multiple inter-connected services.",example:"4bf92f3577b34da6a3ce929d0e0e4736",flat_name:"trace.id",ignore_above:1024,level:"extended",name:"trace.id",normalize:[],otel:[{otlp_field:"trace_id",relation:"otlp",stability:"stable"}],short:"Unique identifier of the trace.",type:"keyword"},"transaction.id":{dashed_name:"transaction-id",description:"Unique identifier of the transaction within the scope of its trace.\nA transaction is the highest level of work measured within a service, such as a request to a server.",example:"00f067aa0ba902b7",flat_name:"transaction.id",ignore_above:1024,level:"extended",name:"transaction.id",normalize:[],otel:[{relation:"na"}],short:"Unique identifier of the transaction within the scope of its trace.",type:"keyword"},"url.domain":{dashed_name:"url-domain",description:'Domain of the url, such as "www.elastic.co".\nIn some cases a URL may refer to an IP and/or port directly, without a domain name. In this case, the IP address would go to the `domain` field.\nIf the URL contains a literal IPv6 address enclosed by `[` and `]` (IETF RFC 2732), the `[` and `]` characters should also be captured in the `domain` field.',example:"www.elastic.co",flat_name:"url.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Domain of the url.",type:"keyword"},"url.extension":{dashed_name:"url-extension",description:'The field contains the file extension from the original request url, excluding the leading dot.\nThe file extension is only set if it exists, as not every url has a file extension.\nThe leading period must not be included. For example, the value must be "png", not ".png".\nNote that when the file name has multiple extensions (example.tar.gz), only the last one should be captured ("gz", not "tar.gz").',example:"png",flat_name:"url.extension",ignore_above:1024,level:"extended",name:"extension",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"File extension from the request url, excluding the leading dot.",type:"keyword"},"url.fragment":{dashed_name:"url-fragment",description:'Portion of the url after the `#`, such as "top".\nThe `#` is not part of the fragment.',flat_name:"url.fragment",ignore_above:1024,level:"extended",name:"fragment",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"Portion of the url after the `#`.",type:"keyword"},"url.full":{dashed_name:"url-full",description:"If full URLs are important to your use case, they should be stored in `url.full`, whether this field is reconstructed or present in the event source.",example:"https://www.elastic.co:443/search?q=elasticsearch#top",flat_name:"url.full",level:"extended",multi_fields:[{flat_name:"url.full.text",name:"text",type:"match_only_text"}],name:"full",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"Full unparsed URL.",type:"wildcard"},"url.original":{dashed_name:"url-original",description:"Unmodified original url as seen in the event source.\nNote that in network monitoring, the observed URL may be a full URL, whereas in access logs, the URL is often just represented as a path.\nThis field is meant to represent the URL as it was observed, complete or not.",example:"https://www.elastic.co:443/search?q=elasticsearch#top or /search?q=elasticsearch",flat_name:"url.original",level:"extended",multi_fields:[{flat_name:"url.original.text",name:"text",type:"match_only_text"}],name:"original",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Unmodified original url as seen in the event source.",type:"wildcard"},"url.password":{dashed_name:"url-password",description:"Password of the request.",flat_name:"url.password",ignore_above:1024,level:"extended",name:"password",normalize:[],short:"Password of the request.",type:"keyword"},"url.path":{dashed_name:"url-path",description:'Path of the request, such as "/search".',flat_name:"url.path",level:"extended",name:"path",normalize:[],otel:[{relation:"match",stability:"stable"}],short:'Path of the request, such as "/search".',type:"wildcard"},"url.port":{dashed_name:"url-port",description:"Port of the request, such as 443.",example:443,flat_name:"url.port",format:"string",level:"extended",name:"port",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Port of the request, such as 443.",type:"long"},"url.query":{dashed_name:"url-query",description:'The query field describes the query string of the request, such as "q=elasticsearch".\nThe `?` is excluded from the query string. If a URL contains no `?`, there is no query field. If there is a `?` but no query, the query field exists with an empty string. The `exists` query can be used to differentiate between the two cases.',flat_name:"url.query",ignore_above:2083,level:"extended",name:"query",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"Query string of the request.",type:"keyword"},"url.registered_domain":{dashed_name:"url-registered-domain",description:'The highest registered url domain, stripped of the subdomain.\nFor example, the registered domain for "foo.example.com" is "example.com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last two labels will not work well for TLDs such as "co.uk".',example:"example.com",flat_name:"url.registered_domain",ignore_above:1024,level:"extended",name:"registered_domain",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"The highest registered url domain, stripped of the subdomain.",type:"keyword"},"url.scheme":{dashed_name:"url-scheme",description:'Scheme of the request, such as "https".\nNote: The `:` is not part of the scheme.',example:"https",flat_name:"url.scheme",ignore_above:1024,level:"extended",name:"scheme",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"Scheme of the url.",type:"keyword"},"url.subdomain":{dashed_name:"url-subdomain",description:'The subdomain portion of a fully qualified domain name includes all of the names except the host name under the registered_domain.  In a partially qualified domain, or if the the qualification level of the full name cannot be determined, subdomain contains all of the names below the registered domain.\nFor example the subdomain portion of "www.east.mydomain.co.uk" is "east". If the domain has multiple levels of subdomain, such as "sub2.sub1.example.com", the subdomain field should contain "sub2.sub1", with no trailing period.',example:"east",flat_name:"url.subdomain",ignore_above:1024,level:"extended",name:"subdomain",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"The subdomain of the domain.",type:"keyword"},"url.top_level_domain":{dashed_name:"url-top-level-domain",description:'The effective top level domain (eTLD), also known as the domain suffix, is the last part of the domain name. For example, the top level domain for example.com is "com".\nThis value can be determined precisely with a list like the public suffix list (https://publicsuffix.org). Trying to approximate this by simply taking the last label will not work well for effective TLDs such as "co.uk".',example:"co.uk",flat_name:"url.top_level_domain",ignore_above:1024,level:"extended",name:"top_level_domain",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"The effective top level domain (com, org, net, co.uk).",type:"keyword"},"url.username":{dashed_name:"url-username",description:"Username of the request.",flat_name:"url.username",ignore_above:1024,level:"extended",name:"username",normalize:[],short:"Username of the request.",type:"keyword"},"user.changes.domain":{dashed_name:"user-changes-domain",description:"Name of the directory the user is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"user.changes.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"user",short:"Name of the directory the user is a member of.",type:"keyword"},"user.changes.email":{dashed_name:"user-changes-email",description:"User email address.",flat_name:"user.changes.email",ignore_above:1024,level:"extended",name:"email",normalize:[],original_fieldset:"user",short:"User email address.",type:"keyword"},"user.changes.full_name":{dashed_name:"user-changes-full-name",description:"User's full name, if available.",example:"Albert Einstein",flat_name:"user.changes.full_name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"user.changes.full_name.text",name:"text",type:"match_only_text"}],name:"full_name",normalize:[],original_fieldset:"user",short:"User's full name, if available.",type:"keyword"},"user.changes.group.domain":{dashed_name:"user-changes-group-domain",description:"Name of the directory the group is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"user.changes.group.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"group",short:"Name of the directory the group is a member of.",type:"keyword"},"user.changes.group.id":{dashed_name:"user-changes-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"user.changes.group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"user.changes.group.name":{dashed_name:"user-changes-group-name",description:"Name of the group.",flat_name:"user.changes.group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"user.changes.hash":{dashed_name:"user-changes-hash",description:"Unique user hash to correlate information for a user in anonymized form.\nUseful if `user.id` or `user.name` contain confidential information and cannot be used.",flat_name:"user.changes.hash",ignore_above:1024,level:"extended",name:"hash",normalize:[],original_fieldset:"user",short:"Unique user hash to correlate information for a user in anonymized form.",type:"keyword"},"user.changes.id":{dashed_name:"user-changes-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"user.changes.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"user.changes.name":{dashed_name:"user-changes-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"user.changes.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"user.changes.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"user.changes.roles":{dashed_name:"user-changes-roles",description:"Array of user roles at the time of the event.",example:'["kibana_admin", "reporting_user"]',flat_name:"user.changes.roles",ignore_above:1024,level:"extended",name:"roles",normalize:["array"],original_fieldset:"user",short:"Array of user roles at the time of the event.",synthetic_source_keep:"none",type:"keyword"},"user.domain":{dashed_name:"user-domain",description:"Name of the directory the user is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"user.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],short:"Name of the directory the user is a member of.",type:"keyword"},"user.effective.domain":{dashed_name:"user-effective-domain",description:"Name of the directory the user is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"user.effective.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"user",short:"Name of the directory the user is a member of.",type:"keyword"},"user.effective.email":{dashed_name:"user-effective-email",description:"User email address.",flat_name:"user.effective.email",ignore_above:1024,level:"extended",name:"email",normalize:[],original_fieldset:"user",short:"User email address.",type:"keyword"},"user.effective.full_name":{dashed_name:"user-effective-full-name",description:"User's full name, if available.",example:"Albert Einstein",flat_name:"user.effective.full_name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"user.effective.full_name.text",name:"text",type:"match_only_text"}],name:"full_name",normalize:[],original_fieldset:"user",short:"User's full name, if available.",type:"keyword"},"user.effective.group.domain":{dashed_name:"user-effective-group-domain",description:"Name of the directory the group is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"user.effective.group.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"group",short:"Name of the directory the group is a member of.",type:"keyword"},"user.effective.group.id":{dashed_name:"user-effective-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"user.effective.group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"user.effective.group.name":{dashed_name:"user-effective-group-name",description:"Name of the group.",flat_name:"user.effective.group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"user.effective.hash":{dashed_name:"user-effective-hash",description:"Unique user hash to correlate information for a user in anonymized form.\nUseful if `user.id` or `user.name` contain confidential information and cannot be used.",flat_name:"user.effective.hash",ignore_above:1024,level:"extended",name:"hash",normalize:[],original_fieldset:"user",short:"Unique user hash to correlate information for a user in anonymized form.",type:"keyword"},"user.effective.id":{dashed_name:"user-effective-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"user.effective.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"user.effective.name":{dashed_name:"user-effective-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"user.effective.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"user.effective.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"user.effective.roles":{dashed_name:"user-effective-roles",description:"Array of user roles at the time of the event.",example:'["kibana_admin", "reporting_user"]',flat_name:"user.effective.roles",ignore_above:1024,level:"extended",name:"roles",normalize:["array"],original_fieldset:"user",short:"Array of user roles at the time of the event.",synthetic_source_keep:"none",type:"keyword"},"user.email":{dashed_name:"user-email",description:"User email address.",flat_name:"user.email",ignore_above:1024,level:"extended",name:"email",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"User email address.",type:"keyword"},"user.full_name":{dashed_name:"user-full-name",description:"User's full name, if available.",example:"Albert Einstein",flat_name:"user.full_name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"user.full_name.text",name:"text",type:"match_only_text"}],name:"full_name",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"User's full name, if available.",type:"keyword"},"user.group.domain":{dashed_name:"user-group-domain",description:"Name of the directory the group is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"user.group.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"group",short:"Name of the directory the group is a member of.",type:"keyword"},"user.group.id":{dashed_name:"user-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"user.group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"user.group.name":{dashed_name:"user-group-name",description:"Name of the group.",flat_name:"user.group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"user.hash":{dashed_name:"user-hash",description:"Unique user hash to correlate information for a user in anonymized form.\nUseful if `user.id` or `user.name` contain confidential information and cannot be used.",flat_name:"user.hash",ignore_above:1024,level:"extended",name:"hash",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Unique user hash to correlate information for a user in anonymized form.",type:"keyword"},"user.id":{dashed_name:"user-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"user.id",ignore_above:1024,level:"core",name:"id",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Unique identifier of the user.",type:"keyword"},"user.name":{dashed_name:"user-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"user.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"user.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Short name or login of the user.",type:"keyword"},"user.risk.calculated_level":{dashed_name:"user-risk-calculated-level",description:"A risk classification level calculated by an internal system as part of entity analytics and entity risk scoring.",example:"High",flat_name:"user.risk.calculated_level",ignore_above:1024,level:"extended",name:"calculated_level",normalize:[],original_fieldset:"risk",short:"A risk classification level calculated by an internal system as part of entity analytics and entity risk scoring.",type:"keyword"},"user.risk.calculated_score":{dashed_name:"user-risk-calculated-score",description:"A risk classification score calculated by an internal system as part of entity analytics and entity risk scoring.",example:880.73,flat_name:"user.risk.calculated_score",level:"extended",name:"calculated_score",normalize:[],original_fieldset:"risk",short:"A risk classification score calculated by an internal system as part of entity analytics and entity risk scoring.",type:"float"},"user.risk.calculated_score_norm":{dashed_name:"user-risk-calculated-score-norm",description:"A risk classification score calculated by an internal system as part of entity analytics and entity risk scoring, and normalized to a range of 0 to 100.",example:88.73,flat_name:"user.risk.calculated_score_norm",level:"extended",name:"calculated_score_norm",normalize:[],original_fieldset:"risk",short:"A normalized risk score calculated by an internal system.",type:"float"},"user.risk.static_level":{dashed_name:"user-risk-static-level",description:"A risk classification level obtained from outside the system, such as from some external Threat Intelligence Platform.",example:"High",flat_name:"user.risk.static_level",ignore_above:1024,level:"extended",name:"static_level",normalize:[],original_fieldset:"risk",short:"A risk classification level obtained from outside the system, such as from some external Threat Intelligence Platform.",type:"keyword"},"user.risk.static_score":{dashed_name:"user-risk-static-score",description:"A risk classification score obtained from outside the system, such as from some external Threat Intelligence Platform.",example:830,flat_name:"user.risk.static_score",level:"extended",name:"static_score",normalize:[],original_fieldset:"risk",short:"A risk classification score obtained from outside the system, such as from some external Threat Intelligence Platform.",type:"float"},"user.risk.static_score_norm":{dashed_name:"user-risk-static-score-norm",description:"A risk classification score obtained from outside the system, such as from some external Threat Intelligence Platform, and normalized to a range of 0 to 100.",example:83,flat_name:"user.risk.static_score_norm",level:"extended",name:"static_score_norm",normalize:[],original_fieldset:"risk",short:"A normalized risk score calculated by an external system.",type:"float"},"user.roles":{dashed_name:"user-roles",description:"Array of user roles at the time of the event.",example:'["kibana_admin", "reporting_user"]',flat_name:"user.roles",ignore_above:1024,level:"extended",name:"roles",normalize:["array"],otel:[{relation:"match",stability:"experimental"}],short:"Array of user roles at the time of the event.",synthetic_source_keep:"none",type:"keyword"},"user.target.domain":{dashed_name:"user-target-domain",description:"Name of the directory the user is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"user.target.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"user",short:"Name of the directory the user is a member of.",type:"keyword"},"user.target.email":{dashed_name:"user-target-email",description:"User email address.",flat_name:"user.target.email",ignore_above:1024,level:"extended",name:"email",normalize:[],original_fieldset:"user",short:"User email address.",type:"keyword"},"user.target.full_name":{dashed_name:"user-target-full-name",description:"User's full name, if available.",example:"Albert Einstein",flat_name:"user.target.full_name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"user.target.full_name.text",name:"text",type:"match_only_text"}],name:"full_name",normalize:[],original_fieldset:"user",short:"User's full name, if available.",type:"keyword"},"user.target.group.domain":{dashed_name:"user-target-group-domain",description:"Name of the directory the group is a member of.\nFor example, an LDAP or Active Directory domain name.",flat_name:"user.target.group.domain",ignore_above:1024,level:"extended",name:"domain",normalize:[],original_fieldset:"group",short:"Name of the directory the group is a member of.",type:"keyword"},"user.target.group.id":{dashed_name:"user-target-group-id",description:"Unique identifier for the group on the system/platform.",flat_name:"user.target.group.id",ignore_above:1024,level:"extended",name:"id",normalize:[],original_fieldset:"group",short:"Unique identifier for the group on the system/platform.",type:"keyword"},"user.target.group.name":{dashed_name:"user-target-group-name",description:"Name of the group.",flat_name:"user.target.group.name",ignore_above:1024,level:"extended",name:"name",normalize:[],original_fieldset:"group",short:"Name of the group.",type:"keyword"},"user.target.hash":{dashed_name:"user-target-hash",description:"Unique user hash to correlate information for a user in anonymized form.\nUseful if `user.id` or `user.name` contain confidential information and cannot be used.",flat_name:"user.target.hash",ignore_above:1024,level:"extended",name:"hash",normalize:[],original_fieldset:"user",short:"Unique user hash to correlate information for a user in anonymized form.",type:"keyword"},"user.target.id":{dashed_name:"user-target-id",description:"Unique identifier of the user.",example:"S-1-5-21-202424912787-2692429404-2351956786-1000",flat_name:"user.target.id",ignore_above:1024,level:"core",name:"id",normalize:[],original_fieldset:"user",short:"Unique identifier of the user.",type:"keyword"},"user.target.name":{dashed_name:"user-target-name",description:"Short name or login of the user.",example:"a.einstein",flat_name:"user.target.name",ignore_above:1024,level:"core",multi_fields:[{flat_name:"user.target.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"user",short:"Short name or login of the user.",type:"keyword"},"user.target.roles":{dashed_name:"user-target-roles",description:"Array of user roles at the time of the event.",example:'["kibana_admin", "reporting_user"]',flat_name:"user.target.roles",ignore_above:1024,level:"extended",name:"roles",normalize:["array"],original_fieldset:"user",short:"Array of user roles at the time of the event.",synthetic_source_keep:"none",type:"keyword"},"user_agent.device.name":{dashed_name:"user-agent-device-name",description:"Name of the device.",example:"iPhone",flat_name:"user_agent.device.name",ignore_above:1024,level:"extended",name:"device.name",normalize:[],short:"Name of the device.",type:"keyword"},"user_agent.name":{dashed_name:"user-agent-name",description:"Name of the user agent.",example:"Safari",flat_name:"user_agent.name",ignore_above:1024,level:"extended",name:"name",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Name of the user agent.",type:"keyword"},"user_agent.original":{dashed_name:"user-agent-original",description:"Unparsed user_agent string.",example:"Mozilla/5.0 (iPhone; CPU iPhone OS 12_1 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.0 Mobile/15E148 Safari/604.1",flat_name:"user_agent.original",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"user_agent.original.text",name:"text",type:"match_only_text"}],name:"original",normalize:[],otel:[{relation:"match",stability:"stable"}],short:"Unparsed user_agent string.",type:"keyword"},"user_agent.os.family":{dashed_name:"user-agent-os-family",description:"OS family (such as redhat, debian, freebsd, windows).",example:"debian",flat_name:"user_agent.os.family",ignore_above:1024,level:"extended",name:"family",normalize:[],original_fieldset:"os",short:"OS family (such as redhat, debian, freebsd, windows).",type:"keyword"},"user_agent.os.full":{dashed_name:"user-agent-os-full",description:"Operating system name, including the version or code name.",example:"Mac OS Mojave",flat_name:"user_agent.os.full",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"user_agent.os.full.text",name:"text",type:"match_only_text"}],name:"full",normalize:[],original_fieldset:"os",short:"Operating system name, including the version or code name.",type:"keyword"},"user_agent.os.kernel":{dashed_name:"user-agent-os-kernel",description:"Operating system kernel version as a raw string.",example:"4.4.0-112-generic",flat_name:"user_agent.os.kernel",ignore_above:1024,level:"extended",name:"kernel",normalize:[],original_fieldset:"os",short:"Operating system kernel version as a raw string.",type:"keyword"},"user_agent.os.name":{dashed_name:"user-agent-os-name",description:"Operating system name, without the version.",example:"Mac OS X",flat_name:"user_agent.os.name",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"user_agent.os.name.text",name:"text",type:"match_only_text"}],name:"name",normalize:[],original_fieldset:"os",short:"Operating system name, without the version.",type:"keyword"},"user_agent.os.platform":{dashed_name:"user-agent-os-platform",description:"Operating system platform (such centos, ubuntu, windows).",example:"darwin",flat_name:"user_agent.os.platform",ignore_above:1024,level:"extended",name:"platform",normalize:[],original_fieldset:"os",short:"Operating system platform (such centos, ubuntu, windows).",type:"keyword"},"user_agent.os.type":{dashed_name:"user-agent-os-type",description:"Use the `os.type` field to categorize the operating system into one of the broad commercial families.\nIf the OS you're dealing with is not listed as an expected value, the field should not be populated. Please let us know by opening an issue with ECS, to propose its addition.",example:"macos",expected_values:["linux","macos","unix","windows","ios","android"],flat_name:"user_agent.os.type",ignore_above:1024,level:"extended",name:"type",normalize:[],original_fieldset:"os",short:"Which commercial OS family (one of: linux, macos, unix, windows, ios or android).",type:"keyword"},"user_agent.os.version":{dashed_name:"user-agent-os-version",description:"Operating system version as a raw string.",example:"10.14.1",flat_name:"user_agent.os.version",ignore_above:1024,level:"extended",name:"version",normalize:[],original_fieldset:"os",short:"Operating system version as a raw string.",type:"keyword"},"user_agent.version":{dashed_name:"user-agent-version",description:"Version of the user agent.",example:12,flat_name:"user_agent.version",ignore_above:1024,level:"extended",name:"version",normalize:[],otel:[{relation:"match",stability:"experimental"}],short:"Version of the user agent.",type:"keyword"},"volume.bus_type":{dashed_name:"volume-bus-type",description:"Bus type of the device, such as `Nvme`, `Usb`, or `FileBackedVirtual`.",example:"FileBackedVirtual",flat_name:"volume.bus_type",ignore_above:1024,level:"extended",name:"bus_type",normalize:[],short:"Bus type of the device.",type:"keyword"},"volume.default_access":{dashed_name:"volume-default-access",description:"Describes the default access(es) of the volume.",flat_name:"volume.default_access",ignore_above:1024,level:"extended",name:"default_access",normalize:[],short:"Bus type of the device.",type:"keyword"},"volume.device_name":{dashed_name:"volume-device-name",description:"Full path of the volume device.\nOnly populate this field for POSIX system volumes.",flat_name:"volume.device_name",ignore_above:1024,level:"extended",name:"device_name",normalize:[],short:"Device name of the volume.",type:"keyword"},"volume.device_type":{dashed_name:"volume-device-type",description:"Volume device type.\nThe most frequently seen volume device types are `Disk File System` and `CD-ROM File System`.",example:"CD-ROM File System",flat_name:"volume.device_type",ignore_above:1024,level:"extended",name:"device_type",normalize:[],short:"Volume device type.",type:"keyword"},"volume.dos_name":{dashed_name:"volume-dos-name",description:"The MS-DOS name of a device.\nDOS device name is in the format of driver letters, such as `C:`. The field is relevant to Windows systems only.",example:"E:",flat_name:"volume.dos_name",ignore_above:1024,level:"extended",name:"dos_name",normalize:[],short:"DOS name of the device.",type:"keyword"},"volume.file_system_type":{dashed_name:"volume-file-system-type",description:"Volume device file system type.\nThe most common volume file system types are `NTFS` and `UDF`.",flat_name:"volume.file_system_type",ignore_above:1024,level:"extended",name:"file_system_type",normalize:[],short:"Volume device file system type.",type:"keyword"},"volume.mount_name":{dashed_name:"volume-mount-name",description:"Mount name of the volume device.\nOnly populate this field for POSIX system volumes.",flat_name:"volume.mount_name",ignore_above:1024,level:"extended",name:"mount_name",normalize:[],short:"Mount name of the volume.",type:"keyword"},"volume.nt_name":{dashed_name:"volume-nt-name",description:"The NT device name.\nNT device name uses a format of `\\Device\\HarddiskVolume2`. The field is relevant to Windows systems only.",example:"\\Device\\Cdrom1",flat_name:"volume.nt_name",ignore_above:1024,level:"extended",name:"nt_name",normalize:[],short:"NT name of the device.",type:"keyword"},"volume.product_id":{dashed_name:"volume-product-id",description:"ProductID of the device.\nThe vendor provides the ProductID for the volume, if any.",flat_name:"volume.product_id",ignore_above:1024,level:"extended",name:"product_id",normalize:[],short:"ProductID of the device.",type:"keyword"},"volume.product_name":{dashed_name:"volume-product-name",description:"Product name of the volume.\nThe volume device vendor provides this value.",example:"Virtual DVD-ROM",flat_name:"volume.product_name",ignore_above:1024,level:"extended",name:"product_name",normalize:[],short:"Produce name of the volume.",type:"keyword"},"volume.removable":{dashed_name:"volume-removable",description:"Indicates if the volume is removable.",flat_name:"volume.removable",level:"extended",name:"removable",normalize:[],short:"Indicates if the volume is removable.",type:"boolean"},"volume.serial_number":{dashed_name:"volume-serial-number",description:"Serial number identifier for the volume device.\nThe serial number is provided by the vendor of the device, if any.",flat_name:"volume.serial_number",ignore_above:1024,level:"extended",name:"serial_number",normalize:[],short:"Serial number of the device.",type:"keyword"},"volume.size":{dashed_name:"volume-size",description:"Size of the volume device in bytes.",flat_name:"volume.size",level:"extended",name:"size",normalize:[],short:"Size of the volume device in bytes.",type:"long"},"volume.vendor_id":{dashed_name:"volume-vendor-id",description:"VendorID of the volume device.\nThe volume device vendor provides this value.",flat_name:"volume.vendor_id",ignore_above:1024,level:"extended",name:"vendor_id",normalize:[],short:"VendorID of the device.",type:"keyword"},"volume.vendor_name":{dashed_name:"volume-vendor-name",description:"Vendor name of the volume device.\nThe value is provided by the vendor of the device.",example:"Msft",flat_name:"volume.vendor_name",ignore_above:1024,level:"extended",name:"vendor_name",normalize:[],short:"Vendor name of the device.",type:"keyword"},"volume.writable":{dashed_name:"volume-writable",description:"Indicates if the volume is writable.",flat_name:"volume.writable",level:"extended",name:"writable",normalize:[],short:"Indicates if the volume is writable.",type:"boolean"},"vulnerability.category":{dashed_name:"vulnerability-category",description:"The type of system or architecture that the vulnerability affects. These may be platform-specific (for example, Debian or SUSE) or general (for example, Database or Firewall). For example (https://qualysguard.qualys.com/qwebhelp/fo_portal/knowledgebase/vulnerability_categories.htm)\nThis field must be an array.",example:'["Firewall"]',flat_name:"vulnerability.category",ignore_above:1024,level:"extended",name:"category",normalize:["array"],short:"Category of a vulnerability.",synthetic_source_keep:"none",type:"keyword"},"vulnerability.classification":{dashed_name:"vulnerability-classification",description:"The classification of the vulnerability scoring system. For example (https://www.first.org/cvss/)",example:"CVSS",flat_name:"vulnerability.classification",ignore_above:1024,level:"extended",name:"classification",normalize:[],short:"Classification of the vulnerability.",type:"keyword"},"vulnerability.description":{dashed_name:"vulnerability-description",description:"The description of the vulnerability that provides additional context of the vulnerability. For example (https://cve.mitre.org/about/faqs.html#cve_entry_descriptions_created)",example:"In macOS before 2.12.6, there is a vulnerability in the RPC...",flat_name:"vulnerability.description",ignore_above:1024,level:"extended",multi_fields:[{flat_name:"vulnerability.description.text",name:"text",type:"match_only_text"}],name:"description",normalize:[],short:"Description of the vulnerability.",type:"keyword"},"vulnerability.enumeration":{dashed_name:"vulnerability-enumeration",description:"The type of identifier used for this vulnerability. For example (https://cve.mitre.org/about/)",example:"CVE",flat_name:"vulnerability.enumeration",ignore_above:1024,level:"extended",name:"enumeration",normalize:[],short:"Identifier of the vulnerability.",type:"keyword"},"vulnerability.id":{dashed_name:"vulnerability-id",description:"The identification (ID) is the number portion of a vulnerability entry. It includes a unique identification number for the vulnerability. For example (https://cve.mitre.org/about/faqs.html#what_is_cve_id)",example:"CVE-2019-00001",flat_name:"vulnerability.id",ignore_above:1024,level:"extended",name:"id",normalize:[],short:"ID of the vulnerability.",type:"keyword"},"vulnerability.reference":{dashed_name:"vulnerability-reference",description:"A resource that provides additional information, context, and mitigations for the identified vulnerability.",example:"https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2019-6111",flat_name:"vulnerability.reference",ignore_above:1024,level:"extended",name:"reference",normalize:[],short:"Reference of the vulnerability.",type:"keyword"},"vulnerability.report_id":{dashed_name:"vulnerability-report-id",description:"The report or scan identification number.",example:20191018.0001,flat_name:"vulnerability.report_id",ignore_above:1024,level:"extended",name:"report_id",normalize:[],short:"Scan identification number.",type:"keyword"},"vulnerability.scanner.vendor":{dashed_name:"vulnerability-scanner-vendor",description:"The name of the vulnerability scanner vendor.",example:"Tenable",flat_name:"vulnerability.scanner.vendor",ignore_above:1024,level:"extended",name:"scanner.vendor",normalize:[],short:"Name of the scanner vendor.",type:"keyword"},"vulnerability.score.base":{dashed_name:"vulnerability-score-base",description:"Scores can range from 0.0 to 10.0, with 10.0 being the most severe.\nBase scores cover an assessment for exploitability metrics (attack vector, complexity, privileges, and user interaction), impact metrics (confidentiality, integrity, and availability), and scope. For example (https://www.first.org/cvss/specification-document)",example:5.5,flat_name:"vulnerability.score.base",level:"extended",name:"score.base",normalize:[],short:"Vulnerability Base score.",type:"float"},"vulnerability.score.environmental":{dashed_name:"vulnerability-score-environmental",description:"Scores can range from 0.0 to 10.0, with 10.0 being the most severe.\nEnvironmental scores cover an assessment for any modified Base metrics, confidentiality, integrity, and availability requirements. For example (https://www.first.org/cvss/specification-document)",example:5.5,flat_name:"vulnerability.score.environmental",level:"extended",name:"score.environmental",normalize:[],short:"Vulnerability Environmental score.",type:"float"},"vulnerability.score.temporal":{dashed_name:"vulnerability-score-temporal",description:"Scores can range from 0.0 to 10.0, with 10.0 being the most severe.\nTemporal scores cover an assessment for code maturity, remediation level, and confidence. For example (https://www.first.org/cvss/specification-document)",flat_name:"vulnerability.score.temporal",level:"extended",name:"score.temporal",normalize:[],short:"Vulnerability Temporal score.",type:"float"},"vulnerability.score.version":{dashed_name:"vulnerability-score-version",description:'The National Vulnerability Database (NVD) provides qualitative severity rankings of "Low", "Medium", and "High" for CVSS v2.0 base score ranges in addition to the severity ratings for CVSS v3.0 as they are defined in the CVSS v3.0 specification.\nCVSS is owned and managed by FIRST.Org, Inc. (FIRST), a US-based non-profit organization, whose mission is to help computer security incident response teams across the world. For example (https://nvd.nist.gov/vuln-metrics/cvss)',example:2,flat_name:"vulnerability.score.version",ignore_above:1024,level:"extended",name:"score.version",normalize:[],short:"CVSS version.",type:"keyword"},"vulnerability.severity":{dashed_name:"vulnerability-severity",description:"The severity of the vulnerability can help with metrics and internal prioritization regarding remediation. For example (https://nvd.nist.gov/vuln-metrics/cvss)",example:"Critical",flat_name:"vulnerability.severity",ignore_above:1024,level:"extended",name:"severity",normalize:[],short:"Severity of the vulnerability.",type:"keyword"}},a="9.0.0"},95535:(e,t,i)=>{"use strict";i.d(t,{v:()=>o});var n=i(43059),a=i(81319),r=i(84286);function o(){const{euiTheme:e,colorMode:t}=(0,a.useEuiTheme)();return(0,r.useMemo)((()=>(0,n.getChartsTheme)(e.themeName,t)),[t,e.themeName])}},60649:(e,t,i)=>{"use strict";i.d(t,{d:()=>r});var n=i(84286),a=i(81319);const r=e=>{const t=(0,a.useEuiTheme)();return(0,n.useMemo)((()=>Object.entries(e).reduce(((e,[i,n])=>(e[i]="function"==typeof n?n(t):n,e)),{})),[t,e])}},43582:(e,t,i)=>{"use strict";function n(e){var t,i,n,a;let r,o=null===(t=e.meta)||void 0===t?void 0:t.esType;var s;return null!==(i=o)&&void 0!==i&&i.startsWith("counter_")&&(o=null===(s=o)||void 0===s?void 0:s.replace("counter_",""),r="counter"),{name:e.name,type:null!==(n=null===(a=e.meta)||void 0===a?void 0:a.type)&&void 0!==n?n:"unknown",esTypes:o?[o]:void 0,searchable:!0,aggregatable:!1,isNull:Boolean(null==e?void 0:e.isNull),...r?{timeSeriesMetric:r}:{}}}i.d(t,{N:()=>n})},82478:(e,t,i)=>{"use strict";i.d(t,{u:()=>r});var n=i(30770),a=i(43582);const r=({dataView:e,fieldName:t,columnMeta:i})=>{const r=e.fields.getByName(t);if(!i)return r;const o=(0,a.N)({name:t,id:t,meta:i});return r&&r.type===o.type&&(0,n.isEqual)(r.esTypes,o.esTypes)?r:e.fields.create(o)}},84701:(e,t,i)=>{"use strict";i.d(t,{D:()=>a});var n=i(81259);function a(e,t,i,a,r,o,s){const l=null!=o?o:"html",d={hit:t,field:r,...s};return a&&r?a.getFormatterForField(r).convert(e,l,d):i.getDefaultInstance(n.fM.STRING).convert(e,l,d)}},46009:(e,t,i)=>{"use strict";i.d(t,{A:()=>a});var n=i(9472);async function a(e,t){return e.isPersisted()?e:await t.create({...e.toSpec(),id:(0,n.v4)()},!0)}},2133:(e,t,i)=>{"use strict";i.d(t,{m:()=>a});var n=i(72927);function a(e){return{type:(0,n.m)(e),scripted:e.scripted}}},64527:(e,t,i)=>{"use strict";i.d(t,{q:()=>l});var n=i(84286),a=i.n(n),r=i(96791);const o=()=>(0,r.jsx)(n.Fragment,null),s=a().lazy((()=>i.e(5159).then(i.bind(i,25159)))),l=function(e){return(0,r.jsx)(a().Suspense,{fallback:(0,r.jsx)(o,null)},(0,r.jsx)(s,e))}},90339:(e,t,i)=>{"use strict";i.d(t,{XD:()=>a,Yr:()=>r,lI:()=>n});let n=function(e){return e.DOCUMENT="document",e.BINARY="binary",e.BOOLEAN="boolean",e.CONFLICT="conflict",e.COUNTER="counter",e.DATE="date",e.DATE_RANGE="date_range",e.DENSE_VECTOR="dense_vector",e.GAUGE="gauge",e.GEO_POINT="geo_point",e.GEO_SHAPE="geo_shape",e.HISTOGRAM="histogram",e.IP="ip",e.IP_RANGE="ip_range",e.FLATTENED="flattened",e.KEYWORD="keyword",e.MURMUR3="murmur3",e.NUMBER="number",e.NESTED="nested",e.RANK_FEATURE="rank_feature",e.RANK_FEATURES="rank_features",e.POINT="point",e.SHAPE="shape",e.SPARSE_VECTOR="sparse_vector",e.SEMANTIC_TEXT="semantic_text",e.STRING="string",e.TEXT="text",e.VERSION="version",e}({});const a=Object.values(n),r=e=>!!e&&a.includes(e)},72927:(e,t,i)=>{"use strict";i.d(t,{m:()=>a});var n=i(90339);function a(e,t){var i;const a=t?t(e):function(e){var t;return e.timeSeriesMetric||(null!==(t=e.type)&&void 0!==t?t:"string")}(e),r=(null===(i=e.esTypes)||void 0===i?void 0:i[0])||null;return r&&["_id","_index","_ignored"].includes(r)&&"string"===a?"keyword":"unknown"===a&&r&&(0,n.Yr)(r)||"string"===a&&r?r:a}},43423:(e,t,i)=>{"use strict";i.d(t,{q:()=>s});var n=i(75008),a=i(81259),r=i(90339);const o=n.i18n.translate("fieldUtils.fieldNameIcons.unknownFieldAriaLabel",{defaultMessage:"Unknown field"});function s(e){if(!e||e===a.fM.UNKNOWN)return o;if("source"===e)return n.i18n.translate("fieldUtils.fieldNameIcons.sourceFieldAriaLabel",{defaultMessage:"Source field"});const t=e;switch(t){case r.lI.DOCUMENT:return n.i18n.translate("fieldUtils.fieldNameIcons.recordAriaLabel",{defaultMessage:"Records"});case r.lI.BINARY:return n.i18n.translate("fieldUtils.fieldNameIcons.binaryAriaLabel",{defaultMessage:"Binary"});case r.lI.BOOLEAN:return n.i18n.translate("fieldUtils.fieldNameIcons.booleanAriaLabel",{defaultMessage:"Boolean"});case r.lI.CONFLICT:return n.i18n.translate("fieldUtils.fieldNameIcons.conflictFieldAriaLabel",{defaultMessage:"Conflict"});case r.lI.COUNTER:return n.i18n.translate("fieldUtils.fieldNameIcons.counterFieldAriaLabel",{defaultMessage:"Counter metric"});case r.lI.DATE:return n.i18n.translate("fieldUtils.fieldNameIcons.dateFieldAriaLabel",{defaultMessage:"Date"});case r.lI.DATE_RANGE:return n.i18n.translate("fieldUtils.fieldNameIcons.dateRangeFieldAriaLabel",{defaultMessage:"Date range"});case r.lI.DENSE_VECTOR:return n.i18n.translate("fieldUtils.fieldNameIcons.denseVectorFieldAriaLabel",{defaultMessage:"Dense vector"});case r.lI.GAUGE:return n.i18n.translate("fieldUtils.fieldNameIcons.gaugeFieldAriaLabel",{defaultMessage:"Gauge metric"});case r.lI.GEO_POINT:return n.i18n.translate("fieldUtils.fieldNameIcons.geoPointFieldAriaLabel",{defaultMessage:"Geo point"});case r.lI.GEO_SHAPE:return n.i18n.translate("fieldUtils.fieldNameIcons.geoShapeFieldAriaLabel",{defaultMessage:"Geo shape"});case r.lI.HISTOGRAM:return n.i18n.translate("fieldUtils.fieldNameIcons.histogramFieldAriaLabel",{defaultMessage:"Histogram"});case r.lI.IP:return n.i18n.translate("fieldUtils.fieldNameIcons.ipAddressFieldAriaLabel",{defaultMessage:"IP address"});case r.lI.IP_RANGE:return n.i18n.translate("fieldUtils.fieldNameIcons.ipRangeFieldAriaLabel",{defaultMessage:"IP range"});case r.lI.FLATTENED:return n.i18n.translate("fieldUtils.fieldNameIcons.flattenedFieldAriaLabel",{defaultMessage:"Flattened"});case r.lI.MURMUR3:return n.i18n.translate("fieldUtils.fieldNameIcons.murmur3FieldAriaLabel",{defaultMessage:"Murmur3"});case r.lI.NUMBER:return n.i18n.translate("fieldUtils.fieldNameIcons.numberFieldAriaLabel",{defaultMessage:"Number"});case r.lI.RANK_FEATURE:return n.i18n.translate("fieldUtils.fieldNameIcons.rankFeatureFieldAriaLabel",{defaultMessage:"Rank feature"});case r.lI.RANK_FEATURES:return n.i18n.translate("fieldUtils.fieldNameIcons.rankFeaturesFieldAriaLabel",{defaultMessage:"Rank features"});case r.lI.POINT:return n.i18n.translate("fieldUtils.fieldNameIcons.pointFieldAriaLabel",{defaultMessage:"Point"});case r.lI.SHAPE:return n.i18n.translate("fieldUtils.fieldNameIcons.shapeFieldAriaLabel",{defaultMessage:"Shape"});case r.lI.SPARSE_VECTOR:return n.i18n.translate("fieldUtils.fieldNameIcons.sparseVectorFieldAriaLabel",{defaultMessage:"Sparse vector"});case r.lI.SEMANTIC_TEXT:return n.i18n.translate("fieldUtils.fieldNameIcons.semanticTextFieldAriaLabel",{defaultMessage:"Semantic text"});case r.lI.STRING:return n.i18n.translate("fieldUtils.fieldNameIcons.stringFieldAriaLabel",{defaultMessage:"String"});case r.lI.TEXT:return n.i18n.translate("fieldUtils.fieldNameIcons.textFieldAriaLabel",{defaultMessage:"Text"});case r.lI.KEYWORD:return n.i18n.translate("fieldUtils.fieldNameIcons.keywordFieldAriaLabel",{defaultMessage:"Keyword"});case r.lI.NESTED:return n.i18n.translate("fieldUtils.fieldNameIcons.nestedFieldAriaLabel",{defaultMessage:"Nested"});case r.lI.VERSION:return n.i18n.translate("fieldUtils.fieldNameIcons.versionFieldAriaLabel",{defaultMessage:"Version"});default:return t||t}}},31936:(e,t,i)=>{"use strict";i.d(t,{q:()=>c});var n=i(3185),a=(i(84286),i(65927)),r=i.n(a),o=i(81319),s=i(96791);const l={iconType:"question",color:"gray"},d={binary:{iconType:"tokenBinary"},boolean:{iconType:"tokenBoolean"},conflict:{iconType:"warning",color:"euiColorVis9",shape:"square"},date:{iconType:"tokenDate"},date_range:{iconType:"tokenDate"},dense_vector:{iconType:"tokenVectorDense"},geo_point:{iconType:"tokenGeo"},geo_shape:{iconType:"tokenGeo"},ip:{iconType:"tokenIP"},ip_range:{iconType:"tokenIP"},flattened:{iconType:"tokenFlattened"},match_only_text:{iconType:"tokenString"},number:{iconType:"tokenNumber"},number_range:{iconType:"tokenNumber"},byte:{iconType:"tokenNumber"},double:{iconType:"tokenNumber"},float:{iconType:"tokenNumber"},half_float:{iconType:"tokenNumber"},integer:{iconType:"tokenNumber"},long:{iconType:"tokenNumber"},scaled_float:{iconType:"tokenNumber"},short:{iconType:"tokenNumber"},unsigned_long:{iconType:"tokenNumber"},murmur3:{iconType:"tokenSearchType"},rank_feature:{iconType:"tokenRankFeature"},rank_features:{iconType:"tokenRankFeatures"},histogram:{iconType:"tokenHistogram"},_source:{iconType:"editorCodeBlock",color:"gray"},point:{iconType:"tokenShape"},shape:{iconType:"tokenShape"},sparse_vector:{iconType:"tokenVectorSparse"},semantic_text:{iconType:"tokenSemanticText"},string:{iconType:"tokenString"},text:{iconType:"tokenString"},keyword:{iconType:"tokenKeyword"},gauge:{iconType:"tokenMetricGauge"},counter:{iconType:"tokenMetricCounter"},nested:{iconType:"tokenNested"},version:{iconType:"tokenTag"}};function c({type:e,label:t,size:i="s",scripted:a,className:c,...u}){const m=d[e]||l;return(0,s.jsx)(o.EuiToken,(0,n.default)({},m,{className:r()("kbnFieldIcon",c),"aria-label":t||e,title:t||e,size:i,fill:a?"dark":void 0},u))}},70042:(e,t,i)=>{"use strict";i.d(t,{C:()=>o});var n=i(84286),a=i(60288),r=i.n(a);const o=(e=!1)=>{const[t,i]=r()(e);return[t,(0,n.useMemo)((()=>({toggle:i,on:()=>i(!0),off:()=>i(!1)})),[i])]}},11978:(e,t,i)=>{"use strict";i.d(t,{k:()=>f});var n=i(84286),a=i.n(n),r=i(33467),o=i.n(r),s=i(6476),l=i.n(s),d=i(29985),c=i.n(d),u=i(80190),m=i(61215),p=i(96791);const h=new m.Storage(localStorage),f=()=>{const e=(0,n.createContext)({initialState$:new u.BehaviorSubject(void 0),initialStateRefresh$:new u.Subject,onInitialStateChange:void 0}),t=(0,n.forwardRef)((function({initialState:t,onInitialStateChange:i,children:a},r){const s=o()(t),[l]=(0,n.useState)((()=>new u.BehaviorSubject(s.current))),[d]=(0,n.useState)((()=>new u.Subject)),c=g((e=>{l.next(e),null==i||i(e)}));(0,n.useImperativeHandle)(r,(()=>({refreshInitialState:()=>{l.next(s.current),d.next(l.getValue())}})),[l,d,s]);const m=(0,n.useMemo)((()=>({initialState$:l,initialStateRefresh$:d,onInitialStateChange:c})),[l,d,c]);return(0,p.jsx)(e.Provider,{value:m},a)})),i=(e,t,i,n)=>!e||!(t in e)||null!=n&&n(e[t])?"function"==typeof i?i():i:e[t],r=(t,a,r,s)=>{const{initialStateRefresh$:l}=(0,n.useContext)(e),d=o()(a),c=o()(s),m=g(r);(0,n.useEffect)((()=>{const e=l.pipe((0,u.map)((e=>i(e,t,d.current,c.current)))).subscribe(m);return()=>{e.unsubscribe()}}),[l,t,c,d,m])},s=(t,a,o)=>{const{shouldIgnoredRestoredValue:s,shouldStoreDefaultValueRightAway:l}=o||{},{initialState$:d,onInitialStateChange:u}=(0,n.useContext)(e),[m,p]=(0,n.useState)((()=>i(d.getValue(),t,a,s))),h=g((e=>{p((i=>{const n="function"==typeof e?e(i):e;return null==u||u({...d.getValue(),[t]:n}),n}))}));return c()((()=>{const e=d.getValue();l&&m!==(null==e?void 0:e[t])&&(null==u||u({...e,[t]:m}))})),r(t,a,p,s),[m,h]};return{withRestorableState:e=>{const i=a().memo(e);return(0,n.forwardRef)((function({initialState:a,onInitialStateChange:r,...o},s){var l;const d=(0,n.useRef)(null),c=(0,n.useRef)(null);(0,n.useImperativeHandle)(s,(()=>({...c.current||{},...d.current||{}})));const u={...o,..."function"!=typeof e||(null===(l=e.prototype)||void 0===l?void 0:l.isReactComponent)?{ref:c}:{}};return(0,p.jsx)(t,{ref:d,initialState:a,onInitialStateChange:r},(0,p.jsx)(i,u))}))},useRestorableState:s,useRestorableRef:(t,a,o)=>{const{shouldStoreDefaultValueRightAway:s}=o||{},{initialState$:d,onInitialStateChange:u}=(0,n.useContext)(e),m=d.getValue(),p=(0,n.useRef)(i(m,t,a));return c()((()=>{const e=p.current,i=d.getValue();s&&e!==(null==i?void 0:i[t])&&(null==u||u({...i,[t]:e}))})),l()((()=>{null==u||u({...d.getValue(),[t]:p.current})})),r(t,a,(e=>{p.current=e})),p},useRestorableLocalStorage:(e,t,i)=>{var n;const[a,r]=s(e,null!==(n=h.get(t))&&void 0!==n?n:i,{shouldStoreDefaultValueRightAway:!0});return[a,g((e=>{r((i=>{const n="function"==typeof e?e(i):e;return h.set(t,n),n}))}))]}}},g=e=>{const t=o()(e),[i]=(0,n.useState)((()=>(...e)=>t.current(...e)));return i}},82708:(e,t,i)=>{"use strict";i.d(t,{L$:()=>r,Ov:()=>a});var n=i(62953);const a={APM:"apm",LOGS:"logs",INFRASTRUCTURE:"infrastructure",OBSERVABILITY:"observability",STREAMS:"streams",SLO:"slo",SIEM:"siem",UPTIME:"uptime",ML:"ml",STACK_ALERTS:"stackAlerts",EXAMPLE:"AlertingExample",MONITORING:"monitoring",ALERTS:"alerts",DISCOVER:"discover"},r=(a.OBSERVABILITY,Object.values(a).map((e=>e)),e=>e.startsWith("siem.")||e===n.ZJ)},51363:(e,t,i)=>{"use strict";i.d(t,{$9:()=>M,C6:()=>l,Ii:()=>A,Ip:()=>k,J0:()=>h,JJ:()=>C,M8:()=>d,MT:()=>f,NW:()=>a,PP:()=>c,TL:()=>y,Tm:()=>P,W8:()=>L,Zu:()=>w,aT:()=>p,bv:()=>j,fN:()=>_,gp:()=>s,hK:()=>m,iL:()=>o,ir:()=>r,jT:()=>u,ji:()=>F,nw:()=>T,op:()=>g,qO:()=>x,rj:()=>E,tJ:()=>v,u8:()=>b,uT:()=>D,wO:()=>I,yi:()=>S});var n=i(69219);const a="ecs.version",r="event.action",o="event.kind",s="tags",l=`${n.zt}.risk_score`,d=`${n.gH}.author`,c=`${n.gH}.created_at`,u=`${n.gH}.created_by`,m=`${n.gH}.description`,p=`${n.gH}.enabled`,h=`${n.gH}.from`,f=`${n.gH}.interval`,g=`${n.gH}.license`,y=`${n.gH}.note`,v=`${n.gH}.references`,_=`${n.gH}.rule_id`,b=`${n.gH}.rule_name_override`,x=`${n.gH}.to`,w=`${n.gH}.type`,k=`${n.gH}.updated_at`,S=`${n.gH}.updated_by`,T=`${n.gH}.version`,E=`${n.zt}.severity`,z=`${n.zt}.suppression`,j=`${z}.terms`,I=`${j}.field`,C=`${j}.value`,A=`${z}.start`,F=`${z}.end`,M=`${z}.docs_count`,D=`${n.zt}.system_status`,L=`${n.zt}.workflow_reason`,P=`${n.zt}.workflow_user`},4451:(e,t,i)=>{"use strict";i.d(t,{$:()=>o});var n=i(43782),a=i(9472),r=i(74233);const o=new n.Type("DefaultUuid",n.string.is,((e,t)=>null==e?n.success((0,a.v4)()):r.u.validate(e,t)),n.identity)},89981:(e,t,i)=>{"use strict";i.d(t,{l:()=>u});var n=i(3185),a=i(11728),r=i(84286),o=i.n(r),s=i(81319),l=i(96791),d={name:"1azakc",styles:"text-align:center"};const c=()=>{const e=d;return(0,l.jsx)("div",{css:e},(0,l.jsx)(s.EuiLoadingSpinner,null))},u=(e,t=(0,l.jsx)(c,null))=>o().forwardRef(((i,o)=>(0,l.jsx)(a.KibanaErrorBoundaryProvider,{analytics:i.analytics},(0,l.jsx)(a.KibanaErrorBoundary,null,(0,l.jsx)(r.Suspense,{fallback:t},(0,l.jsx)(e,(0,n.default)({},i,{ref:o})))))))},17992:(e,t,i)=>{"use strict";i.d(t,{R7:()=>l,gu:()=>s});var n=i(84286),a=i.n(n),r=i(81319),o=i(96791);const s=e=>{const{leftSide:t,bottomSection:i,toolbarProps:{hasRoomForGridControls:n,columnControl:s,columnSortingControl:d,fullScreenControl:c,keyboardShortcutsControl:u,displayControl:m},gridProps:{additionalControls:p,inTableSearchControl:h}}=e,f=n?(0,o.jsx)(a().Fragment,null,t&&p&&(0,o.jsx)(r.EuiFlexItem,{grow:!1},(0,o.jsx)("div",null,p)),s&&(0,o.jsx)(r.EuiFlexItem,{grow:!1},(0,o.jsx)("div",{className:"unifiedDataTableToolbarControlButton",css:l.controlButton},s)),d&&(0,o.jsx)(r.EuiFlexItem,{grow:!1},(0,o.jsx)("div",{className:"unifiedDataTableToolbarControlButton",css:l.controlButton},d)),!t&&p&&(0,o.jsx)(r.EuiFlexItem,{grow:!1},(0,o.jsx)("div",null,p))):null;return(0,o.jsx)(a().Fragment,null,(0,o.jsx)(r.EuiFlexGroup,{responsive:!1,gutterSize:"s",justifyContent:"spaceBetween",alignItems:"center",className:"unifiedDataTableToolbar",css:l.toolbar,"data-test-subj":"unifiedDataTableToolbar",wrap:!0},(0,o.jsx)(r.EuiFlexItem,{grow:!1},t||(0,o.jsx)(r.EuiFlexGroup,{responsive:!1,gutterSize:"s",alignItems:"center"},f)),(0,o.jsx)(r.EuiFlexItem,{grow:!1},(0,o.jsx)(r.EuiFlexGroup,{responsive:!1,gutterSize:"s",alignItems:"center"},Boolean(t)&&f,Boolean(u||m||c||h)&&(0,o.jsx)(r.EuiFlexItem,{grow:!1},(0,o.jsx)("div",{className:"unifiedDataTableToolbarControlGroup",css:l.controlGroup},Boolean(h)&&(0,o.jsx)("div",{className:"unifiedDataTableToolbarControlIconButton",css:l.controlGroupIconButton},h),Boolean(u)&&(0,o.jsx)("div",{className:"unifiedDataTableToolbarControlIconButton",css:l.controlGroupIconButton},u),Boolean(m)&&(0,o.jsx)("div",{className:"unifiedDataTableToolbarControlIconButton",css:l.controlGroupIconButton},m),Boolean(c)&&(0,o.jsx)("div",{className:"unifiedDataTableToolbarControlIconButton",css:l.controlGroupIconButton},c)))))),i?(0,o.jsx)("div",{className:"unifiedDataTableToolbarBottom",css:l.toolbarBottom,"data-test-subj":"unifiedDataTableToolbarBottom"},i):null)},l={toolbar:({euiTheme:e})=>(0,o.css)({padding:`${e.size.s} ${e.size.s} ${e.size.xs}`},"",""),controlButton:({euiTheme:e})=>e?(0,o.css)({".euiDataGridToolbarControl":{blockSize:e.size.xl,border:`${e.border.width.thin} solid ${e.colors.backgroundBaseFormsControlDisabled}`,borderRadius:e.border.radius.small,"& svg":{inlineSize:e.size.base,blockSize:e.size.base}}},"",""):void 0,controlGroup:({euiTheme:e})=>e?(0,o.css)({position:"relative",overflow:"hidden",borderRadius:e.border.radius.small,display:"inline-flex",alignItems:"stretch",flexDirection:"row","&::after":{content:'""',position:"absolute",inset:0,border:`${e.border.width.thin} solid ${e.colors.borderBasePlain}`,borderRadius:"inherit",pointerEvents:"none"},"& .unifiedDataTableToolbarControlIconButton .euiDataGridToolbarControl":{borderRadius:0,border:"none"},"& .unifiedDataTableToolbarControlIconButton + .unifiedDataTableToolbarControlIconButton":{borderInlineStart:`${e.border.width.thin} solid ${e.colors.borderBasePlain}`},"& .unifiedDataTableToolbarControlButton .euiDataGridToolbarControl":{borderRadius:0,border:"none"},"& .unifiedDataTableToolbarControlButton + .unifiedDataTableToolbarControlButton":{borderInlineStart:`${e.border.width.thin} solid ${e.colors.borderBasePlain}`,borderRadius:0}},"",""):void 0,controlGroupIconButton:({euiTheme:e})=>(0,o.css)({".euiToolTipAnchor .euiButtonIcon":{inlineSize:e.size.xl,blockSize:e.size.xl,borderRadius:"inherit","&:hover, &:active, &:focus":{background:"transparent",animation:"none !important",transform:"none !important"}}},"",""),toolbarBottom:{name:"bjn8wh",styles:"position:relative"}}},91228:(e,t,i)=>{"use strict";i.d(t,{YP:()=>ni,ZZ:()=>oi});var n=i(84286),a=i.n(n),r=i(65927),o=i.n(r),s=i(75879),l=i(96791),d=i(81319),c=i(60649),u=i(90855),m=i(55964);var p=i(46009),h=i(33467),f=i.n(h),g=i(72644),y=i.n(g),v=i(75008),_=i(22874);function b({rowIndex:e,inTableSearchTerm:t,visibleColumns:i,renderCellValue:r,onRowProcessed:o}){const s=r,d=(0,n.useRef)(),c=(0,n.useRef)({}),u=(0,n.useRef)(0),m=(0,n.useRef)(i.length),p=(0,n.useRef)(!1),[h,f]=(0,n.useState)(!1),g=(0,n.useCallback)((()=>{p.current||(p.current=!0,o({rowIndex:e,rowMatchesCount:u.current,matchesCountPerColumnId:c.current}))}),[e,o]),y=(0,n.useRef)();y.current=g;const v=(0,n.useCallback)(((e,t)=>{m.current=m.current-1,t>0&&(c.current[e]=t,u.current+=t),0===m.current&&g()}),[g]);return(0,n.useEffect)((()=>(d.current&&clearTimeout(d.current),d.current=setTimeout((()=>{var e;null===(e=y.current)||void 0===e||e.call(y),f(!0)}),2e3),()=>{d.current&&clearTimeout(d.current)})),[e,f]),h?null:(0,l.jsx)(a().Fragment,null,i.map(((i,n)=>(0,l.jsx)(ErrorBoundary,{key:`${e}-${i}`,onError:()=>{v(i,0)}},(0,l.jsx)(s,{columnId:i,rowIndex:e,isExpandable:!1,isExpanded:!1,isDetails:!1,colIndex:n,setCellProps:x,inTableSearchTerm:t,onHighlightsCountFound:e=>{v(i,e)}})))))}class ErrorBoundary extends a().Component{constructor(e){super(e),this.state={hasError:!1}}static getDerivedStateFromError(){return{hasError:!0}}componentDidCatch(){var e,t;null===(e=(t=this.props).onError)||void 0===e||e.call(t)}render(){return this.state.hasError?null:this.props.children}}function x(){}function w(e){const{inTableSearchTerm:t,visibleColumns:i,renderCellValue:r,rowsCount:o,onFinish:s}=e,d=(0,n.useRef)([]),c=(0,n.useRef)(0),u=Math.min(10,o),[{chunkStartRowIndex:m,chunkSize:p},h]=(0,n.useState)({chunkStartRowIndex:0,chunkSize:u}),f=(0,n.useRef)({}),g=(0,n.useRef)(u),y=(0,n.useCallback)((e=>{if(e.rowMatchesCount>0&&(c.current+=e.rowMatchesCount,f.current[e.rowIndex]=e),g.current-=1,g.current>0)return;Object.keys(f.current).sort(((e,t)=>Number(e)-Number(t))).forEach((e=>{d.current.push(f.current[Number(e)])}));const i=m+p;if(i<o){const e=Math.min(100,p+10),t=Math.min(e,o-i);f.current={},g.current=t,h({chunkStartRowIndex:i,chunkSize:t})}else s({term:t,matchesList:d.current,totalMatchesCount:c.current})}),[h,m,p,o,s,t]);return(0,l.jsx)(a().Fragment,null,Array.from({length:p}).map(((e,n)=>{const a=m+n;return(0,l.jsx)(b,{key:a,rowIndex:a,inTableSearchTerm:t,visibleColumns:i,renderCellValue:r,onRowProcessed:y})})))}function k(e){const t=(0,n.useRef)(document.createDocumentFragment());return(0,n.useEffect)((()=>()=>{t.current&&((0,_.unmountComponentAtNode)(t.current),t.current=null)}),[]),t.current?(0,_.createPortal)((0,l.jsx)(w,e),t.current):null}const S={term:"",matchesList:[],matchesCount:null,activeMatchPosition:null,columns:[],isProcessing:!1,renderCellsShadowPortal:null};let T=null;function E({animate:e=!0,term:t,matchPosition:i,matchesList:n,columns:a,onScrollToActiveMatch:r,onInitialStateChange:o}){"number"==typeof i&&(T&&clearTimeout(T),T=setTimeout((()=>{const s=function({matchPosition:e,matchesList:t,columns:i}){let n=0;for(const r of t){const t=r.rowIndex;if(n+r.rowMatchesCount<e){n+=r.rowMatchesCount;continue}const o=r.matchesCountPerColumnId;for(const r of i){var a;const i=null!==(a=o[r])&&void 0!==a?a:0;if(n<e&&n+i>=e)return{rowIndex:Number(t),columnId:r,matchIndexWithinCell:e-n-1,matchPosition:e};n+=i}}return null}({matchPosition:i,matchesList:n,columns:a});s&&r(s,e),e&&(null==o||o({searchTerm:t,activeMatch:s||void 0}))}),0))}function z(e,t,i,n){if("number"!=typeof e.matchesCount||!e.activeMatchPosition||e.isProcessing)return e;let a="prev"===t?e.activeMatchPosition-1:e.activeMatchPosition+1;return a<1?a=e.matchesCount:a>e.matchesCount&&(a=1),E({term:e.term,matchPosition:a,matchesList:e.matchesList,columns:e.columns,onScrollToActiveMatch:i,onInitialStateChange:n}),{...e,activeMatchPosition:a}}var j=i(97536);const I="data-match-index",C="dataGridInTableSearch__match",A="inTableSearchInput",F=a().memo((({initialInTableSearchTerm:e,matchesCount:t,activeMatchPosition:i,isProcessing:a,goToPrevMatch:r,goToNextMatch:o,onChangeSearchTerm:s,onHideInput:c})=>{const{inputValue:u,handleInputChange:m}=(0,j.o)({onChange:s,value:e||""},{allowFalsyValue:!0}),p=(0,n.useCallback)((e=>{const t=e.target.value;m(t)}),[m]),h=(0,n.useCallback)((e=>{e.key!==d.keys.ESCAPE?e.key===d.keys.ENTER&&e.shiftKey?r():e.key===d.keys.ENTER&&o():c(!0)}),[r,o,c]),f=(0,n.useCallback)((e=>{e.relatedTarget&&"clearSearchButton"===e.relatedTarget.getAttribute("data-test-subj")||u||c()}),[c,u]),g=!t||a;return(0,l.jsx)(d.EuiFieldSearch,{autoFocus:!0,compressed:!0,className:"dataGridInTableSearch__input","data-test-subj":A,isClearable:!a,isLoading:a,append:(0,l.jsx)(d.EuiFlexGroup,{responsive:!1,alignItems:"center",gutterSize:"none"},(0,l.jsx)(d.EuiFlexItem,{grow:!1,className:"dataGridInTableSearch__matchesCounter","data-test-subj":"inTableSearchMatchesCounter"},(0,l.jsx)(d.EuiText,{color:"subdued",size:"s"},t&&i?`${i}/${t}`:"0/0")),(0,l.jsx)(d.EuiFlexItem,{grow:!1},(0,l.jsx)(d.EuiButtonIcon,{iconType:"arrowUp",color:"text","data-test-subj":"inTableSearchButtonPrev",disabled:g,"aria-label":v.i18n.translate("dataGridInTableSearch.buttonPreviousMatch",{defaultMessage:"Previous"}),onClick:r})),(0,l.jsx)(d.EuiFlexItem,{grow:!1},(0,l.jsx)(d.EuiButtonIcon,{iconType:"arrowDown",color:"text","data-test-subj":"inTableSearchButtonNext",disabled:g,"aria-label":v.i18n.translate("dataGridInTableSearch.buttonNextMatch",{defaultMessage:"Next"}),onClick:o}))),placeholder:v.i18n.translate("dataGridInTableSearch.inputPlaceholder",{defaultMessage:"Find in table"}),value:u,onChange:p,onKeyUp:h,onBlur:f})})),M="#ffc30e",D=e=>{const t=e.themeName.toLowerCase().includes("amsterdam");return{highlightColor:t?e.colors.plainDark:e.colors.textAccent,highlightBackgroundColor:t?"#e5ffc0":e.colors.backgroundLightAccent,activeHighlightColor:t?e.colors.plainDark:e.colors.textInverse,activeHighlightBackgroundColor:t?M:e.colors.backgroundFilledAccent,activeHighlightBorderColor:t?M:e.colors.borderStrongAccent}},L=({activeMatch:e,colors:t})=>{const{rowIndex:i,columnId:n,matchIndexWithinCell:a}=e;return(0,l.css)(".euiDataGridRowCell[data-gridcell-row-index='",i,"'][data-gridcell-column-id='",n,"']{&:after{content:'';z-index:2;pointer-events:none;position:absolute;inset:0;border:2px solid ",t.activeHighlightBorderColor,"!important;border-radius:3px;}.",C,"[",I,"='",a,"']{color:",t.activeHighlightColor,"!important;background-color:",t.activeHighlightBackgroundColor,"!important;}}","")},P={name:"q70kxz",styles:"position:relative;z-index:1;.dataGridInTableSearch__matchesCounter{font-variant-numeric:tabular-nums;}.dataGridInTableSearch__input{min-width:210px;}.euiFormControlLayout__append{padding-inline-end:0!important;background:none;}.unifiedDataTableToolbarControlIconButton & .euiFormControlLayout,.unifiedDataTableToolbarControlIconButton & .dataGridInTableSearch__input{border-top-right-radius:0;border-bottom-right-radius:0;border-right:0;&::after{border-right:0;}}"},N=({initialState:e,pageSize:t,getColumnIndexFromId:i,scrollToCell:r,shouldOverrideCmdF:o,onChange:s,onChangeCss:c,onChangeToExpectedPage:u,...m})=>{const{euiTheme:p}=(0,d.useEuiTheme)(),h=(0,n.useMemo)((()=>D(p)),[p]),f=(0,n.useRef)(null),g=(0,n.useRef)(null),_=(0,n.useRef)(!1),[b,x]=(0,n.useState)(Boolean(m.inTableSearchTerm)),w=(0,n.useCallback)(((e,n)=>{const{rowIndex:a,columnId:o}=e;if("number"==typeof t&&n){const e=Math.floor(a/t);u(e)}c(L({activeMatch:e,colors:h})),n&&r({rowIndex:"number"==typeof t?a%t:a,columnIndex:i(o),align:"center"})}),[i,r,c,u,t,h]),{matchesCount:T,activeMatchPosition:j,isProcessing:I,goToPrevMatch:C,goToNextMatch:M,renderCellsShadowPortal:N,resetState:R}=(e=>{var t;const{initialState:i,onInitialStateChange:a,inTableSearchTerm:r,visibleColumns:o,rows:s,renderCellValue:d,onScrollToActiveMatch:c}=e,u=(0,n.useRef)(null!=i&&null!==(t=i.activeMatch)&&void 0!==t&&t.matchPosition&&(null==i?void 0:i.searchTerm)===r?i.activeMatch.matchPosition:void 0),[m,p]=(0,n.useState)(S),{matchesCount:h,activeMatchPosition:f,isProcessing:g,renderCellsShadowPortal:y}=m,v=(0,n.useRef)(0);(0,n.useEffect)((()=>{if(v.current+=1,null==s||!s.length||null==r||!r.length)return void p(S);const e=v.current,t=({term:t,matchesList:i,totalMatchesCount:n})=>{if(e<v.current)return;const r=u.current;u.current=void 0;const s=n>0?null!=r?r:1:null;p({term:t,matchesList:i,matchesCount:n,activeMatchPosition:s,columns:o,isProcessing:!1,renderCellsShadowPortal:null}),n>0?E({term:t,animate:!r,matchPosition:s,matchesList:i,columns:o,onScrollToActiveMatch:c,onInitialStateChange:a}):null==a||a({searchTerm:t,activeMatch:void 0})},i=()=>(0,l.jsx)(k,{key:e,inTableSearchTerm:r,rowsCount:s.length,visibleColumns:o,renderCellValue:d,onFinish:t});p((e=>({...e,term:r,isProcessing:!0,renderCellsShadowPortal:i})))}),[p,d,o,s,r,c,a]);const _=(0,n.useCallback)((()=>{p((e=>z(e,"prev",c,a)))}),[p,c,a]),b=(0,n.useCallback)((()=>{p((e=>z(e,"next",c,a)))}),[p,c,a]),x=(0,n.useCallback)((()=>{p(S),null==a||a({searchTerm:void 0,activeMatch:void 0})}),[p,a]);return(0,n.useMemo)((()=>({matchesCount:h,activeMatchPosition:f,goToPrevMatch:_,goToNextMatch:b,resetState:x,isProcessing:g,renderCellsShadowPortal:y})),[h,f,_,b,x,g,y])})({...m,initialState:e,onScrollToActiveMatch:w}),O=(0,n.useCallback)((()=>{x(!0)}),[x]),q=(0,n.useCallback)(((e=!1)=>{x(!1),R(),_.current=e}),[x,R]),V=(0,n.useCallback)((e=>{var t,i;(e.metaKey||e.ctrlKey)&&"f"===e.key&&o(e.target)&&(e.preventDefault(),O(),null===(t=f.current)||void 0===t||null===(i=t.querySelector(`[data-test-subj="${A}"]`))||void 0===i||i.focus())}),[O,o]);return y()("keydown",V),(0,n.useEffect)((()=>{var e;_.current&&!b&&(_.current=!1,null===(e=g.current)||void 0===e||e.focus())}),[b]),(0,l.jsx)("div",{ref:e=>f.current=e,css:P},b?(0,l.jsx)(a().Fragment,null,(0,l.jsx)(F,{initialInTableSearchTerm:null==e?void 0:e.searchTerm,matchesCount:T,activeMatchPosition:j,isProcessing:I,goToPrevMatch:C,goToNextMatch:M,onChangeSearchTerm:s,onHideInput:q}),N?N():null):(0,l.jsx)(d.EuiToolTip,{content:v.i18n.translate("dataGridInTableSearch.inputPlaceholder",{defaultMessage:"Find in table"}),delay:"long"},(0,l.jsx)(d.EuiButtonIcon,{"data-test-subj":"startInTableSearchButton",buttonRef:g,iconType:"search",size:"xs",color:"text",className:"dataGridInTableSearch__button","aria-label":v.i18n.translate("dataGridInTableSearch.buttonSearch",{defaultMessage:"Find in table"}),css:(0,l.css)("min-height:calc(2 * ",p.size.base,");",""),onClick:O})))};var R=i(30770);const O=({inTableSearchTerm:e,highlightColor:t,highlightBackgroundColor:i,onHighlightsCountFound:a,children:r})=>{const o=(0,n.useRef)(null),s=(0,n.useRef)(null),d=Boolean(a),c=(0,n.useRef)(d);return(0,n.useEffect)((()=>{if(e&&o.current){const n=o.current,r=()=>{const r=function(e,t,i,n,a){let r=0;const o=V(t);return Array.from(e.childNodes).forEach((function e(t){if(t.nodeType!==Node.ELEMENT_NODE){if(t.nodeType===Node.TEXT_NODE){const e=t,s=e.textContent||"";if(a){const e=(s.match(o)||[]).length;return void(r+=e)}const l=s.split(o);if(l.length>1){const t=document.createDocumentFragment();l.forEach((function(e){if(o.test(e)){const a=document.createElement("mark");a.textContent=e,a.style.color=i,a.style.backgroundColor=n,a.setAttribute("class",C),a.setAttribute(I,""+r++),t.appendChild(a)}else t.appendChild(document.createTextNode(e))})),e.replaceWith(t)}}}else Array.from(t.childNodes).forEach(e)})),r}(n,e,t,i,d);c.current&&(c.current=!1,null==a||a(r))};s.current&&clearTimeout(s.current),s.current=setTimeout(r,0)}}),[d,e,t,i,r,a]),(0,l.jsx)("div",{ref:o},r)},q=new Map,V=e=>{if(q.has(e))return q.get(e);const t=new RegExp(`(${(0,R.escapeRegExp)(e.trim())})`,"gi");return q.set(e,t),t},U=()=>{q.clear()};var B=i(6476),H=i.n(B),$=i(82478),G=i(50838),W=i(66806);const Q={[W.Rd.COMPACT]:W.Wn,[W.Rd.NORMAL]:W.MI,[W.Rd.EXPANDED]:W.Og},Y=e=>`${e}:dataGridDensity`;var J=i(42526),K=i(7195),Z=i(84701);const X=(e,t)=>t?JSON.stringify(e):JSON.stringify(e,null,2),ee=(0,K.createEscapeValue)({separator:",",quoteValues:!0,escapeFormulaValues:!0}),te=({rowIndex:e,rows:t,columnId:i,dataView:n,fieldFormats:a,columnsMeta:r,options:o})=>{if(!t[e])return{formattedString:"",withFormula:!1};const s=t[e].flattened,l=null==s?void 0:s[i];return(({dataView:e,dataViewField:t,flattenedValue:i,dataTableRecord:n,fieldFormats:a,options:r})=>{var o,s;const l=null!==(o=null==r?void 0:r.compatibleWithCSV)&&void 0!==o&&o;if("_source"===(null==t?void 0:t.type))return{formattedString:X(n.flattened,l),withFormula:!1};const d=Array.isArray(i)?i:[i],c=null!==(s=null==r?void 0:r.compatibleWithCSV)&&void 0!==s&&s;let u=!1;return{formattedString:d.map((i=>{const r=(0,Z.D)(i,n.raw,a,e,t,"text",{skipFormattingInStringifiedJSON:l});return"string"==typeof r?(u=u||(0,K.cellHasFormulas)(r),c?(e=>ee(e))(r):r):X(r,l)||""})).join(", "),withFormula:u}})({dataView:n,dataViewField:(0,$.u)({fieldName:i,dataView:n,columnMeta:null==r?void 0:r[i]}),flattenedValue:l,dataTableRecord:t[e],fieldFormats:a,options:o})},ie=e=>({formattedString:ae(e),withFormula:(0,K.cellHasFormulas)(e)}),ne=(0,K.createEscapeValue)({separator:",",quoteValues:!0,escapeFormulaValues:!0}),ae=e=>ne(e);var re=i(81091),oe=i(95085);const se=({rowIndex:e,setCellProps:t})=>{const{expanded:i,getRowByIndex:a}=(0,n.useContext)(oe.o),r=(0,n.useMemo)((()=>a(e)),[a,e]);return(0,n.useEffect)((()=>{null!=r&&r.isAnchor?t({className:"unifiedDataTable__cell--highlight"}):i&&r&&i.id===r.id?t({className:"unifiedDataTable__cell--expanded"}):t({className:""})}),[i,r,t]),(0,n.useMemo)((()=>({record:r,rowIndex:e})),[r,e])},le=e=>{const{record:t,rowIndex:i}=se(e),a=(0,n.useRef)(null),[r,o]=(0,n.useState)(!1),{expanded:s,setExpanded:c,componentsTourSteps:u}=(0,n.useContext)(oe.o),m=u?u.expandButton:void 0,p=t===s,h=v.i18n.translate("unifiedDataTable.grid.viewDoc",{defaultMessage:"Toggle dialog with details"}),f=null!=t&&t.isAnchor?"docTableExpandToggleColumnAnchor":"docTableExpandToggleColumn";return(0,n.useEffect)((()=>{!p&&r&&(o(!1),setTimeout((()=>{var e;null===(e=a.current)||void 0===e||e.hideToolTip()}),100))}),[p,o,r]),c&&t?(0,l.jsx)(d.EuiToolTip,{content:h,delay:"long",ref:a,anchorClassName:"unifiedDataTable__rowControl",disableScreenReaderOutput:!0},(0,l.jsx)(d.EuiButtonIcon,{id:0===i?m:void 0,size:"xs",iconSize:"s","aria-label":h,"data-test-subj":f,onClick:()=>{var e;const i=p?void 0:t;null===(e=a.current)||void 0===e||e.hideToolTip(),o(Boolean(i)),null==c||c(i)},color:p?"primary":"text",iconType:p?"minimize":"expand",isSelected:p})):null},de=v.i18n.translate("unifiedDataTable.copyEscapedValueWithFormulasToClipboardWarningText",{defaultMessage:"Values may contain formulas that are escaped."}),ce=v.i18n.translate("unifiedDataTable.copyFailedErrorText",{defaultMessage:"Unable to copy to clipboard in this browser"});function ue(e,t,i,n,a){const r=e.getRowByIndex(t);if(r&&a&&e.onFilter){const t=r.flattened[i];e.onFilter(a,t,n)}}const me=v.i18n.translate("unifiedDataTable.grid.esqlMultivalueFilteringDisabled",{defaultMessage:"Multivalue filtering is not supported in ES|QL"});function pe(e,t,i,a,r){return[...r&&e.filterable?[i=>(({cellActionProps:{Component:e,rowIndex:t,columnId:i},field:a,isPlainRecord:r})=>{var o;const s=(0,n.useContext)(oe.o),d=r&&Array.isArray(null===(o=s.getRowByIndex(t))||void 0===o?void 0:o.flattened[i]),c=v.i18n.translate("unifiedDataTable.grid.filterForAria",{defaultMessage:"Filter for this {value}",values:{value:i}});return(0,l.jsx)(e,{onClick:()=>{ue(s,t,i,"+",a)},iconType:"plusInCircle","aria-label":c,title:d?me:c,disabled:d,"data-test-subj":"filterForButton"},v.i18n.translate("unifiedDataTable.grid.filterFor",{defaultMessage:"Filter for"}))})({cellActionProps:i,field:e,isPlainRecord:t}),i=>(({cellActionProps:{Component:e,rowIndex:t,columnId:i},field:a,isPlainRecord:r})=>{var o;const s=(0,n.useContext)(oe.o),d=r&&Array.isArray(null===(o=s.getRowByIndex(t))||void 0===o?void 0:o.flattened[i]),c=v.i18n.translate("unifiedDataTable.grid.filterOutAria",{defaultMessage:"Filter out this {value}",values:{value:i}});return(0,l.jsx)(e,{onClick:()=>{ue(s,t,i,"-",a)},iconType:"minusInCircle","aria-label":c,title:d?me:c,disabled:d,"data-test-subj":"filterOutButton"},v.i18n.translate("unifiedDataTable.grid.filterOut",{defaultMessage:"Filter out"}))})({cellActionProps:i,field:e,isPlainRecord:t})]:[],({Component:e,rowIndex:t,columnId:n})=>function({Component:e,rowIndex:t,columnId:i},n,a){const r=v.i18n.translate("unifiedDataTable.grid.copyClipboardButtonTitle",{defaultMessage:"Copy value of {column}",values:{column:i}});return(0,l.jsx)(e,{onClick:()=>{(({rowIndex:e,columnId:t,toastNotifications:i,valueToStringConverter:n})=>{const a=n(e,t),r=a.formattedString;if(!(0,d.copyToClipboard)(r))return i.addWarning({title:ce}),null;const o=v.i18n.translate("unifiedDataTable.copyValueToClipboard.toastTitle",{defaultMessage:"Copied to clipboard"});a.withFormula?i.addWarning({title:o,text:de}):i.addInfo({title:o})})({rowIndex:t,columnId:i,valueToStringConverter:a,toastNotifications:n})},iconType:"copyClipboard","aria-label":r,title:r,"data-test-subj":"copyClipboardButton"},v.i18n.translate("unifiedDataTable.grid.copyCellValueButton",{defaultMessage:"Copy value"}))}({Component:e,rowIndex:t,columnId:n},i,a)]}var he=i(81259);const fe=({rows:e,toastNotifications:t,columns:i,onCompleted:a})=>{const[r,o]=(0,n.useState)(!1),{valueToStringConverter:c,dataView:u,selectedDocsState:m}=(0,n.useContext)(oe.o),{isDocSelected:p}=m;return(0,l.jsx)(d.EuiContextMenuItem,{"data-test-subj":"unifiedDataTableCopyRowsAsText",icon:"copyClipboard",disabled:r,onClick:async()=>{o(!0);const n=i.reduce(((t,i)=>{if("_source"===i){const i=function(e){const t={};return e?(e.forEach((e=>{Object.keys(e.flattened).forEach((e=>{t[e]=(t[e]||0)+1}))})),t):{}}(e);return t.push(...Object.keys(i).sort()),t}return t.push(i),t}),[]);await(async({columns:e,dataView:t,selectedRowIndices:i,toastNotifications:n,valueToStringConverter:a})=>{let r,o=!1,s="";s+=e.map((e=>{var i;const n=ht(e,null===(i=t.getFieldByName(e))||void 0===i?void 0:i.displayName,void 0),a=ie(n);return o=o||a.withFormula,a.formattedString})).join("\t")+"\n",i.forEach(((t,n)=>{s+=e.map((e=>{const i=a(t,e,{compatibleWithCSV:!0});return o=o||i.withFormula,i.formattedString||"-"})).join("\t")+(n!==i.length-1?"\n":"")}));try{var l,c,u;if(null===(l=window.navigator)||void 0===l||!l.clipboard)throw new Error("Clipboard API not available.");await(null===(c=window.navigator)||void 0===c||null===(u=c.clipboard)||void 0===u?void 0:u.writeText(s)),r=!0}catch(e){r=(0,d.copyToClipboard)(s)}if(!r)return n.addWarning({title:ce}),null;const m=v.i18n.translate("unifiedDataTable.copyRowsAsTextToClipboard.toastTitle",{defaultMessage:"Copied to clipboard"});return o?n.addWarning({title:m,text:de}):n.addInfo({title:m}),s})({columns:(0,R.uniq)(n),selectedRowIndices:e.reduce(((e,t,i)=>(p(t.id)&&e.push(i),e)),[]),valueToStringConverter:c,toastNotifications:t,dataView:u}),o(!1),a()}},(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.copySelectionToClipboard",defaultMessage:"Copy selection as text"}))},ge=({rows:e,toastNotifications:t,onCompleted:i})=>{const[a,r]=(0,n.useState)(!1),{selectedDocsState:o,isPlainRecord:c}=(0,n.useContext)(oe.o),{getSelectedDocsOrderedByRows:u}=o;return(0,l.jsx)(d.EuiContextMenuItem,{"data-test-subj":"dscGridCopySelectedDocumentsJSON",icon:"copyClipboard",disabled:a,onClick:async()=>{r(!0),await(async({selectedRows:e,toastNotifications:t})=>{const i=e?JSON.stringify(e.map((e=>e.raw))):"";let n;try{var a,r,o;if(null===(a=window.navigator)||void 0===a||!a.clipboard)throw new Error("Clipboard API not available.");await(null===(r=window.navigator)||void 0===r||null===(o=r.clipboard)||void 0===o?void 0:o.writeText(i)),n=!0}catch(e){n=(0,d.copyToClipboard)(i)}if(!n)return t.addWarning({title:ce}),null;const s=v.i18n.translate("unifiedDataTable.copyRowsAsJsonToClipboard.toastTitle",{defaultMessage:"Copied to clipboard"});return t.addInfo({title:s}),i})({selectedRows:u(e),toastNotifications:t}),r(!1),i()}},c?(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.copyResultsToClipboardJSON",defaultMessage:"Copy results as JSON"}):(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.copyDocsToClipboardJSON",defaultMessage:"Copy documents as JSON"}))};var ye=i(17992);const ve=e=>{const{record:t,rowIndex:i}=se(e),{euiTheme:a}=(0,d.useEuiTheme)(),{selectedDocsState:r}=(0,n.useContext)(oe.o),{isDocSelected:o,toggleDocSelection:s,toggleMultipleDocsSelection:c}=r,u=v.i18n.translate("unifiedDataTable.grid.selectDoc",{defaultMessage:"Select document ''{rowNumber}''",values:{rowNumber:i+1}});return t?(0,l.jsx)(d.EuiCheckbox,{id:t.id,"aria-label":u,checked:o(t.id),"data-test-subj":`dscGridSelectDoc-${t.id}`,onChange:e=>{var i;null!==(i=e.nativeEvent)&&void 0!==i&&i.shiftKey?c(t.id):s(t.id)},css:(0,l.css)("margin-left:",a.size.xs,";","")}):null},_e=e=>()=>{const{selectedDocsState:t,pageIndex:i,pageSize:r}=(0,n.useContext)(oe.o),{getCountOfFilteredSelectedDocs:o,deselectSomeDocs:s,selectMoreDocs:c}=t,u=(0,n.useMemo)((()=>function(e,t,i){if("number"==typeof t&&"number"==typeof i){const n=t*i,a=n+i;return e.slice(n,a).map((e=>e.id))}}(e,i,r)),[i,r]),m=(0,n.useMemo)((()=>null!=u&&u.length?o(u):0),[u,o]),p=(0,n.useMemo)((()=>!(null==u||!u.length)&&m>0&&m<u.length),[u,m]),h=(0,n.useMemo)((()=>!(null==u||!u.length)&&m>0),[u,m]);if(!u)return null;const f=p||h?v.i18n.translate("unifiedDataTable.deselectAllRowsOnPageColumnHeader",{defaultMessage:"Deselect all visible rows"}):v.i18n.translate("unifiedDataTable.selectAllRowsOnPageColumnHeader",{defaultMessage:"Select all visible rows"});return(0,l.jsx)(a().Fragment,null,(0,l.jsx)(d.EuiScreenReaderOnly,null,(0,l.jsx)("span",null,v.i18n.translate("unifiedDataTable.selectColumnHeader",{defaultMessage:"Select column"}))),(0,l.jsx)(d.EuiCheckbox,{"data-test-subj":"selectAllDocsOnPageToggle",id:"select-all-docs-on-page-toggle","aria-label":f,title:f,indeterminate:p,checked:h,onChange:e=>{p||!e.target.checked?s(u):c(u)}}))};var be={name:"fsste2",styles:".euiButtonEmpty__content{flex-direction:row-reverse;}"};function xe({isPlainRecord:e,isFilterActive:t,rows:i,setIsFilterActive:a,selectedDocsState:r,enableComparisonMode:o,setIsCompareActive:c,fieldFormats:u,pageIndex:m,pageSize:p,toastNotifications:h,columns:f,customBulkActions:g}){const[y,v]=(0,n.useState)(!1),{selectAllDocs:_,clearAllSelectedDocs:b,selectedDocsCount:x,docIdsInSelectionOrder:w}=r,k=(0,n.useCallback)((()=>{v(!1)}),[v]),S=(0,n.useMemo)((()=>{const e=x<i.length&&i.length>1;return!("number"!=typeof p||t||!e)&&x>=p}),[i,p,x,t]),T=(0,n.useCallback)((()=>[...g?g.map((e=>(0,l.jsx)(d.EuiContextMenuItem,{"data-test-subj":e["data-test-subj"],key:e.key,icon:e.icon,onClick:()=>{k(),e.onClick({selectedDocIds:w})}},e.label))):[],...o&&x>1?[(0,l.jsx)(we,{key:"compareSelected",selectedDocIds:w,setIsCompareActive:c})]:[],(0,l.jsx)(fe,{key:"copyRowsAsText",rows:i,toastNotifications:h,columns:f,onCompleted:k}),(0,l.jsx)(ge,{key:"copyRowsAsJson",rows:i,toastNotifications:h,onCompleted:k}),t?(0,l.jsx)(d.EuiContextMenuItem,{"data-test-subj":"dscGridShowAllDocuments",key:"showAllDocuments",icon:"eye",onClick:()=>{k(),a(!1)}},e?(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.showAllResults",defaultMessage:"Show all results"}):(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.showAllDocuments",defaultMessage:"Show all documents"})):(0,l.jsx)(d.EuiContextMenuItem,{"data-test-subj":"dscGridShowSelectedDocuments",key:"showSelectedDocuments",icon:"eye",onClick:()=>{k(),a(!0)}},e?(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.showSelectedResultsOnly",defaultMessage:"Show selected results only"}):(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.showSelectedDocumentsOnly",defaultMessage:"Show selected documents only"})),(0,l.jsx)(d.EuiContextMenuItem,{"data-test-subj":"dscGridClearSelectedDocuments",key:"clearSelection",icon:"cross",onClick:()=>{k(),b(),a(!1)}},(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.clearSelection",defaultMessage:"Clear selection"}))]),[o,x,w,c,h,f,k,i,t,e,a,b,g]),E=(0,n.useCallback)((()=>v((e=>!e))),[]),z=(0,l.jsx)(d.EuiPopover,{closePopover:()=>v(!1),isOpen:y,panelPaddingSize:"none",button:(0,l.jsx)(d.EuiDataGridToolbarControl,{iconSide:"left",iconType:"arrowDown",onClick:E,"data-selected-documents":x,"data-test-subj":"unifiedDataTableSelectionBtn",isSelected:t,badgeContent:u.getDefaultInstance(he.fM.NUMBER,[he._c.INTEGER]).convert(x),css:be},e?(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.selectedResultsButtonLabel",defaultMessage:"Selected",description:"Selected results"}):(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.selectedRowsButtonLabel",defaultMessage:"Selected",description:"Selected documents"}))},y&&(0,l.jsx)(d.EuiContextMenuPanel,{items:T(),"data-test-subj":"unifiedDataTableSelectionMenu"}));return(0,l.jsx)(d.EuiFlexGroup,{responsive:!1,gutterSize:"none",wrap:!1,className:"unifiedDataTableToolbarControlGroup",css:ye.R7.controlGroup},(0,l.jsx)(d.EuiFlexItem,{className:"unifiedDataTableToolbarControlButton",css:ye.R7.controlButton,grow:!1},z),S?(0,l.jsx)(d.EuiFlexItem,{className:"unifiedDataTableToolbarControlButton",css:ye.R7.controlButton,grow:!1},(0,l.jsx)(d.EuiDataGridToolbarControl,{"data-test-subj":"dscGridSelectAllDocs",onClick:()=>{v(!1),_()}},(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.selectAllDocs",defaultMessage:"Select all {rowsCount}",values:{rowsCount:u.getDefaultInstance(he.fM.NUMBER,[he._c.INTEGER]).convert(i.length)}}))):null)}const we=({selectedDocIds:e,setIsCompareActive:t})=>{const i=e.length>100,n=(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.compareSelectedRowsButtonLabel",defaultMessage:"Compare selected"});return(0,l.jsx)(d.EuiContextMenuItem,{"data-test-subj":"unifiedDataTableCompareSelectedDocuments",disabled:i,icon:"diff",onClick:()=>{t(!0)}},i?(0,l.jsx)(d.EuiToolTip,{content:v.i18n.translate("unifiedDataTable.compareSelectedRowsButtonDisabledTooltip",{defaultMessage:"Comparison is limited to {limit} rows",values:{limit:100}})},n):n)};function ke({label:e,onCopy:t,dataTestSubj:i}){return{size:"xs",label:e,iconType:"copyClipboard",iconProps:{size:"m"},onClick:t,"data-test-subj":i}}function Se({columnDisplayName:e,toastNotifications:t}){return ke({label:(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.grid.copyColumnNameToClipBoardButton",defaultMessage:"Copy name"}),onCopy:()=>(({columnDisplayName:e,toastNotifications:t})=>{if(!(0,d.copyToClipboard)(e))return t.addWarning({title:ce}),null;const i=v.i18n.translate("unifiedDataTable.copyColumnNameToClipboard.toastTitle",{defaultMessage:"Copied to clipboard"});return t.addInfo({title:i}),e})({columnDisplayName:e,toastNotifications:t}),dataTestSubj:"gridCopyColumnNameToClipBoardButton"})}function Te({columnId:e,columnDisplayName:t,toastNotifications:i,rowsCount:n,valueToStringConverter:a}){return ke({label:(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.grid.copyColumnValuesToClipBoardButton",defaultMessage:"Copy column"}),onCopy:()=>(async({columnId:e,columnDisplayName:t,toastNotifications:i,valueToStringConverter:n,rowsCount:a})=>{const r=ie(t);let o=r.withFormula;const s=[...Array(a)].map(((t,i)=>{const a=n(i,e,{compatibleWithCSV:!0});return o=o||a.withFormula,a.formattedString})),l=`${r.formattedString}\n${s.join("\n")}`;let c;try{var u,m,p;if(null===(u=window.navigator)||void 0===u||!u.clipboard)throw new Error("Clipboard API not available.");await(null===(m=window.navigator)||void 0===m||null===(p=m.clipboard)||void 0===p?void 0:p.writeText(l)),c=!0}catch(e){c=(0,d.copyToClipboard)(l)}if(!c)return i.addWarning({title:ce}),null;const h=v.i18n.translate("unifiedDataTable.copyColumnValuesToClipboard.toastTitle",{defaultMessage:'Values of "{column}" column copied to clipboard',values:{column:t}});return o?i.addWarning({title:h,text:de}):i.addInfo({title:h}),l})({columnId:e,columnDisplayName:t,toastNotifications:i,rowsCount:n,valueToStringConverter:a}),dataTestSubj:"gridCopyColumnValuesToClipBoardButton"})}var Ee=i(3185),ze=i(43582),je=i(72927),Ie=i(64527),Ce=i(2133),Ae=i(81060);const Fe=({headerRowHeight:e,children:t})=>{const{euiTheme:i}=(0,d.useEuiTheme)(),n=(0,l.css)("overflow-wrap:anywhere;white-space:normal;word-break:break-all;line-height:",i.size.base,";text-align:left;.euiDataGridHeaderCell--numeric &{float:right;}","");return e?(0,l.jsx)(d.EuiTextBlockTruncate,{lines:e,css:n},t):(0,l.jsx)("div",{css:n},t)},Me=({columnDisplayName:e,showColumnTokens:t,columnName:i,columnsMeta:n,dataView:a,headerRowHeight:r})=>(0,l.jsx)(Fe,{headerRowHeight:r},t&&(0,l.jsx)(De,{columnName:i,columnsMeta:n,dataView:a}),(0,l.jsx)(Le,{columnDisplayName:e})),De=e=>{const{euiTheme:t}=(0,d.useEuiTheme)(),{columnName:i,columnsMeta:a,dataView:r}=e,o=(0,n.useMemo)((()=>function({dataView:e,columnName:t,columnsMeta:i}){if(!t||"_source"===t)return null;if(i){const e=(n=i[t])&&n.type?(0,je.m)((0,ze.N)({id:"",name:"",meta:n})):null;return e&&"unknown"!==e?(0,l.jsx)(Ie.q,{type:e,css:Pe}):null}var n;const a=e.getFieldByName(t);return a?(0,l.jsx)(Ie.q,(0,Ee.default)({},(0,Ce.m)(a),{css:Pe})):function(e,t){const i=new RegExp((0,Ae.escapeRegExp)(e)+"(\\.|$)");return!t.fields.getByName(e)&&!!t.fields.getAll().find((e=>{var t;const n=(0,m.getDataViewFieldSubtypeNested)(e);return!!n&&i.test(null!==(t=null==n?void 0:n.nested.path)&&void 0!==t?t:"")}))}(t,e)?(0,l.jsx)(Ie.q,{type:"nested",css:Pe}):null}({columnName:i,columnsMeta:a,dataView:r})),[i,a,r]);return o?(0,l.jsx)("span",{css:(0,l.css)({paddingRight:t.size.xs},"","")},o):null},Le=({columnDisplayName:e})=>(0,l.jsx)("span",{"data-test-subj":"unifiedDataTableColumnTitle"},e),Pe={verticalAlign:"bottom"};var Ne={name:"1flj9lk",styles:"text-align:left"};const Re=({dataView:e,dataViewField:t,headerRowHeight:i=1,columnLabel:n})=>{var a;const r=n||(null!==(a=null==t?void 0:t.customLabel)&&void 0!==a?a:e.timeFieldName),o=v.i18n.translate("unifiedDataTable.tableHeader.timeFieldIconTooltipAriaLabel",{defaultMessage:"{timeFieldName} - this field represents the time that events occurred.",values:{timeFieldName:r}}),s=v.i18n.translate("unifiedDataTable.tableHeader.timeFieldIconTooltip",{defaultMessage:"This field represents the time that events occurred."});return(0,l.jsx)("div",{"aria-label":o,css:Ne},(0,l.jsx)(Fe,{headerRowHeight:i},r," ",(0,l.jsx)(d.EuiIconTip,{type:"clock",content:s})))},Oe=({isSorted:e,showColumnTokens:t,columnName:i,columnsMeta:n,dataView:a,headerRowHeight:r,columnDisplayName:o})=>{const s=v.i18n.translate("unifiedDataTable.tableHeader.scoreFieldIconTooltip",{defaultMessage:"In order to retrieve values for _score, you must sort by it."}),{euiTheme:c}=(0,d.useEuiTheme)();return(0,l.jsx)(Fe,{headerRowHeight:r},t&&e&&(0,l.jsx)(De,{columnName:i,columnsMeta:n,dataView:a}),!e&&(0,l.jsx)("span",{css:(0,l.css)({paddingRight:c.size.xs},"","")},(0,l.jsx)(d.EuiIconTip,{content:s,color:"warning",size:"s",type:"alert",position:"left"})),(0,l.jsx)(Le,{columnDisplayName:o}))},qe=v.i18n.translate("unifiedDataTable.tableHeader.sourceFieldIconTooltip",{defaultMessage:"Shows a quick view of the record using its key:value pairs."}),Ve=v.i18n.translate("unifiedDataTable.tableHeader.sourceFieldIconTooltipTitle",{defaultMessage:"Summary"}),Ue=v.i18n.translate("unifiedDataTable.tableHeader.summary",{defaultMessage:"Summary"}),Be=({headerRowHeight:e=W.H0.single,columnDisplayName:t=Ue,tooltipContent:i=qe,tooltipTitle:a=Ve,iconTipDataTestSubj:r="unifiedDataTable_headerSummaryIcon"})=>{const{euiTheme:o}=(0,d.useEuiTheme)(),s=(0,n.useMemo)((()=>({marginLeft:o.size.xs})),[o.size.xs]);return(0,l.jsx)(Fe,{headerRowHeight:e},t,(0,l.jsx)("span",{css:s},(0,l.jsx)(d.EuiIconTip,{"data-test-subj":r,type:"question",content:i,title:a})))};var He=i(79881),$e=i.n(He),Ge=i(43440),We=i.n(Ge),Qe=i(60362),Ye=i.n(Qe),Je=i(26880),Ke=i.n(Je),Ze=i(51783),Xe=i.n(Ze);const et=e=>null==e||"number"==typeof e&&Number.isNaN(e),tt=(e,t)=>et(e)?et(t)?0:-1:et(t)?1:void 0,it=(e,t)=>{var i;return null!==(i=tt(e,t))&&void 0!==i?i:e-t},nt=(e,t)=>{const i=Xe()(e),n=Xe()(t);return!i.isValid()||et(e)?!n.isValid()||et(t)?0:-1:!n.isValid()||et(t)?1:i.isSame(n)?0:i.isBefore(n)?-1:1},at=(e,t,i,n)=>{var a;const r=n.convert(e),o=n.convert(t);return null!==(a=tt(e,t))&&void 0!==a?a:r.localeCompare(o)},rt=(e,t,i)=>{const n=ot(e,i),a=ot(t,i);let r=0,o=n.parts[r]-a.parts[r];for(;!o&&r<7;)r++,o=n.parts[r]-a.parts[r];return 0===o?(e?e.length:40)-(t?t.length:40):o};function ot(e,t){if(et(e)||!Ke().isValid(e)){const i=null==e?-1:t;return{parts:Array(8).fill(i*(1/0))}}const i=Ke().parse(e);return function(e){return"ipv6"===e.kind()}(i)?i:i.toIPv4MappedAddress()}const st=(e,t,i)=>{var n,a;const r=String(null==e?"":e),o=String(null==t?"":t),s=!r||!$e()(r),l=!o||!$e()(o);if(s&&l)return null==e&&e!==t?-1*i:null==t&&e!==t?1*i:0;if(s)return 1*i;if(l)return-1*i;const d=null!==(n=Ye()(r))&&void 0!==n?n:"",c=null!==(a=Ye()(o))&&void 0!==a?a:"";return We()(d,c)},lt={gte:-1/0,lt:1/0},dt=(e,t)=>{const i={...lt,...e},n={...lt,...t},a=i.gte-n.gte,r=i.lt-n.lt;return a||r||0};function ct(e,t){return(i,n,a)=>{const r=null==i?void 0:i[e],o=null==n?void 0:n[e];return null==r||Number.isNaN(r)?null==o||Number.isNaN(o)?0:1:null==o||Number.isNaN(o)?-1:t(i,n,a)}}let ut=function(e){return e.date="date",e.number="number",e.range="range",e.ip="ip",e.version="version",e}({});const mt=({rows:e,visibleColumns:t,columnsMeta:i,sort:a,dataView:r,isPlainRecord:o,isSortEnabled:s,defaultColumns:l,onSort:d})=>{const c=(0,n.useMemo)((()=>a.map((([e,t])=>({id:e,direction:t}))).filter((e=>t.includes(e.id)))),[a,t]),u=(0,n.useMemo)((()=>{if(o&&e&&c.length)return c.reduce(((e,{id:t,direction:n})=>{const a=(0,$.u)({dataView:r,fieldName:t,columnMeta:null==i?void 0:i[t]});if(!a)return e;const o=function(e,t,i){const n=function(e,t){return function(i){return(n,a,r)=>{const o="asc"===r?1:-1,s=null==n?n:n[e],l=null==a?a:a[e];return Array.isArray(s)||Array.isArray(l)?o*function(e,t,i,n,a){const r=Math.max(e.length,t.length);for(let o=0;o<r;o++){const r=a(e[o],t[o],i,n);if(0!==r)return r}return 0}(Array.isArray(s)?s:[s],Array.isArray(l)?l:[l],o,t,i):o*i(s,l,o,t)}}}(t,i);return e===ut.date?ct(t,n(nt)):e===ut.number?ct(t,n(it)):e===ut.range?ct(t,n(dt)):e===ut.ip?ct(t,n(rt)):e===ut.version?n(st):ct(t,n(at))}(a.type,t,r.getFormatterForField(a));return e.push(((e,t)=>o(e.flattened,t.flattened,n))),e}),[])}),[i,r,o,e,c]);return{sortedRows:(0,n.useMemo)((()=>e&&u?[...e].sort(((e,t)=>{for(const i of u){const n=i(e,t);if(0!==n)return n}return 0})):e),[u,e]),sorting:(0,n.useMemo)((()=>s?o&&l?void 0:{columns:c,onSort:e=>{null==d||d(e.map((({id:e,direction:t})=>[e,t])))}}:{columns:c,onSort:()=>{}}),[s,o,l,c,d])}},pt=({isPlainRecord:e,columnName:t,columnSchema:i,dataViewField:n})=>e?t!==J.JR&&Boolean(i!==W.P2||(null==n?void 0:n.type)&&Object.values(ut).includes(n.type)):!0===(null==n?void 0:n.sortable),ht=(e,t,i)=>i||("_source"===e?v.i18n.translate("unifiedDataTable.grid.documentHeader",{defaultMessage:"Summary"}):t||e),ft=a().memo(Me),gt=a().memo(Re),yt=a().memo(Oe),vt=a().memo(Be),_t=[],bt="select",xt=e=>({id:bt,width:W.ug,headerCellProps:{className:"unifiedDataTable__headerCell"},rowCellRender:ve,headerCellRender:_e(e)});function wt({numberOfColumns:e,columnName:t,columnWidth:i=0,dataView:n,defaultColumns:a,isSortEnabled:r,isPlainRecord:o,toastNotifications:d,hasEditDataViewPermission:c,valueToStringConverter:u,rowsCount:m,onFilter:p,editField:h,columnCellActions:f,cellActionsHandling:g,visibleCellActions:y,columnsMeta:_,showColumnTokens:b,headerRowHeight:x,customGridColumnsConfiguration:w,columnDisplay:k,onResize:S,sortedColumns:T,disableCellActions:E=!1}){const z=(0,$.u)({dataView:n,fieldName:t,columnMeta:null==_?void 0:_[t]}),j=h&&z&&(({hasEditDataViewPermission:e,dataView:t,field:i,editField:n})=>{if("_source"===i.name)return null;const{canEdit:a}=((e,t)=>{var i;const n=Boolean(null===(i=e.getFieldByName(t.name))||void 0===i?void 0:i.runtimeField);return{canEdit:!("unknown"===t.type||"unknown_selected"===t.type)||n,canDelete:n}})(t,i),r=e()||!t.isPersisted();return a&&r?{size:"xs",label:(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.grid.editFieldButton",defaultMessage:"Edit data view field"}),iconType:"pencil",iconProps:{size:"m"},onClick:()=>{n(i.name)},"data-test-subj":"gridEditFieldButton"}:null})({hasEditDataViewPermission:c,dataView:n,field:z,editField:h}),I=S&&i>0?{key:"reset-width",label:v.i18n.translate("unifiedDataTable.grid.resetColumnWidthButton",{defaultMessage:"Reset width"}),iconType:"refresh",size:"xs",iconProps:{size:"m"},onClick:()=>{S({columnId:t,width:void 0})},"data-test-subj":"unifiedDataTableResetColumnWidth"}:void 0,C=ht(t,null==z?void 0:z.displayName,k),A=null==T?void 0:T.some((e=>e.id===t));let F;E?F=_t:null!=f&&f.length&&"replace"===g?F=f:(F=z?pe(z,o,d,u,p):_t,null!=f&&f.length&&"append"===g&&F.push(...f));const M=function(e){switch(e){case he.fM.IP:case he.fM.GEO_SHAPE:case he.fM.NUMBER:return"numeric";case he.fM.BOOLEAN:return"boolean";case he.fM.STRING:return"string";case he.fM.DATE:return"datetime";default:return W.P2}}(null==z?void 0:z.type),D={id:t,schema:M,isSortable:r&&pt({isPlainRecord:o,columnName:t,columnSchema:M,dataViewField:z}),display:b||1!==x?(0,l.jsx)(ft,{dataView:n,columnName:t,columnDisplayName:C,columnsMeta:_,showColumnTokens:b,headerRowHeight:x}):void 0,displayAsText:C,actions:{showHide:!a&&t!==n.timeFieldName&&{label:v.i18n.translate("unifiedDataTable.removeColumnLabel",{defaultMessage:"Remove column"}),iconType:"cross"},showMoveLeft:!a,showMoveRight:!a,additional:[...I?[I]:[],..."__source"===t?[]:[Se({columnDisplayName:C,toastNotifications:d})],Te({columnId:t,columnDisplayName:C,toastNotifications:d,rowsCount:m,valueToStringConverter:u}),...j?[j]:[]]},cellActions:F,visibleCellActions:y,displayHeaderCellProps:{className:"unifiedDataTable__headerCell"}};return D.id===J.JR&&(D.display=(0,l.jsx)(vt,{columnDisplayName:C,headerRowHeight:x})),D.id===n.timeFieldName&&(D.display=(0,l.jsx)(gt,{dataView:n,dataViewField:z,headerRowHeight:x,columnLabel:k}),e>1&&(D.initialWidth=W.Nr)),D.id===W.YQ&&(D.display=(0,l.jsx)(yt,{columnDisplayName:C,isSorted:A,showColumnTokens:b,dataView:n,headerRowHeight:x,columnName:t,columnsMeta:_})),i>0&&(D.initialWidth=Number(i)),w&&w[D.id]?w[D.id]({column:D,headerRowHeight:x}):(E&&(D.isExpandable=!1),D)}const kt=e=>{const{isLoadingMore:t,rowCount:i,sampleSize:a,pageIndex:r,pageCount:o,totalHits:c=0,onFetchMoreRecords:u,data:m,paginationMode:p,hasScrolledToBottom:h}=e,f=m.query.timefilter.timefilter,[g,y]=(0,n.useState)(f.getRefreshInterval());(0,n.useEffect)((()=>{const e=f.getRefreshIntervalUpdate$().subscribe((()=>{y(f.getRefreshInterval())}));return()=>e.unsubscribe()}),[f,y]);const _=Boolean(g&&!1===g.pause&&g.value>0),{euiTheme:b}=(0,d.useEuiTheme)();return("multiPage"!==p||r===o-1&&i<c)&&("singlePage"!==p||h||t)?u&&"boolean"==typeof t?i<=W.k$-a?(0,l.jsx)(St,(0,Ee.default)({hasButton:!0},e),(0,l.jsx)(d.EuiToolTip,{content:_?v.i18n.translate("unifiedDataTable.gridSampleSize.fetchMoreLinkDisabledTooltip",{defaultMessage:"To load more the refresh interval needs to be disabled first"}):void 0},(0,l.jsx)(d.EuiButtonEmpty,{disabled:_,isLoading:t,flush:"both","data-test-subj":"dscGridSampleSizeFetchMoreLink",onClick:u,css:(0,l.css)("margin-left:",b.size.xs,";","")},(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.gridSampleSize.fetchMoreLinkLabel",defaultMessage:"Load more"})))):(0,l.jsx)(St,(0,Ee.default)({hasButton:!1},e)):i<c?(0,l.jsx)(St,(0,Ee.default)({hasButton:!1},e)):null:null},St=({hasButton:e,rowCount:t,children:i,fieldFormats:n})=>{const{euiTheme:a}=(0,d.useEuiTheme)(),r=n.getDefaultInstance(he.fM.NUMBER,[he._c.INTEGER]).convert(t);return(0,l.jsx)("p",{"data-test-subj":"unifiedDataTableFooter",css:(0,l.css)("display:flex;flex-direction:row;align-items:center;justify-content:center;flex-shrink:0;background-color:",a.colors.lightestShade,";padding:",e?`0 ${a.size.base}`:`${a.size.s} ${a.size.base}`,";margin-top:",a.size.xs,";text-align:center;","")},(0,l.jsx)("span",null,e?(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.gridSampleSize.lastPageDescription",defaultMessage:"Search results are limited to {rowCount} documents.",values:{rowCount:r}}):(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.gridSampleSize.limitDescription",defaultMessage:"Search results are limited to {sampleSize} documents. Add more search terms to narrow your search.",values:{sampleSize:r}})),i)};let Tt=function(e){return e.auto="auto",e.custom="custom",e}({});const Et=(0,d.htmlIdGenerator)()();var zt={name:"jycfzi",styles:"flex-shrink:0;flex-basis:66.6%"};function jt({lineCountInput:e,label:t,rowHeight:i=Tt.custom,onChangeRowHeight:n,onChangeLineCountInput:r,maxRowHeight:o=20,"data-test-subj":s}){const c=[{id:`${Et}${Tt.auto}`,label:v.i18n.translate("unifiedDataTable.rowHeight.auto",{defaultMessage:"Auto"}),"data-test-subj":`${s}_rowHeight_${Tt.auto}`},{id:`${Et}${Tt.custom}`,label:v.i18n.translate("unifiedDataTable.rowHeight.custom",{defaultMessage:"Custom"}),"data-test-subj":`${s}_rowHeight_${Tt.custom}`}];return(0,l.jsx)(a().Fragment,null,(0,l.jsx)(d.EuiFormRow,{label:t,"aria-label":t,display:"columnCompressed","data-test-subj":s},(0,l.jsx)(d.EuiFlexGroup,{gutterSize:"s",responsive:!1},(0,l.jsx)(d.EuiButtonGroup,{isFullWidth:!0,css:zt,legend:t,buttonSize:"compressed",options:c,idSelected:`${Et}${i}`,onChange:e=>{const t=e.replace(Et,"");n(t)},"data-test-subj":`${s}_rowHeightButtonGroup`}),(0,l.jsx)(d.EuiFieldNumber,{compressed:!0,value:e,onChange:e=>{const t=Number(e.currentTarget.value);r(t,e.target.checkValidity())},min:1,max:o,required:!0,step:1,disabled:i!==Tt.custom,"data-test-subj":`${s}_lineCountNumber`}))))}const It=()=>{},Ct=({rowHeight:e,onChangeRowHeight:t,onChangeRowHeightLines:i,headerRowHeight:r,onChangeHeaderRowHeight:o,onChangeHeaderRowHeightLines:s,maxAllowedSampleSize:c=1e3,sampleSize:u,onChangeSampleSize:m,lineCountInput:p,headerLineCountInput:h,densityControl:f})=>{const[g,y]=(0,n.useState)(u),_=Math.max(Math.min(10,u),1),{euiTheme:b}=(0,d.useEuiTheme)(),x=(0,n.useMemo)((()=>(0,R.debounce)(null!=m?m:It,300,{leading:!1,trailing:!0})),[m]),w=(0,n.useCallback)((e=>{var t;if(!("value"in e.target)||!e.target.value)return void y("");const i=null!==(t=parseInt(e.target.value,10))&&void 0!==t?t:10;i>=1&&(y(i),i<=c&&x(i))}),[c,y,x]),k=v.i18n.translate("unifiedDataTable.sampleSizeSettings.sampleSizeLabel",{defaultMessage:"Sample size"});(0,n.useEffect)((()=>{y(u)}),[u,y]);const S=[];if(m){let e=10===_?10:1;e>1&&(g&&!At(g,e)||!At(_,e)||!At(c,e))&&(e=1),S.push((0,l.jsx)(a().Fragment,null,(0,l.jsx)(d.EuiFormRow,{label:k,display:"columnCompressed"},(0,l.jsx)(d.EuiRange,{compressed:!0,fullWidth:!0,min:_,max:c,step:e,showInput:!0,value:g,onChange:w,"data-test-subj":"unifiedDataTableSampleSizeInput",showRange:!0}))))}return Boolean(f)&&S.push(f),o&&s&&S.push((0,l.jsx)(jt,{rowHeight:r,label:v.i18n.translate("unifiedDataTable.headerRowHeightLabel",{defaultMessage:"Max header cell lines"}),onChangeRowHeight:o,onChangeLineCountInput:s,"data-test-subj":"unifiedDataTableHeaderRowHeightSettings",maxRowHeight:5,lineCountInput:h})),t&&i&&S.push((0,l.jsx)(jt,{rowHeight:e,label:v.i18n.translate("unifiedDataTable.rowHeightLabel",{defaultMessage:"Body cell lines"}),onChangeRowHeight:t,onChangeLineCountInput:i,"data-test-subj":"unifiedDataTableRowHeightSettings",lineCountInput:p})),S.length>1&&m&&S.splice(1,0,(0,l.jsx)(d.EuiHorizontalRule,{margin:"xs",css:(0,l.css)({marginInlineStart:`-${b.size.s}`,marginInlineEnd:`-${b.size.s}`,inlineSize:"unset"},"","")})),(0,l.jsx)(a().Fragment,null,S.map(((e,t)=>(0,l.jsx)(a().Fragment,{key:`setting-${t}`},e))))};function At(e,t){return e%t===0}var Ft=i(50693),Mt=i.n(Ft);const Dt=e=>"number"==typeof e&&!Number.isNaN(e)&&Math.floor(e)===e&&e>=-1&&e<=20,Lt=(e,t)=>`${e}:${t}`,Pt=(e,t,i,n,a)=>{i.set(Lt(n,a),{previousRowHeight:e,previousConfigRowHeight:t})};let Nt=function(e){return e.header="header",e.row="row",e}({});const Rt=({storage:e,consumer:t,key:i,configRowHeight:n,rowHeightState:a})=>{const r=((e,t,i)=>{const n=e.get(Lt(t,i));return"object"==typeof n&&null!==n&&Dt(n.previousRowHeight)&&Dt(n.previousConfigRowHeight)?n:null})(e,t,i);let o;var s;return o=Dt(a)?a:null!==(s=r)&&n===s.previousConfigRowHeight?r.previousRowHeight:n,0===o?1:o},Ot=({type:e,storage:t,consumer:i,key:a,defaultRowHeight:r,configRowHeight:o=r,rowHeightState:s,onUpdateRowHeight:l})=>{var d,c;const[u]=(0,n.useState)((()=>Rt({storage:t,consumer:i,key:a,configRowHeight:o,rowHeightState:s}))),m=(0,G.OU)(e===Nt.header?"headerRowHeight":"rowHeight",u),p=(0,n.useMemo)((()=>Rt({storage:t,consumer:i,key:a,configRowHeight:o,rowHeightState:null!=s?s:m.current})),[o,i,a,s,t,m]);m.current=p;const h=(0,n.useCallback)((e=>void 0!==e&&e>0?e:o>0?o:r),[o,r]),[g,y]=(0,n.useState)(h(p)),v=(0,n.useMemo)((()=>p===W.H0.auto?Tt.auto:Tt.custom),[p]),_=(0,n.useCallback)((e=>{const n=e===Tt.auto?W.H0.auto:h(g);Pt(n,o,t,i,a),null==l||l(n)}),[o,i,h,a,g,l,t]),b=(0,n.useCallback)(((e,n)=>{n&&(Pt(e,o,t,i,a),null==l||l(e)),y(0===e?void 0:e)}),[o,i,a,l,t]),x=f()(null!==(d=Mt()(v))&&void 0!==d?d:v),w=f()(null!==(c=Mt()(p))&&void 0!==c?c:p);return(0,n.useEffect)((()=>{v===Tt.auto&&x.current===Tt.custom?y(h(w.current)):v===Tt.custom&&y(h(p))}),[h,x,w,v,p]),{rowHeight:v,rowHeightLines:p,lineCountInput:g,onChangeRowHeight:l?_:void 0,onChangeRowHeightLines:l?b:void 0}},qt=(0,i(89981).l)((0,n.lazy)((()=>i.e(5805).then(i.bind(i,5805)))));var Vt=i(44081);const Ut="euiDataGrid--fullScreen",Bt=["unifiedDataTable__fullScreen",(0,Vt.css)("*:not(\n      .",Ut,", .",Ut," *,\n      [data-euiportal='true'],\n      [data-euiportal='true'] *\n    ){z-index:unset!important;}","")],Ht=[J.JR];function $t(e){return e.reduce(((e,t)=>(e[t]=!0,e)),{})}function Gt(e){return Object.keys(e)}const Wt=({getRowIndicator:e,...t})=>{const{record:i}=se(t),{euiTheme:n}=(0,d.useEuiTheme)(),a=i?e(i,n):void 0,r=(null==a?void 0:a.color)||"transparent",o=null==a?void 0:a.label;return(0,l.jsx)("div",{"data-test-subj":"unifiedDataTableRowColorIndicatorCell",title:o,css:(0,l.css)("position:absolute;top:0;background:",r,";width:",4,"px;height:100%;","")})},Qt=({rowControlColumn:e,...t})=>{const{record:i,rowIndex:a}=se(t),r=(0,n.useMemo)((()=>({"data-test-subj":t,color:n,disabled:r,iconType:o,label:s,onClick:c,tooltipContent:u,...m})=>{const p=Boolean(u)?{}:{className:"unifiedDataTable__rowControl"},h=(0,l.jsx)(d.EuiButtonIcon,(0,Ee.default)({"aria-label":s,color:null!=n?n:"text","data-test-subj":null!=t?t:`unifiedDataTable_rowControl_${e.id}`,disabled:r,iconSize:"s",iconType:o,onClick:()=>{i&&c&&c({record:i,rowIndex:a})}},p,m));return u?(0,l.jsx)(d.EuiToolTip,{anchorClassName:"unifiedDataTable__rowControl",content:u,delay:"long"},h):h}),[e.id,i,a]);return i?e.render(r,{record:i,rowIndex:a}):null},Yt=e=>t=>(0,l.jsx)(Qt,(0,Ee.default)({},t,{rowControlColumn:e})),Jt=({rowControlColumns:e,...t})=>{const{record:i,rowIndex:a}=se(t),[r,o]=(0,n.useState)(!1),s=v.i18n.translate("unifiedDataTable.grid.additionalRowActions",{defaultMessage:"Additional actions"}),c=(0,n.useCallback)((e=>({"data-test-subj":t,color:n,disabled:r,label:s,iconType:c,onClick:u})=>(0,l.jsx)(d.EuiContextMenuItem,{"data-test-subj":null!=t?t:`unifiedDataTable_rowMenu_${e}`,disabled:r,icon:c,color:n,onClick:()=>{i&&(null==u||u({record:i,rowIndex:a})),o(!1)}},s)),[i,a]),u=(0,n.useMemo)((()=>e.map((e=>{const t=c(e.id);return(0,l.jsx)(n.Fragment,{key:e.id},i?e.render(t,{record:i,rowIndex:a}):null)}))),[e,c,i,a]);return(0,l.jsx)(d.EuiPopover,{id:`rowMenuActionsPopover_${t.rowIndex}`,className:"unifiedDataTable__rowControl",button:(0,l.jsx)(d.EuiToolTip,{content:s,delay:"long",disableScreenReaderOutput:!0},(0,l.jsx)(d.EuiButtonIcon,{"data-test-subj":`unifiedDataTable_additionalRowControl_${t.columnId}Menu`,iconSize:"s",iconType:"boxesVertical",color:"text","aria-label":s,onClick:()=>{o(!r)}})),isOpen:r,closePopover:()=>o(!1),panelPaddingSize:"none",anchorPosition:"downLeft"},(0,l.jsx)(d.EuiContextMenuPanel,{size:"s",items:u}))},Kt=e=>t=>(0,l.jsx)(Jt,(0,Ee.default)({},t,{rowControlColumns:e}));var Zt={name:"ub10ak",styles:"position:absolute;visibility:hidden;white-space:nowrap;pointer-events:none"};const Xt=({maxWidth:e})=>{const[t,i]=(0,n.useState)(!1),a=(0,n.useCallback)((t=>{t&&i(t.width<e)}),[e]),r=v.i18n.translate("unifiedDataTable.controlColumnsActionHeader",{defaultMessage:"Actions"});return(0,l.jsx)(Fe,null,(0,l.jsx)(d.EuiScreenReaderOnly,null,(0,l.jsx)("span",null,v.i18n.translate("unifiedDataTable.actionsColumnHeader",{defaultMessage:"Actions column"}))),t?(0,l.jsx)("span",{"data-test-subj":"unifiedDataTable_actionsColumnHeaderText"},r):(0,l.jsx)(d.EuiIconTip,{iconProps:{"data-test-subj":"unifiedDataTable_actionsColumnHeaderIcon"},type:"info",content:r}),(0,l.jsx)(d.EuiResizeObserver,{onResize:a},(e=>(0,l.jsx)("span",{ref:e,css:Zt},r))))},ei=()=>(0,l.jsx)("div",{css:(0,l.css)({paddingLeft:4},"","")}),ti=[bt,"openDetails"],ii={overscanRowCount:20};let ni=function(e){return e.loading="loading",e.loadingMore="loadingMore",e.loaded="loaded",e}({});const ai=a().memo(d.EuiDataGrid),ri=a().forwardRef((({ariaLabelledBy:e,columns:t,columnsMeta:i,showColumnTokens:r,canDragAndDropColumns:h,configHeaderRowHeight:g,headerRowHeightState:y,onUpdateHeaderRowHeight:v,controlColumnIds:_=ti,rowAdditionalLeadingControls:b,dataView:x,loadingState:w,onFilter:k,onResize:S,onSetColumns:T,onSort:E,rows:z,searchDescription:j,searchTitle:I,settings:C,showTimeCol:A,showKeyboardShortcuts:F=!0,showFullScreenButton:M=!0,sort:P,isSortEnabled:q=!0,isPaginationEnabled:V=!0,paginationMode:B=W.d1,cellActionsTriggerId:K,cellActionsMetadata:Z,cellActionsHandling:X="replace",visibleCellActions:ee,className:ie,rowHeightState:ne,onUpdateRowHeight:ae,maxAllowedSampleSize:se,sampleSizeState:de,onUpdateSampleSize:ce,isPlainRecord:ue=!1,rowsPerPageState:me,onUpdateRowsPerPage:pe,onFieldEdited:he,services:fe,renderCustomGridBody:ge,renderCustomToolbar:ye,externalControlColumns:ve,trailingControlColumns:_e,totalHits:be,onFetchMoreRecords:we,renderDocumentView:ke,setExpandedDoc:Se,expandedDoc:Te,configRowHeight:ze,showMultiFields:je=!0,maxDocFieldsDisplayed:Ie=50,externalAdditionalControls:Ce,rowsPerPageOptions:Ae,externalCustomRenderers:Fe,consumer:Me="discover",componentsTourSteps:De,gridStyleOverride:Le,rowLineHeightOverride:Pe,customGridColumnsConfiguration:Ne,enableComparisonMode:Re,enableInTableSearch:Oe=!1,cellContext:qe,renderCellPopover:Ve,getRowIndicator:Ue,dataGridDensityState:Be,onUpdateDataGridDensity:He,onUpdatePageIndex:$e,disableCellActions:Ge=!1,disableCellPopover:We=!1,customBulkActions:Qe,shouldKeepAdHocDataViewImmutable:Ye},Je)=>{const Ke=(0,c.d)(si),{fieldFormats:Ze,toastNotifications:Xe,dataViewFieldEditor:et,uiSettings:tt,storage:it,data:nt}=fe,at=(0,n.useRef)(null);(0,n.useImperativeHandle)(Je,(()=>at.current));const[rt,ot]=(0,G.SK)("isFilterActive",!1),[st,lt]=(0,G.SK)("isCompareActive",!1),[dt,ct]=(0,n.useState)(!1),ut=(0,J.ZA)(t,x),pt=ut.includes("_source"),ht=(0,n.useMemo)((()=>{var e;return new Map(null!==(e=null==z?void 0:z.map(((e,t)=>[e.id,{doc:e,docIndex:t}])))&&void 0!==e?e:[])}),[z]),ft=(0,n.useCallback)((e=>{var t;return null===(t=ht.get(e))||void 0===t?void 0:t.doc}),[ht]),gt=(e=>{const[t,i]=(0,G.SK)("selectedDocsMap",{}),a=(0,n.useRef)(),r=(0,n.useCallback)((e=>{i((t=>{const i={...t};return i[e]?delete i[e]:i[e]=!0,i})),a.current=e}),[i]),o=(0,n.useCallback)((e=>{i($t(e))}),[i]),s=(0,n.useCallback)((()=>{i($t([...e.keys()]))}),[e,i]),l=(0,n.useCallback)((e=>{i((t=>$t([...Gt(t),...e])))}),[i]),d=(0,n.useCallback)((e=>{i((t=>$t(Gt(t).filter((t=>!e.includes(t))))))}),[i]),c=(0,n.useCallback)((()=>{i({})}),[i]),u=(0,n.useMemo)((()=>Gt(t).filter((t=>e.has(t)))),[t,e]),m=(0,n.useCallback)((i=>Boolean(t[i])&&e.has(i)),[t,e]),p=(0,n.useCallback)((t=>{var i,n,r;const o=!m(t),s=null===(i=e.get(null!==(n=a.current)&&void 0!==n?n:t))||void 0===i?void 0:i.docIndex,c=null===(r=e.get(t))||void 0===r?void 0:r.docIndex,u=[];if("number"==typeof s&&"number"==typeof c&&s!==c){const t=Math.min(s,c),i=Math.max(s,c);e.forEach((({doc:e,docIndex:n})=>{n>=t&&n<=i&&u.push(e.id)}))}o?l(u):d(u),a.current=t}),[l,d,e,m]),h=(0,n.useCallback)((e=>e.filter((e=>m(e.id)))),[m]),f=u.length,g=(0,n.useCallback)((e=>f?e.filter(m).length:0),[f,m]);return(0,n.useMemo)((()=>({isDocSelected:m,hasSelectedDocs:f>0,selectedDocsCount:f,docIdsInSelectionOrder:u,getCountOfFilteredSelectedDocs:g,toggleDocSelection:r,toggleMultipleDocsSelection:p,selectAllDocs:s,selectMoreDocs:l,deselectSomeDocs:d,replaceSelectedDocs:o,clearAllSelectedDocs:c,getSelectedDocsOrderedByRows:h})),[m,g,r,p,s,l,d,o,c,u,f,h])})(ht),{isDocSelected:yt,hasSelectedDocs:vt,selectedDocsCount:_t,replaceSelectedDocs:bt,docIdsInSelectionOrder:St}=gt,[Tt,Et]=(0,G.SK)("pageIndex",0),zt=(0,n.useRef)(Tt);zt.current=Tt;const jt=(0,n.useCallback)((e=>{Et(e),null==$e||$e(e)}),[Et,$e]);(0,n.useEffect)((()=>{!vt&&rt&&ot(!1)}),[rt,vt,ot]);const It=x.timeFieldName,At=(0,n.useCallback)((e=>function(e,t,i,n,a){return!(!n||!t)&&(!a||!!e&&!!i&&t in i&&e.includes("_source"))}(e,It,i,A,ue)),[It,ue,A,i]),Ft=(0,n.useMemo)((()=>function(e,t,i){const n=t.timeFieldName;return i&&n&&!e.find((e=>e===n))?[n,...e]:e}(ut,x,At(ut))),[x,ut,At]),{sortedRows:Mt,sorting:Dt}=mt({rows:z,visibleColumns:Ft,columnsMeta:i,sort:P,dataView:x,isPlainRecord:ue,isSortEnabled:q,defaultColumns:pt,onSort:E}),{columns:Lt}=null!=Dt?Dt:{},Pt=(0,n.useMemo)((()=>{if(!Mt)return[];if(!rt||!vt)return Mt;const e=Mt.filter((e=>yt(e.id)));return e.length?e:Mt}),[Mt,rt,vt,yt]),Rt=(0,n.useCallback)(((e,t,n)=>te({rowIndex:e,rows:Pt,dataView:x,columnId:t,fieldFormats:Ze,columnsMeta:i,options:n})),[Pt,x,Ze,i]),Vt="number"==typeof me&&me>0?me:W.KG,Qt=(0,n.useMemo)((()=>Pt?Pt.length:0),[Pt]),Jt=(0,n.useMemo)((()=>Math.ceil(Qt/Vt)),[Qt,Vt]);(0,n.useEffect)((()=>{const e=zt.current,t=e>Jt-1?0:e;t!==e&&jt(t)}),[Jt,jt]);const Zt=(0,n.useMemo)((()=>{return V?{onChangeItemsPerPage:e=>{null==pe||pe(e)},onChangePage:jt,pageIndex:Tt,pageSize:Vt,pageSizeOptions:null!=Ae?Ae:(e=Vt,(0,R.sortBy)((0,R.uniq)("number"==typeof e&&e>0?[...W.Lo,e]:W.Lo)))}:void 0;var e}),[V,Ae,pe,Vt,Tt,jt]),ri=(0,n.useMemo)((()=>({expanded:Te,setExpanded:Se,getRowByIndex:e=>Pt[e],onFilter:k,dataView:x,selectedDocsState:gt,valueToStringConverter:Rt,componentsTourSteps:De,isPlainRecord:ue,pageIndex:V?null==Zt?void 0:Zt.pageIndex:0,pageSize:V?null==Zt?void 0:Zt.pageSize:Pt.length})),[De,x,ue,V,Pt,Te,k,Se,gt,Zt,Rt]),oi=(0,n.useMemo)((()=>((e,t,i)=>{if(i)return()=>!0;const n=new Map;return e.forEach((e=>{n.set(e,((e,t)=>{var i;const n=t.fields.getByName(e);if(!n)return{show:!0};const a=(0,m.getDataViewFieldSubtypeMulti)(n.spec);return{show:!Boolean(null==a?void 0:a.multi),parentName:null==a||null===(i=a.multi)||void 0===i?void 0:i.parent}})(e,t))})),e=>{const t=n.get(e);return!t||t.show||!!t.parentName&&!n.has(t.parentName)}})(x.fields.getAll().map((e=>e.name)),x,je)),[x,je]),{dataGridDensity:li,onChangeDataGridDensity:di}=(({storage:e,consumer:t,dataGridDensityState:i,onUpdateDataGridDensity:a})=>{const r=(0,n.useMemo)((()=>null!=i?i:((e,t)=>{var i;return null!==(i=e.get(Y(t)))&&void 0!==i?i:W.Rd.COMPACT})(e,t)),[i,e,t]),o=(0,G.OU)("density",r),s=(0,n.useMemo)((()=>i||o.current),[i,o]);return o.current=s,{dataGridDensity:s,onChangeDataGridDensity:(0,n.useCallback)((i=>{const n=(r=i).cellPadding===W.Wn.cellPadding&&r.fontSize===W.Wn.fontSize?W.Rd.COMPACT:r.cellPadding===W.MI.cellPadding&&r.fontSize===W.MI.fontSize?W.Rd.NORMAL:W.Rd.EXPANDED;var r;e.set(Y(t),n),null==a||a(n)}),[e,t,a])}})({storage:it,consumer:Me,dataGridDensityState:Be,onUpdateDataGridDensity:He}),ci=(0,n.useMemo)((()=>({...W.aD,...Q[li],onChange:di,...Le})),[li,di,Le]),ui=(0,n.useMemo)((()=>(0,re.S)({dataView:x,rows:Pt,shouldShowFieldHandler:oi,closePopover:()=>{var e;return null===(e=at.current)||void 0===e?void 0:e.closeCellPopover()},fieldFormats:Ze,maxEntries:Ie,externalCustomRenderers:Fe,isPlainRecord:ue,isCompressed:li===W.Rd.COMPACT,columnsMeta:i})),[x,Pt,oi,Ie,Ze,Fe,ue,li,i]),{dataGridId:mi,dataGridWrapper:pi,setDataGridWrapper:hi}=(()=>{const e=(0,d.useGeneratedHtmlId)({prefix:"unifiedDataTable"}),[t,i]=(0,n.useState)(null),[a,r]=(0,n.useState)(null),o=(0,n.useCallback)(((t,i)=>{const n=document.getElementById(e);n&&(r(n),i.disconnect())}),[e]),s=(0,n.useCallback)((()=>{a&&(e=>{e.classList.contains(Ut)?document.body.classList.add(...Bt):document.body.classList.remove(...Bt)})(a)}),[a]);return(0,d.useMutationObserver)(t,o,{childList:!0,subtree:!0}),(0,d.useMutationObserver)(a,s,{attributes:!0,attributeFilter:["class"]}),{dataGridId:e,dataGridWrapper:t,setDataGridWrapper:i}})(),fi=(0,G.OU)("inTableSearch",void 0),gi=(0,n.useCallback)((e=>{fi.current=e}),[fi]),{inTableSearchTermCss:yi,inTableSearchControl:vi,cellContextWithInTableSearchSupport:_i,renderCellValueWithInTableSearchSupport:bi}=(e=>{var t;const{enableInTableSearch:i=!0,dataGridWrapper:a,dataGridRef:r,visibleColumns:o,rows:s,renderCellValue:c,pagination:u,cellContext:m,initialState:p,onInitialStateChange:h}=e,{euiTheme:g}=(0,d.useEuiTheme)(),y=Boolean(u),v=y&&(null==u?void 0:u.pageSize)||null,_=null==u?void 0:u.onChangePage,b=(0,n.useRef)();b.current=null!==(t=null==u?void 0:u.pageIndex)&&void 0!==t?t:0;const[x]=(0,n.useState)((()=>p)),w=f()(h),[k]=(0,n.useState)((()=>w.current)),S=(0,n.useMemo)((()=>{const e=D(g);return((e,t,i)=>{const n=e;return({inTableSearchTerm:e,onHighlightsCountFound:a,...r})=>(0,l.jsx)(O,{key:`cell-${e||""}`,inTableSearchTerm:e,highlightColor:t,highlightBackgroundColor:i,onHighlightsCountFound:a},(0,l.jsx)(n,r))})(c,e.highlightColor,e.highlightBackgroundColor)}),[c,g]),[{inTableSearchTerm:T,inTableSearchTermCss:E},z]=(0,n.useState)((()=>({inTableSearchTerm:(null==x?void 0:x.searchTerm)||"",inTableSearchTermCss:null!=x&&x.searchTerm&&null!=x&&x.activeMatch?L({activeMatch:x.activeMatch,colors:D(g)}):void 0}))),j=(0,n.useMemo)((()=>{if(!i)return;const e=a?a.querySelectorAll(".euiDataGridHeaderCell--controlColumn").length:0;return(0,l.jsx)(N,{initialState:x,onInitialStateChange:k,inTableSearchTerm:T,visibleColumns:o,rows:s,renderCellValue:S,pageSize:v,getColumnIndexFromId:t=>o.indexOf(t)+e,scrollToCell:e=>{var t,i;null===(t=r.current)||void 0===t||null===(i=t.scrollToItem)||void 0===i||i.call(t,e)},shouldOverrideCmdF:e=>{var t,i;return!!a&&null!==(t=null===(i=a.contains)||void 0===i?void 0:i.call(a,e))&&void 0!==t&&t},onChange:e=>{const t=e||"";z({inTableSearchTerm:t}),t||U()},onChangeCss:e=>z((t=>({...t,inTableSearchTermCss:e}))),onChangeToExpectedPage:e=>{y&&b.current!==e&&(null==_||_(e))}})}),[i,z,o,s,S,r,a,T,y,v,_,x,k]),I=(0,n.useMemo)((()=>{if(T||m)return{...m,inTableSearchTerm:T}}),[m,T]);return(0,n.useEffect)((()=>()=>{U()}),[]),(0,n.useMemo)((()=>({inTableSearchTermCss:E,inTableSearchControl:j,cellContextWithInTableSearchSupport:I,renderCellValueWithInTableSearchSupport:S})),[E,j,I,S])})({enableInTableSearch:Oe,dataGridWrapper:pi,dataGridRef:at,visibleColumns:Ft,rows:Pt,renderCellValue:ui,cellContext:qe,pagination:Zt,initialState:fi.current,onInitialStateChange:gi}),xi=(0,n.useMemo)((()=>{if(!We)return null!=Ve?Ve:(()=>{const e=(0,n.memo)((function(e){const{columnId:t,setCellPopoverProps:i,DefaultCellPopover:a}=e;return(0,n.useEffect)((()=>{const e={panelClassName:"unifiedDataTable__cellPopover"};Ht.includes(t)&&(e.panelProps={css:{maxInlineSize:"min(75vw, 600px) !important"}}),i(e)}),[t,i]),(0,l.jsx)(a,e)}));return t=>(0,l.jsx)(e,t)})()}),[Ve,We]),wi=(0,n.useMemo)((()=>(0,d.htmlIdGenerator)()()),[]),ki=(0,n.useRef)();(0,n.useEffect)((()=>()=>{null!=ki&&ki.current&&(null==ki||ki.current())}),[]);const Si=(0,n.useMemo)((()=>he?async e=>{var t;const i=Ye?await(0,p.A)(x,nt.dataViews):x;ki.current=he&&await(null==fe||null===(t=fe.dataViewFieldEditor)||void 0===t?void 0:t.openEditor({ctx:{dataView:i},fieldName:e,onSave:async()=>{await he({editedDataView:i})}}))}:void 0),[nt.dataViews,x,he,null==fe?void 0:fe.dataViewFieldEditor,Ye]),Ti=(0,n.useCallback)(((e,t)=>Pt[t%Pt.length].flattened[e]),[Pt]),Ei=(0,n.useMemo)((()=>{if(K)return Ft.map((e=>{var t;const n=(0,$.u)({dataView:x,fieldName:e,columnMeta:null==i?void 0:i[e]});return null!==(t=null==n?void 0:n.toSpec())&&void 0!==t?t:{name:"",type:"",aggregatable:!1,searchable:!1}}))}),[K,Ft,x,i]),zi=(0,n.useMemo)((()=>({dataViewId:x.id,...null!=Z?Z:{}})),[x,Z]),ji=(0,u.ok)({fields:Ei,getCellValue:Ti,triggerId:K,dataGridRef:at,metadata:zi,disableCellActions:Ge}),{rowHeight:Ii,rowHeightLines:Ci,lineCountInput:Ai,onChangeRowHeight:Fi,onChangeRowHeightLines:Mi}=Ot({type:Nt.header,storage:it,consumer:Me,key:"dataGridHeaderRowHeight",defaultRowHeight:1,configRowHeight:g,rowHeightState:y,onUpdateRowHeight:v}),{rowHeight:Di,rowHeightLines:Li,lineCountInput:Pi,onChangeRowHeight:Ni,onChangeRowHeightLines:Ri}=Ot({type:Nt.row,storage:it,consumer:Me,key:"dataGridRowHeight",defaultRowHeight:W.H0.default,configRowHeight:ze,rowHeightState:ne,onUpdateRowHeight:ae}),Oi=(0,n.useMemo)((()=>function({columns:e,columnsCellActions:t,cellActionsHandling:i,rowsCount:n,settings:a,dataView:r,defaultColumns:o,isSortEnabled:s,disableCellActions:l=!1,isPlainRecord:d,services:c,hasEditDataViewPermission:u,valueToStringConverter:m,onFilter:p,editField:h,visibleCellActions:f,columnsMeta:g,showColumnTokens:y,headerRowHeightLines:v,customGridColumnsConfiguration:_,onResize:b,sortedColumns:x}){const w=e=>{var t,i,n;return null!==(t=null==a||null===(i=a.columns)||void 0===i||null===(n=i[e])||void 0===n?void 0:n.width)&&void 0!==t?t:0},k=(e=>{if(e!==W.H0.auto)return e})(v),S=e.length;return e.map(((e,v)=>{var T,E;return wt({numberOfColumns:S,columnName:e,columnCellActions:null==t?void 0:t[v],cellActionsHandling:i,columnWidth:w(e),dataView:r,defaultColumns:o,isSortEnabled:s,isPlainRecord:d,toastNotifications:c.toastNotifications,hasEditDataViewPermission:u,valueToStringConverter:m,rowsCount:n,onFilter:p,editField:h,visibleCellActions:f,columnsMeta:g,showColumnTokens:y,headerRowHeight:k,customGridColumnsConfiguration:_,columnDisplay:null==a||null===(T=a.columns)||void 0===T||null===(E=T[e])||void 0===E?void 0:E.display,onResize:b,sortedColumns:x,disableCellActions:l})}))}({columns:Ft,columnsCellActions:ji,cellActionsHandling:X,rowsCount:Pt.length,settings:C,dataView:x,defaultColumns:pt,isSortEnabled:q,isPlainRecord:ue,services:{uiSettings:tt,toastNotifications:Xe},hasEditDataViewPermission:()=>{var e;return Boolean(null==et||null===(e=et.userPermissions)||void 0===e?void 0:e.editIndexPattern())},valueToStringConverter:Rt,onFilter:k,editField:Si,visibleCellActions:ee,columnsMeta:i,showColumnTokens:r,headerRowHeightLines:Ci,customGridColumnsConfiguration:Ne,onResize:S,sortedColumns:Lt,disableCellActions:Ge})),[X,i,ji,Ne,x,et,pt,Pt.length,Si,Ci,ue,q,k,S,C,r,Xe,tt,Rt,ee,Ft,Lt,Ge]),qi=(0,n.useMemo)((()=>[{type:W.P2,detector:()=>0,sortTextAsc:"",sortTextDesc:"",icon:"",color:""}]),[]),Vi=(0,n.useMemo)((()=>({canDragAndDropColumns:!pt&&h,visibleColumns:Ft,setVisibleColumns:e=>{const t=!At(e);T(e,t)}})),[Ft,T,At,h,pt]),Ui=Boolean(Se&&!!ke),Bi=(0,n.useMemo)((()=>{const{leadColumns:e,leadColumnsExtraContent:t}=function({rows:e,canSetExpandedDoc:t}){return{leadColumns:[xt(e)],leadColumnsExtraContent:t?[le]:[]}}({rows:Pt,canSetExpandedDoc:Ui}),i=e.filter((e=>_.includes(e.id)));if(Ue){const e=(({getRowIndicator:e})=>({id:"colorIndicator",width:4,headerCellRender:()=>null,rowCellRender:({rowIndex:t,setCellProps:i})=>(0,l.jsx)(Wt,{rowIndex:t,setCellProps:i,getRowIndicator:e})}))({getRowIndicator:Ue});i.unshift(e)}const n=(({baseColumns:e,externalControlColumns:t,rowAdditionalLeadingControls:i})=>{if(!(e.length||null!=t&&t.length||null!=i&&i.length))return null;let n=e.length*W.ug;const a=[...e];if(null!=t&&t.length&&(a.length>0&&(a.push(ei),n+=4),a.push(...t.map((e=>e.rowCellRender))),n+=t.reduce(((e,t)=>e+t.width),0)),null!=i&&i.length){const e=(r=i).length<=2?r.map(Yt):[Yt(r[0]),Kt(r.slice(1))];a.push(...e),n+=W.ug*e.length}var r;return{id:"actions",width:n,headerCellProps:{className:"unifiedDataTable__headerCell"},rowCellRender:e=>(0,l.jsx)(d.EuiFlexGroup,{"data-test-subj":"unifiedDataTable_actionsColumnCell",responsive:!1,alignItems:"center",gutterSize:"none"},a.map(((t,i)=>(0,l.jsx)(t,(0,Ee.default)({key:i},e))))),headerCellRender:()=>(0,l.jsx)(Xt,{maxWidth:n})}})({baseColumns:t,rowAdditionalLeadingControls:b,externalControlColumns:ve});return n&&i.push(n),i}),[Ui,_,Pt,ve,Ue,b]),Hi=(0,n.useMemo)((()=>{if(!Ce&&!_t&&!vi)return null;const e=(0,l.jsx)(a().Fragment,null,Boolean(_t)&&(0,l.jsx)(xe,{isPlainRecord:ue,isFilterActive:rt,rows:z,setIsFilterActive:ot,selectedDocsState:gt,enableComparisonMode:Re,setIsCompareActive:lt,fieldFormats:Ze,pageIndex:ri.pageIndex,pageSize:ri.pageSize,toastNotifications:Xe,columns:Ft,customBulkActions:Qe}),Ce);return!ye&&vi?{left:e,right:vi}:e}),[Ce,_t,vi,ue,rt,z,gt,Re,ot,lt,Ze,ri.pageIndex,ri.pageSize,Xe,Ft,ye,Qe]),$i=(0,n.useMemo)((()=>ye?e=>ye({toolbarProps:e,gridProps:{additionalControls:Hi&&"left"in Hi?Hi.left:Hi,inTableSearchControl:vi}}):void 0),[ye,Hi,vi]),Gi=(0,n.useMemo)((()=>{if(He||ae||v||ce)return{allowDensity:Boolean(He),allowRowHeight:Boolean(Ni)||Boolean(Fi),allowResetButton:!1,customRender:({densityControl:e})=>(0,l.jsx)(a().Fragment,null,(0,l.jsx)(Ct,{rowHeight:Di,onChangeRowHeight:Ni,onChangeRowHeightLines:Ri,headerRowHeight:Ii,onChangeHeaderRowHeight:Fi,onChangeHeaderRowHeightLines:Mi,maxAllowedSampleSize:se,sampleSize:de,onChangeSampleSize:ce,lineCountInput:Pi,headerLineCountInput:Ai,densityControl:e}))}}),[Ii,se,Fi,Mi,Ni,Ri,v,ae,ce,Di,de,He,Pi,Ai]),Wi=(0,n.useMemo)((()=>pt?{...W.wb,showColumnSelector:!1,showSortSelector:q,additionalControls:Hi,showDisplaySelector:Gi,showKeyboardShortcuts:F,showFullScreenSelector:M}:{...W.wb,showSortSelector:q,additionalControls:Hi,showDisplaySelector:Gi,showKeyboardShortcuts:F,showFullScreenSelector:M}),[pt,q,Hi,Gi,F,M]),Qi=(({rowHeightLines:e,rowLineHeight:t=W.hp})=>(0,n.useMemo)((()=>{var i;return{defaultHeight:(i=e)===W.H0.auto?"auto":{lineCount:i},lineHeight:t}}),[e,t]))({rowHeightLines:Li,rowLineHeight:Pe}),Yi=(0,n.useCallback)((e=>{ct((t=>{if(w!==ni.loaded)return t;const i=null==pi?void 0:pi.querySelector(".euiDataGrid__virtualized");if(!i)return t;const n=t?140:100,a=i.scrollHeight>i.offsetHeight,r=e.scrollTop+i.offsetHeight>=i.scrollHeight-n;return a&&r}))}),[pi,w]),{run:Ji}=function(e,t){var i;if(!(0,R.isFunction)(e))throw Error("useThrottleFn expected parameter is a function, got "+typeof e);const a=f()(e),r=null!==(i=null==t?void 0:t.wait)&&void 0!==i?i:1e3,o=(0,n.useMemo)((()=>(0,R.throttle)(((...e)=>a.current(...e)),r,t)),[a,t,r]);return H()((()=>{o.cancel()})),{run:o,cancel:o.cancel,flush:o.flush}}(Yi,{wait:200});(0,n.useEffect)((()=>{w===ni.loadingMore&&ct(!1)}),[w]);const Ki=(0,n.useMemo)((()=>{const e={onScroll:"multiPage"===B?void 0:Ji};return pt?e:{...ii,...e}}),[pt,B,Ji]),Zi=w!==ni.loading;return Qt||w!==ni.loading?Qt?(0,l.jsx)(oe.o.Provider,{value:ri},(0,l.jsx)("span",{className:"unifiedDataTable__inner",css:Ke.dataTableInner},(0,l.jsx)(l.Global,{styles:Ke.dataTableGlobal}),(0,l.jsx)("div",{ref:hi,key:st?"comparisonTable":"docTable","data-test-subj":"discoverDocTable","data-render-complete":Zi,"data-shared-item":"","data-rendering-count":1,"data-title":I,"data-description":j,"data-document-number":Pt.length,className:o()(ie,"unifiedDataTable__table"),css:[Ke.dataTable,yi,"",""]},st?(0,l.jsx)(qt,{id:mi,wrapper:pi,consumer:Me,ariaDescribedBy:wi,ariaLabelledBy:e,dataView:x,isPlainRecord:ue,selectedFieldNames:Ft,selectedDocIds:St,schemaDetectors:qi,forceShowAllFields:pt,showFullScreenButton:M,fieldFormats:Ze,getDocById:ft,replaceSelectedDocs:bt,setIsCompareActive:lt}):(0,l.jsx)(ai,{id:mi,"aria-describedby":wi,"aria-labelledby":e,columns:Oi,columnVisibility:Vi,"data-test-subj":"docTable",leadingControlColumns:Bi,onColumnResize:S,pagination:"multiPage"===B?Zt:void 0,renderCellValue:bi,ref:at,rowCount:Qt,schemaDetectors:qi,sorting:Dt,toolbarVisibility:Wi,rowHeightsOptions:Qi,gridStyle:ci,renderCustomGridBody:ge,renderCustomToolbar:$i,trailingControlColumns:_e,cellContext:_i,renderCellPopover:xi,virtualizationOptions:Ki})),w!==ni.loading&&V&&!rt&&!st&&(0,l.jsx)(kt,{isLoadingMore:w===ni.loadingMore,rowCount:Qt,sampleSize:de,pageCount:Jt,pageIndex:null==Zt?void 0:Zt.pageIndex,totalHits:be,onFetchMoreRecords:we,data:nt,fieldFormats:Ze,paginationMode:B,hasScrolledToBottom:"multiPage"===B||dt}),I&&(0,l.jsx)(d.EuiScreenReaderOnly,null,(0,l.jsx)("p",{id:String(wi)},j?(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.searchGenerationWithDescriptionGrid",defaultMessage:"Table generated by Discover session ''{searchTitle}'' ({searchDescription})",values:{searchTitle:I,searchDescription:j}}):(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.searchGenerationWithDescription",defaultMessage:"Table generated by Discover session ''{searchTitle}''",values:{searchTitle:I}}))),Ui&&Te&&ke(Te,Pt,ut,i))):(0,l.jsx)("div",{className:"euiDataGrid__noResults",css:Ke.loadingAndEmpty,"data-render-complete":Zi,"data-shared-item":"","data-title":I,"data-description":j,"data-document-number":0},(0,l.jsx)(d.EuiText,{size:"xs",color:"subdued"},(0,l.jsx)(d.EuiIcon,{type:"discoverApp",size:"m",color:"subdued"}),(0,l.jsx)(d.EuiSpacer,{size:"s"}),(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.noResultsFound",defaultMessage:"No results found"}))):(0,l.jsx)("div",{className:"euiDataGrid__loading",css:Ke.loadingAndEmpty,"data-test-subj":"unifiedDataTableLoading"},(0,l.jsx)(d.EuiText,{size:"xs",color:"subdued"},(0,l.jsx)(d.EuiLoadingSpinner,null),(0,l.jsx)(d.EuiSpacer,{size:"s"}),(0,l.jsx)(s.FormattedMessage,{id:"unifiedDataTable.loadingResults",defaultMessage:"Loading results"})))})),oi=(0,G.be)(ri),si={loadingAndEmpty:{name:"1ym6rfo",styles:"display:flex;flex-direction:column;justify-content:center;align-items:center;flex:1 0 100%;height:100%;width:100%"},dataTableGlobal:({euiTheme:e})=>(0,l.css)({".unifiedDataTable__headerCell":{alignItems:"start !important",".euiDataGridHeaderCell__draggableIcon":{paddingBlock:`calc(${e.size.xs} / 2) !important`},".euiDataGridHeaderCell__button":{marginTop:`-${e.size.xs} !important`}}},"",""),dataTableInner:({euiTheme:e})=>(0,l.css)({display:"flex",flexDirection:"column",flexWrap:"nowrap",height:"100%",".unifiedDataTable__cell--highlight":{backgroundColor:e.colors.backgroundBaseWarning},".unifiedDataTable__cell--expanded":{backgroundColor:e.colors.backgroundBaseInteractiveSelect},".unifiedDataTable__cellValue":{fontFamily:e.font.familyCode},".unifiedDataTable__rowControl":{marginTop:-1},".euiDataGrid--fontSizeSmall .euiDataGridRowCell__content:not(.euiDataGridRowCell__content--defaultHeight) .unifiedDataTable__rowControl":{marginTop:-2.5},".euiDataGrid--fontSizeSmall .euiDataGridRowCell__content--defaultHeight .unifiedDataTable__rowControl":{alignSelf:"flex-start",marginTop:-3},".euiDataGrid__content":{background:"transparent"},".euiDataGrid--bordersHorizontal .euiDataGridHeader":{borderTop:"none"},".euiDataGrid--headerUnderline .euiDataGridHeader":{borderBottom:e.border.thin},'.euiDataGridRowCell--controlColumn .euiDataGridRowCell__content, .euiDataGridRowCell.euiDataGridRowCell--controlColumn[data-gridcell-column-id="openDetails"], .euiDataGridRowCell.euiDataGridRowCell--controlColumn[data-gridcell-column-id="select"], .euiDataGridRowCell.euiDataGridRowCell--controlColumn[data-gridcell-column-id^="additionalRowControl_"], .euiDataGridHeaderCell.euiDataGridHeaderCell--controlColumn[data-gridcell-column-id^="additionalRowControl_"]':{paddingLeft:0,paddingRight:0,borderLeft:0,borderRight:0},'.euiDataGridRowCell.euiDataGridRowCell--controlColumn[data-gridcell-column-id="additionalRowControl_menuControl"] .euiDataGridRowCell__content':{paddingBottom:0},'.euiDataGridHeaderCell.euiDataGridHeaderCell--controlColumn[data-gridcell-column-id="select"]':{paddingLeft:e.size.xs,paddingRight:0},'.euiDataGridHeaderCell.euiDataGridHeaderCell--controlColumn[data-gridcell-column-id="colorIndicator"], .euiDataGridRowCell.euiDataGridRowCell--controlColumn[data-gridcell-column-id="colorIndicator"]':{padding:0,borderLeft:0,borderRight:0},'.euiDataGridRowCell.euiDataGridRowCell--controlColumn[data-gridcell-column-id="colorIndicator"] .euiDataGridRowCell__content':{height:"100%",borderBottom:0},".euiDataGrid__scrollOverlay .euiDataGrid__scrollBarOverlayRight":{backgroundColor:"transparent"},".euiDataGridRowCell__content--autoHeight, .euiDataGridRowCell__content--lineCountHeight, .euiDataGridHeaderCell__content":{whiteSpace:"pre-wrap"}},"",""),dataTable:{name:"zhezlv",styles:"flex-grow:1;flex-shrink:1;min-height:0"}}},66806:(e,t,i)=>{"use strict";i.d(t,{H0:()=>d,KG:()=>r,Lo:()=>s,MI:()=>f,Nr:()=>m,Og:()=>g,P2:()=>p,Rd:()=>_,Wn:()=>h,YQ:()=>a,aD:()=>y,c1:()=>u,d1:()=>l,hp:()=>c,k$:()=>o,ug:()=>n,wb:()=>v});const n=24,a="_score",r=100,o=1e4,s=[10,25,50,r,250,500],l="multiPage",d={auto:-1,single:1,default:3},c="1.6em",u=370,m=212,p="kibana-json",h={cellPadding:"s",fontSize:"s"},f={cellPadding:"m",fontSize:"m"},g={cellPadding:"l",fontSize:"l"},y={...h,border:"horizontal",stripes:!0,rowHover:"highlight",header:"underline"},v={showColumnSelector:{allowHide:!1,allowReorder:!0}};let _=function(e){return e.COMPACT="compact",e.NORMAL="normal",e.EXPANDED="expanded",e}({})},50838:(e,t,i)=>{"use strict";i.d(t,{HY:()=>s,OU:()=>o,SK:()=>r,be:()=>a});var n=i(11978);const{withRestorableState:a,useRestorableState:r,useRestorableRef:o,useRestorableLocalStorage:s}=(0,n.k)()},95085:(e,t,i)=>{"use strict";i.d(t,{o:()=>r});var n=i(84286);const a={},r=i.n(n)().createContext(a)},42526:(e,t,i)=>{"use strict";i.d(t,{JR:()=>n,ZA:()=>r,_U:()=>o});const n="_source",a=[n];function r(e=[],t){return e&&e.length>0&&(1!==e.length||e[0]!==t.timeFieldName)?e:a}function o(e,t){return Object.fromEntries(Object.entries(e).filter((([e])=>e.startsWith(`${t}.`))))}},81091:(e,t,i)=>{"use strict";i.d(t,{Q:()=>C,S:()=>F});var n=i(84286),a=i(75008),r=i(81319),o=i(82478),s=i(84701),l=i(95085),d=i(96791);const c=new WeakMap;var u=i(60649),m=i(65927),p=i.n(m),h=i(42526);function f({useTopLevelObjectColumns:e,row:t,columnId:i,dataView:o,shouldShowFieldHandler:l,maxEntries:m,isPlainRecord:f,fieldFormats:y,dataTestSubj:v="discoverCellDescriptionList",className:_,isCompressed:b=!0}){const x=(0,u.d)(g),w=e?function(e,t,i,n,a){var r;const o=(0,h._U)(e.fields,t),l=null!==(r=e.highlight)&&void 0!==r?r:{},d=[],c=[];return Object.entries(o).forEach((([t,r])=>{var o;const u=i.getFieldByName(t),m=i.fields.getByName?null===(o=i.fields.getByName(t))||void 0===o?void 0:o.displayName:void 0,p=r.map((t=>(0,s.D)(t,e,a,i,u))).join(", "),h=l[t]?d:c;m?n(m)&&h.push([m,p,t]):h.push([t,p,t])})),[...d,...c]}(t.raw,i,o,l,y).slice(0,m):function(e,t,i,n,r){var o;const l=c.get(e.raw);if(l&&l.maxEntries===n)return l.formattedHit;const d=null!==(o=e.raw.highlight)&&void 0!==o?o:{},u=e.flattened,m=[],p=[];for(const e of Object.keys(u)){const n=t.fields.getByName(e),a=null==n?void 0:n.displayName,r=d[e]?m:p;if(a){var h,f;const t=null===(h=n.getSubtypeMulti)||void 0===h||null===(f=h.call(n))||void 0===f?void 0:f.multi.parent,o=Boolean(d[e]),s=Boolean(t&&d[t]);(o&&!s||i(e))&&r.push([a,void 0,e])}else r.push([e,void 0,e])}const g=m.length+p.length;if(m.length>n)m.length=n;else if(m.length<n&&p.length)for(let e=0;e<p.length&&m.length<n;e++)m.push(p[e]);for(const i of m){const n=i[2];i[1]=(0,s.D)(u[n],e.raw,r,t,t.getFieldByName(n))}g>n&&m.push([a.i18n.translate("discover.formatHit.moreFields",{defaultMessage:"and {count} more {count, plural, one {field} other {fields}}",values:{count:g-n}}),"",null]);const y=m;return c.set(e.raw,{formattedHit:y,maxEntries:n}),y}(t,o,l,m,y);return(0,d.jsx)(r.EuiDescriptionList,{type:"inline",compressed:b,className:p()("unifiedDataTable__descriptionList","unifiedDataTable__cellValue",_),css:x.descriptionList,"data-test-subj":v},w.map((([e,i,a])=>{var o;return f&&a&&null===(null!==(o=t.flattened[a])&&void 0!==o?o:null)?null:(0,d.jsx)(n.Fragment,{key:e},(0,d.jsx)(r.EuiDescriptionListTitle,{className:"unifiedDataTable__descriptionListTitle"},e),(0,d.jsx)(r.EuiDescriptionListDescription,{className:"unifiedDataTable__descriptionListDescription",dangerouslySetInnerHTML:{__html:i}}))})))}const g={descriptionList:({euiTheme:e})=>(0,d.css)({".euiDataGridRowCell__content--defaultHeight &":{WebkitLineClamp:1,display:"-webkit-box",WebkitBoxOrient:"vertical",height:"100%",overflow:"hidden"},".unifiedDataTable__descriptionListTitle":{marginInline:"0 0",paddingInline:0,background:"transparent",fontWeight:e.font.weight.bold,lineHeight:"inherit"},".unifiedDataTable__descriptionListDescription":{marginInline:`${e.size.s} ${e.size.s}`,paddingInline:0,wordBreak:"break-all",whiteSpace:"normal",lineHeight:"inherit","& img":{verticalAlign:"middle",maxHeight:`${(0,r.euiLineHeightFromBaseline)("xs",e)} !important`,maxWidth:`calc(${e.size.xxl} * 12.5) !important`}}},"","")};var y=i(30911),v=i(9424);const _=a.i18n.translate("unifiedDataTable.json.codeEditorAriaLabel",{defaultMessage:"Read only JSON view of an elasticsearch document"}),b=a.i18n.translate("unifiedDataTable.json.copyToClipboardLabel",{defaultMessage:"Copy to clipboard"}),x=({jsonValue:e,width:t,height:i,hasLineNumbers:n,onEditorDidMount:a,hideCopyButton:o})=>{if(""===e)return null;const s=(0,d.jsx)(v.CodeEditor,{languageId:y.XJsonLang.ID,width:t,height:i,value:e||"",editorDidMount:a,"aria-label":_,options:{automaticLayout:!0,fontSize:12,lineNumbers:n?"on":"off",minimap:{enabled:!1},overviewRulerBorder:!1,readOnly:!0,scrollbar:{alwaysConsumeMouseWheel:!1},scrollBeyondLastLine:!1,wordWrap:"on",wrappingIndent:"indent"}});return o?s:(0,d.jsx)(r.EuiFlexGroup,{css:w.jsonEditor,direction:"column",gutterSize:"s"},(0,d.jsx)(r.EuiFlexItem,null,(0,d.jsx)(r.EuiSpacer,{size:"s"}),(0,d.jsx)("div",{className:"eui-textRight"},(0,d.jsx)(r.EuiCopy,{textToCopy:e},(e=>(0,d.jsx)(r.EuiButtonEmpty,{size:"xs",flush:"right",iconType:"copyClipboard",onClick:e},b))))),(0,d.jsx)(r.EuiFlexItem,null,s))},w={jsonEditor:{name:"1d3w5wq",styles:"width:100%"}};function k({json:e,width:t,height:i,hasLineNumbers:n}){const a=JSON.stringify(e,null,2);return(0,d.jsx)(x,{jsonValue:a,width:t,height:i,hasLineNumbers:n,onEditorDidMount:()=>{},hideCopyButton:!0})}var S=i(66806);function T(e,t,i){return i?(0,h._U)(t.raw.fields,e):t.raw}const E=({closeButton:e,columnId:t,row:i,useTopLevelObjectColumns:n,dataTestSubj:a="dataTableExpandCellActionJsonPopover"})=>(0,d.jsx)(r.EuiFlexGroup,{gutterSize:"none",direction:"column",justifyContent:"flexEnd",className:"unifiedDataTable__cellPopover",css:z.cellPopover,"data-test-subj":a},(0,d.jsx)(r.EuiFlexItem,{grow:!1},(0,d.jsx)(r.EuiFlexGroup,{justifyContent:"flexEnd",gutterSize:"none",responsive:!1},(0,d.jsx)(r.EuiFlexItem,{grow:!1},e))),(0,d.jsx)(r.EuiFlexItem,null,(0,d.jsx)(k,{json:T(t,i,n),width:S.c1,height:200}))),z={cellPopover:{name:"njjcsq",styles:".lines-content.monaco-editor-background{overflow:unset !important;contain:unset !important;}"}},j=({children:e})=>{const t=(0,u.d)(I);return(0,d.jsx)("span",{className:"unifiedDataTable__cellPopoverValue eui-textBreakWord",css:t.popover},e)},I={popover:e=>{const{euiTheme:t}=e,{fontSize:i}=(0,r.euiFontSize)(e,"s");return(0,d.css)({fontFamily:t.font.familyCode,fontSize:i},"","")}},C="unifiedDataTable__cellValue",A="undefined"!=typeof jest,F=({dataView:e,rows:t,shouldShowFieldHandler:i,closePopover:c,fieldFormats:u,maxEntries:m,externalCustomRenderers:p,isPlainRecord:h,isCompressed:g=!0,columnsMeta:y})=>{const v=({rowIndex:v,columnId:_,isDetails:b,setCellProps:x,colIndex:w,isExpandable:k,isExpanded:S})=>{const T=t?t[v]:void 0,z=(0,o.u)({dataView:e,fieldName:_,columnMeta:null==y?void 0:y[_]}),I=(0,n.useContext)(l.o);if((0,n.useEffect)((()=>{null!=T&&T.isAnchor?x({className:"unifiedDataTable__cell--highlight"}):I.expanded&&T&&I.expanded.id===T.id?x({className:"unifiedDataTable__cell--expanded"}):x({style:void 0})}),[I,T,x,_]),void 0===T)return(0,d.jsx)("span",{className:C},"-");const A=null==p?void 0:p[_];if(A)return(0,d.jsx)("span",{className:C},(0,d.jsx)(A,{rowIndex:v,columnId:_,isDetails:b,setCellProps:x,isExpandable:k,isExpanded:S,colIndex:w,row:T,dataView:e,fieldFormats:u,closePopover:c,isCompressed:g}));const F=Boolean(!z&&(null==T?void 0:T.raw.fields)&&!T.raw.fields[_]);return b?function({row:e,field:t,columnId:i,dataView:n,useTopLevelObjectColumns:o,fieldFormats:l,closePopover:c}){const u=(0,d.jsx)(r.EuiButtonIcon,{"aria-label":a.i18n.translate("unifiedDataTable.grid.closePopover",{defaultMessage:"Close popover"}),"data-test-subj":"docTableClosePopover",iconSize:"s",iconType:"cross",size:"xs",onClick:c});return o||"_source"===(null==t?void 0:t.type)?(0,d.jsx)(E,{row:e,columnId:i,useTopLevelObjectColumns:o,closeButton:u}):(0,d.jsx)(r.EuiFlexGroup,{gutterSize:"none",direction:"row",responsive:!1,"data-test-subj":"dataTableExpandCellActionPopover"},(0,d.jsx)(r.EuiFlexItem,null,(0,d.jsx)(j,null,(0,d.jsx)("span",{dangerouslySetInnerHTML:{__html:(0,s.D)(e.flattened[i],e.raw,l,n,t)}}))),(0,d.jsx)(r.EuiFlexItem,{grow:!1},u))}({row:T,field:z,columnId:_,dataView:e,useTopLevelObjectColumns:F,fieldFormats:u,closePopover:c}):"_source"===(null==z?void 0:z.type)||F?(0,d.jsx)(f,{useTopLevelObjectColumns:F,row:T,dataView:e,columnId:_,fieldFormats:u,shouldShowFieldHandler:i,maxEntries:m,isPlainRecord:h,isCompressed:g}):(0,d.jsx)("span",{className:C,dangerouslySetInnerHTML:{__html:(0,s.D)(T.flattened[_],T.raw,u,e,z)}})};return A?v:(0,n.memo)(v)}},97536:(e,t,i)=>{"use strict";i.d(t,{o:()=>r});var n=i(84286),a=i(30770);const r=({onChange:e,value:t,defaultValue:i},{allowFalsyValue:r,wait:o=256}={wait:256})=>{const[s,l]=(0,n.useState)(t),d=(0,n.useRef)(!1),c=Boolean(r),u=(0,n.useRef)(null!=i?i:t),m=(0,n.useRef)(),p=(0,n.useMemo)((()=>{const t=(0,a.debounce)((t=>{e(t),m.current=setTimeout((()=>{d.current=!1}),o)}),o);return e=>{m.current&&clearTimeout(m.current),d.current=!0,t(e)}}),[e,o]);return(0,n.useEffect)((()=>{d.current||t===s||l(t)}),[t,s]),{inputValue:s,handleInputChange:e=>{l(e);const t=c?null!=e?e:u.current:e||u.current;p(t)},initialValue:u.current}}},53120:(e,t,i)=>{"use strict";i.d(t,{T:()=>a});var n=i(87834);function a(e){return n.vk((e=>"string"==typeof e?""===e?[]:e.split(","):e),n.YO(e))}},8121:(e,t,i)=>{"use strict";i.d(t,{X:()=>o});var n=i(87834),a=i(76494),r=i.n(a);function o(e,t){var i;i=e,!isNaN(Date.parse(i))||i.trim().startsWith("now")&&Boolean(r().parse(i))||t.addIssue({code:n.eq.custom,message:"Failed to parse date-math expression"})}},13191:(e,t,i)=>{"use strict";i.d(t,{s:()=>o});var n=i(68915),a=i(87834);let r=function(e){return e.BooleanFromString="BooleanFromString",e.PassThroughAny="PassThroughAny",e}({});class KbnZodBooleanFromString extends a.fZ{constructor(...e){super(...e),(0,n.default)(this,"kbnTypeName",r.BooleanFromString)}static create(){return new KbnZodBooleanFromString({typeName:a.kY.ZodUnion,options:[a.k5(["true","false"]),a.zM()]}).describe("A boolean value, which can be 'true' or 'false' as string or a native boolean.")}_parse(e){const t=super._parse(e);if(a.fn(t)){const e=t.value;return{status:"valid",value:"true"===e||"false"!==e&&e}}return t}}const o=KbnZodBooleanFromString.create()},7187:(e,t,i)=>{"use strict";i.d(t,{b:()=>a});var n=i(87834);function a(e,t){""===e.trim()&&t.addIssue({code:n.eq.custom,message:"No empty strings allowed"})}n.Yj().min(1).superRefine(a)},53296:(e,t,i)=>{"use strict";i.d(t,{M:()=>n});const n=e=>e},56268:(e,t,i)=>{"use strict";i.d(t,{kO:()=>c,tj:()=>u,IG:()=>l});var n=i(3185),a=(i(84286),i(81319)),r=i(75008),o=i(96791);const s=e=>(0,o.jsx)("svg",(0,n.default)({xmlns:"http://www.w3.org/2000/svg",height:"100%",width:"100%",viewBox:"0 0 64 64",fill:"none"},e),(0,o.jsx)("path",{fill:"#F04E98",d:"M36 28h24v36H36V28Z"}),(0,o.jsx)("path",{fill:"#02BCB7",d:"M4 46c0-9.941 8.059-18 18-18h6v36h-6c-9.941 0-18-8.059-18-18Z"}),(0,o.jsx)("path",{fill:"#0B64DD",d:"M60 12c0 6.627-5.373 12-12 12s-12-5.373-12-12S41.373 0 48 0s12 5.373 12 12Z"}),(0,o.jsx)("path",{fill:"#FEC514",d:"M6 23C6 10.85 15.85 1 28 1v22H6Z"})),l=({size:e="m",...t})=>(0,o.jsx)(a.EuiIcon,(0,n.default)({type:s,size:e},t)),d=r.i18n.translate("xpack.aiAssistant.avatar.aiAssistantLabel",{defaultMessage:"AI Assistant"}),c=({color:e="plain",size:t="m",...i})=>(0,o.jsx)(a.EuiAvatar,(0,n.default)({},i,{color:e,size:t,name:d,iconType:l})),u=({backgroundColor:e,size:t="xxl",ringsColor:i})=>{const{root:n,rings:r}=(({backgroundColor:e="body",size:t="xxl",ringsColor:i})=>{const{euiTheme:{colors:n}}=(0,a.useEuiTheme)(),{maskPoint:r,ringSize:s,rootSize:l}=((e="xxl")=>{const{euiTheme:{size:t}}=(0,a.useEuiTheme)(),i=parseInt(t[e],10),n=i+Math.max(i/2,parseInt(t.m,10));return{rootSize:2*n,ringSize:n,maskPoint:n+1}})(t),d=n[e];return{root:(0,o.css)("background-color:",d,";display:flex;justify-content:center;align-items:center;position:relative;width:",l,"px;height:",l,"px;&:after{content:'';position:absolute;height:",r,"px;width:",r,"px;z-index:2;border:2px solid ",d,";border-radius:50%;}",""),rings:(0,o.css)("display:inline-block;position:absolute;height:",s,"px;width:",s,"px;@keyframes outer{0%{opacity:1;transform:scaleY(1) scaleX(1);}20%{opacity:0.5;}70%{opacity:0.2;transform:scaleY(2) scaleX(2);}80%{opacity:0;transform:scaleY(2) scaleX(2);}90%{opacity:0;transform:scaleY(1) scaleX(1);}}@keyframes inner{0%{opacity:1;transform:scaleY(1) scaleX(1);}15%{opacity:1;transform:scaleY(1) scaleX(1);}40%{opacity:0.5;}70%{opacity:0.2;transform:scaleY(1.5) scaleX(1.5);}80%{opacity:0;transform:scaleY(1.5) scaleX(1.5);}90%{opacity:0;transform:scaleY(1) scaleX(1);}}&:before,&:after{content:'';position:absolute;width:",s,"px;height:",s,"px;top:0;left:0;z-index:0;border:1px solid ",null!=i?i:n.primary,";border-radius:50%;animation:4s cubic-bezier(0.42, 0, 0.37, 1) 0.5s infinite normal none running;}&:before{animation-name:inner;}&:after{animation-name:outer;}","")}})({backgroundColor:e,size:t,ringsColor:i});return(0,o.jsx)("div",{css:n},(0,o.jsx)(l,{size:t}),(0,o.jsx)("span",{css:r}))}},62953:(e,t,i)=>{"use strict";i.d(t,{AT:()=>c,Bz:()=>Q,CR:()=>I,Fc:()=>r,GY:()=>k,Jk:()=>H,NP:()=>m,Of:()=>j,Oo:()=>y,QB:()=>q,Qm:()=>L,Sd:()=>O,Tn:()=>o,Vm:()=>R,XC:()=>A,Xj:()=>D,YK:()=>d,Z6:()=>F,ZJ:()=>T,ZV:()=>p,Zo:()=>B,dk:()=>s,ep:()=>w,fT:()=>G,h_:()=>P,ie:()=>v,j6:()=>S,mb:()=>x,mk:()=>N,mo:()=>f,ns:()=>h,pi:()=>z,sK:()=>$,vd:()=>U,w4:()=>g,wH:()=>W,wZ:()=>b,wz:()=>C,z8:()=>V,zj:()=>M});const n="/api/security_ai_assistant",a="/internal/elastic_assistant",r=`${n}/current_user/conversations`,o=`${`${a}/current_user/conversations`}/_bulk_action`,s=`${r}/_find`,l=`${n}/prompts`,d=`${l}/_bulk_action`,c=`${l}/_find`,u=`${n}/anonymization_fields`,m=`${u}/_bulk_action`,p=`${u}/_find`,h=`${n}/knowledge_base/{resource?}`,f=`${n}/knowledge_base/entries`,g=`${f}/_find`,y=`${f}/_bulk_action`,v=`${a}/evaluate`,_=`${a}/alert_summary`,b=`${_}/_bulk_action`,x=`${_}/_find`,w=`${n}/security_ai_prompts/_find`,k=`${a}/users/_suggest`,S=`${a}/defend_insights`,T="attack-discovery",E="/api/attack_discovery",z=`${E}/_bulk`,j=`${E}/_find`,I=`${E}/_generate`,C=`${E}/generations`,A=`${C}/{execution_uuid}/_dismiss`,F=`${E}/schedules`,M=`${F}/{id}`,D=`${F}/{id}/_enable`,L=`${F}/{id}/_disable`,P=`${F}/_find`,N=`${a}/attack_discovery`,R=`${N}/_bulk`,O=`${N}/_find`,q=`${N}/generations`,V=`${q}/{execution_uuid}/_dismiss`,U=`${N}/schedules`,B=`${U}/{id}`,H=`${U}/{id}/_enable`,$=`${U}/{id}/_disable`,G=`${U}/_find`,W="attack_discovery_ad_hoc_rule_id",Q="securitySolution.attackDiscoveryPublicApiEnabled"},92810:(e,t,i)=>{"use strict";i.d(t,{r:()=>a});var n=i(77765);const a=({anonymizationFields:e=[],currentReplacements:t,field:i,getAnonymizedValue:a,rawData:r})=>{var o;return(null!==(o=r[i])&&void 0!==o?o:[]).reduce(((r,o)=>{const s=`${o}`;if((0,n.Jr)({anonymizationFields:e,field:i})&&(0,n.jG)({anonymizationFields:e,field:i})){const e=`${a({currentReplacements:t,rawValue:s})}`;return{anonymizedValues:[...r.anonymizedValues,e],replacements:{...r.replacements,[e]:s}}}return(0,n.Jr)({anonymizationFields:e,field:i})?{anonymizedValues:[...r.anonymizedValues,s],replacements:{...r.replacements}}:r}),{anonymizedValues:[],replacements:{}})}},77765:(e,t,i)=>{"use strict";i.d(t,{GZ:()=>a,Jr:()=>n,jG:()=>r,ud:()=>o});const n=({anonymizationFields:e,field:t})=>{var i,n;return null!==(i=null===(n=e.find((e=>e.field===t)))||void 0===n?void 0:n.allowed)&&void 0!==i&&i},a=({anonymizationFields:e,field:t})=>{var i,n;return!(null!==(i=null===(n=e.find((e=>e.field===t)))||void 0===n?void 0:n.allowed)&&void 0!==i&&i)},r=({anonymizationFields:e,field:t})=>{var i,n;return null!==(i=null===(n=e.find((e=>e.field===t)))||void 0===n?void 0:n.anonymized)&&void 0!==i&&i},o=({messageContent:e,replacements:t})=>null!=t?Object.keys(t).reduce(((e,i)=>{const n=t[i];return e.replaceAll(i,n)}),e):e},85028:(e,t,i)=>{"use strict";i.d(t,{BoD:()=>n});const n={public:{v1:"2023-10-31"},internal:{v1:"1"}}},81621:(e,t,i)=>{"use strict";i.d(t,{SJ:()=>r,U2:()=>a,WM:()=>n,ji:()=>o});let n=function(e){return e.SHARED="shared",e.RESTRICTED="restricted",e.PRIVATE="private",e}({});const a=e=>{var t;if(!e||""===(null==e?void 0:e.id))return n.PRIVATE;switch(null!==(t=null==e?void 0:e.users.length)&&void 0!==t?t:1){case 0:return n.SHARED;case 1:return n.PRIVATE;default:return n.RESTRICTED}},r=e=>{var t;return null!==(t=null==e?void 0:e.createdBy)&&void 0!==t?t:1===(null==e?void 0:e.users.length)?null==e?void 0:e.users[0]:{}},o=(e,t)=>{if(void 0===t||0===Object.keys(t).length||void 0===e||""===(null==e?void 0:e.id))return!0;const i=r(e),n=!(null==i||!i.id||null==t||!t.id||(null==i?void 0:i.id)!==(null==t?void 0:t.id)),a=!(null==i||!i.name||null==t||!t.name||(null==i?void 0:i.name)!==(null==t?void 0:t.name));return n||a}},92125:(e,t,i)=>{"use strict";i.d(t,{ts:()=>d});var n=i(13530),a=i(84286),r=i(62953),o=i(85028),s=i(45278);const l={page:0,perPage:1e3,sortField:"field",sortOrder:"asc"},d=e=>{const{all:t,page:i=l.page,perPage:d=l.perPage,sortField:c=l.sortField,sortOrder:u=l.sortOrder,signal:m,filter:p}=e||{},{http:h,assistantAvailability:{isAssistantEnabled:f}}=(0,s.BF)(),g=(0,a.useCallback)((async({pageParam:e={page:i,perPage:d,sortField:c,sortOrder:u,filter:p,all:t}})=>{const{page:n=i,perPage:a=d,sortField:s=c,sortOrder:l=u,filter:f="",all:g}=e,y=(e=>e&&0!==e.length?e.split(" ").map((e=>"is:allowed"===e?"allowed: true":"is:anonymized"===e?"anonymized: true":`field: ${e}*`)).join(" AND "):null)(f);return h.fetch(r.ZV,{method:"GET",version:o.BoD.public.v1,query:{page:n+1,per_page:a,sort_field:s,sort_order:l,...y?{filter:y}:{},all_data:g},signal:m})}),[i,d,c,u,p,t,h,m]),y=(0,a.useCallback)((e=>{const t=Math.ceil(e.total/e.perPage);if(e.page<t)return{page:e.page+1,sortField:c,sortOrder:u}}),[c,u]),v=[c,u,d,o.BoD.public.v1,r.ZV,i,p,t],{refetch:_,data:b,isFetched:x,isFetching:w,isError:k,isLoading:S}=(0,n.useInfiniteQuery)(v,g,{getNextPageParam:y,enabled:f,refetchOnWindowFocus:!0});return{refetch:_,data:(0,a.useMemo)((()=>{var e;return null!==(e=null==b?void 0:b.pages.at(-1))&&void 0!==e?e:{page:i,perPage:d,total:0,data:[],aggregations:{},...t?{all:[]}:{}}}),[b,i,d,t]),isFetched:x,isFetching:w,isError:k,isLoading:S}}},86647:(e,t,i)=>{"use strict";i.d(t,{w:()=>d});var n=i(13530),a=i(62953),r=i(85028),o=i(81621),s=i(84286);const l=["id","title","apiConfig","updatedAt"],d=({currentUser:e,http:t,fields:i=l,filter:d,page:c=1,perPage:u=28,signal:m,sortField:p="updated_at",sortOrder:h="desc",refetchOnWindowFocus:f=!0,isAssistantEnabled:g,isConversationOwner:y=!1,setTotalItemCount:v})=>{const _=(0,s.useCallback)((async({pageParam:e})=>{var n,o;return t.fetch(a.dk,{method:"GET",version:r.BoD.public.v1,query:{fields:i,filter:d,page:null!==(n=null==e?void 0:e.page)&&void 0!==n?n:c,per_page:null!==(o=null==e?void 0:e.perPage)&&void 0!==o?o:u,sort_field:p,sort_order:h,is_owner:y},signal:m})}),[i,d,t,y,c,u,m,p,h]),b=(0,s.useCallback)((e=>{if(Math.max(1,Math.ceil(e.total/e.perPage))!==e.page)return{...e,page:e.page+1}}),[]),{data:x,fetchNextPage:w,hasNextPage:k,isFetched:S,isFetching:T,isLoading:E,refetch:z}=(0,n.useInfiniteQuery)([a.dk,c,u,r.BoD.public.v1,d,p,h],_,{enabled:g,getNextPageParam:b,refetchOnWindowFocus:f,select:t=>({...t,pages:t.pages.map((t=>({...t,data:t.data.map((t=>({...t,isConversationOwner:!!y||(0,o.ji)(t,e)})))})))})});(0,s.useEffect)((()=>{var e,t;v&&null!=x&&null!==(e=x.pages)&&void 0!==e&&e.length&&v(null!==(t=null==x?void 0:x.pages[0].total)&&void 0!==t?t:0)}),[null==x?void 0:x.pages,v]);const j=(0,s.useMemo)((()=>(e=>null==e?void 0:e.pages.reduce(((e,t)=>({...e,...t.data.reduce(((e,t)=>({...e,[t.id]:t})),{})})),{}))(x)),[x]),I=(0,s.useRef)(),C=(0,s.useCallback)((async([{isIntersecting:e}])=>{var t;e&&k&&!E&&!T&&(await w(),null===(t=I.current)||void 0===t||t.disconnect())}),[w,k,T,E]);(0,s.useEffect)((()=>()=>{var e;return null===(e=I.current)||void 0===e?void 0:e.disconnect()}),[]);const A=(0,s.useCallback)((e=>{var t,i;null===(t=I.current)||void 0===t||t.disconnect(),I.current=new IntersectionObserver(C,{root:null,rootMargin:"0px",threshold:.1}),null===(i=I.current)||void 0===i||i.observe(e)}),[C]);return{data:null!=j?j:{},isLoading:E,refetch:z,isFetched:S,isFetching:T,setPaginationObserver:A}}},44883:(e,t,i)=>{"use strict";i.d(t,{i:()=>s});var n=i(84286),a=i(45278),r=i(9472),o=i(86647);const s=(e,t,i,s,l,d,c,u,m)=>{const{http:p}=(0,a.BF)(),{refetch:h}=(0,o.w)({http:p,filter:`title:"${t}"`,isAssistantEnabled:!1}),f=(0,n.useMemo)((()=>e),[e]),g=(0,n.useMemo)((()=>i),[i]),y=(0,n.useMemo)((()=>s),[s]),v=(0,n.useMemo)((()=>null!=l?l:(0,r.v4)()),[l]),_=(0,n.useMemo)((()=>null!=d?d:void 0),[d]),b=(0,n.useMemo)((()=>c),[c]),x=(0,n.useMemo)((()=>m),[m]),{registerPromptContext:w,showAssistantOverlay:k,unRegisterPromptContext:S}=(0,a.BF)(),T=(0,n.useCallback)((async e=>{if(null!=v&&u&&null!=t){var i,n;const a=await h(),r=a&&t?Object.values(null!==(i=null==a||null===(n=a.data)||void 0===n?void 0:n.pages[0].data)&&void 0!==i?i:[]).find((e=>e.title===t)):void 0;k({showOverlay:e,promptContextId:v,selectedConversation:null!=r&&r.id?{id:r.id}:{title:null!=t?t:""}})}}),[k,t,u,v,h]);return(0,n.useEffect)((()=>(S(v),w({category:f,description:g,getPromptContext:y,id:v,suggestedUserPrompt:_,tooltip:b,replacements:null!=x?x:void 0}),()=>S(v))),[f,g,y,x,_,b,v,w,S]),{promptContextId:v,showAssistantOverlay:T}}},45278:(e,t,i)=>{"use strict";i.d(t,{BF:()=>s,a7:()=>l}),i(81060);var n=i(84286),a=i.n(n),r=(i(57064),i(84897),i(13530),i(96791));const o=a().createContext(void 0),s=()=>{const e=a().useContext(o);if(null==e)throw new Error("useAssistantContext must be used within a AssistantProvider");return e},l=({children:e,value:t})=>(0,r.jsx)(o.Provider,{value:t},e)},89693:(e,t,i)=>{"use strict";i.d(t,{Q5:()=>n,Qf:()=>a});const n="open",a="closed"},99613:(e,t,i)=>{"use strict";i.d(t,{S:()=>f});var n=i(84286),a=i.n(n),r=i(81319),o=i(26752),s=i.n(o),l=i(96791),d={name:"gdzl2d",styles:"border-left:none;border-bottom-left-radius:0;border-top-left-radius:0"},c={name:"1urpyts",styles:"border-bottom-right-radius:0;border-top-right-radius:0"},u={name:"qq6qmk",styles:"&:hover{height:7px;border-radius:3px;transition:all 0.3s ease;.euiBadge{cursor:unset;}&::after{opacity:1;transition:all 0.3s ease;top:-9px;}}"},m={name:"l9ua6r",styles:"position:relative;border-radius:2px;height:5px;min-width:10px"};const p=()=>{const{euiTheme:e}=(0,r.useEuiTheme)();return{bar:(0,l.css)("gap:",e.size.xxs,";min-height:7px;",""),part:{base:m,empty:(0,l.css)("background-color:",e.colors.lightShade,";flex:1;",""),tick:(0,l.css)("&::after{content:'';opacity:0;position:absolute;top:-10px;right:0;width:1px;height:6px;background-color:",e.colors.lightShade,";}",""),hover:u,visibleTooltip:(0,l.css)("&>div{opacity:1;top:calc(-",e.base+2,"px - 13px);}&::after{opacity:1;}","")},tooltip:(0,l.css)("opacity:0;position:absolute;width:100%;height:calc(\n        ",e.base+2,"px + 14px + 7px\n      );text-align:right;top:calc(\n        -",e.base+2,"px - 14px\n      );right:0;&:hover{opacity:1;top:calc(\n          -",e.base+2,"px - 13px\n        );transition:all 0.3s ease;}",""),tooltipBadgeLeft:c,tooltipBadgeRight:d}},h=({"data-test-subj":e})=>{const t=p(),i=[t.part.base,t.part.empty];return(0,l.jsx)("div",{css:i,"data-test-subj":`${e}`})},f=a().memo((function(e){const t=p(),{stats:i,"data-test-subj":a,hideLastTooltip:o}=e,[d,c]=(0,n.useState)(null),u=(0,n.useMemo)((()=>i.some((e=>e.isCurrentFilter))),[i]),m=i.map(((e,n)=>{var m,p;const h=n===i.length-1,f=(({isHovered:e,isCurrentFilter:t,isLast:i,hasFilterActive:n,hideLastTooltip:a,isHoveringAnyStatsBar:r})=>!!e||!r&&(t||i&&!a&&!n))({isHovered:d===e.key,isCurrentFilter:null!==(m=e.isCurrentFilter)&&void 0!==m&&m,isLast:h,hasFilterActive:u,hideLastTooltip:o,isHoveringAnyStatsBar:Boolean(d)}),g=[t.part.base,t.part.tick,t.part.hover,(0,l.css)("background-color:",e.color,";flex:",e.count,";","")];f&&g.push(t.part.visibleTooltip);const y=s()(e.count).format("0,0a");return(0,l.jsx)("div",{key:e.key,css:g,"data-test-subj":`${a}__part`,onClick:e.filter,onMouseEnter:()=>c(e.key),onMouseLeave:()=>c(null),onKeyDown:t=>{var i;"Enter"!==t.key&&" "!==t.key||null===(i=e.filter)||void 0===i||i.call(e)},tabIndex:0,role:"button"},(0,l.jsx)("div",{css:[t.tooltip,f&&t.part.visibleTooltip,"",""]},(0,l.jsx)(r.EuiFlexGroup,{gutterSize:"none",justifyContent:"flexEnd",wrap:!1,responsive:!1},(0,l.jsx)(r.EuiFlexItem,{grow:!1},(0,l.jsx)(r.EuiBadge,{color:"hollow",css:t.tooltipBadgeLeft},y)),(0,l.jsx)(r.EuiFlexItem,{grow:!1},(0,l.jsx)(r.EuiBadge,{color:"hollow",css:t.tooltipBadgeRight},(0,l.jsx)(r.EuiFlexGroup,{gutterSize:"xs",alignItems:"center",responsive:!1},(0,l.jsx)(r.EuiFlexItem,{grow:!1},(0,l.jsx)(r.EuiIcon,{type:"dot",size:"s",color:e.color})),(0,l.jsx)(r.EuiFlexItem,{grow:!1},null!==(p=e.label)&&void 0!==p?p:e.key),e.isCurrentFilter&&e.reset&&(0,l.jsx)(r.EuiFlexItem,{grow:!1},(0,l.jsx)(r.EuiIcon,{type:"cross",size:"m",onClick:e.reset}))))))))}));return(0,l.jsx)(r.EuiFlexGroup,{alignItems:"center",css:t.bar,"data-test-subj":a,responsive:!1},m.length?m:(0,l.jsx)(h,{"data-test-subj":`${a}__emptyBar`}))}))},44912:(e,t,i)=>{"use strict";i.d(t,{N7:()=>s,XX:()=>n,bn:()=>o,eG:()=>l,mY:()=>r,ng:()=>a});const n="memory",a="expandableFlyout.ui",r="pushVsOverlay",o="collapsedWidth",s="expandedWidth",l="sectionWidths"},48354:(e,t,i)=>{"use strict";i.d(t,{Qx:()=>o,gg:()=>s});var n=i(84286),a=i(96791);const r=(0,n.createContext)(void 0),o=(0,n.memo)((({urlKey:e,children:t})=>{const i=(0,n.useMemo)((()=>({urlKey:e})),[e]);return(0,a.jsx)(r.Provider,{value:i},t)}));o.displayName="ExpandableFlyoutContextProvider";const s=()=>{const e=(0,n.useContext)(r);if(void 0===e)throw new Error("ExpandableFlyoutContext can only be used within ExpandableFlyoutContext provider");return e}},63103:(e,t,i)=>{"use strict";i.d(t,{x:()=>d});var n=i(84286),a=i(1493),r=i(44912),o=i(48354),s=i(20108),l=i(79987);const d=()=>{const e=(0,l.wA)(),t=(0,a.useHistory)(),{urlKey:i}=(0,o.gg)(),d=i||r.XX,c=(0,n.useCallback)((({right:t,left:i,preview:n})=>e((0,s._m)({right:t,left:i,preview:n,id:d}))),[e,d]),u=(0,n.useCallback)((t=>e((0,s.ji)({right:t,id:d}))),[e,d]),m=(0,n.useCallback)((t=>e((0,s.sD)({left:t,id:d}))),[e,d]),p=(0,n.useCallback)((t=>e((0,s.F6)({preview:t,id:d}))),[e,d]),h=(0,n.useCallback)((()=>e((0,s.bf)({id:d}))),[e,d]),f=(0,n.useCallback)((()=>e((0,s.Iw)({id:d}))),[e,d]),g=(0,n.useCallback)((()=>e((0,s.h5)({id:d}))),[e,d]),y=(0,n.useCallback)((()=>{d===r.XX?e((0,s.iW)({id:d})):t.goBack()}),[e,d,t]),v=(0,n.useCallback)((()=>e((0,s.E8)({id:d}))),[e,d]);return(0,n.useMemo)((()=>({openFlyout:c,openRightPanel:u,openLeftPanel:m,openPreviewPanel:p,closeRightPanel:h,closeLeftPanel:f,closePreviewPanel:g,closeFlyout:v,previousPreviewPanel:y})),[c,u,m,p,h,f,g,v,y])}},96734:(e,t,i)=>{"use strict";i.d(t,{K:()=>s});var n=i(84286),a=i(44912),r=i(48354),o=i(79987);const s=()=>{const{urlKey:e}=(0,r.gg)(),t=(0,n.useMemo)((()=>e||a.XX),[e]);return(0,o.d4)((0,o.IS)(t))}},20108:(e,t,i)=>{"use strict";i.d(t,{$k:()=>g,AF:()=>f,E8:()=>d,F6:()=>l,Iw:()=>u,JP:()=>v,TS:()=>y,Ux:()=>h,_m:()=>r,bf:()=>c,eT:()=>_,fA:()=>b,h5:()=>m,iW:()=>p,ji:()=>o,sD:()=>s});var n=i(57150);let a=function(e){return e.openFlyout="open_flyout",e.openRightPanel="open_right_panel",e.openLeftPanel="open_left_panel",e.openPreviewPanel="open_preview_panel",e.closeRightPanel="close_right_panel",e.closeLeftPanel="close_left_panel",e.closePreviewPanel="close_preview_panel",e.previousPreviewPanel="previous_preview_panel",e.closeFlyout="close_flyout",e.urlChanged="urlChanged",e.changePushVsOverlay="change_push_overlay",e.setDefaultWidths="set_default_widths",e.changeUserCollapsedWidth="change_user_collapsed_width",e.changeUserExpandedWidth="change_user_expanded_width",e.changeUserSectionWidths="change_user_section_widths",e.resetAllUserWidths="reset_all_user_widths",e}({});const r=(0,n.createAction)(a.openFlyout),o=(0,n.createAction)(a.openRightPanel),s=(0,n.createAction)(a.openLeftPanel),l=(0,n.createAction)(a.openPreviewPanel),d=(0,n.createAction)(a.closeFlyout),c=(0,n.createAction)(a.closeRightPanel),u=(0,n.createAction)(a.closeLeftPanel),m=(0,n.createAction)(a.closePreviewPanel),p=(0,n.createAction)(a.previousPreviewPanel),h=(0,n.createAction)(a.urlChanged),f=(0,n.createAction)(a.changePushVsOverlay),g=(0,n.createAction)(a.setDefaultWidths),y=(0,n.createAction)(a.changeUserCollapsedWidth),v=(0,n.createAction)(a.changeUserExpandedWidth),_=(0,n.createAction)(a.changeUserSectionWidths),b=(0,n.createAction)(a.resetAllUserWidths)},79987:(e,t,i)=>{"use strict";i.d(t,{ob:()=>y,TI:()=>z,t3:()=>S,TD:()=>k,IS:()=>w,Gd:()=>E,_u:()=>j,g5:()=>I,M_:()=>g,wA:()=>v,d4:()=>_});var n=i(84286),a=i(47012),r=i(57150),o=i(53338),s=i(14899),l=i.n(s),d=i(20108);const c={byId:{},needsSync:!1},u={pushVsOverlay:"overlay",defaultWidths:{overlay:{},push:{}},userFlyoutWidths:{},userSectionWidths:{}},m={panels:c,ui:u},p=(0,r.createReducer)(c,(e=>{e.addCase(d._m,((e,{payload:{preview:t,left:i,right:n,id:a}})=>{var r;a in e.byId?(e.byId[a].right=n,e.byId[a].left=i,e.byId[a].preview=t?[t]:void 0,n&&(null===(r=e.byId[a].history)||void 0===r||r.push({lastOpen:Date.now(),panel:n}))):e.byId[a]={left:i,right:n,preview:t?[t]:void 0,history:n?[{lastOpen:Date.now(),panel:n}]:[]},e.needsSync=!0})),e.addCase(d.sD,((e,{payload:{left:t,id:i}})=>{i in e.byId?e.byId[i].left=t:e.byId[i]={left:t,right:void 0,preview:void 0,history:[]},e.needsSync=!0})),e.addCase(d.ji,((e,{payload:{right:t,id:i}})=>{i in e.byId?e.byId[i].right=t:e.byId[i]={right:t,left:void 0,preview:void 0,history:[]},e.needsSync=!0})),e.addCase(d.F6,((e,{payload:{preview:t,id:i}})=>{if(i in e.byId)if(e.byId[i].preview){var n,a;l()(t,null===(n=e.byId[i].preview)||void 0===n?void 0:n.at(-1))||null===(a=e.byId[i].preview)||void 0===a||a.push(t)}else e.byId[i].preview=t?[t]:void 0;else e.byId[i]={right:void 0,left:void 0,preview:t?[t]:void 0,history:[]};e.needsSync=!0})),e.addCase(d.iW,((e,{payload:{id:t}})=>{var i;t in e.byId&&(null===(i=e.byId[t].preview)||void 0===i||i.pop()),e.needsSync=!1})),e.addCase(d.E8,((e,{payload:{id:t}})=>{t in e.byId&&(e.byId[t].right=void 0,e.byId[t].left=void 0,e.byId[t].preview=void 0),e.needsSync=!0})),e.addCase(d.Iw,((e,{payload:{id:t}})=>{t in e.byId&&(e.byId[t].left=void 0),e.needsSync=!0})),e.addCase(d.bf,((e,{payload:{id:t}})=>{t in e.byId&&(e.byId[t].right=void 0),e.needsSync=!0})),e.addCase(d.h5,((e,{payload:{id:t}})=>{t in e.byId&&(e.byId[t].preview=void 0),e.needsSync=!0})),e.addCase(d.Ux,((e,{payload:{preview:t,left:i,right:n,id:a}})=>{a in e.byId?(e.byId[a].right=n,e.byId[a].left=i,e.byId[a].preview=t?[t]:void 0):e.byId[a]={right:n,left:i,preview:t?[t]:void 0,history:n?[{lastOpen:Date.now(),panel:n}]:[]},e.needsSync=!1}))})),h=(0,r.createReducer)(u,(e=>{e.addCase(d.AF,((e,{payload:{type:t}})=>{e.pushVsOverlay=t})),e.addCase(d.$k,((e,{payload:{rightOverlay:t,leftOverlay:i,previewOverlay:n,rightPush:a,leftPush:r,previewPush:o}})=>{e.defaultWidths.overlay.rightWidth=t,e.defaultWidths.overlay.leftWidth=i,e.defaultWidths.overlay.previewWidth=n,e.defaultWidths.overlay.rightPercentage=t/(t+i)*100,e.defaultWidths.overlay.leftPercentage=i/(t+i)*100,e.defaultWidths.overlay.previewPercentage=n/(n+i)*100,e.defaultWidths.push.rightWidth=a,e.defaultWidths.push.leftWidth=r,e.defaultWidths.push.previewWidth=o,e.defaultWidths.push.rightPercentage=a/(a+r)*100,e.defaultWidths.push.leftPercentage=r/(a+r)*100,e.defaultWidths.push.previewPercentage=o/(o+r)*100})),e.addCase(d.TS,((e,{payload:{width:t}})=>{e.userFlyoutWidths.collapsedWidth=t})),e.addCase(d.JP,((e,{payload:{width:t}})=>{e.userFlyoutWidths.expandedWidth=t})),e.addCase(d.eT,((e,{payload:{right:t,left:i}})=>{e.userSectionWidths.leftPercentage=i,e.userSectionWidths.rightPercentage=t})),e.addCase(d.fA,(e=>{e.userFlyoutWidths.collapsedWidth=void 0,e.userFlyoutWidths.expandedWidth=void 0,e.userSectionWidths.leftPercentage=void 0,e.userSectionWidths.rightPercentage=void 0}))}));var f=i(44912);const g=(0,r.configureStore)({reducer:{panels:p,ui:h},devTools:!1,middleware:[()=>e=>t=>{if(!t.type)return e(t);if(d.AF.match(t)&&t.payload.savedToLocalStorage){const e=localStorage.getItem(f.ng),i=e?JSON.parse(e):{};i[f.mY]=t.payload.type,localStorage.setItem(f.ng,JSON.stringify(i))}return e(t)},()=>e=>t=>{if(!t.type)return e(t);if(d.eT.match(t)&&t.payload.savedToLocalStorage){const e=localStorage.getItem(f.ng),i=e?JSON.parse(e):{};i[f.eG]={left:t.payload.left,right:t.payload.right},localStorage.setItem(f.ng,JSON.stringify(i))}return e(t)},()=>e=>t=>{if(!t.type)return e(t);const i=localStorage.getItem(f.ng),n=i?JSON.parse(i):{};return d.TS.match(t)&&t.payload.savedToLocalStorage&&(n[f.bn]=t.payload.width,localStorage.setItem(f.ng,JSON.stringify(n))),d.JP.match(t)&&t.payload.savedToLocalStorage&&(n[f.N7]=t.payload.width,localStorage.setItem(f.ng,JSON.stringify(n))),e(t)},()=>e=>t=>{if(!t.type)return e(t);if(d.fA.match(t)){const e=localStorage.getItem(f.ng),t=e?JSON.parse(e):{};delete t[f.bn],delete t[f.N7],delete t[f.eG],localStorage.setItem(f.ng,JSON.stringify(t))}return e(t)}]}),y=(0,n.createContext)({store:g,storeState:m}),v=(0,a.createDispatchHook)(y),_=(0,a.createSelectorHook)(y),b=e=>e,x=(0,o.createSelector)(b,(e=>e.panels)),w=e=>(0,o.createSelector)(x,(t=>t.byId[e]||{})),k=()=>(0,o.createSelector)(x,(e=>e.needsSync)),S=e=>(0,o.createSelector)(b,(t=>t.panels.byId[e].history||[])),T=(0,o.createSelector)(b,(e=>e.ui)),E=(0,o.createSelector)(T,(e=>e.pushVsOverlay)),z=(0,o.createSelector)(T,(e=>e.defaultWidths)),j=(0,o.createSelector)(T,(e=>e.userFlyoutWidths)),I=(0,o.createSelector)(T,(e=>e.userSectionWidths))},47907:(e,t,i)=>{"use strict";i.d(t,{h:()=>r});var n=i(26752),a=i.n(n);const r=e=>isNaN(e)?0:e<1e3?e:a()(e).format("0.0a")},32274:(e,t,i)=>{"use strict";i.d(t,{FY:()=>d,Nr:()=>r,PE:()=>a,cX:()=>s,ie:()=>o,rU:()=>l});const n=i(75008).i18n.translate("securitySolutionPackages.csp.common.utils.helpers.unknownError",{defaultMessage:"Unknown Error"}),a=(e,t)=>e instanceof Error?e.message:"string"==typeof e?e:null!=t?t:n,r=e=>{const t=Object.fromEntries(Object.entries(e).filter((([e,t])=>!0===t.muted)));return Object.keys(t).map((e=>{const i=t[e];return{bool:{must:[{term:{"rule.benchmark.id":i.benchmark_id}},{term:{"rule.benchmark.version":i.benchmark_version}},{term:{"rule.benchmark.rule_number":i.rule_number}}]}}}))},o=(e,t,i,n)=>({bool:{filter:[{bool:{should:[{term:{[e]:`${t||""}`}}],minimum_should_match:1}},i&&n?{bool:{should:[{term:{[n]:{value:i,case_insensitive:!0}}}],minimum_should_match:1}}:void 0].filter(Boolean)}}),s=(e,t,i)=>o(e,t,i,"result.evaluation"),l=(e,t,i)=>o(e,t,i,"vulnerability.severity"),d=({field:e,to:t,from:i,queryValue:n="",size:a=0,severity:r,sortField:o,sortDirection:s})=>({size:a||0,_source:!1,sort:o?[{[o]:s}]:[],fields:["_id","_index","kibana.alert.rule.uuid","kibana.alert.severity","kibana.alert.rule.name","kibana.alert.workflow_status"],query:{bool:{filter:[{bool:{should:[{term:{[e]:`${n||""}`}}],minimum_should_match:1}},r?{bool:{should:[{term:{"kibana.alert.severity":r}}],minimum_should_match:1}}:void 0,{range:{"@timestamp":{gte:i,lte:t}}},{terms:{"kibana.alert.workflow_status":["open","acknowledged"]}}].filter(Boolean)}},runtime_mappings:{"related.entity":{type:"keyword"}}})},65636:(e,t,i)=>{"use strict";i.d(t,{_:()=>l}),i(84286);var n=i(81319),a=i(75879),r=i(96791),o=i(83348),s=i(69074);const l=({type:e=o.ff.UNKNOWN})=>{const{getMisconfigurationStatusColor:t}=(0,s.O)();return(0,r.jsx)(n.EuiBadge,{color:t(e),css:(0,r.css)("width:","46px",";display:flex;justify-content:center;",""),"data-test-subj":`${e}_finding`},e===o.ff.FAILED?(0,r.jsx)(a.FormattedMessage,{id:"securitySolutionPackages.csp.cspEvaluationBadge.failLabel",defaultMessage:"Fail"}):e===o.ff.PASSED?(0,r.jsx)(a.FormattedMessage,{id:"securitySolutionPackages.csp.cspEvaluationBadge.passLabel",defaultMessage:"Pass"}):(0,r.jsx)(a.FormattedMessage,{id:"securitySolutionPackages.csp.cspEvaluationBadge.naLabel",defaultMessage:"N/A"}))}},98628:(e,t,i)=>{"use strict";i.d(t,{a:()=>c,$:()=>m});var n=i(81319),a=i(84286),r=i.n(a),o=i(96791),s=i(76659),l=i(62402),d={name:"1xszn7y",styles:"border:none;.euiBadge__text{display:flex;}width:62px"};const c=({score:e,version:t})=>{const{euiTheme:i}=(0,n.useEuiTheme)(),{getCvsScoreColor:a}=(()=>{const{euiTheme:e}=(0,n.useEuiTheme)();return{getCvsScoreColor:t=>(0,s.Qw)(t,e)}})();if(!e)return null;const l=a(e),c=t?`v${t.split(".")[0]}`:null;return(0,o.jsx)(n.EuiBadge,{color:l,css:d,"data-test-subj":"vulnerabilities_cvss_score_badge"},(0,o.jsx)(r().Fragment,null,(0,o.jsx)(n.EuiTextColor,{color:"ghost"},e<10?e.toFixed(1):e),(0,o.jsx)(r().Fragment,null,(0,o.jsx)("hr",{css:(0,o.css)("width:1px;border:0 none;background-color:",i.border.color,";margin:0px 6px;","")}),(0,o.jsx)(n.EuiTextColor,{color:"ghost"},c||"-"))))};var u={name:"fhxb3m",styles:"display:flex;flex-direction:row;align-items:center"};const m=({severity:e})=>{const{getSeverityStatusColor:t}=(0,l.S)();if(!e)return null;const i=t(e);return(0,o.jsx)("div",{"data-test-subj":"vulnerabilities_severity_badge",css:u},(0,o.jsx)(n.EuiIcon,{type:"dot",color:i,css:(0,o.css)("opacity:",e?1:0,";","")}),e)}},64194:(e,t,i)=>{"use strict";i.d(t,{U:()=>s});var n=i(13530),a=i(83348),r=i(20409);const o=["get_rules_state_key"],s=()=>{const{http:e}=(0,r.useKibana)().services;return(0,n.useQuery)(o,(()=>e.get(a.a,{version:a.s0})))}},69074:(e,t,i)=>{"use strict";i.d(t,{O:()=>r});var n=i(81319),a=i(76659);const r=()=>{const{euiTheme:e}=(0,n.useEuiTheme)();return{getMisconfigurationStatusColor:t=>(0,a.dA)(t,e)}}},62402:(e,t,i)=>{"use strict";i.d(t,{S:()=>r});var n=i(81319),a=i(76659);const r=()=>{const{euiTheme:e}=(0,n.useEuiTheme)();return{getSeverityStatusColor:t=>(0,a.HH)(t,e)}}},2456:(e,t,i)=>{"use strict";i.d(t,{A:()=>r});var n=i(32274),a=i(29983);const r=(e,t)=>{const{data:i}=(0,a.p)({query:(0,n.ie)(e,t),sort:[],enabled:!0,pageSize:1}),r=(null==i?void 0:i.count.passed)||0,o=(null==i?void 0:i.count.failed)||0;return{passedFindings:r,failedFindings:o,hasMisconfigurationFindings:r>0||o>0}}},49998:(e,t,i)=>{"use strict";i.d(t,{Q:()=>o});var n=i(32274),a=i(35538),r=i(16047);const o=(e,t)=>{const{data:i}=(0,a.S)({query:(0,n.ie)(e,t),sort:[],enabled:!0,pageSize:1}),{CRITICAL:o=0,HIGH:s=0,MEDIUM:l=0,LOW:d=0,NONE:c=0}=(null==i?void 0:i.count)||{},u={critical:o,high:s,medium:l,low:d,none:c};return{counts:u,hasVulnerabilitiesFindings:(0,r.$)(u)}}},29983:(e,t,i)=>{"use strict";i.d(t,{p:()=>d});var n=i(13530),a=i(80190),r=i(20409),o=i(25172),s=i(64194),l=i(26664);const d=e=>{const{data:t,notifications:{toasts:i}}=(0,r.useKibana)().services,{data:d}=(0,s.U)();return(0,n.useQuery)(["csp_misconfiguration_preview",{params:e},d],(async()=>{var i;const{rawResponse:{aggregations:n}}=await(0,a.lastValueFrom)(t.search.search({params:(0,l.VO)(e,d)}));if(!n&&!1===e.ignore_unavailable)throw new Error("expected aggregations to be defined");return{count:(0,l.RO)(null==n||null===(i=n.count)||void 0===i?void 0:i.buckets)}}),{enabled:e.enabled&&!!d,keepPreviousData:!0,onError:e=>(0,o.N)(i,e)})}},35538:(e,t,i)=>{"use strict";i.d(t,{S:()=>l});var n=i(13530),a=i(20409),r=i(80190),o=i(25172),s=i(26664);const l=e=>{const{data:t,notifications:{toasts:i}}=(0,a.useKibana)().services;return(0,n.useQuery)(["csp_vulnerabilities_preview",{params:e}],(async()=>{var i;const{rawResponse:{aggregations:n}}=await(0,r.lastValueFrom)(t.search.search({params:(0,s.fx)(e,!0)}));return{count:(0,s.e3)(null==n||null===(i=n.count)||void 0===i?void 0:i.buckets)}}),{keepPreviousData:!0,enabled:e.enabled,onError:e=>(0,o.N)(i,e)})}},26664:(e,t,i)=>{"use strict";i.d(t,{RO:()=>h,VO:()=>f,e3:()=>y,fx:()=>v});var n=i(32274),a=i(83348);const r=["result.*","rule.*","resource.*"],o="passed",s="failed",l="unknown",d="LOW",c="MEDIUM",u="HIGH",m="CRITICAL",p="NONE",h=e=>{const t=e||{[o]:{doc_count:0},[s]:{doc_count:0},[l]:{doc_count:0}};return Object.entries(t).reduce(((e,[t,i])=>(e[t]=(e[t]||0)+(i.doc_count||0),e)),{[o]:0,[s]:0,[l]:0})},f=({query:e,sort:t},i,d=!1)=>{const c=(0,n.Nr)(i);return{index:a.rp,size:d?0:500,aggs:{count:{filters:{other_bucket_key:l,filters:{[o]:{match:{"result.evaluation":o}},[s]:{match:{"result.evaluation":s}}}}}},ignore_unavailable:!0,query:g(e,c),_source:r,sort:t}},g=(e,t)=>{var i,n;return{...e,bool:{...null==e?void 0:e.bool,filter:[...null!==(i=null==e||null===(n=e.bool)||void 0===n?void 0:n.filter)&&void 0!==i?i:[],{range:{"@timestamp":{gte:`now-${a.nW}`,lte:"now"}}}],must_not:[...t]}}},y=e=>{const t=e||{[d]:{doc_count:0},[c]:{doc_count:0},[u]:{doc_count:0},[m]:{doc_count:0},[p]:{doc_count:0}};return Object.entries(t).reduce(((e,[t,i])=>(e[t]=(e[t]||0)+(i.doc_count||0),e)),{[d]:0,[c]:0,[u]:0,[m]:0,[p]:0})},v=({query:e,sort:t},i=!1)=>({index:a.Du,size:i?0:500,aggs:{count:{filters:{other_bucket_key:p,filters:{[d]:{term:{"vulnerability.severity":{value:d,case_insensitive:!0}}},[c]:{term:{"vulnerability.severity":{value:c,case_insensitive:!0}}},[u]:{term:{"vulnerability.severity":{value:u,case_insensitive:!0}}},[m]:{term:{"vulnerability.severity":{value:m,case_insensitive:!0}}}}}}},ignore_unavailable:!0,query:_(e),sort:t}),_=e=>{var t,i;return{...e,bool:{...null==e?void 0:e.bool,filter:[...null!==(t=null==e||null===(i=e.bool)||void 0===i?void 0:i.filter)&&void 0!==t?t:[],{range:{"@timestamp":{gte:`now-${a.yz}`,lte:"now"}}}]}}}},76659:(e,t,i)=>{"use strict";i.d(t,{HH:()=>a,Qw:()=>r,dA:()=>o});var n=i(83348);const a=(e,t)=>{switch(e){case n.le.LOW:return t.colors.severity.neutral;case n.le.MEDIUM:return t.colors.severity.warning;case n.le.HIGH:return t.colors.severity.risk;case n.le.CRITICAL:return t.colors.severity.danger;default:return t.colors.severity.unknown}},r=(e,t)=>a(e>=0&&e<=4?n.le.LOW:e>=4&&e<=7?n.le.MEDIUM:e>=7&&e<=9?n.le.HIGH:e>=9?n.le.CRITICAL:n.le.UNKNOWN,t),o=(e,t)=>{switch(e){case n.ff.PASSED:return t.colors.severity.success;case n.ff.FAILED:return t.colors.severity.danger;default:return t.colors.severity.unknown}}},2188:(e,t,i)=>{"use strict";i.d(t,{r:()=>a});var n=i(83348);const a=e=>{if(!e)return e;const t=e.toUpperCase();return(e=>e in n.le)(t)?t:e}},54044:(e,t,i)=>{"use strict";i.d(t,{S0:()=>s,XX:()=>d,cj:()=>u,dY:()=>o,iN:()=>m,oJ:()=>p,rQ:()=>c});var n=i(45995),a=i(83348),r=i(43721);const o="cspq",s="flyout",l=e=>{try{return(0,n.encode)(e)}catch(e){return void r.error("Failed to encode rison:",e)}},d=e=>{const t=l(e);if(t)return`${o}=${t}`},c=(e,t)=>{const i=l(t);if(i)return`${e}=${i}`},u=(e,t)=>{const i=new URLSearchParams(e),a={};return t.forEach((e=>{const t=i.get(e);if(t){const i=(e=>{try{return(0,n.decode)(e)}catch(e){return void r.error("Failed to decode rison:",e)}})(t);void 0!==i&&(a[e]=i)}})),a},m=(e,t,i)=>d({query:e.query.queryString.getDefaultQuery(),filters:t,...i&&{groupBy:i}}),p=(e={},t=a.IM)=>Object.entries(e).flatMap((([e,i])=>Array.isArray(i)?i.map((i=>h(e,i,t))):i?h(e,i,t):[])),h=(e,t,i)=>{let n=!1,a=t;return"object"==typeof t&&(n=t.negate,a=t.value),"*"===a?{query:{exists:{field:e}},meta:{type:"exists",index:i}}:{meta:{alias:null,negate:n,disabled:!1,type:"phrase",key:e,index:i},query:{match_phrase:{[e]:a}}}}},25172:(e,t,i)=>{"use strict";i.d(t,{N:()=>o});var n=i(75008),a=i(32274);const r=n.i18n.translate("securitySolutionPackages.csp.findings.findingsErrorToast.searchFailedTitle",{defaultMessage:"Search failed"}),o=(e,t)=>{t instanceof Error?e.addError(t,{title:r}):e.addDanger((0,a.PE)(t,r))}},16047:(e,t,i)=>{"use strict";i.d(t,{I:()=>s,$:()=>o});var n=i(83348),a=i(75008);const r=e=>{switch(e){case n.le.LOW:return"Low";case n.le.MEDIUM:return"Medium";case n.le.HIGH:return"High";case n.le.CRITICAL:return"Critical";default:return"None"}},o=e=>Object.values(e).reduce(((e,t)=>e+t),0)>0,s=(e,t,i,o)=>{const s=[];return Object.values(e).every((e=>0===e))||(e.none>0&&s.push({key:a.i18n.translate("xpack.securitySolution.flyout.right.insights.vulnerabilities.noneVulnerabilitiesText",{defaultMessage:r(n.le.UNKNOWN)}),count:e.none,color:t(n.le.UNKNOWN),filter:()=>{null==i||i(n.le.UNKNOWN)},isCurrentFilter:o===n.le.UNKNOWN,reset:e=>{null==i||i(""),null==e||e.stopPropagation()}}),e.low>0&&s.push({key:a.i18n.translate("xpack.securitySolution.flyout.right.insights.vulnerabilities.lowVulnerabilitiesText",{defaultMessage:r(n.le.LOW)}),count:e.low,color:t(n.le.LOW),filter:()=>{null==i||i(n.le.LOW)},isCurrentFilter:o===n.le.LOW,reset:e=>{null==i||i(""),null==e||e.stopPropagation()}}),e.medium>0&&s.push({key:a.i18n.translate("xpack.securitySolution.flyout.right.insights.vulnerabilities.mediumVulnerabilitiesText",{defaultMessage:r(n.le.MEDIUM)}),count:e.medium,color:t(n.le.MEDIUM),filter:()=>{null==i||i(n.le.MEDIUM)},isCurrentFilter:o===n.le.MEDIUM,reset:e=>{null==i||i(""),null==e||e.stopPropagation()}}),e.high>0&&s.push({key:a.i18n.translate("xpack.securitySolution.flyout.right.insights.vulnerabilities.highVulnerabilitiesText",{defaultMessage:r(n.le.HIGH)}),count:e.high,color:t(n.le.HIGH),filter:()=>{null==i||i(n.le.HIGH)},isCurrentFilter:o===n.le.HIGH,reset:e=>{null==i||i(""),null==e||e.stopPropagation()}}),e.critical>0&&s.push({key:a.i18n.translate("xpack.securitySolution.flyout.right.insights.vulnerabilities.CriticalVulnerabilitiesText",{defaultMessage:r(n.le.CRITICAL)}),count:e.critical,color:t(n.le.CRITICAL),filter:()=>{null==i||i(n.le.CRITICAL)},isCurrentFilter:o===n.le.CRITICAL,reset:e=>{null==i||i(""),null==e||e.stopPropagation()}})),s}},75378:(e,t,i)=>{"use strict";i.d(t,{J:()=>o});var n=i(84286),a=i(38240);function r(e,t){switch(t.type){case"setResult":return{...e,result:t.result,loading:!1};case"setError":return{...e,error:t.error,loading:!1};case"load":return{loading:!0,result:void 0,error:void 0}}}const o=e=>{const t=(0,a.a)(),i=(0,n.useRef)(),[o,s]=(0,n.useReducer)(r,{loading:!1,error:void 0,result:void 0}),l=(0,n.useCallback)(((...n)=>{i.current&&i.current.unsubscribe(),s({type:"load"}),i.current=e(...n).subscribe((e=>{t()&&s({type:"setResult",result:e})}),(e=>{t()&&s({type:"setError",error:e})}))}),[e,t]);return(0,n.useEffect)((()=>()=>{i.current&&i.current.unsubscribe()}),[]),{result:o.result,error:o.error,loading:o.loading,start:l}}},6188:(e,t,i)=>{"use strict";i.d(t,{$:()=>s});var n=i(43782),a=i(74233);const r=n.exact(n.type({comment:a.u})),o=n.array(r),s=(n.union([o,n.undefined]),new n.Type("DefaultCreateComments",n.array(r).is,(e=>null==e?n.success([]):n.array(r).decode(e)),n.identity))},7615:(e,t,i)=>{"use strict";i.d(t,{g:()=>o});var n=i(43782),a=i(22215),r=i(81252);const o=new n.Type("NonEmptyEntriesArray",a.Qn.is,((e,t)=>Array.isArray(e)&&0===e.length?n.failure(e,t):Array.isArray(e)&&e.some((e=>r.P.is(e)))&&e.some((e=>!r.P.is(e)))?n.failure(e,t,"Cannot have entry of type list and other"):a.Qn.validate(e,t)),n.identity)},79216:(e,t,i)=>{"use strict";i.d(t,{C:()=>f});var n=i(43782),a=i(4451),r=i(59817),o=i(7615),s=i(52590),l=i(98932),d=i(6188),c=i(81196),u=i(89938),m=i(59271),p=i(40200),h=i(18150);const f=n.intersection([n.exact(n.type({description:r.h,entries:o.g,name:s.U,type:l.v})),n.exact(n.partial({comments:d.$,item_id:a.$,list_id:n.undefined,meta:c.mI,namespace_type:u.i,os_types:m.$W,tags:p._,expire_time:h.a}))])},41225:(e,t,i)=>{"use strict";i.d(t,{Z:()=>a,n:()=>r});var n=i(9472);const a=e=>null!=e.id?e:{...e,id:(0,n.v4)()},r=e=>{const t=e;if(null!=t.id){const{id:e,...i}=t;return i}return e}},56269:(e,t,i)=>{"use strict";i.d(t,{X:()=>r});var n=i(76494),a=i.n(n);function r(e,t){const i=new Date,n=a().parse(e,{forceNow:i}),r=a().parse(t,{forceNow:i});if(!n||!r)return;const o=r.diff(n,"ms");return isNaN(o)?void 0:o}},62775:(e,t,i)=>{"use strict";i.d(t,{E:()=>r});var n=i(28979),a=i(56269);function r(e){try{const t=(0,a.X)("now",e);if(void 0===t||t>-1e3&&t<1e3)return e;if(0===t)return"now";const i=n.W.fromMilliseconds(t);return i.value<0?`now${i}`:`now+${i}`}catch{return e}}},28979:(e,t,i)=>{"use strict";i.d(t,{W:()=>TimeDuration});class TimeDuration{static fromMilliseconds(e){return new TimeDuration(Math.round(e/1e3),"s").toNormalizedTimeDuration()}static parse(e){if("string"!=typeof e)return;const t=e.match(n);if(!t)return;const i=parseInt(t[1],10),a=t[2];return new TimeDuration(i,a).toNormalizedTimeDuration()}constructor(e,t){this.value=e,this.unit=t}toMilliseconds(){switch(this.unit){case"s":return 1e3*this.value;case"m":return 1e3*this.value*60;case"h":return 1e3*this.value*60*60;case"d":return 1e3*this.value*60*60*24}}toNormalizedTimeDuration(){const e=this.toMilliseconds();return void 0===e?this:0===e?new TimeDuration(0,"s"):e%864e5==0?new TimeDuration(e/864e5,"d"):e%36e5==0?new TimeDuration(e/36e5,"h"):e%6e4==0?new TimeDuration(e/6e4,"m"):e%1e3==0?new TimeDuration(e/1e3,"s"):this}toString(){return`${this.value}${this.unit}`}}const n=new RegExp(`^((?:\\-|\\+)?[0-9]+)(${["s","m","h","d"].join("|")})$`)},8249:(e,t,i)=>{"use strict";i.d(t,{r:()=>a,w:()=>r});var n=i(56512);const a=`${n.bdu}/fleet/integrations/all`,r=`${n.bdu}/fleet/integrations/installed`},27247:(e,t,i)=>{"use strict";i.d(t,{x75:()=>u.x75,fdc:()=>u.fdc,XMK:()=>m.XM,w6U:()=>p.w6,FYe:()=>p.FY,LGk:()=>p.LG,PkR:()=>p.Pk,olg:()=>m.ol,OFb:()=>m.OF,Uz6:()=>m.Uz,TIc:()=>u.TIc,H94:()=>m.H9,NQh:()=>m.NQ,iKm:()=>u.iKm,oI_:()=>p.oI,exo:()=>m.ex,B_M:()=>m.B_,CV8:()=>m.CV,$hb:()=>h.$h,SMb:()=>h.SM,fUf:()=>m.fU,po1:()=>u.po1,J_L:()=>u.J_L,HdT:()=>m.Hd,xBQ:()=>u.xBQ,zGM:()=>m.zG,nme:()=>m.nm,QeH:()=>m.Qe,DBK:()=>u.DBK});var n=i(87834),a=i(7187);const r=n.z.array(n.z.string().min(1).superRefine(a.b)).min(1),o=n.z.string().min(1).superRefine(a.b),s=n.z.array(o),l=(n.z.enum(["open","closed","acknowledged","in-progress"]).enum,n.z.enum(["open","acknowledged","in-progress"])),d=(l.enum,n.z.object({add:n.z.array(n.z.string().min(1).superRefine(a.b)),remove:n.z.array(n.z.string().min(1).superRefine(a.b))})),c=(n.z.object({assignees:d,ids:r}),n.z.object({tags_to_add:s,tags_to_remove:s}));n.z.object({ids:r,tags:c}),n.z.object({}).catchall(n.z.unknown()),i(8249),n.z.object({acknowledged:n.z.boolean()}),n.z.object({acknowledged:n.z.boolean()}),n.z.object({name:n.z.string(),index_mapping_outdated:n.z.boolean().nullable()}),n.z.object({is_authenticated:n.z.boolean(),has_encryption_key:n.z.boolean()});var u=i(54241),m=i(43070),p=(i(41390),i(64848)),h=i(75158),f=i(13191),g=i(99624),y=i(52353);const v=n.z.object({invocationCount:n.z.number().int(),timeframeEnd:n.z.string().datetime()}),_=n.z.object({request:y.u.optional(),description:y.u.optional(),duration:n.z.number().int().optional(),request_type:y.u.optional()}),b=n.z.object({errors:n.z.array(y.u),warnings:n.z.array(y.u),duration:n.z.number().int(),startedAt:y.u.optional(),requests:n.z.array(_).optional()}),x=(n.z.object({enable_logged_requests:f.s.optional()}),n.z.discriminatedUnion("type",[g.r6.merge(v),g.xc.merge(v),g.kz.merge(v),g.sr.merge(v),g.Us.merge(v),g.kf.merge(v),g.u_.merge(v),g.Gw.merge(v)]),n.z.object({logs:n.z.array(b),previewId:y.u.optional(),isAborted:n.z.boolean().optional()}),n.z.union([n.z.string(),n.z.object({}).catchall(n.z.unknown())])),w=n.z.union([x,n.z.array(x)]),k=(n.z.object({query:n.z.object({}).catchall(n.z.unknown()).optional(),aggs:n.z.object({}).catchall(n.z.unknown()).optional(),size:n.z.number().int().min(0).optional(),track_total_hits:n.z.boolean().optional(),_source:n.z.union([n.z.boolean(),n.z.string(),n.z.array(n.z.string())]).optional(),fields:n.z.array(n.z.string()).optional(),runtime_mappings:n.z.object({}).catchall(n.z.unknown()).optional(),sort:w.optional()}),n.z.object({}).catchall(n.z.unknown()),n.z.enum(["false_positive","duplicate","true_positive","benign_positive","automated_closure","other"])),S=(k.enum,n.z.object({signal_ids:n.z.array(n.z.string().min(1).superRefine(a.b)).min(1),status:l})),T=n.z.object({signal_ids:n.z.array(n.z.string().min(1).superRefine(a.b)).min(1),status:n.z.literal("closed"),reason:k.optional()}),E=n.z.discriminatedUnion("status",[T,S]),z=n.z.object({query:n.z.object({}).catchall(n.z.unknown()),status:l,conflicts:n.z.enum(["abort","proceed"]).optional().default("abort")}),j=n.z.object({query:n.z.object({}).catchall(n.z.unknown()),status:n.z.literal("closed"),conflicts:n.z.enum(["abort","proceed"]).optional().default("abort"),reason:k.optional()}),I=n.z.discriminatedUnion("status",[j,z]),C=(n.z.union([E,I]),n.z.object({}).catchall(n.z.unknown()),n.z.object({requests_per_second:n.z.number().int().min(1).optional(),size:n.z.number().int().min(1).optional(),slices:n.z.number().int().min(1).optional()})),A=n.z.object({index:n.z.string(),migration_id:n.z.string(),migration_index:n.z.string()}),F=n.z.object({index:n.z.string(),error:n.z.object({message:n.z.string(),status_code:n.z.string()})}),M=n.z.object({index:n.z.string()}),D=(n.z.object({index:n.z.array(n.z.string().min(1).superRefine(a.b)).min(1)}).merge(C),n.z.object({indices:n.z.array(n.z.union([A,F,M]))}),n.z.object({id:n.z.string(),destinationIndex:n.z.string(),status:n.z.enum(["success","failure","pending"]),sourceIndex:n.z.string(),version:n.z.string(),updated:n.z.string().datetime(),error:n.z.object({message:n.z.string(),status_code:n.z.number().int()}).optional()})),L=(n.z.object({migration_ids:n.z.array(n.z.string()).min(1)}),n.z.array(D),n.z.object({id:n.z.string(),completed:n.z.boolean(),destinationIndex:n.z.string(),status:n.z.enum(["success","failure","pending"]),sourceIndex:n.z.string(),version:n.z.string(),updated:n.z.string().datetime(),error:n.z.object({message:n.z.string(),status_code:n.z.number().int()}).optional()}));n.z.object({migration_ids:n.z.array(n.z.string()).min(1)}),n.z.array(L);var P=i(8121);const N=n.z.object({version:n.z.number().int(),count:n.z.number().int()}),R=n.z.object({id:y.u,status:n.z.enum(["success","failure","pending"]),version:n.z.number().int(),updated:n.z.string().datetime()}),O=n.z.object({index:y.u,version:n.z.number().int(),signal_versions:n.z.array(N),migrations:n.z.array(R),is_outdated:n.z.boolean()});n.z.object({from:n.z.string().superRefine(P.X)}),n.z.object({indices:n.z.array(O)})},67576:(e,t,i)=>{"use strict";i.d(t,{E:()=>r});var n=i(87834),a=i(43534);const r=n.z.object({id:n.z.string().optional(),rule_id:a.rW.optional(),list_id:n.z.string().min(1).optional(),item_id:n.z.string().min(1).optional(),error:n.z.object({status_code:n.z.number().int().min(400),message:n.z.string()})}).strict()},54241:(e,t,i)=>{"use strict";i.d(t,{x75:()=>n.x75,fdc:()=>n.fdc,TIc:()=>n.TIc,iKm:()=>n.iKm,po1:()=>n.po1,KhL:()=>n.KhL,Nar:()=>n.Nar,J_L:()=>n.J_L,xBQ:()=>o.x,DBK:()=>n.DBK}),i(19437);var n=i(89901),a=(i(67576),i(40316),i(87834));a.z.string(),a.z.boolean(),a.z.string().optional(),a.z.enum(["open","closed","acknowledged","in-progress"]),a.z.enum(["false_positive","duplicate","true_positive","benign_positive","automated_closure","other"]),a.z.array(a.z.string()),a.z.array(a.z.string());const r=a.z.record(a.z.string(),a.z.object({all:a.z.boolean(),maintenance:a.z.boolean(),read:a.z.boolean(),create_index:a.z.boolean(),index:a.z.boolean(),monitor:a.z.boolean(),delete:a.z.boolean(),manage:a.z.boolean(),delete_index:a.z.boolean(),create_doc:a.z.boolean(),view_index_metadata:a.z.boolean(),create:a.z.boolean(),write:a.z.boolean()}));a.z.object({username:a.z.string(),has_all_requested:a.z.boolean(),cluster:a.z.object({monitor_ml:a.z.boolean(),manage_index_templates:a.z.boolean(),monitor_transform:a.z.boolean(),manage_security:a.z.boolean(),manage_own_api_key:a.z.boolean(),all:a.z.boolean(),monitor:a.z.boolean(),manage:a.z.boolean(),manage_transform:a.z.boolean(),manage_ml:a.z.boolean(),manage_pipeline:a.z.boolean()}),index:r,is_authenticated:a.z.boolean(),has_encryption_key:a.z.boolean()}),a.z.object({tags_to_add:a.z.array(a.z.string()),tags_to_remove:a.z.array(a.z.string())}),a.z.string();var o=i(2182);i(69986)},40316:(e,t,i)=>{"use strict";i.d(t,{sX:()=>o});var n=i(87834);const a=n.z.number().int().min(1),r=n.z.number().int().min(0),o=n.z.object({page:a,per_page:r,total:n.z.number().int().min(0)})},19437:(e,t,i)=>{"use strict";i.d(t,{Wm:()=>n.Wm,zn:()=>n.zn});var n=i(16626)},16626:(e,t,i)=>{"use strict";i.d(t,{Wm:()=>r,on:()=>g,zn:()=>a});var n=i(87834);const a=n.z.enum([".osquery",".endpoint"]),r=a.enum,o=n.z.object({}).catchall(n.z.object({field:n.z.string().optional(),value:n.z.union([n.z.string(),n.z.array(n.z.string())]).optional()})),s=n.z.object({id:n.z.string(),query:n.z.string(),ecs_mapping:o.optional(),version:n.z.string().optional(),platform:n.z.string().optional(),removed:n.z.boolean().optional(),snapshot:n.z.boolean().optional()}),l=n.z.object({query:n.z.string().optional(),ecs_mapping:o.optional(),queries:n.z.array(s).optional(),pack_id:n.z.string().optional(),saved_query_id:n.z.string().optional(),timeout:n.z.number().optional()}),d=n.z.object({query:n.z.string().optional(),ecsMapping:o.optional(),queries:n.z.array(s).optional(),packId:n.z.string().optional(),savedQueryId:n.z.string().optional(),timeout:n.z.number().optional()}),c=n.z.object({action_type_id:n.z.literal(".osquery"),params:l}),u=n.z.object({actionTypeId:n.z.literal(".osquery"),params:d}),m=n.z.object({command:n.z.literal("isolate"),comment:n.z.string().optional()}),p=n.z.object({command:n.z.enum(["kill-process","suspend-process"]),comment:n.z.string().optional(),config:n.z.object({field:n.z.string(),overwrite:n.z.boolean().optional().default(!0)})}),h=n.z.object({action_type_id:n.z.literal(".endpoint"),params:n.z.union([m,p])}),f=n.z.object({actionTypeId:n.z.literal(".endpoint"),params:n.z.union([m,p])}),g=n.z.union([c,h]);n.z.union([u,f])},43534:(e,t,i)=>{"use strict";i.d(t,{$Y:()=>ce,$s:()=>X,AI:()=>j,AW:()=>re,Ab:()=>ie,DX:()=>ee,Dj:()=>_e,Eg:()=>x,F3:()=>le,GH:()=>O,GK:()=>ye,HA:()=>T,J_:()=>Y,KF:()=>G,Kh:()=>k,MU:()=>A,N:()=>u,Og:()=>I,Ov:()=>F,Pd:()=>me,Q:()=>S,QW:()=>z,Qt:()=>ve,R3:()=>ge,Rd:()=>se,SV:()=>V,TI:()=>h,U$:()=>d,Vy:()=>L,XM:()=>c,Xi:()=>oe,ZO:()=>ne,aH:()=>R,aS:()=>Z,ap:()=>K,ay:()=>ue,bf:()=>Q,e8:()=>xe,eP:()=>N,eW:()=>fe,fd:()=>Ee,ft:()=>he,g4:()=>D,gR:()=>w,gt:()=>W,gx:()=>E,h0:()=>s,iK:()=>p,mp:()=>m,n7:()=>ae,po:()=>J,qY:()=>je,qf:()=>C,rW:()=>l,rx:()=>q,sJ:()=>Se,t:()=>M,x1:()=>P,x7:()=>ke,zn:()=>f});var n=i(87834),a=i(8121),r=i(7187),o=i(52353);const s=o.k,l=n.z.string(),d=n.z.string().min(1),c=n.z.string().min(1),u=n.z.number().int().min(1),m=n.z.number().int().min(0),p=n.z.enum(["kuery","lucene","eql","esql"]).enum,h=n.z.enum(["kuery","lucene"]),f=(h.enum,n.z.boolean()),g=n.z.boolean(),y=n.z.boolean(),v=n.z.array(n.z.object({field_name:n.z.string()})),_=n.z.object({type:n.z.literal("internal")}),b=n.z.object({type:n.z.literal("external"),is_customized:g,has_base_version:y,customized_fields:v}),x=n.z.discriminatedUnion("type",[b,_]),w=n.z.boolean(),k=n.z.string(),S=n.z.string().superRefine(a.X),T=n.z.string(),E=n.z.number().int().min(0).max(100),z=n.z.array(n.z.object({field:n.z.string(),operator:n.z.literal("equals"),value:n.z.string(),risk_score:E.optional()})),j=n.z.enum(["low","medium","high","critical"]),I=(j.enum,n.z.array(n.z.object({field:n.z.string(),operator:n.z.literal("equals"),severity:j,value:n.z.string()}))),C=n.z.array(n.z.string()),A=n.z.object({}).catchall(n.z.unknown()),F=n.z.string(),M=n.z.array(n.z.string()),D=n.z.array(n.z.string()),L=n.z.array(n.z.string()),P=n.z.string(),N=n.z.string(),R=n.z.string(),O=n.z.string(),q=n.z.string(),V=n.z.number().int().min(1).default(100),U=n.z.object({id:n.z.string(),name:n.z.string(),reference:n.z.string()}),B=n.z.object({id:n.z.string(),name:n.z.string(),reference:n.z.string(),subtechnique:n.z.array(U).optional()}),H=n.z.object({id:n.z.string(),name:n.z.string(),reference:n.z.string()}),$=n.z.object({framework:n.z.string(),tactic:H,technique:n.z.array(B).optional()}),G=n.z.array($),W=n.z.array(n.z.string()),Q=n.z.string(),Y=n.z.string(),J=n.z.string(),K=n.z.array(n.z.unknown()),Z=n.z.string(),X=n.z.string(),ee=n.z.boolean(),te=n.z.object({name:n.z.string().min(1).superRefine(r.b),type:n.z.string().min(1).superRefine(r.b),ecs:n.z.boolean()}),ie=n.z.object({name:n.z.string().min(1).superRefine(r.b),type:n.z.string().min(1).superRefine(r.b)}),ne=n.z.array(te),ae=n.z.string(),re=n.z.string(),oe=n.z.enum(["exactMatch","aliasMatch","conflict"]),se=(oe.enum,n.z.string()),le=n.z.enum(["savedObjectConversion","savedObjectImport"]),de=(le.enum,n.z.object({package:o.u,version:o.u,integration:o.u.optional()})),ce=n.z.array(de),ue=n.z.object({field_names:n.z.array(o.u).min(1)}),me=n.z.union([n.z.enum(["no_actions","rule"]),n.z.string().regex(/^[1-9]\d*[smhd]$/)]),pe=n.z.enum(["onActiveAlert","onThrottleInterval","onActionGroupChange"]),he=(pe.enum,n.z.object({summary:n.z.boolean(),notifyWhen:pe,throttle:me.nullable()})),fe=n.z.object({}).catchall(n.z.unknown()),ge=n.z.object({}).catchall(n.z.unknown()),ye=n.z.string(),ve=n.z.string(),_e=n.z.object({action_type_id:n.z.string(),group:ye.optional(),id:ve,params:ge,uuid:o.u.optional(),alerts_filter:fe.optional(),frequency:he.optional()}),be=n.z.enum(["detection","rule_default","endpoint","endpoint_trusted_apps","endpoint_trusted_devices","endpoint_events","endpoint_host_isolation_exceptions","endpoint_blocklists"]),xe=(be.enum,n.z.object({id:n.z.string().min(1).superRefine(r.b),list_id:n.z.string().min(1).superRefine(r.b),type:be,namespace_type:n.z.enum(["agnostic","single"])})),we=n.z.enum(["s","m","h"]),ke=we.enum,Se=n.z.object({value:n.z.number().int().min(1),unit:we}),Te=n.z.enum(["doNotSuppress","suppress"]),Ee=Te.enum,ze=n.z.array(n.z.string()).min(1).max(3),je=n.z.object({group_by:ze,duration:Se.optional(),missing_fields_strategy:Te.optional()});n.z.object({groupBy:ze,duration:Se.optional(),missingFieldsStrategy:Te.optional()})},89901:(e,t,i)=>{"use strict";i.d(t,{$YD:()=>n.$Y,$ZJ:()=>s.$,$sL:()=>n.$s,AI$:()=>n.AI,AWH:()=>n.AW,Abb:()=>n.Ab,DBK:()=>r.D,DXL:()=>n.DX,Fqq:()=>l.F,J_L:()=>n.J_,KFo:()=>n.KF,KhL:()=>n.rW,Nar:()=>n.N,NpF:()=>a.Np,O41:()=>c.O4,Ogw:()=>n.Og,PtQ:()=>c.Pt,QWD:()=>n.QW,QuJ:()=>s.Q,Rjj:()=>o.Rj,SVT:()=>n.SV,TIc:()=>n.TI,TpT:()=>o.Tp,Tr5:()=>d.Tr,U$H:()=>n.U$,Vyw:()=>n.Vy,XMc:()=>n.XM,ZOi:()=>n.ZO,aHt:()=>n.aH,aSj:()=>n.aS,apW:()=>n.ap,ayf:()=>n.ay,bfL:()=>n.bf,ePo:()=>n.eP,fdc:()=>n.fd,g44:()=>n.g4,gti:()=>n.gt,gxD:()=>n.gx,iKm:()=>n.iK,lwu:()=>l.l,n7P:()=>n.n7,oSh:()=>a.oS,po1:()=>n.po,qYN:()=>n.qY,qf6:()=>n.qf,v77:()=>o.v7,vLm:()=>d.vL,x1i:()=>n.x1,x75:()=>n.x7,xiC:()=>a.xi,zsF:()=>d.zs});var n=i(43534),a=i(99624),r=i(46628),o=i(10934),s=i(87373),l=i(64834),d=i(55092),c=i(58273)},99624:(e,t,i)=>{"use strict";i.d(t,{Gw:()=>$e,Np:()=>v,Us:()=>ge,kf:()=>Te,kz:()=>J,m2:()=>Ye,oS:()=>f,r6:()=>C,sr:()=>oe,u_:()=>Le,xc:()=>q,xi:()=>Qe});var n=i(87834),a=i(43534),r=i(16626),o=i(9513),s=i(10934),l=i(58273),d=i(55092),c=i(87373),u=i(64834);const m=n.z.object({name:a.U$,description:a.XM,risk_score:a.gx,severity:a.AI}),p=n.z.object({rule_name_override:a.aS.optional(),timestamp_override:a.$s.optional(),timestamp_override_fallback_disabled:a.DX.optional(),timeline_id:a.n7.optional(),timeline_title:a.AW.optional(),outcome:a.Xi.optional(),alias_target_id:a.Rd.optional(),alias_purpose:a.F3.optional(),license:a.Ov.optional(),note:a.x1.optional(),building_block_type:a.aH.optional(),output_index:a.GH.optional(),namespace:a.rx.optional(),meta:a.MU.optional(),investigation_fields:a.ay.optional(),throttle:a.Pd.optional(),response_actions:n.z.array(r.on).optional()}),h=n.z.object({version:a.N.optional(),tags:a.qf.optional(),enabled:a.gR.optional(),risk_score_mapping:a.QW.optional(),severity_mapping:a.Og.optional(),interval:a.Kh.optional(),from:a.Q.optional(),to:a.HA.optional(),actions:n.z.array(a.Dj).optional(),exceptions_list:n.z.array(a.e8).optional(),author:a.t.optional(),false_positives:a.g4.optional(),references:a.Vy.optional(),max_signals:a.SV.optional(),threat:a.KF.optional(),setup:a.eP.optional(),related_integrations:a.$Y.optional(),required_fields:n.z.array(a.Ab).optional()}),f=m.merge(p).merge(h),g=m.partial().merge(p).merge(h),y=m.merge(p).merge(h.required()),v=n.z.object({id:a.h0,rule_id:a.rW,immutable:a.zn,rule_source:a.Eg,updated_at:n.z.string().datetime(),updated_by:n.z.string(),created_at:n.z.string().datetime(),created_by:n.z.string(),revision:a.mp,required_fields:a.ZO,execution_summary:o.p.optional()}),_=f.merge(n.z.object({rule_id:a.rW.optional()})),b=f.merge(n.z.object({id:a.h0.optional(),rule_id:a.rW.optional()})),x=g.merge(n.z.object({id:a.h0.optional(),rule_id:a.rW.optional()})),w=y.merge(v),k=n.z.literal("eql"),S=n.z.object({type:n.z.literal("eql"),query:a.po,language:k}),T=n.z.object({index:a.gt.optional(),data_view_id:a.bf.optional(),filters:a.ap.optional(),event_category_override:s.Rj.optional(),tiebreaker_field:s.v7.optional(),timestamp_field:s.Tp.optional(),alert_suppression:a.qY.optional()}),E=S.merge(T),z=S.merge(T),j=S.partial().merge(T),I=w.merge(z),C=_.merge(E),A=b.merge(E),F=x.merge(j),M=n.z.object({type:n.z.literal("query")}),D=n.z.object({index:a.gt.optional(),data_view_id:a.bf.optional(),filters:a.ap.optional(),saved_id:a.J_.optional(),alert_suppression:a.qY.optional()}),L=n.z.object({query:a.po.optional(),language:a.TI.optional()}),P=M.merge(D).merge(L),N=M.partial().merge(D).merge(L),R=M.merge(D).merge(L.required()),O=w.merge(R),q=_.merge(P),V=b.merge(P),U=x.merge(N),B=n.z.object({type:n.z.literal("saved_query"),saved_id:a.J_}),H=n.z.object({index:a.gt.optional(),data_view_id:a.bf.optional(),filters:a.ap.optional(),alert_suppression:a.qY.optional(),query:a.po.optional()}),$=n.z.object({language:a.TI.optional()}),G=B.merge(H).merge($),W=B.partial().merge(H).merge($),Q=B.merge(H).merge($.required()),Y=w.merge(Q),J=_.merge(G),K=b.merge(G),Z=x.merge(W),X=n.z.object({type:n.z.literal("threshold"),query:a.po,threshold:l.O4}),ee=n.z.object({index:a.gt.optional(),data_view_id:a.bf.optional(),filters:a.ap.optional(),saved_id:a.J_.optional(),alert_suppression:l.Pt.optional()}),te=n.z.object({language:a.TI.optional()}),ie=X.merge(ee).merge(te),ne=X.partial().merge(ee).merge(te),ae=X.merge(ee).merge(te.required()),re=w.merge(ae),oe=_.merge(ie),se=b.merge(ie),le=x.merge(ne),de=n.z.object({type:n.z.literal("threat_match"),query:a.po,threat_query:d.jA,threat_mapping:d.vL,threat_index:d.zs}),ce=n.z.object({index:a.gt.optional(),data_view_id:a.bf.optional(),filters:a.ap.optional(),saved_id:a.J_.optional(),threat_filters:d.AH.optional(),threat_indicator_path:d.Tr.optional(),threat_language:a.TI.optional(),concurrent_searches:d.oz.optional(),items_per_search:d.gU.optional(),alert_suppression:a.qY.optional()}),ue=n.z.object({language:a.TI.optional()}),me=de.merge(ce).merge(ue),pe=de.partial().merge(ce).merge(ue),he=de.merge(ce).merge(ue.required()),fe=w.merge(he),ge=_.merge(me),ye=b.merge(me),ve=x.merge(pe),_e=n.z.object({type:n.z.literal("machine_learning"),anomaly_threshold:c.$,machine_learning_job_id:c.Q}),be=n.z.object({alert_suppression:a.qY.optional()}),xe=_e.partial().merge(be),we=_e.merge(be),ke=_e.merge(be),Se=w.merge(we),Te=_.merge(ke),Ee=b.merge(ke),ze=x.merge(xe),je=n.z.object({type:n.z.literal("new_terms"),query:a.po,new_terms_fields:u.l,history_window_start:u.F}),Ie=n.z.object({index:a.gt.optional(),data_view_id:a.bf.optional(),filters:a.ap.optional(),alert_suppression:a.qY.optional()}),Ce=n.z.object({language:a.TI.optional()}),Ae=je.partial().merge(Ie).merge(Ce),Fe=je.merge(Ie).merge(Ce.required()),Me=je.merge(Ie).merge(Ce),De=w.merge(Fe),Le=_.merge(Me),Pe=b.merge(Me),Ne=x.merge(Ae),Re=n.z.literal("esql"),Oe=n.z.object({type:n.z.literal("esql"),language:Re,query:a.po}),qe=n.z.object({alert_suppression:a.qY.optional()}),Ve=qe.merge(Oe.partial()),Ue=qe.merge(Oe),Be=qe.merge(Oe),He=w.merge(Ue),$e=_.merge(Be),Ge=b.merge(Be),We=x.merge(Ve.partial()),Qe=n.z.discriminatedUnion("type",[E,P,G,ie,me,ke,Me,Be]),Ye=(n.z.union([j,N,W,ne,pe,xe,Ae,Ve]),n.z.discriminatedUnion("type",[z,R,Q,ae,he,we,Fe,Ue]),n.z.discriminatedUnion("type",[C,q,J,oe,ge,Te,Le,$e]),n.z.discriminatedUnion("type",[A,V,K,se,ye,Ee,Pe,Ge]),n.z.union([F,U,Z,le,ve,ze,Ne,We]),n.z.discriminatedUnion("type",[I,O,Y,re,fe,Se,De,He]))},10934:(e,t,i)=>{"use strict";i.d(t,{Rj:()=>a,Tp:()=>r,v7:()=>o});var n=i(87834);const a=n.z.string(),r=n.z.string(),o=n.z.string()},87373:(e,t,i)=>{"use strict";i.d(t,{$:()=>a,Q:()=>r});var n=i(87834);const a=n.z.number().int().min(0),r=n.z.union([n.z.string(),n.z.array(n.z.string()).min(1)])},64834:(e,t,i)=>{"use strict";i.d(t,{F:()=>o,l:()=>r});var n=i(87834),a=i(7187);const r=n.z.array(n.z.string()).min(1).max(3),o=n.z.string().min(1).superRefine(a.b)},55092:(e,t,i)=>{"use strict";i.d(t,{AH:()=>d,Tr:()=>c,gU:()=>m,jA:()=>r,oz:()=>u,vL:()=>s,zs:()=>l});var n=i(87834),a=i(52353);const r=n.z.string(),o=n.z.object({field:a.u,type:n.z.literal("mapping"),value:a.u,negate:n.z.boolean().optional()}),s=n.z.array(n.z.object({entries:n.z.array(o)})).min(1),l=n.z.array(n.z.string()),d=n.z.array(n.z.unknown()),c=n.z.string(),u=n.z.number().int().min(1),m=n.z.number().int().min(1)},58273:(e,t,i)=>{"use strict";i.d(t,{O4:()=>d,Pt:()=>c});var n=i(87834),a=i(43534);const r=n.z.array(n.z.object({field:n.z.string(),value:n.z.number().int().min(0)})),o=n.z.number().int().min(1),s=n.z.union([n.z.string(),n.z.array(n.z.string()).max(5)]),l=n.z.array(n.z.string()),d=n.z.object({field:s,value:o,cardinality:r.optional()}),c=(n.z.object({field:l,value:o,cardinality:r.optional()}),n.z.object({field:l,value:o,cardinality:r}),n.z.object({duration:a.sJ}))},1144:(e,t,i)=>{"use strict";i.d(t,{j:()=>r});var n=i(56269),a=i(28979);function r(e){if("now"!==e.to)return;const t=(0,n.X)(e.from,`now-${e.interval}`);return void 0===t||t<0?void 0:{interval:e.interval,lookback:a.W.fromMilliseconds(t).toString()}}},46628:(e,t,i)=>{"use strict";function n(e){var t;return"external"===(null===(t=e.rule_source)||void 0===t?void 0:t.type)&&e.rule_source.is_customized}i.d(t,{D:()=>n})},2182:(e,t,i)=>{"use strict";i.d(t,{x:()=>n});const n=i(87834).z.enum(["asc","desc"]);n.enum},69986:(e,t,i)=>{"use strict";i.d(t,{I:()=>a});var n=i(87834);const a=n.z.object({type:n.z.string(),message:n.z.string(),actionPath:n.z.string(),buttonLabel:n.z.string().optional()})},43070:(e,t,i)=>{"use strict";i.d(t,{XM:()=>ue.XM,ol:()=>p,OF:()=>I,cX:()=>ue.cX,SA:()=>ue.SA,Uz:()=>v,H9:()=>y,NQ:()=>Y,Cs:()=>ue.Cs,sH:()=>ue.sH,Dp:()=>ue.Dp,tD:()=>ue.tD,j1:()=>ue.j1,ex:()=>G,B_:()=>x,CV:()=>w,fU:()=>b,Hd:()=>ae,zG:()=>H,nm:()=>B,Qe:()=>te});var n=i(87834);n.z.object({rules_custom_installed:n.z.number().int().min(0),rules_installed:n.z.number().int().min(0),rules_not_installed:n.z.number().int().min(0),rules_not_updated:n.z.number().int().min(0),timelines_installed:n.z.number().int().min(0),timelines_not_installed:n.z.number().int().min(0),timelines_not_updated:n.z.number().int().min(0)}).strict(),n.z.object({rules_installed:n.z.number().int().min(0),rules_updated:n.z.number().int().min(0),timelines_installed:n.z.number().int().min(0),timelines_updated:n.z.number().int().min(0)}).strict();var a=i(43782);const r=a.exact(a.type({rule_id:a.string,version:a.number})),o=a.exact(a.type({mode:a.literal("SPECIFIC_RULES"),rules:a.array(r)})),s=a.exact(a.type({mode:a.literal("ALL_RULES")}));a.union([s,o]);var l=i(30770),d=i(99624),c=i(43534);const u=n.z.object({message:n.z.string(),status_code:n.z.number().optional(),rules:n.z.array(n.z.object({rule_id:c.rW,name:c.U$.optional()}))});var m=i(89901);let p=function(e){return e.index_patterns="index_patterns",e.data_view="data_view",e}({});const h=n.z.object({type:n.z.literal(p.index_patterns),index_patterns:m.gti}),f=n.z.object({type:n.z.literal(p.data_view),data_view_id:m.bfL}),g=n.z.discriminatedUnion("type",[h,f]);let y=function(e){return e.inline_query="inline_query",e.saved_query="saved_query",e}({});const v=n.z.object({type:n.z.literal(y.inline_query),query:m.po1,language:m.TIc,filters:m.apW}),_=n.z.object({type:n.z.literal(y.saved_query),saved_query_id:m.J_L}),b=n.z.discriminatedUnion("type",[v,_]),x=n.z.object({query:m.po1,language:n.z.literal("eql"),filters:m.apW,event_category_override:m.Rjj.optional(),timestamp_field:m.TpT.optional(),tiebreaker_field:m.v77.optional()}),w=n.z.object({query:m.po1,language:n.z.literal("esql")}),k=n.z.object({field_name:m.aSj}),S=n.z.object({field_name:m.$sL,fallback_disabled:m.DXL}),T=n.z.object({timeline_id:m.n7P,timeline_title:m.AWH}),E=n.z.object({type:m.aHt}),z=({allowedUnits:e})=>n.z.string().refine((t=>{if(""===t.trim())return!1;try{const i=t.length,n=Number(t.trim().substring(0,i-1)),a=t.trim().at(-1);return(e=>e>=1&&Number.isSafeInteger(e))(n)&&e.includes(a)}catch(e){return!1}}),{message:'Invalid time duration format. Must be a string that is not empty, and composed of a positive integer greater than 0 followed by a unit of time in the format {safe_integer}{timeUnit}, e.g. "30s", "1m", "2h", "7d"'}),j=n.z.object({interval:z({allowedUnits:["s","m","h"]}),from:c.Q,to:c.HA}),I=(n.z.object({interval:z({allowedUnits:["s","m","h"]}),lookback:z({allowedUnits:["s","m","h"]})}),n.z.object({rule_id:m.KhL,version:m.Nar,name:m.U$H,tags:m.qf6,description:m.XMc,severity:m.AI$,severity_mapping:m.Ogw,risk_score:m.gxD,risk_score_mapping:m.QWD,references:m.Vyw,false_positives:m.g44,threat:m.KFo,note:m.x1i,setup:m.ePo,related_integrations:m.$YD,required_fields:m.ZOi,rule_schedule:j,max_signals:m.SVT,investigation_fields:m.ayf.optional(),rule_name_override:k.optional(),timestamp_override:S.optional(),timeline_template:T.optional(),building_block:E.optional()})),C=n.z.object({type:n.z.literal("query"),kql_query:b,data_source:g.optional(),alert_suppression:m.qYN.optional()}),A=n.z.object({type:n.z.literal("saved_query"),kql_query:b,data_source:g.optional(),alert_suppression:m.qYN.optional()}),F=n.z.object({type:n.z.literal("eql"),eql_query:x,data_source:g.optional(),alert_suppression:m.qYN.optional()}),M=n.z.object({type:n.z.literal("esql"),esql_query:w,alert_suppression:m.qYN.optional()}),D=n.z.object({type:n.z.literal("threat_match"),kql_query:b,threat_query:v,threat_index:m.zsF,threat_mapping:m.vLm,data_source:g.optional(),threat_indicator_path:m.Tr5.optional(),alert_suppression:m.qYN.optional()}),L=n.z.object({type:n.z.literal("threshold"),kql_query:b,threshold:m.O41,data_source:g.optional(),alert_suppression:m.PtQ.optional()}),P=n.z.object({type:n.z.literal("machine_learning"),machine_learning_job_id:m.QuJ,anomaly_threshold:m.$ZJ,alert_suppression:m.qYN.optional()}),N=n.z.object({type:n.z.literal("new_terms"),kql_query:v,new_terms_fields:m.lwu,history_window_start:m.Fqq,data_source:g.optional(),alert_suppression:m.qYN.optional()}),R=n.z.discriminatedUnion("type",[C,A,F,M,D,L,P,N]),O=(n.z.intersection(I,R),n.z.union([C.shape.type,A.shape.type,F.shape.type,M.shape.type,D.shape.type,L.shape.type,P.shape.type,N.shape.type])),q=I.merge(C.omit({type:!0})).merge(A.omit({type:!0})).merge(F.omit({type:!0})).merge(M.omit({type:!0})).merge(D.omit({type:!0})).merge(L.omit({type:!0})).merge(P.omit({type:!0})).merge(N.omit({type:!0})).merge(n.z.object({type:O})),V=e=>Object.keys(e.shape),U=e=>[...V(I),...V(e)];new Map([["query",U(C)],["saved_query",U(A)],["eql",U(F)],["esql",U(M)],["threat_match",U(D)],["threshold",U(L)],["machine_learning",U(P)],["new_terms",U(N)]]),Symbol("MissingVersion");let B=function(e){return e.StockValueNoUpdate="BASE=A, CURRENT=A, TARGET=A",e.StockValueCanUpdate="BASE=A, CURRENT=A, TARGET=B",e.CustomizedValueNoUpdate="BASE=A, CURRENT=B, TARGET=A",e.CustomizedValueSameUpdate="BASE=A, CURRENT=B, TARGET=B",e.CustomizedValueCanUpdate="BASE=A, CURRENT=B, TARGET=C",e.MissingBaseNoUpdate="BASE=-, CURRENT=A, TARGET=A",e.MissingBaseCanUpdate="BASE=-, CURRENT=A, TARGET=B",e}({}),H=function(e){return e.NONE="NONE",e.SOLVABLE="SOLVABLE",e.NON_SOLVABLE="NON_SOLVABLE",e}({});var $=i(54241);let G=function(e){return e.CUSTOMIZED="CUSTOMIZED",e.NOT_CUSTOMIZED="NOT_CUSTOMIZED",e}({});const W=n.z.object({tags:n.z.array(n.z.string()).optional(),name:n.z.string().optional(),customization_status:n.z.nativeEnum(G).optional()}),Q=(n.z.enum(["ALL_RULES","SPECIFIC_RULES"]).enum,n.z.enum(["BASE","CURRENT","TARGET","MERGED"])),Y=(Q.enum,["type","rule_id","version"]),J=Y.reduce(((e,t)=>({...e,[t]:!0})),{}),K=q.omit(J),Z=n.z.object((0,l.mapValues)(K.shape,(e=>(e=>n.z.discriminatedUnion("pick_version",[n.z.object({pick_version:Q}).strict(),n.z.object({pick_version:n.z.literal("RESOLVED"),resolved_value:e}).strict()]))(e).optional()))).strict(),X=n.z.object({rule_id:$.KhL,revision:n.z.number(),version:$.Nar,pick_version:Q.optional(),fields:Z.optional()}),ee=n.z.enum(["SKIP","UPGRADE_SOLVABLE"]),te=ee.enum,ie=n.z.object({mode:n.z.literal("SPECIFIC_RULES"),rules:n.z.array(X).min(1),pick_version:Q.optional(),on_conflict:ee.optional(),dry_run:n.z.boolean().optional()}),ne=n.z.object({mode:n.z.literal("ALL_RULES"),pick_version:Q.optional(),filter:W.optional(),on_conflict:ee.optional(),dry_run:n.z.boolean().optional()}),ae=n.z.enum(["RULE_UP_TO_DATE","CONFLICT"]).enum,re=n.z.object({reason:n.z.literal(ae.RULE_UP_TO_DATE),rule_id:n.z.string()}),oe=n.z.object({reason:n.z.literal(ae.CONFLICT),rule_id:n.z.string(),conflict:n.z.nativeEnum(H)}),se=n.z.discriminatedUnion("reason",[re,oe]);n.z.object({summary:n.z.object({total:n.z.number(),succeeded:n.z.number(),skipped:n.z.number(),failed:n.z.number()}),results:n.z.object({updated:n.z.array(d.m2),skipped:n.z.array(se)}),errors:n.z.array(u)}),n.z.discriminatedUnion("mode",[ne,ie]);var le=i(64848);const de=W.merge(n.z.object({rule_ids:n.z.array(n.z.string()).optional()})),ce=n.z.object({field:le.HC.optional(),order:$.xBQ.optional()});n.z.object({filter:de.optional(),sort:ce.optional(),page:n.z.coerce.number().int().min(1).optional().default(1),per_page:n.z.coerce.number().int().min(0).optional().default(20)}).nullable();var ue=i(78370);n.z.object({id:n.z.string(),revision:n.z.number(),version:n.z.number()});const me=n.z.enum(["RULE_NOT_PREBUILT","RULE_NOT_CUSTOMIZED"]),pe=(me.enum,n.z.object({id:n.z.string(),skip_reason:me}));n.z.object({success:n.z.boolean().optional(),status_code:n.z.number().int().optional(),message:n.z.string().optional(),rules_count:n.z.number().int().optional(),attributes:n.z.object({results:n.z.object({updated:n.z.array(d.m2),created:n.z.array(d.m2),deleted:n.z.array(d.m2),skipped:n.z.array(pe)}),summary:n.z.object({failed:n.z.number().int(),skipped:n.z.number().int(),succeeded:n.z.number().int(),total:n.z.number().int()}),errors:n.z.array(le.OK).optional()})}),n.z.object({id:n.z.string()})},78370:(e,t,i)=>{"use strict";i.d(t,{Cs:()=>c,Dp:()=>u,SA:()=>a,XM:()=>o,cX:()=>r,j1:()=>s,sH:()=>l,tD:()=>d});const n=`${i(56512).bdu}/prebuilt_rules`,a=`${n}/status`,r=`${n}/base_version`,o=`${n}/_bootstrap`,s=`${n}/upgrade/_review`,l=`${n}/upgrade/_perform`,d=`${n}/installation/_review`,c=`${n}/installation/_perform`,u=`${n}/revert`},41390:(e,t,i)=>{"use strict";i.d(t,{mP:()=>k});var n=i(43782),a=i(79216);const r=/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i,o=new n.Type("UUID",n.string.is,((e,t)=>"string"==typeof e&&r.test(e)?n.success(e):n.failure(e,t)),n.identity);n.exact(n.type({id:o})),n.exact(n.type({items:n.array(a.C)})),n.exact(n.type({name:n.string,description:n.string}));var s=i(89938);const l=n.array(s.i),d=new n.Type("DefaultNamespaceArray",l.is,((e,t)=>{if(null==e)return n.success(["single"]);if("string"==typeof e){const i=e.trim().split(",").map((e=>e.trim()));return l.validate(i,t)}return n.failure(e,t)}),String);var c=i(74233),u=i(21583);const m=n.exact(n.type({id:c.u,list_id:c.u,type:u.y1,namespace_type:s.i})),p=n.array(m);n.union([p,n.undefined]);var h=i(94597),f=i(35475);const g=new n.Type("NonEmptyStringArray",n.array(n.string).is,((e,t)=>{if("string"==typeof e&&""!==e.trim()){const i=e.trim().split(",").map((e=>e.trim()));return i.some((e=>""===e))?n.failure(e,t):n.success(i)}return n.failure(e,t)}),String),y=o,v=n.string,_=c.u,b=(n.intersection([n.exact(n.type({namespace_types:d})),n.exact(n.partial({ids:g,list_ids:g}))]),n.exact(n.type({name:_,id:y,rule_id:v,exception_lists:p}))),x=n.intersection([h.f,n.exact(n.type({referenced_rules:n.array(b)}))]),w=n.record(f.J,x);n.exact(n.type({references:n.array(w)}));const k=`${i(56512).bdu}/rules/exceptions/_find_references`},64848:(e,t,i)=>{"use strict";i.d(t,{YY:()=>I,w6:()=>j,FY:()=>p,LG:()=>W,Pk:()=>Y,HC:()=>re,OK:()=>h,oI:()=>ce.o,FS:()=>ce.F});var n=i(87834),a=i(13191),r=i(99624),o=i(43534),s=i(58273);const l=n.z.literal("RULE_NOT_MODIFIED"),d=n.z.literal("NO_GAPS_TO_FILL"),c=n.z.object({id:n.z.string(),name:n.z.string().optional(),skip_reason:n.z.union([l,d])}),u=n.z.object({id:n.z.string(),name:n.z.string().optional()}),m=n.z.enum(["IMMUTABLE","PREBUILT_CUSTOMIZATION_LICENSE","MACHINE_LEARNING_AUTH","MACHINE_LEARNING_INDEX_PATTERN","ESQL_INDEX_PATTERN","MANUAL_RULE_RUN_FEATURE","MANUAL_RULE_RUN_DISABLED_RULE","THRESHOLD_RULE_TYPE_IN_SUPPRESSION","UNSUPPORTED_RULE_IN_SUPPRESSION_FOR_THRESHOLD","RULE_FILL_GAPS_DISABLED_RULE"]),p=m.enum,h=n.z.object({message:n.z.string(),status_code:n.z.number().int(),err_code:m.optional(),rules:n.z.array(u)}),f=n.z.object({updated:n.z.array(r.m2),created:n.z.array(r.m2),deleted:n.z.array(r.m2),skipped:n.z.array(c)}),g=n.z.object({failed:n.z.number().int(),skipped:n.z.number().int(),succeeded:n.z.number().int(),total:n.z.number().int()}),y=n.z.object({success:n.z.boolean().optional(),status_code:n.z.number().int().optional(),message:n.z.string().optional(),rules_count:n.z.number().int().optional(),attributes:n.z.object({results:f,summary:g,errors:n.z.array(h).optional()})}),v=n.z.string(),_=n.z.object({query:n.z.string().optional(),ids:n.z.array(n.z.string()).min(1).optional(),gaps_range_start:n.z.string().optional(),gaps_range_end:n.z.string().optional()}),b=_.merge(n.z.object({action:n.z.literal("delete")})),x=_.merge(n.z.object({action:n.z.literal("disable")})),w=_.merge(n.z.object({action:n.z.literal("enable")})),k=_.merge(n.z.object({action:n.z.literal("export")})),S=_.merge(n.z.object({action:n.z.literal("duplicate"),duplicate:n.z.object({include_exceptions:n.z.boolean(),include_expired_exceptions:n.z.boolean()}).optional()})),T=_.merge(n.z.object({action:n.z.literal("run"),run:n.z.object({start_date:n.z.string(),end_date:n.z.string()})})),E=_.merge(n.z.object({action:n.z.literal("fill_gaps"),fill_gaps:n.z.object({start_date:n.z.string(),end_date:n.z.string()})})),z=n.z.enum(["rule","1h","1d","7d"]),j=(z.enum,n.z.enum(["enable","disable","export","delete","duplicate","edit","run","fill_gaps"]).enum),I=n.z.enum(["add_tags","delete_tags","set_tags","add_index_patterns","delete_index_patterns","set_index_patterns","set_timeline","add_rule_actions","set_rule_actions","set_schedule","add_investigation_fields","delete_investigation_fields","set_investigation_fields","delete_alert_suppression","set_alert_suppression","set_alert_suppression_for_threshold"]).enum,C=n.z.object({group:o.GK.optional(),id:o.Qt,params:o.R3,frequency:o.ft.optional(),alerts_filter:o.eW.optional()}).strict(),A=n.z.object({type:n.z.enum(["add_rule_actions","set_rule_actions"]),value:n.z.object({throttle:z.optional(),actions:n.z.array(C)})}),F=n.z.object({type:n.z.literal("set_schedule"),value:n.z.object({interval:n.z.string().regex(/^[1-9]\d*[smh]$/),lookback:n.z.string().regex(/^[1-9]\d*[smh]$/)})}),M=n.z.object({type:n.z.enum(["add_index_patterns","delete_index_patterns","set_index_patterns"]),value:o.gt,overwrite_data_views:n.z.boolean().optional()}),D=n.z.object({type:n.z.enum(["add_tags","delete_tags","set_tags"]),value:o.qf}),L=n.z.object({type:n.z.enum(["add_investigation_fields","delete_investigation_fields","set_investigation_fields"]),value:o.ay}),P=n.z.object({type:n.z.literal("set_timeline"),value:n.z.object({timeline_id:o.n7,timeline_title:o.AW})}),N=n.z.object({type:n.z.literal("set_alert_suppression"),value:o.qY}),R=n.z.object({type:n.z.literal("set_alert_suppression_for_threshold"),value:s.Pt}),O=n.z.object({type:n.z.literal("delete_alert_suppression")}),q=n.z.union([N,R,O]),V=n.z.union([D,M,L,P,A,F,q]),U=_.merge(n.z.object({action:n.z.literal("edit"),edit:n.z.array(V).min(1)}));n.z.object({dry_run:a.s.optional()}),n.z.union([b,x,w,k,S,T,E,U]),n.z.union([y,v]);var B=i(43782);function H(e,t){const i=e=>Object.values(t).includes(e);return new B.Type(e,i,((e,t)=>i(e)?B.success(e):B.failure(e,t)),B.identity)}var $=i(74233);const G=(e,t=`NonEmptyArray<${e.name}>`)=>{const i=B.array(e);return new B.Type(t,i.is,((e,t)=>Array.isArray(e)&&0===e.length?B.failure(e,t):i.validate(e,t)),B.identity)};let W=function(e){return e.Enabled="enabled",e.Disabled="disabled",e}({});const Q=H("CoverageOverviewRuleActivity",W);let Y=function(e){return e.Prebuilt="prebuilt",e.Custom="custom",e}({});const J=H("CoverageOverviewRuleSource",Y),K=B.partial({search_term:$.u,activity:G(Q),source:G(J)}),Z=(B.exact(B.partial({filter:K})),B.type({name:B.string,activity:Q})),X=(B.exact(B.type({coverage:B.record(B.string,G(B.string)),unmapped_rule_ids:B.array(B.string),rules_data:B.record(B.string,Z)})),n.z.object({id:o.h0.optional(),rule_id:o.rW.optional()}),n.z.object({id:o.h0.optional(),rule_id:o.rW.optional()}),{exported_exception_list_count:B.number,exported_exception_list_item_count:B.number,missing_exception_list_item_count:B.number,missing_exception_list_items:B.array(B.exact(B.type({item_id:$.u}))),missing_exception_lists:B.array(B.exact(B.type({list_id:$.u}))),missing_exception_lists_count:B.number}),ee=(B.exact(B.type(X)),{exported_count:B.number,exported_rules_count:B.number,missing_rules:B.array(B.exact(B.type({rule_id:$.u}))),missing_rules_count:B.number}),te=B.intersection([B.exact(B.type({id:$.u,type:$.u})),B.exact(B.partial({reason:B.string}))]),ie={exported_action_connector_count:B.number,missing_action_connection_count:B.number,missing_action_connections:B.array(B.exact(B.type({id:$.u,type:$.u}))),excluded_action_connection_count:B.number,excluded_action_connections:B.array(te)};B.intersection([B.exact(B.type(ee)),B.exact(B.partial(X)),B.exact(B.partial(ie))]),n.z.object({exclude_export_details:a.s.optional().default(!1),file_name:n.z.string().optional().default("export.ndjson")}),n.z.object({objects:n.z.array(n.z.object({rule_id:o.rW}))}).nullable();var ne=i(53120),ae=i(2182);const re=n.z.enum(["created_at","createdAt","enabled","execution_summary.last_execution.date","execution_summary.last_execution.metrics.execution_gap_duration_s","execution_summary.last_execution.metrics.total_indexing_duration_ms","execution_summary.last_execution.metrics.total_search_duration_ms","execution_summary.last_execution.status","name","risk_score","riskScore","severity","updated_at","updatedAt"]),oe=(re.enum,n.z.object({fields:(0,ne.T)(n.z.string()).optional(),filter:n.z.string().optional(),sort_field:re.optional(),sort_order:ae.x.optional(),page:n.z.coerce.number().int().min(1).optional().default(1),per_page:n.z.coerce.number().int().min(0).optional().default(20),gaps_range_start:n.z.string().optional(),gaps_range_end:n.z.string().optional()}),n.z.object({page:n.z.number().int(),perPage:n.z.number().int(),total:n.z.number().int(),data:n.z.array(r.m2)}),new B.Type("PositiveInteger",B.number.is,((e,t)=>"number"==typeof e&&Number.isSafeInteger(e)&&e>=0?B.success(e):B.failure(e,t)),B.identity));B.exact(B.type({rules_summary:B.type({custom_count:oe,prebuilt_installed_count:oe}),aggregated_fields:B.type({tags:B.array(B.string)})}));var se=i(67576),le=i(69986);n.z.object({overwrite:a.s.optional().default(!1),overwrite_exceptions:a.s.optional().default(!1),overwrite_action_connectors:a.s.optional().default(!1),as_new_list:a.s.optional().default(!1)}),n.z.object({exceptions_success:n.z.boolean(),exceptions_success_count:n.z.number().int().min(0),exceptions_errors:n.z.array(se.E),rules_count:n.z.number().int().min(0),success:n.z.boolean(),success_count:n.z.number().int().min(0),errors:n.z.array(se.E),action_connectors_errors:n.z.array(se.E),action_connectors_warnings:n.z.array(le.I),action_connectors_success:n.z.boolean(),action_connectors_success_count:n.z.number().int().min(0)}).strict();var de=i(89901);de.oSh.and(de.xiC).and(de.NpF.partial().extend({rule_id:de.KhL,required_fields:n.YO(de.Abb).optional()})).and(n.Ik({version:de.Nar}));var ce=i(44597)},44597:(e,t,i)=>{"use strict";i.d(t,{F:()=>a,o:()=>r});var n=i(56512);const a=`${n.bdu}/rules/_rule_management_filters`,r=`${n.bdu}/rules/_coverage_overview`},75158:(e,t,i)=>{"use strict";i.d(t,{p_:()=>j,Mb:()=>m,x5:()=>z,rF:()=>p,Km:()=>h,$h:()=>v.$h,SM:()=>v.SM,xE:()=>b,jY:()=>S,RO:()=>T,MS:()=>E});var n=i(43782),a=i(88736);let r=function(e){return e.last_hour="last_hour",e.last_day="last_day",e.last_week="last_week",e.last_month="last_month",e.last_year="last_year",e.custom_range="custom_range",e}({}),o=function(e){return e.minute="minute",e.hour="hour",e.day="day",e.week="week",e.month="month",e}({});const s=n.union([n.exact(n.type({type:n.literal(r.last_hour),granularity:n.literal(o.minute)})),n.exact(n.type({type:n.literal(r.last_day),granularity:n.union([n.literal(o.minute),n.literal(o.hour)])})),n.exact(n.type({type:n.literal(r.last_week),granularity:n.union([n.literal(o.hour),n.literal(o.day)])})),n.exact(n.type({type:n.literal(r.last_month),granularity:n.union([n.literal(o.day),n.literal(o.week)])})),n.exact(n.type({type:n.literal(r.last_year),granularity:n.union([n.literal(o.week),n.literal(o.month)])})),n.exact(n.type({type:n.literal(r.custom_range),granularity:n.union([n.literal(o.minute),n.literal(o.hour),n.literal(o.day),n.literal(o.week),n.literal(o.month)]),from:a.H,to:a.H}))]);n.exact(n.partial({interval:s,debug:n.boolean}));var l=i(74233);n.exact(n.intersection([n.type({rule_id:l.u}),n.partial({interval:s,debug:n.boolean})])),n.exact(n.partial({interval:s,debug:n.boolean})),n.exact(n.type({}));var d=i(87834),c=i(53120);const u=d.z.enum(["trace","debug","info","warn","error"]),m=u.enum,p=d.z.enum(["message","status-change","execution-metrics"]),h=p.enum,f=d.z.object({timestamp:d.z.string().datetime(),sequence:d.z.number().int(),level:u,type:p,execution_id:d.z.string().min(1),message:d.z.string()});var g=i(2182),y=i(40316);d.z.object({search_term:d.z.string().optional(),event_types:(0,c.T)(p).optional().default([]),log_levels:(0,c.T)(u).optional().default([]),date_start:d.z.string().datetime().optional(),date_end:d.z.string().datetime().optional(),sort_order:g.x.optional().default("desc"),page:d.z.coerce.number().int().optional().default(1),per_page:d.z.coerce.number().int().optional().default(20)}),d.z.object({ruleId:d.z.string().min(1)}),d.z.object({events:d.z.array(f),pagination:y.sX});var v=i(8319);const _=d.z.enum(["backfill","standard"]),b=_.enum,x=d.z.object({execution_uuid:d.z.string(),timestamp:d.z.string().datetime(),duration_ms:d.z.number().int(),status:d.z.string(),message:d.z.string(),num_active_alerts:d.z.number().int(),num_new_alerts:d.z.number().int(),num_recovered_alerts:d.z.number().int(),num_triggered_actions:d.z.number().int(),num_succeeded_actions:d.z.number().int(),num_errored_actions:d.z.number().int(),total_search_duration_ms:d.z.number().int(),es_search_duration_ms:d.z.number().int(),schedule_delay_ms:d.z.number().int(),timed_out:d.z.boolean(),indexing_duration_ms:d.z.number().int(),search_duration_ms:d.z.number().int(),gap_duration_s:d.z.number().int(),frozen_indices_queried_count:d.z.number().int(),security_status:d.z.string(),security_message:d.z.string(),backfill:d.z.object({from:d.z.string().datetime(),to:d.z.string().datetime()}).optional()}),w=d.z.enum(["timestamp","duration_ms","gap_duration_s","indexing_duration_ms","search_duration_ms","schedule_delay_ms"]);w.enum,d.z.object({start:d.z.string().datetime(),end:d.z.string().datetime(),query_text:d.z.string().optional().default(""),status_filters:(0,c.T)(v.$h).optional().default([]),run_type_filters:(0,c.T)(_).optional().default([]),sort_field:w.optional().default("timestamp"),sort_order:g.x.optional().default("desc"),page:d.z.coerce.number().int().optional().default(1),per_page:d.z.coerce.number().int().optional().default(20)}),d.z.object({ruleId:d.z.string().min(1)}),d.z.object({events:d.z.array(x).optional(),total:d.z.number().int().optional()});var k=i(56512);const S=`${k.bdu}/health/_setup`,T=e=>`${k.bdu}/rules/${e}/execution/events`,E=e=>`${k.bdu}/rules/${e}/execution/results`;i(73024);let z=function(e){return e.trace="trace",e.debug="debug",e.info="info",e.warn="warn",e.error="error",e.off="off",e}({});i(29616),i(9513);const j=u.options},73024:(e,t,i)=>{"use strict";i.d(t,{Q:()=>a});var n=i(87834);const a=n.z.object({total_search_duration_ms:n.z.number().int().min(0).optional(),total_indexing_duration_ms:n.z.number().int().min(0).optional(),total_enrichment_duration_ms:n.z.number().int().min(0).optional(),execution_gap_duration_s:n.z.number().int().min(0).optional(),frozen_indices_queried_count:n.z.number().int().min(0).optional(),gap_range:n.z.object({gte:n.z.string(),lte:n.z.string()}).optional()})},8319:(e,t,i)=>{"use strict";i.d(t,{$h:()=>a,SM:()=>r,Te:()=>o});var n=i(87834);const a=n.z.enum(["going to run","running","partial failure","failed","succeeded"]),r=a.enum,o=n.z.number().int()},9513:(e,t,i)=>{"use strict";i.d(t,{p:()=>o});var n=i(87834),a=i(8319),r=i(73024);const o=n.z.object({last_execution:n.z.object({date:n.z.string().datetime(),status:a.$h,status_order:a.Te,message:n.z.string(),metrics:r.Q})})},32356:(e,t,i)=>{"use strict";i.d(t,{J5:()=>r});var n=i(87834);const a=n.z.enum(["NOT_INSTALLED","DISABLED","ENABLED"]),r=a.enum,o=n.z.enum(["idle","claiming","running","failed","should_delete","unrecognized","dead_letter"]),s=(o.enum,n.z.object({status:o,runAt:n.z.string().datetime(),startedAt:n.z.string().datetime().optional()}));n.z.object({risk_engine_status:a,risk_engine_task_status:s.optional()})},52353:(e,t,i)=>{"use strict";i.d(t,{k:()=>o,u:()=>r});var n=i(87834),a=i(7187);const r=n.z.string().min(1).superRefine(a.b),o=n.z.string().uuid()},13123:(e,t,i)=>{"use strict";i.d(t,{Cu:()=>m});var n=i(27247),a=i(48644),r=i(71288);const o=`${r.xn}: true`,s=`${r.xn}: false`,l=`${r.rr}: true`,d=`${r.rr}: false`,c=`${r.A5}: true`,u=`NOT ${r.A5}: true`;function m({filter:e,showCustomRules:t,showElasticRules:i,enabled:m,tags:f,excludeRuleTypes:g=[],ruleExecutionStatus:y,customizationStatus:v,includeRuleTypes:_=[]}){const b=[];return null!=e&&e.length&&b.push(`(${function(e,t=p){return t.map((t=>`${t}: ${(0,a.Gd)(e)}`)).join(" OR ")}(e)})`),t&&i||(i?b.push(o):t&&b.push(s)),void 0!==m&&b.push(m?l:d),null!=f&&f.length&&b.push(function(e){return`${r.HQ}:(${e.map(a.Gd).join(" AND ")})`}(f)),g.length&&b.push(`NOT ${h(g)}`),_.length&&b.push(h(_)),y===n.SMb.succeeded?b.push(`${r.RZ}: "succeeded"`):y===n.SMb["partial failure"]?b.push(`${r.RZ}: "warning"`):y===n.SMb.failed&&b.push(`${r.RZ}: "failed"`),v===n.exo.CUSTOMIZED?b.push(c):v===n.exo.NOT_CUSTOMIZED&&b.push(u),b.join(" AND ")}const p=[r.ey,r.a$.INDEX,r.a$.TACTIC_ID,r.a$.TACTIC_NAME,r.a$.TECHNIQUE_ID,r.a$.TECHNIQUE_NAME,r.a$.SUBTECHNIQUE_ID,r.a$.SUBTECHNIQUE_NAME];function h(e){return`${r.nA}: (${e.map(a.Gd).join(" OR ")})`}},75577:(e,t,i)=>{"use strict";i.d(t,{$E:()=>s,hU:()=>d,ie:()=>a,jw:()=>l,kq:()=>r,rc:()=>o});var n=i(19437);const a=({group:e,id:t,action_type_id:i,params:n,uuid:a,frequency:r,alerts_filter:o})=>({id:t,params:n,actionTypeId:i,...o&&{alertsFilter:o},...a&&{uuid:a},...r&&{frequency:r},...e&&{group:e}}),r=({group:e,id:t,actionTypeId:i,params:n,uuid:a,frequency:r,alertsFilter:o})=>({id:t,params:n,action_type_id:i,...o&&{alerts_filter:o},...a&&{uuid:a},...r&&{frequency:r},...e&&{group:e}}),o=({id:e,actionTypeId:t,params:i,uuid:n})=>({id:e,params:i,action_type_id:t,...n&&{uuid:n}}),s=({group:e,id:t,params:i,frequency:n,alertsFilter:a})=>({group:e,id:t,params:i,...a&&{alerts_filter:a},...n&&{frequency:n}}),l=({action_type_id:e,params:t})=>{if(e===n.Wm[".osquery"]){const{saved_query_id:i,ecs_mapping:n,pack_id:a,...r}=t;return{params:{...r,savedQueryId:i,ecsMapping:n,packId:a},actionTypeId:e}}return{params:t,actionTypeId:e}},d=({actionTypeId:e,params:t})=>{if(e===n.Wm[".osquery"]){const{savedQueryId:i,ecsMapping:n,packId:a,...r}=t;return{params:{...r,saved_query_id:i,ecs_mapping:n,pack_id:a},action_type_id:e}}return{params:t,action_type_id:e}}},612:(e,t,i)=>{"use strict";i.d(t,{$l:()=>l,Ds:()=>v,I0:()=>f,I2:()=>c,IA:()=>r,J9:()=>o,M4:()=>m,Mj:()=>y,OV:()=>s,SQ:()=>h,YC:()=>g,ZG:()=>p,cy:()=>u,f9:()=>_,q_:()=>d});var n=i(30770),a=i(34940);const r=e=>{if(null!=e){const t=e.trim().split(/[ \t\r\n]+/);return"sequence"===t[0]&&"where"!==t[1]}return!1},o=e=>"eql"===e,s=e=>"threshold"===e,l=e=>"query"===e||"saved_query"===e,d=e=>"threat_match"===e,c=e=>"machine_learning"===e,u=e=>"new_terms"===e,m=e=>"esql"===e,p=e=>Array.isArray(e)?e:(0,n.isEmpty)(e)?[]:[e],h=e=>Array.isArray(e)?e:[e],f=e=>a.bm.includes(e),g=e=>f(e),y=e=>!s(e)&&f(e),v=e=>!s(e)&&f(e),_=e=>f(e)&&a.iy.includes(e)},84064:(e,t,i)=>{"use strict";i.d(t,{r:()=>n});const n=e=>a(e)&&r(e)&&o(e)&&s(e),a=({capabilities:e})=>e.canGetDatafeeds&&e.canStartStopDatafeed&&e.canUpdateDatafeed&&e.canPreviewDatafeed,r=({capabilities:e})=>e.canCreateJob&&e.canGetJobs&&e.canUpdateJob&&e.canDeleteJob&&e.canOpenJob&&e.canCloseJob&&e.canForecastJob,o=({capabilities:e})=>e.canGetFilters&&e.canCreateFilter&&e.canDeleteFilter,s=({capabilities:e})=>e.canCreateCalendar&&e.canGetCalendars&&e.canDeleteCalendar},40883:(e,t,i)=>{"use strict";i.d(t,{J:()=>n});const n=e=>e.isPlatinumOrTrialLicense},27962:(e,t,i)=>{"use strict";i.d(t,{D:()=>n});const n=e=>e.capabilities.canGetJobs&&e.capabilities.canGetDatafeeds&&e.capabilities.canGetCalendars},1934:(e,t,i)=>{"use strict";i.d(t,{AD:()=>s,I2:()=>d,NA:()=>o,xI:()=>l});const n=["started","opened"],a=["starting","stopping","opening","closing"],r=["deleted","failed"],o=(e,t)=>n.includes(e)&&n.includes(t),s=(e,t)=>a.includes(e)||a.includes(t),l=(e,t)=>r.includes(e)||r.includes(t),d=e=>"machine_learning"===e},74360:(e,t,i)=>{"use strict";i.d(t,{I:()=>a});var n=i(56512);const a=e=>e.groups.some((e=>n.LTM.includes(e)))},10238:(e,t,i)=>{"use strict";i.d(t,{g:()=>n});let n=function(e){return e.ENTRA="entityanalytics_entra_id.user",e.OKTA="entityanalytics_okta.user",e}({})},36149:(e,t,i)=>{"use strict";i.d(t,{G:()=>n});const n=e=>e.map((({title:e,fieldName:t,selectedOptions:i=[],existsSelected:n=!1,exclude:a=!1,hideActionBar:r=!1})=>({title:null!=e?e:t,selectedOptions:i,fieldName:t,existsSelected:n,exclude:a,hideActionBar:r})))},2672:(e,t,i)=>{"use strict";i.d(t,{V:()=>a});var n=i(68915);class InvariantError extends Error{constructor(...e){super(...e),(0,n.default)(this,"name","InvariantError")}}function a(e,t){if(!e)throw new InvariantError(t)}},81688:(e,t,i)=>{"use strict";i.d(t,{t:()=>a});var n=i(45278);const a=()=>{const{assistantAvailability:e}=(0,n.BF)();return e}},62290:(e,t,i)=>{"use strict";i.d(t,{e:()=>C});var n=i(81319),a=i(84286),r=i.n(a),o=i(96791),s=i(75879),l=i(49998),d=i(2456),c=i(22019),u=i(99613),m=i(35538),p=i(62402),h=i(32274),f=i(47907),g=i(16047),y=i(4015),v=i(66744),_=i(13140),b=i(63109);const x=({vulnerabilitiesTotal:e})=>{const{euiTheme:t}=(0,n.useEuiTheme)();return(0,o.jsx)(n.EuiFlexItem,null,(0,o.jsx)(n.EuiFlexGroup,{direction:"column",gutterSize:"none"},(0,o.jsx)(n.EuiFlexItem,null,(0,o.jsx)(n.EuiTitle,{size:"s"},(0,o.jsx)("h3",null,e))),(0,o.jsx)(n.EuiFlexItem,null,(0,o.jsx)(n.EuiText,{size:"xs",css:(0,o.css)("font-weight:",t.font.weight.semiBold,";","")},(0,o.jsx)(s.FormattedMessage,{id:"xpack.securitySolution.flyout.right.insights.vulnerabilities.vulnerabilitiesCountDescription",defaultMessage:"Vulnerabilities"})))))},w=({value:e,field:t,isPreviewMode:i,isLinkEnabled:r,openDetailsPanel:l})=>{(0,a.useEffect)((()=>{y.sQ.trackUiMetric(v.METRIC_TYPE.CLICK,y.B7)}),[]);const{data:d}=(0,m.S)({query:(0,h.ie)(t,e),sort:[],enabled:!0,pageSize:1}),{CRITICAL:c=0,HIGH:w=0,MEDIUM:k=0,LOW:S=0,NONE:T=0}=(null==d?void 0:d.count)||{},E=c+w+k+S+T,z=(0,g.$)({critical:c,high:w,medium:k,low:S,none:T}),{euiTheme:j}=(0,n.useEuiTheme)(),{getSeverityStatusColor:I}=(0,p.S)(),C=(0,a.useCallback)((()=>{l({tab:b.yu.CSP_INSIGHTS,subTab:b.NC.VULNERABILITIES})}),[l]),A=(0,a.useMemo)((()=>r?{callback:C,tooltip:(0,o.jsx)(s.FormattedMessage,{id:"xpack.securitySolution.flyout.right.insights.vulnerabilities.vulnerabilitiesTooltip",defaultMessage:"Show all vulnerabilities findings"})}:void 0),[r,C]),F=(0,g.I)({critical:c,high:w,medium:k,low:S,none:T},I);return(0,o.jsx)(_.l,{header:{iconType:!i&&z?"arrowStart":"",title:(0,o.jsx)(n.EuiTitle,{css:(0,o.css)("font-weight:",j.font.weight.semiBold,";","")},(0,o.jsx)(s.FormattedMessage,{id:"xpack.securitySolution.flyout.right.insights.vulnerabilities.vulnerabilitiesTitle",defaultMessage:"Vulnerabilities"})),link:A},"data-test-subj":"securitySolutionFlyoutInsightsVulnerabilities"},(0,o.jsx)(n.EuiFlexGroup,{gutterSize:"none"},(0,o.jsx)(x,{vulnerabilitiesTotal:(0,f.h)(E)}),(0,o.jsx)(n.EuiFlexItem,{grow:2},(0,o.jsx)(n.EuiFlexGroup,{direction:"column",gutterSize:"none"},(0,o.jsx)(n.EuiFlexItem,null),(0,o.jsx)(n.EuiFlexItem,null,(0,o.jsx)(n.EuiSpacer,null),(0,o.jsx)(u.S,{stats:F}))))))};var k=i(30770),S=i(9777);const T=({alertsTotal:e,euiTheme:t})=>(0,o.jsx)(n.EuiFlexItem,null,(0,o.jsx)(n.EuiFlexGroup,{direction:"column",gutterSize:"none"},(0,o.jsx)(n.EuiFlexItem,null,(0,o.jsx)(n.EuiTitle,{size:"s"},(0,o.jsx)("h3",{"data-test-subj":"securitySolutionFlyoutInsightsAlertsCount"},(0,f.h)(e)))),(0,o.jsx)(n.EuiFlexItem,null,(0,o.jsx)(n.EuiText,{size:"xs",css:(0,o.css)("font-weight:",t.font.weight.semiBold,";","")},(0,o.jsx)(s.FormattedMessage,{id:"xpack.securitySolution.flyout.right.insights.alerts.alertsCountDescription",defaultMessage:"Alerts"}))))),E=({alertsData:e,isPreviewMode:t,openDetailsPanel:i,isLinkEnabled:r})=>{const{euiTheme:l}=(0,n.useEuiTheme)(),d=new Map,c={critical:4,high:3,medium:2,low:1};Object.keys(e||{}).forEach((t=>{var i,n;null!=e&&null!==(i=e[t])&&void 0!==i&&i.severities&&(null==e||null===(n=e[t])||void 0===n||n.severities.forEach((e=>{const t=d.get(e.key)||0;d.set(e.key,t+e.value)})))}));const m=Array.from(d,(([e,t])=>({key:(0,k.capitalize)(e),count:t,color:(0,S.XY)(e,l),sort:c[e.toLowerCase()]||0}))).sort(((e,t)=>t.sort-e.sort)),p=m.reduce(((e,t)=>e+t.count),0),h=p>0,f=(0,a.useCallback)((()=>{i({tab:b.yu.CSP_INSIGHTS,subTab:b.NC.ALERTS})}),[i]),g=(0,a.useMemo)((()=>r?{callback:f,tooltip:(0,o.jsx)(s.FormattedMessage,{id:"xpack.securitySolution.flyout.right.insights.alerts.alertsTooltip",defaultMessage:"Show all alerts"})}:void 0),[r,f]);return(0,o.jsx)(_.l,{header:{iconType:!t&&h?"arrowStart":"",title:(0,o.jsx)(n.EuiText,{size:"xs",css:(0,o.css)({fontWeight:l.font.weight.bold},"","")},(0,o.jsx)(s.FormattedMessage,{id:"xpack.securitySolution.flyout.right.insights.alerts.alertsTitle",defaultMessage:"Alerts"})),link:p>0?g:void 0},"data-test-subj":"securitySolutionFlyoutInsightsAlerts"},(0,o.jsx)(n.EuiFlexGroup,{gutterSize:"none"},(0,o.jsx)(T,{alertsTotal:p,euiTheme:l}),(0,o.jsx)(n.EuiFlexItem,{grow:2},(0,o.jsx)(n.EuiFlexGroup,{direction:"column",gutterSize:"none"},(0,o.jsx)(n.EuiFlexItem,null),(0,o.jsx)(n.EuiFlexItem,null,(0,o.jsx)(n.EuiSpacer,null),(0,o.jsx)(u.S,{stats:m,"data-test-subj":"AlertsPreviewDistributionBarTestId"}))))))};var z=i(45443),j=i(76767),I=i(84101);const C=({value:e,field:t,isPreviewMode:i,isLinkEnabled:a,openDetailsPanel:u})=>{const{euiTheme:m}=(0,n.useEuiTheme)(),p=[],{hasMisconfigurationFindings:h}=(0,d.A)(t,e),{hasVulnerabilitiesFindings:f}=(0,l.Q)(t,e),g=f&&"host.name"===t,{to:y,from:v}=(0,z.u)(),{hasNonClosedAlerts:_,filteredAlertsData:b}=(0,I.i)({field:t,value:e,to:y,from:v,queryId:j.L});return _&&p.push((0,o.jsx)(r().Fragment,null,(0,o.jsx)(E,{alertsData:b,isPreviewMode:i,isLinkEnabled:a,openDetailsPanel:u}),(0,o.jsx)(n.EuiSpacer,{size:"s"}))),h&&p.push((0,o.jsx)(r().Fragment,null,(0,o.jsx)(c.V,{value:e,field:t,isPreviewMode:i,isLinkEnabled:a,openDetailsPanel:u}),(0,o.jsx)(n.EuiSpacer,{size:"s"}))),g&&p.push((0,o.jsx)(r().Fragment,null,(0,o.jsx)(w,{value:e,field:t,isPreviewMode:i,isLinkEnabled:a,openDetailsPanel:u}),(0,o.jsx)(n.EuiSpacer,{size:"s"}))),(0,o.jsx)(r().Fragment,null,p.length>0&&(0,o.jsx)(r().Fragment,null,(0,o.jsx)(n.EuiAccordion,{initialIsOpen:!0,id:"entityInsight-accordion","data-test-subj":"entityInsightTestSubj",buttonProps:{"data-test-subj":"entityInsight-accordion-button",css:(0,o.css)("color:",m.colors.primary,";","")},buttonContent:(0,o.jsx)(n.EuiTitle,{size:"xs"},(0,o.jsx)("h3",null,(0,o.jsx)(s.FormattedMessage,{id:"xpack.securitySolution.flyout.entityDetails.insightsTitle",defaultMessage:"Insights"})))},(0,o.jsx)(n.EuiSpacer,{size:"m"}),p),(0,o.jsx)(n.EuiHorizontalRule,null)))}},22019:(e,t,i)=>{"use strict";i.d(t,{V:()=>v,f:()=>g});var n=i(84286),a=i(96791),r=i(81319),o=i(75879),s=i(99613),l=i(2456),d=i(75008),c=i(69074),u=i(83348),m=i(66744),p=i(4015),h=i(13140),f=i(63109);const g=(e,t)=>{const{getMisconfigurationStatusColor:i}=(0,c.O)();return(0,n.useMemo)((()=>{const n=[];return 0===e&&0===t?[]:(e>0&&n.push({key:d.i18n.translate("xpack.securitySolution.flyout.right.insights.misconfigurations.passedFindingsText",{defaultMessage:"{count, plural, one {Passed finding} other {Passed findings}}",values:{count:e}}),count:e,color:i(u.ff.PASSED)}),t>0&&n.push({key:d.i18n.translate("xpack.securitySolution.flyout.right.insights.misconfigurations.failedFindingsText",{defaultMessage:"{count, plural, one {Failed finding} other {Failed findings}}",values:{count:t}}),count:t,color:i(u.ff.FAILED)}),n)}),[e,t,i])},y=({passedFindings:e,failedFindings:t})=>{const{euiTheme:i}=(0,r.useEuiTheme)();return(0,a.jsx)(r.EuiFlexItem,null,(0,a.jsx)(r.EuiFlexGroup,{direction:"column",gutterSize:"none"},(0,a.jsx)(r.EuiFlexItem,null,(0,a.jsx)(r.EuiTitle,{size:"s"},(0,a.jsx)("h3",null,`${Math.round(e/(e+t)*100)}%`))),(0,a.jsx)(r.EuiFlexItem,null,(0,a.jsx)(r.EuiText,{size:"xs",css:(0,a.css)("font-weight:",i.font.weight.semiBold,";","")},(0,a.jsx)(o.FormattedMessage,{id:"xpack.securitySolution.flyout.right.insights.misconfigurations.postureScoreDescription",defaultMessage:"Posture score"})))))},v=({value:e,field:t,isPreviewMode:i,isLinkEnabled:d,openDetailsPanel:c})=>{const{hasMisconfigurationFindings:u,passedFindings:v,failedFindings:_}=(0,l.A)(t,e),b=g(v,_);(0,n.useEffect)((()=>{p.sQ.trackUiMetric(m.METRIC_TYPE.CLICK,p.LT)}),[]);const{euiTheme:x}=(0,r.useEuiTheme)(),w=(0,n.useCallback)((()=>{c({tab:f.yu.CSP_INSIGHTS,subTab:f.NC.MISCONFIGURATIONS})}),[c]),k=(0,n.useMemo)((()=>d?{callback:w,tooltip:(0,a.jsx)(o.FormattedMessage,{id:"xpack.securitySolution.flyout.right.insights.misconfiguration.misconfigurationTooltip",defaultMessage:"Show all misconfiguration findings"})}:void 0),[d,w]);return(0,a.jsx)(h.l,{header:{iconType:!i&&u?"arrowStart":"",title:(0,a.jsx)(r.EuiTitle,{css:(0,a.css)("font-weight:",x.font.weight.semiBold,";",""),"data-test-subj":"securitySolutionFlyoutInsightsMisconfigurationsTitleText"},(0,a.jsx)(o.FormattedMessage,{id:"xpack.securitySolution.flyout.right.insights.misconfigurations.misconfigurationsTitle",defaultMessage:"Misconfigurations"})),link:u?k:void 0},"data-test-subj":"securitySolutionFlyoutInsightsMisconfigurations"},(0,a.jsx)(r.EuiFlexGroup,{gutterSize:"none"},(0,a.jsx)(y,{passedFindings:v,failedFindings:_}),(0,a.jsx)(r.EuiFlexItem,{grow:2},(0,a.jsx)(r.EuiFlexGroup,{direction:"column",gutterSize:"none"},(0,a.jsx)(r.EuiFlexItem,null),(0,a.jsx)(r.EuiFlexItem,null,(0,a.jsx)(r.EuiSpacer,null),(0,a.jsx)(s.S,{stats:b}))))))}},84101:(e,t,i)=>{"use strict";i.d(t,{i:()=>s});var n=i(84286),a=i(89693),r=i(38288),o=i(55892);const s=({field:e,value:t,to:i,from:s,queryId:l})=>{var d,c;const{signalIndexName:u}=(0,r.q)(),m=(0,n.useMemo)((()=>({field:e,value:t})),[e,t]),{items:p}=(0,o.SU)({entityFilter:m,signalIndexName:u,queryId:l,to:i,from:s,runtimeMappings:{"related.entity":{type:"keyword"}}}),h=p?Object.fromEntries(Object.entries(p).filter((([e])=>e!==a.Qf))):{};return{hasNonClosedAlerts:((null==h||null===(d=h.acknowledged)||void 0===d?void 0:d.total)||0)+((null==h||null===(c=h.open)||void 0===c?void 0:c.total)||0)>0,filteredAlertsData:h}}},82302:(e,t,i)=>{"use strict";i.d(t,{s:()=>u,t:()=>c});var n=i(81319),a=i(84286),r=i.n(a),o=i(75008);const s=o.i18n.translate("xpack.securitySolution.accessibility.tooltipWithKeyboardShortcut.pressTooltipLabel",{defaultMessage:"Press"});var l=i(96791);const d=({additionalScreenReaderOnlyContext:e="",content:t,shortcut:i,showShortcut:a})=>(0,l.jsx)(r().Fragment,null,(0,l.jsx)("div",{"data-test-subj":"content"},t),""!==e&&(0,l.jsx)(n.EuiScreenReaderOnly,null,(0,l.jsx)("p",{"data-test-subj":"additionalScreenReaderOnlyContext"},e)),a&&(0,l.jsx)(n.EuiText,{color:"subdued","data-test-subj":"shortcut",size:"s",textAlign:"center"},(0,l.jsx)("span",null,s)," ",(0,l.jsx)(n.EuiBadge,{color:"hollow"},i))),c=r().memo(d);c.displayName="TooltipWithKeyboardShortcut";const u=({interval:e})=>{const t=(0,a.useMemo)((()=>{if(e){const i=parseInt(e.slice(0,-1),10),n=e.charAt(e.length-1);if(Number.isFinite(i))switch(n){case"s":return t=i,o.i18n.translate("xpack.securitySolution.accessibility.intervalAbbrScreenReader.seconds",{defaultMessage:"{value} {value, plural, one { second } other { seconds }}",values:{value:t}});case"m":return(e=>o.i18n.translate("xpack.securitySolution.accessibility.intervalAbbrScreenReader.minutes",{defaultMessage:"{value} {value, plural, one { minute } other { minutes }}",values:{value:e}}))(i);case"h":return(e=>o.i18n.translate("xpack.securitySolution.accessibility.intervalAbbrScreenReader.hours",{defaultMessage:"{value} {value, plural, one { hour } other { hours }}",values:{value:e}}))(i)}}var t}),[e]);return(0,l.jsx)(r().Fragment,null,(0,l.jsx)("span",{"data-test-subj":"interval-abbr-value","aria-hidden":Boolean(t)},e),t&&(0,l.jsx)(n.EuiScreenReaderOnly,null,(0,l.jsx)("p",null,t)))}},29848:(e,t,i)=>{"use strict";i.r(t),i.d(t,{BarChartWrapper:()=>w,ChartWrapper:()=>x,SeriesType:()=>p,WrappedByAutoSizer:()=>m,Wrapper:()=>b,chartDefaultSettings:()=>g,checkIfAllValuesAreZero:()=>_,defaultChartHeight:()=>d,defaultChartWidth:()=>c,getChartHeight:()=>y,getChartWidth:()=>v,useThemes:()=>f});var n=i(61971),a=i(43059),r=i(81319),o=i(84286),s=i.n(o),l=i(95535);const d="100%",c="100%",u=(0,n.A)("div",{target:"ew2sgln3"})((e=>`\n    height: ${null!=e.height?e.height:d};\n  `)," position:relative;&:hover{z-index:100;}");u.displayName="WrappedByAutoSizer";const m=s().memo(u);let p=function(e){return e.BAR="bar",e.AREA="area",e.LINE="line",e}({});const h={chartMargins:{left:0,right:0,top:4,bottom:0},chartPaddings:{left:0,right:0,top:0,bottom:0},scales:{barsPadding:.05}},f=()=>({baseTheme:(0,l.v)(),theme:h}),g={rotation:0,rendering:"canvas",showLegend:!1,legendValues:[],debug:!1,legendPosition:a.Position.Bottom},y=(e,t)=>{const i=e||t;return i?`${i}px`:d},v=(e,t)=>{const i=e||t;return i?`${i}px`:c},_=e=>Array.isArray(e)&&e.every((e=>Array.isArray(e.value)&&e.value.every((({y:e})=>0===e)))),b=(0,n.A)("div",{target:"ew2sgln2"})({name:"bjn8wh",styles:"position:relative"}),x=(0,n.A)(r.EuiFlexGroup,{target:"ew2sgln1"})({name:"125wnaz",styles:"z-index:0"}),w=(0,n.A)(r.EuiFlexGroup,{target:"ew2sgln0"})({name:"1135n8c",styles:"z-index:0;padding-right:20px"})},73671:(e,t,i)=>{"use strict";i.d(t,{V:()=>y,W:()=>g});var n=i(81319),a=i(84286),r=i.n(a),o=i(43059),s=i(30770),l=i(75008),d=i(96791),c=i(29848),u=i(81057),m=i(7777);const p={chartMargins:{top:0,bottom:0,left:0,right:0},partition:{idealFontSizeJump:1.1,outerSizeRatio:1,emptySizeRatio:.8,circlePadding:4}};var h={name:"hmav8r",styles:"position:relative;align-items:center"};const f=({children:e,dataExists:t,donutTextWrapperClassName:i,donutTextWrapperStyles:r,isChartEmbeddablesEnabled:o,label:s,title:l})=>{const{euiTheme:c}=(0,n.useEuiTheme)(),u=((e,t,i,n)=>({donutTextWrapper:(0,d.css)("top:",t&&!e?"66%":"34%",";width:100%;max-width:75%;position:absolute;z-index:1;",n&&i?`&.${n} {${i}}`:"",";",""),flexItem:h}))(t,o,r,i),m=(0,a.useMemo)((()=>({color:c.colors.textSubdued})),[c.colors.textSubdued]),p=o?void 0:"eui-textTruncate";return(0,d.jsx)(n.EuiFlexGroup,{alignItems:"center",justifyContent:"center",responsive:!1,gutterSize:"l","data-test-subj":"donut-chart"},(0,d.jsx)(n.EuiFlexItem,{css:u.flexItem,grow:o},(0,d.jsx)(n.EuiFlexGroup,{css:u.donutTextWrapper,alignItems:"center",className:i,direction:"column",gutterSize:"none",justifyContent:"center"},(0,d.jsx)(n.EuiFlexItem,null,l),s&&(0,d.jsx)(n.EuiFlexItem,{className:p},(0,d.jsx)(n.EuiToolTip,{content:s},(0,d.jsx)(n.EuiText,{tabIndex:0,className:p,size:"s",css:t?void 0:m},s)))),e))},g=r().memo(f),y=({data:e,fillColor:t,height:i=90,label:h,legendItems:f,onPartitionClick:y,title:v,totalCount:_})=>{const{baseTheme:b,theme:x}=(0,c.useThemes)(),w=(0,a.useCallback)((e=>{if(y){var t;const i=e.flat(2),n=i.length>0&&"groupByRollup"in i[0]&&null!=(null===(t=i[0])||void 0===t?void 0:t.groupByRollup)?`${i[0].groupByRollup}`:"";(0,s.isEmpty)(n.trim())||y(n)}}),[y]);return(0,d.jsx)(g,{dataExists:null!=e&&e.length>0,label:h,title:v,isChartEmbeddablesEnabled:!1},(0,d.jsx)(r().Fragment,null,null==e||null==_||0===_?(0,d.jsx)(m.w,{size:i}):(0,d.jsx)(o.Chart,{size:i},(0,d.jsx)(o.Settings,{theme:[p,x],baseTheme:b,onElementClick:w,locale:l.i18n.getLocale()}),(0,d.jsx)(o.Partition,{id:"donut-chart",data:e,layout:o.PartitionLayout.sunburst,valueAccessor:e=>e.value,valueFormatter:e=>`${(0,o.defaultPartitionValueFormatter)(e)}`,layers:[{groupByRollup:e=>{var t;return null!==(t=e.label)&&void 0!==t?t:e.key},nodeLabel:e=>e,shape:{fillColor:t}}]})),f&&(null==f?void 0:f.length)>0&&(0,d.jsx)(n.EuiFlexItem,null,(0,d.jsx)(u.Dd,{legendItems:f,height:i}))))}},7777:(e,t,i)=>{"use strict";i.d(t,{D:()=>o,w:()=>l});var n=i(81319),a=i(96791),r=i(84286);const o="#FAFBFD",s=({size:e=90,donutWidth:t=20})=>{const{euiTheme:i}=(0,n.useEuiTheme)(),r=e-t;return e-t>0?(0,a.jsx)("div",{"data-test-subj":"empty-donut",css:(0,a.css)("border-radius:50%;height:",e,"px;width:",e,"px;background-color:",i.colors.backgroundBaseSubdued,";text-align:center;line-height:",e,"px;","")},(0,a.jsx)("div",{"data-test-subj":"empty-donut-small",css:(0,a.css)("border-radius:50%;height:",r,"px;width:",r,"px;background-color:",i.colors.backgroundBasePlain,";display:inline-block;vertical-align:middle;","")})):null},l=i.n(r)().memo(s)},81057:(e,t,i)=>{"use strict";i.d(t,{Dd:()=>k});var n=i(81319),a=i(75181),r=i(84286),o=i.n(r),s=i(96791),l=i(61971),d=i(26752),c=i.n(d),u=i(56512),m=i(27456),p=i(12947),h=i(65898),f=i(72259),g=i(30572),y=i(79436);const v=(0,l.A)(n.EuiFlexItem,{target:"e1aa7000"})((({theme:e})=>`margin-right: ${e.euiTheme.size.s};`),";"),_=o().memo((({value:e})=>(0,f.z$)(e)?(0,s.jsx)(o().Fragment,null,e):(0,s.jsx)("em",{"data-test-subj":"value-wrapper-empty"},h.ZI)));_.displayName="ValueWrapper";const b=({legendItem:e,isInlineActions:t=!1})=>{const[i]=(0,p.UW)(u.KYu),{color:a,count:o,dataProviderId:l,field:d,scopeId:h,value:f}=e,b=(0,y.getSourcererScopeId)(null!=h?h:""),x=(0,r.useMemo)((()=>null==e.render?(0,s.jsx)(_,{value:f}):e.render({field:d,value:f})),[d,f,e]);return(0,s.jsx)(n.EuiText,{size:"xs"},(0,s.jsx)(n.EuiFlexGroup,{alignItems:"center",gutterSize:"none",responsive:!1},null!=a&&(0,s.jsx)(n.EuiFlexItem,{grow:!1},(0,s.jsx)(n.EuiHealth,{"data-test-subj":"legend-color",color:a})),(0,s.jsx)(n.EuiFlexItem,{grow:!0},(0,s.jsx)(n.EuiFlexGroup,{alignItems:"center",justifyContent:"spaceBetween",gutterSize:"none",responsive:!1},(0,s.jsx)(n.EuiFlexItem,{grow:!1},t?x:(0,s.jsx)(m.BY,{field:d,hideTopN:!0,id:l,scopeId:h,value:f},x)),null!=o&&(0,s.jsx)(v,{"data-test-subj":"legendItemCount",grow:!1},c()(o).format(i)))),t&&(0,s.jsx)(n.EuiFlexItem,{grow:!1,"data-test-subj":"legendItemInlineActions"},(0,s.jsx)(g.ex,{mode:g.jk.INLINE,visibleCellActions:0,triggerId:g.Gn.DEFAULT,data:{field:d,value:f},sourcererScopeId:b,metadata:{scopeId:h},disabledActionTypes:[g.Pj.SHOW_TOP_N],extraActionsIconType:"boxesVertical",extraActionsColor:"text"}))))};b.displayName="DraggableLegendItemComponent";const x=o().memo(b),w=({className:e,height:t=0,legendItems:i,minWidth:r=165,isInlineActions:o=!1})=>{const l=((e,t)=>{const{euiTheme:i}=(0,n.useEuiTheme)();return{draggableLegendContainer:(0,s.css)("height:",e,"px;overflow:auto;scrollbar-width:thin;width:100%;@media only screen and (min-width: ",i.breakpoint.m,"){width:165px;}min-width:",t,"px;&::-webkit-scrollbar{height:",i.size.base,";width:",i.size.base,";}&::-webkit-scrollbar-thumb{background-clip:content-box;background-color:",(0,a.B3)(i.colors.darkShade,.5),";border:",i.border.radius.small," solid transparent;}&::-webkit-scrollbar-corner,&::-webkit-scrollbar-track{background-color:transparent;}","")}})(0===t?175:t,r);return 0===i.length?null:(0,s.jsx)("div",{css:l.draggableLegendContainer,className:e,"data-test-subj":"draggable-legend"},(0,s.jsx)(n.EuiText,{size:"xs"},(0,s.jsx)(n.EuiFlexGroup,{direction:"column",gutterSize:"none"},i.map((e=>(0,s.jsx)(n.EuiFlexItem,{key:e.dataProviderId,grow:!1},(0,s.jsx)(x,{legendItem:e,isInlineActions:o}),(0,s.jsx)(n.EuiSpacer,{"data-test-subj":"draggable-legend-spacer",size:"s"})))))))};w.displayName="DraggableLegendComponent";const k=o().memo(w)},65898:(e,t,i)=>{"use strict";i.d(t,{CX:()=>r,II:()=>a,ZI:()=>o});var n=i(75008);const a=n.i18n.translate("xpack.securitySolution.chart.dataAllValuesZerosTitle",{defaultMessage:"All values returned zero"}),r=n.i18n.translate("xpack.securitySolution.chart.dataNotAvailableTitle",{defaultMessage:"Chart Data Not Available"}),o=n.i18n.translate("xpack.securitySolution.chart.emptyValueLabel",{defaultMessage:"empty value"})},60186:(e,t,i)=>{"use strict";i.d(t,{Pc:()=>_});var n=i(84286),a=i.n(n),r=i(26768),o=i.n(r),s=i(8765),l=i(62868),d=i(84845),c=i(26500),u=i(30572),m=i(79436),p=i(42147),h=i(54376),f=i(96791);const g=a().memo((({dataProvider:e,scopeId:t=c.ri.active,children:i,hideTopN:a=!1})=>{const{timelineId:r}=(0,n.useContext)(p.h),{tableId:o}=(0,n.useContext)(h.Gt),s=(0,n.useMemo)((()=>{var e;return(0,m.getSourcererScopeId)(null!==(e=null!=t?t:r)&&void 0!==e?e:o)}),[t,o,r]),l=(0,n.useMemo)((()=>{const{value:t,field:i}=e.queryMatch;return{value:t||[],field:i}}),[e.queryMatch]),d=(0,n.useMemo)((()=>a?[u.Pj.SHOW_TOP_N]:[]),[a]);return(0,f.jsx)(u.ex,{mode:u.jk.HOVER_DOWN,visibleCellActions:6,showActionTooltips:!0,triggerId:u.Gn.DEFAULT,data:l,disabledActionTypes:d,sourcererScopeId:s,metadata:{scopeId:t}},i)}));g.displayName="CellActionsWrapper";var y=i(82349);const v=o().span.withConfig({displayName:"ProviderContentWrapper",componentId:"sc-1n4vnmw-0"})(["> span.euiToolTipAnchor{display:block;}> span.euiToolTipAnchor.eui-textTruncate{display:inline-block;}"]),_=a().memo((({dataProvider:e,render:t,scopeId:i,truncate:r,hideTopN:o})=>{const c=(0,n.useMemo)((()=>a().createElement("div",{tabIndex:-1,"data-provider-id":(0,y.FH)(e.id)},r?a().createElement(d.P,{"data-test-subj":"render-truncatable-content"},t(e,null,{isDragging:!1,isDropAnimating:!1,isClone:!1,dropAnimation:null,draggingOver:null,combineWith:null,combineTargetFor:null,mode:null})):a().createElement(v,{"data-test-subj":`render-content-${e.queryMatch.field}`},t(e,null,{isDragging:!1,isDropAnimating:!1,isClone:!1,dropAnimation:null,draggingOver:null,combineWith:null,combineTargetFor:null,mode:null})))),[e,t,r]);return u=i,[s.CV.rulePreview,l.D].includes(null!=u?u:"")?a().createElement(a().Fragment,null,c):a().createElement(g,{dataProvider:e,scopeId:i,hideTopN:o},c);var u}));_.displayName="DraggableWrapper"},82349:(e,t,i)=>{"use strict";i.d(t,{FH:()=>a.FH,FY:()=>a.FY,ME:()=>a.ME,N0:()=>a.N0,NV:()=>a.NV,Ud:()=>a.Ud,Yd:()=>a.Yd,ZN:()=>a.ZN,aj:()=>p,lM:()=>a.lM,lT:()=>c,n4:()=>a.n4,qK:()=>m});var n=i(81060),a=i(17267),r=i(8765),o=i(28104),s=i(79436),l=i(53551),d=i(33727);const c=({activeTimelineDataProviders:e,dataProviders:t,dispatch:i,result:n,timelineId:r,noProviderFound:o=l.Y9.noProviderFound,onAddedToTimeline:s})=>{const c=(0,a.iP)(n),u=t[c];u?(0,d.zO)({dataProviders:e,destination:n.destination,dispatch:i,onAddedToTimeline:s,providerToAdd:u,timelineId:r}):i(o({id:c}))},u={"kibana.alert.rule.name":"kibana.alert.rule.uuid","event.module":"rule.reference"},m=({browserFields:e,dispatch:t,result:i,scopeId:l,defaultsHeader:d})=>{var c;const m=(0,a.xr)(i),p=(e=>(0,n.keyBy)("name",(e=>Object.values(e).reduce(((e,t)=>[...e,...Object.values(null!=t.fields?t.fields:{})]),[]))(e)))(e)[m],h=l!==r.CV.alertsOnAlertsPage&&l!==r.CV.alertsOnRuleDetailsPage||null===(c=d.find((e=>e.id===m)))||void 0===c?{}:c,f=(0,s.getScopedActions)(l);var g;null!=p&&f?t(f.upsertColumn({column:{columnHeaderType:"not-filtered",id:m,linkField:null!==(g=u[m])&&void 0!==g?g:void 0,type:p.type,aggregatable:p.aggregatable,initialWidth:o.Zw,...h},id:l,index:null!=i.destination?i.destination.index:0})):f&&t(f.upsertColumn({column:{columnHeaderType:"not-filtered",id:m,initialWidth:o.Zw},id:l,index:null!=i.destination?i.destination.index:0}))},p=e=>e.slice(e.lastIndexOf(".")+1)},27456:(e,t,i)=>{"use strict";i.d(t,{BY:()=>h,vm:()=>y});var n=i(61971),a=i(81319),r=i(84286),o=i.n(r),s=i(60186),l=i(82349),d=i(49014),c=i(9552),u=i(96791);const m=({field:e,tooltipContent:t})=>null!=t?t:e,p=o().memo((({children:e,field:t,tooltipContent:i,tooltipPosition:n,value:r})=>(e=>null===e)(i)?(0,u.jsx)(o().Fragment,null,e||r):(0,u.jsx)(a.EuiToolTip,{"data-test-subj":`${t}-tooltip`,position:n,content:m({tooltipContent:i,field:t})},(0,u.jsx)(o().Fragment,null,e||r))));p.displayName="Content";const h=o().memo((({hideTopN:e=!1,id:t,field:i,fieldType:n="",isAggregatable:a=!1,value:o,name:d,children:m,scopeId:h,tooltipContent:f,tooltipPosition:g,queryValue:y,truncate:v})=>{const _=(0,r.useMemo)((()=>{var e;return{and:[],enabled:!0,id:(0,l.ME)(t),name:d||(null!==(e=null==o?void 0:o.toString())&&void 0!==e?e:""),excluded:!1,kqlQuery:"",queryMatch:{field:i,value:y||(null!=o?o:""),operator:c.gU}}}),[i,t,d,y,o]),b=(0,r.useCallback)((()=>(0,u.jsx)(p,{field:i,tooltipContent:f,tooltipPosition:g,value:o},m)),[m,i,f,g,o]);return null==o?null:(0,u.jsx)(s.Pc,{dataProvider:_,fieldType:n,isAggregatable:a,hideTopN:e,render:b,scopeId:h,truncate:v})}));h.displayName="DefaultDraggable";const f=(0,n.A)(a.EuiBadge,{target:"eb5dvw90"})({name:"40f4ru",styles:"vertical-align:top"});f.displayName="Badge";const g=({contextId:e,eventId:t,field:i,value:n,iconType:a,isAggregatable:r,fieldType:o,name:s,children:l,scopeId:c,tooltipContent:m,queryValue:p})=>null!=n?(0,u.jsx)(h,{id:`draggable-badge-default-draggable-${e}-${t}-${i}-${n}`,isAggregatable:r,fieldType:o,field:i,name:s,value:n,scopeId:c,tooltipContent:m,queryValue:p},(0,u.jsx)(f,{iconType:a,color:"hollow",title:""},l||(""!==n?n:(0,d.vM)()))):null;g.displayName="DraggableBadgeComponent";const y=o().memo(g);y.displayName="DraggableBadge"},25432:(e,t,i)=>{"use strict";i.d(t,{M:()=>l});var n=i(84286),a=i(81319),r=i(96791);const o=(0,n.lazy)((()=>i.e(8632).then(i.bind(i,76243)))),s={display:"flex",margin:"auto"},l=({onSkip:e})=>(0,r.jsx)(n.Suspense,{fallback:(0,r.jsx)(a.EuiLoadingLogo,{logo:"logoSecurity",size:"xl",css:s})},(0,r.jsx)(o,{onSkip:e}))},10534:(e,t,i)=>{"use strict";i.d(t,{lQ:()=>E,WZ:()=>T});var n=i(81060),a=i(51363),r=i(69219);let o=function(e){return e.MALICIOUS_FILE="malicious_file",e.RANSOMWARE="ransomware",e.MEMORY_SIGNATURE="memory_signature",e.SHELLCODE_THREAD="shellcode_thread",e.BEHAVIOR="behavior",e}({}),s=function(e){return e.PROCESS="process",e.FILE="file",e.NETWORK="network",e.REGISTRY="registry",e.MALWARE="malware",e}({});var l=i(75008),d=i(73597),c=i(15909),u=i(12730),m=i(80633),p=i(81125);const h=`${u.nq}.terms.field`,f=`${u.nq}.terms.value`,g=`${u.nq}.cardinality.field`,y=`${u.nq}.count`,v=l.i18n.translate("xpack.securitySolution.detections.alerts.agentStatus",{defaultMessage:"Agent status"}),_=l.i18n.translate("xpack.securitySolution.detections.alerts.quarantinedFilePath",{defaultMessage:"Quarantined file path"}),b=l.i18n.translate("xpack.securitySolution.detections.alerts.ruleType",{defaultMessage:"Rule type"}),x=[{id:m.It,overrideField:p.ky},{id:"host.name"},...d.im.map((e=>({id:e,overrideField:m._0,label:v}))),{id:"Endpoint.policy.applied.artifacts.global.channel"},{id:"user.name"},{id:"rule.name"},{id:"cloud.provider"},{id:"cloud.region"},{id:"orchestrator.cluster.id"},{id:"orchestrator.cluster.name"},{id:"container.image.name"},{id:"container.image.tag"},{id:"orchestrator.namespace"},{id:"orchestrator.resource.parent.type"},{id:"orchestrator.resource.type"},{id:"process.executable"},{id:"file.path"},{id:a.Zu,label:b}];function w({primaryEventCategory:e,allEventCategories:t}){switch(e){case s.PROCESS:return[{id:"process.name"},{id:"process.parent.name"},{id:"process.args"}];case s.FILE:return[{id:"file.name"},{id:"file.hash.sha256"},{id:"file.directory"},{id:"process.name"}];case s.NETWORK:return[{id:"destination.address"},{id:"destination.port"},{id:"source.address"},{id:"source.port"},{id:"dns.question.name"},{id:"process.name"}];case s.REGISTRY:return[{id:"registry.key"},{id:"registry.value"},{id:"process.name"}];case s.MALWARE:return w({primaryEventCategory:s.FILE,allEventCategories:t});default:let e=[];return null!=t&&t.includes(s.FILE)&&(e=e.concat(w({primaryEventCategory:s.FILE}))),null!=t&&t.includes(s.PROCESS)&&(e=e.concat(w({primaryEventCategory:s.PROCESS}))),e}}function k(e,t){switch(e){case o.BEHAVIOR:return[{id:"rule.description",label:c.NZ},...w({...t,primaryEventCategory:void 0})];case o.SHELLCODE_THREAD:return[{id:"Target.process.executable"},{id:"Memory_protection.unique_key_v1"}];case o.RANSOMWARE:return[{id:"Ransomware.feature"},{id:"process.hash.sha256"},...w({...t,primaryEventCategory:void 0})];case o.MEMORY_SIGNATURE:return w({...t,primaryEventCategory:void 0});case o.MALICIOUS_FILE:return[{id:"file.Ext.quarantine_path",overrideField:m.CR,label:_}];default:return[]}}function S(e){switch(e){case"threshold":return[{id:y,label:c.Xw},{id:h,overrideField:f,label:c.b4},{id:g,label:c.SA}];case"machine_learning":return[{id:`${r.ZQ}.machine_learning_job_id`,legacyId:"signal.rule.machine_learning_job_id"},{id:`${r.ZQ}.anomaly_threshold`,legacyId:"signal.rule.anomaly_threshold"}];case"threat_match":return[{id:`${r.ZQ}.threat_index`,legacyId:"signal.rule.threat_index"},{id:`${r.ZQ}.threat_query`,legacyId:"signal.rule.threat_query"}];case"new_terms":return[{id:u.wz,label:c.Sj},{id:u.g$,label:c.iH}];default:return[]}}function T({eventCategories:e,eventCode:t,eventRuleType:i,ruleCustomHighlightedFields:a,type:r="all"}){const o=a.map((e=>({id:e}))),s=[...x,...w(e),...k(t,e),...S(i)];return"default"===r?(0,n.uniqBy)("id",s):"custom"===r?o:(0,n.uniqBy)("id",[...o,...s])}function E(e){const t=(0,n.find)({category:"event",field:"event.category"},e);let i,a;return Array.isArray(null==t?void 0:t.originalValue)?(i=null==t?void 0:t.originalValue[0],a=null==t?void 0:t.originalValue):(i=null==t?void 0:t.originalValue,i&&(a=[i])),{primaryEventCategory:i,allEventCategories:a}}},94052:(e,t,i)=>{"use strict";i.d(t,{SA:()=>a,if:()=>r});var n=i(81060);const a=e=>(0,n.isEmpty)(e)?"":`Example: ${e}`,r=e=>{switch(e){case"string":case"keyword":return"string";case"number":case"long":case"float":return"number";case"date":return"clock";case"ip":case"geo_point":return"globe";default:return"question"}}},71163:(e,t,i)=>{"use strict";i.d(t,{k:()=>c});var n=i(3185),a=i(84286),r=i(81319),o=i(15909),s=i(51848),l=i(16890),d=i(96791);const c=({asEmptyButton:e,children:t,dataProviders:i,filters:c,timeRange:u,keepDataView:m,iconType:p,flush:h,isDisabled:f,"data-test-subj":g,...y})=>{const{investigateInTimeline:v}=(0,l.R)(),_=(0,a.useCallback)((()=>{v({dataProviders:i,filters:c,timeRange:u,keepDataView:m})}),[i,c,u,m,v]),{timelinePrivileges:{read:b}}=(0,s.x)(),x=!b||f;return e?(0,d.jsx)(r.EuiButtonEmpty,{"aria-label":o.Hw,onClick:_,flush:null!=h?h:"right",size:"xs",iconType:p,disabled:x,"data-test-subj":g},t):(0,d.jsx)(r.EuiButton,(0,n.default)({"aria-label":o.Hw,disabled:x,onClick:_,"data-test-subj":g},y),t)};c.displayName="InvestigateInTimelineButton"},81125:(e,t,i)=>{"use strict";i.d(t,{IR:()=>a,XX:()=>l,hl:()=>r,ky:()=>c,o9:()=>d,o_:()=>o,qZ:()=>s});var n=i(75008);const a=n.i18n.translate("xpack.securitySolution.alertSummaryView.alertSummaryViewConversationId",{defaultMessage:"Alert summary"}),r=e=>n.i18n.translate("xpack.securitySolution.alertSummaryView.alertSummaryViewContextDescription",{defaultMessage:"Alert (from {view})",values:{view:e}}),o=n.i18n.translate("xpack.securitySolution.alertSummaryView.alertSummaryViewContextTooltip",{defaultMessage:"Add this alert as context"}),s=n.i18n.translate("xpack.securitySolution.alertSummaryView.eventSummaryViewConversationId",{defaultMessage:"Event summary"}),l=e=>n.i18n.translate("xpack.securitySolution.alertSummaryView.eventSummaryViewContextDescription",{defaultMessage:"Event (from {view})",values:{view:e}}),d=n.i18n.translate("xpack.securitySolution.alertSummaryView.eventSummaryViewContextTooltip",{defaultMessage:"Add this event as context"}),c=n.i18n.translate("xpack.securitySolution.detections.alerts.ancestorsId",{defaultMessage:"Source event"})},6209:(e,t,i)=>{"use strict";i.d(t,{g:()=>o,t:()=>s});var n=i(17267),a=i(33727),r=i(26500);const o=(e,t,i,o=r.gU,s=!1)=>({and:[],enabled:!0,id:(0,n.ME)(t),name:e,excluded:s,kqlQuery:"",queryMatch:{field:e,value:i,operator:o,displayValue:(0,a.O2)(i)}}),s=(e,t,i,n=r.gU,a=!1)=>{const{and:s,...l}=o(e,t,i,n,a);return l}},54376:(e,t,i)=>{"use strict";i.d(t,{Gt:()=>d,ab:()=>m,v1:()=>c});var n=i(84286),a=i(81319),r=i(75879),o=i(20409),s=i(96791);const l={tall:490,short:250},d=(0,n.createContext)({tableId:null}),c=({height:e="tall"})=>(0,s.jsx)(a.EuiPanel,{color:"subdued"},(0,s.jsx)(a.EuiFlexGroup,{style:{height:l[e]},alignItems:"center",justifyContent:"center","data-test-subj":"loading-alerts-panel"},(0,s.jsx)(a.EuiFlexItem,{grow:!1},(0,s.jsx)(a.EuiLoadingSpinner,{size:"xl"})))),u={maxWidth:500},m=()=>{const{http:e}=(0,o.useKibana)().services;return(0,s.jsx)(a.EuiPanel,{color:"subdued","data-test-subj":"tGridEmptyState"},(0,s.jsx)(a.EuiFlexGroup,{alignItems:"center",justifyContent:"center"},(0,s.jsx)(a.EuiFlexItem,{grow:!1},(0,s.jsx)(a.EuiPanel,{hasBorder:!0,css:u},(0,s.jsx)(a.EuiFlexGroup,null,(0,s.jsx)(a.EuiFlexItem,null,(0,s.jsx)(a.EuiText,{size:"s"},(0,s.jsx)(a.EuiTitle,null,(0,s.jsx)("h3",null,(0,s.jsx)(r.FormattedMessage,{id:"xpack.securitySolution.eventsViewer.empty.title",defaultMessage:"No results match your search criteria"}))),(0,s.jsx)("p",null,(0,s.jsx)(r.FormattedMessage,{id:"xpack.securitySolution.eventsViewer.empty.description",defaultMessage:"Try searching over a longer period of time or modifying your search"})))),(0,s.jsx)(a.EuiFlexItem,{grow:!1},(0,s.jsx)(a.EuiImage,{size:"200",alt:"",url:e.basePath.prepend("/plugins/timelines/assets/illustration_product_no_results_magnifying_glass.svg")})))))))}},8465:(e,t,i)=>{"use strict";i.d(t,{s:()=>n});const n=(0,i(84286).createContext)(null)},41e3:(e,t,i)=>{"use strict";i.d(t,{E:()=>u,M:()=>m});var n=i(84286),a=i.n(n),r=i(81319),o=i(10904),s=i(49014),l=i(15847),d=i(1057),c=i(96791);let u=function(e){return e.FIRST_SEEN="first-seen",e.LAST_SEEN="last-seen",e}({});const m=a().memo((({indexPatterns:e,field:t,type:i,value:m})=>{const[p,{firstSeen:h,lastSeen:f,errorMessage:g}]=(0,o.n)({field:t,value:m,order:i===u.FIRST_SEEN?d.OP.asc:d.OP.desc,defaultIndex:e}),y=(0,n.useMemo)((()=>i===u.FIRST_SEEN?h:f),[h,f,i]);return null!=g?(0,c.jsx)(r.EuiIconTip,{position:"top",content:g,iconProps:{"data-test-subj":"firstLastSeenErrorToolTip"},"aria-label":`firstLastSeenError-${i}`,id:`firstLastSeenError-${t}-${i}`,type:"warning"}):(0,c.jsx)(a().Fragment,null,p&&(0,c.jsx)(r.EuiLoadingSpinner,{"data-test-subj":"loading-spinner",size:"m"}),p||null==y||"Invalid Date"!==new Date(y).toString()?!p&&null!==y&&(0,c.jsx)(r.EuiText,{"data-test-subj":"first-last-seen-value",size:"s"},(0,c.jsx)(l.CR,{value:`${y}`})):y,!p&&null===y&&(0,s.f$)())}));m.displayName="FirstLastSeen"},43616:(e,t,i)=>{"use strict";i.d(t,{eZ:()=>c,lT:()=>m});var n=i(84286),a=i.n(n),r=i(26752),o=i.n(r),s=i(56512),l=i(12947),d=i(96791);const c=()=>{const[e]=(0,l.UW)(s.klS);return t=>((e,t)=>o()(e).format(t))(t,e)},u=({value:e})=>(0,d.jsx)(a().Fragment,null,c()(e));u.displayName="PreferenceFormattedBytesComponent";const m=a().memo(u);m.displayName="PreferenceFormattedBytes"},72591:(e,t,i)=>{"use strict";i.d(t,{g:()=>d});var n=i(84286),a=i.n(n),r=i(26768),o=i.n(r),s=i(81319);const l=o().div.withConfig({displayName:"StatusTextWrapper",componentId:"sc-1nku0d-0"})(["width:100%;display:inline-grid;"]),d=({tooltipContent:e,children:t,healthColor:i,dataTestSubj:n})=>a().createElement(s.EuiToolTip,{content:e},a().createElement(s.EuiHealth,{color:i,"data-test-subj":n},a().createElement(l,{tabIndex:0},a().createElement("span",{className:"eui-textTruncate"},t))));d.displayName="HealthTruncateText"},53555:(e,t,i)=>{"use strict";i.d(t,{e:()=>l});var n=i(81319),a=i(17267),r=i(84286),o=i.n(r),s=i(96791);const l=o().memo((({hoverContent:e,anchorPosition:t="downCenter",children:i})=>{const[o,l]=(0,r.useState)(null!=e),[d,c]=(0,r.useState)(!1),[,u]=(0,r.useState)(void 0),m=(0,r.useRef)(null),p=(0,r.useCallback)((()=>{u((e=>{clearTimeout(e)})),c(!1)}),[]),h=(0,r.useCallback)((()=>{u(Number(setTimeout((()=>{document.body.classList.contains(a.g4)||c(!0)}),100)))}),[u,c]),f=(0,r.useCallback)((()=>{p()}),[p]),g=(0,r.useCallback)((e=>{o&&"Escape"===e.key&&f()}),[o,f]);return(0,r.useEffect)((()=>{l(null!=e&&d)}),[e,d]),(0,r.useEffect)((()=>{var e;o&&(null==m||null===(e=m.current)||void 0===e||e.positionPopoverFluid())}),[e,o]),(0,s.jsx)("div",{onMouseLeave:f},(0,s.jsx)(n.EuiPopover,{ref:m,anchorPosition:t,button:(0,s.jsx)("div",{"data-test-subj":"HoverPopoverButton",onMouseEnter:h},i),closePopover:p,hasArrow:!1,isOpen:o,ownFocus:!1,panelPaddingSize:"none",panelStyle:{minInlineSize:"fit-content"},panelClassName:"HoverPopover__popover",repositionOnScroll:!0},o?(0,s.jsx)("div",{onKeyDown:g},e):null))}));l.displayName="HoverPopover"},38388:(e,t,i)=>{"use strict";i.d(t,{K:()=>f});var n=i(81319),a=i(84286),r=i.n(a),o=i(26768),s=i.n(o),l=i(75008);const d=l.i18n.translate("xpack.securitySolution.alertDetails.summary.readMore",{defaultMessage:"Read More"}),c=l.i18n.translate("xpack.securitySolution.alertDetails.summary.readLess",{defaultMessage:"Read Less"}),u=s()(n.EuiButtonEmpty).withConfig({displayName:"ReadMore",componentId:"sc-1cdn95f-0"})(["span.euiButtonContent{padding:0;}"]),m=s().div.withConfig({displayName:"ExpandedContent",componentId:"sc-1cdn95f-1"})(["max-height:",";overflow-wrap:break-word;overflow-x:hidden;overflow-y:auto;"],(({maxHeight:e})=>e)),p=s().div.withConfig({displayName:"StyledLineClamp",componentId:"sc-1cdn95f-2"})(["display:-webkit-box;-webkit-line-clamp:",";-webkit-box-orient:vertical;overflow:hidden;max-height:",";height:",";"],(({lineClamp:e})=>e),(({lineClampHeight:e})=>e),(({lineClampHeight:e})=>e)),h=({children:e,lineClampHeight:t="5.5em",lineClamp:i=3,maxHeight:n="33vh"})=>{const[o,s]=(0,a.useState)(null),[l,h]=(e=>{const[t,i]=(0,a.useState)(null),n=(0,a.useRef)(null);return(0,a.useEffect)((()=>{var e,t,a,r,o,s,l,d,c;null!=(null===(e=n.current)||void 0===e?void 0:e.clientHeight)&&((null!==(t=null==n||null===(a=n.current)||void 0===a?void 0:a.scrollHeight)&&void 0!==t?t:0)>(null!==(r=null==n||null===(o=n.current)||void 0===o?void 0:o.clientHeight)&&void 0!==r?r:0)&&i(!0),(null!==(s=null===(l=n.current)||void 0===l?void 0:l.scrollHeight)&&void 0!==s?s:0)<=(null!==(d=null==n||null===(c=n.current)||void 0===c?void 0:c.clientHeight)&&void 0!==d?d:0)&&i(!1))}),[n,e]),[t,n]})(e),f=(0,a.useCallback)((()=>{s((e=>!e))}),[]);return o?r().createElement(r().Fragment,null,r().createElement(m,{maxHeight:n,"data-test-subj":"expanded-line-clamp"},r().createElement("p",null,e)),l&&r().createElement(u,{onClick:f,size:"s","data-test-subj":"summary-view-readmore"},c)):r().createElement(r().Fragment,null,null==l||!0===l?r().createElement(p,{"data-test-subj":"styled-line-clamp",ref:h,lineClampHeight:t,lineClamp:i},e):e,l&&r().createElement(u,{onClick:f,size:"s","data-test-subj":"summary-view-readmore"},d))},f=r().memo(h)},55521:(e,t,i)=>{"use strict";i.d(t,{a:()=>u});var n=i(81319),a=i(75181),r=i(84286),o=i.n(r),s=i(26768),l=i.n(s);const d=l().aside.withConfig({displayName:"Aside",componentId:"sc-tazcmx-0"})(["padding:",";",""],(({theme:e})=>e.eui.euiSizeM),(({overlay:e,overlayBackground:t,theme:i})=>e&&(0,s.css)(["background:",";bottom:0;left:0;position:absolute;right:0;top:0;z-index:",";"],t?(0,a.B3)(t,.9):(0,a.B3)(i.eui.euiColorEmptyShade,.9),i.eui.euiZLevel1)));d.displayName="Aside";const c=l()(n.EuiFlexGroup).attrs((()=>({alignItems:"center",direction:"column",gutterSize:"s",justifyContent:"center"}))).withConfig({displayName:"FlexGroup",componentId:"sc-tazcmx-1"})(["",""],(({overlay:e})=>e&&(0,s.css)(["height:100%;"])));c.displayName="FlexGroup";const u=o().memo((({children:e,overlay:t,overlayBackground:i,size:a})=>o().createElement(d,{overlay:t,overlayBackground:i},o().createElement(c,{overlay:{overlay:t}},o().createElement(n.EuiFlexItem,{grow:!1},o().createElement(n.EuiLoadingSpinner,{"data-test-subj":"loading-spinner",size:a})),e&&o().createElement(n.EuiFlexItem,{grow:!1},o().createElement(n.EuiText,{color:"subdued",size:"s"},o().createElement("p",null,e)))))));u.displayName="Loader"},16366:(e,t,i)=>{"use strict";i.d(t,{n:()=>c});var n=i(84286),a=i(81319),r=i(28001),o=i(69042),s=i(51848),l=i(96791);const d=(0,n.forwardRef)((({onChange:e,value:t,ariaLabel:i,editorId:d,dataTestSubj:c,height:u,autoFocusDisabled:m,setIsMarkdownInvalid:p,includePlugins:h=!0,placeholder:f},g)=>{const[y,v]=(0,n.useState)([]),_=(0,n.useCallback)(((e,{messages:t})=>{v(e?[e]:t),p(!!e)}),[p]),b=(0,n.useRef)(null);(0,n.useEffect)((()=>{var e,t;m||null===(e=b.current)||void 0===e||null===(t=e.textarea)||void 0===t||t.focus()}),[m]);const x=(0,o.Ot)("investigation_guide"),w=(0,o.Ot)("investigation_guide_interactions"),{timelinePrivileges:{read:k}}=(0,s.x)(),S=(0,n.useMemo)((()=>h?(0,r.B4)({insightsUpsellingMessage:x,interactionsUpsellingMessage:w,canSeeTimeline:k}):void 0),[h,k,x,w]);return(0,n.useImperativeHandle)(g,(()=>{var e,t;if(!b.current)return null;const i=null===(e=b.current)||void 0===e||null===(t=e.textarea)||void 0===t?void 0:t.closest(".euiMarkdownEditor");return{...b.current,toolbar:null==i?void 0:i.querySelector(".euiMarkdownEditorToolbar")}})),(0,l.jsx)(a.EuiMarkdownEditor,{ref:b,"aria-label":i,editorId:d,onChange:e,value:t,uiPlugins:S,parsingPluginList:r.x8,processingPluginList:r.YG,onParse:_,errors:y,"data-test-subj":c,height:u,placeholder:f})}));d.displayName="MarkdownEditorComponent";const c=(0,n.memo)(d)},57417:(e,t,i)=>{"use strict";i.d(t,{X:()=>d});var n=i(84286),a=i.n(n),r=i(81319),o=i(79140),s=i(16366),l=i(96791);const d=a().memo((0,n.forwardRef)((({field:e,dataTestSubj:t,idAria:i,includePlugins:a,placeholder:d},c)=>{const{isInvalid:u,errorMessage:m}=(0,o.hI)(e),[p,h]=(0,n.useState)(!1);return(0,l.jsx)(r.EuiFormRow,{"data-test-subj":t,describedByIds:i?[i]:void 0,error:m,fullWidth:!0,helpText:e.helpText,isInvalid:u||p,label:e.label,labelAppend:e.labelAppend},(0,l.jsx)(s.n,{ref:c,ariaLabel:i,onChange:e.setValue,value:e.value,"data-test-subj":`${t}-markdown-editor`,setIsMarkdownInvalid:h,includePlugins:a,placeholder:d}))})));d.displayName="MarkdownEditorForm"},61110:(e,t,i)=>{"use strict";i.d(t,{nt:()=>w.n,X2:()=>k.X,To:()=>x});var n=i(3185),a=i(84286),r=i.n(a),o=i(81060),s=i(81319),l=i(31813),d=i.n(l),c=i(75879),u=i(28001),m=i(96791);const p=({disableLinks:e,href:t,target:i,children:n,...a})=>(0,m.jsx)(s.EuiToolTip,{content:t},(0,m.jsx)(s.EuiLink,{href:e?void 0:t,"data-test-subj":"markdown-link",rel:"nofollow",target:"_blank"},n)),h=(0,a.memo)(p);var f=i(12947),g=i(99309),y=i(75008);const v=y.i18n.translate("xpack.securitySolution.markdown.platinumWarning",{defaultMessage:"The following markdown may make use of subscription features"}),_=y.i18n.translate("xpack.securitySolution.markdown.invalid",{defaultMessage:"Invalid markdown detected"}),b=({children:e,disableLinks:t,textSize:i="m"})=>{const l=(0,a.useMemo)((()=>e=>(0,m.jsx)(h,(0,n.default)({},e,{disableLinks:t}))),[t]),p=(0,o.cloneDeep)(u.YG);p[1][1].components.a=l;const y=(0,g.R)().isAtLeast("platinum"),{application:b}=(0,f.o1)().services,x=(0,a.useMemo)((()=>{if(!1===y){const t=String(e);return u._r.some((e=>new RegExp(e).test(t)))}return!1}),[e,y]),w=(0,a.useMemo)((()=>d()().use(u.x8).use(p)),[p]),k=(0,a.useMemo)((()=>{try{return w.processSync(e),null}catch(e){return String(e.message)}}),[e,w]);return(0,m.jsx)(r().Fragment,null,x&&(0,m.jsx)(r().Fragment,null,(0,m.jsx)(s.EuiCallOut,{title:v,color:"primary",iconType:"lock"},(0,m.jsx)(c.FormattedMessage,{id:"xpack.securitySolution.markdown.premiumPluginLinkPrefix",defaultMessage:"To use these interactive markdown features, you must {link}.",values:{link:(0,m.jsx)(s.EuiLink,{href:b.getUrlForApp("management",{path:"stack/license_management/home"})},(0,m.jsx)(c.FormattedMessage,{id:"xpack.securitySolution.markdown.premiumPluginLinkSuffix",defaultMessage:"start a trial or upgrade your subscription"}))}})),(0,m.jsx)(s.EuiSpacer,{size:"s"})),null!==k&&(0,m.jsx)(r().Fragment,null,(0,m.jsx)(s.EuiCallOut,{title:_,color:"danger",iconType:"error"},k),(0,m.jsx)(s.EuiSpacer,{size:"s"})),(0,m.jsx)(s.EuiMarkdownFormat,{parsingPluginList:u.x8,processingPluginList:p,textSize:i},e))};b.displayName="MarkdownRendererComponent";const x=(0,a.memo)(b);var w=i(16366),k=i(57417)},28001:(e,t,i)=>{"use strict";i.d(t,{x8:()=>Gt,_r:()=>Qt,YG:()=>Wt,B4:()=>Yt});var n=i(81319),a=i(70073),r=i(84286),o=i.n(r),s=e=>"checkbox"===e.type,l=e=>e instanceof Date,d=e=>null==e;const c=e=>"object"==typeof e;var u=e=>!d(e)&&!Array.isArray(e)&&c(e)&&!l(e),m=e=>u(e)&&e.target?s(e.target)?e.target.checked:e.target.value:e,p=(e,t)=>e.has((e=>e.substring(0,e.search(/\.\d+(\.|$)/))||e)(t)),h="undefined"!=typeof window&&void 0!==window.HTMLElement&&"undefined"!=typeof document;function f(e){let t;const i=Array.isArray(e);if(e instanceof Date)t=new Date(e);else if(e instanceof Set)t=new Set(e);else{if(h&&(e instanceof Blob||e instanceof FileList)||!i&&!u(e))return e;if(t=i?[]:{},i||(e=>{const t=e.constructor&&e.constructor.prototype;return u(t)&&t.hasOwnProperty("isPrototypeOf")})(e))for(const i in e)e.hasOwnProperty(i)&&(t[i]=f(e[i]));else t=e}return t}var g=e=>Array.isArray(e)?e.filter(Boolean):[],y=e=>void 0===e,v=(e,t,i)=>{if(!t||!u(e))return i;const n=g(t.split(/[,[\].]+?/)).reduce(((e,t)=>d(e)?e:e[t]),e);return y(n)||n===e?y(e[t])?i:e[t]:n};const _="blur",b="onChange",x="onSubmit",w="all",k="pattern",S="required",T=r.createContext(null),E=()=>r.useContext(T),z=e=>{const{children:t,...i}=e;return r.createElement(T.Provider,{value:i},t)};var j=(e,t,i,n=!0)=>{const a={defaultValues:t._defaultValues};for(const r in e)Object.defineProperty(a,r,{get:()=>{const a=r;return t._proxyFormState[a]!==w&&(t._proxyFormState[a]=!n||w),i&&(i[a]=!0),e[a]}});return a},I=e=>u(e)&&!Object.keys(e).length,C=(e,t,i,n)=>{i(e);const{name:a,...r}=e;return I(r)||Object.keys(r).length>=Object.keys(t).length||Object.keys(r).find((e=>t[e]===(!n||w)))},A=e=>Array.isArray(e)?e:[e],F=(e,t,i)=>i&&t?e===t:!e||!t||e===t||A(e).some((e=>e&&(e.startsWith(t)||t.startsWith(e))));function M(e){const t=r.useRef(e);t.current=e,r.useEffect((()=>{const i=!e.disabled&&t.current.subject&&t.current.subject.subscribe({next:t.current.next});return()=>{i&&i.unsubscribe()}}),[e.disabled])}var D=e=>"string"==typeof e,L=(e,t,i,n,a)=>D(e)?(n&&t.watch.add(e),v(i,e,a)):Array.isArray(e)?e.map((e=>(n&&t.watch.add(e),v(i,e)))):(n&&(t.watchAll=!0),i),P=e=>/^\w*$/.test(e),N=e=>g(e.replace(/["|']|\]/g,"").split(/\.|\[/));function R(e,t,i){let n=-1;const a=P(t)?[t]:N(t),r=a.length,o=r-1;for(;++n<r;){const t=a[n];let r=i;if(n!==o){const i=e[t];r=u(i)||Array.isArray(i)?i:isNaN(+a[n+1])?{}:[]}e[t]=r,e=e[t]}return e}function O(e){const t=E(),{name:i,control:n=t.control,shouldUnregister:a}=e,o=p(n._names.array,i),s=function(e){const t=E(),{control:i=t.control,name:n,defaultValue:a,disabled:o,exact:s}=e||{},l=r.useRef(n);l.current=n,M({disabled:o,subject:i._subjects.values,next:e=>{F(l.current,e.name,s)&&c(f(L(l.current,i._names,e.values||i._formValues,!1,a)))}});const[d,c]=r.useState(i._getWatch(n,a));return r.useEffect((()=>i._removeUnmounted())),d}({control:n,name:i,defaultValue:v(n._formValues,i,v(n._defaultValues,i,e.defaultValue)),exact:!0}),l=function(e){const t=E(),{control:i=t.control,disabled:n,name:a,exact:o}=e||{},[s,l]=r.useState(i._formState),d=r.useRef(!0),c=r.useRef({isDirty:!1,isLoading:!1,dirtyFields:!1,touchedFields:!1,isValidating:!1,isValid:!1,errors:!1}),u=r.useRef(a);return u.current=a,M({disabled:n,next:e=>d.current&&F(u.current,e.name,o)&&C(e,c.current,i._updateFormState)&&l({...i._formState,...e}),subject:i._subjects.state}),r.useEffect((()=>(d.current=!0,c.current.isValid&&i._updateValid(!0),()=>{d.current=!1})),[i]),j(s,i,c.current,!1)}({control:n,name:i}),d=r.useRef(n.register(i,{...e.rules,value:s}));return d.current=n.register(i,e.rules),r.useEffect((()=>{const e=n._options.shouldUnregister||a,t=(e,t)=>{const i=v(n._fields,e);i&&(i._f.mount=t)};if(t(i,!0),e){const e=f(v(n._options.defaultValues,i));R(n._defaultValues,i,e),y(v(n._formValues,i))&&R(n._formValues,i,e)}return()=>{(o?e&&!n._state.action:e)?n.unregister(i):t(i,!1)}}),[i,n,o,a]),{field:{name:i,value:s,onChange:r.useCallback((e=>d.current.onChange({target:{value:m(e),name:i},type:"change"})),[i]),onBlur:r.useCallback((()=>d.current.onBlur({target:{value:v(n._formValues,i),name:i},type:_})),[i,n]),ref:e=>{const t=v(n._fields,i);t&&e&&(t._f.ref={focus:()=>e.focus(),select:()=>e.select(),setCustomValidity:t=>e.setCustomValidity(t),reportValidity:()=>e.reportValidity()})}},formState:l,fieldState:Object.defineProperties({},{invalid:{enumerable:!0,get:()=>!!v(l.errors,i)},isDirty:{enumerable:!0,get:()=>!!v(l.dirtyFields,i)},isTouched:{enumerable:!0,get:()=>!!v(l.touchedFields,i)},error:{enumerable:!0,get:()=>v(l.errors,i)}})}}var q=(e,t,i,n,a)=>t?{...i[e],types:{...i[e]&&i[e].types?i[e].types:{},[n]:a||!0}}:{};const V=(e,t,i)=>{for(const n of i||Object.keys(e)){const i=v(e,n);if(i){const{_f:e,...n}=i;if(e&&t(e.name)){if(e.ref.focus){e.ref.focus();break}if(e.refs&&e.refs[0].focus){e.refs[0].focus();break}}else u(n)&&V(n,t)}}};var U=e=>({isOnSubmit:!e||e===x,isOnBlur:"onBlur"===e,isOnChange:e===b,isOnAll:e===w,isOnTouch:"onTouched"===e}),B=(e,t,i)=>!i&&(t.watchAll||t.watch.has(e)||[...t.watch].some((t=>e.startsWith(t)&&/^\.\w+/.test(e.slice(t.length))))),H=(e,t,i)=>{const n=g(v(e,i));return R(n,"root",t[i]),R(e,i,n),e},$=e=>"boolean"==typeof e,G=e=>"file"===e.type,W=e=>"function"==typeof e,Q=e=>{if(!h)return!1;const t=e?e.ownerDocument:0;return e instanceof(t&&t.defaultView?t.defaultView.HTMLElement:HTMLElement)},Y=e=>D(e),J=e=>"radio"===e.type,K=e=>e instanceof RegExp;const Z={value:!1,isValid:!1},X={value:!0,isValid:!0};var ee=e=>{if(Array.isArray(e)){if(e.length>1){const t=e.filter((e=>e&&e.checked&&!e.disabled)).map((e=>e.value));return{value:t,isValid:!!t.length}}return e[0].checked&&!e[0].disabled?e[0].attributes&&!y(e[0].attributes.value)?y(e[0].value)||""===e[0].value?X:{value:e[0].value,isValid:!0}:X:Z}return Z};const te={isValid:!1,value:null};var ie=e=>Array.isArray(e)?e.reduce(((e,t)=>t&&t.checked&&!t.disabled?{isValid:!0,value:t.value}:e),te):te;function ne(e,t,i="validate"){if(Y(e)||Array.isArray(e)&&e.every(Y)||$(e)&&!e)return{type:i,message:Y(e)?e:"",ref:t}}var ae=e=>u(e)&&!K(e)?e:{value:e,message:""},re=async(e,t,i,n,a)=>{const{ref:r,refs:o,required:l,maxLength:c,minLength:m,min:p,max:h,pattern:f,validate:g,name:_,valueAsNumber:b,mount:x,disabled:w}=e._f,T=v(t,_);if(!x||w)return{};const E=o?o[0]:r,z=e=>{n&&E.reportValidity&&(E.setCustomValidity($(e)?"":e||""),E.reportValidity())},j={},C=J(r),A=s(r),F=C||A,M=(b||G(r))&&y(r.value)&&y(T)||Q(r)&&""===r.value||""===T||Array.isArray(T)&&!T.length,L=q.bind(null,_,i,j),P=(e,t,i,n="maxLength",a="minLength")=>{const o=e?t:i;j[_]={type:e?n:a,message:o,ref:r,...L(e?n:a,o)}};if(a?!Array.isArray(T)||!T.length:l&&(!F&&(M||d(T))||$(T)&&!T||A&&!ee(o).isValid||C&&!ie(o).isValid)){const{value:e,message:t}=Y(l)?{value:!!l,message:l}:ae(l);if(e&&(j[_]={type:S,message:t,ref:E,...L(S,t)},!i))return z(t),j}if(!(M||d(p)&&d(h))){let e,t;const n=ae(h),a=ae(p);if(d(T)||isNaN(T)){const i=r.valueAsDate||new Date(T),o=e=>new Date((new Date).toDateString()+" "+e),s="time"==r.type,l="week"==r.type;D(n.value)&&T&&(e=s?o(T)>o(n.value):l?T>n.value:i>new Date(n.value)),D(a.value)&&T&&(t=s?o(T)<o(a.value):l?T<a.value:i<new Date(a.value))}else{const i=r.valueAsNumber||(T?+T:T);d(n.value)||(e=i>n.value),d(a.value)||(t=i<a.value)}if((e||t)&&(P(!!e,n.message,a.message,"max","min"),!i))return z(j[_].message),j}if((c||m)&&!M&&(D(T)||a&&Array.isArray(T))){const e=ae(c),t=ae(m),n=!d(e.value)&&T.length>+e.value,a=!d(t.value)&&T.length<+t.value;if((n||a)&&(P(n,e.message,t.message),!i))return z(j[_].message),j}if(f&&!M&&D(T)){const{value:e,message:t}=ae(f);if(K(e)&&!T.match(e)&&(j[_]={type:k,message:t,ref:r,...L(k,t)},!i))return z(t),j}if(g)if(W(g)){const e=ne(await g(T,t),E);if(e&&(j[_]={...e,...L("validate",e.message)},!i))return z(e.message),j}else if(u(g)){let e={};for(const n in g){if(!I(e)&&!i)break;const a=ne(await g[n](T,t),E,n);a&&(e={...a,...L(n,a.message)},z(a.message),i&&(j[_]=e))}if(!I(e)&&(j[_]={ref:E,...e},!i))return j}return z(!0),j};function oe(e,t){const i=Array.isArray(t)?t:P(t)?[t]:N(t),n=1===i.length?e:function(e,t){const i=t.slice(0,-1).length;let n=0;for(;n<i;)e=y(e)?n++:e[t[n++]];return e}(e,i),a=i.length-1,r=i[a];return n&&delete n[r],0!==a&&(u(n)&&I(n)||Array.isArray(n)&&function(e){for(const t in e)if(e.hasOwnProperty(t)&&!y(e[t]))return!1;return!0}(n))&&oe(e,i.slice(0,-1)),e}function se(){let e=[];return{get observers(){return e},next:t=>{for(const i of e)i.next&&i.next(t)},subscribe:t=>(e.push(t),{unsubscribe:()=>{e=e.filter((e=>e!==t))}}),unsubscribe:()=>{e=[]}}}var le=e=>d(e)||!c(e);function de(e,t){if(le(e)||le(t))return e===t;if(l(e)&&l(t))return e.getTime()===t.getTime();const i=Object.keys(e),n=Object.keys(t);if(i.length!==n.length)return!1;for(const a of i){const i=e[a];if(!n.includes(a))return!1;if("ref"!==a){const e=t[a];if(l(i)&&l(e)||u(i)&&u(e)||Array.isArray(i)&&Array.isArray(e)?!de(i,e):i!==e)return!1}}return!0}var ce=e=>"select-multiple"===e.type,ue=e=>Q(e)&&e.isConnected,me=e=>{for(const t in e)if(W(e[t]))return!0;return!1};function pe(e,t={}){const i=Array.isArray(e);if(u(e)||i)for(const i in e)Array.isArray(e[i])||u(e[i])&&!me(e[i])?(t[i]=Array.isArray(e[i])?[]:{},pe(e[i],t[i])):d(e[i])||(t[i]=!0);return t}function he(e,t,i){const n=Array.isArray(e);if(u(e)||n)for(const n in e)Array.isArray(e[n])||u(e[n])&&!me(e[n])?y(t)||le(i[n])?i[n]=Array.isArray(e[n])?pe(e[n],[]):{...pe(e[n])}:he(e[n],d(t)?{}:t[n],i[n]):i[n]=!de(e[n],t[n]);return i}var fe=(e,t)=>he(e,t,pe(t)),ge=(e,{valueAsNumber:t,valueAsDate:i,setValueAs:n})=>y(e)?e:t?""===e?NaN:e?+e:e:i&&D(e)?new Date(e):n?n(e):e;function ye(e){const t=e.ref;if(!(e.refs?e.refs.every((e=>e.disabled)):t.disabled))return G(t)?t.files:J(t)?ie(e.refs).value:ce(t)?[...t.selectedOptions].map((({value:e})=>e)):s(t)?ee(e.refs).value:ge(y(t.value)?e.ref.value:t.value,e)}var ve=e=>y(e)?e:K(e)?e.source:u(e)?K(e.value)?e.value.source:e.value:e;function _e(e,t,i){const n=v(e,i);if(n||P(i))return{error:n,name:i};const a=i.split(".");for(;a.length;){const n=a.join("."),r=v(t,n),o=v(e,n);if(r&&!Array.isArray(r)&&i!==n)return{name:i};if(o&&o.type)return{name:n,error:o};a.pop()}return{name:i}}const be={mode:x,reValidateMode:b,shouldFocusError:!0};function xe(e={},t){let i,n={...be,...e},a={submitCount:0,isDirty:!1,isLoading:W(n.defaultValues),isValidating:!1,isSubmitted:!1,isSubmitting:!1,isSubmitSuccessful:!1,isValid:!1,touchedFields:{},dirtyFields:{},errors:{}},r={},o=(u(n.defaultValues)||u(n.values))&&f(n.defaultValues||n.values)||{},c=n.shouldUnregister?{}:f(o),b={action:!1,mount:!1,watch:!1},x={mount:new Set,unMount:new Set,array:new Set,watch:new Set},k=0;const S={isDirty:!1,dirtyFields:!1,touchedFields:!1,isValidating:!1,isValid:!1,errors:!1},T={values:se(),array:se(),state:se()},E=e.resetOptions&&e.resetOptions.keepDirtyValues,z=U(n.mode),j=U(n.reValidateMode),C=n.criteriaMode===w,F=async e=>{if(S.isValid||e){const e=n.resolver?I((await O()).errors):await q(r,!0);e!==a.isValid&&T.state.next({isValid:e})}},M=e=>S.isValidating&&T.state.next({isValidating:e}),P=(e,t,i,n)=>{const a=v(r,e);if(a){const r=v(c,e,y(i)?v(o,e):i);y(r)||n&&n.defaultChecked||t?R(c,e,t?r:ye(a._f)):Z(e,r),b.mount&&F()}},N=(e,t,i,n,r)=>{let s=!1,l=!1;const d={name:e};if(!i||n){S.isDirty&&(l=a.isDirty,a.isDirty=d.isDirty=Y(),s=l!==d.isDirty);const i=de(v(o,e),t);l=v(a.dirtyFields,e),i?oe(a.dirtyFields,e):R(a.dirtyFields,e,!0),d.dirtyFields=a.dirtyFields,s=s||S.dirtyFields&&l!==!i}if(i){const t=v(a.touchedFields,e);t||(R(a.touchedFields,e,i),d.touchedFields=a.touchedFields,s=s||S.touchedFields&&t!==i)}return s&&r&&T.state.next(d),s?d:{}},O=async e=>n.resolver(c,n.context,((e,t,i,n)=>{const a={};for(const i of e){const e=v(t,i);e&&R(a,i,e._f)}return{criteriaMode:i,names:[...e],fields:a,shouldUseNativeValidation:n}})(e||x.mount,r,n.criteriaMode,n.shouldUseNativeValidation)),q=async(e,t,i={valid:!0})=>{for(const r in e){const o=e[r];if(o){const{_f:e,...r}=o;if(e){const r=x.array.has(e.name),s=await re(o,c,C,n.shouldUseNativeValidation&&!t,r);if(s[e.name]&&(i.valid=!1,t))break;!t&&(v(s,e.name)?r?H(a.errors,s,e.name):R(a.errors,e.name,s[e.name]):oe(a.errors,e.name))}r&&await q(r,t,i)}}return i.valid},Y=(e,t)=>(e&&t&&R(c,e,t),!de(ne(),o)),K=(e,t,i)=>L(e,x,{...b.mount?c:y(t)?o:D(e)?{[e]:t}:t},i,t),Z=(e,t,i={})=>{const n=v(r,e);let a=t;if(n){const i=n._f;i&&(!i.disabled&&R(c,e,ge(t,i)),a=Q(i.ref)&&d(t)?"":t,ce(i.ref)?[...i.ref.options].forEach((e=>e.selected=a.includes(e.value))):i.refs?s(i.ref)?i.refs.length>1?i.refs.forEach((e=>(!e.defaultChecked||!e.disabled)&&(e.checked=Array.isArray(a)?!!a.find((t=>t===e.value)):a===e.value))):i.refs[0]&&(i.refs[0].checked=!!a):i.refs.forEach((e=>e.checked=e.value===a)):G(i.ref)?i.ref.value="":(i.ref.value=a,i.ref.type||T.values.next({name:e,values:{...c}})))}(i.shouldDirty||i.shouldTouch)&&N(e,a,i.shouldTouch,i.shouldDirty,!0),i.shouldValidate&&ie(e)},X=(e,t,i)=>{for(const n in t){const a=t[n],o=`${e}.${n}`,s=v(r,o);!x.array.has(e)&&le(a)&&(!s||s._f)||l(a)?Z(o,a,i):X(o,a,i)}},ee=(e,i,n={})=>{const s=v(r,e),l=x.array.has(e),u=f(i);R(c,e,u),l?(T.array.next({name:e,values:{...c}}),(S.isDirty||S.dirtyFields)&&n.shouldDirty&&T.state.next({name:e,dirtyFields:fe(o,c),isDirty:Y(e,u)})):!s||s._f||d(u)?Z(e,u,n):X(e,u,n),B(e,x)&&T.state.next({...a}),T.values.next({name:e,values:{...c}}),!b.mount&&t()},te=async t=>{const o=t.target;let s=o.name,l=!0;const d=v(r,s);if(d){let p,h;const f=o.type?ye(d._f):m(t),g=t.type===_||"focusout"===t.type,y=!((u=d._f).mount&&(u.required||u.min||u.max||u.maxLength||u.minLength||u.pattern||u.validate)||n.resolver||v(a.errors,s)||d._f.deps)||((e,t,i,n,a)=>!a.isOnAll&&(!i&&a.isOnTouch?!(t||e):(i?n.isOnBlur:a.isOnBlur)?!e:!(i?n.isOnChange:a.isOnChange)||e))(g,v(a.touchedFields,s),a.isSubmitted,j,z),b=B(s,x,g);R(c,s,f),g?(d._f.onBlur&&d._f.onBlur(t),i&&i(0)):d._f.onChange&&d._f.onChange(t);const w=N(s,f,g,!1),E=!I(w)||b;if(!g&&T.values.next({name:s,type:t.type,values:{...c}}),y)return S.isValid&&F(),E&&T.state.next({name:s,...b?{}:w});if(!g&&b&&T.state.next({...a}),M(!0),n.resolver){const{errors:e}=await O([s]),t=_e(a.errors,r,s),i=_e(e,r,t.name||s);p=i.error,s=i.name,h=I(e)}else p=(await re(d,c,C,n.shouldUseNativeValidation))[s],l=isNaN(f)||f===v(c,s,f),l&&(p?h=!1:S.isValid&&(h=await q(r,!0)));l&&(d._f.deps&&ie(d._f.deps),((t,n,r,o)=>{const s=v(a.errors,t),l=S.isValid&&$(n)&&a.isValid!==n;var d;if(e.delayError&&r?(d=()=>((e,t)=>{R(a.errors,e,t),T.state.next({errors:a.errors})})(t,r),i=e=>{clearTimeout(k),k=setTimeout(d,e)},i(e.delayError)):(clearTimeout(k),i=null,r?R(a.errors,t,r):oe(a.errors,t)),(r?!de(s,r):s)||!I(o)||l){const e={...o,...l&&$(n)?{isValid:n}:{},errors:a.errors,name:t};a={...a,...e},T.state.next(e)}M(!1)})(s,h,p,w))}var u},ie=async(e,t={})=>{let i,o;const s=A(e);if(M(!0),n.resolver){const t=await(async e=>{const{errors:t}=await O();if(e)for(const i of e){const e=v(t,i);e?R(a.errors,i,e):oe(a.errors,i)}else a.errors=t;return t})(y(e)?e:s);i=I(t),o=e?!s.some((e=>v(t,e))):i}else e?(o=(await Promise.all(s.map((async e=>{const t=v(r,e);return await q(t&&t._f?{[e]:t}:t)})))).every(Boolean),(o||a.isValid)&&F()):o=i=await q(r);return T.state.next({...!D(e)||S.isValid&&i!==a.isValid?{}:{name:e},...n.resolver||!e?{isValid:i}:{},errors:a.errors,isValidating:!1}),t.shouldFocus&&!o&&V(r,(e=>e&&v(a.errors,e)),e?s:x.mount),o},ne=e=>{const t={...o,...b.mount?c:{}};return y(e)?t:D(e)?v(t,e):e.map((e=>v(t,e)))},ae=(e,t)=>({invalid:!!v((t||a).errors,e),isDirty:!!v((t||a).dirtyFields,e),isTouched:!!v((t||a).touchedFields,e),error:v((t||a).errors,e)}),me=(e,t,i)=>{const n=(v(r,e,{_f:{}})._f||{}).ref;R(a.errors,e,{...t,ref:n}),T.state.next({name:e,errors:a.errors,isValid:!1}),i&&i.shouldFocus&&n&&n.focus&&n.focus()},pe=(e,t={})=>{for(const i of e?A(e):x.mount)x.mount.delete(i),x.array.delete(i),t.keepValue||(oe(r,i),oe(c,i)),!t.keepError&&oe(a.errors,i),!t.keepDirty&&oe(a.dirtyFields,i),!t.keepTouched&&oe(a.touchedFields,i),!n.shouldUnregister&&!t.keepDefaultValue&&oe(o,i);T.values.next({values:{...c}}),T.state.next({...a,...t.keepDirty?{isDirty:Y()}:{}}),!t.keepIsValid&&F()},he=(e,t={})=>{let i=v(r,e);const a=$(t.disabled);return R(r,e,{...i||{},_f:{...i&&i._f?i._f:{ref:{name:e}},name:e,mount:!0,...t}}),x.mount.add(e),i?a&&R(c,e,t.disabled?void 0:v(c,e,ye(i._f))):P(e,!0,t.value),{...a?{disabled:t.disabled}:{},...n.progressive?{required:!!t.required,min:ve(t.min),max:ve(t.max),minLength:ve(t.minLength),maxLength:ve(t.maxLength),pattern:ve(t.pattern)}:{},name:e,onChange:te,onBlur:te,ref:a=>{if(a){he(e,t),i=v(r,e);const n=y(a.value)&&a.querySelectorAll&&a.querySelectorAll("input,select,textarea")[0]||a,l=(e=>J(e)||s(e))(n),d=i._f.refs||[];if(l?d.find((e=>e===n)):n===i._f.ref)return;R(r,e,{_f:{...i._f,...l?{refs:[...d.filter(ue),n,...Array.isArray(v(o,e))?[{}]:[]],ref:{type:n.type,name:e}}:{ref:n}}}),P(e,!1,void 0,n)}else i=v(r,e,{}),i._f&&(i._f.mount=!1),(n.shouldUnregister||t.shouldUnregister)&&(!p(x.array,e)||!b.action)&&x.unMount.add(e)}}},xe=()=>n.shouldFocusError&&V(r,(e=>e&&v(a.errors,e)),x.mount),we=(e,t)=>async i=>{i&&(i.preventDefault&&i.preventDefault(),i.persist&&i.persist());let o=f(c);if(T.state.next({isSubmitting:!0}),n.resolver){const{errors:e,values:t}=await O();a.errors=e,o=t}else await q(r);oe(a.errors,"root"),I(a.errors)?(T.state.next({errors:{}}),await e(o,i)):(t&&await t({...a.errors},i),xe(),setTimeout(xe)),T.state.next({isSubmitted:!0,isSubmitting:!1,isSubmitSuccessful:I(a.errors),submitCount:a.submitCount+1,errors:a.errors})},ke=(i,n={})=>{const s=i||o,l=f(s),d=i&&!I(i)?l:o;if(n.keepDefaultValues||(o=s),!n.keepValues){if(n.keepDirtyValues||E)for(const e of x.mount)v(a.dirtyFields,e)?R(d,e,v(c,e)):ee(e,v(d,e));else{if(h&&y(i))for(const e of x.mount){const t=v(r,e);if(t&&t._f){const e=Array.isArray(t._f.refs)?t._f.refs[0]:t._f.ref;if(Q(e)){const t=e.closest("form");if(t){t.reset();break}}}}r={}}c=e.shouldUnregister?n.keepDefaultValues?f(o):{}:f(d),T.array.next({values:{...d}}),T.values.next({values:{...d}})}x={mount:new Set,unMount:new Set,array:new Set,watch:new Set,watchAll:!1,focus:""},!b.mount&&t(),b.mount=!S.isValid||!!n.keepIsValid,b.watch=!!e.shouldUnregister,T.state.next({submitCount:n.keepSubmitCount?a.submitCount:0,isDirty:n.keepDirty?a.isDirty:!(!n.keepDefaultValues||de(i,o)),isSubmitted:!!n.keepIsSubmitted&&a.isSubmitted,dirtyFields:n.keepDirtyValues?a.dirtyFields:n.keepDefaultValues&&i?fe(o,i):{},touchedFields:n.keepTouched?a.touchedFields:{},errors:n.keepErrors?a.errors:{},isSubmitting:!1,isSubmitSuccessful:!1})},Se=(e,t)=>ke(W(e)?e(c):e,t);return{control:{register:he,unregister:pe,getFieldState:ae,handleSubmit:we,setError:me,_executeSchema:O,_getWatch:K,_getDirty:Y,_updateValid:F,_removeUnmounted:()=>{for(const e of x.unMount){const t=v(r,e);t&&(t._f.refs?t._f.refs.every((e=>!ue(e))):!ue(t._f.ref))&&pe(e)}x.unMount=new Set},_updateFieldArray:(e,t=[],i,n,s=!0,l=!0)=>{if(n&&i){if(b.action=!0,l&&Array.isArray(v(r,e))){const t=i(v(r,e),n.argA,n.argB);s&&R(r,e,t)}if(l&&Array.isArray(v(a.errors,e))){const t=i(v(a.errors,e),n.argA,n.argB);s&&R(a.errors,e,t),((e,t)=>{!g(v(e,t)).length&&oe(e,t)})(a.errors,e)}if(S.touchedFields&&l&&Array.isArray(v(a.touchedFields,e))){const t=i(v(a.touchedFields,e),n.argA,n.argB);s&&R(a.touchedFields,e,t)}S.dirtyFields&&(a.dirtyFields=fe(o,c)),T.state.next({name:e,isDirty:Y(e,t),dirtyFields:a.dirtyFields,errors:a.errors,isValid:a.isValid})}else R(c,e,t)},_getFieldArray:t=>g(v(b.mount?c:o,t,e.shouldUnregister?v(o,t,[]):[])),_reset:ke,_resetDefaultValues:()=>W(n.defaultValues)&&n.defaultValues().then((e=>{Se(e,n.resetOptions),T.state.next({isLoading:!1})})),_updateFormState:e=>{a={...a,...e}},_subjects:T,_proxyFormState:S,get _fields(){return r},get _formValues(){return c},get _state(){return b},set _state(e){b=e},get _defaultValues(){return o},get _names(){return x},set _names(e){x=e},get _formState(){return a},set _formState(e){a=e},get _options(){return n},set _options(e){n={...n,...e}}},trigger:ie,register:he,handleSubmit:we,watch:(e,t)=>W(e)?T.values.subscribe({next:i=>e(K(void 0,t),i)}):K(e,t,!0),setValue:ee,getValues:ne,reset:Se,resetField:(e,t={})=>{v(r,e)&&(y(t.defaultValue)?ee(e,v(o,e)):(ee(e,t.defaultValue),R(o,e,t.defaultValue)),t.keepTouched||oe(a.touchedFields,e),t.keepDirty||(oe(a.dirtyFields,e),a.isDirty=t.defaultValue?Y(e,v(o,e)):Y()),t.keepError||(oe(a.errors,e),S.isValid&&F()),T.state.next({...a}))},clearErrors:e=>{e&&A(e).forEach((e=>oe(a.errors,e))),T.state.next({errors:e?a.errors:{}})},unregister:pe,setError:me,setFocus:(e,t={})=>{const i=v(r,e),n=i&&i._f;if(n){const e=n.refs?n.refs[0]:n.ref;e.focus&&(e.focus(),t.shouldSelect&&e.select())}},getFieldState:ae}}function we(e={}){const t=r.useRef(),[i,n]=r.useState({isDirty:!1,isValidating:!1,isLoading:W(e.defaultValues),isSubmitted:!1,isSubmitting:!1,isSubmitSuccessful:!1,isValid:!1,submitCount:0,dirtyFields:{},touchedFields:{},errors:{},defaultValues:W(e.defaultValues)?void 0:e.defaultValues});t.current||(t.current={...xe(e,(()=>n((e=>({...e}))))),formState:i});const a=t.current.control;return a._options=e,M({subject:a._subjects.state,next:e=>{C(e,a._proxyFormState,a._updateFormState,!0)&&n({...a._formState})}}),r.useEffect((()=>{e.values&&!de(e.values,a._defaultValues)?a._reset(e.values,a._options.resetOptions):a._resetDefaultValues()}),[e.values,a]),r.useEffect((()=>{a._state.mount||(a._updateValid(),a._state.mount=!0),a._state.watch&&(a._state.watch=!1,a._subjects.state.next({...a._formState})),a._removeUnmounted()})),t.current.formState=j(i,a),t.current}var ke=i(30770),Se=i(75879),Te=i(75008),Ee=i(3185),ze=i(96791);const je=({euiFieldProps:e})=>{const{field:{onChange:t,value:i,name:a},fieldState:{error:o}}=O({name:"label",defaultValue:""}),s=(0,r.useMemo)((()=>!(null==o||!o.message)),[null==o?void 0:o.message]);return(0,ze.jsx)(n.EuiFormRow,{label:Te.i18n.translate("xpack.securitySolution.markdown.osquery.labelFieldText",{defaultMessage:"Label"}),error:null==o?void 0:o.message,isInvalid:s,fullWidth:!0},(0,ze.jsx)(n.EuiFieldText,(0,Ee.default)({isInvalid:s,onChange:t,value:i,name:a,fullWidth:!0,"data-test-subj":"input"},e)))},Ie=o().memo(je),Ce=Te.i18n.translate("xpack.securitySolution.markdown.osquery.permissionDenied",{defaultMessage:"Permission denied"}),Ae=()=>(0,ze.jsx)(n.EuiEmptyPrompt,{iconType:"logoOsquery",title:(0,ze.jsx)("h2",null,Ce),titleSize:"xs",body:(0,ze.jsx)("p",null,(0,ze.jsx)(Se.FormattedMessage,{id:"xpack.securitySolution.markdown.osquery.missingPrivileges",defaultMessage:"To access this page, ask your administrator for {osquery} Kibana privileges.",values:{osquery:(0,ze.jsx)(n.EuiCode,null,"osquery")}}))});var Fe=i(12947);const Me=({node:e,onSave:t,onCancel:i})=>{var a,s,l;const d=null!=e,{osquery:c,application:{capabilities:{osquery:u}}}=(0,Fe.o1)().services,m=we({defaultValues:{label:null==e||null===(a=e.configuration)||void 0===a?void 0:a.label,query:null==e||null===(s=e.configuration)||void 0===s?void 0:s.query,ecs_mapping:null==e||null===(l=e.configuration)||void 0===l?void 0:l.ecs_mapping}}),p=(0,r.useCallback)((e=>{t(`!{osquery${JSON.stringify((0,ke.pickBy)({query:e.query,label:e.label,ecs_mapping:e.ecs_mapping},(e=>!(0,ke.isEmpty)(e))))}}`,{block:!0})}),[t]),h=(0,r.useMemo)((()=>!(u.runSavedQueries&&u.readSavedQueries||u.writeLiveQueries)),[u.readSavedQueries,u.runSavedQueries,u.writeLiveQueries]),f=(0,r.useMemo)((()=>{if(null!=c&&c.LiveQueryField){const{LiveQueryField:e}=c;return(0,ze.jsx)(z,m,(0,ze.jsx)(Ie,null),(0,ze.jsx)(n.EuiSpacer,{size:"m"}),(0,ze.jsx)(e,{formMethods:m}))}return null}),[m,c]);return h?(0,ze.jsx)(Ae,null):(0,ze.jsx)(o().Fragment,null,(0,ze.jsx)(n.EuiModalHeader,null,(0,ze.jsx)(n.EuiModalHeaderTitle,null,(0,ze.jsx)("h1",null,d?(0,ze.jsx)(Se.FormattedMessage,{id:"xpack.securitySolution.markdown.osquery.editModalTitle",defaultMessage:"Edit query"}):(0,ze.jsx)(Se.FormattedMessage,{id:"xpack.securitySolution.markdown.osquery.addModalTitle",defaultMessage:"Add query"})))),(0,ze.jsx)(n.EuiModalBody,null,(0,ze.jsx)(o().Fragment,null,f)),(0,ze.jsx)(n.EuiModalFooter,null,(0,ze.jsx)(n.EuiButtonEmpty,{onClick:i},Te.i18n.translate("xpack.securitySolution.markdown.osquery.modalCancelButtonLabel",{defaultMessage:"Cancel"})),(0,ze.jsx)(n.EuiButton,{onClick:m.handleSubmit(p),fill:!0},d?(0,ze.jsx)(Se.FormattedMessage,{id:"xpack.securitySolution.markdown.osquery.addModalConfirmButtonLabel",defaultMessage:"Add query"}):(0,ze.jsx)(Se.FormattedMessage,{id:"xpack.securitySolution.markdown.osquery.editModalConfirmButtonLabel",defaultMessage:"Save changes"}))))},De=o().memo(Me);var Le=i(40166),Pe=i(69042),Ne=i(91463),Re=i(67253),Oe=i(10508),qe={name:"vyocnz",styles:">span>img{margin-block-end:0;}"},Ve=i(51783),Ue=i.n(Ve),Be=i(26752),He=i.n(Be),$e=i(55964),Ge=i(85642),We=i(98445),Qe=i(69473),Ye=i(7195),Je=i(91228),Ke=i(48659),Ze=i(96343),Xe=i(80590),et=i(22804),tt=i(85196),it=i(51023),nt=i(68880);const at=["*"],rt={};var ot=i(19818),st=i(9552);const lt=e=>e===$e.FILTERS.EXISTS?st.A0:e===$e.FILTERS.PHRASES?st.h7:st.gU,dt={$state:{store:$e.FilterStateStore.APP_STATE},meta:{disabled:!1,negate:!1,alias:null,index:void 0}},ct={and:[],enabled:!0,id:"",name:"",excluded:!1,kqlQuery:"",type:ot.xA.default,queryMatch:{field:"",value:"",operator:st.A0}},ut=e=>{const t={...dt,meta:{...dt.meta,negate:e.excluded,type:e.queryType}};if(e.queryType===$e.FILTERS.EXISTS)return{...t,meta:{...t.meta,params:void 0,value:"exists"},query:{exists:{field:e.field}}};if(e.queryType===$e.FILTERS.PHRASES){var i;let n=JSON.parse(String(e.value));return"number"===e.valueType?n=n.map(Number):"boolean"===e.valueType&&(n=n.map(Boolean)),{...t,meta:{...t.meta},query:{bool:{minimum_should_match:1,should:null===(i=n)||void 0===i?void 0:i.map((t=>({match_phrase:{[e.field]:t}})))}}}}var n;if(e.queryType===$e.FILTERS.PHRASE)return{...t,meta:{...t.meta,params:{query:e.value},value:void 0},query:{match_phrase:{[e.field]:null!==(n=e.value)&&void 0!==n?n:""}}};if(e.queryType===$e.FILTERS.RANGE){let i,n;try{const t=JSON.parse(String(e.value));i=t.gte,n=t.lt}catch{i="",n=""}const a={gte:i,lt:n};return{...t,meta:{...t.meta,params:a},query:{range:{[e.field]:a}}}}return t},mt=({providers:e,alertData:t})=>{const i=(0,r.useMemo)((()=>e.some((e=>e.some((e=>"range"===e.queryType))))),[e]);return{dataProviders:(0,r.useMemo)((()=>i?[]:((e,t)=>e.map((e=>e.reduce(((e,i,n)=>{const{field:a,value:r,excluded:o,queryType:s}=i,{result:l,matchedBrackets:d}=((e,t)=>{if("number"==typeof e||"boolean"==typeof e)return{result:e,skipped:!0,matchedBrackets:null};const i=/\{{([^}]+)\}}/g,n=e.match(new RegExp(i));let a=e;n&&t&&(0,ke.each)(n,(e=>{const i=e.replace(/{{|}}/g,"").trim();if(a.includes(e)){const n=t.find((({field:e})=>e===i));if(n&&n.values){const{values:[t]}=n;a=a.replace(e,t)}}}));const r=new RegExp(i).test(a);return{result:a,skipped:r,matchedBrackets:n}})(r,t),c=!t&&d;if(0===n)return{and:[],enabled:!0,id:JSON.stringify(a+r),name:a,excluded:o,kqlQuery:"",type:c?ot.xA.template:ot.xA.default,queryMatch:{field:a,value:l,operator:lt(s)}};{const t={enabled:!0,id:JSON.stringify(a+r),name:a,excluded:o,kqlQuery:"",type:c?ot.xA.template:ot.xA.default,queryMatch:{field:a,value:l,operator:lt(s)}};e.and.push(t)}return e}),ct))))(e,t)),[t,e,i]),filters:(0,r.useMemo)((()=>i?(e=>{const t=[];for(let i=0;i<e.length;i++){const n=e[i];if(n.length>1){const e=n.map((e=>ut(e))),i={$state:{store:$e.FilterStateStore.APP_STATE},meta:{type:$e.FILTERS.COMBINED,relation:$e.BooleanRelation.AND,params:e,index:void 0,disabled:!1,negate:!1}};t.push(i)}else{const e=n[0],i=ut(e);t.push(i)}}return t})(e):[]),[i,e,t])}};var pt=i(71163),ht=i(94522),ft=i(56512);const gt=e=>{var t,i,n,a,r,o;const s=null!==(t=null===(i=e.meta)||void 0===i?void 0:i.key)&&void 0!==t?t:"",l={field:s,excluded:null!==(n=null===(a=e.meta)||void 0===a?void 0:a.negate)&&void 0!==n&&n,queryType:null!==(r=null===(o=e.meta)||void 0===o?void 0:o.type)&&void 0!==r?r:$e.FILTERS.PHRASE};if((0,$e.isRangeFilter)(e)){var d;const{gte:t,lt:i}=e.query.range[s],n=JSON.stringify({gte:t,lt:i});return{...l,value:n,queryType:null!==(d=e.meta.type)&&void 0!==d?d:$e.FILTERS.RANGE}}if((0,$e.isPhrasesFilter)(e)){var c,u,m,p;const t=typeof(null===(c=e.meta)||void 0===c?void 0:c.params[0]);return{...l,value:JSON.stringify(null!==(u=null===(m=e.meta)||void 0===m?void 0:m.params)&&void 0!==u?u:[]),valueType:t,queryType:null!==(p=e.meta.type)&&void 0!==p?p:$e.FILTERS.PHRASES}}var h;if((0,$e.isExistsFilter)(e))return{...l,value:"",queryType:null!==(h=e.meta.type)&&void 0!==h?h:$e.FILTERS.EXISTS};if((0,$e.isPhraseFilter)(e)){var f,g,y,v,_,b;const t=typeof(null===(f=e.meta)||void 0===f||null===(g=f.params)||void 0===g?void 0:g.query);return{...l,value:null!==(y=null===(v=e.meta)||void 0===v||null===(_=v.params)||void 0===_?void 0:_.query)&&void 0!==y?y:"",valueType:t,queryType:null!==(b=e.meta.type)&&void 0!==b?b:$e.FILTERS.PHRASE}}return{...l,value:"",queryType:$e.FILTERS.PHRASE}},yt=e=>e.map((e=>gt(e))),vt=e=>!1===e.some($e.isCombinedFilter)?[yt(e)]:e.reduce(((e,t)=>{if((0,$e.isCombinedFilter)(t)){const i=t.meta.params;if(t.meta.relation===$e.BooleanRelation.OR){const t=i.map((e=>{const t=vt([e]);return(0,ke.flatten)(t)}));return[...e,...t]}{const t=vt(i);return[...e,...t]}}return[...e,[gt(t)]]}),[]);var _t=i(99309),bt=i(76494),xt=i.n(bt),wt=i(79881),kt=i.n(wt),St=i(81259);function Tt(e,t,i){var n;if(void 0===t||"undefined"===i)return!1;switch(e.type){case"date":const i="string"==typeof t?xt().parse(t):null;return Boolean("string"==typeof t&&i&&i.isValid());case"ip":if("string"==typeof t||"number"==typeof t)try{return Boolean(new Ye.IpAddress(t))}catch(e){return!1}return!1;case"string":return"string"==typeof t&&null!==(n=e.esTypes)&&void 0!==n&&n.includes(St._c.VERSION)?Boolean(kt()(t)):"string"==typeof t&&t.trim().length>0;case"boolean":return"boolean"==typeof t;case"number":return"number"==typeof t||"string"==typeof t&&!isNaN(parseFloat(t));default:return!0}}const Et=Te.i18n.translate("xpack.securitySolution.markdown.insight.label",{defaultMessage:"Label"}),zt=Te.i18n.translate("xpack.securitySolution.markdown.insight.title",{defaultMessage:"Investigate"}),jt=Te.i18n.translate("xpack.securitySolution.markdown.insight.labelText",{defaultMessage:"Label on the query button."}),It=Te.i18n.translate("xpack.securitySolution.markdown.insight.description",{defaultMessage:"Description"}),Ct=Te.i18n.translate("xpack.securitySolution.markdown.insight.descriptionText",{defaultMessage:"Additional description of the query."}),At=Te.i18n.translate("xpack.securitySolution.markdown.insight.formDescription",{defaultMessage:"Create a query to investigate an alert in Timeline, using a clickable query button in the investigation guide. The button also displays a count of matching documents."}),Ft=Te.i18n.translate("xpack.securitySolution.markdown.insight.filterBuilder",{defaultMessage:"Filters"}),Mt=Te.i18n.translate("xpack.securitySolution.markdown.insight.filterBuilderText",{defaultMessage:"Create filters to populate the Timeline query builder. To use a value from the alert document, enter the field name in double braces {example} as a custom option in the value field.",values:{example:"{{kibana.alert.example}}"}}),Dt=Te.i18n.translate("xpack.securitySolution.markdown.insight.relativeTimerange",{defaultMessage:"Relative time range"}),Lt=Te.i18n.translate("xpack.securitySolution.markdown.insight.relativeTimerangeText",{defaultMessage:"Select a time range to limit the query, relative to the alert's creation time (optional)."}),Pt=Te.i18n.translate("xpack.securitySolution.markdown.insight.modalCancelButtonLabel",{defaultMessage:"Cancel"}),Nt=Te.i18n.translate("xpack.securitySolution.markdownEditor.plugins.insightProviderError",{defaultMessage:"Unable to parse insight provider configuration"});var Rt=i(59434);const Ot="!{investigate",qt=({label:e,description:t,providers:i,relativeFrom:a,relativeTo:s})=>{const{addError:l}=(0,Qe.De)();let d=[];try{void 0!==i&&(d=JSON.parse(i))}catch(e){l(e,{title:Nt})}const{data:c,timestamp:u}=(0,r.useContext)(Ne.YH),{dataProviders:m,filters:p}=mt({providers:d,alertData:c}),h=(0,r.useMemo)((()=>{if(a&&s){const e=u?Ue()(u):Ue()();return{kind:"absolute",from:(0,ht.f7)(a,ht.q2,!1,Ue(),e.toDate()).toISOString(),to:(0,ht.f7)(s,ht.XC,!0,Ue(),e.toDate()).toISOString()}}return null}),[a,s,u]),{totalCount:f,isQueryLoading:g,oldestTimestamp:y,hasError:v}=(({dataProviders:e,filters:t,relativeTimerange:i})=>{var n;const{uiSettings:a}=(0,Fe.o1)().services,o=(0,r.useMemo)((()=>(0,Ye.getEsQueryConfig)(a)),[a]),{browserFields:s,selectedPatterns:l,sourcererDataView:d,dataViewId:c}=(0,et.H)(tt.EL.timeline),u=(0,We.j)("newDataViewPickerEnabled"),{dataView:m}=(0,Ge.$)(tt.EL.timeline),p=(0,it.M)(tt.EL.timeline),h=(0,nt.d)(tt.EL.timeline),f=u?p:l,g=u?h:s,y=u?null!==(n=m.id)&&void 0!==n?n:"":c,[v,_]=(0,r.useState)(!1),b=(0,r.useMemo)((()=>{try{if(!1===v)return(0,Ze.mT)({config:o,dataProviders:e,dataViewSpec:d,dataView:m,browserFields:g,filters:t,kqlQuery:{query:"",language:"kuery"},kqlMode:"filter"})}catch(e){return _(!0),null}}),[v,o,e,d,m,g,t]),[x,{events:w,totalCount:k}]=(0,Xe.Em)({dataViewId:y,fields:at,filterQuery:null==b?void 0:b.filterQuery,id:Ke.ri.active,indexNames:f,language:"kuery",limit:1,runtimeMappings:rt,startDate:null==i?void 0:i.from,endDate:null==i?void 0:i.to,fetchNotes:!1}),S=(0,r.useMemo)((()=>[Je.YP.loading,Je.YP.loadingMore].includes(x)),[x]),[T]=w,E=T&&T.data&&T.data.find((e=>"@timestamp"===e.field));return{isQueryLoading:S,totalCount:k,oldestTimestamp:E&&E.value&&E.value[0],hasError:v}})({dataProviders:m,filters:p,relativeTimerange:h}),_=(0,r.useMemo)((()=>{if(h)return h;if(null!=y)return{kind:"absolute",from:y,to:(new Date).toISOString()};{const{to:e,from:t,fromStr:i,toStr:n}=(0,ht.id)();return{kind:"relative",to:e,from:t,fromStr:i,toStr:n}}}),[y,h]);return g?(0,ze.jsx)(n.EuiLoadingSpinner,null):(0,ze.jsx)(o().Fragment,null,(0,ze.jsx)(pt.k,{asEmptyButton:!1,isDisabled:v,dataProviders:m,filters:p,timeRange:_,keepDataView:!0,"data-test-subj":"insight-investigate-in-timeline-button"},(0,ze.jsx)(n.EuiIcon,{type:"timeline"}),` ${e} (${He()(f).format("0,0.[000]a")})`),(0,ze.jsx)("div",null,t))};var Vt={name:"1pp61l7",styles:"min-width:700px"};const Ut=({node:e,onSave:t,onCancel:i})=>{const a=null!=e,{sourcererDataView:s}=(0,et.H)(tt.EL.default),l=(0,We.j)("newDataViewPickerEnabled"),{dataView:d}=(0,Ge.$)(tt.EL.default),c=l?d.name:s.name,{unifiedSearch:{ui:{FiltersBuilderLazy:u}},uiSettings:m}=(0,Fe.o1)().services,p=(0,Rt.J)({sourcererScope:tt.EL.default}),h=l?d:p,[f,g]=(0,r.useState)([[]]),y=(0,r.useMemo)((()=>[{value:"0",text:""},...m.get(ft.vuw).map((({display:e},t)=>({value:String(t),text:e})))]),[m]),v=we({defaultValues:{label:null==e?void 0:e.label,description:null==e?void 0:e.description,relativeTimerange:(null==e?void 0:e.relativeTimerange)||"0"},shouldUnregister:!0}),_=O({name:"label",control:v.control}),b=O({name:"description",control:v.control}),x=O({name:"relativeTimerange",control:v.control}),w=(0,r.useCallback)((e=>{const t=y.find((t=>t.value===e));if(t&&"0"!==t.value){const e=Number(t.value),i=m.get(ft.vuw);return{relativeFrom:i[e].from,relativeTo:i[e].to}}return{}}),[y,m]),k=(0,r.useCallback)((()=>{t(`${Ot}${JSON.stringify((0,ke.pickBy)({label:_.field.value,description:b.field.value,providers:f,...w(x.field.value)},(e=>!(0,ke.isEmpty)(e))))}}`,{block:!0})}),[t,f,_.field.value,b.field.value,x.field.value,w]),S=(0,r.useCallback)((e=>{g(vt(e))}),[]),T=(0,r.useCallback)((e=>{x.field.onChange(e.target.value)}),[x.field]),E=(0,r.useMemo)((()=>{var e;const t=null!==(e=_.field.value)&&void 0!==e?e:"",i=f.flat();return""===t.trim()||0===i.length||i.some((e=>!function(e,t){if(!t||!e.field)return!1;switch(e.queryType){case"phrase":return Tt(t,e.value,e.valueType);case"phrases":const i="string"==typeof e.value?JSON.parse(`${e.value}`):null;return!(!Array.isArray(i)||!i.length)&&i.every((i=>Tt(t,i,e.valueType)));case"range":const n=JSON.parse("string"==typeof e.value?e.value:"");return"object"==typeof n&&(!n.gte||Tt(t,n.gte,e.valueType))&&(!n.lt||Tt(t,n.lt,e.valueType));case"exists":return!0;default:throw new Error(`Unknown operator type: ${e.queryType}`)}}(e,null==h?void 0:h.getFieldByName(e.field))))}),[_.field.value,f,h]),j=(0,r.useMemo)((()=>{const e=null!=c?c:"*";return[{$state:{store:$e.FilterStateStore.APP_STATE},meta:{disabled:!1,negate:!1,alias:null,index:e}}]}),[c]),I=(0,_t.R)().isAtLeast("platinum");return(0,ze.jsx)(o().Fragment,null,(0,ze.jsx)(n.EuiModalHeader,{css:Vt},(0,ze.jsx)(n.EuiModalHeaderTitle,null,(0,ze.jsx)(n.EuiFlexGroup,{gutterSize:"s"},(0,ze.jsx)(n.EuiFlexItem,null,a?(0,ze.jsx)(Se.FormattedMessage,{id:"xpack.securitySolution.markdown.insight.editModalTitle",defaultMessage:"Edit investigation query"}):(0,ze.jsx)(Se.FormattedMessage,{id:"xpack.securitySolution.markdown.insight.addModalTitle",defaultMessage:"Add investigation query"}))))),!1===I&&(0,ze.jsx)(n.EuiCallOut,{title:"To add suggested queries to an investigation guide, please upgrade to platinum",iconType:"timeline"}),(0,ze.jsx)(n.EuiModalBody,null,(0,ze.jsx)(z,v,(0,ze.jsx)(n.EuiForm,{fullWidth:!0},(0,ze.jsx)(n.EuiFormRow,{label:At,fullWidth:!0},(0,ze.jsx)(o().Fragment,null)),(0,ze.jsx)(n.EuiFormRow,{label:Et,helpText:jt,isInvalid:void 0!==_.field.value&&0===_.field.value.trim().length,fullWidth:!0},(0,ze.jsx)(n.EuiFieldText,(0,Ee.default)({isInvalid:void 0!==_.field.value&&0===_.field.value.trim().length},v.register("label"),{ref:null,name:"label",onChange:_.field.onChange}))),(0,ze.jsx)(n.EuiFormRow,{label:It,helpText:Ct,fullWidth:!0},(0,ze.jsx)(n.EuiFieldText,(0,Ee.default)({},v.register("description"),{ref:null,name:"description",onChange:b.field.onChange}))),(0,ze.jsx)(n.EuiFormRow,{label:Ft,helpText:Mt,fullWidth:!0},h?(0,ze.jsx)(u,{filters:j,onChange:S,dataView:h,maxDepth:1}):(0,ze.jsx)(o().Fragment,null)),(0,ze.jsx)(n.EuiFormRow,{label:Dt,helpText:Lt,fullWidth:!0},(0,ze.jsx)(n.EuiSelect,(0,Ee.default)({},v.register("relativeTimerange"),{ref:null,onChange:T,options:y})))))),(0,ze.jsx)(n.EuiModalFooter,null,(0,ze.jsx)(n.EuiButtonEmpty,{onClick:i},Pt),(0,ze.jsx)(n.EuiButton,{onClick:v.handleSubmit(k),fill:!0,disabled:E},a?(0,ze.jsx)(Se.FormattedMessage,{id:"xpack.securitySolution.markdown.insight.addModalConfirmButtonLabel",defaultMessage:"Add query"}):(0,ze.jsx)(Se.FormattedMessage,{id:"xpack.securitySolution.markdown.insight.editModalConfirmButtonLabel",defaultMessage:"Save changes"}))))},Bt=o().memo(Ut),Ht=`${Ot}{\n  "label": "Test action",\n  "description": "Click to investigate",\n  "providers": [\n    [\n      {"field": "event.id", "value": "{{kibana.alert.original_event.id}}", "queryType": "phrase", "excluded": "false"}\n    ],\n    [\n      {"field": "event.action", "value": "", "queryType": "exists", "excluded": "false"},\n      {"field": "process.pid", "value": "{{process.pid}}", "queryType": "phrase", "excluded":"false"}\n    ]\n  ]\n}}`,$t=(0,n.getDefaultEuiMarkdownUiPlugins)(),Gt=(0,n.getDefaultEuiMarkdownParsingPlugins)(),Wt=(0,n.getDefaultEuiMarkdownProcessingPlugins)(),Qt=[Ot],Yt=({insightsUpsellingMessage:e,interactionsUpsellingMessage:t,canSeeTimeline:i})=>{const r=$t.map((e=>e.name)),o=(({insightsUpsellingMessage:e})=>({name:"insights",button:{label:null!=e?e:zt,iconType:"timelineWithArrow",isDisabled:!!e},helpText:(0,ze.jsx)("div",null,(0,ze.jsx)(n.EuiCodeBlock,{language:"md",fontSize:"l",paddingSize:"s",isCopyable:!0},Ht),(0,ze.jsx)(n.EuiSpacer,{size:"s"})),editor:Bt}))({insightsUpsellingMessage:e}),s=a.IQ({interactionsUpsellingMessage:t,canSeeTimeline:i}),l=(({interactionsUpsellingMessage:e})=>({name:"osquery",button:{label:null!=e?e:"Osquery",iconType:"logoOsquery",isDisabled:!!e},helpText:(0,ze.jsx)("div",null,(0,ze.jsx)(n.EuiCodeBlock,{language:"md",fontSize:"l",paddingSize:"s",isCopyable:!0},"!{osquery{options}}"),(0,ze.jsx)(n.EuiSpacer,{size:"s"})),editor:De}))({interactionsUpsellingMessage:t});if(!1===r.includes(o.name))$t.push(s),$t.push(l),$t.push(o);else{const e=$t.findIndex((e=>e.name===o.name));$t[e]=o}return $t};Gt.push((function(){const e=this.Parser,t=e.prototype.inlineTokenizers,i=e.prototype.inlineMethods,n=function(e,t,i){if(!1===t.startsWith(Ot))return!1;const n=t[13];if("{"!==n&&"}"!==n)return!1;if(i)return!0;let a={};if("{"===n){let i="",n=0;for(let e=13;e<t.length;e++){const a=t[e];if("{"===a)n++,i+=a;else if("}"===a){if(n--,-1===n)break;i+=a}else i+=a}try{return a=JSON.parse(i),e(t)({type:"insight",...a,providers:JSON.stringify(a.providers)})}catch(t){const i=e.now();this.file.fail((e=>Te.i18n.translate("xpack.securitySolution.markdownEditor.plugins.insightConfigError",{values:{err:e},defaultMessage:"Unable to parse insight JSON configuration: {err}"}))(t),{line:i.line,column:i.column+13})}}return!1};n.locator=(e,t)=>e.indexOf(Ot,t),t.insight=n,i.splice(i.indexOf("text"),0,"insight")})),Gt.push(a.K3),Gt.push(Le.Q),Wt[1][1].components.insight=({label:e,description:t,providers:i,relativeFrom:a,relativeTo:r})=>{const s=(0,Pe.Ot)("investigation_guide");return s?(0,ze.jsx)(o().Fragment,null,(0,ze.jsx)(n.EuiToolTip,{content:s},(0,ze.jsx)(n.EuiButton,{isDisabled:!0,iconSide:"left",iconType:"timeline","data-test-subj":"insight-investigate-in-timeline-button"},`${e}`)),(0,ze.jsx)("div",null,t)):(0,ze.jsx)(qt,{label:e,description:t,providers:i,relativeFrom:a,relativeTo:r})},Wt[1][1].components.timeline=a.Uk,Wt[1][1].components.osquery=({configuration:e})=>{var t;const[i,a]=(0,r.useState)(!1),{agentId:s,alertId:l,data:d}=(0,r.useContext)(Ne.YH),c=(0,r.useCallback)((()=>a(!0)),[a]),u=(0,r.useCallback)((()=>a(!1)),[a]),m=(0,Pe.Ot)("investigation_guide_interactions"),p=(0,r.useMemo)((()=>{const e=(0,ke.reduce)(d,((e,t)=>{var i;return{...e,[t.field]:null==t||null===(i=t.values)||void 0===i?void 0:i[0]}}),{});return(0,Re.u)(e)}),[d]);return(0,ze.jsx)(o().Fragment,null,(0,ze.jsx)(n.EuiToolTip,{content:m},(0,ze.jsx)(n.EuiButton,{iconType:"data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoP