"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValueListsMetrics = void 0;
var _get_lists_overview = require("./queries/get_lists_overview");
var _get_list_items_overview = require("./queries/get_list_items_overview");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getValueListsMetrics = async ({
  esClient,
  logger
}) => {
  try {
    const listsOverview = await (0, _get_lists_overview.getListsOverview)({
      esClient,
      logger
    });
    const itemsOverview = await (0, _get_list_items_overview.getListItemsOverview)({
      esClient,
      logger
    });
    return {
      lists_overview: listsOverview,
      items_overview: itemsOverview
    };
  } catch (error) {
    logger.error(`Error fetching value lists metrics: ${error.message}`);
    return {
      lists_overview: _utils.METRICS_LISTS_DEFAULT_STATE,
      items_overview: _utils.METRICS_ITEMS_DEFAULT_STATE
    };
  }
};
exports.getValueListsMetrics = getValueListsMetrics;