"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.allUsers = void 0;
exports.getUserCriticalityData = getUserCriticalityData;
exports.getUserRiskData = getUserRiskData;
var _fp = require("lodash/fp");
var _lodash = _interopRequireDefault(require("lodash"));
var _constants = require("../../../../../../common/constants");
var _build_query = require("../../../../../utils/build_query");
var _queryAll_users = require("./query.all_users.dsl");
var _queryRisk_score = require("../../risk_score/all/query.risk_score.dsl");
var _search_strategy = require("../../../../../../common/search_strategy");
var _queryAsset_criticality = require("../../asset_criticality/query.asset_criticality.dsl");
var _asset_criticality = require("../../../../../../common/entity_analytics/asset_criticality");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const allUsers = exports.allUsers = {
  buildDsl: options => {
    if (options.pagination && options.pagination.querySize >= _constants.DEFAULT_MAX_TABLE_QUERY_SIZE) {
      throw new Error(`No query size above ${_constants.DEFAULT_MAX_TABLE_QUERY_SIZE}`);
    }
    return (0, _queryAll_users.buildUsersQuery)(options);
  },
  parse: async (options, response, deps) => {
    const {
      activePage,
      cursorStart,
      fakePossibleCount,
      querySize
    } = options.pagination;
    const inspect = {
      dsl: [(0, _build_query.inspectStringifyObject)((0, _queryAll_users.buildUsersQuery)(options))]
    };
    const buckets = (0, _fp.getOr)([], 'aggregations.user_data.buckets', response.rawResponse);
    const totalCount = (0, _fp.getOr)(0, 'aggregations.user_count.value', response.rawResponse);
    const fakeTotalCount = fakePossibleCount <= totalCount ? fakePossibleCount : totalCount;
    const users = buckets.map(bucket => ({
      name: bucket.key,
      lastSeen: (0, _fp.getOr)(null, `lastSeen.value_as_string`, bucket),
      domain: (0, _fp.getOr)(null, `domain.hits.hits[0].fields['user.domain']`, bucket)
    }), {});
    const showMorePagesIndicator = totalCount > fakeTotalCount;
    const edges = users.splice(cursorStart, querySize - cursorStart);
    const userNames = edges.map(({
      name
    }) => name);
    const enhancedEdges = deps !== null && deps !== void 0 && deps.spaceId ? await enhanceEdges(edges, userNames, deps.spaceId, deps.esClient) : edges;
    return {
      ...response,
      inspect,
      totalCount,
      users: enhancedEdges,
      pageInfo: {
        activePage: activePage !== null && activePage !== void 0 ? activePage : 0,
        fakeTotalCount,
        showMorePagesIndicator
      }
    };
  }
};
async function enhanceEdges(edges, userNames, spaceId, esClient) {
  const [riskByUserName, criticalityByUserName] = await Promise.all([getUserRiskData(esClient, spaceId, userNames).then(buildRecordFromAggs('user.name', 'user.risk.calculated_level')), getUserCriticalityData(esClient, userNames).then(buildRecordFromAggs('id_value', 'criticality_level'))]);
  return edges.map(({
    name,
    lastSeen,
    domain
  }) => ({
    name,
    lastSeen,
    domain,
    risk: riskByUserName === null || riskByUserName === void 0 ? void 0 : riskByUserName[name !== null && name !== void 0 ? name : ''],
    criticality: criticalityByUserName === null || criticalityByUserName === void 0 ? void 0 : criticalityByUserName[name !== null && name !== void 0 ? name : '']
  }));
}
async function getUserRiskData(esClient, spaceId, userNames) {
  try {
    const userRiskResponse = await esClient.asCurrentUser.search((0, _queryRisk_score.buildRiskScoreQuery)({
      defaultIndex: [(0, _search_strategy.getRiskIndex)(spaceId, true)],
      filterQuery: (0, _search_strategy.buildUserNamesFilter)(userNames),
      riskScoreEntity: _search_strategy.EntityType.user
    }));
    return userRiskResponse;
  } catch (error) {
    var _error$meta, _error$meta$body, _error$meta$body$erro;
    if ((error === null || error === void 0 ? void 0 : (_error$meta = error.meta) === null || _error$meta === void 0 ? void 0 : (_error$meta$body = _error$meta.body) === null || _error$meta$body === void 0 ? void 0 : (_error$meta$body$erro = _error$meta$body.error) === null || _error$meta$body$erro === void 0 ? void 0 : _error$meta$body$erro.type) !== 'index_not_found_exception') {
      throw error;
    }
    return undefined;
  }
}
async function getUserCriticalityData(esClient, hostNames) {
  try {
    const criticalityResponse = await esClient.asCurrentUser.search((0, _queryAsset_criticality.buildAssetCriticalityQuery)({
      defaultIndex: [(0, _asset_criticality.getAssetCriticalityIndex)('default')],
      // TODO:(@tiansivive) move to constant or import from somewhere else
      filterQuery: {
        terms: {
          id_value: hostNames
        }
      }
    }));
    return criticalityResponse;
  } catch (error) {
    var _error$meta2, _error$meta2$body, _error$meta2$body$err;
    if ((error === null || error === void 0 ? void 0 : (_error$meta2 = error.meta) === null || _error$meta2 === void 0 ? void 0 : (_error$meta2$body = _error$meta2.body) === null || _error$meta2$body === void 0 ? void 0 : (_error$meta2$body$err = _error$meta2$body.error) === null || _error$meta2$body$err === void 0 ? void 0 : _error$meta2$body$err.type) !== 'index_not_found_exception') {
      throw error;
    }
    return undefined;
  }
}
const buildRecordFromAggs = (key, path) => data => data === null || data === void 0 ? void 0 : data.hits.hits.reduce((acc, hit) => ({
  ...acc,
  [_lodash.default.get(hit._source, key) || '']: _lodash.default.get(hit._source, path)
}), {});