"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.actionResults = void 0;
var _build_query = require("../../../../../utils/build_query");
var _queryAction_results = require("./query.action_results.dsl");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionResults = exports.actionResults = {
  buildDsl: options => (0, _queryAction_results.buildActionResultsQuery)(options),
  parse: async (options, response) => {
    var _response$rawResponse, _response$rawResponse2, _response$rawResponse3, _response$rawResponse4, _response$rawResponse5, _response$rawResponse6, _response$rawResponse7, _aggsBuckets$find$doc, _aggsBuckets$find;
    const inspect = {
      dsl: [(0, _build_query.inspectStringifyObject)((0, _queryAction_results.buildActionResultsQuery)(options))]
    };
    const responded = (_response$rawResponse = (_response$rawResponse2 = response.rawResponse) === null || _response$rawResponse2 === void 0 ? void 0 : (_response$rawResponse3 = _response$rawResponse2.aggregations) === null || _response$rawResponse3 === void 0 ? void 0 : (_response$rawResponse4 = _response$rawResponse3.aggs.responses_by_action_id) === null || _response$rawResponse4 === void 0 ? void 0 : _response$rawResponse4.doc_count) !== null && _response$rawResponse !== void 0 ? _response$rawResponse : 0;

    // We should get just one agent id, but just in case we get more than one, we'll use the length
    const agentsWithPendingActions = options.agents - responded;
    const isExpired = !options.expiration ? true : new Date(options.expiration) < new Date();
    const isCompleted = isExpired || agentsWithPendingActions <= 0;
    const aggsBuckets = (_response$rawResponse5 = response.rawResponse) === null || _response$rawResponse5 === void 0 ? void 0 : (_response$rawResponse6 = _response$rawResponse5.aggregations) === null || _response$rawResponse6 === void 0 ? void 0 : (_response$rawResponse7 = _response$rawResponse6.aggs.responses_by_action_id) === null || _response$rawResponse7 === void 0 ? void 0 : _response$rawResponse7.responses.buckets;
    const successful = (_aggsBuckets$find$doc = aggsBuckets === null || aggsBuckets === void 0 ? void 0 : (_aggsBuckets$find = aggsBuckets.find(bucket => bucket.key === 'success')) === null || _aggsBuckets$find === void 0 ? void 0 : _aggsBuckets$find.doc_count) !== null && _aggsBuckets$find$doc !== void 0 ? _aggsBuckets$find$doc : 0;
    const wasSuccessful = responded === successful;

    // TODO use getActionsStatus() - this requires a refactor of the function to accept isExpired
    const status = isExpired ? 'failed' : isCompleted ? wasSuccessful ? 'successful' : 'failed' : 'pending';
    return {
      ...response,
      edges: response.rawResponse.hits.hits,
      isCompleted,
      wasSuccessful: responded === successful,
      isExpired,
      inspect,
      status
    };
  }
};