"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerTimelineRoutes = registerTimelineRoutes;
var _timelines = require("./timelines");
var _get_draft_timelines = require("./draft_timelines/get_draft_timelines");
var _clean_draft_timelines = require("./draft_timelines/clean_draft_timelines");
var _install_prepackaged_timelines = require("./prepackaged_timelines/install_prepackaged_timelines");
var _notes = require("./notes");
var _pinned_events = require("./pinned_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerTimelineRoutes(router, config, startServices) {
  (0, _timelines.createTimelinesRoute)(router);
  (0, _timelines.patchTimelinesRoute)(router);
  (0, _timelines.importTimelinesRoute)(router, config);
  (0, _timelines.exportTimelinesRoute)(router, config);
  (0, _get_draft_timelines.getDraftTimelinesRoute)(router);
  (0, _timelines.getTimelineRoute)(router);
  (0, _timelines.resolveTimelineRoute)(router);
  (0, _timelines.getTimelinesRoute)(router);
  (0, _clean_draft_timelines.cleanDraftTimelinesRoute)(router);
  (0, _timelines.deleteTimelinesRoute)(router);
  (0, _timelines.persistFavoriteRoute)(router);
  (0, _timelines.copyTimelineRoute)(router);
  (0, _install_prepackaged_timelines.installPrepackedTimelinesRoute)(router, config);
  (0, _notes.persistNoteRoute)(router);
  (0, _notes.deleteNoteRoute)(router);
  (0, _notes.getNotesRoute)(router, startServices);
  (0, _pinned_events.persistPinnedEventRoute)(router);
}