"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewTelemetryEventsSender = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _axios = _interopRequireWildcard(require("axios"));
var _types = require("./types");
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Preview telemetry events sender for the telemetry route.
 * @see telemetry_detection_rules_preview_route
 */
class PreviewTelemetryEventsSender {
  constructor(logger, composite) {
    /** Inner composite telemetry events sender */
    (0, _defineProperty2.default)(this, "composite", void 0);
    /**
     * Axios local instance
     * @deprecated `IAsyncTelemetryEventsSender` has a dedicated method for preview. */
    (0, _defineProperty2.default)(this, "axiosInstance", _axios.default.create());
    /** Last sent message */
    (0, _defineProperty2.default)(this, "sentMessages", []);
    /** Last sent EBT events */
    (0, _defineProperty2.default)(this, "ebtEventsSent", []);
    /** Logger for this class  */
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = logger;
    this.composite = composite;

    /**
     * Intercept the last message and save it for the preview within the lastSentMessage
     * Reject the request intentionally to stop from sending to the server
     */
    this.axiosInstance.interceptors.request.use(config => {
      (0, _helpers.tlog)(this.logger, `Intercepting telemetry', ${JSON.stringify(config.data)} and not sending data to the telemetry server`);
      const data = config.data != null ? [config.data] : [];
      this.sentMessages = [...this.sentMessages, ...data];
      return Promise.reject(new Error('Not sending to telemetry server'));
    });

    /**
     * Create a fake response for the preview on return within the error section.
     * @param error The error we don't do anything with
     * @returns The response resolved to stop the chain from continuing.
     */
    this.axiosInstance.interceptors.response.use(response => response, error => {
      // create a fake response for the preview as if the server had sent it back to us
      const okResponse = {
        data: {},
        status: 200,
        statusText: 'ok',
        headers: {},
        config: {
          headers: new _axios.AxiosHeaders()
        }
      };
      return Promise.resolve(okResponse);
    });
  }
  getSentMessages() {
    return this.sentMessages;
  }
  getEbtEventsSent() {
    return this.ebtEventsSent;
  }
  setup(telemetryReceiver, telemetrySetup, taskManager, telemetryUsageCounter) {
    return this.composite.setup(telemetryReceiver, telemetrySetup, taskManager, telemetryUsageCounter);
  }
  getClusterID() {
    return this.composite.getClusterID();
  }
  start(telemetryStart, taskManager, receiver) {
    return this.composite.start(telemetryStart, taskManager, receiver);
  }
  stop() {
    return this.composite.stop();
  }
  async queueTelemetryEvents(events) {
    const result = this.composite.simulateSendAsync(_types.TelemetryChannel.ENDPOINT_ALERTS, events);
    this.sentMessages = [...this.sentMessages, ...result];
  }
  getTelemetryUsageCluster() {
    return this.composite.getTelemetryUsageCluster();
  }
  isTelemetryOptedIn() {
    return this.composite.isTelemetryOptedIn();
  }
  isTelemetryServicesReachable() {
    return this.composite.isTelemetryServicesReachable();
  }
  sendIfDue(axiosInstance) {
    return this.composite.sendIfDue(axiosInstance);
  }
  processEvents(events) {
    return this.composite.processEvents(events);
  }
  async sendOnDemand(channel, toSend) {
    const ch = Object.values(_types.TelemetryChannel).find(c => c === channel);
    if (ch === undefined) {
      throw new Error(`Channel ${channel} not found`);
    }
    const result = this.composite.simulateSendAsync(ch, toSend);
    this.sentMessages = [...this.sentMessages, ...result];
    return Promise.resolve();
  }
  getV3UrlFromV2(v2url, channel) {
    return this.composite.getV3UrlFromV2(v2url, channel);
  }
  sendAsync(channel, events) {
    const result = this.composite.simulateSendAsync(channel, events);
    this.sentMessages = [...this.sentMessages, ...result];
  }
  simulateSendAsync(channel, events) {
    const result = this.composite.simulateSendAsync(channel, events);
    this.sentMessages = [...this.sentMessages, ...result];
    return result;
  }
  updateQueueConfig(channel, config) {
    this.composite.updateQueueConfig(channel, config);
  }
  updateDefaultQueueConfig(config) {
    this.composite.updateDefaultQueueConfig(config);
  }
  reportEBT(eventTypeOpts, eventData) {
    this.ebtEventsSent.push({
      eventType: eventTypeOpts.eventType,
      eventData: eventData
    });
    this.composite.reportEBT(eventTypeOpts, eventData);
  }
}
exports.PreviewTelemetryEventsSender = PreviewTelemetryEventsSender;