"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findTagsByName = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findTagsByName = async ({
  savedObjectsClient,
  tagName
}) => {
  const tagResponse = await savedObjectsClient.find({
    type: 'tag',
    search: `"${tagName}"`,
    searchFields: ['name'],
    sortField: 'updated_at',
    sortOrder: 'desc'
  });
  return tagResponse.saved_objects.filter(({
    attributes: {
      name
    }
  }) => name === tagName);
};
exports.findTagsByName = findTagsByName;