"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTagRoute = void 0;
var _i18n = require("@kbn/i18n");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _tags = require("../../../../common/api/tags");
var _constants = require("../../../../common/constants");
var _route_validation = require("../../../utils/build_validation/route_validation");
var _utils = require("../../detection_engine/routes/utils");
var _common = require("../../timeline/utils/common");
var _saved_objects = require("../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createTagRoute = (router, logger) => {
  router.versioned.put({
    path: _constants.INTERNAL_TAGS_URL,
    access: 'internal',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution']
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _route_validation.buildRouteValidationWithExcess)(_tags.createTagRequest)
      }
    }
  }, async (context, request, response) => {
    const frameworkRequest = await (0, _common.buildFrameworkRequest)(context, request);
    const savedObjectsClient = (await frameworkRequest.context.core).savedObjects.client;
    const {
      name: tagName,
      description,
      color
    } = request.body;
    try {
      const tag = await (0, _saved_objects.createTag)({
        savedObjectsClient,
        tagName,
        description,
        color
      });
      return response.ok({
        body: tag
      });
    } catch (err) {
      var _error$statusCode;
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      logger.error(`Failed to create ${tagName} tag - ${JSON.stringify(error.message)}`);
      const siemResponse = (0, _utils.buildSiemResponse)(response);
      return siemResponse.error({
        statusCode: (_error$statusCode = error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: _i18n.i18n.translate('xpack.securitySolution.dashboards.createSecuritySolutionTagErrorTitle', {
          values: {
            tagName,
            message: error.message
          },
          defaultMessage: `Failed to create {tagName} tag - {message}`
        })
      });
    }
  });
};
exports.createTagRoute = createTagRoute;