"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTranslationResultNode = void 0;
var _constants = require("../../../../../../../common/constants");
var _constants2 = require("../../../../../../constants");
var _constants3 = require("../../../../../../../../../../common/siem_migrations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTranslationResultNode = () => {
  return async state => {
    // Set defaults
    const elasticRule = {
      title: state.original_rule.title,
      description: state.original_rule.description || state.original_rule.title,
      severity: _constants2.DEFAULT_TRANSLATION_SEVERITY,
      risk_score: _constants2.DEFAULT_TRANSLATION_RISK_SCORE,
      ...state.elastic_rule
    };
    const query = elasticRule.query;
    let translationResult;
    if (!query) {
      translationResult = _constants3.MigrationTranslationResult.UNTRANSLATABLE;
    } else {
      var _state$validation_err;
      if (query.startsWith('FROM logs-*')) {
        elasticRule.query = query.replace('FROM logs-*', `FROM ${_constants.MISSING_INDEX_PATTERN_PLACEHOLDER}`);
        translationResult = _constants3.MigrationTranslationResult.PARTIAL;
      } else if ((_state$validation_err = state.validation_errors) !== null && _state$validation_err !== void 0 && _state$validation_err.esql_errors) {
        translationResult = _constants3.MigrationTranslationResult.PARTIAL;
      } else if (query.match(/\[(macro|lookup):.*?\]/)) {
        translationResult = _constants3.MigrationTranslationResult.PARTIAL;
      } else {
        translationResult = _constants3.MigrationTranslationResult.FULL;
      }
    }
    return {
      elastic_rule: elasticRule,
      translation_result: translationResult
    };
  };
};
exports.getTranslationResultNode = getTranslationResultNode;