"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSortingOptions = void 0;
var _sort = require("../../common/data/sort");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sortMissingValue = (direction = 'asc') => direction === 'desc' ? '_last' : '_first';
const sortingOptions = {
  ..._sort.commonSortingOptions,
  installedRuleId(direction = 'asc') {
    return (0, _sort.getFieldExistenceSort)('elastic_rule.id')(direction);
  },
  matchedPrebuiltRule(direction = 'asc') {
    return [{
      'elastic_rule.prebuilt_rule_id': {
        order: direction,
        missing: sortMissingValue(direction)
      }
    }];
  },
  severity(direction = 'asc') {
    const field = 'elastic_rule.severity';
    return [{
      _script: {
        order: direction,
        type: 'number',
        script: {
          source: `
          if (doc.containsKey('${field}') && !doc['${field}'].empty) {
            def value = doc['${field}'].value.toLowerCase();
            if (value == 'critical') { return 3 }
            if (value == 'high') { return 2 }
            if (value == 'medium') { return 1 }
            if (value == 'low') { return 0 }
          }
          return -1;
          `,
          lang: 'painless'
        }
      }
    }];
  },
  riskScore(direction = 'asc') {
    return [{
      'elastic_rule.risk_score': direction
    }];
  },
  updated(direction = 'asc') {
    return [{
      updated_at: direction
    }];
  },
  name(direction = 'asc') {
    return [{
      'elastic_rule.title.keyword': direction
    }];
  }
};
const DEFAULT_SORTING = [...sortingOptions.translationResult('desc'), ...sortingOptions.installedRuleId('desc'), ...sortingOptions.matchedPrebuiltRule('desc'), ...sortingOptions.severity(), ...sortingOptions.riskScore('desc'), ...sortingOptions.updated()];
const sortingOptionsMap = {
  'elastic_rule.title': sortingOptions.name,
  'elastic_rule.severity': direction => [...sortingOptions.severity(direction), ...sortingOptions.riskScore(direction), ...sortingOptions.translationResult('desc'), ...sortingOptions.installedRuleId('desc'), ...sortingOptions.matchedPrebuiltRule('desc')],
  'elastic_rule.risk_score': direction => [...sortingOptions.riskScore(direction), ...sortingOptions.severity(direction), ...sortingOptions.translationResult('desc'), ...sortingOptions.matchedPrebuiltRule('desc')],
  'elastic_rule.prebuilt_rule_id': direction => [...sortingOptions.matchedPrebuiltRule(direction), ...sortingOptions.translationResult('desc'), ...sortingOptions.severity('desc'), ...sortingOptions.riskScore(direction)],
  translation_result: direction => [...sortingOptions.translationResult(direction), ...sortingOptions.matchedPrebuiltRule('desc'), ...sortingOptions.severity('desc'), ...sortingOptions.riskScore(direction)],
  updated_at: sortingOptions.updated
};
const getSortingOptions = sort => {
  var _sortingOptionsMap$so, _sortingOptionsMap$so2;
  if (!(sort !== null && sort !== void 0 && sort.sortField)) {
    return DEFAULT_SORTING;
  }
  return (_sortingOptionsMap$so = (_sortingOptionsMap$so2 = sortingOptionsMap[sort.sortField]) === null || _sortingOptionsMap$so2 === void 0 ? void 0 : _sortingOptionsMap$so2.call(sortingOptionsMap, sort.sortDirection)) !== null && _sortingOptionsMap$so !== void 0 ? _sortingOptionsMap$so : DEFAULT_SORTING;
};
exports.getSortingOptions = getSortingOptions;