"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemRuleMigrationsUpdateRulesRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _constants = require("../../../../../../common/siem_migrations/constants");
var _rule_migration = require("../../../../../../common/siem_migrations/model/api/rules/rule_migration.gen");
var _authz = require("../../../common/api/util/authz");
var _audit = require("../../../common/api/util/audit");
var _update_rules = require("../util/update_rules");
var _with_license = require("../../../common/api/util/with_license");
var _with_existing_migration_id = require("../../../common/api/util/with_existing_migration_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerSiemRuleMigrationsUpdateRulesRoute = (router, logger) => {
  router.versioned.patch({
    path: _constants.SIEM_RULE_MIGRATION_RULES_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_migration.UpdateRuleMigrationRulesRequestParams),
        body: (0, _zodHelpers.buildRouteValidationWithZod)(_rule_migration.UpdateRuleMigrationRulesRequestBody)
      }
    }
  }, (0, _with_license.withLicense)((0, _with_existing_migration_id.withExistingMigration)(async (context, req, res) => {
    const {
      migration_id: migrationId
    } = req.params;
    const rulesToUpdate = req.body;
    if (rulesToUpdate.length === 0) {
      return res.noContent();
    }
    const ids = rulesToUpdate.map(rule => rule.id);
    const siemMigrationAuditLogger = new _audit.SiemMigrationAuditLogger(context.securitySolution, 'rules');
    try {
      const ctx = await context.resolve(['securitySolution']);
      const ruleMigrationsClient = ctx.securitySolution.siemMigrations.getRulesClient();
      await siemMigrationAuditLogger.logUpdateRules({
        migrationId,
        ids
      });
      const transformedRuleToUpdate = rulesToUpdate.map(_update_rules.transformToInternalUpdateRuleMigrationData);
      await ruleMigrationsClient.data.items.update(transformedRuleToUpdate);
      return res.ok({
        body: {
          updated: true
        }
      });
    } catch (error) {
      logger.error(error);
      await siemMigrationAuditLogger.logUpdateRules({
        migrationId,
        ids,
        error
      });
      return res.badRequest({
        body: error.message
      });
    }
  })));
};
exports.registerSiemRuleMigrationsUpdateRulesRoute = registerSiemRuleMigrationsUpdateRulesRoute;