"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardMigrationTelemetryClient = void 0;
var _siem_migrations = require("../../../telemetry/event_based/events/siem_migrations");
var _siem_migrations_telemetry_client = require("../../common/task/siem_migrations_telemetry_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DashboardMigrationTelemetryClient extends _siem_migrations_telemetry_client.SiemMigrationTelemetryClient {
  startSiemMigrationTask() {
    const startTime = Date.now();
    const stats = {
      completed: 0,
      failed: 0
    };
    return {
      startItemTranslation: () => {
        const dashboardStartTime = Date.now();
        return {
          success: migrationResult => {
            stats.completed++;
            this.reportEvent(_siem_migrations.SIEM_MIGRATIONS_DASHBOARD_TRANSLATION_SUCCESS, {
              migrationId: this.migrationId,
              translationResult: migrationResult.translation_result || '',
              duration: Date.now() - dashboardStartTime,
              model: this.modelName,
              eventName: _siem_migrations.siemMigrationEventNames[_siem_migrations.SiemMigrationsEventTypes.DashboardTranslationSuccess]
            });
          },
          failure: error => {
            stats.failed++;
            this.reportEvent(_siem_migrations.SIEM_MIGRATIONS_DASHBOARD_TRANSLATION_FAILURE, {
              migrationId: this.migrationId,
              error: error.message,
              model: this.modelName,
              eventName: _siem_migrations.siemMigrationEventNames[_siem_migrations.SiemMigrationsEventTypes.DashboardTranslationFailure]
            });
          }
        };
      },
      success: () => {
        const duration = Date.now() - startTime;
        this.reportEvent(_siem_migrations.SIEM_MIGRATIONS_MIGRATION_SUCCESS, {
          migrationId: this.migrationId,
          type: 'dashboards',
          model: this.modelName || '',
          completed: stats.completed,
          failed: stats.failed,
          total: stats.completed + stats.failed,
          duration,
          eventName: _siem_migrations.siemMigrationEventNames[_siem_migrations.SiemMigrationsEventTypes.MigrationSuccess]
        });
      },
      failure: error => {
        const duration = Date.now() - startTime;
        this.reportEvent(_siem_migrations.SIEM_MIGRATIONS_MIGRATION_FAILURE, {
          migrationId: this.migrationId,
          type: 'dashboards',
          model: this.modelName || '',
          completed: stats.completed,
          failed: stats.failed,
          total: stats.completed + stats.failed,
          duration,
          error: error.message,
          eventName: _siem_migrations.siemMigrationEventNames[_siem_migrations.SiemMigrationsEventTypes.MigrationFailure]
        });
      },
      aborted: error => {
        const duration = Date.now() - startTime;
        this.reportEvent(_siem_migrations.SIEM_MIGRATIONS_MIGRATION_ABORTED, {
          migrationId: this.migrationId,
          type: 'dashboards',
          model: this.modelName || '',
          completed: stats.completed,
          failed: stats.failed,
          total: stats.completed + stats.failed,
          duration,
          reason: error.message,
          eventName: _siem_migrations.siemMigrationEventNames[_siem_migrations.SiemMigrationsEventTypes.MigrationAborted]
        });
      }
    };
  }
}
exports.DashboardMigrationTelemetryClient = DashboardMigrationTelemetryClient;