"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTranslationResultNode = void 0;
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _comments = require("../../../../../../../common/task/util/comments");
var _constants = require("../../../../../../../common/constants");
var _constants2 = require("../../../../../../../../../../common/siem_migrations/constants");
var _process_panel = require("./process_panel");
var _create_markdown_panel = require("../../../../helpers/markdown_panel/create_markdown_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTranslationResultNode = params => {
  return async state => {
    var _state$validation_err, _state$parsed_panel, _state$esql_query_col;
    const query = state.esql_query;
    if (!query) {
      const message = 'SPL query unsupported or missing, cannot translate panel';
      const panelJSON = (0, _create_markdown_panel.createMarkdownPanel)(message, state.parsed_panel);
      return {
        elastic_panel: panelJSON,
        translation_result: _constants2.MigrationTranslationResult.UNTRANSLATABLE
      };
    }
    let translationResult;
    if (query.startsWith(`FROM ${_constants.MISSING_INDEX_PATTERN_PLACEHOLDER}`)) {
      translationResult = _constants2.MigrationTranslationResult.PARTIAL;
    } else if ((_state$validation_err = state.validation_errors) !== null && _state$validation_err !== void 0 && _state$validation_err.esql_errors) {
      translationResult = _constants2.MigrationTranslationResult.PARTIAL;
    } else if (query.match(/\[(macro|lookup):.*?\]/)) {
      translationResult = _constants2.MigrationTranslationResult.PARTIAL;
    } else {
      translationResult = _constants2.MigrationTranslationResult.FULL;
    }
    const vizType = (_state$parsed_panel = state.parsed_panel) === null || _state$parsed_panel === void 0 ? void 0 : _state$parsed_panel.viz_type;
    let panel;
    try {
      if (!vizType) {
        throw new Error('Panel visualization type could not be extracted');
      }
      panel = readVisualizationTemplate(vizType);
    } catch (error) {
      params.logger.error(`Error retrieving visualization template: ${error}`);
      return {
        translation_result: _constants2.MigrationTranslationResult.UNTRANSLATABLE,
        comments: [(0, _comments.generateAssistantComment)(`Error retrieving visualization template: ${error}`)]
      };
    }
    const panelJSON = (0, _process_panel.processPanel)(panel, query, (_state$esql_query_col = state.esql_query_columns) !== null && _state$esql_query_col !== void 0 ? _state$esql_query_col : [], state.parsed_panel);
    return {
      elastic_panel: panelJSON,
      translation_result: translationResult
    };
  };
};
exports.getTranslationResultNode = getTranslationResultNode;
function readVisualizationTemplate(vizType) {
  const templatePath = _path.default.join(__dirname, `./templates/${vizType}.viz.json`);
  const template = _fs.default.readFileSync(templatePath, 'utf-8');
  if (!template) {
    throw new Error(`Template not found for visualization type "${vizType}"`);
  }
  return JSON.parse(template);
}