"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSelectIndexPatternNode = void 0;
var _constants = require("../../../../../../../common/constants");
var _select_index_pattern = require("../../../../../../../../../assistant/tools/esql/graphs/select_index_pattern/select_index_pattern");
var _prompts = require("./prompts");
var _constants2 = require("../../../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSelectIndexPatternNode = params => {
  const selectIndexPatternGraphPromise = (0, _select_index_pattern.getSelectIndexPatternGraph)({
    // Using the `asInternalUser` so we can access all indices to find the best index pattern
    // we can change it to `asCurrentUser`, but we would be restricted to the indices the user (who started the migration task) has access to.
    esClient: params.esScopedClient.asInternalUser,
    createLlmInstance: async () => params.model
  });
  return async (state, config) => {
    if (!state.esql_query) {
      return {
        index_pattern: _constants.MISSING_INDEX_PATTERN_PLACEHOLDER
      };
    }
    const description = `Dashboard description: "${state.dashboard_description}"
Specific Panel description: "${state.description}"`;
    const question = await _prompts.SELECT_INDEX_PATTERN_PROMPT.format({
      query: state.esql_query,
      title: state.parsed_panel.title,
      description
    });
    const selectIndexPatternGraph = await selectIndexPatternGraphPromise; // This will only be awaited the first time the node is executed
    const {
      selectedIndexPattern
    } = await selectIndexPatternGraph.invoke({
      input: {
        question
      }
    }, config);
    const indexPattern = selectedIndexPattern !== null && selectedIndexPattern !== void 0 ? selectedIndexPattern : _constants.MISSING_INDEX_PATTERN_PLACEHOLDER;
    const esqlQuery = state.esql_query.replace(`FROM ${_constants2.TRANSLATION_INDEX_PATTERN}`,
    // Will always be at the beginning of the query
    `FROM ${indexPattern}`);
    return {
      index_pattern: indexPattern,
      esql_query: esqlQuery
    };
  };
};
exports.getSelectIndexPatternNode = getSelectIndexPatternNode;