"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExtractColumnsFromEsqlQueryNode = void 0;
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getExtractColumnsFromEsqlQueryNode = ({
  model,
  esqlKnowledgeBase,
  logger
}) => {
  return async state => {
    const query = state.esql_query;
    if (!query) {
      return {
        esql_query_columns: undefined
      };
    }
    const prompt = await _prompts.EXTRACT_COLUMNS_ESQL_QUERY_TEMPLATE.format({
      esql_query: query
    });
    const response = await esqlKnowledgeBase.translate(prompt);
    const columns = [];
    try {
      var _response$match;
      const outputJsonStr = (_response$match = response.match(/```json\n([\s\S]*?)\n```/)) === null || _response$match === void 0 ? void 0 : _response$match[1];
      if (!outputJsonStr) {
        throw new Error('No ESQL Columns JSON found in the response');
      }
      const outputJson = JSON.parse(outputJsonStr);
      columns.push(...outputJson.columns);
    } catch (e) {
      const message = `Failed to parse JSON when extracting columns from ES|QL query. Trying again: ${e}`;
      logger.error(message);
    }
    return {
      esql_query_columns: columns
    };
  };
};
exports.getExtractColumnsFromEsqlQueryNode = getExtractColumnsFromEsqlQueryNode;