"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerSiemDashboardMigrationsEvaluateRoute = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
var _uuid = require("uuid");
var _zod = require("@kbn/zod");
var _dashboard_migration = require("../../../../../../common/siem_migrations/model/dashboard_migration.gen");
var _common = require("../../../../../../common/siem_migrations/model/common.gen");
var _constants = require("../../../../../../common/siem_migrations/dashboards/constants");
var _authz = require("../../../common/api/util/authz");
var _with_license = require("../../../common/api/util/with_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REQUEST_TIMEOUT = 10 * 60 * 1000; // 10 minutes

const requestBodyValidation = (0, _zodHelpers.buildRouteValidationWithZod)(_zod.z.object({
  settings: _dashboard_migration.DashboardMigrationTaskExecutionSettings,
  langsmith_options: _common.LangSmithEvaluationOptions
}));
const registerSiemDashboardMigrationsEvaluateRoute = (router, logger) => {
  router.versioned.post({
    path: _constants.SIEM_DASHBOARD_MIGRATION_EVALUATE_PATH,
    access: 'internal',
    security: {
      authz: _authz.authz
    },
    options: {
      timeout: {
        idleSocket: REQUEST_TIMEOUT
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: requestBodyValidation
      }
    }
  }, (0, _with_license.withLicense)(async (context, req, res) => {
    const {
      settings: {
        connector_id: connectorId
      },
      langsmith_options: langsmithOptions
    } = req.body;
    try {
      const evaluationId = (0, _uuid.v4)();
      const abortController = new AbortController();
      req.events.aborted$.subscribe(() => abortController.abort());
      const securitySolutionContext = await context.securitySolution;
      const dashboardMigrationsClient = securitySolutionContext.siemMigrations.getDashboardsClient();
      await dashboardMigrationsClient.task.evaluate({
        evaluationId,
        connectorId,
        langsmithOptions,
        abortController
      });
      return res.ok({
        body: {
          evaluationId
        }
      });
    } catch (err) {
      var _err$statusCode;
      logger.error(err);
      return res.customError({
        body: err.message,
        statusCode: (_err$statusCode = err.statusCode) !== null && _err$statusCode !== void 0 ? _err$statusCode : 500
      });
    }
  }));
};
exports.registerSiemDashboardMigrationsEvaluateRoute = registerSiemDashboardMigrationsEvaluateRoute;