"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFieldExistenceSort = exports.commonSortingOptions = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const commonSortingOptions = exports.commonSortingOptions = {
  translationResult(direction = 'asc') {
    const field = 'translation_result';
    return [{
      _script: {
        order: direction,
        type: 'number',
        script: {
          source: `
          if (doc.containsKey('${field}') && !doc['${field}'].empty) {
            def value = doc['${field}'].value.toLowerCase();
            if (value == 'full') { return 2 }
            if (value == 'partial') { return 1 }
            if (value == 'untranslatable') { return 0 }
          }
          return -1;
          `,
          lang: 'painless'
        }
      }
    }];
  },
  updated(direction = 'asc') {
    return [{
      updated_at: direction
    }];
  }
};

/**
 * Sort Direction `asc` - Missing values come last
 * Sort Direction `desc` - Missing values come first
 *
 * values that exist can be distinct but are treated as same.
 *
 * */
const getFieldExistenceSort = field => {
  return (direction = 'asc') => [{
    _script: {
      order: direction,
      type: 'number',
      script: {
        source: `
          if (doc.containsKey('${field}') && !doc['${field}'].empty) {
            return 0;
          }
          return 1;
          `,
        lang: 'painless'
      }
    }
  }];
};
exports.getFieldExistenceSort = getFieldExistenceSort;