"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dsl = void 0;
var _constants = require("../../../../../common/siem_migrations/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dsl = exports.dsl = {
  isFullyTranslated() {
    return {
      term: {
        translation_result: _constants.MigrationTranslationResult.FULL
      }
    };
  },
  isNotFullyTranslated() {
    return {
      bool: {
        must_not: dsl.isFullyTranslated()
      }
    };
  },
  isPartiallyTranslated() {
    return {
      term: {
        translation_result: _constants.MigrationTranslationResult.PARTIAL
      }
    };
  },
  isNotPartiallyTranslated() {
    return {
      bool: {
        must_not: dsl.isPartiallyTranslated()
      }
    };
  },
  isFullOrPartiallyTranslated() {
    return {
      terms: {
        translation_result: [_constants.MigrationTranslationResult.FULL, _constants.MigrationTranslationResult.PARTIAL]
      }
    };
  },
  isNotFullOrPartiallyTranslated() {
    return {
      bool: {
        must_not: dsl.isFullOrPartiallyTranslated()
      }
    };
  },
  isUntranslatable() {
    return {
      term: {
        translation_result: _constants.MigrationTranslationResult.UNTRANSLATABLE
      }
    };
  },
  isNotUntranslatable() {
    return {
      bool: {
        must_not: dsl.isUntranslatable()
      }
    };
  },
  isFailed() {
    return {
      term: {
        status: _constants.SiemMigrationStatus.FAILED
      }
    };
  },
  isNotFailed() {
    return {
      bool: {
        must_not: dsl.isFailed()
      }
    };
  }
};