"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRiskInputsIndex = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRiskInputsIndex = async ({
  dataViewId,
  logger,
  soClient
}) => {
  try {
    const dataView = await soClient.get('index-pattern', dataViewId);
    const index = dataView.attributes.title;
    const runtimeMappings = dataView.attributes.runtimeFieldMap != null ? JSON.parse(dataView.attributes.runtimeFieldMap) : {};
    return {
      index,
      runtimeMappings
    };
  } catch (e) {
    logger.info(`No dataview found for ID '${dataViewId}'; using ID instead as simple index pattern`);
    return {
      index: dataViewId,
      runtimeMappings: {}
    };
  }
};
exports.getRiskInputsIndex = getRiskInputsIndex;