"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPrivilegedUsersCsvService = void 0;
var _papaparse = _interopRequireDefault(require("papaparse"));
var _stream = require("stream");
var _privileged_user_parse_transform = require("./streams/privileged_user_parse_transform");
var _batching = require("../../shared/streams/batching");
var _upsert_batch = require("./bulk/upsert_batch");
var _utils = require("./bulk/utils");
var _query_existing_users = require("./bulk/query_existing_users");
var _soft_delete_omitted_users = require("./bulk/soft_delete_omitted_users");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createPrivilegedUsersCsvService = dataClient => {
  const {
    deps,
    index
  } = dataClient;
  const esClient = deps.clusterClient.asCurrentUser;
  const bulkUpload = async (stream, options) => {
    const csvStream = _papaparse.default.parse(_papaparse.default.NODE_STREAM_INPUT, {
      header: false,
      dynamicTyping: true,
      skipEmptyLines: true
    });
    const batches = _stream.Readable.from(stream.pipe(csvStream)).pipe((0, _privileged_user_parse_transform.privilegedUserParserTransform)()).pipe((0, _batching.batchPartitions)(100));
    let results = {
      users: [],
      errors: [],
      failed: 0,
      successful: 0
    };
    for await (const batch of batches) {
      const usrs = await (0, _query_existing_users.queryExistingUsers)(esClient, index)(batch);
      const upserted = await (0, _upsert_batch.bulkUpsertBatch)(esClient, index, options)(usrs);
      results = (0, _utils.accumulateUpsertResults)({
        users: [],
        errors: [],
        failed: 0,
        successful: 0
      }, upserted);
    }
    const softDeletedResults = await (0, _soft_delete_omitted_users.softDeleteOmittedUsers)(esClient, index, options)(results);
    return {
      errors: softDeletedResults.updated.errors.concat(softDeletedResults.deleted.errors),
      stats: {
        failed: softDeletedResults.updated.failed + softDeletedResults.deleted.failed,
        successful: softDeletedResults.updated.successful + softDeletedResults.deleted.successful,
        total: softDeletedResults.updated.failed + softDeletedResults.updated.successful + softDeletedResults.deleted.failed + softDeletedResults.deleted.successful
      }
    };
  };
  return {
    bulkUpload
  };
};
exports.createPrivilegedUsersCsvService = createPrivilegedUsersCsvService;