"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.privilegeMonitoringTypeNameMappings = exports.privilegeMonitoringTypeName = exports.privilegeMonitoringType = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const privilegeMonitoringTypeName = exports.privilegeMonitoringTypeName = 'privilege-monitoring-status';
const privilegeMonitoringTypeNameMappings = exports.privilegeMonitoringTypeNameMappings = {
  dynamic: false,
  properties: {
    status: {
      type: 'keyword'
    }
  }
};
const version1 = {
  changes: [{
    type: 'mappings_addition',
    addedMappings: {
      status: {
        type: 'keyword'
      }
    }
  }]
};
const privilegeMonitoringType = exports.privilegeMonitoringType = {
  name: privilegeMonitoringTypeName,
  indexPattern: _coreSavedObjectsServer.SECURITY_SOLUTION_SAVED_OBJECT_INDEX,
  hidden: false,
  namespaceType: 'multiple-isolated',
  mappings: privilegeMonitoringTypeNameMappings,
  modelVersions: {
    1: version1
  }
};