"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timeStampsAreValid = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timeStampsAreValid = async ({
  completedEventTimeStamp,
  startedEventTimeStamp,
  source,
  dataClient
}) => {
  if (!completedEventTimeStamp || !startedEventTimeStamp) {
    dataClient.log('warn', `Missing start/completed markers for source ${source.id}; skipping deletion detection. ` + `started=${String(startedEventTimeStamp)} completed=${String(completedEventTimeStamp)}`);
    return false;
  }
  if (completedEventTimeStamp <= startedEventTimeStamp) {
    dataClient.log('warn', `Completed <= started for source ${source.id} (started=${startedEventTimeStamp}, completed=${completedEventTimeStamp}); skipping.`);
    return false;
  }
  return true;
};
exports.timeStampsAreValid = timeStampsAreValid;