"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEntityStoreRoutes = void 0;
var _apply_dataview_indices = require("./apply_dataview_indices");
var _delete = require("./delete");
var _list = require("./entities/list");
var _get = require("./get");
var _init = require("./init");
var _list2 = require("./list");
var _privileges = require("./privileges");
var _start = require("./start");
var _stop = require("./stop");
var _status = require("./status");
var _enablement = require("./enablement");
var _upsert_entity = require("./entity_crud/upsert_entity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerEntityStoreRoutes = ({
  router,
  logger,
  getStartServices,
  config
}) => {
  (0, _enablement.enableEntityStoreRoute)(router, logger, config);
  (0, _status.getEntityStoreStatusRoute)(router, logger, config);
  (0, _init.initEntityEngineRoute)(router, logger, config);
  (0, _start.startEntityEngineRoute)(router, logger);
  (0, _stop.stopEntityEngineRoute)(router, logger);
  (0, _delete.deleteEntityEngineRoute)(router, logger, getStartServices);
  (0, _get.getEntityEngineRoute)(router, logger);
  (0, _list2.listEntityEnginesRoute)(router, logger);
  (0, _list.listEntitiesRoute)(router, logger);
  (0, _apply_dataview_indices.applyDataViewIndicesEntityEngineRoute)(router, logger);
  (0, _privileges.entityStoreInternalPrivilegesRoute)(router, logger, getStartServices);
  (0, _upsert_entity.upsertEntity)(router, logger);
};
exports.registerEntityStoreRoutes = registerEntityStoreRoutes;