"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteEntityEngineRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _zodHelpers = require("@kbn/zod-helpers");
var _search_strategy = require("../../../../../common/search_strategy");
var _delete = require("../../../../../common/api/entity_analytics/entity_store/engine/delete.gen");
var _constants = require("../../../../../common/constants");
var _translations = require("../../risk_engine/routes/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteEntityEngineRoute = (router, logger, getStartServices) => {
  router.versioned.delete({
    access: 'public',
    path: '/api/entity_store/engines/{entityType}',
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: {
        query: (0, _zodHelpers.buildRouteValidationWithZod)(_delete.DeleteEntityEngineRequestQuery),
        params: (0, _zodHelpers.buildRouteValidationWithZod)(_delete.DeleteEntityEngineRequestParams)
      }
    }
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const [_, {
      taskManager
    }] = await getStartServices();
    if (!taskManager) {
      return siemResponse.error({
        statusCode: 400,
        body: _translations.TASK_MANAGER_UNAVAILABLE_ERROR
      });
    }
    try {
      const secSol = await context.securitySolution;
      const body = await secSol.getEntityStoreDataClient().delete(_search_strategy.EntityType[request.params.entityType], taskManager, {
        deleteData: !!request.query.data,
        deleteEngine: true
      });
      return response.ok({
        body
      });
    } catch (e) {
      logger.error('Error in DeleteEntityEngine:', e);
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.deleteEntityEngineRoute = deleteEntityEngineRoute;