"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userEntityEngineDescription = exports.USER_IDENTITY_FIELD = exports.USER_DEFINITION_VERSION = void 0;
var _common = require("./common");
var _field_utils = require("./field_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const USER_DEFINITION_VERSION = exports.USER_DEFINITION_VERSION = '1.0.0';
const USER_IDENTITY_FIELD = exports.USER_IDENTITY_FIELD = 'user.name';
const USER_ENTITY_TYPE = 'Identity';
const userEntityEngineDescription = exports.userEntityEngineDescription = {
  entityType: 'user',
  version: USER_DEFINITION_VERSION,
  identityField: USER_IDENTITY_FIELD,
  identityFieldMapping: {
    type: 'keyword',
    fields: {
      text: {
        type: 'match_only_text'
      }
    }
  },
  settings: {
    timestampField: '@timestamp'
  },
  pipeline: [{
    set: {
      field: 'entity.type',
      value: USER_ENTITY_TYPE,
      override: false
    }
  }],
  fields: [(0, _field_utils.collectValues)({
    source: 'user.domain'
  }), (0, _field_utils.collectValues)({
    source: 'user.email'
  }), (0, _field_utils.collectValues)({
    source: 'user.full_name',
    mapping: {
      type: 'keyword',
      fields: {
        text: {
          type: 'match_only_text'
        }
      }
    }
  }), (0, _field_utils.collectValues)({
    source: 'user.hash'
  }), (0, _field_utils.collectValues)({
    source: 'user.id'
  }), (0, _field_utils.collectValues)({
    source: 'user.roles'
  }), ...(0, _common.getCommonFieldDescriptions)('user'), ...(0, _common.getEntityFieldsDescriptions)('user'), (0, _field_utils.collectValues)({
    source: `user.entity.relationships.Accesses_frequently`,
    destination: 'entity.relationships.Accesses_frequently',
    mapping: {
      type: 'keyword'
    },
    allowAPIUpdate: true
  }), (0, _field_utils.collectValues)({
    source: `user.entity.relationships.Owns`,
    destination: 'entity.relationships.Owns',
    mapping: {
      type: 'keyword'
    },
    allowAPIUpdate: true
  }), (0, _field_utils.collectValues)({
    source: `user.entity.relationships.Supervises`,
    destination: 'entity.relationships.Supervises',
    mapping: {
      type: 'keyword'
    },
    allowAPIUpdate: true
  }), (0, _field_utils.collectValues)({
    source: `user.entity.relationships.Supervised_by`,
    destination: 'entity.relationships.Supervised_by',
    mapping: {
      type: 'keyword'
    },
    allowAPIUpdate: true
  })]
};