"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.genericEntityEngineDescription = exports.GENERIC_IDENTITY_FIELD = exports.GENERIC_DEFINITION_VERSION = void 0;
var _field_utils = require("./field_utils");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GENERIC_DEFINITION_VERSION = exports.GENERIC_DEFINITION_VERSION = '1.0.0';
const GENERIC_IDENTITY_FIELD = exports.GENERIC_IDENTITY_FIELD = 'entity.id';
const genericEntityEngineDescription = exports.genericEntityEngineDescription = {
  entityType: 'generic',
  version: GENERIC_DEFINITION_VERSION,
  identityField: GENERIC_IDENTITY_FIELD,
  identityFieldMapping: {
    type: 'keyword'
  },
  settings: {
    timestampField: '@timestamp'
  },
  fields: [...(0, _common.getEntityFieldsDescriptions)(), (0, _field_utils.newestValue)({
    source: 'cloud.account.id'
  }), (0, _field_utils.newestValue)({
    source: 'cloud.account.name'
  }), (0, _field_utils.newestValue)({
    source: 'cloud.availability_zone'
  }), (0, _field_utils.newestValue)({
    source: 'cloud.instance.id'
  }), (0, _field_utils.newestValue)({
    source: 'cloud.instance.name'
  }), (0, _field_utils.newestValue)({
    source: 'cloud.machine.type'
  }), (0, _field_utils.newestValue)({
    source: 'cloud.project.id'
  }), (0, _field_utils.newestValue)({
    source: 'cloud.project.name'
  }), (0, _field_utils.newestValue)({
    source: 'cloud.provider'
  }), (0, _field_utils.newestValue)({
    source: 'cloud.region'
  }), (0, _field_utils.newestValue)({
    source: 'cloud.service.name'
  }), (0, _field_utils.newestValue)({
    source: 'host.architecture'
  }), (0, _field_utils.newestValue)({
    source: 'host.boot.id'
  }), (0, _field_utils.newestValue)({
    source: 'host.cpu.usage'
  }), (0, _field_utils.newestValue)({
    source: 'host.disk.read.bytes'
  }), (0, _field_utils.newestValue)({
    source: 'host.disk.write.bytes'
  }), (0, _field_utils.newestValue)({
    source: 'host.domain'
  }), (0, _field_utils.newestValue)({
    source: 'host.hostname'
  }), (0, _field_utils.newestValue)({
    source: 'host.id'
  }), (0, _field_utils.newestValue)({
    source: 'host.mac'
  }), (0, _field_utils.newestValue)({
    source: 'host.name'
  }), (0, _field_utils.newestValue)({
    source: 'host.network.egress.bytes'
  }), (0, _field_utils.newestValue)({
    source: 'host.network.egress.packets'
  }), (0, _field_utils.newestValue)({
    source: 'host.network.ingress.bytes'
  }), (0, _field_utils.newestValue)({
    source: 'host.network.ingress.packets'
  }), (0, _field_utils.newestValue)({
    source: 'host.pid_ns_ino'
  }), (0, _field_utils.newestValue)({
    source: 'host.type'
  }), (0, _field_utils.newestValue)({
    source: 'host.uptime'
  }), (0, _field_utils.newestValue)({
    source: 'host.ip',
    mapping: {
      type: 'ip'
    }
  }), (0, _field_utils.newestValue)({
    source: 'user.domain'
  }), (0, _field_utils.newestValue)({
    source: 'user.email'
  }), (0, _field_utils.newestValue)({
    source: 'user.full_name'
  }), (0, _field_utils.newestValue)({
    source: 'user.roles'
  }), (0, _field_utils.newestValue)({
    source: 'user.hash'
  }), (0, _field_utils.newestValue)({
    source: 'user.id'
  }), (0, _field_utils.newestValue)({
    source: 'user.name',
    mapping: {
      type: 'keyword',
      fields: {
        text: {
          type: 'match_only_text'
        }
      }
    }
  }), (0, _field_utils.newestValue)({
    source: 'user.full_name',
    mapping: {
      type: 'keyword',
      fields: {
        text: {
          type: 'match_only_text'
        }
      }
    }
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.api_version'
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.cluster.id'
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.cluster.name'
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.cluster.url'
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.cluster.version'
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.namespace'
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.organization'
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.resource.annotation'
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.resource.id'
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.resource.ip'
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.resource.label'
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.resource.name'
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.resource.parent.type'
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.resource.type'
  }), (0, _field_utils.newestValue)({
    source: 'orchestrator.type'
  }), ...(0, _common.getCommonFieldDescriptions)('entity')]
};