"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchAfterAndBulkCreate = void 0;
var _utils = require("./utils");
var _search_after_bulk_create_factory = require("./search_after_bulk_create_factory");
var _factories = require("../factories");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// search_after through documents and re-index using bulk endpoint.
const searchAfterAndBulkCreate = async params => {
  const {
    sharedParams,
    services,
    buildReasonMessage
  } = params;
  const bulkCreateExecutor = async ({
    enrichedEvents,
    toReturn
  }) => {
    const wrappedDocs = (0, _factories.wrapHits)(sharedParams, enrichedEvents, buildReasonMessage);
    const bulkCreateResult = await (0, _factories.bulkCreate)({
      wrappedAlerts: wrappedDocs,
      sharedParams,
      services,
      maxAlerts: sharedParams.tuple.maxSignals - toReturn.createdSignalsCount
    });
    (0, _utils.addToSearchAfterReturn)({
      current: toReturn,
      next: bulkCreateResult
    });
    return bulkCreateResult;
  };
  return (0, _search_after_bulk_create_factory.searchAfterAndBulkCreateFactory)({
    ...params,
    bulkCreateExecutor,
    getWarningMessage: _utils.getMaxSignalsWarning
  });
};
exports.searchAfterAndBulkCreate = searchAfterAndBulkCreate;