"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQueryFilterLoadFields = void 0;
var _server = require("@kbn/data-views-plugin/server");
var _common = require("@kbn/data-plugin/common");
var _esQuery = require("@kbn/es-query");
var _get_query_filter = require("./get_query_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getQueryFilterLoadFields = dataViewsService => async ({
  query,
  language,
  filters,
  index,
  exceptionFilter
}) => {
  const config = {
    allowLeadingWildcards: true,
    queryStringOptions: {
      analyze_wildcard: true
    },
    ignoreFilterIfFieldNotInIndex: false,
    dateFormatTZ: 'Zulu'
  };
  const initialQuery = {
    query,
    language
  };
  const allFilters = (0, _get_query_filter.getAllFilters)(filters, exceptionFilter);
  const title = (index !== null && index !== void 0 ? index : []).join();
  const dataViewLazy = await dataViewsService.createDataViewLazy({
    title
  });
  const flds = await (0, _common.queryToFields)({
    dataView: dataViewLazy,
    request: {
      query: [initialQuery],
      filters: allFilters
    }
  });
  const dataViewLimitedFields = new _server.DataView({
    spec: {
      title
    },
    fieldFormats: {},
    shortDotsEnable: false,
    metaFields: []
  });
  dataViewLimitedFields.fields.replaceAll(Object.values(flds).map(fld => fld.toSpec()));
  return (0, _esQuery.buildEsQuery)(dataViewLimitedFields, initialQuery, allFilters, config);
};
exports.getQueryFilterLoadFields = getQueryFilterLoadFields;