"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.threatEnrichmentFactory = void 0;
var _enrich_signal_threat_matches = require("./enrich_signal_threat_matches");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const threatEnrichmentFactory = ({
  signalIdToMatchedQueriesMap,
  threatIndicatorPath,
  threatMappings
}) => {
  return signals => (0, _enrich_signal_threat_matches.enrichSignalThreatMatchesFromSignalsMap)(signals, threatIndicatorPath, signalIdToMatchedQueriesMap, threatMappings);
};
exports.threatEnrichmentFactory = threatEnrichmentFactory;