"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateHealthTimings = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const calculateHealthTimings = requestReceivedAt => {
  const requestedAt = (0, _moment.default)(requestReceivedAt);
  const processedAt = (0, _moment.default)().utc();
  const processingTime = _moment.default.duration(processedAt.diff(requestReceivedAt));
  return {
    requested_at: requestedAt.toISOString(),
    processed_at: processedAt.toISOString(),
    processing_time_ms: processingTime.asMilliseconds()
  };
};
exports.calculateHealthTimings = calculateHealthTimings;