"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformRuleToExportableFormat = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Transforms a rule object to exportable format. Exportable format shouldn't contain runtime fields like
 * `execution_summary`
 */
const transformRuleToExportableFormat = rule => {
  const exportedRule = {
    ...rule
  };

  // Fields containing runtime information shouldn't be exported. It causes import failures.
  delete exportedRule.execution_summary;
  return exportedRule;
};
exports.transformRuleToExportableFormat = transformRuleToExportableFormat;