"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.internalRuleToAPIResponse = void 0;
var _normalize_rule_fields_common = require("./normalize_rule_fields_common");
var _type_specific_camel_to_snake = require("./type_specific_camel_to_snake");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const internalRuleToAPIResponse = rule => {
  const normalizedCommonFields = (0, _normalize_rule_fields_common.normalizeCommonRuleFields)(rule);
  const normalizedTypeSpecificFields = (0, _type_specific_camel_to_snake.typeSpecificCamelToSnake)(rule.params);
  return {
    ...normalizedCommonFields,
    ...normalizedTypeSpecificFields
  };
};
exports.internalRuleToAPIResponse = internalRuleToAPIResponse;