"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateRuleFieldsDiff = void 0;
var _normalize_rule_response = require("../../../../../../../common/detection_engine/prebuilt_rules/diff/normalize_rule_response");
var _deep_equality_diff_algorithm = require("./two_way_diff_algorithms/deep_equality_diff_algorithm");
var _order_agnostic_array_diff_algorithm = require("./two_way_diff_algorithms/order_agnostic_array_diff_algorithm");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Determines the diff between two rule response objects and returns a list of every rule field
 */
const calculateRuleFieldsDiff = ({
  ruleA,
  ruleB
}) => {
  const normalizedRuleA = (0, _normalize_rule_response.normalizeRuleResponse)(ruleA);
  const normalizedRuleB = (0, _normalize_rule_response.normalizeRuleResponse)(ruleB);
  const fieldsDiff = {};
  const keys = new Set([...Object.keys(normalizedRuleA), ...Object.keys(normalizedRuleB)]);
  for (const key of keys) {
    const fieldKey = key;
    const valueA = normalizedRuleA[fieldKey];
    const valueB = normalizedRuleB[fieldKey];
    const comparator = allFieldsComparators[fieldKey];

    // We only compare fields if there is a comparator explicitly defined for the field in the lists below
    if (comparator) {
      fieldsDiff[fieldKey] = {
        is_equal: comparator(valueA, valueB),
        value_a: valueA,
        value_b: valueB
      };
    }
  }
  return fieldsDiff;
};

/**
 * Field Comparators
 *
 * This is an exhaustive list of comparators based on the `RuleDiffField` types which is, aside from minor
 * omittances for non-diffable fields, a 1-to-1 extension of the `RuleResponse` schema. Every field we diff on
 * is listed here with its corresponding comparison logic. If a rule field is not listed here, it will not be
 * used in the diffing logic and will not be returned in the final outcome object.
 *
 * NOTE: When adding a new field to these comparators, also add a test for diff synchronization in `./calculate_rule_diff_synchronization.test.ts`
 */
exports.calculateRuleFieldsDiff = calculateRuleFieldsDiff;
const commonFieldComparators = {
  version: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  name: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  tags: _order_agnostic_array_diff_algorithm.orderAgnosticArrayDiffAlgorithm,
  description: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  severity: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  severity_mapping: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  risk_score: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  risk_score_mapping: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  references: _order_agnostic_array_diff_algorithm.orderAgnosticArrayDiffAlgorithm,
  false_positives: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  threat: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  note: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  setup: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  related_integrations: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  required_fields: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  from: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  to: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  interval: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  investigation_fields: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  building_block_type: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  timeline_id: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  timeline_title: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  timestamp_override: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  timestamp_override_fallback_disabled: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  rule_name_override: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  max_signals: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm
};
const customQueryFieldComparators = {
  type: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  query: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  language: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  filters: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  saved_id: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  data_view_id: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  index: _order_agnostic_array_diff_algorithm.orderAgnosticArrayDiffAlgorithm,
  alert_suppression: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm
};
const savedQueryFieldComparators = {
  type: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  query: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  language: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  filters: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  saved_id: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  data_view_id: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  index: _order_agnostic_array_diff_algorithm.orderAgnosticArrayDiffAlgorithm,
  alert_suppression: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm
};
const eqlFieldComparators = {
  type: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  query: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  language: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  filters: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  data_view_id: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  index: _order_agnostic_array_diff_algorithm.orderAgnosticArrayDiffAlgorithm,
  alert_suppression: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  event_category_override: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  tiebreaker_field: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  timestamp_field: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm
};
const esqlFieldComparators = {
  type: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  query: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  language: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  alert_suppression: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm
};
const threatMatchFieldComparators = {
  type: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  query: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  language: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  filters: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  saved_id: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  data_view_id: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  index: _order_agnostic_array_diff_algorithm.orderAgnosticArrayDiffAlgorithm,
  alert_suppression: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  threat_query: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  threat_index: _order_agnostic_array_diff_algorithm.orderAgnosticArrayDiffAlgorithm,
  threat_filters: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  threat_indicator_path: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  threat_language: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  threat_mapping: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm
};
const thresholdFieldComparators = {
  type: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  query: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  language: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  filters: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  saved_id: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  data_view_id: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  index: _order_agnostic_array_diff_algorithm.orderAgnosticArrayDiffAlgorithm,
  alert_suppression: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  threshold: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm
};
const machineLearningFieldComparators = {
  type: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  anomaly_threshold: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  machine_learning_job_id: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  alert_suppression: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm
};
const newTermsFieldComparators = {
  type: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  query: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  language: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  filters: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  data_view_id: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  index: _order_agnostic_array_diff_algorithm.orderAgnosticArrayDiffAlgorithm,
  alert_suppression: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm,
  new_terms_fields: _order_agnostic_array_diff_algorithm.orderAgnosticArrayDiffAlgorithm,
  history_window_start: _deep_equality_diff_algorithm.deepEqualityDiffAlgorithm
};
const allFieldsComparators = {
  ...commonFieldComparators,
  ...customQueryFieldComparators,
  ...savedQueryFieldComparators,
  ...eqlFieldComparators,
  ...esqlFieldComparators,
  ...threatMatchFieldComparators,
  ...thresholdFieldComparators,
  ...machineLearningFieldComparators,
  ...newTermsFieldComparators
};