"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEntityStats = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIndexDocCount = (esClient, index) => esClient.indices.stats({
  index
});
const getLatestDocTimestamp = async (esClient, index) => {
  var _latestTimestamp$hits, _latestTimestamp$hits2;
  const latestTimestamp = await esClient.search({
    index,
    query: {
      match_all: {}
    },
    sort: '@timestamp:desc',
    size: 1,
    fields: ['@timestamp'],
    _source: false
  });
  const latestEventTimestamp = (_latestTimestamp$hits = latestTimestamp.hits) === null || _latestTimestamp$hits === void 0 ? void 0 : (_latestTimestamp$hits2 = _latestTimestamp$hits.hits[0]) === null || _latestTimestamp$hits2 === void 0 ? void 0 : _latestTimestamp$hits2.fields;
  return latestEventTimestamp ? latestEventTimestamp['@timestamp'][0] : null;
};
const getEntityStats = async (esClient, index, logger) => {
  try {
    const isIndexExists = await esClient.indices.exists({
      index
    });
    if (isIndexExists) {
      var _indexStats$_all$prim, _indexStats$_all$prim2, _indexStats$_all$prim3;
      const indexStats = await getIndexDocCount(esClient, index);
      return {
        doc_count: (_indexStats$_all$prim = indexStats._all.primaries) !== null && _indexStats$_all$prim !== void 0 && _indexStats$_all$prim.docs ? (_indexStats$_all$prim2 = indexStats._all.primaries) === null || _indexStats$_all$prim2 === void 0 ? void 0 : (_indexStats$_all$prim3 = _indexStats$_all$prim2.docs) === null || _indexStats$_all$prim3 === void 0 ? void 0 : _indexStats$_all$prim3.count : 0,
        last_doc_timestamp: await getLatestDocTimestamp(esClient, index)
      };
    }
    return {};
  } catch (e) {
    logger.error(`Failed to get index stats for ${index}`);
    return {};
  }
};
exports.getEntityStats = getEntityStats;