"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnsupportedAgentTypeError = exports.AgentStatusNotSupportedError = exports.AgentStatusClientError = void 0;
var _stringify = require("../../../utils/stringify");
var _custom_http_request_error = require("../../../../utils/custom_http_request_error");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable max-classes-per-file */

/**
 * Errors associated with Agent Status clients
 */
class AgentStatusClientError extends _custom_http_request_error.CustomHttpRequestError {
  toJSON() {
    return {
      message: this.message,
      statusCode: this.statusCode,
      meta: this.meta,
      stack: this.stack
    };
  }
  toString() {
    return (0, _stringify.stringify)(this.toJSON());
  }
}
exports.AgentStatusClientError = AgentStatusClientError;
class UnsupportedAgentTypeError extends AgentStatusClientError {
  constructor(message, statusCode = 501, meta) {
    super(message, statusCode, meta);
  }
}
exports.UnsupportedAgentTypeError = UnsupportedAgentTypeError;
class AgentStatusNotSupportedError extends AgentStatusClientError {
  constructor(agentIds, agentType, statusCode = 405, meta) {
    super(`Agent status is not available for ${`[agentIds: ${agentIds} and agentType: ${agentType}]`} not supported`, statusCode, meta);
  }
}
exports.AgentStatusNotSupportedError = AgentStatusNotSupportedError;