"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapToHostMetadata = mapToHostMetadata;
exports.queryResponseToHostResult = exports.queryResponseToHostListResult = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Maps the data from the index to `HostMetadata`, ensuring that only known properties are
 * returned.
 * @param data
 */
function mapToHostMetadata(data) {
  const {
    host,
    agent,
    '@timestamp': timestamp,
    elastic,
    Endpoint,
    event,
    data_stream: dataStream
  } = 'HostDetails' in data ? data.HostDetails : data;
  return {
    '@timestamp': timestamp,
    event,
    elastic,
    Endpoint,
    agent,
    host,
    data_stream: dataStream
  };
}
const queryResponseToHostResult = searchResponse => {
  const response = searchResponse;
  const metadata = response.hits.hits && response.hits.hits[0] && response.hits.hits[0]._source ? mapToHostMetadata(response.hits.hits[0]._source) : undefined;
  const hostResult = {
    resultLength: response.hits.hits.length,
    result: metadata
  };
  return hostResult;
};
exports.queryResponseToHostResult = queryResponseToHostResult;
const queryResponseToHostListResult = searchResponse => {
  var _response$hits;
  const response = searchResponse;
  const list = response.hits.hits.length > 0 ? response.hits.hits.map(entry => mapToHostMetadata(entry === null || entry === void 0 ? void 0 : entry._source)) : [];
  return {
    resultLength: ((_response$hits = response.hits) === null || _response$hits === void 0 ? void 0 : _response$hits.total).value || 0,
    resultList: list
  };
};
exports.queryResponseToHostListResult = queryResponseToHostListResult;