"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnalyzeIndexPatternGraph = void 0;
var _langgraph = require("@langchain/langgraph");
var _prebuilt = require("@langchain/langgraph/prebuilt");
var _state = require("./state");
var _constants = require("./constants");
var _common = require("../../utils/common");
var _inspect_index_mapping_tool = require("../../tools/inspect_index_mapping_tool/inspect_index_mapping_tool");
var _get_field_descriptors = require("./nodes/get_field_descriptors/get_field_descriptors");
var _analyze_compressed_index_mapping_agent = require("./nodes/analyze_compressed_index_mapping_agent/analyze_compressed_index_mapping_agent");
var _explore_partial_index_mapping_agent = require("./nodes/explore_partial_index_mapping_agent/explore_partial_index_mapping_agent");
var _explore_partial_index_mapping_responder = require("./nodes/explore_partial_index_mapping_responder/explore_partial_index_mapping_responder");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAnalyzeIndexPatternGraph = async ({
  esClient,
  createLlmInstance
}) => {
  const [analyzeCompressedIndexMappingAgent, explorePartialIndexMappingAgent, explorePartialIndexMappingResponder] = await Promise.all([(0, _analyze_compressed_index_mapping_agent.getAnalyzeCompressedIndexMappingAgent)({
    createLlmInstance
  }), (0, _explore_partial_index_mapping_agent.getExplorePartialIndexMappingAgent)({
    esClient,
    createLlmInstance
  }), (0, _explore_partial_index_mapping_responder.getExplorePartialIndexMappingResponder)({
    createLlmInstance
  })]);
  const graph = new _langgraph.StateGraph(_state.AnalyzeIndexPatternAnnotation).addNode(_constants.GET_FIELD_DESCRIPTORS, (0, _get_field_descriptors.getFieldDescriptors)({
    esClient
  })).addNode(_constants.ANALYZE_COMPRESSED_INDEX_MAPPING_AGENT, analyzeCompressedIndexMappingAgent).addNode(_constants.EXPLORE_PARTIAL_INDEX_AGENT, explorePartialIndexMappingAgent).addNode(_constants.TOOLS, state => {
    const {
      input
    } = state;
    if (input === undefined) {
      throw new Error('Input is required');
    }
    const inspectIndexMappingTool = (0, _inspect_index_mapping_tool.getInspectIndexMappingTool)({
      esClient,
      indexPattern: input.indexPattern
    });
    const tools = [inspectIndexMappingTool];
    const toolNode = new _prebuilt.ToolNode(tools);
    return toolNode.invoke(state);
  }).addNode(_constants.EXPLORE_PARTIAL_INDEX_RESPONDER, explorePartialIndexMappingResponder).addEdge(_langgraph.START, _constants.GET_FIELD_DESCRIPTORS).addConditionalEdges(_constants.GET_FIELD_DESCRIPTORS, state => {
    if (state.fieldDescriptors === undefined) {
      throw new Error('Expected field descriptors to be defined');
    }
    return state.fieldDescriptors.length > 2500 ? _constants.EXPLORE_PARTIAL_INDEX_AGENT : _constants.ANALYZE_COMPRESSED_INDEX_MAPPING_AGENT;
  }, {
    [_constants.EXPLORE_PARTIAL_INDEX_AGENT]: _constants.EXPLORE_PARTIAL_INDEX_AGENT,
    [_constants.ANALYZE_COMPRESSED_INDEX_MAPPING_AGENT]: _constants.ANALYZE_COMPRESSED_INDEX_MAPPING_AGENT
  }).addEdge(_constants.ANALYZE_COMPRESSED_INDEX_MAPPING_AGENT, _langgraph.END).addConditionalEdges(_constants.EXPLORE_PARTIAL_INDEX_AGENT, state => {
    if ((0, _common.messageContainsToolCalls)(state.messages[state.messages.length - 1])) {
      return _constants.TOOLS;
    }
    return _constants.EXPLORE_PARTIAL_INDEX_RESPONDER;
  }, {
    [_constants.TOOLS]: _constants.TOOLS,
    [_constants.EXPLORE_PARTIAL_INDEX_RESPONDER]: _constants.EXPLORE_PARTIAL_INDEX_RESPONDER
  }).addEdge(_constants.TOOLS, _constants.EXPLORE_PARTIAL_INDEX_AGENT).addEdge(_constants.EXPLORE_PARTIAL_INDEX_RESPONDER, _langgraph.END).compile();
  return graph;
};
exports.getAnalyzeIndexPatternGraph = getAnalyzeIndexPatternGraph;