"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useReadonlyHeader = useReadonlyHeader;
var _react = require("react");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("./common/lib/kibana");
var _use_alerts_privileges = require("./detections/containers/detection_engine/alerts/use_alerts_privileges");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component places a read-only icon badge in the header
 * if user only has read *Kibana* privileges, not individual data index
 * privileges
 */
function useReadonlyHeader(tooltip) {
  const {
    hasKibanaREAD,
    hasKibanaCRUD
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const chrome = (0, _kibana.useKibana)().services.chrome;
  (0, _react.useEffect)(() => {
    if (hasKibanaREAD && !hasKibanaCRUD) {
      chrome.setBadge({
        text: i18n.READ_ONLY_BADGE_TEXT,
        tooltip,
        iconType: 'glasses'
      });
    }

    // remove the icon after the component unmounts
    return () => {
      chrome.setBadge();
    };
  }, [chrome, hasKibanaREAD, hasKibanaCRUD, tooltip]);
}