"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTimelineMiddlewares = createTimelineMiddlewares;
var _timeline_changed = require("./timeline_changed");
var _timeline_favorite = require("./timeline_favorite");
var _timeline_note = require("./timeline_note");
var _timeline_pinned_event = require("./timeline_pinned_event");
var _timeline_save = require("./timeline_save");
var _timeline_privileges = require("./timeline_privileges");
var _timeline_localstorage = require("./timeline_localstorage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createTimelineMiddlewares(kibana) {
  return [(0, _timeline_privileges.timelinePrivilegesMiddleware)(kibana), _timeline_changed.timelineChangedMiddleware, (0, _timeline_favorite.favoriteTimelineMiddleware)(kibana), (0, _timeline_note.addNoteToTimelineMiddleware)(kibana), (0, _timeline_pinned_event.addPinnedEventToTimelineMiddleware)(kibana), (0, _timeline_save.saveTimelineMiddleware)(kibana), _timeline_localstorage.timelineLocalStorageMiddleware];
}