"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.migrateEntityRiskLevelColumnTitle = exports.LOCAL_STORAGE_MIGRATION_KEY = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _ = require(".");
var _columns = require("../../../detections/configurations/security_solution_detections/columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_STORAGE_MIGRATION_KEY = exports.LOCAL_STORAGE_MIGRATION_KEY = 'securitySolution.dataTable.entityRiskLevelColumnTitleMigration';
const migrateEntityRiskLevelColumnTitle = (storage, dataTableState) => {
  //  Set/Get a flag to prevent migration from running more than once
  const hasAlreadyMigrated = storage.get(LOCAL_STORAGE_MIGRATION_KEY);
  if (hasAlreadyMigrated) {
    return;
  }
  storage.set(LOCAL_STORAGE_MIGRATION_KEY, true);
  let updatedTableModel = false;
  for (const [tableId, tableModel] of Object.entries(dataTableState)) {
    // Only updates the title for alerts tables
    if (_securitysolutionDataTable.tableEntity[tableId] === _securitysolutionDataTable.TableEntityType.alert) {
      // In order to show correct column title after user upgrades to 8.13 we need update the stored table model with the new title.
      const columns = tableModel.columns;
      if (Array.isArray(columns)) {
        columns.forEach(col => {
          if (col.id === _columns.userRiskLevelColumn.id) {
            col.displayAsText = _columns.userRiskLevelColumn.displayAsText;
            updatedTableModel = true;
          }
          if (col.id === _columns.hostRiskLevelColumn.id) {
            col.displayAsText = _columns.hostRiskLevelColumn.displayAsText;
            updatedTableModel = true;
          }
        });
      }
    }
  }
  if (updatedTableModel) {
    storage.set(_.LOCAL_STORAGE_TABLE_KEY, dataTableState);
  }
};
exports.migrateEntityRiskLevelColumnTitle = migrateEntityRiskLevelColumnTitle;