"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.activeTimeline = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Future Engineer
 * This class is just there to manage temporarily the reload of the active timeline when switching tabs
 * because of the bootstrap of the security solution app, we will always trigger the query
 * to avoid it we will cache its request and response so we can go back where the user was before switching tabs
 *
 * !!! Important !!! this is just there until, we will have a better way to bootstrap the app
 * I did not want to put in the store because I was feeling it will feel less temporarily and I did not want other engineer using it
 *
 */

class ActiveTimelineEvents {
  constructor() {
    (0, _defineProperty2.default)(this, "_activePage", 0);
    (0, _defineProperty2.default)(this, "_pageName", '');
    (0, _defineProperty2.default)(this, "_request", null);
    (0, _defineProperty2.default)(this, "_response", null);
    (0, _defineProperty2.default)(this, "_eqlRequest", null);
    (0, _defineProperty2.default)(this, "_eqlResponse", null);
  }
  getActivePage() {
    return this._activePage;
  }
  setActivePage(activePage) {
    this._activePage = activePage;
  }
  getPageName() {
    return this._pageName;
  }
  setPageName(pageName) {
    this._pageName = pageName;
  }
  getRequest() {
    return this._request;
  }
  setRequest(req) {
    this._request = req;
  }
  getResponse() {
    return this._response;
  }
  setResponse(resp) {
    this._response = resp;
  }
  getEqlRequest() {
    return this._eqlRequest;
  }
  setEqlRequest(req) {
    this._eqlRequest = req;
  }
  getEqlResponse() {
    return this._eqlResponse;
  }
  setEqlResponse(resp) {
    this._eqlResponse = resp;
  }
}
const activeTimeline = exports.activeTimeline = new ActiveTimelineEvents();