"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataProviderFilter = exports.QueryBarTimeline = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _esQuery = require("@kbn/es-query");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _constants = require("../../../../common/store/inputs/constants");
var _model = require("../../../../sourcerer/store/model");
var _kuery = require("../../../../common/lib/kuery");
var _saved_query_services = require("../../../../common/utils/saved_query_services");
var _query_bar = require("../../../../common/components/query_bar");
var _helpers = require("../helpers");
var _store = require("../../../store");
var _use_browser_fields = require("../../../../data_view_manager/hooks/use_browser_fields");
var _containers = require("../../../../sourcerer/containers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761322521701505730/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/query_bar/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchBarContainer = _styled.default.div`
  /*
  *
  * hide search bar default filters as they are disturbing the layout  as shown below
  *
  * Filters are displayed with QueryBar so below is how is the layout with default filters.
  *
  *
  *                    --------------------------------
  *   -----------------|                              |------------
  *   | DataViewPicker |        QueryBar              | Date      |
  *   -------------------------------------------------------------
  *                    |      Filters                 |
  *                    --------------------------------
  *
  * The tree under this component makes sure that default filters are not rendered and we can separately display
  * them outside query component so that layout is as below:
  *
  *   -----------------------------------------------------------
  *   | DataViewPicker |      QueryBar              |   Date    |
  *   -----------------------------------------------------------
  *   |                       Filters                           |
  *   -----------------------------------------------------------
  *
  * */

  .uniSearchBar .filter-items-group {
    display: none;
  }

  .euiDataGrid__restrictBody & {
    .kbnQueryBar {
      display: flex;
    }
  }
`;

// eslint-disable-next-line react/display-name
const QueryBarTimeline = exports.QueryBarTimeline = /*#__PURE__*/(0, _react.memo)(({
  dataProviders,
  filters,
  filterManager,
  filterQuery,
  from,
  fromStr,
  kqlMode,
  isRefreshPaused,
  savedQueryId,
  setSavedQueryId,
  refreshInterval,
  timelineId,
  to,
  toStr,
  updateReduxTime
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [dateRangeFrom, setDateRangeFrom] = (0, _react.useState)(fromStr != null ? fromStr : new Date(from).toISOString());
  const [dateRangeTo, setDateRangTo] = (0, _react.useState)(toStr != null ? toStr : new Date(to).toISOString());
  const {
    browserFields: oldBrowserFields,
    sourcererDataView: oldSourcererDataViewSpec
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const {
    newDataViewPickerEnabled
  } = (0, _use_experimental_features.useEnableExperimental)();
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.timeline);
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)(_model.SourcererScopeName.timeline);
  const dataViewBase = (0, _react.useMemo)(() => (0, _kuery.dataViewSpecToViewBase)(oldSourcererDataViewSpec), [oldSourcererDataViewSpec]);
  const dataView = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalDataView : dataViewBase, [newDataViewPickerEnabled, experimentalDataView, dataViewBase]);
  const browserFields = (0, _react.useMemo)(() => newDataViewPickerEnabled ? experimentalBrowserFields : oldBrowserFields, [experimentalBrowserFields, newDataViewPickerEnabled, oldBrowserFields]);
  const [savedQuery, setSavedQuery] = (0, _react.useState)(undefined);
  const [filterQueryConverted, setFilterQueryConverted] = (0, _react.useState)({
    query: filterQuery != null ? filterQuery.expression : '',
    language: filterQuery != null ? filterQuery.kind : 'kuery'
  });
  const queryBarFilters = (0, _react.useMemo)(() => (0, _helpers.getNonDropAreaFilters)(filters), [filters]);
  const [dataProvidersDsl, setDataProvidersDsl] = (0, _react.useState)((0, _kuery.convertKueryToElasticSearchQuery)((0, _helpers.buildGlobalQuery)(dataProviders, browserFields), dataView));
  const savedQueryServices = (0, _saved_query_services.useSavedQueryServices)();
  const applyKqlFilterQuery = (0, _react.useCallback)((expression, kind) => dispatch(_store.timelineActions.applyKqlFilterQuery({
    id: timelineId,
    filterQuery: {
      kuery: {
        kind,
        expression
      },
      serializedQuery: (0, _kuery.convertKueryToElasticSearchQuery)(expression, dataView)
    }
  })), [dispatch, dataView, timelineId]);
  (0, _react.useEffect)(() => {
    setFilterQueryConverted({
      query: filterQuery != null ? filterQuery.expression : '',
      language: filterQuery != null ? filterQuery.kind : 'kuery'
    });
  }, [filterQuery]);
  (0, _react.useEffect)(() => {
    setDataProvidersDsl((0, _kuery.convertKueryToElasticSearchQuery)((0, _helpers.buildGlobalQuery)(dataProviders, browserFields), dataView));
  }, [dataProviders, browserFields, dataView]);
  (0, _react.useEffect)(() => {
    if (fromStr != null && toStr != null) {
      setDateRangeFrom(fromStr);
      setDateRangTo(toStr);
    } else if (from != null && to != null) {
      setDateRangeFrom(new Date(from).toISOString());
      setDateRangTo(new Date(to).toISOString());
    }
  }, [from, fromStr, to, toStr]);
  (0, _react.useEffect)(() => {
    let isSubscribed = true;
    async function setSavedQueryByServices() {
      if (savedQueryId != null && savedQueryServices != null) {
        try {
          // The getSavedQuery function will throw a promise rejection in
          // src/legacy/core_plugins/data/public/search/search_bar/lib/saved_query_service.ts
          // if the savedObjectsClient is undefined. This is happening in a test
          // so I wrapped this in a try catch to keep the unhandled promise rejection
          // warning from appearing in tests.
          const mySavedQuery = await savedQueryServices.getSavedQuery(savedQueryId);
          if (isSubscribed && mySavedQuery != null) {
            setSavedQuery({
              ...mySavedQuery,
              attributes: {
                ...mySavedQuery.attributes,
                filters: (0, _helpers.getNonDropAreaFilters)(filters)
              }
            });
          }
        } catch (exc) {
          setSavedQuery(undefined);
        }
      } else if (isSubscribed) {
        setSavedQuery(undefined);
      }
    }
    setSavedQueryByServices();
    return () => {
      isSubscribed = false;
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [savedQueryId]);
  const onSubmitQuery = (0, _react.useCallback)((newQuery, timefilter) => {
    if (filterQuery == null || filterQuery != null && filterQuery.expression !== newQuery.query || filterQuery.kind !== newQuery.language) {
      applyKqlFilterQuery(newQuery.query, newQuery.language);
    }
    if (timefilter != null) {
      const isQuickSelection = timefilter.from.includes('now') || timefilter.to.includes('now');
      updateReduxTime({
        id: _constants.InputsModelId.timeline,
        end: timefilter.to,
        start: timefilter.from,
        isInvalid: false,
        isQuickSelection,
        timelineId,
        hasRangeChanged: true
      });
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [filterQuery, timelineId]);
  const onSavedQuery = (0, _react.useCallback)(newSavedQuery => {
    if (newSavedQuery != null) {
      if (newSavedQuery.id !== savedQueryId) {
        setSavedQueryId(newSavedQuery.id);
      }
      if (savedQueryServices != null && dataProvidersDsl !== '') {
        const dataProviderFilterExists = newSavedQuery.attributes.filters != null ? newSavedQuery.attributes.filters.findIndex(f => f.meta.controlledBy === _helpers.TIMELINE_FILTER_DROP_AREA) : -1;
        savedQueryServices.updateQuery(newSavedQuery.id, {
          ...newSavedQuery.attributes,
          filters: newSavedQuery.attributes.filters != null ? dataProviderFilterExists > -1 ? [...newSavedQuery.attributes.filters.slice(0, dataProviderFilterExists), getDataProviderFilter(dataProvidersDsl), ...newSavedQuery.attributes.filters.slice(dataProviderFilterExists + 1)] : [...newSavedQuery.attributes.filters, getDataProviderFilter(dataProvidersDsl)] : []
        });
      }
    } else {
      setSavedQueryId(null);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [dataProvidersDsl, savedQueryId, savedQueryServices]);
  if (!dataView) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(SearchBarContainer, {
    className: "search_bar_container",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_query_bar.QueryBar, {
    dateRangeFrom: dateRangeFrom,
    dateRangeTo: dateRangeTo,
    hideSavedQuery: kqlMode === 'search',
    indexPattern: dataView,
    isRefreshPaused: isRefreshPaused,
    filterQuery: filterQueryConverted,
    filterManager: filterManager,
    filters: queryBarFilters,
    onSubmitQuery: onSubmitQuery,
    refreshInterval: refreshInterval,
    savedQuery: savedQuery,
    onSavedQuery: onSavedQuery,
    dataTestSubj: 'timelineQueryInput',
    displayStyle: "inPage",
    preventCacheClearOnUnmount: newDataViewPickerEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 9
    }
  }));
});
const getDataProviderFilter = dataProviderDsl => {
  const dslObject = JSON.parse(dataProviderDsl);
  const key = Object.keys(dslObject);
  return {
    ...dslObject,
    meta: {
      alias: _helpers.TIMELINE_FILTER_DROP_AREA,
      controlledBy: _helpers.TIMELINE_FILTER_DROP_AREA,
      negate: false,
      disabled: false,
      type: 'custom',
      key: (0, _fp.isEmpty)(key) ? 'bool' : key[0],
      value: dataProviderDsl
    },
    $state: {
      store: _esQuery.FilterStateStore.APP_STATE
    }
  };
};
exports.getDataProviderFilter = getDataProviderFilter;